/*
Copyright 1990-2009 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import java.util.*;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

import com.sun.g11n.vkb.sym.*;
import com.sun.g11n.vkb.geom.*;

import static com.sun.g11n.vkb.L10N._;
import static com.sun.g11n.vkb.Main.error;

/**
 *
 * @author naoyuki
 */
public class ContextMenu {
    // Here is the new spec for Virtual Keyboard context menu.
    //
    // "Show Keyboard" > [ all of user- | pre-defined keyboard ] # disabled if DMK is off
    // "Display Multiple Keyboard [ ]"                            # DMK, default is off
    // ---------------------------
    // "Symbols" > [Albanian, Arabic, ...]                        # temporary change current symbol
    // "Layout" > [Generic 101, Generic 102, ...]                 # temporary change current layout
    // "Edit Key..."                                              # open edit mode standalone keyboard
    // "Delete Custom Symbol...                                   # open custom symbol manage dialog
    // ---------------------------
    // "Synchronize with Physical Keyboard [ ]"                   # default is off
    // ---------------------------
    // "Save Keyboard"                                            # enabled only symbol/layout changed
    // "Delete"                                                   # disabled for pre-defined
    // ---------------------------
    // "Help"

    // Design mode menu
    // "Edit Edit..."

    /* status */
    private static boolean multiKBDSupport;
    private static boolean syncPhysicalKBD;
    private static boolean needSave;

    private static KeyCanvas canvas;
    private static VKBManager manager;

    /**
     * ContextMenu is the singleton. So constructor is private and
     * the instance must be retrieved through getInstance() static method. 
     * 
     * @retrun ContextMenu instance
     */
    public static ContextMenu getInstance() {
        if (contextMenu == null) {
            contextMenu = new ContextMenu();
        }
        return contextMenu;
    }
    private ContextMenu() {
        manager = VKBManager.getInstance();
        init();
    }
    private int x;
    private int y;
    private Point getPoint() {
        return new Point(x, y);
    }

    void show(Component invoker, int x, int y) {
        if (!(invoker instanceof KeyCanvas)) {
            error("Context menu should not be invoked on other thatn KeyCanvas.");
        }
        this.x = x;
        this.y = y;
        canvas = (KeyCanvas)invoker;
        if (canvas.isModifiable()) {
            if (designPopupMenu == null) {
                designPopupMenu = new JPopupMenu();
                designPopupMenu.add(editKeyWindowAction);
            }
            designPopupMenu.show(invoker, x, y);
            return;
        }

        if (popupMenu == null) {
            popupMenu = new JPopupMenu();
            popupMenu.enableInputMethods(false);
            popupMenu.add(showKeyboardMenu);
            popupMenu.add(displayMultipleKeyboardCheckBox);
            popupMenu.addSeparator();
            popupMenu.add(symbolsMenu);
            popupMenu.add(layoutMenu);
            popupMenu.add(editKeyAction);
            popupMenu.add(deleteCustomSymbolAction);
            popupMenu.addSeparator();
            popupMenu.add(synchronizePhysicalKeyboardCheckBox);
            popupMenu.addSeparator();
            popupMenu.add(saveAction);
            //popupMenu.add(saveAsAction);
            popupMenu.add(deleteAction);
            popupMenu.addSeparator();
            popupMenu.add(helpAction);
        }

        if (manager.currentKeyboardSaved()) {
            saveAction.setEnabled(false);
            //saveAsAction.setEnabled(false);
        } else {
            saveAction.setEnabled(true);
            //saveAsAction.setEnabled(true);
        }
        if (manager.currentKeyboardDeletable()) {
            deleteAction.setEnabled(true);
        } else {
            deleteAction.setEnabled(false);
        }
        popupMenu.show(invoker, x, y);
    }

    /*
     * initialize all of Action objects correspond to menu items
     */
    private static void init() {
        multiKBDSupport = Prefs.getMultiKBDSupport();
        syncPhysicalKBD = Prefs.getIMSync();
        needSave = false;
        
        displayMultipleKeyboardAction = new DisplayMultipleKeyboardAction();
        displayMultipleKeyboardCheckBox = new JCheckBoxMenuItem(displayMultipleKeyboardAction);
        displayMultipleKeyboardCheckBox.enableInputMethods(false);
        displayMultipleKeyboardCheckBox.setState(multiKBDSupport);
        editKeyAction = new EditKeyAction();
        deleteCustomSymbolAction = new DeleteCustomSymbolAction();
        synchronizePhysicalKeyboardAction = new SynchronizePhysicalKeyboardAction();
        synchronizePhysicalKeyboardCheckBox = new JCheckBoxMenuItem(synchronizePhysicalKeyboardAction);
        synchronizePhysicalKeyboardCheckBox.enableInputMethods(false);
        synchronizePhysicalKeyboardCheckBox.setState(syncPhysicalKBD);
        saveAction = new SaveAction();
        //saveAsAction = new SaveAsAction();
        deleteAction = new DeleteAction();
        editKeyWindowAction = new EditKeyWindowAction();

        helpAction = new HelpAction();

        // submenu setup
        setupKeyboardSubmenu();
        setupSymbolsSubmenu();
        setupLayoutSubmenu();
    }

    private static void setupKeyboardSubmenu() {
        // setup showKeyboardMenu
        java.util.List<KeyboardDescription> list = Prefs.getShowKeyboardList();

        int itemsPerMenu = Main.getLangItemPerMenu();
        int count = 0;
        showKeyboardMenu = new JMenu(_("vkb.context_menu.show_keyboard"));
        showKeyboardMenu.enableInputMethods(false);
        JMenu currentMenu = showKeyboardMenu;

        for (KeyboardDescription desc : list) {
            if (count < itemsPerMenu) {
                JMenuItem item = new JMenuItem(new ShowKeyboardAction(desc));
                currentMenu.add(item);
                count++;
            } else {
                JMenu item = new JMenu(_("vkb.select_symbol_next"));
                item.enableInputMethods(false);
                currentMenu.add(item);
                currentMenu = item;
                currentMenu.add(new JMenuItem(new ShowKeyboardAction(desc)));
                count = 1;
            }
        }
    }
    static void refreshKeyboardMenu() {
        // add newly created Keyboard to Keyboard list
        int id = popupMenu.getComponentIndex(showKeyboardMenu);
        popupMenu.remove(id);
        setupKeyboardSubmenu();
        popupMenu.add(showKeyboardMenu, id);
    }

    private static void setupSymbolsSubmenu() {
        // setup symbolsMenu
        symbolsMenu = new JMenu(_("vkb.context_menu.symbols"));
        symbolsMenu.enableInputMethods(false);
        SortedSet<Symbol> psymbols = manager.getPredefinedSymbolSet();
        SortedSet<Symbol> usymbols = manager.getUserSymbolSet();
        int itemsPerMenu = Main.getLangItemPerMenu();
        int count = 0;
        JMenu currentMenu = symbolsMenu;

        for (Symbol symbol : usymbols) {
            if (count < itemsPerMenu) {
                JMenuItem item = new JMenuItem(new SymbolAction(symbol));
                currentMenu.add(item);
                count++;
            } else {
                JMenu item = new JMenu(_("vkb.select_symbol_next"));
                item.enableInputMethods(false);
                currentMenu.add(item);
                currentMenu = item;
                currentMenu.add(new JMenuItem(new SymbolAction(symbol)));
                count = 1;
            }
        }
        currentMenu.addSeparator();
        for (Symbol symbol : psymbols) {
            if (count < itemsPerMenu) {
                JMenuItem item = new JMenuItem(new SymbolAction(symbol));
                currentMenu.add(item);
                count++;
            } else {
                JMenu item = new JMenu(_("vkb.select_symbol_next"));
                currentMenu.add(item);
                currentMenu = item;
                currentMenu.add(new JMenuItem(new SymbolAction(symbol)));
                count = 1;
            }
        }

    }
    public void refreshSymbolMenu() {
        // add newly created Symbol to symbol list
        int id = popupMenu.getComponentIndex(symbolsMenu);
        popupMenu.remove(id);
        setupSymbolsSubmenu();
        popupMenu.add(symbolsMenu, id);
    }
    private static void setupLayoutSubmenu() {
        // setup layoutMenu
        layoutMenu = new JMenu(_("vkb.context_menu.layout"));
        layoutMenu.enableInputMethods(false);
        SortedSet<Geometry> sgeoms = manager.getSortedGeometrySet();
        int itemsPerMenu = Main.getLangItemPerMenu(); // share with symbol list
        int count = 0;
        JMenu currentMenu = layoutMenu;
        for (Geometry geom : sgeoms) {
            if (count < itemsPerMenu) {
                JMenuItem item = new JMenuItem(new LayoutAction(geom));
                currentMenu.add(item);
                count++;
            } else {
                JMenu item = new JMenu(_("vkb.select_symbol_next")); // share with symbol list
                item.enableInputMethods(false);
                currentMenu.add(item);
                currentMenu = item;
                currentMenu.add(new JMenuItem(new LayoutAction(geom)));
                count = 1;
            }
        }
    }
    
    private static ContextMenu contextMenu;
    private static JPopupMenu popupMenu;
    private static JPopupMenu designPopupMenu;

    private static JMenu showKeyboardMenu;
    private static Action displayMultipleKeyboardAction;
    private static JCheckBoxMenuItem displayMultipleKeyboardCheckBox;
    private static JMenu symbolsMenu;
    private static JMenu layoutMenu;
    private static Action editKeyAction;
    private static Action deleteCustomSymbolAction;
    private static Action synchronizePhysicalKeyboardAction;
    private static JCheckBoxMenuItem synchronizePhysicalKeyboardCheckBox;
    private static Action saveAction;
    //private static Action saveAsAction;
    private static Action deleteAction;
    private static Action editKeyWindowAction;
    private static Action helpAction;

    // Action classes
    static class ShowKeyboardAction extends AbstractAction {
        KeyboardDescription desc;
        ShowKeyboardAction(KeyboardDescription desc) {
            super(desc.getDescription());
            this.desc = desc;
        }
        @Override public void actionPerformed(ActionEvent e) {
            Geometry geom = desc.getGeometry();
            Symbol sym = desc.getSymbol();
            if (!sym.isPredefined()) {
                // refresh for the case of customize symbol is overridden
                sym = manager.getSymbolByName(sym.getDescription());
            }
            if (multiKBDSupport) {
                manager.newKeyboardFrame(geom, sym);
            } else {
                KeyboardFrame frame = manager.getCurrentFrame();
                frame.changeGeometry(geom);
                frame.changeSymbol(sym);
            }
            manager.setCurrentGeometry(geom);
            manager.setCurrentSymbol(sym);
        }
    }

    static class DisplayMultipleKeyboardAction extends AbstractAction {
        DisplayMultipleKeyboardAction() {
            super(_("vkb.context_menu.display_multiple_keyboard"));
        }
        @Override public void actionPerformed(ActionEvent e) {
            boolean b = displayMultipleKeyboardCheckBox.getState();
            Prefs.setMultiKBDSupport(b);
            if (b) {
                multiKBDSupport = true;
                manager.setFrameStyle(FrameStyle.TAB_FRAME);
            } else {
                multiKBDSupport = false;
                manager.setFrameStyle(FrameStyle.SINGLE_FRAME);
            }
        }
    }
    static class SymbolAction extends AbstractAction {
        Symbol symbol;
        SymbolAction(Symbol symbol) {
            super(symbol.getDescription());
            this.symbol = symbol;
        }
        @Override public void actionPerformed(ActionEvent e) {
            KeyboardFrame frame = manager.getCurrentFrame();
            if (frame != null) {
                frame.changeSymbol(symbol);
                manager.setCurrentSymbol(symbol);
            }
        }        
    }
    static class LayoutAction extends AbstractAction {
        Geometry geom;
        LayoutAction(Geometry geom) {
            super(geom.getDescription());
            this.geom = geom;
        }
        @Override public void actionPerformed(ActionEvent e) {
            KeyboardFrame frame = manager.getCurrentFrame();
            if (frame != null) {
                frame.changeGeometry(geom);
                manager.setCurrentGeometry(geom);
            }
        }
    }
    static class EditKeyAction extends AbstractAction {
        EditKeyAction() {
            super(_("vkb.context_menu.edit_key"));
        }
        @Override public void actionPerformed(ActionEvent e) {
            manager.newEditFrame();
        }       
    }
    static class DeleteCustomSymbolAction extends AbstractAction {
        DeleteCustomSymbolAction() {
            super(_("vkb.context_menu.delete_custom_symbol"));
        }
        @Override public void actionPerformed(ActionEvent e) {
            manager.deleteCustomSymbol();
            refreshKeyboardMenu();
            contextMenu.refreshSymbolMenu();

        }
    }
    static class SynchronizePhysicalKeyboardAction extends AbstractAction {
        SynchronizePhysicalKeyboardAction() {
            super(_("vkb.context_menu.synchronize_physical_keyboard"));
        }
        @Override public void actionPerformed(ActionEvent e) {
            if (synchronizePhysicalKeyboardCheckBox.getState()) {
                syncPhysicalKBD = true;
            } else {
                syncPhysicalKBD = false;
            }
            manager.setSyncMode(syncPhysicalKBD);
        }       
    }
    static class SaveAction extends AbstractAction {
        SaveAction() {
            super(_("vkb.context_menu.save"));
        }
        @Override public void actionPerformed(ActionEvent e) {
            Geometry geom = manager.getCurrentGeometry();
            Symbol sym = manager.getCurrentSymbol();
            KeyboardDescription newDesc = new KeyboardDescription(geom, sym);
            if (Prefs.addShowKeyboardList(newDesc)) {
                refreshKeyboardMenu();
            }
        }       
    }
    static class SaveAsAction extends AbstractAction {
        SaveAsAction() {
            super(_("vkb.context_menu.save_as"));
        }
        @Override public void actionPerformed(ActionEvent e) {
            KeyboardSaveDialog ksd = new KeyboardSaveDialog(VKBManager.getInstance().getCurrentAWTFrame(), false);
            ksd.setVisible(true);
        }       
    }    
    static class DeleteAction extends AbstractAction {
        DeleteAction() {
            super(_("vkb.context_menu.delete"));
        }
        @Override public void actionPerformed(ActionEvent e) {
            KeyboardFrame frame = manager.getCurrentFrame();
            Geometry geom = manager.getCurrentGeometry();
            Symbol sym = manager.getCurrentSymbol();
            KeyboardDescription desc = new KeyboardDescription(geom, sym);
            if (Prefs.delShowKeyboardList(desc)) {
                refreshKeyboardMenu();
            }
            if (multiKBDSupport) {
                manager.removeKeyboardFrame(frame);
            } else {
                geom = manager.getDefaultGeometry();
                sym = manager.getDefaultSymbol();
                frame.changeGeometry(geom);
                frame.changeSymbol(sym);
                manager.setCurrentGeometry(geom);
                manager.setCurrentSymbol(sym);
            }
        }       
    }
    static class EditKeyWindowAction extends AbstractAction {
        EditKeyWindowAction() {
            super(_("vkb.context_menu.edit_key_window"));
        }
        @Override public void actionPerformed(ActionEvent e) {
            if (canvas != null) {
                canvas.invokeKeyEditor(contextMenu.getPoint());
            }
        }
    }

    static class HelpAction extends AbstractAction {
        HelpAction() {
            super(_("vkb.context_menu.help"));
        }
        @Override public void actionPerformed(ActionEvent e) {
            manager.invokeHelp();
        }
     }
}
