/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * LONameMapping.java
 *
 * Created on 2006/07/20, 18:27
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package kldhandler;

import java.util.*;
import java.io.*;

/**
 *
 * @author naoyuki
 */
public class LONameMapper {
    
    private ResourceBundle mapBundle = null;
    private Set<String> srcOnlySet = null;
    private Set<String> algSet = null;
    private Set<String> addUSSet = null;
    
    /** Creates a new instance of LONameMapping */
    public LONameMapper(File file) {
        if (file != null && file.canRead()) {
            try {
                mapBundle = new PropertyResourceBundle(new FileInputStream(file));
            } catch (IOException e) {
                System.err.println(" Warning : " + file.getName() + " can not be mapping file.");
                mapBundle = null;
            }
        }
        if (mapBundle == null) {
            // default bundle
            mapBundle = ResourceBundle.getBundle("kldhandler.layoutmapping");
        }
    }
    
    public String getConfigStr(String name) {
        try {
            return mapBundle.getString(name);
        } catch(MissingResourceException e) {
            e.printStackTrace();
        }
        return null;
    }
   
    public boolean srcOnly(String name) {
        if (srcOnlySet == null) {
            return false;
        }
        if (srcOnlySet.contains(name)) {
            return true;
        }
        return false;
    }
    
    public boolean preferAltGraph(String name) {
        if (algSet == null) {
            return false;
        }
        if (algSet.contains(name)) {
            return true;
        }
        return false;
    }

    public boolean addUSSymbols(String name) {
        if (addUSSet == null) {
            return false;
        }
        if (addUSSet.contains(name)) {
            return true;
        }
        return false;
    }
    
    public String[] getElmNames(String name) {
        String[] elma = null;
        try {
            String elms = mapBundle.getString(name);
            int srconly = elms.indexOf(":SRCONLY");
            if (srconly != -1) {
                if (srcOnlySet == null) {
                    srcOnlySet = new HashSet<String>();
                }
                elms = elms.substring(0, elms.indexOf(":"));
                srcOnlySet.add(name);
            }
            int alg = elms.indexOf(":ALG");
            if (alg != -1) {
                if (algSet == null) {
                    algSet = new HashSet<String>();
                }
                elms = elms.substring(0, elms.indexOf(":"));
                algSet.add(name);
            }
            int addus = elms.indexOf(":ADDUS");
            if (addus != -1) {
                if (addUSSet == null) {
                    addUSSet = new HashSet<String>();
                }
                elms = elms.substring(0, elms.indexOf(":"));
                addUSSet.add(name);
            }
            elma = elms.split("\\+");
        } catch(MissingResourceException e) {
            System.err.println("Keyboard type name : " + name  + " does not exist.");
            System.exit(1);
        }
        return elma;
    }
    
    public Set<String> getSupportedTypes() {
        Set<String> s = new HashSet<String>();
        for (Enumeration<String> e = mapBundle.getKeys(); e.hasMoreElements();) {
            s.add(e.nextElement());
        }
        return s;
    }
}
