#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


IIIMP_message *
iiimp_status_draw_new(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_contents *	status)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_STATUS_DRAW;
    m->im_id = im_id;
    m->ic_id = ic_id;
    m->v.status_draw.status = status;
    return m;
}


void
iiimp_status_draw_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    if (NULL == m) return;
    iiimp_contents_delete(data_s, m->v.status_draw.status);
    free(m);
    return;
}


uchar_t *
iiimp_status_draw_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_contents *	status,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;

    nbyte = 0;
    nbyte += 2;			/* input method id */
    nbyte += 2;			/* input context id */
    nbyte += status->nbyte;	/* status string of text */

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_STATUS_DRAW, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(ic_id, rest, p, data_s->byte_swap);
    iiimp_contents_pack(data_s, status, &rest, &p);

    return buf;
}


IIIMP_message *
iiimp_status_draw_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *		m;
    IIIMP_status_draw_v *	v;
    size_t			rest;
    const uchar_t *		p;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.status_draw);

    m->opcode = opcode;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    GETU16(m->ic_id, rest, p, data_s->byte_swap);

    v->status = iiimp_contents_unpack(data_s, &rest, &p, rest);
    if (NULL == v->status) {
	free(m);
	return NULL;
    }

    *nbyte = rest;
    *ptr = p;

    return m;
}


void
iiimp_status_draw_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, m->ic_id);
    iiimp_contents_print(data_s, m->v.status_draw.status);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
