/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _CODEPOINT_IM_H_
#define _CODEPOINT_IM_H_

int esc_key_flag;

/* Limit Constant Defination */
#define MAX_CHNAME_LEN		256 
#define MAX_USEDCODES_NUM	126 

#define CODEPOINT_CONFIG_NAME   "codepoint.cfg"
#define DESCRIPTION_STR   "Description"
#define LOCALE_STR  "Locale Name:"
#define NAME_STR    "Layout Name:"
#define ENCODE_STR    "Encode:"
#define USEDCODES_STR   "UsedCodes:"
#define INPUT_TYPE_STR   "Input Type:"
#define DEFAULT_INPUT_STR   "Default Input:"
#define MAX_INPUT_STR   "Max Input:"

#define IME_Status  ime_buffer->return_status
#define Input_Buf  ime_buffer->inputkey_buf
#define Input_Len  ime_buffer->inputkey_len
#define Preedit_Buf  ime_buffer->preedit_buf
#define prev_Preedit_Buf  ime_buffer->prev_preedit_buf
#define Preedit_Len  ime_buffer->preedit_len
#define Preedit_CaretPos ime_buffer->preedit_caretpos
#define Commit_Buf  ime_buffer->commit_buf
#define Commit_Len  ime_buffer->commit_len
#define Status_Buf  ime_buffer->status_buf
#define Status_Len  ime_buffer->status_len
#define Lookup_Buf  ime_buffer->lookup_buf
#define Lookup_Num  ime_buffer->lookup_num
#define Lookup_Pos  ime_buffer->cur_lookup_pos
#define Candidates_Buf  ime_buffer->candidates_buf
#define Additions_Buf  ime_buffer->additions_buf

/* Section Constant */
enum _Section_List {
  DEFAULT_SECTION = 0,
  DESCRIPTION_SECTION,
  MAX_SECTION_NUM
};

/* Bit Operations */
#define BITMASK(i) 		(1 << (i))
#define BITSET(a, i) 		((a) |= BITMASK(i))
#define BITCLEAR(a, i) 		((a) &= ~BITMASK(i))
#define GETBIT(a, i) 		((a) & BITMASK(i))

typedef struct {
  char		Encode;     /* UTF-8 or native: encoding of table */	
  unsigned char   Lname[MAX_CHNAME_LEN];
  unsigned char 	Cname[MAX_CHNAME_LEN]; /* IM Name */
  char 	InputType[MAX_CHNAME_LEN]; /* Input Type: HEX or OCTAL */
  char  UsedCodes[MAX_USEDCODES_NUM]; /* Characters for valid input */
  char	Output_Encode;			/* encode of output */
  char Default_Input;  /* Default Input Length*/
  char Max_Input;  /* Maximum Input Length*/
} TableStruct;

#endif    /*  _CODEPOINT_IM_H_  */
		
