#ifndef _LE_INFO_H_
#define _LE_INFO_H_

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "SunIM.h"
#include "ime_module.h"
#include "le_keybinding.h"

#include <time.h>

typedef enum {
    LE_FAIL = 0,
    LE_OK,
} LeResult;

typedef enum {
    LE_FALSE = 0,
    LE_TRUE,
} LeBoolean;

/* define the status for zh,en/conversion/qjbj/punctuation */
typedef enum {
    NOT_SHIFT_DOWN = 0,
    SHIFT_DOWN,
} ShiftStatus;

typedef enum {
    ZY_CHINESE = 0,
    ZY_ENGLISH,
} ZYStatus;

typedef enum {
    CONVERSION_OFF = 0,
    CONVERSION_ON,
} ConversionStatus;

typedef enum {
    QJBJ_HALFWIDTH = 0,
    QJBJ_FULLWIDTH,
} QjBjStatus;

typedef struct {
    char ch;
    unsigned char *full_char;
} FullCharItem;

typedef struct {
    int num_fullchars;
    FullCharItem *fullchars;
} FullChars;

typedef enum {
    PUNCT_ENGLISH = 0,
    PUNCT_CHINESE,
} PunctStatus;

typedef struct {
    char ch;
    unsigned char *full_punct;
} PunctCharItem;

typedef struct {
    int num_puncts;
    PunctCharItem *puncts;
} PunctChars;

typedef struct {

    /* base info */
    char *base_dir;
    time_t time_stamp;

    /* ime info */
    int num_ime_modules;
    ImeModuleContextRec **ime_modules;

    /* keybinding info */
    int num_imm_keybindings;
    ImmKeybindingRec **imm_keybindings;

    FullChars full_chars;
    PunctChars punct_chars;

} LeInfoRec;

#endif	/* _LE_INFO_H_ */
