/*
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Karl Park <karl.park@sun.com>
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "iml.h"
#include "key_event.h"
#include "le.h"
#include "le_proc.h"
#include "encode.h"
#include "xaux_locale.h"
#include "kolelog.h"
#include "aux-message.h"
#include "SunIM.h"

void proc_paletteaux_connect_event();
void proc_paletteaux_switch_conversion_event();
void proc_paletteaux_switch_hex_inputmode_event();
void proc_paletteaux_switch_junjabanja_event();
void proc_paletteaux_hangul_hanja_conversion_event();
void proc_paletteaux_change_position_event();
void proc_paletteaux_show_selectaux_event(iml_session_t *s);
void proc_selectaux_update_imeinfo_event(iml_session_t *s);
void proc_paletteaux_show_optionaux_event(iml_session_t *s);
void proc_paletteaux_show_keyboardaux_event(iml_session_t *s, int nKeyboardID);
void proc_paletteaux_hide_keyboardaux_event(iml_session_t *s);
void proc_paletteaux_show_lookupaux_event(iml_session_t *s);
void proc_paletteaux_start_action_event(iml_session_t *s, char *command_str);
void proc_paletteaux_set_options_event(iml_session_t *s, IMAuxDrawCallbackStruct *aux_data);
void proc_paletteaux_switch_input_mode_event(iml_session_t *s, int imode);
/* For different keyboard layout support */
void proc_paletteaux_switch_keyboardlayout_event(iml_session_t *s, int nKeyboardLayoutID);
void proc_keyboardaux_change_position_event(iml_session_t *s, int x, int y);
void proc_keyboardaux_change_key_status_event(iml_session_t *s, int key_status);
void proc_lookupaux_change_position_event(iml_session_t *s, int x, int y);
void proc_lookupaux_change_status_event(iml_session_t *s, int on);
void proc_selectaux_change_status_event(iml_session_t *s, int on);
void proc_optionaux_change_status_event(iml_session_t *s, int on);
void proc_commonaux_commit_string_event(iml_session_t *s, int locale_id, char *commit_str);
void proc_commonaux_commit_key_event(iml_session_t *s, int keycode, int keychar, int keystatus);
void proc_commonaux_lost_focus_event(iml_session_t *s);

void le_show_selectaux_notify(iml_session_t *s);
void le_show_optionaux_notify(iml_session_t *s);
static void le_show_keyboardaux_notify(iml_session_t *s, int nKeyboardID, int engine_id);
void le_show_lookupaux_notify(iml_session_t *s);
void le_start_action_notify(iml_session_t *s, char *command_str);
void le_imeinfo_notify(iml_session_t *s, char *classname, int aux_locale_id);
void le_update_paletteaux_input_mode_info(iml_session_t *s, int imode);
void le_update_optionaux_argsinfo(iml_session_t *s);
void le_update_keymapinfo_notify(iml_session_t *s, int engine_id);
void le_change_focus_notify(iml_session_t *s);
void proc_aux_event(iml_session_t *s, IMAuxEvent *auxevent);

extern int         	g_number_of_engines;
extern IMEEngineRec 	*g_engines[MAX_ENGINE_NUM];

void
auxevent_handler (iml_session_t *s, IMAuxEvent *ev)
{
  /*
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  MyDataPerDesktop *desktop_data =
    (MyDataPerDesktop *)(s->desktop->specific_data);
  IMKeyEventStruct *key_event =
    (IMKeyEventStruct *) keylistevent->keylist;
  IMEBufferMethods mthds = session_data->session_core.ime_methods_table;
  IMEBuffer a_buffer = session_data->session_core.ime_buffer;
  */
  proc_aux_event (s, ev);
  iml_status_draw (s);

}



/* ============================================================== */
/*            Process information from Auxiliary Window           */
/* ============================================================== */
void
proc_aux_event(iml_session_t *s, IMAuxEvent *auxevent)
{
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    MyDataPerDesktop *desktop_data =
	(MyDataPerDesktop *)(s->desktop->specific_data);
    IMEBufferMethods mthds = session_data->session_core.ime_methods_table;
    IMEBuffer a_buffer = session_data->session_core.ime_buffer;

    IMAuxDrawCallbackStruct *aux_data = auxevent->aux;
    int nIntegerCount, *pIntegerList;
    int nStringCount, nStringLen;
    int reqType;
    int locale_id, on, engine_id, junjabanja, punct, x, y;
    int charset_id;
    int nKeyboardID, keycode, keychar, keystatus;
    int nKeyboardLayoutID;
    int imode;
    char *command_str, *commit_str;

    nIntegerCount = aux_data->count_integer_values;
    pIntegerList = aux_data->integer_values;

    if (nIntegerCount <= 0) return;

    reqType = pIntegerList[0];

    KOLE_LOG (LOGDEST_STDOUT, "proc_aux_event: session:%x",aux_data, s);
    KOLE_LOG (LOGDEST_STDOUT, "reqType: %d", reqType);
    switch (reqType)
    {
	/* need not check whether the Palette is started */
	case PALETTEAUX_CONNECT:

	    locale_id = pIntegerList[1];
	    proc_paletteaux_connect_event(s, locale_id);
	    break;

	case PALETTEAUX_SWITCH_INPUT_MODE:
	    imode = pIntegerList[1];
	    proc_paletteaux_switch_input_mode_event(s, imode);
	    break;
	    /*
	      case PALETTEAUX_SET_LOCALE:
	      proc_paletteaux_set_locale_event(s);
	      break;
	    */
	    /*
	      case PALETTEAUX_SWITCH_HEX_INPUTMODE:
	      proc_paletteaux_switch_hex_inputmode_event(s);
	      break;
	    */
	case PALETTEAUX_SWITCH_QJBJ:
	    junjabanja = pIntegerList[1];
	    proc_paletteaux_switch_junjabanja_event(s, junjabanja);
	    break;

	case PALETTEAUX_HANJA_CONVERSION:
	    proc_paletteaux_hangul_hanja_conversion_event(s);
	    break;

	case PALETTEAUX_CHANGE_POSITION:
	    x = pIntegerList[1];
	    y = pIntegerList[2];
	    proc_paletteaux_change_position_event(s, x, y);
	    break;

	case PALETTEAUX_SHOW_SELECTAUX:
	    proc_paletteaux_show_selectaux_event(s);
	    break;

	case PALETTEAUX_SHOW_OPTIONAUX:
	    proc_paletteaux_show_optionaux_event(s);
	    break;

	case PALETTEAUX_SHOW_KEYBOARDAUX:
	    nKeyboardID = pIntegerList[1];
	    proc_key_switch_keyboard_layout_event(s, nKeyboardID);
	    proc_paletteaux_show_keyboardaux_event(s, nKeyboardID);
	    break;
	case PALETTEAUX_SWITCH_KEYBOARDLAYOUT:
	    /*
	      charset_id = pIntegerList[1];
	    (*mthds->ime_buffer_set_active_repertoire)(a_buffer, (OPTION_CHARSET *)&charset_id);

	    */
	    nKeyboardLayoutID = pIntegerList[1];
            KOLE_LOG (LOGDEST_STDOUT, "nKeyboardLayoutID is %d.\n", nKeyboardLayoutID);
	    proc_paletteaux_switch_keyboardlayout_event (s, nKeyboardLayoutID);
	    break;

	    /*****************************************************
		 Those protocal names are old ones, and no longer exist.
		 I leave it here just until everything looks fine.
		 soon to be removed...

		case PALETTEAUX_SWITCH_PUNCT:
			punct = pIntegerList[1];
			proc_paletteaux_switch_punct_event(s, punct);
			break;
	    ******************************************************/
	case PALETTEAUX_SHOW_LOOKUPAUX:
	    proc_paletteaux_show_lookupaux_event(s);
	    break;

	case PALETTEAUX_START_ACTION:
	    nStringCount = aux_data->count_string_values;
	    if (nStringCount != 1) break;

	    command_str = (char *)aux_data->string_values->text.utf_chars;
	    proc_paletteaux_start_action_event(s, command_str);

	    break;
      
	case PALETTEAUX_SWITCH_CHARSET_NOTIFY:
	    charset_id = pIntegerList[1];
	    (*mthds->ime_buffer_set_active_repertoire)(a_buffer, (OPTION_CHARSET *)&charset_id);
	    break;

	case KEYBOARDAUX_CHANGE_POSITION:
	    x = pIntegerList[1];
	    y = pIntegerList[2];
	    proc_keyboardaux_change_position_event(s, x, y);
	    break;

	case KEYBOARDAUX_CHANGE_KEY_STATUS:
	    keystatus = pIntegerList[1];
	    proc_keyboardaux_change_key_status_event(s, keystatus);
	    break;

	case LOOKUPAUX_CHANGE_POSITION:
	    x = pIntegerList[1];
	    y = pIntegerList[2];
	    proc_keyboardaux_change_position_event(s, x, y);
	    break;

	case LOOKUPAUX_CHANGE_STATUS:
	    on = pIntegerList[1];
	    proc_lookupaux_change_status_event(s, on);
	    break;

	case SELECTAUX_CHANGE_STATUS:
	    on = pIntegerList[1];
	    proc_selectaux_change_status_event(s, on);
	    break;
	    /*
	      case SELECTAUX_UPDATE_IMEINFO:
	      proc_selectaux_update_imeinfo_event(s);
	      break;
	    */

	case OPTIONAUX_CHANGE_STATUS:
	    on = pIntegerList[1];
	    proc_optionaux_change_status_event(s, on);
	    break;

	case COMMONAUX_COMMIT_STRING:
	    nStringCount = aux_data->count_string_values;
	    if (nStringCount != 1) break;

	    locale_id = pIntegerList[1];
	    commit_str = (char *)aux_data->string_values->text.utf_chars;
	    proc_commonaux_commit_string_event(s, locale_id, commit_str);

	    break;

	case COMMONAUX_COMMIT_KEY:
	    keycode = pIntegerList[1];
	    keychar = pIntegerList[2];
	    keystatus = pIntegerList[3];
	    proc_commonaux_commit_key_event(s, keycode, keychar, keystatus);

	    break;

	case COMMONAUX_UPDATE_OPTIONSINFO:
	    proc_paletteaux_set_options_event(s, aux_data);
	    break;

	case COMMONAUX_LOST_FOCUS:
	    proc_commonaux_lost_focus_event(s);
	    break;

    }
}

void
proc_paletteaux_connect_event (iml_session_t *s, int locale_id)
{
  MyDataPerDesktop *desktop_data =
    (MyDataPerDesktop *)(s->desktop->specific_data);
  MyDataPerSession *ds = (MyDataPerSession *)s->specific_data;
	
  KOLE_LOG (LOGDEST_STDOUT, "PALETTEAUX_CONNECT Request Received");
  desktop_data->paletteaux_ready = True;
  desktop_data->aux_locale_id = locale_id;
  /* @@@@
     ds->ime_buffer->encode = locale_id;
     @@@@*/
}

void
proc_paletteaux_switch_input_mode_event(iml_session_t *s, int imode)
{
  IMKeyEventStruct akey;
  IMKeyListEvent keyev;
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

  KOLE_LOG (LOGDEST_STDOUT, "PALETTEAUX_SWITCH_INPUT_MODE: imode=%d", imode);

  if (imode == INPUT_MODE_HEX_EUC) {	/* Hex mode from the paletteaux */
    akey.keyCode = IM_VK_X;
    akey.keyChar = IM_VK_X;
    akey.modifier = IM_CTRL_MASK;
    keyev.type = IM_EventKeyList;
    keyev.keylist = (IMKeyList) &akey;
  } else if (imode == INPUT_MODE_HEX_UTF8){	/* Hex mode from the paletteaux */
    akey.keyCode = IM_VK_X;
    akey.keyChar = IM_VK_X;
    akey.modifier = IM_CTRL_MASK | IM_SHIFT_MASK;
    keyev.type = IM_EventKeyList;
    keyev.keylist = (IMKeyList) &akey;
  } else if (imode == INPUT_MODE_SYMBOL){ /* Symbol mode from the paletteaux */
    akey.keyCode = IM_VK_J;
    akey.keyChar = IM_VK_J;
    akey.modifier = IM_CTRL_MASK;
    keyev.type = IM_EventKeyList;
    keyev.keylist = (IMKeyList) &akey;
  } else if (imode == INPUT_MODE_HANGUL){
    akey.keyCode = IM_VK_X;
    akey.keyChar = IM_VK_X;
    akey.modifier = IM_CTRL_MASK;
    keyev.type = IM_EventKeyList;
    keyev.keylist = (IMKeyList) &akey;

  } else {		/* Normal hangul input mode from the paletteaux */
    akey.keyCode = IM_VK_SPACE;
    akey.keyChar = IM_VK_SPACE;
    akey.modifier = IM_CTRL_MASK;
    keyev.type = IM_EventKeyList;
    keyev.keylist = (IMKeyList) &akey;
  }
#if 0
  proc_key_event(s, (IMKeyListEvent *)&keyev);
#endif
}

void proc_paletteaux_switch_conversion_event(iml_session_t *s, int on)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  int engine_id = session_data->paletteaux_status.engine_id;

  KOLE_LOG (LOGDEST_STDOUT, "PALETTEAUX_SWITCH_CONVERSION:  on:%d", on);
  if (on)
    iml_conversion_on(s);
  else
    iml_conversion_off(s);

  session_data->paletteaux_status.on = on;
#ifdef EVIL
  le_clear_ime_buffer(s, session_data->session_core.ime_buffer);
#endif
  if (on == CONVERSION_OFF) {
    session_data->paletteaux_status.engine_id = 0xff;
#ifdef EVIL
    le_status_draw(s);
#endif
  }
}


void proc_paletteaux_switch_junjabanja_event(iml_session_t *s, int junjabanja)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

  KOLE_LOG (LOGDEST_STDOUT, "PALETTEAUX_SWITCH_QJBJ:  junjabanja:%d", junjabanja);
  session_data->paletteaux_status.junjabanja = junjabanja;
#ifdef EVIL
  le_clear_ime_buffer(s, session_data->session_core.ime_buffer);
#endif
}

void proc_paletteaux_hangul_hanja_conversion_event(iml_session_t *s)
{
  IMKeyEventStruct akey;
  IMKeyListEvent keyev;
  KOLE_LOG (LOGDEST_STDOUT, "PALETTEAUX_HANJA_CONVERSION Request Received");
  akey.keyCode = IM_VK_W;
  akey.keyChar = IM_VK_W;
  akey.modifier = IM_CTRL_MASK;
  keyev.type = IM_EventKeyList;
  keyev.keylist = (IMKeyList) &akey;
#if 0
  proc_key_event(s, (IMKeyListEvent *)&keyev);
#endif
}

/* This function will be called when user choose 'internal code' menu from paletteaux */
/*
  void proc_paletteaux_switch_hex_inputmode_event(iml_session_t *s)
  {
  MyDataPerSession *sd = (MyDataPerSession *) s->specific_data;

  IMKeyEventStruct akey;
  IMKeyListEvent keyev;
  KOLE_LOG (LOGDEST_STDOUT, "PALETTEAUX_SWITCH_HEX_INPUTMODE Request Received");
  if(sd->input_mode == INPUT_MODE_HANGUL)){
  proc_paletteaux_switch_conversion_event(s, CONVERSION_ON);
  }
  sd->input_mode = 1;
  akey.keyCode = IM_VK_X;
  akey.keyChar = IM_VK_X;
  akey.modifier = IM_CTRL_MASK;
  keyev.type = IM_EventKeyList;
  keyev.keylist = (IMKeyList) &akey;
  proc_key_event(s, (IMKeyListEvent *)&keyev);
  }
*/
void proc_paletteaux_change_position_event(iml_session_t *s, int x, int y)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

  KOLE_LOG (LOGDEST_STDOUT, "PALETTEAUX_CHANGE_POSITION:  x: 0x%x, y:0x%x", x, y);
  session_data->paletteaux_status.x = x;
  session_data->paletteaux_status.y = y;
}

void proc_paletteaux_show_selectaux_event(iml_session_t *s)
{
  MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  int aux_locale_id = desktop_data->aux_locale_id;
  char *classname = XAUX_SELECT_CLASS_NAME;
	
  if (desktop_data->selectaux_started == False) {
    if (desktop_data->root_session) {
      KOLE_LOG (LOGDEST_STDOUT, "First start SelectAux");
      iml_aux_start(desktop_data->root_session, classname);
      le_imeinfo_notify(s, classname, aux_locale_id);
      desktop_data->selectaux_started = True;
    }
  }

  session_data->selectaux_status.on = True;
  le_show_selectaux_notify(s);
}

void proc_paletteaux_show_optionaux_event(iml_session_t *s)
{
  MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  char *classname = XAUX_OPTION_CLASS_NAME;
	
  if (desktop_data->optionaux_started == False) {
    if (desktop_data->root_session) {
      KOLE_LOG (LOGDEST_STDOUT, "First start OptionAux");
      iml_aux_start(desktop_data->root_session, classname);
      le_update_optionaux_argsinfo(s);
      desktop_data->optionaux_started = True;
    }
  }

  session_data->optionaux_status.on = True;
  le_show_optionaux_notify(s);
}

void proc_paletteaux_show_lookupaux_event(iml_session_t *s)
{
  MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  char *classname = XAUX_LOOKUP_CLASS_NAME;

  if (desktop_data->lookupaux_started == False) {
    if (desktop_data->root_session) {
      KOLE_LOG (LOGDEST_STDOUT, "First start LookupAux");
      iml_aux_start(desktop_data->root_session, classname);
      desktop_data->lookupaux_started = True;
    }
  }

  session_data->lookupaux_status.on = True;
  le_show_lookupaux_notify(s);
}

void
proc_paletteaux_show_keyboardaux_event (iml_session_t *s, int nKeyboardID)
{
  MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  int engine_id = session_data->paletteaux_status.engine_id;
  char *classname = XAUX_KEYBOARD_CLASS_NAME;

  KOLE_LOG (LOGDEST_STDOUT,
	    "Processig PALETTEAUX_SHOW_KEYBOARDAUX\n");

  if (desktop_data->keyboardaux_started == False) {
    if (desktop_data->root_session) {
      KOLE_LOG (LOGDEST_STDOUT, "First start KeyboardAux");
      iml_aux_start(desktop_data->root_session, classname);
      desktop_data->keyboardaux_started = True;
    }
  }

  if (nKeyboardID == -1) { /* hide the keyboard aux */
    session_data->keyboardaux_status.keyboard_id = nKeyboardID;
    le_update_keymapinfo_notify(s, engine_id);
    le_show_keyboardaux_notify(s, nKeyboardID, engine_id);
	
  } else {
    session_data->keyboardaux_status.keyboard_id = nKeyboardID;
    /* Now change the currently active keyboard layout */
		
    /*
      session_data->ime_buffer->keyboard_layout = nKeyboardID;
    */
    le_update_keymapinfo_notify(s, engine_id);
    le_show_keyboardaux_notify(s, nKeyboardID, engine_id);
  }
}

void proc_paletteaux_start_action_event(iml_session_t *s, char *command_str)
{
  MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
  char *classname = XAUX_ACTION_CLASS_NAME;
	
  if (desktop_data->actionaux_started == False) {
    if (desktop_data->root_session) {
      KOLE_LOG (LOGDEST_STDOUT, "First start ActionAux");
      iml_aux_start(desktop_data->root_session, classname);
      desktop_data->actionaux_started = True;
    }
  }

  KOLE_LOG (LOGDEST_STDOUT, "PALETTEAUX_START_ACTION Request Received");
  KOLE_LOG (LOGDEST_STDOUT,
	    "command_str:%s, len:%d", command_str, strlen(command_str));

  le_start_action_notify(s, command_str);
}

void
proc_paletteaux_switch_keyboardlayout_event(iml_session_t *s, int nKeyboardLayoutID)
{
    MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
    MyDataPerDesktop *desktop_data =
	(MyDataPerDesktop *)(s->desktop->specific_data);
    IMEBuffer a_buffer = session_data->session_core.ime_buffer;
    IMEBufferMethods mthds = session_data->session_core.ime_methods_table;

    (*mthds->ime_buffer_set_keyboard_layout)(a_buffer,
					     (KEYBOARD_LAYOUT_T *)&nKeyboardLayoutID);
}

void proc_paletteaux_set_options_event(iml_session_t *s, IMAuxDrawCallbackStruct *aux_data)
{
  MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  UserPreference *user_pref = &(desktop_data->user_pref);

  IMText *lt;
  char *ime_ename;
  char *option_name;
  char *ptr;
  int i, j, option_value;
  int nIntegerCount, *pIntegerList;
  int nStringCount, nStringLen;
  int engine_id, engine_locale_id, aux_locale_id;

  nIntegerCount = aux_data->count_integer_values;
  pIntegerList = aux_data->integer_values;
  nStringCount = aux_data->count_string_values;

  KOLE_LOG (LOGDEST_STDOUT, "COMMONAUX_UPDATE_OPTIONSINFO Request Received");
  KOLE_LOG (LOGDEST_STDOUT, "Options num:%d", nStringCount);

  aux_locale_id = desktop_data->aux_locale_id;
  for (i=0; i<nStringCount; i++) {
    lt = aux_data->string_values + i;
    option_name = (char *)(lt->text.native_chars);
    ptr = strchr(option_name, ':');
    *ptr = '\0'; ptr++;
    /*
      option_value = pIntegerList[i+1];
      KOLE_LOG (LOGDEST_STDOUT, "set option: %s\t%d", option_name, option_value);
    */
    if(!strcmp(option_name, "keyboard_layout")){
      user_pref->keyboard_layout = atoi(ptr);
    } else if(!strcmp(option_name, "ime_user_id")){
      user_pref->ime_user_id =  atoi(ptr);
    } else if(!strcmp(option_name,"conversion_format")){
      user_pref->conversion_format = atoi(ptr);
    } else if(!strcmp(option_name,"auto_commit_on_char_basis")){
      user_pref->auto_commit_on_char_basis = atoi(ptr);
    } else if(!strcmp(option_name,"auto_commit_on_single_candidate_conversion")){
      user_pref->auto_commit_on_single_candidate_conversion = atoi(ptr);
    } else if(!strcmp(option_name, "ime_user_home")){
      user_pref->ime_user_home = strdup(ptr);
    }
  }
  /************************************************************
	   This call is needed to let the engine core know about 
	   some change in the way they calculate correct hangul value
  ************************************************************/
  le_update_ime_buffer(s, user_pref);
}

void proc_keyboardaux_change_position_event(iml_session_t *s, int x, int y)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

  KOLE_LOG (LOGDEST_STDOUT, "KEYBOARDAUX_CHANGE_POSITION:  x: 0x%x, y:0x%x", x, y);
  session_data->keyboardaux_status.x = x;
  session_data->keyboardaux_status.y = y;
}

void proc_keyboardaux_change_key_status_event(iml_session_t *s, int key_status)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

  KOLE_LOG (LOGDEST_STDOUT,
	    "KEYBOARDAUX_CHANGE_KEY_STATUS:  key_status: 0x%x", key_status);
  session_data->keyboardaux_status.key_status = key_status;
}

void proc_lookupaux_change_position_event(iml_session_t *s, int x, int y)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

  KOLE_LOG (LOGDEST_STDOUT, "LOOKUPAUX_CHANGE_POSITION:  x: 0x%x, y:0x%x", x, y);
}

void proc_lookupaux_change_status_event(iml_session_t *s, int on)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

  KOLE_LOG (LOGDEST_STDOUT, "LOOKUPAUX_CHANGE_STATUS:  on: %d", on);
  session_data->lookupaux_status.on = on;
}

void
proc_selectaux_change_status_event (iml_session_t *s, int on)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

  KOLE_LOG (LOGDEST_STDOUT, "SELECTAUX_CHANGE_STATUS:  on: %d", on);
  session_data->selectaux_status.on = on;
}

void
proc_optionaux_change_status_event (iml_session_t *s, int on)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

  KOLE_LOG (LOGDEST_STDOUT, "OPTIONAUX_CHANGE_STATUS:  on: %d", on);
  session_data->optionaux_status.on = on;
}

void
proc_commonaux_commit_string_event (iml_session_t *s, int locale_id, char *commit_str)
{
  KOLE_LOG (LOGDEST_STDOUT, "COMMONAUX_COMMIT_STRING Request Received");
  KOLE_LOG (LOGDEST_STDOUT,
	    "locale_id:%d, command_str:%s, len:%d", 
	    locale_id, commit_str, strlen(commit_str));
  /*
    encode_commit(s, locale_id, (unsigned char *)commit_str);
  */
}

void
proc_commonaux_commit_key_event (iml_session_t *s, int keycode, int keychar, int keystatus)
{
  static IMKeyEventStruct akey;
  static IMKeyListEvent keyev;

  KOLE_LOG (LOGDEST_STDOUT, "COMMONAUX_COMMIT_KEY Request Received");
  KOLE_LOG (LOGDEST_STDOUT,
	    "keycode:0x%x, keychar:0x%x, keystatus:0x%x", 
	    keycode, keychar, keystatus);

  akey.keyCode = keycode;
  akey.keyChar = keychar;
  akey.modifier = keystatus;
  keyev.type = IM_EventKeyList;
  keyev.keylist = (IMKeyList) &akey;
#if 0
  proc_key_event(s, (IMKeyListEvent *) &keyev);
#endif

  keyevent_handler(s, &keyev); 
}

void
proc_commonaux_lost_focus_event (iml_session_t *s)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  int on_save = session_data->paletteaux_status.on;
	
  KOLE_LOG (LOGDEST_STDOUT, "COMMONAUX_LOST_FOCUS Request Received\n");
  session_data->paletteaux_status.on = False;
  le_change_focus_notify(s);
  session_data->paletteaux_status.on = on_save;
}

/* ============================================================== */
/*              Send information to Auxiliary Window              */
/* ============================================================== */
void
le_start_aux_notify (iml_session_t *s, char *classname)
{
  MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
  iml_aux_start(desktop_data->root_session, classname);
}

void
send_info_to_aux (iml_session_t *s, char *classname,
		      int count_integers,  int *integers,
		      int count_strings,   int *len_strings,
		      char **strings)
{
  iml_aux_draw (s, classname, 
		count_integers,  integers,
		count_strings,   len_strings,
		(unsigned char **)strings);
}

void
le_imeinfo_notify (iml_session_t *s, char *classname, int aux_locale_id)
{
  int nIntegerCount,  pIntegerList[5];
  int nStringsCount,  pLenStrings[2];
  char *pStrings[2], *ename, *kname;
  int i, engine_locale_id;

  KOLE_LOG (LOGDEST_STDOUT, "le_imeinfo_notify: ======\n");

  nIntegerCount = 1;
  pIntegerList[0] = COMMONAUX_SET_IME_NEW_NOTIFY;
  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);

  for (i=0; i<g_number_of_engines; i++) {
    if (aux_locale_id != -1) {
      engine_locale_id = g_engines[i]->core.baseinfo.locale_id;
      if (engine_locale_id != aux_locale_id && engine_locale_id != ENCODES_NUM)
	continue;
    }

    /* send the IME base information to auxiliary window */
    nIntegerCount = 5;
    pIntegerList[0] = COMMONAUX_SET_IME_INFO_NOTIFY;
    pIntegerList[1] = g_engines[i]->core.baseinfo.engine_id;
    pIntegerList[2] = g_engines[i]->core.baseinfo.locale_id;
    pIntegerList[3] = g_engines[i]->core.baseinfo.encode_id;
    pIntegerList[4] = g_engines[i]->core.baseinfo.status;

    nStringsCount = 2;
    ename = g_engines[i]->core.baseinfo.ename;
    if (ename == NULL) ename = "IME";
    pLenStrings[0] = strlen(ename) + 1;
    pStrings[0] = (char *)ename;

    kname = g_engines[i]->core.baseinfo.kname;
    if (kname == NULL) kname = "IME";
    pLenStrings[1] = strlen(kname) + 1;
    pStrings[1] = (char *)kname;
		
    KOLE_LOG (LOGDEST_STDOUT, "le_imeinfo_notify: \n");
    KOLE_LOG (LOGDEST_STDOUT, "\tengine_id: %d\n", pIntegerList[1]);
    KOLE_LOG (LOGDEST_STDOUT, "\tlocale_id: %d\n", pIntegerList[2]);
    KOLE_LOG (LOGDEST_STDOUT, "\tencode_id: %d\n", pIntegerList[3]);
    KOLE_LOG (LOGDEST_STDOUT, "\tstatus: %d\n", pIntegerList[4]);
    KOLE_LOG (LOGDEST_STDOUT, "\tename: %s\n", ename);
    KOLE_LOG (LOGDEST_STDOUT, "\tkname: %s\n", kname);

    send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 
		     nStringsCount,  pLenStrings,
		     pStrings);
  }

  nIntegerCount = 1;
  pIntegerList[0] = COMMONAUX_SET_IME_END_NOTIFY;
  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}


void
auxhandler_send_session_property (iml_session_t *s, char *classname)
{
  int nIntegerCount,  pIntegerList[6];
  int nStringsCount,  pLenStrings[2];
  char *pStrings[2], *ename, *kname;

  MyDataPerSession *sd = (MyDataPerSession *)(s->specific_data);
  IMEBufferMethods mthds = sd->session_core.ime_methods_table;
  IMEBuffer ime_buffer = sd->session_core.ime_buffer;

  nIntegerCount = 6;
  pIntegerList[0] = KOLE_AUX_SESSION_PROPERTY;
  (*mthds->ime_buffer_get_input_mode)(ime_buffer, &pIntegerList[1]);
  (*mthds->ime_buffer_get_keyboard_layout)(ime_buffer, &pIntegerList[2]);
  (*mthds->ime_buffer_get_active_repertoire)(ime_buffer, &pIntegerList[3]);
  (*mthds->ime_buffer_get_deletion_option)(ime_buffer, &pIntegerList[4]);
  (*mthds->ime_buffer_get_commitmode_option)(ime_buffer, &pIntegerList[5]);  
  
  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_update_paletteaux_input_mode_info (iml_session_t *s, int imode)
{
  char *classname = XAUX_PALETTE_CLASS_NAME;
  int nIntegerCount,  pIntegerList[2];

  KOLE_LOG (LOGDEST_STDOUT, "le_update_paletteaux_input_mode_info");

  nIntegerCount = 2;
  pIntegerList[0] = PALETTEAUX_SWITCH_INPUT_MODE_NOTIFY;
  pIntegerList[1] = imode;

  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_update_optionaux_argsinfo (iml_session_t *s)
{
  MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
  char *classname = XAUX_OPTION_CLASS_NAME;

  int nIntegerCount,  pIntegerList[MAX_ARGS_NUM + 2];
  int nStringsCount,  pLenStrings[MAX_ARGS_NUM + 2];
  char *pStrings[MAX_ARGS_NUM + 2];
  int engine_locale_id, aux_locale_id;
  int i, j, total_args_num, args_num, arg_value;
  char *ename, *kname, *arg_name;
  char *tmp_name, ime_kname[256], tmp_arg_name[256];
  int encode_id, ilen, olen, ret;

  KOLE_LOG (LOGDEST_STDOUT, "le_update_optionaux_argsinfo");

  aux_locale_id = desktop_data->aux_locale_id;
  for (i=0; i<g_number_of_engines; i++) {
    engine_locale_id = g_engines[i]->core.baseinfo.locale_id;
    if (engine_locale_id != aux_locale_id && engine_locale_id != ENCODES_NUM)
      continue;

    ename = (char *)g_engines[i]->core.baseinfo.ename;
    if (!ename || !*ename)
      continue;

    kname = (char *)g_engines[i]->core.baseinfo.kname;
    if (!kname || !*kname)
      continue;

    if (desktop_data->ime_args[i] == NULL) {
      desktop_data->ime_args[i] = (IMEArgList)calloc(1, sizeof(IMEArgListRec));
      if (desktop_data->ime_args[i] == NULL)
	continue;

      /* set the options of ime */
      /*
	g_engines[i]->so_methods->IME_SetValues(&(g_engines[i]->core),  desktop_data->ime_args[i], -1);
      */
    }

    total_args_num = desktop_data->ime_args[i]->args_num;

    if (total_args_num == 0) 
      continue;

    if (total_args_num >= MAX_ARGS_NUM)
      total_args_num = MAX_ARGS_NUM - 1;

    strcpy(ime_kname, kname);

    encode_id = g_engines[i]->core.baseinfo.encode_id;
    KOLE_LOG (LOGDEST_STDOUT, "ime encode_id is: %d", encode_id);
    if (encode_id == ENCODE_UTF8) {
      ilen = strlen(kname);
      tmp_name = ime_kname;
      olen = 256;
      memset(ime_kname, 0, olen);
      ret = Convert_UTF8_To_Native(aux_locale_id, kname, ilen, &tmp_name, (size_t *)&olen);
      if (ret == -1)
	strcpy(ime_kname, ename);
    }

    KOLE_LOG (LOGDEST_STDOUT, "Set options for IME :%s", ime_kname);
    /* set the option information of this IME to OptionAux */
    pIntegerList[0] = OPTIONAUX_UPDATE_ARGS_INFO_NOTIFY;
    pLenStrings[0] = strlen(ename) + 1;
    pStrings[0] = (char *)ename;
    pLenStrings[1] = strlen(ime_kname) + 1;
    pStrings[1] = (char *)ime_kname;

    args_num = 0;
    for (j=0; j<total_args_num; j++) {
      arg_name = (char *)desktop_data->ime_args[i]->args[j].name;
      if (!arg_name || !*arg_name) 
	continue;

      ilen = strlen(arg_name);
      tmp_name = tmp_arg_name;
      olen = 256;
      memset(tmp_arg_name, 0, olen);
      ret = Convert_UTF8_To_Native(aux_locale_id, arg_name, ilen, &tmp_name, (size_t *)&olen);
      if (ret == -1)
	strcpy(tmp_arg_name, arg_name);

      arg_value = desktop_data->ime_args[i]->args[j].value;
      pIntegerList[args_num + 2] = arg_value;
      pLenStrings[args_num + 2] = strlen(tmp_arg_name) + 1;
      pStrings[args_num + 2] = (char *)strdup(tmp_arg_name);
			
      KOLE_LOG (LOGDEST_STDOUT, "arg_name:%s\tvalue:%d", tmp_arg_name, arg_value);
      args_num++;
    }

    if (args_num == 0)
      continue;

    nIntegerCount = args_num + 2;
    pIntegerList[1] = args_num;
    nStringsCount = args_num + 2;

    send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 
		     nStringsCount,  pLenStrings,
		     pStrings);

    for (j=0; j<args_num; j++) {
      if (pStrings[j + 2]) {
	KOLE_LOG (LOGDEST_STDOUT, " Free char :%s", pStrings[j + 2]);
	free((char *)pStrings[j + 2]);
      }
    }
  }
}

void
le_update_paletteaux_keymapinfo (iml_session_t *s, int engine_id)
{
  char *classname = XAUX_PALETTE_CLASS_NAME;
  int nIntegerCount,  pIntegerList[2];

  KOLE_LOG (LOGDEST_STDOUT, "le_update_paletteaux_keymapinfo");

  nIntegerCount = 2;
  pIntegerList[0] = COMMONAUX_UPDATE_KEYMAPINFO_NOTIFY;
  pIntegerList[1] = engine_id;

  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_update_keyboardaux_keymapinfo (iml_session_t *s, int engine_id, int bNeedKeyMap)
{
  MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
  char *classname = XAUX_KEYBOARD_CLASS_NAME;

  int nIntegerCount,  pIntegerList[2];
  int nStringsCount,  pLenStrings[1];
  char *pStrings[1];

  static char keymap_buf[MAX_KEYMAP_KEY_NUM][5];
  int encode_id, aux_locale_id;
  int i, ilen, olen, ret;
  char key_str[64], *str, *tmp_str;

  KOLE_LOG (LOGDEST_STDOUT, "le_update_keyboardaux_keymapinfo");

  nIntegerCount = 2;
  pIntegerList[0] = COMMONAUX_UPDATE_KEYMAPINFO_NOTIFY;
  pIntegerList[1] = engine_id;

  if (bNeedKeyMap) {
    memset(keymap_buf[0], 0, sizeof(keymap_buf));

    encode_id = g_engines[engine_id]->core.baseinfo.encode_id;
    aux_locale_id = desktop_data->aux_locale_id;
    for(i=0; i<MAX_KEYMAP_KEY_NUM; i++) {
      str = (char *)g_engines[engine_id]->core.keymapinfo.keymap[i];
      if (str && *str) {
	if (encode_id == ENCODE_UTF8) {
	  ilen = strlen(str);
	  tmp_str = key_str;
	  olen = 64;
	  memset(key_str, 0, 64);
	  ret = Convert_UTF8_To_Native(aux_locale_id, str, ilen, &tmp_str, (size_t *)&olen);
	  if (ret == 0)
	    strncpy(keymap_buf[i], key_str, 4);
	} else {
	  strncpy(keymap_buf[i], str, 4);
	}
	KOLE_LOG (LOGDEST_STDOUT, "keymap_buf[%d]: %s, str:%s", i, keymap_buf[i], str);
      }
    }

    nStringsCount = 1;
    pLenStrings[0] = sizeof(keymap_buf);
    pStrings[0] = (char *)(keymap_buf[0]);

    send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 
		     nStringsCount,  pLenStrings,
		     pStrings);
  } else {
    send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 
		     0, NULL, NULL);
  }

}

void
le_update_keymapinfo_notify (iml_session_t *s, int engine_id)
{
  MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
  int bSet, bSentKeymapToAux;

  if (engine_id < 0 || engine_id >= g_number_of_engines) return;

  bSet = g_engines[engine_id]->core.keymapinfo.bSet;

  if (bSet && desktop_data->paletteaux_started == True)
    le_update_paletteaux_keymapinfo(s, engine_id);

  if (desktop_data->keyboardaux_started == True) {
    bSentKeymapToAux = desktop_data->bSentKeymapToAux[engine_id];
    if (bSet && !bSentKeymapToAux) {
      /* if have keymap and not sent to KeyboardAux */
      /* send keymap to KeyboardAux */
      le_update_keyboardaux_keymapinfo(s, engine_id, 1);
      desktop_data->bSentKeymapToAux[engine_id] = True;
    } else {
      /* if no keymap or have sent to KeyboardAux */
      /* update the information of KeyboardAux */
      le_update_keyboardaux_keymapinfo(s, engine_id, 0);
    }

  }
}

void
le_update_keyboardaux_keypress_notify (iml_session_t *s, int keycode, int keychar, int keystatus)
{
  char *classname = XAUX_KEYBOARD_CLASS_NAME;
  int nIntegerCount,  pIntegerList[4];

  KOLE_LOG (LOGDEST_STDOUT, "le_update_keyboardaux_keypress_notify");

  nIntegerCount = 4;
  pIntegerList[0] = KEYBOARDAUX_PRESS_KEY_NOTIFY;
  pIntegerList[1] = keycode;
  pIntegerList[2] = keychar;
  pIntegerList[3] = keystatus;

  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_send_keyevent_to_keyboardaux (iml_session_t *s, IMKeyListEvent *ev)
{
  MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  IMKeyEventStruct *key_event = (IMKeyEventStruct *) ev->keylist;
  int keycode, keystatus, keychar;

  if (desktop_data->keyboardaux_started == False)
    return;

  if (session_data->keyboardaux_status.keyboard_id == -1)
    return;

  keycode = key_event->keyCode;
  keychar = key_event->keyChar;
  keystatus = key_event->modifier;

  KOLE_LOG (LOGDEST_STDOUT,
	    "le_update_keyboardaux_keypress_notify: keycode:0x%x, keychar:0x%x, keystatus:0x%x",
	    keycode, keychar, keystatus);
  le_update_keyboardaux_keypress_notify(s, keycode, keychar, keystatus);
}

static void
le_switch_conversion_notify (iml_session_t *s, int on)
{
  char *classname = XAUX_PALETTE_CLASS_NAME;
  int nIntegerCount,  pIntegerList[2];

  KOLE_LOG (LOGDEST_STDOUT, "le_switch_conversion_notify");

  nIntegerCount = 2;
  pIntegerList[0] = PALETTEAUX_SWITCH_CONVERSION_NOTIFY;
  pIntegerList[1] = on;

  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_switch_junjabanja_notify (iml_session_t *s, int junjabanja)
{
  char *classname = XAUX_PALETTE_CLASS_NAME;
  int nIntegerCount,  pIntegerList[2];

  KOLE_LOG (LOGDEST_STDOUT, "le_switch_junjabanja_notify");

  nIntegerCount = 2;
  pIntegerList[0] = PALETTEAUX_SWITCH_QJBJ_NOTIFY;
  pIntegerList[1] = junjabanja;

  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_change_paletteaux_focus_notify (iml_session_t *s)
{
  MyDataPerDesktop *desktop_data =
    (MyDataPerDesktop *)(s->desktop->specific_data);
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  
  IMEBufferMethods mthds = session_data->session_core.ime_methods_table;
  INPUT_MODE_T input_mode;
  
  IMEBuffer ime_buffer = session_data->session_core.ime_buffer;
  char *classname = XAUX_PALETTE_CLASS_NAME;
  int nIntegerCount,  pIntegerList[12];
  int tmp;

  KOLE_LOG (LOGDEST_STDOUT, "le_change_paletteaux_focus_notify");
  
  (void) (*mthds->ime_buffer_get_input_mode) (ime_buffer, &input_mode);
  nIntegerCount = 12;
  pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
  pIntegerList[1] = session_data->paletteaux_status.x;
  pIntegerList[2] = session_data->paletteaux_status.y;
  pIntegerList[3] = session_data->paletteaux_status.on;
  pIntegerList[4] = session_data->paletteaux_status.junjabanja;
  pIntegerList[5] = session_data->paletteaux_status.punct;
  pIntegerList[6] = session_data->paletteaux_status.engine_id;
  pIntegerList[7] = input_mode;

  (*mthds->ime_buffer_get_keyboard_layout)(ime_buffer, &tmp);
  pIntegerList[8] = tmp;
  
  (*mthds->ime_buffer_get_active_repertoire)(ime_buffer, &tmp);
  pIntegerList[9] = tmp;
  (*mthds->ime_buffer_get_deletion_option)(ime_buffer, &tmp);
  pIntegerList[10] = tmp;
  (*mthds->ime_buffer_get_commitmode_option)(ime_buffer, &tmp);  
  pIntegerList[11] = tmp;
  
  KOLE_LOG (LOGDEST_STDOUT, " x:%d, y:%d, on:%d, junjabanja:%d, punct:%d, engine_id:%d",
       pIntegerList[1],
       pIntegerList[2],
       pIntegerList[3],
       pIntegerList[4],
       pIntegerList[5],
       pIntegerList[6],
       pIntegerList[7]);
  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_change_keyboardaux_focus_notify (iml_session_t *s)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  char *classname = XAUX_KEYBOARD_CLASS_NAME;
  int nIntegerCount,  pIntegerList[7];

  KOLE_LOG (LOGDEST_STDOUT, "le_change_keyboardaux_focus_notify");

  nIntegerCount = 7;
  pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
  pIntegerList[1] = session_data->keyboardaux_status.x;
  pIntegerList[2] = session_data->keyboardaux_status.y;
  pIntegerList[3] = session_data->keyboardaux_status.keyboard_id;
  pIntegerList[4] = session_data->keyboardaux_status.key_status;
  pIntegerList[5] = session_data->paletteaux_status.on;
  pIntegerList[6] = session_data->paletteaux_status.engine_id;
  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_change_lookupaux_focus_notify (iml_session_t *s)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  char *classname = XAUX_LOOKUP_CLASS_NAME;
  int nIntegerCount,  pIntegerList[3];

  KOLE_LOG (LOGDEST_STDOUT, "le_change_lookupaux_focus_notify");

  nIntegerCount = 3;
  pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
  pIntegerList[1] = session_data->lookupaux_status.on;
  pIntegerList[2] = session_data->paletteaux_status.on;
  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_change_selectaux_focus_notify (iml_session_t *s)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  char *classname = XAUX_SELECT_CLASS_NAME;
  int nIntegerCount,  pIntegerList[3];

  KOLE_LOG (LOGDEST_STDOUT, "le_change_selectaux_focus_notify");

  nIntegerCount = 3;
  pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
  pIntegerList[1] = session_data->selectaux_status.on;
  pIntegerList[2] = session_data->paletteaux_status.on;
  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_change_optionaux_focus_notify (iml_session_t *s)
{
  MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
  char *classname = XAUX_OPTION_CLASS_NAME;
  int nIntegerCount,  pIntegerList[3];

  KOLE_LOG (LOGDEST_STDOUT, "le_change_selectaux_focus_notify");

  nIntegerCount = 3;
  pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
  pIntegerList[1] = session_data->optionaux_status.on;
  pIntegerList[2] = session_data->paletteaux_status.on;
  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_change_focus_notify (iml_session_t *s)
{
  MyDataPerDesktop *desktop_data =
    (MyDataPerDesktop *)(s->desktop->specific_data);
#if 0
  MyDataPerSession *ds = (MyDataPerSession *)(s->specific_data);
  IMEBufferMethods mthds = ds->session_core.ime_methods_table;
  INPUT_MODE_T input_mode;
  IMEBuffer ime_buffer = ds->session_core.ime_buffer;

  (void) (*mthds->ime_buffer->get_input_mode) (ime_buffer, &input_mode);
#endif
  /*
    if (desktop_data->paletteaux_started == True)
  */
  le_change_paletteaux_focus_notify (s);

  if (desktop_data->keyboardaux_started == True)
    le_change_keyboardaux_focus_notify (s);

  if (desktop_data->lookupaux_started == True)
    le_change_lookupaux_focus_notify (s);

  if (desktop_data->selectaux_started == True)
    le_change_selectaux_focus_notify (s);

  if (desktop_data->optionaux_started == True)
    le_change_optionaux_focus_notify (s);
}

void
le_show_selectaux_notify (iml_session_t *s)
{
  char *classname = XAUX_SELECT_CLASS_NAME;
  int nIntegerCount,  pIntegerList[1];

  KOLE_LOG (LOGDEST_STDOUT, "le_show_selectaux_notify");

  nIntegerCount = 1;
  pIntegerList[0] = SELECTAUX_SHOW_NOTIFY;

  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_show_optionaux_notify (iml_session_t *s)
{
  MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
  UserPreference *user_pref = &(desktop_data->user_pref);
  int n_option;
  char buffer[200];

  char *classname = XAUX_OPTION_CLASS_NAME;
  int nIntegerCount,  pIntegerList[7];
  int nStringCount, pLenStrings[6];
  char *pStrings[6];

  KOLE_LOG (LOGDEST_STDOUT, "le_show_optionaux_notify");

  nIntegerCount = 1;
  pIntegerList[0] = OPTIONAUX_SHOW_NOTIFY;

  n_option = OPTION_PAIR_NUM;
  nStringCount = n_option;

  sprintf(buffer, "%s:%d", STR_IME_USER_ID, user_pref->ime_user_id);
  pLenStrings[IDX_IME_USER_ID] = strlen(buffer);
  pStrings[IDX_IME_USER_ID] = strdup(buffer);

  sprintf(buffer, "%s:%s", STR_IME_USER_HOME, user_pref->ime_user_home);
  pLenStrings[IDX_IME_USER_HOME] = strlen(buffer);
  pStrings[IDX_IME_USER_HOME] = strdup(buffer);

  sprintf(buffer, "%s:%d", STR_KEYBOARD_LAYOUT, user_pref->keyboard_layout);
  pLenStrings[IDX_KEYBOARD_LAYOUT] = strlen(buffer);
  pStrings[IDX_KEYBOARD_LAYOUT] = strdup(buffer);

  sprintf(buffer, "%s:%d", STR_CONVERSION_FORMAT, user_pref->conversion_format);
  pLenStrings[IDX_CONVERSION_FORMAT] = strlen(buffer);
  pStrings[IDX_CONVERSION_FORMAT] = strdup(buffer);

  sprintf(buffer, "%s:%d", 
	  STR_AUTO_COMMIT_ON_CHAR_BASIS, user_pref->auto_commit_on_char_basis);
  pLenStrings[IDX_AUTO_COMMIT_ON_CHAR_BASIS] = strlen(buffer);
  pStrings[IDX_AUTO_COMMIT_ON_CHAR_BASIS] = strdup(buffer);

  sprintf(buffer, "%s:%d", 
	  STR_AUTO_COMMIT_ON_SINGLE_CANDIDATE_CONVERSION, 
	  user_pref->auto_commit_on_single_candidate_conversion);
  pLenStrings[IDX_AUTO_COMMIT_ON_SINGLE_CANDIDATE_CONVERSION] = strlen(buffer);
  pStrings[IDX_AUTO_COMMIT_ON_SINGLE_CANDIDATE_CONVERSION] = strdup(buffer);

  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, nStringCount, pLenStrings, pStrings);
}

static void
le_show_keyboardaux_notify (iml_session_t *s, int nKeyboardID, int engine_id)
{
  char *classname = XAUX_KEYBOARD_CLASS_NAME;
  int nIntegerCount,  pIntegerList[3];

  KOLE_LOG (LOGDEST_STDOUT,
	    "SVR->AUX: KEYBOARDAUX_SHOW_NOTIFY\n");

  nIntegerCount = 3;
  pIntegerList[0] = KEYBOARDAUX_SHOW_NOTIFY;
  pIntegerList[1] = nKeyboardID;
  pIntegerList[2] = engine_id;

  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_show_lookupaux_notify (iml_session_t *s)
{
  char *classname = XAUX_LOOKUP_CLASS_NAME;
  int nIntegerCount,  pIntegerList[1];

  KOLE_LOG (LOGDEST_STDOUT, "le_show_lookupaux_notify");

  nIntegerCount = 1;
  pIntegerList[0] = LOOKUPAUX_SHOW_NOTIFY;

  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void
le_start_action_notify (iml_session_t *s, char *command_str)
{
  char *classname = XAUX_ACTION_CLASS_NAME;
  int nIntegerCount,  pIntegerList[1];
  int nStringsCount,  pLenStrings[1];
  char *pStrings[1];

  nIntegerCount = 1;
  pIntegerList[0] = ACTIONAUX_START_ACTION_NOTIFY;

  nStringsCount = 1;
  pLenStrings[0] = strlen(command_str) + 1;
  pStrings[0] = (char *)command_str;

  KOLE_LOG (LOGDEST_STDOUT,
	    "le_start_action_notify: %s, len:%d", command_str, pLenStrings[0]);
  send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 
		   nStringsCount,  pLenStrings,
		   pStrings);
}

#if 0
static void
get_session_property (iml_session *s)
{
  MyDataPerDesktop *dd =
    (MyDataPerDesktop *)(s->desktop->specific_data);
  MyDataPerSession *sd = (MyDataPerSession *)(s->specific_data);
  IMEBufferMethods mthds = ds->session_core.ime_methods_table;
  IMEBuffer ime_buffer = ds->session_core.ime_buffer;
  int n_property;
  KOLE_config **p_configs;
    
  (*mthds->ime_buffer_get_configuration)(ime_buffer, &n_property, &p_configs);
  
}
#endif
