/*
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Karl Park <karl.park@sun.com>
 */

#ifndef LE_OPTIONS_H
#define LE_OPTIONS_H

#ifndef Bool
typedef enum {
  True=1, False=0
} Boolean;
#define Bool Boolean
#endif

#define DEFAULT_KOLE_OPTION_FILE "/usr/lib/iiim/le/kole/input_methods/kole.conf"
/* NAME of Options */
#define STR_OPTION_CHARSET "charset"
#define STR_OPTION_DELETION "delete by jaso"
#define STR_OPTION_KEYBOARD "keyboard"
#define STR_OPTION_COMMITMODE "commit mode"

/* Value of Options */
#define STR_CHARSET_EUC "euc"
#define STR_CHARSET_UNICODE "utf8"

#define STR_DELETION_BY_JASO_YES "y"
#define STR_DELETION_BY_JASO_NO "n"

#define STR_KEYBOARD_LAYOUT_2PAIR "2bul"
#define STR_KEYBOARD_LAYOUT_3PAIR390 "3bul_390"
#define STR_KEYBOARD_LAYOUT_3PAIRFINAL "3bul_final"


#define STR_COMMITMODE_BY_CHAR "char"
#define STR_COMMITMODE_BY_HOTKEY "hotkey"


enum KOLE_OPTION_TYPES {
  KOLE_OPTION_TYPE_KEYBOARD,
  KOLE_OPTION_TYPE_CHARSET,
  KOLE_OPTION_TYPE_DELETION,
  KOLE_OPTION_TYPE_CHARBASED_COMMIT,
  KOLE_OPTION_TYPE_COUNT,
};

typedef enum KOLE_OPTION_TYPES KOLE_option_type;


enum _KEYBOARD_LAYOUT_T {
  LAYOUT_2PART = 0,
  LAYOUT_3PART390,
  LAYOUT_3PART_FINAL,
  LAYOUT_NUM,
};
typedef enum _KEYBOARD_LAYOUT_T KEYBOARD_LAYOUT_T;
typedef KEYBOARD_LAYOUT_T OPTION_KEYBOARD_LAYOUT;

typedef enum _OPTION_CHARSET {
  IN_EUC,
  IN_UNICODE,
} OPTION_CHARSET;


typedef enum _OPTION_DELETION{
  BY_CHAR,
  BY_JASO
} OPTION_DELETION;

typedef enum _OPTION_COMMIT_MODE {
  COMMIT_BY_CHAR,
  COMMIT_BY_HOTKEY
} OPTION_COMMIT_MODE;

typedef struct {
  enum KOLE_OPTION_TYPES type;
  char *vstr;
  union {
    KEYBOARD_LAYOUT_T kbd;
    OPTION_CHARSET cset;
    OPTION_DELETION del;
    OPTION_COMMIT_MODE commit_by;
  } v;
} KOLE_config;

typedef struct _Config Config;

struct _Config {
  OPTION_CHARSET charset;
  OPTION_DELETION deletion;
  OPTION_KEYBOARD_LAYOUT keyboard;
  OPTION_COMMIT_MODE commit_mode;
};

#endif /* LE_OPTIONS_H */
