#ifndef _LE_DESKTOP_H_
#define _LE_DESKTOP_H_

#include "le_info.h"

typedef enum {
    AUX_NOT_STARTED = 0,
    AUX_STARTED,
} AuxStatus;

typedef struct _AuxModuleRec {
    char *class_name;
    AuxStatus status;
} AuxModuleRec;

typedef struct _LeDesktopContextRec {
    char *locale;

    ImeModuleRec *default_ime_module;
    HanJaStatus default_hanja_status;
    PunctStatus default_qjbj_status;
    int default_conversion_status;

    int   time_stamp;
    char  shortcutkey_vkb;

    int num_ime_modules;
    ImeModuleContextRec **ime_modules;

    int num_aux_modules;
    AuxModuleRec **aux_modules;

    int palette_aux_started;

    iml_session_t *current_session;

    int            focus_seq_wrong;

} LeDesktopContextRec;

#endif	/* _LE_DESKTOP_H_ */
