#include <stdio.h>

#include "ime_module.h"

/********************************************************/
/*                   IMEFeedback                            */
/********************************************************/
IMEFeedback ime_feedback_init()
{
    IMEFeedback ime_feedback =
	(IMEFeedback) calloc(1, sizeof(IMEFeedbackRec));
    return (ime_feedback);
}

IMEResult ime_feedback_destroy(IMEFeedback ime_feedback)
{
    if (ime_feedback == NULL)
	return (IME_FAIL);

    free((char *) ime_feedback);
    return (IME_OK);
}

/********************************************************/
/*                   IMEText                            */
/********************************************************/
IMEText ime_text_init()
{
    IMEText ime_text = (IMEText) calloc(1, sizeof(IMETextRec));
    return (ime_text);
}

IMEResult ime_text_destroy(IMEText ime_text)
{
    if (ime_text == NULL)
	return (IME_FAIL);

    if (ime_text->text)
	free((char *) ime_text->text);
    ime_text->text = NULL;

    if (ime_text->feedbacks)
	ime_feedback_destroy(ime_text->feedbacks);
    ime_text->feedbacks = NULL;

    ime_text->encoding = ENCODE_INVALID;
    ime_text->char_length = 0;
    ime_text->count_feedbacks = 0;

    free((char *) ime_text);
    return (IME_OK);
}

/********************************************************/
/*                   IMEPreedit                         */
/********************************************************/
IMEPreedit ime_preedit_init()
{
    IMEPreedit ime_preedit = (IMEPreedit) calloc(1, sizeof(IMEPreeditRec));
    return (ime_preedit);
}

IMEResult ime_preedit_destroy(IMEPreedit ime_preedit)
{
    if (ime_preedit == NULL)
	return (IME_FAIL);

    if (ime_preedit->text)
	ime_text_destroy(ime_preedit->text);

    ime_preedit->text = NULL;
    ime_preedit->caret = 0;
    ime_preedit->caret_direction = 0;

    free((char *) ime_preedit);
    return (IME_OK);
}

/********************************************************/
/*                   IMELookup                          */
/********************************************************/
IMELookup ime_lookup_init()
{
    IMELookup ime_lookup = (IMELookup) calloc(1, sizeof(IMELookupRec));
    return (ime_lookup);
}

IMEResult ime_lookup_destroy(IMELookup ime_lookup)
{
    int i;

    if (ime_lookup == NULL)
	return (IME_FAIL);

    if (ime_lookup->layout)
	free((char *) ime_lookup->layout);

    if (ime_lookup->choices) {
	for (i = 0; i < ime_lookup->n_choices; i++) {
	    if (ime_lookup->choices[i]) {
		ime_text_destroy(ime_lookup->choices[i]->label);
		ime_text_destroy(ime_lookup->choices[i]->candidate);
		ime_text_destroy(ime_lookup->choices[i]->comments);
	    }
	}
	free((char *) ime_lookup->choices);
    }

    if (ime_lookup->title)
	ime_text_destroy(ime_lookup->title);

    free((char *) ime_lookup);
    return (IME_OK);
}

/********************************************************/
/*                   IMECommit                          */
/********************************************************/
IMECommit ime_commit_init()
{
    IMECommit ime_commit = (IMECommit) calloc(1, sizeof(IMECommitRec));
    return (ime_commit);
}

IMEResult ime_commit_destroy(IMECommit ime_commit)
{
    if (ime_commit == NULL)
	return (IME_FAIL);

    if (ime_commit->commit_buf)
	free((char *) ime_commit->commit_buf);

    ime_commit->commit_buf = NULL;
    ime_commit->commit_len = 0;

    free((char *) ime_commit);
    return (IME_OK);
}

IMEResult ime_commit_clear(IMECommit ime_commit)
{
    ime_commit->commit_len = 0;
    return (IME_OK);
}

/********************************************************/
/*                   IMEBeep                          */
/********************************************************/
IMEBeep ime_beep_init()
{
    IMEBeep ime_beep = (IMEBeep) calloc(1, sizeof(IMEBeepRec));
    return (ime_beep);
}

IMEResult ime_beep_destroy(IMEBeep ime_beep)
{
    if (ime_beep == NULL)
	return (IME_FAIL);

    free((char *) ime_beep);
    return (IME_OK);
}

/********************************************************/
/*                   IMEInput                          */
/********************************************************/
IMEInput ime_input_init()
{
    IMEInput ime_input = (IMEInput) calloc(1, sizeof(IMEInputRec));
    return (ime_input);
}

IMEResult ime_input_destroy(IMEInput ime_input)
{
    if (ime_input == NULL)
	return (IME_FAIL);

    if (ime_input->input_buf)
	free((char *) ime_input->input_buf);

    ime_input->input_buf = NULL;
    ime_input->input_len = 0;

    free((char *) ime_input);
    return (IME_OK);
}

IMEResult ime_input_clear(IMEInput ime_input)
{
    if (ime_input == NULL)
	return (IME_FAIL);

    ime_input->input_len = 0;
    return (IME_OK);
}

/********************************************************/
/*                   IMEBuffer                          */
/********************************************************/
IMEBuffer ime_buffer_init()
{
    IMEBuffer ime_buffer = (IMEBuffer) calloc(1, sizeof(IMEBufferRec));
    return (ime_buffer);
}

IMEResult ime_buffer_destroy(IMEBuffer ime_buffer)
{
    if (ime_buffer == NULL)
	return (IME_FAIL);

    if (ime_buffer->preedit) {
	ime_preedit_destroy(ime_buffer->preedit);
    }

    if (ime_buffer->lookup) {
	ime_lookup_destroy(ime_buffer->lookup);
    }

    if (ime_buffer->commit) {
	ime_commit_destroy(ime_buffer->commit);
    }

    if (ime_buffer->beep) {
	ime_beep_destroy(ime_buffer->beep);
    }

    return (IME_OK);
}

IMEResult ime_buffer_set_mask_info(IMEBuffer ime_buffer, int mask)
{
    if (ime_buffer == NULL)
	return (IME_FAIL);

    ime_buffer->mask = mask;

    return (IME_OK);
}

IMEResult ime_buffer_get_mask_info(IMEBuffer ime_buffer, int *mask)
{
    *mask = 0;
    if (ime_buffer == NULL)
	return (IME_FAIL);

    *mask = ime_buffer->mask;

    return (IME_OK);
}

#if 0

IMEResult ime_buffer_set_preedit_info(IMEBuffer ime_buffer,
				      unsigned char *preedit_buf,
				      int preedit_len)
{
    if (ime_buffer == NULL)
	return (IME_FAIL);

    if (ime_buffer->preedit == NULL) {
	ime_buffer->preedit = ime_preedit_init();
	if (ime_buffer->preedit == NULL)
	    return (IME_FAIL);
    }

    if (ime_buffer->preedit->preedit_buf != NULL)
	free((char *) ime_buffer->preedit->preedit_buf);
    ime_buffer->preedit->preedit_buf =
	(unsigned char *) calloc(preedit_len + 1, sizeof(unsigned char));
    if (ime_buffer->preedit->preedit_buf == NULL)
	return (IME_FAIL);

    strncpy(ime_buffer->preedit->preedit_buf, preedit_buf, preedit_len);
    ime_buffer->preedit->preedit_len = preedit_len;

    return (IME_OK);
}

IMEResult ime_buffer_get_preedit_info(IMEBuffer ime_buffer,
				      unsigned char *preedit_buf,
				      int *preedit_len)
{
    int preedit_len_true = *preedit_len;

    *preedit_len = 0;

    if (ime_buffer == NULL)
	return (IME_FAIL);
    if (ime_buffer->preedit == NULL)
	return (IME_FAIL);
    if (ime_buffer->preedit->preedit_buf == NULL)
	return (IME_FAIL);

    if (ime_buffer->preedit->preedit_len < preedit_len_true)
	preedit_len_true = ime_buffer->preedit->preedit_len;

    strncpy(preedit_buf, ime_buffer->preedit->preedit_buf,
	    preedit_len_true);
    *preedit_len = preedit_len_true;

    return (IME_OK);
}

IMEResult ime_buffer_set_commit_info(IMEBuffer ime_buffer,
				     unsigned char *commit_buf,
				     int commit_len)
{
    if (ime_buffer == NULL)
	return (IME_FAIL);

    if (ime_buffer->commit == NULL) {
	ime_buffer->commit = ime_commit_init();
	if (ime_buffer->commit == NULL)
	    return (IME_FAIL);
    }

    if (ime_buffer->commit->commit_buf != NULL)
	free((char *) ime_buffer->commit->commit_buf);
    ime_buffer->commit->commit_buf =
	(unsigned char *) calloc(commit_len + 1, sizeof(unsigned char));
    if (ime_buffer->commit->commit_buf == NULL)
	return (IME_FAIL);

    strncpy(ime_buffer->commit->commit_buf, commit_buf, commit_len);
    ime_buffer->commit->commit_len = commit_len;

    return (IME_OK);
}

IMEResult ime_buffer_set_input_info(IMEBuffer ime_buffer,
				    unsigned char *input_buf,
				    int input_len)
{
    if (ime_buffer == NULL)
	return (IME_FAIL);

    if (ime_buffer->input == NULL) {
	ime_buffer->input = ime_input_init();
	if (ime_buffer->input == NULL)
	    return (IME_FAIL);
    }

    if (ime_buffer->input->input_buf != NULL)
	free((char *) ime_buffer->input->input_buf);
    ime_buffer->input->input_buf =
	(unsigned char *) calloc(input_len + 1, sizeof(unsigned char));
    if (ime_buffer->input->input_buf == NULL)
	return (IME_FAIL);

    strncpy(ime_buffer->input->input_buf, input_buf, input_len);
    ime_buffer->input->input_len = input_len;

    return (IME_OK);
}

IMEResult ime_buffer_get_input_info(IMEBuffer ime_buffer,
				    unsigned char *input_buf,
				    int *input_len)
{
    int input_len_true = *input_len;

    *input_len = 0;

    if (ime_buffer == NULL)
	return (IME_FAIL);
    if (ime_buffer->input == NULL)
	return (IME_FAIL);
    if (ime_buffer->input->input_buf == NULL)
	return (IME_FAIL);

    if (ime_buffer->input->input_len < input_len_true)
	input_len_true = ime_buffer->input->input_len;

    strncpy(input_buf, ime_buffer->input->input_buf, input_len_true);
    *input_len = input_len_true;

    return (IME_OK);
}

IMEResult ime_buffer_set_beep_info(IMEBuffer ime_buffer, int beep_type,
				   int beep_volume, int beep_length)
{
    if (ime_buffer == NULL)
	return (IME_FAIL);

    if (ime_buffer->beep == NULL) {
	ime_buffer->beep = ime_beep_init();
	if (ime_buffer->beep == NULL)
	    return (IME_FAIL);
    }

    if (beep_volume == -1)
	beep_volume = IME_BEEP_VOLUME_DEFAULT;
    if (beep_length == -1)
	beep_length = IME_BEEP_LENGTH_DEFAULT;

    ime_buffer->beep->beep_type = beep_type;
    ime_buffer->beep->beep_volume = beep_volume;
    ime_buffer->beep->beep_length = beep_length;

    return (IME_OK);
}

IMEResult ime_buffer_set_lookup_info(IMEBuffer ime_buffer,
				     IMELookupLabelType label_type,
				     unsigned char **label_buf,
				     int lookup_num,
				     unsigned char **lookup_buf,
				     IMELookupDirection direction)
{
    int i;

    if (lookup_num <= 0)
	return (IME_FAIL);
    if (lookup_buf == NULL)
	return (IME_FAIL);

    if (ime_buffer == NULL)
	return (IME_FAIL);

    if (ime_buffer->lookup == NULL) {
	ime_buffer->lookup = ime_lookup_init();
	if (ime_buffer->lookup == NULL)
	    return (IME_FAIL);
    }

    if (ime_buffer->lookup->label_buf != NULL) {
	for (i = 0; i < ime_buffer->lookup->lookup_num; i++) {
	    if (ime_buffer->lookup->label_buf[i] != NULL)
		free((char *) ime_buffer->lookup->label_buf[i]);
	}
	free((char *) ime_buffer->lookup->label_buf);
	ime_buffer->lookup->label_buf = NULL;
    }

    if (ime_buffer->lookup->lookup_buf != NULL) {
	for (i = 0; i < ime_buffer->lookup->lookup_num; i++) {
	    if (ime_buffer->lookup->lookup_buf[i] != NULL)
		free((char *) ime_buffer->lookup->lookup_buf[i]);
	}
	free((char *) ime_buffer->lookup->lookup_buf);
	ime_buffer->lookup->lookup_buf = NULL;
    }

    if (label_type == IMELookupLabel_Customized) {
	if (label_buf == NULL) {
	    label_type = IMELookupLabel_Numeric_Begin_With_0;
	} else {
	    ime_buffer->lookup->label_buf =
		(unsigned char **) calloc(lookup_num,
					  sizeof(unsigned char *));
	    if (ime_buffer->lookup->label_buf == NULL) {
		label_type = IMELookupLabel_Numeric_Begin_With_0;
	    } else {
		for (i = 0; i < lookup_num; i++) {
		    if (label_buf[i] == NULL)
			continue;
		    ime_buffer->lookup->label_buf[i] =
			(unsigned char *) strdup(label_buf[i]);
		}
	    }
	}
    }

    ime_buffer->lookup->lookup_num = lookup_num;
    ime_buffer->lookup->lookup_buf =
	(unsigned char **) calloc(lookup_num, sizeof(unsigned char *));
    if (ime_buffer->lookup->lookup_buf == NULL) {
	return (IME_FAIL);
    }

    for (i = 0; i < lookup_num; i++) {
	if (lookup_buf[i] == NULL)
	    continue;
	ime_buffer->lookup->lookup_buf[i] =
	    (unsigned char *) strdup(lookup_buf[i]);
    }

    ime_buffer->lookup->label_type = label_type;
    ime_buffer->lookup->direction = direction;

    return (IME_OK);
}

#endif
