/* 
 * Copyright (C) 2008 Sun Microsystems
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Aijin Kim <Aijin.Kim@Sun.COM>
 */

#ifndef _NEIMA_IM_H_
#define _NEIMA_IM_H_

#include "ime.h"

#define MAX_CANDIDATES_NUM              16
#define MAX_INPUT_KEY_NUM               9
#define MAX_PREEDIT_CHAR_NUM            9
#define MAX_CANDIDATE_CHAR_NUM          9
#define MAX_COMMIT_CHAR_NUM             9

#define MAX_KEYMAP_KEY_NUM              95

#define IME_PREEDIT_AREA                1
#define IME_LOOKUP_AREA                 2
#define IME_STATUS_AREA                 4
#define IME_COMMIT                      8

typedef struct _ImeBufferRec {
	ImeEncoding encoding;

	char preedit_buf[MAX_PREEDIT_CHAR_NUM];
	int  preedit_len;

	char *lookups[MAX_CANDIDATES_NUM];
	char lookups_buf[MAX_CANDIDATES_NUM][MAX_CANDIDATE_CHAR_NUM];
	int  num_candidates;

	int  commit_len;
	char commit_buf[MAX_COMMIT_CHAR_NUM];

	int  preedit_caretpos;
        int  lookup_label_type;
        int  return_status;
} ImeBufferRec;

#define imm_map_keyevent 		imm_services->ImmPrefilterKey
#define imm_get_ime_info		imm_services->ImmGetImeInfo
#define imm_get_ime_session_data	imm_services->ImmGetData
#define imm_set_ime_session_data	imm_services->ImmSetData
#define imm_show_preedit		imm_services->ImmShowPreedit
#define imm_hide_preedit		imm_services->ImmHidePreedit
#define imm_update_preedit		imm_services->ImmUpdatePreedit
#define imm_show_candidates		imm_services->ImmShowCandidates
#define imm_hide_candidates		imm_services->ImmHideCandidates
#define imm_update_candidates		imm_services->ImmUpdateCandidates
#define imm_commit			imm_services->ImmCommit
#define imm_beep			imm_services->ImmBeep
#define imm_show_aux			imm_services->ImmStartAux
#define imm_hide_aux			imm_services->ImmCloseAux

#endif /* _NEIMA_IM_H_ */
