/* 
 * Copyright (C) 2008 Sun Microsystems
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Aijin Kim <Aijin.Kim@Sun.COM>
 */

#include <stdio.h>
#include <iconv.h>

#include "ime.h"
#include "ime_buffer.h"

#define PREFIX_COMPLETE     (0x20000)
#define PREFIX_VALID        (0x10000)
#define HEXCANDIDATES       (0x0FFFF)

//lower 16 bit return value mask '0..9A..F' possiblities.
//    When return valid, lower 16 bit contains value only when incoming hex-char
//         could make the hex-string valid character.
//    When non-valid or complete, lower 16 bit is of no use

static unsigned char number_string[] = "0123456789ABCDEF";

#define HEXVALUE(c)     ((c >= 'A')?(c-'A'+10):(c-'0'))

int commit_all(ImeBufferRec *ime_buffer)
{
    unsigned char *p = ime_buffer->preedit.preedit.text, *dst =ime_buffer->commit_buf;

    for(; *p; p+=2)
        *dst++ = (HEXVALUE(*p) << 4) + HEXVALUE(*(p+1));
    *dst = 0;

    ime_buffer->preedit.preedit.text[0] = '\0';
    ime_buffer->preedit.caret = 0;
    ime_buffer->candidates.count = 0;
    ime_buffer->return_status |= (IME_COMMIT | IME_PREEDIT_AREA | IME_LOOKUP_AREA);
}

int hex_ko_filter(unsigned char key, ImeBufferRec *ime_buffer)
{
    int  i, ret, preedit_len;
    unsigned char *p, *dst;

    ime_buffer->return_status = 0;
    preedit_len = strlen(ime_buffer->preedit.preedit.text);

    DEBUG_printf("    ====>hex_ko: filter key(0x%x)\n", key);
    if ((key >= '0' && key <= '9') || (key >= 'a' && key <= 'f') || (key >= 'A' && key <= 'F')) {
        DEBUG_printf("        ====>hex_ko:ime_buffer->preedit.preedit.text: %s (len=%d) key=%c(0x%x)\n", ime_buffer->preedit.preedit.text, preedit_len, key, key);

        ime_buffer->preedit.preedit.text[preedit_len] = toupper(key);
        ime_buffer->preedit.preedit.text[++preedit_len] = 0;

        ret = validate_prefix(ime_buffer->preedit.preedit.text);
        DEBUG_printf("        ====>Validating Key...result 0x%x...", ret);
        if (!(ret & PREFIX_VALID)) {
            DEBUG_printf("Invalid\n", key);
            ime_buffer->preedit.preedit.text[--preedit_len] = 0;
            return IME_INVALID_KEY;
        }
        DEBUG_printf("valid Key\n", key);
        DEBUG_printf("        ====>hex_ko:ime_buffer->preedit.preedit.text: %s (len=%d) key=%c(0x%x)\n", ime_buffer->preedit.preedit.text, preedit_len, key, key);

        ime_buffer->preedit.caret = preedit_len;
        ime_buffer->return_status |= IME_PREEDIT_AREA;

        if (ret & PREFIX_COMPLETE) {
            printf("  [Hex_Ko IME] Commit all...\n");
            commit_all(ime_buffer);
        } else if (ret & PREFIX_VALID) {
            ime_buffer->candidates.count = 0;
            ime_buffer->candidates.page_state = ImeCandidatesFirstPage | ImeCandidatesLastPage;
            for (i=0; i < 16; ++i) {
                if (ret & 1) {
                    dst = ime_buffer->candidates.candidates[ime_buffer->candidates.count].text;
                    for(p=ime_buffer->preedit.preedit.text; *p && *(p+1); p+=2)
                        *dst++ = (HEXVALUE(*p) << 4) + HEXVALUE(*(p+1));
                    *dst++ = (HEXVALUE(*p) << 4) + i;
                    *dst = 0;
                    ime_buffer->candidates.numbers[ime_buffer->candidates.count] = number_string[i];
                    ime_buffer->candidates.numbers[ime_buffer->candidates.count+1] = 0;
                    ++ime_buffer->candidates.count;
                }
                ret >>= 1;
            }
            printf("    ====%d Candidates\n",  ime_buffer->candidates.count);
            if (ime_buffer->candidates.count) {
                ime_buffer->return_status |= IME_LOOKUP_AREA;

                #ifdef DEBUG
                for (i=0; i < ime_buffer->candidates.count; ++i) {
                    printf("          %c %s\n", 
                          ime_buffer->candidates.numbers[i], 
                          ime_buffer->candidates.candidates[i].text);
                }
                #endif
            }
        }
        return(IME_OK);
    }

    if(key == IME_FILTERED_KEY_ESCAPE && preedit_len > 0) {
        clear_ime_buffer(ime_buffer);
        ime_buffer->return_status |= (IME_PREEDIT_AREA | IME_LOOKUP_AREA);
        return (IME_OK);
    }

    if ((key == IME_FILTERED_KEY_BACKSPACE || key == IME_FILTERED_KEY_DELETE) && (preedit_len > 0)) {
        ime_buffer->preedit.preedit.text[--preedit_len] = '\0';
        ime_buffer->return_status = IME_PREEDIT_AREA;
        ime_buffer->candidates.count = 0;
        ime_buffer->return_status |= IME_LOOKUP_AREA;
        return(IME_OK);
    }

    return (preedit_len == 0)?(IME_UNUSED_KEY):(IME_INVALID_KEY);
}

int validate_prefix(unsigned char *prefix)
{
    int idx, ret;

    for (idx = 0; *prefix; ++prefix, ++idx) {
        switch (idx) {
        case 0:
            if (*prefix < 'A' || *prefix > 'F')
                return 0;
            break;
        case 1:
            if ((*(prefix-1) == 'A' && *prefix == '0') || (*(prefix-1) == 'F' && *prefix > '7'))
                return 0;
            break;
        case 2:
            if (*prefix < 'A' || *prefix > 'F')
                return 0;
            break;
        case 3:
            if ((*(prefix-1) == 'A' && *prefix == '0') || (*(prefix-1) == 'F' && *prefix == 'F'))
                return 0;
            break;
        default:
            return 0;
        }
    }
    ret = PREFIX_VALID;
    if (idx == 3) {
        ret |= HEXCANDIDATES;
        if (*(prefix-1) == 'F') ret ^= 0x8000;
        if (*(prefix-1) == 'A') ret ^= 0x0001;
    } else if (idx == 4) {
        ret |= PREFIX_COMPLETE;
    }
    return ret;
}
