/* 
 * Copyright (C) 2008 Sun Microsystems
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Aijin Kim <Aijin.Kim@Sun.COM>
 */

#include "ime.h"
#include "hangul_im.h"

ImmResult hangul_lookup_start(ImeInputContext ic, hangul_session_t *hs, ImeKey key);
ImmResult hangul_lookup_commit(ImeInputContext ic, hangul_session_t *hs);
ImmResult hangul_lookup_commit_nth(ImeInputContext ic, hangul_session_t *hs, int n);
ImmResult hangul_lookup_prev(ImeInputContext ic, hangul_session_t *hs);
ImmResult hangul_lookup_next(ImeInputContext ic, hangul_session_t *hs);
ImmResult hangul_lookup_prev_page(ImeInputContext ic, hangul_session_t *hs);
ImmResult hangul_lookup_next_page(ImeInputContext ic, hangul_session_t *hs);
ImmResult hangul_lookup_done(ImeInputContext ic, hangul_session_t *hs);

ImmResult hangul_update_preedit(ImeInputContext ic, hangul_session_t *hs);
ImmResult hangul_commit(ImeInputContext ic, hangul_session_t *hs);

int hangul_flush(ImeInputContext ic, hangul_session_t *hs);

void get_key_value(char *buf, char *key, char *value);
