/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/* Copyright (c) 2004 Red Hat, Inc. All rights reserved. */

#include "SunIM.h"

Bool    if_default_OpenIF      (iml_if_t *If);
Bool    if_default_CloseIF     (iml_if_t *If);
Bool    if_default_GetIFValue  (iml_if_t *If,
				IMArgList args,
				int       num_args);
Bool    if_default_SetIFValue  (iml_if_t *If,
				IMArgList args,
				int       num_args);
Bool    if_default_OpenDesktop (iml_desktop_t *desktop,
				IMArgList      args,
				int            num_args);
Bool    if_default_CloseDesktop(iml_desktop_t *desktop);
Bool    if_default_CreateSC    (iml_session_t *s,
				IMArgList      args,
				int            num_args);
Bool    if_default_DestroySC   (iml_session_t *s);
Bool    if_default_GetSCValue  (iml_session_t *s,
				IMArgList      args,
				int            num_args);
Bool    if_default_SetSCValue  (iml_session_t *s,
				IMArgList      args,
				int            num_args);
IMText *if_default_ResetSC     (iml_session_t *s);
void    if_default_SetSCFocus  (iml_session_t *s);
void    if_default_UnsetSCFocus(iml_session_t *s);
void    if_default_SendEvent   (iml_session_t *s,
				IMInputEvent *ev);

/* LEIF methods */
if_methods_t default_methods = {
    if_default_OpenIF,
    if_default_CloseIF,
    if_default_GetIFValue,
    if_default_SetIFValue,

    if_default_OpenDesktop,
    if_default_CloseDesktop,

    if_default_CreateSC,
    if_default_DestroySC,
    if_default_GetSCValue,
    if_default_SetSCValue,
    if_default_ResetSC,
    if_default_SetSCFocus,
    if_default_UnsetSCFocus,
    if_default_SendEvent,
};

UTFCHAR lename_string[] = {'d', 'e', 'f', 'a', 'u', 'l', 't', 0};
UTFCHAR hrn_string[] = {'d', 'i', 's', 'a', 'b', 'l', 'e', 'd', 0};

static IMLEName lename = {
    "default", lename_string
};
static IMLocale locales[] = {
    {"en", hrn_string},
    {NULL, NULL},
};
static IMObjectDescriptorStruct *objects = NULL;


void
if_GetIfInfo(IMArgList args,
	     int       num_args)
{
    int i;

    for (i = 0; i < num_args; i++, args++) {
	switch (args->id) {
	    case IF_VERSION:
		args->value = (IMArgVal) "1.2";
		break;
	    case IF_METHOD_TABLE:
		args->value = (IMArgVal) &default_methods;
		break;
	    case IF_LE_NAME:
		args->value = (IMArgVal) &lename;
		break;
	    case IF_SUPPORTED_LOCALES:
		args->value = (IMArgVal) &locales;
		break;
	    case IF_SUPPORTED_OBJECTS:
		args->value = (IMArgVal) objects;
		break;
	    case IF_NEED_THREAD_LOCK:
		args->value = (IMArgVal) False;
		break;
	    default:
		break;
	}
    }
}

/*
 * LEIF methods
 */
Bool
if_default_OpenIF(iml_if_t *If)
{
    return True;
}

Bool
if_default_CloseIF(iml_if_t *If)
{
    return True;
}

Bool
if_default_GetIFValue(iml_if_t *If,
		      IMArgList args,
		      int       num_args)
{
    return True;
}

Bool
if_default_SetIFValue(iml_if_t *If,
		      IMArgList args,
		      int       num_args)
{
    return True;
}

Bool
if_default_OpenDesktop(iml_desktop_t *desktop,
		       IMArgList      args,
		       int            num_args)
{
    return True;
}

Bool
if_default_CloseDesktop(iml_desktop_t *desktop)
{
    return True;
}

Bool
if_default_CreateSC(iml_session_t *s,
		    IMArgList      args,
		    int            num_args)
{
    return True;
}

Bool
if_default_DestroySC(iml_session_t *s)
{
    return True;
}

Bool
if_default_GetSCValue(iml_session_t *s,
		      IMArgList      args,
		      int            num_args)
{
    return True;
}

Bool
if_default_SetSCValue(iml_session_t *s,
		      IMArgList      args,
		      int            num_args)
{
    return True;
}

IMText *
if_default_ResetSC(iml_session_t *s)
{
    return (IMText *)NULL;
}

void
if_default_SetSCFocus(iml_session_t *s)
{
}

void
if_default_UnsetSCFocus(iml_session_t *s)
{
}

void
if_default_SendEvent(iml_session_t *s,
		     IMInputEvent *ev)
{
    if (ev) {
	if (ev->type == IM_EventKeyList) {
	    iml_inst *lp;

	    lp = s->If->m->iml_make_keypress_inst(s, (IMKeyEventStruct *)((IMKeyListEvent *)ev)->keylist);
	    s->If->m->iml_execute(s, &lp);
	}
    }
}
