/*

Copyright (c) 2006 Yuuhei TERAMOTO <tera@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "syscfg.h"
#include <errno.h>
#include <iconv.h>
#include "phonogram_conv.h"
#include "conv.h"
#include "encode.h"

static iconv_t open_iconv( char * to, char *from );

pgc_descriptor_rec *
pgc_open(
    char * rule_path,
    char * out_encode
)
{
    char *unit_encode;
    pgc_descriptor_rec * pgcd = (pgc_descriptor_rec *)malloc(sizeof(pgc_descriptor_rec));
    if( pgcd == NULL ){
	errno = ENOMEM;
	return NULL;
    }
    memset( pgcd, 0, sizeof(*pgcd) );
    pgcd->rule_path = strdup( rule_path );
    if( LoadCodeTable( pgcd->rule_path, &pgcd->hztbl ) == -1 ){
	goto err;
    }
    if( out_encode != NULL ){
	unit_encode = get_name_from_encodeid( pgcd->hztbl.Encode );
	if( strcasecmp( out_encode, unit_encode ) != 0 ){
	    pgcd->ic_out = open_iconv( out_encode, unit_encode );
	    if( pgcd->ic_out == (iconv_t)-1 ){
		goto err;
	    }
	}else{
	    pgcd->ic_out = (iconv_t)-1;
	}
    }
end1:    
    return pgcd;
err:
    if( pgcd != NULL ){
	free( pgcd->rule_path );
    }
    free(pgcd);
    pgcd = NULL;
    goto end1;
}

void
pgc_close(
    pgc_descriptor_rec * pgcd
)
{
    if( pgcd == NULL ){
	return;
    }
    if( pgcd->ic_out != (iconv_t)-1 ){
	iconv_close( pgcd->ic_out );
    }
    if( pgcd->rule_path != NULL ){
	free( pgcd->rule_path );
    }
    UnloadCodeTable( &pgcd->hztbl );
    free(pgcd);
}

int
pgc_convert(
    pgc_descriptor_rec * pgcd,
    PGC_UTFCHAR *inbuf, 
    size_t inlen,
    int eot,
    pgc_trans_list * trans_list
)
{
    int ret = 0;
    size_t ii, schinlen;
    int *schin;

    *trans_list = NULL;

    if( pgcd == NULL ){
	return -1;
    }
    schinlen = inlen + eot;
    schin = (int*)malloc( sizeof(*schin) * schinlen );
    if( schin == NULL ){
	goto err;
    }
    for( ii = 0 ; ii < inlen; ii++ ){
	schin[ii] = (unsigned int)inbuf[ii];
    }
    if( eot ){
	schin[ii++] = PGC_ENDOFTEXT;
    }
    ret = codetable_search(&pgcd->hztbl, schin, schinlen, trans_list );
    if( ret < 0 ){
	goto err;
    }
    if( pgcd->ic_out != (iconv_t)-1 ){
	pgc_trans trans;
	for( trans = pgc_trans_list_next( *trans_list, NULL ); 
	     trans != NULL; trans = pgc_trans_list_next( *trans_list, trans ) ){
	    if( pgc_trans_reencode( pgcd->ic_out, trans ) != 0 ){
		goto err;
	    }
	}
    }
end:
    free( schin );
    return ret;
err:
    if( ret != 0 ){
	ret = -1;
    }
    goto end;

}

static iconv_t
open_iconv( 
char * to,
char *from 
)
{
    char dummy1[2]={0}, dummy2[4];
    char *inbuf = dummy1;
    char *outbuf = dummy2;
    size_t inbytesleft=sizeof(dummy1), outbytesleft=sizeof(dummy2);
    iconv_t icd;

    icd = iconv_open( to, from );
    if( icd == (iconv_t)-1 ){
	return (iconv_t)-1;
    }
    //remove BOM
    iconv( icd, &inbuf, &inbytesleft, &outbuf, &outbytesleft );
    return icd;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */







