/*

Copyright (c) 2006 Kenji ABE <abek@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#include <stdlib.h>
#include <string.h>

#include "imtext.h"
#include "utfcsdef.h"


static IMText *make_empty_im_text(iml_session_t *session);
static IMFeedbackList *create_feedback_list(iml_session_t *session, int size, int count_per_char, int deco);


IMText *
make_im_text(
    iml_session_t *session,
    const UTFCHAR *str,
    int len,
    int deco
)
{
    iml_methods_t *mtbl;
    IMText *txt;

    ASSERT(session);

    mtbl = METHODS_TBL(session);

    txt = make_empty_im_text(session);
    txt->char_length = len;

    if (len > 0) {
	txt->text.utf_chars = mtbl->iml_new(session, len * sizeof(UTFCHAR));
	if (txt->text.utf_chars == NULL) {
	    return NULL;
	}

	if (str) {
	    memmove(txt->text.utf_chars, str, len * sizeof(UTFCHAR));
	}

	txt->feedback = create_feedback_list(session, txt->char_length, N_FEEDBACK_TYPE, deco);
	if (txt->feedback == NULL) {
	    return NULL;
	}
    }

    return txt;
}

static
IMText *
make_empty_im_text(
    iml_session_t *session
)
{
    iml_methods_t *mtbl;
    IMText *txt;

    ASSERT(session);

    mtbl = METHODS_TBL(session);

    txt = mtbl->iml_new(session, sizeof(IMText));
    memset(txt, 0, sizeof(IMText));
    txt->encoding = UTF16_CODESET;

    return txt;
}

static
IMFeedbackList *
create_feedback_list(
    iml_session_t *session,
    int size,
    int count_per_char,
    int deco
)
{
    iml_methods_t *mtbl;
    IMFeedbackList *fb_list, *p;
    IMFeedback *fb;
    int fb_alloc_size;
    int i;

    ASSERT(session);

    mtbl = METHODS_TBL(session);
    
    fb_list = mtbl->iml_new(session, sizeof(IMFeedbackList) * size);

    fb_alloc_size = sizeof(IMFeedback) * size * count_per_char;
    fb = mtbl->iml_new(session, fb_alloc_size);
    memset(fb, 0, fb_alloc_size);

    p = fb_list;
    for (i = 0; i < size; ++i) {
	p->count_feedbacks = count_per_char;
	p->feedbacks = fb;

	fb[0].type = IM_DECORATION_FEEDBACK;
	fb[0].value = deco;

	++p;
	fb += count_per_char;
    }

    return fb_list;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
