/*

Copyright (c) 2006 Kenji ABE <abek@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#include "IMArg.h"
#include "SunIM.h"
#include "SunIMProt.h"
#include "SunIMMthd.h"
#include "SunIMCore.h"

#include "iminput.h"
#include "imtext.h"
#include "imstatus.h"
#include "utfcsdef.h"


static void make_status_on_inst(iml_session_t *session, iml_inst **inst_list);
static void make_status_off_inst(iml_session_t *session, iml_inst **inst_list);


const UTFCHAR STATUS_PREFIX[] = {'A', 'n', 't', 'h', 'y', '[', 0x0000};
const UTFCHAR STATUS_POSTFIX[] = {']', 0x0000};

const UTFCHAR STATUS_MODE_DIRECT = '-';

const UTFCHAR STATUS_SEPARATOR = '/';

const UTFCHAR STATUS_METHOD_ROMAN = 'R';


#define STATUS_STR_MAX (16)


void
draw_status(
    iml_session_t *session
)
{
    iml_methods_t *mtbl = METHODS_TBL(session);
    iml_inst *inst_list = NULL;

    make_status_draw_inst(session, &inst_list);
    mtbl->iml_execute(session, &inst_list);
}

void
clear_status(
    iml_session_t *session
)
{
    iml_methods_t *mtbl = METHODS_TBL(session);
    PrivateSessionData *psd = SESSION_DATA(session);
    if (psd->draw_status_p) {
	iml_inst *inst_list = NULL;
	make_status_off_inst(session, &inst_list);
	mtbl->iml_execute(session, &inst_list);

	psd->draw_status_p = False;
    }
}

void
make_status_draw_inst(
    iml_session_t *session,
    iml_inst **inst_list
)
{
    PrivateSessionData *psd = SESSION_DATA(session);
    iml_methods_t *mtbl = METHODS_TBL(session);
    IMText *im_txt;
    iml_inst *inst;
    UTFCHAR buff[STATUS_STR_MAX];
    UTFCHAR *p;

    if (!psd->draw_status_p) {
	make_status_on_inst(session, inst_list);
	mtbl->iml_execute(session, inst_list);
	*inst_list = NULL;

	psd->draw_status_p = True;
    }

    p = utfcscpy(buff, STATUS_PREFIX);
    if (psd->im_state == IM_STATE_OFF) {
	*p = STATUS_MODE_DIRECT;
    } else {
	*p = im_input_get_status_char(psd->im_input);
    }
    ++p;
    *p++ = STATUS_SEPARATOR;
    *p++ = STATUS_METHOD_ROMAN;
    p = utfcscpy(p, STATUS_POSTFIX);

    im_txt  = make_im_text(session, buff, p - buff, 0);
    inst = mtbl->iml_make_status_draw_inst(session, im_txt);
    mtbl->iml_link_inst_tail(inst_list, inst);
}

static
void
make_status_on_inst(
    iml_session_t *session,
    iml_inst **inst_list
)
{
    iml_methods_t *mtbl = METHODS_TBL(session);
    iml_inst *inst = mtbl->iml_make_status_start_inst(session);
    mtbl->iml_link_inst_tail(inst_list, inst);
}

static
void
make_status_off_inst(
    iml_session_t *session,
    iml_inst **inst_list
)
{
    iml_methods_t *mtbl = METHODS_TBL(session);
    iml_inst *inst = mtbl->iml_make_status_done_inst(session);
    mtbl->iml_link_inst_tail(inst_list, inst);
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
