/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include "commonIM.h"
#include "XimpIm.h"
#include "switchIM.h"
#include "iiimpIM.h"
#include "composeIM.h"
#include "iiimpIC.h"
#include "status.h"
#include "iiimpSwitcher.h"
#include "iiimpAuxP.h"
#include "guiIM.h"
#include "guiIMPre.h"
#include "iiimpUtil.h"
#include "xfactory.h"
#include "popupIM.h"
#include "KeyMap.h"

static int SwitchCloseIM(XIM);

extern char* IIIMP_SetIMValues(XIM, XIMArg*);
extern char* IIIMP_GetIMValues(XIM, XIMArg*);

static XIC SwitchCreateIC(XIM, XIMArg*);
extern int _Ximp_ctstombs(XIM, char*, int, char*, int, Status*);
extern int _Ximp_ctstowcs(XIM, char*, int, wchar_t*, int, Status*);

int	active_im_count = 0;

static XIMMethods
get_switch_im_methods()
{
    static XIMMethodsRec imm;

    if (!imm.close) {
	imm.close = SwitchCloseIM;
	imm.set_values = IIIMP_SetIMValues;
	imm.get_values = IIIMP_GetIMValues;
	imm.create_ic = SwitchCreateIC;
	imm.ctstombs = _Ximp_ctstombs;
	imm.ctstowcs = _Ximp_ctstowcs;
    }
    return &imm;
}


static void DestroyIC(XIC);
static void SetFocus(XIC);
static void UnSetFocus(XIC);
static char *MbReset(XIC);
static wchar_t *WcReset(XIC);
extern char *IIIMP_SetICValues(XIC, XIMArg *);
extern char *IIIMP_GetICValues(XIC, XIMArg *);
static int MbLookupString(XIC, XKeyEvent *,
			  char *, int,
			  KeySym *, Status *);
static int WcLookupString(XIC, XKeyEvent *,
			  wchar_t *, int,
			  KeySym *, Status *);

static XICMethods
get_switch_ic_methods()
{
    static XICMethodsRec icm;

    if (!icm.destroy) {
	icm.destroy = DestroyIC;
	icm.set_focus = SetFocus;
	icm.unset_focus = UnSetFocus;
	icm.set_values = IIIMP_SetICValues;
	icm.get_values = IIIMP_GetICValues;
	icm.mb_reset = MbReset;
	icm.wc_reset = WcReset;
	icm.mb_lookup_string = MbLookupString;
	icm.wc_lookup_string = WcLookupString;
    }
    return &icm;
}

XIM
_SwitchOpenIM(
    XLCd lcd,
    Display *dpy,
    XrmDatabase rdb,
    char *res_name,
    char *res_class
)
{
    XimCommon im = 0;
    char *disableMultiScriptIM = getenv("DISABLE_MULTI_SCRIPT_IM");

    if (disableMultiScriptIM &&
	!strcmp("true", disableMultiScriptIM)) return 0; /* hidden feature */

    im = Xmalloc(sizeof(XimCommonRec));
    if (!im) goto Error;
    memset(im, 0, sizeof(XimCommonRec));

    if (!CommonOpenIM((XIM)im, lcd, dpy, rdb, res_name, res_class))
	goto Error;

    im->methods = get_switch_im_methods();

    if (!COMPOSE_OpenIM_SWITCH((XIM)im, lcd)) goto Error;
    if (!IIIMP_OpenIM_SWITCH((XIM)im, lcd, dpy)) goto Error;

    active_im_count += 1;

    CommonSetErrorHandler ();
    return (XIM)im;

Error:
    if (im) Xfree(im);
    return 0;
}

static Status
SwitchCloseIM(
    XIM xim
)
{
    XimCommon im = (XimCommon)xim;

    active_im_count -= 1;

    XIM_COMPOSE(im, switch_methods)->close(xim);
    XIM_IIIMP(im, switch_methods)->close(xim);

    CommonCloseIM((XIM)im);

    return True;
}

void
RegisterSwitchFilter(
    XicCommon ic, 
    SwitchKeyEventProc is_switch_key,
    XFilterEventProc key_filter,
    XICMethods ic_methods
)
{
    SwitchFilterEventRec *rec;

    rec = (SwitchFilterEventList)Xmalloc(sizeof(SwitchFilterEventRec));
    if (!rec)
	return;
    rec->is_switch_key = is_switch_key;
    rec->key_filter = key_filter;
    rec->ic_methods = ic_methods;
    rec->next = ic->switch_filters;
    ic->switch_filters = rec;
    return;
}

void
UnRegisterSwitchFilter(
    XicCommon ic, 
    SwitchKeyEventProc is_switch_key,
    XFilterEventProc key_filter,
    XICMethods ic_methods
)
{
    SwitchFilterEventList *prev, fl;

    for (prev = &ic->switch_filters; (fl = *prev) != NULL; ) {
	if (fl->is_switch_key == is_switch_key &&
	    fl->key_filter == key_filter && fl->ic_methods == ic_methods) {
	    *prev = fl->next;
	    Xfree((char *)fl);
	} else
	    prev = &fl->next;
    }
    return;
}

void
ResetSwitchFilter(
    XicCommon ic
)
{
    extern Bool Ximp_Local_KeyFilter(Display *, Window, XEvent*, XPointer);

    ic->active_filter = Ximp_Local_KeyFilter; /* default */
    ic->active_methods = get_local_ic_methods();
    return;
}

#ifdef HAS_IIIM_PROPERTIES
/*
 * super hotkey handling in clien side
 */
#define IMSTR_BUFSIZE 256

static void
le_select_set_input_language (XicCommon ic, char  *imstr) {
  int conv_mode;
  static Atom desktop_lang_atom = None;
  Display *display = ic->core.im->core.display;
  char *imstr_copy = strdup (imstr);
  
  ic_initialize_with_input_language (ic, imstr_copy);
  free (imstr_copy); 
  ic_switcher_set_input_language (ic, NULL);

  iiimcf_get_current_conversion_mode (XIC_IIIMP(ic, context),
				      &conv_mode);

  if (IsActivateAtSwitch (ic, conv_mode)) {
    IMTriggerNotify(ic, CONV_ON);
    SetConversionMode(ic, True);
  } else {
    IMTriggerNotify(ic, CONV_OFF);
    SetConversionMode(ic, False);
  }

  if (desktop_lang_atom == None) {
    desktop_lang_atom =
      XInternAtom (display, "_IIIM_SWITCHER_DESKTOP_INPUT_LANGUAGE", False);
  }
  XChangeProperty (display, DefaultRootWindow (display),
		   desktop_lang_atom, desktop_lang_atom,
		   8,
		   PropModeReplace,
		   (unsigned char *)imstr,
		   strlen (imstr) + 1);
}

static char *
get_next_im_string (XicCommon ic) {

  XimCommon im = (XimCommon)ic->core.im;
  LangElement *langs = XIM_IIIMP (im, supported_languages);
  int num_of_langs = XIM_IIIMP (im, count_languages);
  int current_id = 0, i;
  char *lang, *engine;
  char buffer[IMSTR_BUFSIZE];

  for (i = 0; i < num_of_langs; i++) {
    if (!strcmp (ic->current_language, langs[i].lang_id) &&
	(ic->current_le == NULL || !strcmp (ic->current_le, langs[i].engine_id))) {
      current_id = i;
      break;
    }
  }
  if (current_id + 1 < num_of_langs) {
    lang = langs[current_id + 1].lang_id;
    engine = langs[current_id + 1].engine_id;
  } else {
    lang = langs[0].lang_id;
    engine = langs[0].engine_id;
  }

  if ((strlen (lang) + strlen (engine) + 2) > IMSTR_BUFSIZE) {
    /* must be illegal lang or engine */
    return strdup("C");
  }
  sprintf (buffer, "%s:%s", lang, engine);

  return strdup (buffer);
}

static char *
get_prev_im_string (XicCommon ic) {
  XimCommon im = (XimCommon)ic->core.im;
  LangElement *langs = XIM_IIIMP (im, supported_languages);
  int num_of_langs = XIM_IIIMP (im, count_languages);
  int current_id = 0, i;
  char *lang, *engine;
  char buffer[IMSTR_BUFSIZE];

  for (i = 0; i < num_of_langs; i++) {
    if (!strcmp (ic->current_language, langs[i].lang_id) &&
	(ic->current_le == NULL || !strcmp (ic->current_le, langs[i].engine_id))) {
      current_id = i;
      break;
    }
  }
  if (current_id  < 1) {
    lang = langs[num_of_langs - 1].lang_id;
    engine = langs[num_of_langs - 1].engine_id;
  } else {
    lang = langs[current_id - 1].lang_id;
    engine = langs[current_id - 1].engine_id;
  }

  if ((strlen (lang) + strlen (engine) + 2) > IMSTR_BUFSIZE) {
    /* must be illegal lang or engine */
    return strdup("C");
  }
  sprintf (buffer, "%s:%s", lang, engine);

  return strdup (buffer);
}

static Bool le_select_keypress();
static Bool le_select_client_buttonpress();
static Bool le_select_buttonpress();
static Bool le_select_buttonmotion();

static void
le_select_window_normalize (LESelectWindow *lsw) {
  if (lsw->index < 0)
    lsw->index = 0;
  else if (lsw->index + 1 >= lsw->length) {
    lsw->index = lsw->length - 1;
  }
}

static void
le_select_done (XicCommon ic) {
  XimCommon im = (XimCommon)ic->core.im;
  Display *display = im->core.display;
  LESelectWindow *lsw = XIM_IIIMP (im, le_select_window);

  XUnmapWindow (display, lsw->window);
  _XUnregisterFilter (display, lsw->client, le_select_keypress, (XPointer)ic);
  _XUnregisterFilter (display, lsw->client, le_select_client_buttonpress, (XPointer)ic);
  _XUnregisterFilter (display, lsw->window, le_select_buttonpress, (XPointer)ic);
  _XUnregisterFilter (display, lsw->window, le_select_buttonmotion, (XPointer)ic);
}

static Bool
le_select_buttonmotion (Display *display, Window window, XEvent *event,
			XPointer client_data) {
  XicCommon ic = (XicCommon)client_data;
  XimCommon im = (XimCommon)ic->core.im;
  LESelectWindow *le_select_window = XIM_IIIMP (im, le_select_window);

  le_select_window->index = get_lang_menu_index (ic, event);
  le_select_window_normalize (le_select_window);
  XIC_POPUP (ic, menu_index) = le_select_window->index + 1;
  update_lang_menu (ic, le_select_window->window);

  return True;
}

static Bool
le_select_buttonpress (Display *display, Window window, XEvent *event,
		       XPointer client_data) {

  char buffer[IMSTR_BUFSIZE];
  XicCommon ic = (XicCommon)client_data;
  XimCommon im = (XimCommon)ic->core.im;
  LESelectWindow *le_select_window = XIM_IIIMP (im, le_select_window);

  if (event->type == ButtonPress) {
    le_select_window->index = get_lang_menu_index (ic, event);
    le_select_window_normalize (le_select_window);
    XIC_POPUP (ic, menu_index) = le_select_window->index + 1;
    update_lang_menu (ic, le_select_window->window);
    return True;
  } else { /* ButtonRelease */
    LangElement *langs = XIM_IIIMP (im, supported_languages);
    if ((strlen (langs[le_select_window->index].lang_id) +
	 strlen (langs[le_select_window->index].engine_id) + 2) > IMSTR_BUFSIZE) {
      /* must be illegal lang_id or engine_id */
      return True;
    }
    sprintf (buffer, "%s:%s",
	     langs[le_select_window->index].lang_id,
	     langs[le_select_window->index].engine_id);
    le_select_set_input_language (ic, buffer);
  }

  le_select_done (ic);
  return True;
}

static Bool
le_select_client_buttonpress (Display *display, Window window, XEvent *event,
			      XPointer client_data) {

  le_select_done ((XicCommon)client_data);
  return True;
}

static Bool
le_select_keypress (Display *display, Window window, XEvent *event,
		    XPointer client_data) {
  XicCommon ic = (XicCommon)client_data;
  XimCommon im = (XimCommon)ic->core.im;
  IIIMCF_keyevent kev;
  LESelectWindow *le_select_window = XIM_IIIMP (im, le_select_window);
  char buffer[IMSTR_BUFSIZE];

  if (event->type == KeyRelease)
    return True;

  if (XKeyEvent_To_IIIMCF_keyevent ((XKeyEvent *)event, &kev)) {
    switch (kev.keycode) {
    case IIIMF_KEYCODE_SPACE:
    case IIIMF_KEYCODE_DOWN:
      if (le_select_window->index + 1 >= le_select_window->length) {
	le_select_window->index = 0;
      } else {
	le_select_window->index++;
      }
      XIC_POPUP (ic, menu_index) = le_select_window->index + 1;
      update_lang_menu (ic, le_select_window->window);
      return True;
    case IIIMF_KEYCODE_UP:
      if (le_select_window->index < 1) {
	le_select_window->index = le_select_window->length - 1;
      } else {
	le_select_window->index--;
      }
      XIC_POPUP (ic, menu_index) = le_select_window->index + 1;
      update_lang_menu (ic, le_select_window->window);
      return True;
    case IIIMF_KEYCODE_ENTER:
      {
	LangElement *langs = XIM_IIIMP (im, supported_languages);
	if ((strlen (langs[le_select_window->index].lang_id) +
	     strlen (langs[le_select_window->index].engine_id) + 2) > IMSTR_BUFSIZE) {
	  /* must be illegal lang_id or engine_id */
	  return True;
	}
	sprintf (buffer, "%s:%s",
		 langs[le_select_window->index].lang_id,
		 langs[le_select_window->index].engine_id);
	le_select_set_input_language (ic, buffer);
	/* go through to unmap selection popup */
      }
    }
  }

  le_select_done (ic);
  return True;
}

static Bool
le_select_repaint (Display *display, Window window, XEvent *event,
		   XPointer client_data) {
  XicCommon ic = (XicCommon)client_data;
  XimCommon im = (XimCommon)ic->core.im;
  LESelectWindow *le_select_window = XIM_IIIMP (im, le_select_window);
  XIC_POPUP (ic, menu_index) = le_select_window->index + 1;
  update_lang_menu (ic, le_select_window->window);
  return True;
}

static Bool
le_select_map (Display *display, Window window, XEvent *event,
		   XPointer client_data) {
  return True;
}

static Bool
le_select_unmap (Display *display, Window window, XEvent *event,
		   XPointer client_data) {

  le_select_done ((XicCommon)client_data);
  return True;
}

static void
le_select_setup_menu (XicCommon ic, Window client)
{
  XimCommon im = (XimCommon)ic->core.im;
  Display *display = im->core.display;
  LESelectWindow *le_select_window = XIM_IIIMP(im, le_select_window);
  int x = 0, y = 0;
  int new_x, new_y;
  unsigned int width, height;
  XPoint point;

  XSizeHints hints;

  if (!le_select_window || !(le_select_window->window)) {
    le_select_window = (LESelectWindow *)malloc (sizeof (LESelectWindow));
    XIM_IIIMP (im, le_select_window) = le_select_window;
    unsigned long fg, bg;

    status_window_fg_and_bg (ic, &fg, &bg);
    le_select_window->window = XCreateSimpleWindow (display, DefaultRootWindow (display),
						    0, 0, 1, 1, 0, 0, bg);
    XFactoryRemoveDecoration (display, le_select_window->window);
    XSelectInput (display, le_select_window->window,
		  KeyPressMask|ExposureMask|ButtonPressMask|ButtonReleaseMask|
		  StructureNotifyMask|PointerMotionMask);

    _XRegisterFilterByType (display, le_select_window->window,
			    Expose, Expose,
			    le_select_repaint, (XPointer)ic);
    _XRegisterFilterByType (display, le_select_window->window,
			    MapNotify, MapNotify,
			    le_select_map, (XPointer)ic);
    _XRegisterFilterByType (display, le_select_window->window,
			    UnmapNotify, UnmapNotify,
			    le_select_unmap, (XPointer)ic);
  }

  le_select_window->index = 0;
  le_select_window->length = XIM_IIIMP (im, count_languages);
  le_select_window->client = client;

  _XRegisterFilterByType (display, client,
			  KeyPress, KeyRelease,
			  le_select_keypress, (XPointer)ic);
  _XRegisterFilterByType (display, client,
			  ButtonPress, ButtonRelease,
			  le_select_client_buttonpress, (XPointer)ic); 
  _XRegisterFilterByType (display, le_select_window->window,
			  ButtonPress, ButtonRelease,
			  le_select_buttonpress, (XPointer)ic);
  _XRegisterFilterByType (display, le_select_window->window,
			  MotionNotify, MotionNotify,
			  le_select_buttonmotion, (XPointer)ic);

  if (XIMP_CHK_PREAREAMASK (ic)) {
    x = ic->core.preedit_attr.area.x;
    y = ic->core.preedit_attr.area.y;
    XFactoryGetLocationOnScreen (display, client, x, y, &point);
  } else if (XIMP_CHK_PRESPOTLMASK (ic)) {
    point.x = -1;
    point.y = -1;
    PreeditCaretPlacement (ic, &point);
    if ((point.x == -1) && (point.y == -1)) {
      XFontSetExtents *fse;
      fse = XExtentsOfFontSet (status_window_fontset (ic));
      x = ic->core.preedit_attr.spot_location.x;
      y = ic->core.preedit_attr.spot_location.y;
      y += (fse->max_logical_extent.height + fse->max_logical_extent.y);
      y += 6;
      XFactoryGetLocationOnScreen (display, client, x, y, &point);
    } else{
      point.y += 4;
    }
  } else {
    Window parent;
    Window root;
    int x_return,y_return;
    unsigned int width_return,height_return,border_width_return,depth_return;
    parent =  XFactoryGetFrameWindow (display, client);
    XGetGeometry (display, parent, &root, &x_return,&y_return,
		  &width_return,&height_return,&border_width_return, &depth_return);
    XFactoryGetLocationOnScreen(display, parent, 0, height_return, &point);
    point.x -= border_width_return;
    point.y += border_width_return;
  }
  x = point.x;
  y = point.y;
  
  get_lang_menu_size (ic, &width, &height);
  XFactoryAdjustPlacementInsideScreen (display, le_select_window->window,
				       x, y, width, height, &new_x, &new_y);

  hints.flags = PPosition | PSize;
  hints.x = new_x;
  hints.y = new_y;
  hints.width = 100;
  hints.height = 200;
  XSetWMNormalHints (display, le_select_window->window, &hints);
  XMoveResizeWindow (display, le_select_window->window, new_x, new_y, width, height);

  XMapWindow (display, le_select_window->window);
  XRaiseWindow (display, le_select_window->window);
  popup_lang_menu (ic, new_x, new_y, le_select_window->window, NULL, False);
  update_lang_menu (ic, le_select_window->window);
}

static void
le_switch_handler(XicCommon ic, Window w)
{
  le_select_setup_menu (ic, w);
}

static void
le_cycle_handler(XicCommon ic)
{
  char *imstr = get_next_im_string (ic);
  le_select_set_input_language (ic, imstr);
  free (imstr);
}

static void
le_reverse_cycle_handler(XicCommon ic)
{
  char *imstr = get_prev_im_string (ic);
  le_select_set_input_language (ic, imstr);
  free (imstr);
}

#endif /* HAS_IIIM_PROPERTIES */

static Bool
vkb_target_filter(
    Display *d,
    Window w,
    XEvent *ev,
    XPointer client_data
)
{
    XicCommon ic = (XicCommon)client_data;
    if (ic == NULL || ic->iiimp_icpart == NULL)
      return False;
    XIC xic = (XIC)client_data;
    if (ev->type == FocusIn) {
      IMChangeFocus(ic, 1);
    } else if (ev->type == FocusOut) {
      IMChangeFocus(ic, 0);
    }
    
    return False;
}


/*
  ALLOW_SWITCH_FROM_REMOTE_TO_LOCAL is a bad idea, but for now as
  a quick solution to disable switching from a remote language engine
  to a local input mode, I have to put these codes..
  (by toshi with deepest regrets)
*/
  
static Bool
Switch_KeyFilter(
    Display *d /*unused*/,
    Window w /* unused */,
    XEvent *ev,
    XPointer client_data
)
{
    XicCommon ic = (XicCommon)client_data;
    SwitchFilterEventList filter;
    SwitchMode mode;
#ifndef ALLOW_SWITCH_FROM_REMOTE_TO_LOCAL
    Bool IIIMP_Local_KeyFilter(Display *d /*unused*/,
			       Window w /* unused */,
			       XEvent *ev, XPointer client_data);
#endif

#ifdef HAS_IIIM_PROPERTIES    
    SuperHotkeyKind shk;
    if (ev->type == KeyPress && isSuperHotkey ((XimCommon)ic->core.im, ev, &shk)) {
      switch (shk) {
      case LE_SELECT:
	le_switch_handler (ic, w);
	break;
      case LE_CYCLE:
	le_cycle_handler (ic);
	break;
      case LE_REVERSE_CYCLE:
	le_reverse_cycle_handler (ic);
	break;
      }
      return True;
    }
#endif /* HAS_IIIM_PEOPERTIES */
    
    for (filter = ic->switch_filters; filter; filter = filter->next) {
	if (ev->type == KeyPress || ev->type == KeyRelease)
	    mode = filter->is_switch_key(ic, ev);
	else
	    mode = Switch_NOP;
	switch (mode) {
	  case Switch_ON:
	   if (filter->next && filter->next->is_switch_key(ic, ev) == Switch_ON) {
	       /* If this key is used for the next filter too, give way 
		  to the next */
	       ic->active_filter = filter->next->key_filter;
	       ic->active_methods = filter->next->ic_methods;
	   } else {
	       ic->active_filter = filter->key_filter;
	       ic->active_methods = filter->ic_methods;
	   }
	   goto call_filter;
	  case Switch_OFF:
	   if (ic->active_filter) {
	       /* Before turn off active filter, pass the event to the
		  handler because it may need to process the event to
		  finalize operations.  */
	       ic->active_filter(d, w, ev, client_data);
	   }
	   ResetSwitchFilter(ic);
	   return True;
	  case Switch_NOP:
	  default:
#ifndef ALLOW_SWITCH_FROM_REMOTE_TO_LOCAL
	   if (ic->active_filter == IIIMP_Local_KeyFilter)
	       goto call_filter;
#endif
	   break;
	}
    }
call_filter:
    if (!ic->active_filter) {
	ResetSwitchFilter(ic);
    }
    return ic->active_filter(d, w, ev, client_data);
}

static XIC
SwitchCreateIC(
    XIM xim,
    XIMArg * arg
)
{
    XicCommon ic = 0;
    ic = Xmalloc(sizeof(XicCommonRec));
    if (!ic) goto Error;;
    memset(ic, 0, sizeof(XicCommonRec));

    ic->core.im = xim;
    ic->methods = get_switch_ic_methods();

    if (!CommonCreateIC((XIC)ic, arg)) goto Error;
    
    if (!COMPOSE_CreateIC_SWITCH((XIC)ic, arg)) goto Error;
    if (!IIIMP_CreateIC_SWITCH((XIC)ic, arg)) goto Error;

    ic->core.filter_events = KeyPressMask;

    ResetSwitchFilter(ic);

    /* setting initialize needs to be done at very first place, so that
       incomming first status draw call back is handled correctly. */
    GetIMSettings(ic);

    return (XIC)ic;
Error:
    if (ic) Xfree(ic);
    return 0;
}

static void
DestroyIC(
    XIC xic
)
{
    XicCommon ic = (XicCommon)xic;

    _XUnregisterFilter(ic->core.im->core.display, ic->core.focus_window,
		       Switch_KeyFilter, (XPointer)ic);
    _XUnregisterFilter(ic->core.im->core.display, ic->core.focus_window,
		       vkb_target_filter, (XPointer)ic);

    IIimpDestroryAuxData(ic);

    if (ic->local_icpart)
      XIC_COMPOSE(ic, switch_methods)->destroy(xic);
    XIC_IIIMP(ic, switch_methods)->destroy(xic);

    CommonDestroyIC(xic);

    return;
}

#ifdef HAS_IIIM_PROPERTIES
extern Atom global_conv_mode_atom;

int
get_global_conv_mode (XIM im)
{
  XTextProperty text_props;
  int mode;
  XGetTextProperty (im->core.display,
		    RootWindow (im->core.display, DefaultScreen (im->core.display)),
		    &text_props, global_conv_mode_atom);
  if (text_props.value == NULL) {
    return -1;
  }
  if (!strcmp ((char *)text_props.value, "on")) {
    mode = 1;
  } else {
    mode = 0;
  }
  free (text_props.value);
  return mode;
}

void
set_global_conv_mode (XIM im, int mode)
{
  char *mode_str;
  mode_str = (mode == 1) ? "on" : "off";
  XChangeProperty (im->core.display,
		   RootWindow (im->core.display, DefaultScreen (im->core.display)),
		   global_conv_mode_atom,
		   global_conv_mode_atom,
		   8,
		   PropModeReplace,
		   (unsigned char *)mode_str,
		   strlen (mode_str));
}

#endif /* HAS_IIIM_PROPERTIES */

static void
SetFocus(
    XIC xic
)
{
    XicCommon ic = (XicCommon)xic;
#ifdef HAS_IIIM_PROPERTIES
	GetIIIMSettings (ic);
	if (!IsLangSwitchPerIC ()) {
	  extern char *get_desktop_lang (XicCommon);
	  extern char **my_strsplit (const char *, const char *);
	  char *desktop_lang = get_desktop_lang (ic);
	  char *dt_lang;
	  char *dt_le;
	  char **elms;

	  if (desktop_lang != NULL) {
	    elms = my_strsplit (desktop_lang, ":");
	    dt_lang = elms[0];
	    dt_le = elms[1];
	  } else {
	    dt_lang = NULL;
	    dt_le = NULL;
	  }
	  if ((dt_lang != NULL && dt_le == NULL &&
	       strcmp (dt_lang, ic->current_language)) ||
	      (dt_le != NULL && ic->current_le == NULL) ||
	      (dt_lang != NULL && dt_le != NULL &&
	       (strcmp (dt_lang, ic->current_language) ||
		strcmp (dt_le, ic->current_le)))) {
	    ic_initialize_with_input_language (ic, desktop_lang);
	  }
	  if (dt_lang != NULL) {
	    my_strfreev (elms);
	    free (desktop_lang);
	  }
	}
	if (IsSyncActivation ()) {
	  IIIMF_status st;
	  int conversion_mode = CONV_OFF;
	  int global_conversion_mode = get_global_conv_mode (ic->core.im);

	  st = iiimcf_get_current_conversion_mode (XIC_IIIMP(ic, context),
						   &conversion_mode);
	  if (conversion_mode != global_conversion_mode) {
	    if (global_conversion_mode == 1) {
	      ic_change_conversion_mode (ic, "on");
	    } else if (global_conversion_mode == 0) {
	      ic_change_conversion_mode (ic, "off");
	    }
	  }
	}
#endif /* HAS_IIIM_PROPERTIES */    

    _XRegisterFilterByType(ic->core.im->core.display, ic->core.focus_window,
			   KeyPress, KeyRelease,
			   Switch_KeyFilter, (XPointer)ic);

    /* VKB support for application which does not call XSetICFocus (ex: java) */
    _XRegisterFilterByType(ic->core.im->core.display, ic->core.focus_window,
			   FocusIn, FocusOut,
			   vkb_target_filter, (XPointer)ic);
    ic->active_methods->set_focus(xic);
  
    return;
}

static void
UnSetFocus(
    XIC xic
)
{
    XicCommon ic = (XicCommon)xic;

    ic->active_methods->unset_focus(xic);

#ifdef HAS_IIIM_PROPERTIES    
    /* This is needed to ensure gimlet knows the last client
     * coversion mode to handle on/off policy at language switching
     * "DO NOT CHANGE".
     */
    ic_switcher_set_conversion_mode (ic);
#endif /* HAS_IIIM_PROPERTIIES */     

    _XUnregisterFilter(ic->core.im->core.display, ic->core.focus_window,
		       vkb_target_filter, (XPointer)ic);

    return;
}

static char*
MbReset(
    XIC xic
)
{
    XicCommon ic = (XicCommon)xic;

/*
    _XUnregisterFilter(ic->core.im->core.display, ic->core.focus_window,
		       Switch_KeyFilter, (XPointer)ic);
*/
    return ic->active_methods->mb_reset(xic);
}

static wchar_t*
WcReset(
    XIC xic
)
{
    XicCommon ic = (XicCommon)xic;

/*
    _XUnregisterFilter(ic->core.im->core.display, ic->core.focus_window,
		       Switch_KeyFilter, (XPointer)ic);
*/
    return ic->active_methods->wc_reset(xic);
}

static int
MbLookupString(
    XIC xic,
    XKeyEvent *ev,
    char * buffer,
    int bytes,
    KeySym *keysym,
    Status *status
)
{
    XicCommon ic = (XicCommon)xic;
    int ret;

    ret = IIIMP_MbLookupString_SWITCH(xic, ev, buffer, bytes, keysym, status);
    if (0 < ret) {
	return ret;
    }

    return ic->active_methods->mb_lookup_string(xic,
						ev, buffer,
						bytes, keysym,
						status);
}

static int
WcLookupString(
    XIC xic,
    XKeyEvent *ev,
    wchar_t * buffer, 
    int wlen,
    KeySym *keysym,
    Status *status
)
{
    XicCommon ic = (XicCommon)xic;
    int ret;
    ret = IIIMP_WcLookupString_SWITCH(xic, ev, buffer, wlen, keysym, status);
    if (0 < ret) {
	return ret;
    }
    return ic->active_methods->wc_lookup_string(xic,
						ev, buffer,
						wlen, keysym,
						status);
}
      
void
SwitchUpdateStatus(
    XicCommon ic
)
{
    if (XIM_IS_SWITCH(ic->core.im) &&
	(ic->active_methods == get_local_ic_methods()) &&
	(None != ic->core.client_window)) {
	Ximp_Local_Status_Set(ic);
	Ximp_Local_Status_Start(ic);
	Ximp_Local_Status_Draw(ic);
    }
    return;
}

void
SwitchKeyEventFilter(
    XicCommon ic,
    Window old_focus
)
{
    _XUnregisterFilter(ic->core.im->core.display, old_focus,
		       Switch_KeyFilter, (XPointer)ic);
    _XRegisterFilterByType(ic->core.im->core.display, ic->core.focus_window,
			   KeyPress, KeyRelease,
			   Switch_KeyFilter, (XPointer)ic);
    return;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
