/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef XK_KATAKANA
#define XK_KATAKANA
#endif

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Xmd.h>
#ifdef sun
#include <X11/extensions/XKBproto.h>
#include <X11/XKBlib.h>
#endif

#if defined (sun)
#include <X11/Sunkeysym.h>
#endif /* sun */

#include "KeyMap.h"

#define kana_table 1 /* for japanese kana support */

typedef struct KEYMAP_ENTRY {
    long awtKey;
    KeySym x11Key;
    Bool printable;
} KeymapEntry;

#if kana_table
typedef struct KEYMAP_ENTRY2 {
    long awtKey;
    KeySym x11Key;
    KeySym alt_x11Key;
    int keychar;
    Bool printable;
    KeyCode keycode;
} KeymapEntry2;
#endif

static int awt_MetaMask = 0;
static int awt_AltMask = 0;
static int awt_NumLockMask = 0;
static int awt_KanaLockMask = 0;

#ifdef	linux
#include <X11/Xatom.h>
static long KanaMode = -1;
static Atom kanawin_atom = 0;
static Atom kanaflag_atom = 0;
#endif /* linux */

static const struct {
  unsigned short keysym;
  unsigned short ucs;
} x11_keysym_to_unicode_tab[] = {
  { 0x01a1, 0x0104 },  /* Aogonek */
  { 0x01a2, 0x02d8 },  /* breve */
  { 0x01a3, 0x0141 },  /* Lstroke */
  { 0x01a5, 0x013d },  /* Lcaron */
  { 0x01a6, 0x015a },  /* Sacute */
  { 0x01a9, 0x0160 },  /* Scaron */
  { 0x01aa, 0x015e },  /* Scedilla */
  { 0x01ab, 0x0164 },  /* Tcaron */
  { 0x01ac, 0x0179 },  /* Zacute */
  { 0x01ae, 0x017d },  /* Zcaron */
  { 0x01af, 0x017b },  /* Zabovedot */
  { 0x01b1, 0x0105 },  /* aogonek */
  { 0x01b2, 0x02db },  /* ogonek */
  { 0x01b3, 0x0142 },  /* lstroke */
  { 0x01b5, 0x013e },  /* lcaron */
  { 0x01b6, 0x015b },  /* sacute */
  { 0x01b7, 0x02c7 },  /* caron */
  { 0x01b9, 0x0161 },  /* scaron */
  { 0x01ba, 0x015f },  /* scedilla */
  { 0x01bb, 0x0165 },  /* tcaron */
  { 0x01bc, 0x017a },  /* zacute */
  { 0x01bd, 0x02dd },  /* doubleacute */
  { 0x01be, 0x017e },  /* zcaron */
  { 0x01bf, 0x017c },  /* zabovedot */
  { 0x01c0, 0x0154 },  /* Racute */
  { 0x01c3, 0x0102 },  /* Abreve */
  { 0x01c5, 0x0139 },  /* Lacute */
  { 0x01c6, 0x0106 },  /* Cacute */
  { 0x01c8, 0x010c },  /* Ccaron */
  { 0x01ca, 0x0118 },  /* Eogonek */
  { 0x01cc, 0x011a },  /* Ecaron */
  { 0x01cf, 0x010e },  /* Dcaron */
  { 0x01d0, 0x0110 },  /* Dstroke */
  { 0x01d1, 0x0143 },  /* Nacute */
  { 0x01d2, 0x0147 },  /* Ncaron */
  { 0x01d5, 0x0150 },  /* Odoubleacute */
  { 0x01d8, 0x0158 },  /* Rcaron */
  { 0x01d9, 0x016e },  /* Uring */
  { 0x01db, 0x0170 },  /* Udoubleacute */
  { 0x01de, 0x0162 },  /* Tcedilla */
  { 0x01e0, 0x0155 },  /* racute */
  { 0x01e3, 0x0103 },  /* abreve */
  { 0x01e5, 0x013a },  /* lacute */
  { 0x01e6, 0x0107 },  /* cacute */
  { 0x01e8, 0x010d },  /* ccaron */
  { 0x01ea, 0x0119 },  /* eogonek */
  { 0x01ec, 0x011b },  /* ecaron */
  { 0x01ef, 0x010f },  /* dcaron */
  { 0x01f0, 0x0111 },  /* dstroke */
  { 0x01f1, 0x0144 },  /* nacute */
  { 0x01f2, 0x0148 },  /* ncaron */
  { 0x01f5, 0x0151 },  /* odoubleacute */
  { 0x01f8, 0x0159 },  /* rcaron */
  { 0x01f9, 0x016f },  /* uring */
  { 0x01fb, 0x0171 },  /* udoubleacute */
  { 0x01fe, 0x0163 },  /* tcedilla */
  { 0x01ff, 0x02d9 },  /* abovedot */
  { 0x02a1, 0x0126 },  /* Hstroke */
  { 0x02a6, 0x0124 },  /* Hcircumflex */
  { 0x02a9, 0x0130 },  /* Iabovedot */
  { 0x02ab, 0x011e },  /* Gbreve */
  { 0x02ac, 0x0134 },  /* Jcircumflex */
  { 0x02b1, 0x0127 },  /* hstroke */
  { 0x02b6, 0x0125 },  /* hcircumflex */
  { 0x02b9, 0x0131 },  /* idotless */
  { 0x02bb, 0x011f },  /* gbreve */
  { 0x02bc, 0x0135 },  /* jcircumflex */
  { 0x02c5, 0x010a },  /* Cabovedot */
  { 0x02c6, 0x0108 },  /* Ccircumflex */
  { 0x02d5, 0x0120 },  /* Gabovedot */
  { 0x02d8, 0x011c },  /* Gcircumflex */
  { 0x02dd, 0x016c },  /* Ubreve */
  { 0x02de, 0x015c },  /* Scircumflex */
  { 0x02e5, 0x010b },  /* cabovedot */
  { 0x02e6, 0x0109 },  /* ccircumflex */
  { 0x02f5, 0x0121 },  /* gabovedot */
  { 0x02f8, 0x011d },  /* gcircumflex */
  { 0x02fd, 0x016d },  /* ubreve */
  { 0x02fe, 0x015d },  /* scircumflex */
  { 0x03a2, 0x0138 },  /* kra */
  { 0x03a3, 0x0156 },  /* Rcedilla */
  { 0x03a5, 0x0128 },  /* Itilde */
  { 0x03a6, 0x013b },  /* Lcedilla */
  { 0x03aa, 0x0112 },  /* Emacron */
  { 0x03ab, 0x0122 },  /* Gcedilla */
  { 0x03ac, 0x0166 },  /* Tslash */
  { 0x03b3, 0x0157 },  /* rcedilla */
  { 0x03b5, 0x0129 },  /* itilde */
  { 0x03b6, 0x013c },  /* lcedilla */
  { 0x03ba, 0x0113 },  /* emacron */
  { 0x03bb, 0x0123 },  /* gcedilla */
  { 0x03bc, 0x0167 },  /* tslash */
  { 0x03bd, 0x014a },  /* ENG */
  { 0x03bf, 0x014b },  /* eng */
  { 0x03c0, 0x0100 },  /* Amacron */
  { 0x03c7, 0x012e },  /* Iogonek */
  { 0x03cc, 0x0116 },  /* Eabovedot */
  { 0x03cf, 0x012a },  /* Imacron */
  { 0x03d1, 0x0145 },  /* Ncedilla */
  { 0x03d2, 0x014c },  /* Omacron */
  { 0x03d3, 0x0136 },  /* Kcedilla */
  { 0x03d9, 0x0172 },  /* Uogonek */
  { 0x03dd, 0x0168 },  /* Utilde */
  { 0x03de, 0x016a },  /* Umacron */
  { 0x03e0, 0x0101 },  /* amacron */
  { 0x03e7, 0x012f },  /* iogonek */
  { 0x03ec, 0x0117 },  /* eabovedot */
  { 0x03ef, 0x012b },  /* imacron */
  { 0x03f1, 0x0146 },  /* ncedilla */
  { 0x03f2, 0x014d },  /* omacron */
  { 0x03f3, 0x0137 },  /* kcedilla */
  { 0x03f9, 0x0173 },  /* uogonek */
  { 0x03fd, 0x0169 },  /* utilde */
  { 0x03fe, 0x016b },  /* umacron */
  { 0x047e, 0x203e },  /* overline */
  { 0x04a1, 0x3002 },  /* kana_fullstop */
  { 0x04a2, 0x300c },  /* kana_openingbracket */
  { 0x04a3, 0x300d },  /* kana_closingbracket */
  { 0x04a4, 0x3001 },  /* kana_comma */
  { 0x04a5, 0x30fb },  /* kana_conjunctive */
  { 0x04a6, 0x30f2 },  /* kana_WO */
  { 0x04a7, 0x30a1 },  /* kana_a */
  { 0x04a8, 0x30a3 },  /* kana_i */
  { 0x04a9, 0x30a5 },  /* kana_u */
  { 0x04aa, 0x30a7 },  /* kana_e */
  { 0x04ab, 0x30a9 },  /* kana_o */
  { 0x04ac, 0x30e3 },  /* kana_ya */
  { 0x04ad, 0x30e5 },  /* kana_yu */
  { 0x04ae, 0x30e7 },  /* kana_yo */
  { 0x04af, 0x30c3 },  /* kana_tsu */
  { 0x04b0, 0x30fc },  /* prolongedsound */
  { 0x04b1, 0x30a2 },  /* kana_A */
  { 0x04b2, 0x30a4 },  /* kana_I */
  { 0x04b3, 0x30a6 },  /* kana_U */
  { 0x04b4, 0x30a8 },  /* kana_E */
  { 0x04b5, 0x30aa },  /* kana_O */
  { 0x04b6, 0x30ab },  /* kana_KA */
  { 0x04b7, 0x30ad },  /* kana_KI */
  { 0x04b8, 0x30af },  /* kana_KU */
  { 0x04b9, 0x30b1 },  /* kana_KE */
  { 0x04ba, 0x30b3 },  /* kana_KO */
  { 0x04bb, 0x30b5 },  /* kana_SA */
  { 0x04bc, 0x30b7 },  /* kana_SHI */
  { 0x04bd, 0x30b9 },  /* kana_SU */
  { 0x04be, 0x30bb },  /* kana_SE */
  { 0x04bf, 0x30bd },  /* kana_SO */
  { 0x04c0, 0x30bf },  /* kana_TA */
  { 0x04c1, 0x30c1 },  /* kana_CHI */
  { 0x04c2, 0x30c4 },  /* kana_TSU */
  { 0x04c3, 0x30c6 },  /* kana_TE */
  { 0x04c4, 0x30c8 },  /* kana_TO */
  { 0x04c5, 0x30ca },  /* kana_NA */
  { 0x04c6, 0x30cb },  /* kana_NI */
  { 0x04c7, 0x30cc },  /* kana_NU */
  { 0x04c8, 0x30cd },  /* kana_NE */
  { 0x04c9, 0x30ce },  /* kana_NO */
  { 0x04ca, 0x30cf },  /* kana_HA */
  { 0x04cb, 0x30d2 },  /* kana_HI */
  { 0x04cc, 0x30d5 },  /* kana_FU */
  { 0x04cd, 0x30d8 },  /* kana_HE */
  { 0x04ce, 0x30db },  /* kana_HO */
  { 0x04cf, 0x30de },  /* kana_MA */
  { 0x04d0, 0x30df },  /* kana_MI */
  { 0x04d1, 0x30e0 },  /* kana_MU */
  { 0x04d2, 0x30e1 },  /* kana_ME */
  { 0x04d3, 0x30e2 },  /* kana_MO */
  { 0x04d4, 0x30e4 },  /* kana_YA */
  { 0x04d5, 0x30e6 },  /* kana_YU */
  { 0x04d6, 0x30e8 },  /* kana_YO */
  { 0x04d7, 0x30e9 },  /* kana_RA */
  { 0x04d8, 0x30ea },  /* kana_RI */
  { 0x04d9, 0x30eb },  /* kana_RU */
  { 0x04da, 0x30ec },  /* kana_RE */
  { 0x04db, 0x30ed },  /* kana_RO */
  { 0x04dc, 0x30ef },  /* kana_WA */
  { 0x04dd, 0x30f3 },  /* kana_N */
  { 0x04de, 0x309b },  /* voicedsound */
  { 0x04df, 0x309c },  /* semivoicedsound */
  { 0x05ac, 0x060c },  /* Arabic_comma */
  { 0x05bb, 0x061b },  /* Arabic_semicolon */
  { 0x05bf, 0x061f },  /* Arabic_question_mark */
  { 0x05c1, 0x0621 },  /* Arabic_hamza */
  { 0x05c2, 0x0622 },  /* Arabic_maddaonalef */
  { 0x05c3, 0x0623 },  /* Arabic_hamzaonalef */
  { 0x05c4, 0x0624 },  /* Arabic_hamzaonwaw */
  { 0x05c5, 0x0625 },  /* Arabic_hamzaunderalef */
  { 0x05c6, 0x0626 },  /* Arabic_hamzaonyeh */
  { 0x05c7, 0x0627 },  /* Arabic_alef */
  { 0x05c8, 0x0628 },  /* Arabic_beh */
  { 0x05c9, 0x0629 },  /* Arabic_tehmarbuta */
  { 0x05ca, 0x062a },  /* Arabic_teh */
  { 0x05cb, 0x062b },  /* Arabic_theh */
  { 0x05cc, 0x062c },  /* Arabic_jeem */
  { 0x05cd, 0x062d },  /* Arabic_hah */
  { 0x05ce, 0x062e },  /* Arabic_khah */
  { 0x05cf, 0x062f },  /* Arabic_dal */
  { 0x05d0, 0x0630 },  /* Arabic_thal */
  { 0x05d1, 0x0631 },  /* Arabic_ra */
  { 0x05d2, 0x0632 },  /* Arabic_zain */
  { 0x05d3, 0x0633 },  /* Arabic_seen */
  { 0x05d4, 0x0634 },  /* Arabic_sheen */
  { 0x05d5, 0x0635 },  /* Arabic_sad */
  { 0x05d6, 0x0636 },  /* Arabic_dad */
  { 0x05d7, 0x0637 },  /* Arabic_tah */
  { 0x05d8, 0x0638 },  /* Arabic_zah */
  { 0x05d9, 0x0639 },  /* Arabic_ain */
  { 0x05da, 0x063a },  /* Arabic_ghain */
  { 0x05e0, 0x0640 },  /* Arabic_tatweel */
  { 0x05e1, 0x0641 },  /* Arabic_feh */
  { 0x05e2, 0x0642 },  /* Arabic_qaf */
  { 0x05e3, 0x0643 },  /* Arabic_kaf */
  { 0x05e4, 0x0644 },  /* Arabic_lam */
  { 0x05e5, 0x0645 },  /* Arabic_meem */
  { 0x05e6, 0x0646 },  /* Arabic_noon */
  { 0x05e7, 0x0647 },  /* Arabic_ha */
  { 0x05e8, 0x0648 },  /* Arabic_waw */
  { 0x05e9, 0x0649 },  /* Arabic_alefmaksura */
  { 0x05ea, 0x064a },  /* Arabic_yeh */
  { 0x05eb, 0x064b },  /* Arabic_fathatan */
  { 0x05ec, 0x064c },  /* Arabic_dammatan */
  { 0x05ed, 0x064d },  /* Arabic_kasratan */
  { 0x05ee, 0x064e },  /* Arabic_fatha */
  { 0x05ef, 0x064f },  /* Arabic_damma */
  { 0x05f0, 0x0650 },  /* Arabic_kasra */
  { 0x05f1, 0x0651 },  /* Arabic_shadda */
  { 0x05f2, 0x0652 },  /* Arabic_sukun */
  { 0x06a1, 0x0452 },  /* Serbian_dje */
  { 0x06a2, 0x0453 },  /* Macedonia_gje */
  { 0x06a3, 0x0451 },  /* Cyrillic_io */
  { 0x06a4, 0x0454 },  /* Ukrainian_ie */
  { 0x06a5, 0x0455 },  /* Macedonia_dse */
  { 0x06a6, 0x0456 },  /* Ukrainian_i */
  { 0x06a7, 0x0457 },  /* Ukrainian_yi */
  { 0x06a8, 0x0458 },  /* Cyrillic_je */
  { 0x06a9, 0x0459 },  /* Cyrillic_lje */
  { 0x06aa, 0x045a },  /* Cyrillic_nje */
  { 0x06ab, 0x045b },  /* Serbian_tshe */
  { 0x06ac, 0x045c },  /* Macedonia_kje */
  { 0x06ad, 0x0491 },  /* Ukrainian_ghe_with_upturn */
  { 0x06ae, 0x045e },  /* Byelorussian_shortu */
  { 0x06af, 0x045f },  /* Cyrillic_dzhe */
  { 0x06b0, 0x2116 },  /* numerosign */
  { 0x06b1, 0x0402 },  /* Serbian_DJE */
  { 0x06b2, 0x0403 },  /* Macedonia_GJE */
  { 0x06b3, 0x0401 },  /* Cyrillic_IO */
  { 0x06b4, 0x0404 },  /* Ukrainian_IE */
  { 0x06b5, 0x0405 },  /* Macedonia_DSE */
  { 0x06b6, 0x0406 },  /* Ukrainian_I */
  { 0x06b7, 0x0407 },  /* Ukrainian_YI */
  { 0x06b8, 0x0408 },  /* Cyrillic_JE */
  { 0x06b9, 0x0409 },  /* Cyrillic_LJE */
  { 0x06ba, 0x040a },  /* Cyrillic_NJE */
  { 0x06bb, 0x040b },  /* Serbian_TSHE */
  { 0x06bc, 0x040c },  /* Macedonia_KJE */
  { 0x06bd, 0x0490 },  /* Ukrainian_GHE_WITH_UPTURN */
  { 0x06be, 0x040e },  /* Byelorussian_SHORTU */
  { 0x06bf, 0x040f },  /* Cyrillic_DZHE */
  { 0x06c0, 0x044e },  /* Cyrillic_yu */
  { 0x06c1, 0x0430 },  /* Cyrillic_a */
  { 0x06c2, 0x0431 },  /* Cyrillic_be */
  { 0x06c3, 0x0446 },  /* Cyrillic_tse */
  { 0x06c4, 0x0434 },  /* Cyrillic_de */
  { 0x06c5, 0x0435 },  /* Cyrillic_ie */
  { 0x06c6, 0x0444 },  /* Cyrillic_ef */
  { 0x06c7, 0x0433 },  /* Cyrillic_ghe */
  { 0x06c8, 0x0445 },  /* Cyrillic_ha */
  { 0x06c9, 0x0438 },  /* Cyrillic_i */
  { 0x06ca, 0x0439 },  /* Cyrillic_shorti */
  { 0x06cb, 0x043a },  /* Cyrillic_ka */
  { 0x06cc, 0x043b },  /* Cyrillic_el */
  { 0x06cd, 0x043c },  /* Cyrillic_em */
  { 0x06ce, 0x043d },  /* Cyrillic_en */
  { 0x06cf, 0x043e },  /* Cyrillic_o */
  { 0x06d0, 0x043f },  /* Cyrillic_pe */
  { 0x06d1, 0x044f },  /* Cyrillic_ya */
  { 0x06d2, 0x0440 },  /* Cyrillic_er */
  { 0x06d3, 0x0441 },  /* Cyrillic_es */
  { 0x06d4, 0x0442 },  /* Cyrillic_te */
  { 0x06d5, 0x0443 },  /* Cyrillic_u */
  { 0x06d6, 0x0436 },  /* Cyrillic_zhe */
  { 0x06d7, 0x0432 },  /* Cyrillic_ve */
  { 0x06d8, 0x044c },  /* Cyrillic_softsign */
  { 0x06d9, 0x044b },  /* Cyrillic_yeru */
  { 0x06da, 0x0437 },  /* Cyrillic_ze */
  { 0x06db, 0x0448 },  /* Cyrillic_sha */
  { 0x06dc, 0x044d },  /* Cyrillic_e */
  { 0x06dd, 0x0449 },  /* Cyrillic_shcha */
  { 0x06de, 0x0447 },  /* Cyrillic_che */
  { 0x06df, 0x044a },  /* Cyrillic_hardsign */
  { 0x06e0, 0x042e },  /* Cyrillic_YU */
  { 0x06e1, 0x0410 },  /* Cyrillic_A */
  { 0x06e2, 0x0411 },  /* Cyrillic_BE */
  { 0x06e3, 0x0426 },  /* Cyrillic_TSE */
  { 0x06e4, 0x0414 },  /* Cyrillic_DE */
  { 0x06e5, 0x0415 },  /* Cyrillic_IE */
  { 0x06e6, 0x0424 },  /* Cyrillic_EF */
  { 0x06e7, 0x0413 },  /* Cyrillic_GHE */
  { 0x06e8, 0x0425 },  /* Cyrillic_HA */
  { 0x06e9, 0x0418 },  /* Cyrillic_I */
  { 0x06ea, 0x0419 },  /* Cyrillic_SHORTI */
  { 0x06eb, 0x041a },  /* Cyrillic_KA */
  { 0x06ec, 0x041b },  /* Cyrillic_EL */
  { 0x06ed, 0x041c },  /* Cyrillic_EM */
  { 0x06ee, 0x041d },  /* Cyrillic_EN */
  { 0x06ef, 0x041e },  /* Cyrillic_O */
  { 0x06f0, 0x041f },  /* Cyrillic_PE */
  { 0x06f1, 0x042f },  /* Cyrillic_YA */
  { 0x06f2, 0x0420 },  /* Cyrillic_ER */
  { 0x06f3, 0x0421 },  /* Cyrillic_ES */
  { 0x06f4, 0x0422 },  /* Cyrillic_TE */
  { 0x06f5, 0x0423 },  /* Cyrillic_U */
  { 0x06f6, 0x0416 },  /* Cyrillic_ZHE */
  { 0x06f7, 0x0412 },  /* Cyrillic_VE */
  { 0x06f8, 0x042c },  /* Cyrillic_SOFTSIGN */
  { 0x06f9, 0x042b },  /* Cyrillic_YERU */
  { 0x06fa, 0x0417 },  /* Cyrillic_ZE */
  { 0x06fb, 0x0428 },  /* Cyrillic_SHA */
  { 0x06fc, 0x042d },  /* Cyrillic_E */
  { 0x06fd, 0x0429 },  /* Cyrillic_SHCHA */
  { 0x06fe, 0x0427 },  /* Cyrillic_CHE */
  { 0x06ff, 0x042a },  /* Cyrillic_HARDSIGN */
  { 0x07a1, 0x0386 },  /* Greek_ALPHAaccent */
  { 0x07a2, 0x0388 },  /* Greek_EPSILONaccent */
  { 0x07a3, 0x0389 },  /* Greek_ETAaccent */
  { 0x07a4, 0x038a },  /* Greek_IOTAaccent */
  { 0x07a5, 0x03aa },  /* Greek_IOTAdieresis */
  { 0x07a7, 0x038c },  /* Greek_OMICRONaccent */
  { 0x07a8, 0x038e },  /* Greek_UPSILONaccent */
  { 0x07a9, 0x03ab },  /* Greek_UPSILONdieresis */
  { 0x07ab, 0x038f },  /* Greek_OMEGAaccent */
  { 0x07ae, 0x0385 },  /* Greek_accentdieresis */
  { 0x07af, 0x2015 },  /* Greek_horizbar */
  { 0x07b1, 0x03ac },  /* Greek_alphaaccent */
  { 0x07b2, 0x03ad },  /* Greek_epsilonaccent */
  { 0x07b3, 0x03ae },  /* Greek_etaaccent */
  { 0x07b4, 0x03af },  /* Greek_iotaaccent */
  { 0x07b5, 0x03ca },  /* Greek_iotadieresis */
  { 0x07b6, 0x0390 },  /* Greek_iotaaccentdieresis */
  { 0x07b7, 0x03cc },  /* Greek_omicronaccent */
  { 0x07b8, 0x03cd },  /* Greek_upsilonaccent */
  { 0x07b9, 0x03cb },  /* Greek_upsilondieresis */
  { 0x07ba, 0x03b0 },  /* Greek_upsilonaccentdieresis */
  { 0x07bb, 0x03ce },  /* Greek_omegaaccent */
  { 0x07c1, 0x0391 },  /* Greek_ALPHA */
  { 0x07c2, 0x0392 },  /* Greek_BETA */
  { 0x07c3, 0x0393 },  /* Greek_GAMMA */
  { 0x07c4, 0x0394 },  /* Greek_DELTA */
  { 0x07c5, 0x0395 },  /* Greek_EPSILON */
  { 0x07c6, 0x0396 },  /* Greek_ZETA */
  { 0x07c7, 0x0397 },  /* Greek_ETA */
  { 0x07c8, 0x0398 },  /* Greek_THETA */
  { 0x07c9, 0x0399 },  /* Greek_IOTA */
  { 0x07ca, 0x039a },  /* Greek_KAPPA */
  { 0x07cb, 0x039b },  /* Greek_LAMBDA */
  { 0x07cc, 0x039c },  /* Greek_MU */
  { 0x07cd, 0x039d },  /* Greek_NU */
  { 0x07ce, 0x039e },  /* Greek_XI */
  { 0x07cf, 0x039f },  /* Greek_OMICRON */
  { 0x07d0, 0x03a0 },  /* Greek_PI */
  { 0x07d1, 0x03a1 },  /* Greek_RHO */
  { 0x07d2, 0x03a3 },  /* Greek_SIGMA */
  { 0x07d4, 0x03a4 },  /* Greek_TAU */
  { 0x07d5, 0x03a5 },  /* Greek_UPSILON */
  { 0x07d6, 0x03a6 },  /* Greek_PHI */
  { 0x07d7, 0x03a7 },  /* Greek_CHI */
  { 0x07d8, 0x03a8 },  /* Greek_PSI */
  { 0x07d9, 0x03a9 },  /* Greek_OMEGA */
  { 0x07e1, 0x03b1 },  /* Greek_alpha */
  { 0x07e2, 0x03b2 },  /* Greek_beta */
  { 0x07e3, 0x03b3 },  /* Greek_gamma */
  { 0x07e4, 0x03b4 },  /* Greek_delta */
  { 0x07e5, 0x03b5 },  /* Greek_epsilon */
  { 0x07e6, 0x03b6 },  /* Greek_zeta */
  { 0x07e7, 0x03b7 },  /* Greek_eta */
  { 0x07e8, 0x03b8 },  /* Greek_theta */
  { 0x07e9, 0x03b9 },  /* Greek_iota */
  { 0x07ea, 0x03ba },  /* Greek_kappa */
  { 0x07eb, 0x03bb },  /* Greek_lambda */
  { 0x07ec, 0x03bc },  /* Greek_mu */
  { 0x07ed, 0x03bd },  /* Greek_nu */
  { 0x07ee, 0x03be },  /* Greek_xi */
  { 0x07ef, 0x03bf },  /* Greek_omicron */
  { 0x07f0, 0x03c0 },  /* Greek_pi */
  { 0x07f1, 0x03c1 },  /* Greek_rho */
  { 0x07f2, 0x03c3 },  /* Greek_sigma */
  { 0x07f3, 0x03c2 },  /* Greek_finalsmallsigma */
  { 0x07f4, 0x03c4 },  /* Greek_tau */
  { 0x07f5, 0x03c5 },  /* Greek_upsilon */
  { 0x07f6, 0x03c6 },  /* Greek_phi */
  { 0x07f7, 0x03c7 },  /* Greek_chi */
  { 0x07f8, 0x03c8 },  /* Greek_psi */
  { 0x07f9, 0x03c9 },  /* Greek_omega */
  { 0x08a4, 0x2320 },  /* topintegral */
  { 0x08a5, 0x2321 },  /* botintegral */
  { 0x08a6, 0x2502 },  /* vertconnector */
  { 0x08bc, 0x2264 },  /* lessthanequal */
  { 0x08bd, 0x2260 },  /* notequal */
  { 0x08be, 0x2265 },  /* greaterthanequal */
  { 0x08bf, 0x222b },  /* integral */
  { 0x08c0, 0x2234 },  /* therefore */
  { 0x08c1, 0x221d },  /* variation */
  { 0x08c2, 0x221e },  /* infinity */
  { 0x08c5, 0x2207 },  /* nabla */
  { 0x08c8, 0x2245 },  /* approximate */
  { 0x08cd, 0x21d4 },  /* ifonlyif */
  { 0x08ce, 0x21d2 },  /* implies */
  { 0x08cf, 0x2261 },  /* identical */
  { 0x08d6, 0x221a },  /* radical */
  { 0x08da, 0x2282 },  /* includedin */
  { 0x08db, 0x2283 },  /* includes */
  { 0x08dc, 0x2229 },  /* intersection */
  { 0x08dd, 0x222a },  /* union */
  { 0x08de, 0x2227 },  /* logicaland */
  { 0x08df, 0x2228 },  /* logicalor */
  { 0x08ef, 0x2202 },  /* partialderivative */
  { 0x08f6, 0x0192 },  /* function */
  { 0x08fb, 0x2190 },  /* leftarrow */
  { 0x08fc, 0x2191 },  /* uparrow */
  { 0x08fd, 0x2192 },  /* rightarrow */
  { 0x08fe, 0x2193 },  /* downarrow */
  { 0x09df, 0x2422 },  /* blank */
  { 0x09e0, 0x25c6 },  /* soliddiamond */
  { 0x09e1, 0x2592 },  /* checkerboard */
  { 0x09e2, 0x2409 },  /* ht */
  { 0x09e3, 0x240c },  /* ff */
  { 0x09e4, 0x240d },  /* cr */
  { 0x09e5, 0x240a },  /* lf */
  { 0x09e8, 0x2424 },  /* nl */
  { 0x09e9, 0x240b },  /* vt */
  { 0x09ea, 0x2518 },  /* lowrightcorner */
  { 0x09eb, 0x2510 },  /* uprightcorner */
  { 0x09ec, 0x250c },  /* upleftcorner */
  { 0x09ed, 0x2514 },  /* lowleftcorner */
  { 0x09ee, 0x253c },  /* crossinglines */
  { 0x09f1, 0x2500 },  /* horizlinescan5 */
  { 0x09f4, 0x251c },  /* leftt */
  { 0x09f5, 0x2524 },  /* rightt */
  { 0x09f6, 0x2534 },  /* bott */
  { 0x09f7, 0x252c },  /* topt */
  { 0x09f8, 0x2502 },  /* vertbar */
  { 0x0aa1, 0x2003 },  /* emspace */
  { 0x0aa2, 0x2002 },  /* enspace */
  { 0x0aa3, 0x2004 },  /* em3space */
  { 0x0aa4, 0x2005 },  /* em4space */
  { 0x0aa5, 0x2007 },  /* digitspace */
  { 0x0aa6, 0x2008 },  /* punctspace */
  { 0x0aa7, 0x2009 },  /* thinspace */
  { 0x0aa8, 0x200a },  /* hairspace */
  { 0x0aa9, 0x2014 },  /* emdash */
  { 0x0aaa, 0x2013 },  /* endash */
  { 0x0aae, 0x2026 },  /* ellipsis */
  { 0x0ab0, 0x2153 },  /* onethird */
  { 0x0ab1, 0x2154 },  /* twothirds */
  { 0x0ab2, 0x2155 },  /* onefifth */
  { 0x0ab3, 0x2156 },  /* twofifths */
  { 0x0ab4, 0x2157 },  /* threefifths */
  { 0x0ab5, 0x2158 },  /* fourfifths */
  { 0x0ab6, 0x2159 },  /* onesixth */
  { 0x0ab7, 0x215a },  /* fivesixths */
  { 0x0ab8, 0x2105 },  /* careof */
  { 0x0abb, 0x2012 },  /* figdash */
  { 0x0abc, 0x2329 },  /* leftanglebracket */
  { 0x0abd, 0x002e },  /* decimalpoint */
  { 0x0abe, 0x232a },  /* rightanglebracket */
  { 0x0ac3, 0x215b },  /* oneeighth */
  { 0x0ac4, 0x215c },  /* threeeighths */
  { 0x0ac5, 0x215d },  /* fiveeighths */
  { 0x0ac6, 0x215e },  /* seveneighths */
  { 0x0ac9, 0x2122 },  /* trademark */
  { 0x0aca, 0x2613 },  /* signaturemark */
  { 0x0acc, 0x25c1 },  /* leftopentriangle */
  { 0x0acd, 0x25b7 },  /* rightopentriangle */
  { 0x0ace, 0x25cb },  /* emopencircle */
  { 0x0acf, 0x25a1 },  /* emopenrectangle */
  { 0x0ad0, 0x2018 },  /* leftsinglequotemark */
  { 0x0ad1, 0x2019 },  /* rightsinglequotemark */
  { 0x0ad2, 0x201c },  /* leftdoublequotemark */
  { 0x0ad3, 0x201d },  /* rightdoublequotemark */
  { 0x0ad4, 0x211e },  /* prescription */
  { 0x0ad6, 0x2032 },  /* minutes */
  { 0x0ad7, 0x2033 },  /* seconds */
  { 0x0ad9, 0x271d },  /* latincross */
  { 0x0adb, 0x25ac },  /* filledrectbullet */
  { 0x0adc, 0x25c0 },  /* filledlefttribullet */
  { 0x0add, 0x25b6 },  /* filledrighttribullet */
  { 0x0ade, 0x25cf },  /* emfilledcircle */
  { 0x0adf, 0x25a0 },  /* emfilledrect */
  { 0x0ae0, 0x25e6 },  /* enopencircbullet */
  { 0x0ae1, 0x25ab },  /* enopensquarebullet */
  { 0x0ae2, 0x25ad },  /* openrectbullet */
  { 0x0ae3, 0x25b3 },  /* opentribulletup */
  { 0x0ae4, 0x25bd },  /* opentribulletdown */
  { 0x0ae5, 0x2606 },  /* openstar */
  { 0x0ae6, 0x2022 },  /* enfilledcircbullet */
  { 0x0ae7, 0x25aa },  /* enfilledsqbullet */
  { 0x0ae8, 0x25b2 },  /* filledtribulletup */
  { 0x0ae9, 0x25bc },  /* filledtribulletdown */
  { 0x0aea, 0x261c },  /* leftpointer */
  { 0x0aeb, 0x261e },  /* rightpointer */
  { 0x0aec, 0x2663 },  /* club */
  { 0x0aed, 0x2666 },  /* diamond */
  { 0x0aee, 0x2665 },  /* heart */
  { 0x0af0, 0x2720 },  /* maltesecross */
  { 0x0af1, 0x2020 },  /* dagger */
  { 0x0af2, 0x2021 },  /* doubledagger */
  { 0x0af3, 0x2713 },  /* checkmark */
  { 0x0af4, 0x2717 },  /* ballotcross */
  { 0x0af5, 0x266f },  /* musicalsharp */
  { 0x0af6, 0x266d },  /* musicalflat */
  { 0x0af7, 0x2642 },  /* malesymbol */
  { 0x0af8, 0x2640 },  /* femalesymbol */
  { 0x0af9, 0x260e },  /* telephone */
  { 0x0afa, 0x2315 },  /* telephonerecorder */
  { 0x0afb, 0x2117 },  /* phonographcopyright */
  { 0x0afc, 0x2038 },  /* caret */
  { 0x0afd, 0x201a },  /* singlelowquotemark */
  { 0x0afe, 0x201e },  /* doublelowquotemark */
  { 0x0ba3, 0x003c },  /* leftcaret */
  { 0x0ba6, 0x003e },  /* rightcaret */
  { 0x0ba8, 0x2228 },  /* downcaret */
  { 0x0ba9, 0x2227 },  /* upcaret */
  { 0x0bc0, 0x00af },  /* overbar */
  { 0x0bc2, 0x22a4 },  /* downtack */
  { 0x0bc3, 0x2229 },  /* upshoe */
  { 0x0bc4, 0x230a },  /* downstile */
  { 0x0bc6, 0x005f },  /* underbar */
  { 0x0bca, 0x2218 },  /* jot */
  { 0x0bcc, 0x2395 },  /* quad */
  { 0x0bce, 0x22a5 },  /* uptack */
  { 0x0bcf, 0x25cb },  /* circle */
  { 0x0bd3, 0x2308 },  /* upstile */
  { 0x0bd6, 0x222a },  /* downshoe */
  { 0x0bd8, 0x2283 },  /* rightshoe */
  { 0x0bda, 0x2282 },  /* leftshoe */
  { 0x0bdc, 0x22a3 },  /* lefttack */
  { 0x0bfc, 0x22a2 },  /* righttack */
  { 0x0cdf, 0x2017 },  /* hebrew_doublelowline */
  { 0x0ce0, 0x05d0 },  /* hebrew_aleph */
  { 0x0ce1, 0x05d1 },  /* hebrew_bet */
  { 0x0ce2, 0x05d2 },  /* hebrew_gimel */
  { 0x0ce3, 0x05d3 },  /* hebrew_dalet */
  { 0x0ce4, 0x05d4 },  /* hebrew_he */
  { 0x0ce5, 0x05d5 },  /* hebrew_waw */
  { 0x0ce6, 0x05d6 },  /* hebrew_zain */
  { 0x0ce7, 0x05d7 },  /* hebrew_chet */
  { 0x0ce8, 0x05d8 },  /* hebrew_tet */
  { 0x0ce9, 0x05d9 },  /* hebrew_yod */
  { 0x0cea, 0x05da },  /* hebrew_finalkaph */
  { 0x0ceb, 0x05db },  /* hebrew_kaph */
  { 0x0cec, 0x05dc },  /* hebrew_lamed */
  { 0x0ced, 0x05dd },  /* hebrew_finalmem */
  { 0x0cee, 0x05de },  /* hebrew_mem */
  { 0x0cef, 0x05df },  /* hebrew_finalnun */
  { 0x0cf0, 0x05e0 },  /* hebrew_nun */
  { 0x0cf1, 0x05e1 },  /* hebrew_samech */
  { 0x0cf2, 0x05e2 },  /* hebrew_ayin */
  { 0x0cf3, 0x05e3 },  /* hebrew_finalpe */
  { 0x0cf4, 0x05e4 },  /* hebrew_pe */
  { 0x0cf5, 0x05e5 },  /* hebrew_finalzade */
  { 0x0cf6, 0x05e6 },  /* hebrew_zade */
  { 0x0cf7, 0x05e7 },  /* hebrew_qoph */
  { 0x0cf8, 0x05e8 },  /* hebrew_resh */
  { 0x0cf9, 0x05e9 },  /* hebrew_shin */
  { 0x0cfa, 0x05ea },  /* hebrew_taw */
  { 0x0da1, 0x0e01 },  /* Thai_kokai */
  { 0x0da2, 0x0e02 },  /* Thai_khokhai */
  { 0x0da3, 0x0e03 },  /* Thai_khokhuat */
  { 0x0da4, 0x0e04 },  /* Thai_khokhwai */
  { 0x0da5, 0x0e05 },  /* Thai_khokhon */
  { 0x0da6, 0x0e06 },  /* Thai_khorakhang */
  { 0x0da7, 0x0e07 },  /* Thai_ngongu */
  { 0x0da8, 0x0e08 },  /* Thai_chochan */
  { 0x0da9, 0x0e09 },  /* Thai_choching */
  { 0x0daa, 0x0e0a },  /* Thai_chochang */
  { 0x0dab, 0x0e0b },  /* Thai_soso */
  { 0x0dac, 0x0e0c },  /* Thai_chochoe */
  { 0x0dad, 0x0e0d },  /* Thai_yoying */
  { 0x0dae, 0x0e0e },  /* Thai_dochada */
  { 0x0daf, 0x0e0f },  /* Thai_topatak */
  { 0x0db0, 0x0e10 },  /* Thai_thothan */
  { 0x0db1, 0x0e11 },  /* Thai_thonangmontho */
  { 0x0db2, 0x0e12 },  /* Thai_thophuthao */
  { 0x0db3, 0x0e13 },  /* Thai_nonen */
  { 0x0db4, 0x0e14 },  /* Thai_dodek */
  { 0x0db5, 0x0e15 },  /* Thai_totao */
  { 0x0db6, 0x0e16 },  /* Thai_thothung */
  { 0x0db7, 0x0e17 },  /* Thai_thothahan */
  { 0x0db8, 0x0e18 },  /* Thai_thothong */
  { 0x0db9, 0x0e19 },  /* Thai_nonu */
  { 0x0dba, 0x0e1a },  /* Thai_bobaimai */
  { 0x0dbb, 0x0e1b },  /* Thai_popla */
  { 0x0dbc, 0x0e1c },  /* Thai_phophung */
  { 0x0dbd, 0x0e1d },  /* Thai_fofa */
  { 0x0dbe, 0x0e1e },  /* Thai_phophan */
  { 0x0dbf, 0x0e1f },  /* Thai_fofan */
  { 0x0dc0, 0x0e20 },  /* Thai_phosamphao */
  { 0x0dc1, 0x0e21 },  /* Thai_moma */
  { 0x0dc2, 0x0e22 },  /* Thai_yoyak */
  { 0x0dc3, 0x0e23 },  /* Thai_rorua */
  { 0x0dc4, 0x0e24 },  /* Thai_ru */
  { 0x0dc5, 0x0e25 },  /* Thai_loling */
  { 0x0dc6, 0x0e26 },  /* Thai_lu */
  { 0x0dc7, 0x0e27 },  /* Thai_wowaen */
  { 0x0dc8, 0x0e28 },  /* Thai_sosala */
  { 0x0dc9, 0x0e29 },  /* Thai_sorusi */
  { 0x0dca, 0x0e2a },  /* Thai_sosua */
  { 0x0dcb, 0x0e2b },  /* Thai_hohip */
  { 0x0dcc, 0x0e2c },  /* Thai_lochula */
  { 0x0dcd, 0x0e2d },  /* Thai_oang */
  { 0x0dce, 0x0e2e },  /* Thai_honokhuk */
  { 0x0dcf, 0x0e2f },  /* Thai_paiyannoi */
  { 0x0dd0, 0x0e30 },  /* Thai_saraa */
  { 0x0dd1, 0x0e31 },  /* Thai_maihanakat */
  { 0x0dd2, 0x0e32 },  /* Thai_saraaa */
  { 0x0dd3, 0x0e33 },  /* Thai_saraam */
  { 0x0dd4, 0x0e34 },  /* Thai_sarai */
  { 0x0dd5, 0x0e35 },  /* Thai_saraii */
  { 0x0dd6, 0x0e36 },  /* Thai_saraue */
  { 0x0dd7, 0x0e37 },  /* Thai_sarauee */
  { 0x0dd8, 0x0e38 },  /* Thai_sarau */
  { 0x0dd9, 0x0e39 },  /* Thai_sarauu */
  { 0x0dda, 0x0e3a },  /* Thai_phinthu */
  { 0x0dde, 0x0e3e },  /* Thai_maihanakat_maitho */
  { 0x0ddf, 0x0e3f },  /* Thai_baht */
  { 0x0de0, 0x0e40 },  /* Thai_sarae */
  { 0x0de1, 0x0e41 },  /* Thai_saraae */
  { 0x0de2, 0x0e42 },  /* Thai_sarao */
  { 0x0de3, 0x0e43 },  /* Thai_saraaimaimuan */
  { 0x0de4, 0x0e44 },  /* Thai_saraaimaimalai */
  { 0x0de5, 0x0e45 },  /* Thai_lakkhangyao */
  { 0x0de6, 0x0e46 },  /* Thai_maiyamok */
  { 0x0de7, 0x0e47 },  /* Thai_maitaikhu */
  { 0x0de8, 0x0e48 },  /* Thai_maiek */
  { 0x0de9, 0x0e49 },  /* Thai_maitho */
  { 0x0dea, 0x0e4a },  /* Thai_maitri */
  { 0x0deb, 0x0e4b },  /* Thai_maichattawa */
  { 0x0dec, 0x0e4c },  /* Thai_thanthakhat */
  { 0x0ded, 0x0e4d },  /* Thai_nikhahit */
  { 0x0df0, 0x0e50 },  /* Thai_leksun */
  { 0x0df1, 0x0e51 },  /* Thai_leknung */
  { 0x0df2, 0x0e52 },  /* Thai_leksong */
  { 0x0df3, 0x0e53 },  /* Thai_leksam */
  { 0x0df4, 0x0e54 },  /* Thai_leksi */
  { 0x0df5, 0x0e55 },  /* Thai_lekha */
  { 0x0df6, 0x0e56 },  /* Thai_lekhok */
  { 0x0df7, 0x0e57 },  /* Thai_lekchet */
  { 0x0df8, 0x0e58 },  /* Thai_lekpaet */
  { 0x0df9, 0x0e59 },  /* Thai_lekkao */
  { 0x0ea1, 0x3131 },  /* Hangul_Kiyeog */
  { 0x0ea2, 0x3132 },  /* Hangul_SsangKiyeog */
  { 0x0ea3, 0x3133 },  /* Hangul_KiyeogSios */
  { 0x0ea4, 0x3134 },  /* Hangul_Nieun */
  { 0x0ea5, 0x3135 },  /* Hangul_NieunJieuj */
  { 0x0ea6, 0x3136 },  /* Hangul_NieunHieuh */
  { 0x0ea7, 0x3137 },  /* Hangul_Dikeud */
  { 0x0ea8, 0x3138 },  /* Hangul_SsangDikeud */
  { 0x0ea9, 0x3139 },  /* Hangul_Rieul */
  { 0x0eaa, 0x313a },  /* Hangul_RieulKiyeog */
  { 0x0eab, 0x313b },  /* Hangul_RieulMieum */
  { 0x0eac, 0x313c },  /* Hangul_RieulPieub */
  { 0x0ead, 0x313d },  /* Hangul_RieulSios */
  { 0x0eae, 0x313e },  /* Hangul_RieulTieut */
  { 0x0eaf, 0x313f },  /* Hangul_RieulPhieuf */
  { 0x0eb0, 0x3140 },  /* Hangul_RieulHieuh */
  { 0x0eb1, 0x3141 },  /* Hangul_Mieum */
  { 0x0eb2, 0x3142 },  /* Hangul_Pieub */
  { 0x0eb3, 0x3143 },  /* Hangul_SsangPieub */
  { 0x0eb4, 0x3144 },  /* Hangul_PieubSios */
  { 0x0eb5, 0x3145 },  /* Hangul_Sios */
  { 0x0eb6, 0x3146 },  /* Hangul_SsangSios */
  { 0x0eb7, 0x3147 },  /* Hangul_Ieung */
  { 0x0eb8, 0x3148 },  /* Hangul_Jieuj */
  { 0x0eb9, 0x3149 },  /* Hangul_SsangJieuj */
  { 0x0eba, 0x314a },  /* Hangul_Cieuc */
  { 0x0ebb, 0x314b },  /* Hangul_Khieuq */
  { 0x0ebc, 0x314c },  /* Hangul_Tieut */
  { 0x0ebd, 0x314d },  /* Hangul_Phieuf */
  { 0x0ebe, 0x314e },  /* Hangul_Hieuh */
  { 0x0ebf, 0x314f },  /* Hangul_A */
  { 0x0ec0, 0x3150 },  /* Hangul_AE */
  { 0x0ec1, 0x3151 },  /* Hangul_YA */
  { 0x0ec2, 0x3152 },  /* Hangul_YAE */
  { 0x0ec3, 0x3153 },  /* Hangul_EO */
  { 0x0ec4, 0x3154 },  /* Hangul_E */
  { 0x0ec5, 0x3155 },  /* Hangul_YEO */
  { 0x0ec6, 0x3156 },  /* Hangul_YE */
  { 0x0ec7, 0x3157 },  /* Hangul_O */
  { 0x0ec8, 0x3158 },  /* Hangul_WA */
  { 0x0ec9, 0x3159 },  /* Hangul_WAE */
  { 0x0eca, 0x315a },  /* Hangul_OE */
  { 0x0ecb, 0x315b },  /* Hangul_YO */
  { 0x0ecc, 0x315c },  /* Hangul_U */
  { 0x0ecd, 0x315d },  /* Hangul_WEO */
  { 0x0ece, 0x315e },  /* Hangul_WE */
  { 0x0ecf, 0x315f },  /* Hangul_WI */
  { 0x0ed0, 0x3160 },  /* Hangul_YU */
  { 0x0ed1, 0x3161 },  /* Hangul_EU */
  { 0x0ed2, 0x3162 },  /* Hangul_YI */
  { 0x0ed3, 0x3163 },  /* Hangul_I */
  { 0x0ed4, 0x11a8 },  /* Hangul_J_Kiyeog */
  { 0x0ed5, 0x11a9 },  /* Hangul_J_SsangKiyeog */
  { 0x0ed6, 0x11aa },  /* Hangul_J_KiyeogSios */
  { 0x0ed7, 0x11ab },  /* Hangul_J_Nieun */
  { 0x0ed8, 0x11ac },  /* Hangul_J_NieunJieuj */
  { 0x0ed9, 0x11ad },  /* Hangul_J_NieunHieuh */
  { 0x0eda, 0x11ae },  /* Hangul_J_Dikeud */
  { 0x0edb, 0x11af },  /* Hangul_J_Rieul */
  { 0x0edc, 0x11b0 },  /* Hangul_J_RieulKiyeog */
  { 0x0edd, 0x11b1 },  /* Hangul_J_RieulMieum */
  { 0x0ede, 0x11b2 },  /* Hangul_J_RieulPieub */
  { 0x0edf, 0x11b3 },  /* Hangul_J_RieulSios */
  { 0x0ee0, 0x11b4 },  /* Hangul_J_RieulTieut */
  { 0x0ee1, 0x11b5 },  /* Hangul_J_RieulPhieuf */
  { 0x0ee2, 0x11b6 },  /* Hangul_J_RieulHieuh */
  { 0x0ee3, 0x11b7 },  /* Hangul_J_Mieum */
  { 0x0ee4, 0x11b8 },  /* Hangul_J_Pieub */
  { 0x0ee5, 0x11b9 },  /* Hangul_J_PieubSios */
  { 0x0ee6, 0x11ba },  /* Hangul_J_Sios */
  { 0x0ee7, 0x11bb },  /* Hangul_J_SsangSios */
  { 0x0ee8, 0x11bc },  /* Hangul_J_Ieung */
  { 0x0ee9, 0x11bd },  /* Hangul_J_Jieuj */
  { 0x0eea, 0x11be },  /* Hangul_J_Cieuc */
  { 0x0eeb, 0x11bf },  /* Hangul_J_Khieuq */
  { 0x0eec, 0x11c0 },  /* Hangul_J_Tieut */
  { 0x0eed, 0x11c1 },  /* Hangul_J_Phieuf */
  { 0x0eee, 0x11c2 },  /* Hangul_J_Hieuh */
  { 0x0eef, 0x316d },  /* Hangul_RieulYeorinHieuh */
  { 0x0ef0, 0x3171 },  /* Hangul_SunkyeongeumMieum */
  { 0x0ef1, 0x3178 },  /* Hangul_SunkyeongeumPieub */
  { 0x0ef2, 0x317f },  /* Hangul_PanSios */
  { 0x0ef4, 0x3184 },  /* Hangul_SunkyeongeumPhieuf */
  { 0x0ef5, 0x3186 },  /* Hangul_YeorinHieuh */
  { 0x0ef6, 0x318d },  /* Hangul_AraeA */
  { 0x0ef7, 0x318e },  /* Hangul_AraeAE */
  { 0x0ef8, 0x11eb },  /* Hangul_J_PanSios */
  { 0x0efa, 0x11f9 },  /* Hangul_J_YeorinHieuh */
  { 0x0eff, 0x20a9 },  /* Korean_Won */
  { 0x13bc, 0x0152 },  /* OE */
  { 0x13bd, 0x0153 },  /* oe */
  { 0x13be, 0x0178 },  /* Ydiaeresis */
  { 0x20a0, 0x20a0 },  /* EcuSign */
  { 0x20a1, 0x20a1 },  /* ColonSign */
  { 0x20a2, 0x20a2 },  /* CruzeiroSign */
  { 0x20a3, 0x20a3 },  /* FFrancSign */
  { 0x20a4, 0x20a4 },  /* LiraSign */
  { 0x20a5, 0x20a5 },  /* MillSign */
  { 0x20a6, 0x20a6 },  /* NairaSign */
  { 0x20a7, 0x20a7 },  /* PesetaSign */
  { 0x20a8, 0x20a8 },  /* RupeeSign */
  { 0x20a9, 0x20a9 },  /* WonSign */
  { 0x20aa, 0x20aa },  /* NewSheqelSign */
  { 0x20ab, 0x20ab },  /* DongSign */
  { 0x20ac, 0x20ac },  /* EuroSign */
};  



/* extract the definitions below from java header files */
#undef java_awt_event_KeyEvent_COMPONENT_EVENT_MASK
#define java_awt_event_KeyEvent_COMPONENT_EVENT_MASK 1LL
#undef java_awt_event_KeyEvent_CONTAINER_EVENT_MASK
#define java_awt_event_KeyEvent_CONTAINER_EVENT_MASK 2LL
#undef java_awt_event_KeyEvent_FOCUS_EVENT_MASK
#define java_awt_event_KeyEvent_FOCUS_EVENT_MASK 4LL
#undef java_awt_event_KeyEvent_KEY_EVENT_MASK
#define java_awt_event_KeyEvent_KEY_EVENT_MASK 8LL
#undef java_awt_event_KeyEvent_MOUSE_EVENT_MASK
#define java_awt_event_KeyEvent_MOUSE_EVENT_MASK 16LL
#undef java_awt_event_KeyEvent_MOUSE_MOTION_EVENT_MASK
#define java_awt_event_KeyEvent_MOUSE_MOTION_EVENT_MASK 32LL
#undef java_awt_event_KeyEvent_WINDOW_EVENT_MASK
#define java_awt_event_KeyEvent_WINDOW_EVENT_MASK 64LL
#undef java_awt_event_KeyEvent_ACTION_EVENT_MASK
#define java_awt_event_KeyEvent_ACTION_EVENT_MASK 128LL
#undef java_awt_event_KeyEvent_ADJUSTMENT_EVENT_MASK
#define java_awt_event_KeyEvent_ADJUSTMENT_EVENT_MASK 256LL
#undef java_awt_event_KeyEvent_ITEM_EVENT_MASK
#define java_awt_event_KeyEvent_ITEM_EVENT_MASK 512LL
#undef java_awt_event_KeyEvent_TEXT_EVENT_MASK
#define java_awt_event_KeyEvent_TEXT_EVENT_MASK 1024LL
#undef java_awt_event_KeyEvent_RESERVED_ID_MAX
#define java_awt_event_KeyEvent_RESERVED_ID_MAX 1999L
#undef java_awt_event_KeyEvent_serialVersionUID
#define java_awt_event_KeyEvent_serialVersionUID -1825314779160409405LL
#undef java_awt_event_KeyEvent_COMPONENT_FIRST
#define java_awt_event_KeyEvent_COMPONENT_FIRST 100L
#undef java_awt_event_KeyEvent_COMPONENT_LAST
#define java_awt_event_KeyEvent_COMPONENT_LAST 103L
#undef java_awt_event_KeyEvent_COMPONENT_MOVED
#define java_awt_event_KeyEvent_COMPONENT_MOVED 100L
#undef java_awt_event_KeyEvent_COMPONENT_RESIZED
#define java_awt_event_KeyEvent_COMPONENT_RESIZED 101L
#undef java_awt_event_KeyEvent_COMPONENT_SHOWN
#define java_awt_event_KeyEvent_COMPONENT_SHOWN 102L
#undef java_awt_event_KeyEvent_COMPONENT_HIDDEN
#define java_awt_event_KeyEvent_COMPONENT_HIDDEN 103L
#undef java_awt_event_KeyEvent_serialVersionUID
#define java_awt_event_KeyEvent_serialVersionUID 8101406823902992965LL
#undef java_awt_event_KeyEvent_SHIFT_MASK
#define java_awt_event_KeyEvent_SHIFT_MASK 1L
#undef java_awt_event_KeyEvent_CTRL_MASK
#define java_awt_event_KeyEvent_CTRL_MASK 2L
#undef java_awt_event_KeyEvent_META_MASK
#define java_awt_event_KeyEvent_META_MASK 4L
#undef java_awt_event_KeyEvent_ALT_MASK
#define java_awt_event_KeyEvent_ALT_MASK 8L
#undef java_awt_event_KeyEvent_BUTTON1_MASK
#define java_awt_event_KeyEvent_BUTTON1_MASK 16L
#undef java_awt_event_KeyEvent_BUTTON2_MASK
#define java_awt_event_KeyEvent_BUTTON2_MASK 8L
#undef java_awt_event_KeyEvent_BUTTON3_MASK
#define java_awt_event_KeyEvent_BUTTON3_MASK 4L
#undef java_awt_event_KeyEvent_KEY_FIRST
#define java_awt_event_KeyEvent_KEY_FIRST 400L
#undef java_awt_event_KeyEvent_KEY_LAST
#define java_awt_event_KeyEvent_KEY_LAST 402L
#undef java_awt_event_KeyEvent_KEY_TYPED
#define java_awt_event_KeyEvent_KEY_TYPED 400L
#undef java_awt_event_KeyEvent_KEY_PRESSED
#define java_awt_event_KeyEvent_KEY_PRESSED 401L
#undef java_awt_event_KeyEvent_KEY_RELEASED
#define java_awt_event_KeyEvent_KEY_RELEASED 402L
#undef java_awt_event_KeyEvent_VK_ENTER
#define java_awt_event_KeyEvent_VK_ENTER 10L
#undef java_awt_event_KeyEvent_VK_BACK_SPACE
#define java_awt_event_KeyEvent_VK_BACK_SPACE 8L
#undef java_awt_event_KeyEvent_VK_TAB
#define java_awt_event_KeyEvent_VK_TAB 9L
#undef java_awt_event_KeyEvent_VK_CANCEL
#define java_awt_event_KeyEvent_VK_CANCEL 3L
#undef java_awt_event_KeyEvent_VK_CLEAR
#define java_awt_event_KeyEvent_VK_CLEAR 12L
#undef java_awt_event_KeyEvent_VK_SHIFT
#define java_awt_event_KeyEvent_VK_SHIFT 16L
#undef java_awt_event_KeyEvent_VK_CONTROL
#define java_awt_event_KeyEvent_VK_CONTROL 17L
#undef java_awt_event_KeyEvent_VK_ALT
#define java_awt_event_KeyEvent_VK_ALT 18L
#undef java_awt_event_KeyEvent_VK_PAUSE
#define java_awt_event_KeyEvent_VK_PAUSE 19L
#undef java_awt_event_KeyEvent_VK_CAPS_LOCK
#define java_awt_event_KeyEvent_VK_CAPS_LOCK 20L
#undef java_awt_event_KeyEvent_VK_ESCAPE
#define java_awt_event_KeyEvent_VK_ESCAPE 27L
#undef java_awt_event_KeyEvent_VK_SPACE
#define java_awt_event_KeyEvent_VK_SPACE 32L
#undef java_awt_event_KeyEvent_VK_PAGE_UP
#define java_awt_event_KeyEvent_VK_PAGE_UP 33L
#undef java_awt_event_KeyEvent_VK_PAGE_DOWN
#define java_awt_event_KeyEvent_VK_PAGE_DOWN 34L
#undef java_awt_event_KeyEvent_VK_END
#define java_awt_event_KeyEvent_VK_END 35L
#undef java_awt_event_KeyEvent_VK_HOME
#define java_awt_event_KeyEvent_VK_HOME 36L
#undef java_awt_event_KeyEvent_VK_LEFT
#define java_awt_event_KeyEvent_VK_LEFT 37L
#undef java_awt_event_KeyEvent_VK_UP
#define java_awt_event_KeyEvent_VK_UP 38L
#undef java_awt_event_KeyEvent_VK_RIGHT
#define java_awt_event_KeyEvent_VK_RIGHT 39L
#undef java_awt_event_KeyEvent_VK_DOWN
#define java_awt_event_KeyEvent_VK_DOWN 40L
#undef java_awt_event_KeyEvent_VK_COMMA
#define java_awt_event_KeyEvent_VK_COMMA 44L
#undef java_awt_event_KeyEvent_VK_PERIOD
#define java_awt_event_KeyEvent_VK_PERIOD 46L
#undef java_awt_event_KeyEvent_VK_MINUS
#define java_awt_event_KeyEvent_VK_MINUS 0x2D
#undef java_awt_event_KeyEvent_VK_SLASH
#define java_awt_event_KeyEvent_VK_SLASH 47L
#undef java_awt_event_KeyEvent_VK_0
#define java_awt_event_KeyEvent_VK_0 48L
#undef java_awt_event_KeyEvent_VK_1
#define java_awt_event_KeyEvent_VK_1 49L
#undef java_awt_event_KeyEvent_VK_2
#define java_awt_event_KeyEvent_VK_2 50L
#undef java_awt_event_KeyEvent_VK_3
#define java_awt_event_KeyEvent_VK_3 51L
#undef java_awt_event_KeyEvent_VK_4
#define java_awt_event_KeyEvent_VK_4 52L
#undef java_awt_event_KeyEvent_VK_5
#define java_awt_event_KeyEvent_VK_5 53L
#undef java_awt_event_KeyEvent_VK_6
#define java_awt_event_KeyEvent_VK_6 54L
#undef java_awt_event_KeyEvent_VK_7
#define java_awt_event_KeyEvent_VK_7 55L
#undef java_awt_event_KeyEvent_VK_8
#define java_awt_event_KeyEvent_VK_8 56L
#undef java_awt_event_KeyEvent_VK_9
#define java_awt_event_KeyEvent_VK_9 57L
#undef java_awt_event_KeyEvent_VK_SEMICOLON
#define java_awt_event_KeyEvent_VK_SEMICOLON 59L
#undef java_awt_event_KeyEvent_VK_EQUALS
#define java_awt_event_KeyEvent_VK_EQUALS 61L
#undef java_awt_event_KeyEvent_VK_A
#define java_awt_event_KeyEvent_VK_A 65L
#undef java_awt_event_KeyEvent_VK_B
#define java_awt_event_KeyEvent_VK_B 66L
#undef java_awt_event_KeyEvent_VK_C
#define java_awt_event_KeyEvent_VK_C 67L
#undef java_awt_event_KeyEvent_VK_D
#define java_awt_event_KeyEvent_VK_D 68L
#undef java_awt_event_KeyEvent_VK_E
#define java_awt_event_KeyEvent_VK_E 69L
#undef java_awt_event_KeyEvent_VK_F
#define java_awt_event_KeyEvent_VK_F 70L
#undef java_awt_event_KeyEvent_VK_G
#define java_awt_event_KeyEvent_VK_G 71L
#undef java_awt_event_KeyEvent_VK_H
#define java_awt_event_KeyEvent_VK_H 72L
#undef java_awt_event_KeyEvent_VK_I
#define java_awt_event_KeyEvent_VK_I 73L
#undef java_awt_event_KeyEvent_VK_J
#define java_awt_event_KeyEvent_VK_J 74L
#undef java_awt_event_KeyEvent_VK_K
#define java_awt_event_KeyEvent_VK_K 75L
#undef java_awt_event_KeyEvent_VK_L
#define java_awt_event_KeyEvent_VK_L 76L
#undef java_awt_event_KeyEvent_VK_M
#define java_awt_event_KeyEvent_VK_M 77L
#undef java_awt_event_KeyEvent_VK_N
#define java_awt_event_KeyEvent_VK_N 78L
#undef java_awt_event_KeyEvent_VK_O
#define java_awt_event_KeyEvent_VK_O 79L
#undef java_awt_event_KeyEvent_VK_P
#define java_awt_event_KeyEvent_VK_P 80L
#undef java_awt_event_KeyEvent_VK_Q
#define java_awt_event_KeyEvent_VK_Q 81L
#undef java_awt_event_KeyEvent_VK_R
#define java_awt_event_KeyEvent_VK_R 82L
#undef java_awt_event_KeyEvent_VK_S
#define java_awt_event_KeyEvent_VK_S 83L
#undef java_awt_event_KeyEvent_VK_T
#define java_awt_event_KeyEvent_VK_T 84L
#undef java_awt_event_KeyEvent_VK_U
#define java_awt_event_KeyEvent_VK_U 85L
#undef java_awt_event_KeyEvent_VK_V
#define java_awt_event_KeyEvent_VK_V 86L
#undef java_awt_event_KeyEvent_VK_W
#define java_awt_event_KeyEvent_VK_W 87L
#undef java_awt_event_KeyEvent_VK_X
#define java_awt_event_KeyEvent_VK_X 88L
#undef java_awt_event_KeyEvent_VK_Y
#define java_awt_event_KeyEvent_VK_Y 89L
#undef java_awt_event_KeyEvent_VK_Z
#define java_awt_event_KeyEvent_VK_Z 90L
#undef java_awt_event_KeyEvent_VK_OPEN_BRACKET
#define java_awt_event_KeyEvent_VK_OPEN_BRACKET 91L
#undef java_awt_event_KeyEvent_VK_BACK_SLASH
#define java_awt_event_KeyEvent_VK_BACK_SLASH 92L
#undef java_awt_event_KeyEvent_VK_CLOSE_BRACKET
#define java_awt_event_KeyEvent_VK_CLOSE_BRACKET 93L
#undef java_awt_event_KeyEvent_VK_NUMPAD0
#define java_awt_event_KeyEvent_VK_NUMPAD0 96L
#undef java_awt_event_KeyEvent_VK_NUMPAD1
#define java_awt_event_KeyEvent_VK_NUMPAD1 97L
#undef java_awt_event_KeyEvent_VK_NUMPAD2
#define java_awt_event_KeyEvent_VK_NUMPAD2 98L
#undef java_awt_event_KeyEvent_VK_NUMPAD3
#define java_awt_event_KeyEvent_VK_NUMPAD3 99L
#undef java_awt_event_KeyEvent_VK_NUMPAD4
#define java_awt_event_KeyEvent_VK_NUMPAD4 100L
#undef java_awt_event_KeyEvent_VK_NUMPAD5
#define java_awt_event_KeyEvent_VK_NUMPAD5 101L
#undef java_awt_event_KeyEvent_VK_NUMPAD6
#define java_awt_event_KeyEvent_VK_NUMPAD6 102L
#undef java_awt_event_KeyEvent_VK_NUMPAD7
#define java_awt_event_KeyEvent_VK_NUMPAD7 103L
#undef java_awt_event_KeyEvent_VK_NUMPAD8
#define java_awt_event_KeyEvent_VK_NUMPAD8 104L
#undef java_awt_event_KeyEvent_VK_NUMPAD9
#define java_awt_event_KeyEvent_VK_NUMPAD9 105L
#undef java_awt_event_KeyEvent_VK_MULTIPLY
#define java_awt_event_KeyEvent_VK_MULTIPLY 106L
#undef java_awt_event_KeyEvent_VK_ADD
#define java_awt_event_KeyEvent_VK_ADD 107L
#undef java_awt_event_KeyEvent_VK_SEPARATER
#define java_awt_event_KeyEvent_VK_SEPARATER 108L
#undef java_awt_event_KeyEvent_VK_SUBTRACT
#define java_awt_event_KeyEvent_VK_SUBTRACT 109L
#undef java_awt_event_KeyEvent_VK_DECIMAL
#define java_awt_event_KeyEvent_VK_DECIMAL 110L
#undef java_awt_event_KeyEvent_VK_DIVIDE
#define java_awt_event_KeyEvent_VK_DIVIDE 111L
#undef java_awt_event_KeyEvent_VK_F1
#define java_awt_event_KeyEvent_VK_F1 112L
#undef java_awt_event_KeyEvent_VK_F2
#define java_awt_event_KeyEvent_VK_F2 113L
#undef java_awt_event_KeyEvent_VK_F3
#define java_awt_event_KeyEvent_VK_F3 114L
#undef java_awt_event_KeyEvent_VK_F4
#define java_awt_event_KeyEvent_VK_F4 115L
#undef java_awt_event_KeyEvent_VK_F5
#define java_awt_event_KeyEvent_VK_F5 116L
#undef java_awt_event_KeyEvent_VK_F6
#define java_awt_event_KeyEvent_VK_F6 117L
#undef java_awt_event_KeyEvent_VK_F7
#define java_awt_event_KeyEvent_VK_F7 118L
#undef java_awt_event_KeyEvent_VK_F8
#define java_awt_event_KeyEvent_VK_F8 119L
#undef java_awt_event_KeyEvent_VK_F9
#define java_awt_event_KeyEvent_VK_F9 120L
#undef java_awt_event_KeyEvent_VK_F10
#define java_awt_event_KeyEvent_VK_F10 121L
#undef java_awt_event_KeyEvent_VK_F11
#define java_awt_event_KeyEvent_VK_F11 122L
#undef java_awt_event_KeyEvent_VK_F12
#define java_awt_event_KeyEvent_VK_F12 123L
#undef java_awt_event_KeyEvent_VK_DELETE
#define java_awt_event_KeyEvent_VK_DELETE 127L
#undef java_awt_event_KeyEvent_VK_NUM_LOCK
#define java_awt_event_KeyEvent_VK_NUM_LOCK 144L
#undef java_awt_event_KeyEvent_VK_SCROLL_LOCK
#define java_awt_event_KeyEvent_VK_SCROLL_LOCK 145L
#undef java_awt_event_KeyEvent_VK_PRINTSCREEN
#define java_awt_event_KeyEvent_VK_PRINTSCREEN 154L
#undef java_awt_event_KeyEvent_VK_INSERT
#define java_awt_event_KeyEvent_VK_INSERT 155L
#undef java_awt_event_KeyEvent_VK_HELP
#define java_awt_event_KeyEvent_VK_HELP 156L
#undef java_awt_event_KeyEvent_VK_META
#define java_awt_event_KeyEvent_VK_META 157L
#undef java_awt_event_KeyEvent_VK_BACK_QUOTE
#define java_awt_event_KeyEvent_VK_BACK_QUOTE 192L
#undef java_awt_event_KeyEvent_VK_QUOTE
#define java_awt_event_KeyEvent_VK_QUOTE 222L
#undef java_awt_event_KeyEvent_VK_FINAL
#define java_awt_event_KeyEvent_VK_FINAL 24L
#undef java_awt_event_KeyEvent_VK_CONVERT
#define java_awt_event_KeyEvent_VK_CONVERT 28L
#undef java_awt_event_KeyEvent_VK_NONCONVERT
#define java_awt_event_KeyEvent_VK_NONCONVERT 29L
#undef java_awt_event_KeyEvent_VK_ACCEPT
#define java_awt_event_KeyEvent_VK_ACCEPT 30L
#undef java_awt_event_KeyEvent_VK_MODECHANGE
#define java_awt_event_KeyEvent_VK_MODECHANGE 31L
#undef java_awt_event_KeyEvent_VK_KANA
#define java_awt_event_KeyEvent_VK_KANA 21L
#undef java_awt_event_KeyEvent_VK_KANJI
#define java_awt_event_KeyEvent_VK_KANJI 25L

/* To support Hangul keys in Sun Korean keyboard */
#undef java_awt_event_KeyEvent_VK_HANGUL
#define java_awt_event_KeyEvent_VK_HANGUL 22L
#undef java_awt_event_KeyEvent_VK_HANGUL_HANJA
#define java_awt_event_KeyEvent_VK_HANGUL_HANJA 26L

#undef java_awt_event_KeyEvent_VK_UNDEFINED
#define java_awt_event_KeyEvent_VK_UNDEFINED 0L
#undef java_awt_event_KeyEvent_CHAR_UNDEFINED
#define java_awt_event_KeyEvent_CHAR_UNDEFINED 0L

#undef java_awt_event_KeyEvent_VK_CUT
#define java_awt_event_KeyEvent_VK_CUT                      0xFFD1
#undef java_awt_event_KeyEvent_VK_COPY
#define java_awt_event_KeyEvent_VK_COPY                     0xFFCD
#undef java_awt_event_KeyEvent_VK_PASTE
#define java_awt_event_KeyEvent_VK_PASTE                    0xFFCF
#undef java_awt_event_KeyEvent_VK_UNDO
#define java_awt_event_KeyEvent_VK_UNDO                     0xFFCB
#undef java_awt_event_KeyEvent_VK_AGAIN
#define java_awt_event_KeyEvent_VK_AGAIN                    0xFFC9
#undef java_awt_event_KeyEvent_VK_FIND
#define java_awt_event_KeyEvent_VK_FIND                     0xFFD0
#undef java_awt_event_KeyEvent_VK_PROPS
#define java_awt_event_KeyEvent_VK_PROPS                    0xFFCA
#undef java_awt_event_KeyEvent_VK_STOP
#define java_awt_event_KeyEvent_VK_STOP                     0xFFC8

#undef java_awt_event_KeyEvent_VK_AT
#define java_awt_event_KeyEvent_VK_AT                       0x0200

/* support forwarding compose key */
#undef java_awt_event_KeyEvent_VK_COMPOSE 
#define java_awt_event_KeyEvent_VK_COMPOSE                  0xFF20

#undef java_awt_event_KeyEvent_VK_DEAD_GRAVE
#define java_awt_event_KeyEvent_VK_DEAD_GRAVE 128L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_ACUTE
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_ACUTE 129L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_CIRCUMFLEX
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_CIRCUMFLEX 130L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_TILDE
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_TILDE 131L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_MACRON
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_MACRON 132L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_BREVE
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_BREVE 133L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_ABOVEDOT
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_ABOVEDOT 134L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_DIAERESIS
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_DIAERESIS 135L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_ABOVERING
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_ABOVERING 136L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_DOUBLEACUTE
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_DOUBLEACUTE 137L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_CARON
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_CARON 138L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_CEDILLA
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_CEDILLA 139L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_OGONEK
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_OGONEK 140L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_IOTA
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_IOTA 141L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_VOICED_SOUND
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_VOICED_SOUND 142L
#undef java_awt_event_KeyEvent_VK_IM_VK_DEAD_SEMIVOICED_SOUND
#define java_awt_event_KeyEvent_VK_IM_VK_DEAD_SEMIVOICED_SOUND 143L


#undef java_awt_event_InputEvent_SHIFT_MASK
#define java_awt_event_InputEvent_SHIFT_MASK 1L
#undef java_awt_event_InputEvent_CTRL_MASK
#define java_awt_event_InputEvent_CTRL_MASK 2L
#undef java_awt_event_InputEvent_META_MASK
#define java_awt_event_InputEvent_META_MASK 4L
#undef java_awt_event_InputEvent_ALT_MASK
#define java_awt_event_InputEvent_ALT_MASK 8L
#undef java_awt_event_InputEvent_BUTTON1_MASK
#define java_awt_event_InputEvent_BUTTON1_MASK 16L
#undef java_awt_event_InputEvent_BUTTON2_MASK
#define java_awt_event_InputEvent_BUTTON2_MASK 8L
#undef java_awt_event_InputEvent_BUTTON3_MASK
#define java_awt_event_InputEvent_BUTTON3_MASK 4L

/* Add the missing mapping */
#undef java_awt_event_KeyEvent_VK_AT
#define java_awt_event_KeyEvent_VK_AT 512
#undef java_awt_event_KeyEvent_VK_COLON
#define java_awt_event_KeyEvent_VK_COLON 513L
#undef java_awt_event_KeyEvent_VK_CIRCUMFLEX
#define java_awt_event_KeyEvent_VK_CIRCUMFLEX 514L
#undef java_awt_event_KeyEvent_VK_DOLLAR
#define java_awt_event_KeyEvent_VK_DOLLAR 515L
#undef java_awt_event_KeyEvent_VK_ERUO
#define java_awt_event_KeyEvent_VK_EURO 516L
#undef java_awt_event_KeyEvent_VK_EXCLAMATION_MARK
#define java_awt_event_KeyEvent_VK_EXCLAMATION_MARK 517L
#undef java_awt_event_KeyEvent_VK_LEFT_PARENTHESIS
#define java_awt_event_KeyEvent_VK_LEFT_PARENTHESIS 519L
#undef java_awt_event_KeyEvent_VK_NUMBER_SIGN
#define java_awt_event_KeyEvent_VK_NUMBER_SIGN 520L
#undef java_awt_event_KeyEvent_VK_PLUS
#define java_awt_event_KeyEvent_VK_PLUS 521L
#undef java_awt_event_KeyEvent_VK_RIGHT_PARENTHESIS
#define java_awt_event_KeyEvent_VK_RIGHT_PARENTHESIS 522L
#undef java_awt_event_KeyEvent_VK_UNDERSCORE
#define java_awt_event_KeyEvent_VK_UNDERSCORE 523L
#undef java_awt_event_KeyEvent_VK_AMPERSAND
#define java_awt_event_KeyEvent_VK_AMPERSAND 150L
#undef java_awt_event_KeyEvent_VK_ASTERISK
#define java_awt_event_KeyEvent_VK_ASTERISK 151L
#undef java_awt_event_KeyEvent_VK_QUOTEDBL
#define java_awt_event_KeyEvent_VK_QUOTEDBL 152L
#undef java_awt_event_KeyEvent_VK_LESS
#define java_awt_event_KeyEvent_VK_LESS 153L
#undef java_awt_event_KeyEvent_VK_GREATER
#define java_awt_event_KeyEvent_VK_GREATER 160L
#undef java_awt_event_KeyEvent_VK_BRACELEFT
#define java_awt_event_KeyEvent_VK_BRACELEFT 161L
#undef java_awt_event_KeyEvent_VK_BRACERIGHT
#define java_awt_event_KeyEvent_VK_BRACERIGHT 162L

typedef	enum {
    FALSE = 0,
    TRUE = 1
} bool_t;

typedef unsigned short unicode;

#if kana_table
static KeymapEntry2 kana_normal_keymapTable[] = {
    { java_awt_event_KeyEvent_VK_1, XK_kana_NU, XK_1, 0xff87, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_2, XK_kana_FU, XK_2, 0xff8c, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_3, XK_kana_A, XK_3, 0xff71, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_4, XK_kana_U, XK_4, 0xff73, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_5, XK_kana_E, XK_5, 0xff74, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_6, XK_kana_O, XK_6, 0xff75, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_7, XK_kana_YA, XK_7, 0xff94, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_8, XK_kana_YU, XK_8, 0xff95, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_9, XK_kana_YO, XK_9, 0xff96, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_0, XK_kana_WA, XK_0, 0xff9c, TRUE, 0 },
    { '-',			    XK_kana_HO, XK_minus, 0xff8e, TRUE, 0 },
    { '~',			    XK_kana_HE, XK_asciicircum, 0xff8d, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_Q, XK_kana_TA, XK_q, 0xff80, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_W, XK_kana_TE, XK_w, 0xff83, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_E, XK_kana_I, XK_e, 0xff72, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_R, XK_kana_SU, XK_r, 0xff7d, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_T, XK_kana_KA, XK_t, 0xff76, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_Y, XK_kana_N, XK_y, 0xff9d, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_U, XK_kana_NA, XK_u, 0xff85, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_I, XK_kana_NI, XK_i, 0xff86, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_O, XK_kana_RA, XK_o, 0xff97, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_P, XK_kana_SE, XK_p, 0xff7e, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_AT, XK_voicedsound, XK_at, 0xff9e, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_OPEN_BRACKET, XK_semivoicedsound, XK_bracketleft, 0xff9f, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_A, XK_kana_CHI, XK_a, 0xff81, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_S, XK_kana_TO, XK_s, 0xff84, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_D, XK_kana_SHI, XK_d, 0xff7c, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_F, XK_kana_HA, XK_f, 0xff8a, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_G, XK_kana_KI, XK_g, 0xff77, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_H, XK_kana_KU, XK_h, 0xff78, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_J, XK_kana_MA, XK_j, 0xff8f, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_K, XK_kana_NO, XK_k, 0xff89, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_L, XK_kana_RI, XK_l, 0xff98, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_SEMICOLON, XK_kana_RE, XK_semicolon, 0xff9a, TRUE, 0 },
    { ':',				    XK_kana_KE, XK_colon, 0xff79, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_CLOSE_BRACKET, XK_kana_MU, XK_bracketright, 0xff91, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_Z, XK_kana_TSU, XK_z, 0xff82, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_X, XK_kana_SA, XK_x, 0xff7b, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_C, XK_kana_SO, XK_c, 0xff7f, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_V, XK_kana_HI, XK_v, 0xff8b, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_B, XK_kana_KO, XK_b, 0xff7a, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_N, XK_kana_MI, XK_n, 0xff90, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_M, XK_kana_MO, XK_m, 0xff93, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_COMMA, XK_kana_NE, XK_comma, 0xff88, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_PERIOD, XK_kana_RU, XK_period, 0xff99, TRUE , 0},
    { java_awt_event_KeyEvent_VK_SLASH, XK_kana_ME, XK_slash, 0xff92, TRUE, 0 },
    /* hack to japanese keyboard */
    /* backslash is duplicate for RO and prolongedsound */
    { java_awt_event_KeyEvent_VK_BACK_SLASH, XK_kana_RO, XK_underscore, 0xff9b, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_BACK_SLASH, XK_prolongedsound, XK_bar, 0xff70, TRUE, 0 },
    { 0, 0, 0 }
};

static KeymapEntry2 kana_shift_keymapTable[] = {
    { java_awt_event_KeyEvent_VK_3, XK_kana_a, XK_numbersign, 0xff67, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_4, XK_kana_u, XK_dollar, 0xff69, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_5, XK_kana_e, XK_percent, 0xff6a, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_6, XK_kana_o, XK_ampersand, 0xff6b, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_7, XK_kana_ya, XK_apostrophe, 0xff6c, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_8, XK_kana_yu, XK_parenleft, 0xff6d, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_9, XK_kana_yo, XK_parenright, 0xff6e, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_0, XK_kana_WO, XK_asciitilde, 0xff66, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_E, XK_kana_i, XK_E, 0xff68, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_OPEN_BRACKET, XK_kana_openingbracket, XK_braceleft, 0xff62, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_CLOSE_BRACKET, XK_kana_closingbracket, XK_braceright, 0xff63, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_Z, XK_kana_tsu, XK_Z, 0xff6f, TRUE, 0 },
    /* XK_less does not return correct keycode on VineLinux 1.1 */
    { java_awt_event_KeyEvent_VK_COMMA, XK_kana_comma, XK_comma, 0xff64, TRUE, 0 },
    { java_awt_event_KeyEvent_VK_PERIOD, XK_kana_fullstop, XK_greater, 0xff61, TRUE,0 },
    { java_awt_event_KeyEvent_VK_SLASH, XK_kana_conjunctive, XK_question, 0xff65, TRUE,0 },
    { 0, 0, 0 }
};
#endif

static KeymapEntry keymapTable[] = {
    { java_awt_event_KeyEvent_VK_A, XK_a, TRUE },
    { java_awt_event_KeyEvent_VK_B, XK_b, TRUE },
    { java_awt_event_KeyEvent_VK_C, XK_c, TRUE },
    { java_awt_event_KeyEvent_VK_D, XK_d, TRUE },
    { java_awt_event_KeyEvent_VK_E, XK_e, TRUE },
    { java_awt_event_KeyEvent_VK_F, XK_f, TRUE },
    { java_awt_event_KeyEvent_VK_G, XK_g, TRUE },
    { java_awt_event_KeyEvent_VK_H, XK_h, TRUE },
    { java_awt_event_KeyEvent_VK_I, XK_i, TRUE },
    { java_awt_event_KeyEvent_VK_J, XK_j, TRUE },
    { java_awt_event_KeyEvent_VK_K, XK_k, TRUE },
    { java_awt_event_KeyEvent_VK_L, XK_l, TRUE },
    { java_awt_event_KeyEvent_VK_M, XK_m, TRUE },
    { java_awt_event_KeyEvent_VK_N, XK_n, TRUE },
    { java_awt_event_KeyEvent_VK_O, XK_o, TRUE },
    { java_awt_event_KeyEvent_VK_P, XK_p, TRUE },
    { java_awt_event_KeyEvent_VK_Q, XK_q, TRUE },
    { java_awt_event_KeyEvent_VK_R, XK_r, TRUE },
    { java_awt_event_KeyEvent_VK_S, XK_s, TRUE },
    { java_awt_event_KeyEvent_VK_T, XK_t, TRUE },
    { java_awt_event_KeyEvent_VK_U, XK_u, TRUE },
    { java_awt_event_KeyEvent_VK_V, XK_v, TRUE },
    { java_awt_event_KeyEvent_VK_W, XK_w, TRUE },
    { java_awt_event_KeyEvent_VK_X, XK_x, TRUE },
    { java_awt_event_KeyEvent_VK_Y, XK_y, TRUE },
    { java_awt_event_KeyEvent_VK_Z, XK_z, TRUE },

    { java_awt_event_KeyEvent_VK_ENTER, XK_Return, TRUE },
    { java_awt_event_KeyEvent_VK_ENTER, XK_KP_Enter, TRUE },
    { java_awt_event_KeyEvent_VK_ENTER, XK_Linefeed, TRUE },

    { java_awt_event_KeyEvent_VK_BACK_SPACE, XK_BackSpace, TRUE },
    { java_awt_event_KeyEvent_VK_TAB, XK_Tab, TRUE },
    { java_awt_event_KeyEvent_VK_TAB, XK_ISO_Left_Tab, TRUE },
    { java_awt_event_KeyEvent_VK_CANCEL, XK_Cancel, FALSE },
    { java_awt_event_KeyEvent_VK_CLEAR, XK_Clear, FALSE },
    { java_awt_event_KeyEvent_VK_SHIFT, XK_Shift_L, FALSE },
    { java_awt_event_KeyEvent_VK_SHIFT, XK_Shift_R, FALSE }, 
    { java_awt_event_KeyEvent_VK_CONTROL, XK_Control_L, FALSE },
    { java_awt_event_KeyEvent_VK_CONTROL, XK_Control_R, FALSE }, 
    { java_awt_event_KeyEvent_VK_ALT, XK_Alt_L, FALSE },
    { java_awt_event_KeyEvent_VK_ALT, XK_Alt_R, FALSE },
    { java_awt_event_KeyEvent_VK_META, XK_Meta_L, FALSE },
    { java_awt_event_KeyEvent_VK_META, XK_Meta_R, FALSE }, 
    { java_awt_event_KeyEvent_VK_PAUSE, XK_Pause, FALSE },
    { java_awt_event_KeyEvent_VK_CAPS_LOCK, XK_Caps_Lock, FALSE },
    { java_awt_event_KeyEvent_VK_ESCAPE, XK_Escape, TRUE },
    { java_awt_event_KeyEvent_VK_SPACE, XK_space, TRUE },

    { java_awt_event_KeyEvent_VK_PAGE_UP, XK_Page_Up, FALSE },
    { java_awt_event_KeyEvent_VK_PAGE_UP, XK_R9, FALSE },
    { java_awt_event_KeyEvent_VK_PAGE_UP, XK_Prior, FALSE },
    { java_awt_event_KeyEvent_VK_PAGE_UP, XK_F29, FALSE },
    { java_awt_event_KeyEvent_VK_PAGE_DOWN, XK_Page_Down, FALSE },
    { java_awt_event_KeyEvent_VK_PAGE_DOWN, XK_R15, FALSE },
    { java_awt_event_KeyEvent_VK_PAGE_DOWN, XK_Next, FALSE },
    { java_awt_event_KeyEvent_VK_PAGE_DOWN, XK_F35, FALSE },
    { java_awt_event_KeyEvent_VK_END, XK_End, FALSE },
    { java_awt_event_KeyEvent_VK_END, XK_R13, FALSE },
    { java_awt_event_KeyEvent_VK_END, XK_F33, FALSE },
    { java_awt_event_KeyEvent_VK_HOME, XK_Home, FALSE },
    { java_awt_event_KeyEvent_VK_HOME, XK_R7, FALSE },
    { java_awt_event_KeyEvent_VK_HOME, XK_F27, FALSE },

    { java_awt_event_KeyEvent_VK_LEFT, XK_Left, FALSE },
    { java_awt_event_KeyEvent_VK_UP, XK_Up, FALSE },
    { java_awt_event_KeyEvent_VK_RIGHT, XK_Right, FALSE },
    { java_awt_event_KeyEvent_VK_DOWN, XK_Down, FALSE },
    { java_awt_event_KeyEvent_VK_INSERT, XK_Insert, FALSE },
    { java_awt_event_KeyEvent_VK_HELP, XK_Help, FALSE },

    { java_awt_event_KeyEvent_VK_0, XK_0, TRUE },
    { java_awt_event_KeyEvent_VK_1, XK_1, TRUE },
    { java_awt_event_KeyEvent_VK_2, XK_2, TRUE },
    { java_awt_event_KeyEvent_VK_3, XK_3, TRUE },
    { java_awt_event_KeyEvent_VK_4, XK_4, TRUE },
    { java_awt_event_KeyEvent_VK_5, XK_5, TRUE },
    { java_awt_event_KeyEvent_VK_6, XK_6, TRUE },
    { java_awt_event_KeyEvent_VK_7, XK_7, TRUE },
    { java_awt_event_KeyEvent_VK_8, XK_8, TRUE },
    { java_awt_event_KeyEvent_VK_9, XK_9, TRUE },

    { java_awt_event_KeyEvent_VK_EQUALS, XK_equal, TRUE },
    { java_awt_event_KeyEvent_VK_BACK_SLASH, XK_backslash, TRUE },
    { java_awt_event_KeyEvent_VK_BACK_QUOTE, XK_grave, TRUE },
    { java_awt_event_KeyEvent_VK_OPEN_BRACKET, XK_bracketleft, TRUE },
    { java_awt_event_KeyEvent_VK_CLOSE_BRACKET, XK_bracketright, TRUE },
    { java_awt_event_KeyEvent_VK_SEMICOLON, XK_semicolon, TRUE },
    { java_awt_event_KeyEvent_VK_QUOTE, XK_apostrophe, TRUE },
    { java_awt_event_KeyEvent_VK_MINUS, XK_minus, TRUE },
    { java_awt_event_KeyEvent_VK_COMMA, XK_comma, TRUE },
    { java_awt_event_KeyEvent_VK_PERIOD, XK_period, TRUE },
    { java_awt_event_KeyEvent_VK_SLASH, XK_slash, TRUE },

    { java_awt_event_KeyEvent_VK_NUMPAD0, XK_KP_0, TRUE },
    { java_awt_event_KeyEvent_VK_NUMPAD1, XK_KP_1, TRUE },
    { java_awt_event_KeyEvent_VK_NUMPAD2, XK_KP_2, TRUE },
    { java_awt_event_KeyEvent_VK_NUMPAD3, XK_KP_3, TRUE },
    { java_awt_event_KeyEvent_VK_NUMPAD4, XK_KP_4, TRUE },
    { java_awt_event_KeyEvent_VK_NUMPAD5, XK_KP_5, TRUE },
    { java_awt_event_KeyEvent_VK_NUMPAD6, XK_KP_6, TRUE },
    { java_awt_event_KeyEvent_VK_NUMPAD7, XK_KP_7, TRUE },
    { java_awt_event_KeyEvent_VK_NUMPAD8, XK_KP_8, TRUE },
    { java_awt_event_KeyEvent_VK_NUMPAD9, XK_KP_9, TRUE },
    { java_awt_event_KeyEvent_VK_MULTIPLY, XK_KP_Multiply, TRUE },
    { java_awt_event_KeyEvent_VK_ADD, XK_KP_Add, TRUE },
    { java_awt_event_KeyEvent_VK_SUBTRACT, XK_KP_Subtract, TRUE },
    { java_awt_event_KeyEvent_VK_DECIMAL, XK_KP_Decimal, TRUE },
    { java_awt_event_KeyEvent_VK_DIVIDE, XK_KP_Divide, TRUE },
    { java_awt_event_KeyEvent_VK_EQUALS, XK_KP_Equal, TRUE },
    { java_awt_event_KeyEvent_VK_INSERT, XK_KP_Insert, FALSE },
    { java_awt_event_KeyEvent_VK_ENTER, XK_KP_Enter, FALSE },

    { java_awt_event_KeyEvent_VK_HOME, XK_KP_Home, FALSE },
    { java_awt_event_KeyEvent_VK_UP, XK_KP_Up, FALSE },
    { java_awt_event_KeyEvent_VK_PAGE_UP, XK_KP_Prior, FALSE },
    { java_awt_event_KeyEvent_VK_LEFT, XK_KP_Left, FALSE },
    { java_awt_event_KeyEvent_VK_RIGHT, XK_KP_Right, FALSE },
    { java_awt_event_KeyEvent_VK_END, XK_KP_End, FALSE },
    { java_awt_event_KeyEvent_VK_DOWN, XK_KP_Down, FALSE },
    { java_awt_event_KeyEvent_VK_PAGE_DOWN, XK_KP_Next, FALSE },

    { java_awt_event_KeyEvent_VK_F1, XK_F1, FALSE },
    { java_awt_event_KeyEvent_VK_F2, XK_F2, FALSE },
    { java_awt_event_KeyEvent_VK_F3, XK_F3, FALSE },
    { java_awt_event_KeyEvent_VK_F4, XK_F4, FALSE },
    { java_awt_event_KeyEvent_VK_F5, XK_F5, FALSE },
    { java_awt_event_KeyEvent_VK_F6, XK_F6, FALSE },
    { java_awt_event_KeyEvent_VK_F7, XK_F7, FALSE },
    { java_awt_event_KeyEvent_VK_F8, XK_F8, FALSE },
    { java_awt_event_KeyEvent_VK_F9, XK_F9, FALSE },
    { java_awt_event_KeyEvent_VK_F10, XK_F10, FALSE },
    /* next two entries for for 4173902 */
#if defined (sun)
    { java_awt_event_KeyEvent_VK_F11, SunXK_F36, FALSE },
    { java_awt_event_KeyEvent_VK_F12, SunXK_F37, FALSE },
#else
    { java_awt_event_KeyEvent_VK_F11, XK_F11, FALSE },
    { java_awt_event_KeyEvent_VK_F12, XK_F12, FALSE },
#endif
    { java_awt_event_KeyEvent_VK_DELETE, XK_Delete, TRUE },
    { java_awt_event_KeyEvent_VK_DELETE, XK_KP_Delete, TRUE },

    { java_awt_event_KeyEvent_VK_NUM_LOCK, XK_Num_Lock, FALSE },
    { java_awt_event_KeyEvent_VK_SCROLL_LOCK, XK_Scroll_Lock, FALSE },
    { java_awt_event_KeyEvent_VK_PRINTSCREEN, XK_Print, FALSE },

    { java_awt_event_KeyEvent_VK_ACCEPT, XK_Execute, FALSE },

    { java_awt_event_KeyEvent_VK_KANJI, XK_Henkan_Mode, FALSE },
    { java_awt_event_KeyEvent_VK_CONVERT, XK_Kanji, FALSE },

    /* To support Hangul keys in Sun Korean keyboard */
    { java_awt_event_KeyEvent_VK_HANGUL, XK_Hangul, FALSE },
    { java_awt_event_KeyEvent_VK_HANGUL_HANJA, XK_Hangul_Hanja, FALSE },

    { java_awt_event_KeyEvent_VK_NONCONVERT, XK_Muhenkan, FALSE },

    { java_awt_event_KeyEvent_VK_KANA, XK_Katakana, FALSE },
    { java_awt_event_KeyEvent_VK_KANA, XK_kana_switch, FALSE },

    { java_awt_event_KeyEvent_VK_CUT, XK_F20, FALSE },
    { java_awt_event_KeyEvent_VK_COPY, XK_F16, FALSE },
    { java_awt_event_KeyEvent_VK_PASTE, XK_F18, FALSE },
    { java_awt_event_KeyEvent_VK_UNDO, XK_F14, FALSE },
    { java_awt_event_KeyEvent_VK_FIND, XK_F19, FALSE },
    { java_awt_event_KeyEvent_VK_PROPS, XK_F13, FALSE },

    /* For supporting DEAD KEYS */
    { java_awt_event_KeyEvent_VK_DEAD_GRAVE, XK_dead_grave, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_ACUTE, XK_dead_acute, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_CIRCUMFLEX, XK_dead_circumflex, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_TILDE, XK_dead_tilde, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_MACRON, XK_dead_macron, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_BREVE, XK_dead_breve, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_ABOVEDOT, XK_dead_abovedot, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_DIAERESIS, XK_dead_diaeresis, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_ABOVERING, XK_dead_abovering, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_DOUBLEACUTE, XK_dead_doubleacute, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_CARON, XK_dead_caron, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_CEDILLA, XK_dead_cedilla, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_OGONEK, XK_dead_ogonek, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_IOTA, XK_dead_iota, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_VOICED_SOUND, XK_dead_voiced_sound, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_SEMIVOICED_SOUND, XK_dead_semivoiced_sound, FALSE },

#if defined (sun)
    { java_awt_event_KeyEvent_VK_DEAD_GRAVE, SunXK_FA_Grave, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_CIRCUMFLEX, SunXK_FA_Circum, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_ACUTE, SunXK_FA_Acute, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_TILDE, SunXK_FA_Tilde, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_DIAERESIS, SunXK_FA_Diaeresis, FALSE },
    { java_awt_event_KeyEvent_VK_IM_VK_DEAD_CEDILLA, SunXK_FA_Cedilla, FALSE },
#endif

    /* support forwarding compose key */
    { java_awt_event_KeyEvent_VK_COMPOSE, XK_Multi_key, FALSE },

    /* Add the missing mapping */
    { java_awt_event_KeyEvent_VK_AT, XK_at, TRUE },
    { java_awt_event_KeyEvent_VK_COLON, XK_colon, TRUE },
    { java_awt_event_KeyEvent_VK_CIRCUMFLEX, XK_asciicircum, TRUE },
    { java_awt_event_KeyEvent_VK_DOLLAR, XK_dollar, TRUE },
    { java_awt_event_KeyEvent_VK_EURO, XK_EuroSign, TRUE},
    { java_awt_event_KeyEvent_VK_EXCLAMATION_MARK, XK_exclam, TRUE },
    { java_awt_event_KeyEvent_VK_LEFT_PARENTHESIS, XK_parenleft, TRUE },
    { java_awt_event_KeyEvent_VK_NUMBER_SIGN, XK_numbersign, TRUE },
    { java_awt_event_KeyEvent_VK_PLUS, XK_plus, TRUE },
    { java_awt_event_KeyEvent_VK_RIGHT_PARENTHESIS, XK_parenright, TRUE },
    { java_awt_event_KeyEvent_VK_UNDERSCORE, XK_underscore, TRUE },
    { java_awt_event_KeyEvent_VK_AMPERSAND, XK_ampersand, TRUE },
    { java_awt_event_KeyEvent_VK_ASTERISK, XK_asterisk, TRUE },
    { java_awt_event_KeyEvent_VK_QUOTEDBL, XK_quotedbl, TRUE },
    { java_awt_event_KeyEvent_VK_LESS, XK_less, TRUE },
    { java_awt_event_KeyEvent_VK_GREATER, XK_greater, TRUE },
    { java_awt_event_KeyEvent_VK_BRACELEFT, XK_braceleft, TRUE },
    { java_awt_event_KeyEvent_VK_BRACERIGHT, XK_braceright, TRUE },
    
    { 0, 0, 0 }
};

static long keysymToUnicode(long keysym)
{
  int min = 0;
  int max = sizeof (x11_keysym_to_unicode_tab) / sizeof (x11_keysym_to_unicode_tab[0]);
  int mid;
  while (max >= min) {
    mid = (min + max) / 2;
    if (x11_keysym_to_unicode_tab[mid].keysym < keysym)
      min = mid + 1;
    else if (x11_keysym_to_unicode_tab[mid].keysym > keysym)
      max = mid - 1;
    else {
      return x11_keysym_to_unicode_tab[mid].ucs;
    }
  }
  return 0;
}

static KeySym getX11KeySym(long awtKey) 
{
    int i;
    for (i = 0; keymapTable[i].awtKey != 0; i++) {
        if (keymapTable[i].awtKey == awtKey) {
	  /* stop checking printable or not, otherwise
	     arrow keys won't work
	    if (keymapTable[i].printable == FALSE) return 0;
	    */
	  return keymapTable[i].x11Key;
        }
    }
    return 0;
}

static long getAWTKeyCode(long keysym) 
{
    int i;
    for (i = 0; keymapTable[i].awtKey != 0; i++) {
        if (keymapTable[i].x11Key == keysym) {
	  return keymapTable[i].awtKey;
        }
    }
    return 0;
}

/* for kana */
#if kana_table
static void getAWTKeyCode2(long keysym, int *keycode, int *keychar) 
{
    int i;
	  *keycode = 0;
	  *keychar = 0;

    for (i = 0; kana_normal_keymapTable[i].awtKey != 0; i++) {
        if (kana_normal_keymapTable[i].x11Key == keysym) {
	  *keycode = kana_normal_keymapTable[i].awtKey;
	  *keychar = kana_normal_keymapTable[i].keychar;
	  return;
        }
    }
    for (i = 0; kana_shift_keymapTable[i].awtKey != 0; i++) {
        if (kana_shift_keymapTable[i].x11Key == keysym) {
	  *keycode = kana_shift_keymapTable[i].awtKey;
	  *keychar = kana_shift_keymapTable[i].keychar;
	  return;
        }
    }
    return;
}
#endif

static void
set_mod_mask(int modnum, int *mask) {
    switch(modnum) {
      case 1: 
	*mask = Mod1Mask;
	break;			
      case 2: 
	*mask = Mod2Mask;
	break;		
      case 3: 
	*mask = Mod3Mask;
	break;			
      case 4: 
	*mask = Mod4Mask;
	break;	
      case 5:
	*mask = Mod5Mask;
	break;
      default:
	*mask = 0;
    }
}

#ifdef sun
static int
xkb_enabled_kana(Display *dpy)
{
    int i1, i2, i3, i4;
    int xkbReqBase;
    int xkbEventBase;

    i1 = XkbMajorVersion;
    i2 = XkbMinorVersion;

    if (XkbLibraryVersion(&i1, &i2) == False)
	return 0;
    if (XkbQueryExtension(dpy,&xkbReqBase,&xkbEventBase,&i2,&i3,&i4) == False)
	return 0;

    /*
     * hack, 0x2000 lock state until it is resolved how to take it.
     */
    return 0x2000;
}
#endif

#ifdef linux
static void GetKanaFlag(Display *disp);
#endif

static void
setup_modifier_map(Display *disp)
{
    XModifierKeymap *modmap; 
    int i, k, nkeys;
    KeyCode keycode, metaL, metaR, altL, altR, numLock, Mode_switch;

    metaL = XKeysymToKeycode(disp, XK_Meta_L);
    metaR = XKeysymToKeycode(disp, XK_Meta_R);
    altR = XKeysymToKeycode(disp, XK_Alt_R);
    altL = XKeysymToKeycode(disp, XK_Alt_L);
    numLock = XKeysymToKeycode(disp, XK_Num_Lock);
    Mode_switch = XKeysymToKeycode(disp, XK_Mode_switch);

    modmap = XGetModifierMapping(disp);
    nkeys = modmap->max_keypermod;
    for(i = 3*nkeys; 
	i < (nkeys*8) && (awt_MetaMask == 0 || awt_AltMask == 0 || awt_NumLockMask == 0 || awt_KanaLockMask ==0);
            i++) {
	keycode = modmap->modifiermap[i];
	k = (i/nkeys) - 2;
	if (awt_MetaMask == 0 && (keycode == metaL || keycode == metaR)) {
	    set_mod_mask(k, &awt_MetaMask);
	} else if (awt_AltMask == 0 && (keycode == altL || keycode == altR)) {
 	    set_mod_mask(k, &awt_AltMask);
	} else if (awt_NumLockMask == 0 && keycode == numLock) {
            set_mod_mask(k, &awt_NumLockMask);
	} else if (awt_KanaLockMask == 0 && keycode == Mode_switch) {
#ifdef sun
	    if ((awt_KanaLockMask = xkb_enabled_kana(disp)) == 0)
#endif
		set_mod_mask(k, &awt_KanaLockMask);
        }
    }
    XFreeModifiermap(modmap);

#ifdef	linux
    /* hack for Linux XFree86 */
    for (i = 0; keymapTable[i].awtKey != 0; i++) {
      if (keymapTable[i].x11Key == XK_Henkan_Mode) {
	keymapTable[i].x11Key = XK_Zenkaku_Hankaku;
	break;
      }
    }
    for (i = 0; keymapTable[i].awtKey != 0; i++) {
      if (keymapTable[i].x11Key == XK_Kanji) {
	keymapTable[i].x11Key = XK_Henkan_Mode;
	break;
      }
    }
    for (i = 0; keymapTable[i].awtKey != 0; i++) {
      if (keymapTable[i].x11Key == XK_Execute) {
	keymapTable[i].x11Key = XK_Muhenkan;
	break;
      }
    }

    /* hack for Linux XFree86 */
    if (getenv("HTT_GENERATES_KANAKEY")){
	KanaMode = 0;
    } else {
	return;
    }

    /* Get Keycodes for Kana keys */
    for (i = 0; kana_normal_keymapTable[i].awtKey != 0; i++) {
	kana_normal_keymapTable[i].keycode = XKeysymToKeycode(disp,
						kana_normal_keymapTable[i].x11Key);
	if (kana_normal_keymapTable[i].keycode == 0) {
		kana_normal_keymapTable[i].keycode = XKeysymToKeycode(disp,
						kana_normal_keymapTable[i].alt_x11Key);
	}
#ifdef	DEBUG
	printf("xkey=%x(%x) -> %x\n", kana_normal_keymapTable[i].x11Key,
					kana_normal_keymapTable[i].keychar,
					kana_normal_keymapTable[i].keycode);
#endif
    }
    for (i = 0; kana_shift_keymapTable[i].awtKey != 0; i++) {
	kana_shift_keymapTable[i].keycode = XKeysymToKeycode(disp,
						kana_shift_keymapTable[i].x11Key);
	if (kana_shift_keymapTable[i].keycode == 0) {
		kana_shift_keymapTable[i].keycode = XKeysymToKeycode(disp,
						kana_shift_keymapTable[i].alt_x11Key);
	}
#ifdef	DEBUG
	printf("xkey=%x(%x) -> %x\n", kana_shift_keymapTable[i].x11Key,
					kana_shift_keymapTable[i].keychar,
					kana_shift_keymapTable[i].keycode);
#endif
    }
#endif /* linux */
}

#ifdef linux
void
CreateKanaWindow(Display *disp)
{
    Window kana_w;

    /* hack for Linux XFree86 */
    if (getenv("HTT_GENERATES_KANAKEY")){
	KanaMode = 0;
    } else {
	return;
    }

    if (!kanawin_atom) {
	kanawin_atom = XInternAtom(disp, "HTT_KANA_WIN", False);
	kanaflag_atom = XInternAtom(disp, "HTT_KANA_FLAG", False);
    }

    kana_w = XGetSelectionOwner(disp, kanawin_atom);

    if (kana_w == None) {
	kana_w = XCreateSimpleWindow(disp, RootWindow(disp, 0),
			0, 0, 1, 1, 0, 0, 0);

	XSetSelectionOwner(disp, kanawin_atom, kana_w, CurrentTime);
	if (kana_w == XGetSelectionOwner(disp, kanawin_atom)) {
	    XChangeProperty(disp, kana_w, kanaflag_atom, XA_WINDOW, 32,
			    PropModeReplace,
			    (unsigned char*) &KanaMode, 1);
	}
    }
}
#endif /* linux */

#ifdef linux
static int
IgnoreError(Display *disp, XErrorEvent *event)
{
    return 0;
}
#endif /* linux */

#ifdef linux
static void
GetKanaFlag(Display *disp)
{
    int           (*oldhandler)(Display *, XErrorEvent *) = NULL;
    Window          kana_w;
    Atom            ret_type;
    int             ret_format;
    unsigned long   nitems, bytes_left;
    unsigned long  *tmp = NULL;

    if (!kanawin_atom) {
        return;
    }

    XSync(disp, False);
    oldhandler = XSetErrorHandler(IgnoreError);

    kana_w = XGetSelectionOwner(disp, kanawin_atom);
    if (!kana_w) {
        KanaMode = 0;
        XSync(disp, False);
        XSetErrorHandler(oldhandler);
        return;
    }

    XGetWindowProperty(disp, kana_w,
		       kanaflag_atom, 0, 4, False, XA_WINDOW,
		       &ret_type, &ret_format,
		       &nitems, &bytes_left, (void*) &tmp);

    XSync(disp, False);
    XSetErrorHandler(oldhandler);

    if ((tmp != NULL) && (ret_type == XA_WINDOW)) {
       KanaMode = *tmp;
    }
    if (tmp) {
	free((char*)tmp);
    }
}
#endif /* linux */

/*
	XKeysymToKeycode() does not return correct keycode for XK_Delete.
	So we store and keep the value of KeyCode at the first key typed,
	then use in modify_Event()
*/

static long keyCode_XK_Delete = 0;

static void
modify_Event(
    XEvent *xevent,
    long keyCode,
    unicode keyChar,
    long modifiers
)
{
    KeySym keysym = 0;

    if (xevent->type != KeyPress && xevent->type != KeyRelease)
        return;

    switch(keyCode) {
      case java_awt_event_KeyEvent_VK_ENTER:
      case java_awt_event_KeyEvent_VK_BACK_SPACE:
      case java_awt_event_KeyEvent_VK_TAB:
      case java_awt_event_KeyEvent_VK_ESCAPE:
      case java_awt_event_KeyEvent_VK_MULTIPLY:
      case java_awt_event_KeyEvent_VK_ADD:
      case java_awt_event_KeyEvent_VK_SUBTRACT:
      case java_awt_event_KeyEvent_VK_DIVIDE:
      case java_awt_event_KeyEvent_VK_EQUALS:
      case java_awt_event_KeyEvent_VK_DECIMAL:
          keysym = getX11KeySym(keyCode);
          break;
      default:
          if ((keyChar != 0 && keyChar < 256)
	      || (keyChar >= 0xff61 && keyChar <= 0xff9f)) {
              keysym = keyChar;
          } else {
              keysym = getX11KeySym(keyCode);
          }
          break;
    }

    if (keysym != 0) {
	if (modifiers & java_awt_event_InputEvent_CTRL_MASK) {
	    switch (keysym + 64) {
	      case '[':
	      case ']':
	      case '\\':
	      case '_':
		keysym += 64;
		break;
	      default:
	 	if (keysym < 128) {
		  if (modifiers & java_awt_event_InputEvent_SHIFT_MASK) {
		    if (isupper(keysym + 'A' - 1)) {
		      keysym += ('A' - 1);
		    }
		  } else {
		    if (isalpha(keysym + 'a' - 1)) {
		      keysym += ('a' - 1);
		    }
		    if (isalpha(keysym))
		      keysym = tolower(keysym);	
		  }
		}
		break;
	    }
	}

	/*
	 * 0xff61 is Unicode value of first XK_kana_fullstop.
	 * We need X Keysym to Unicode map in post1.1 release
	 * to support more intenational keyboard.
	 */
	/*
	 * 0xff63 is duplicate with INSERT
	 */
	if (keyCode != java_awt_event_KeyEvent_VK_INSERT &&
	    keyCode != java_awt_event_KeyEvent_VK_ACCEPT &&
	    keyCode != java_awt_event_KeyEvent_VK_ENTER &&
	    (keysym >= 0xff61 && keysym <= 0xff9f) && keysym == keyChar) {
	    keysym = keysym - 0xff61 + XK_kana_fullstop;

	    /*
	     * modifier needs to be set
	     */
	    xevent->xkey.state |= awt_KanaLockMask;
	}

	/* workaround, do we have to set NumLock mask for
	   all KP_ keysym??? */
	if(keysym == XK_KP_Decimal){
	    xevent->xkey.state |= awt_NumLockMask;
        }

	if (xevent->xany.display)
	    xevent->xkey.keycode = XKeysymToKeycode(xevent->xany.display,
						    keysym);
	else
	    xevent->xkey.keycode = keysym; /* hack */

	/* workaround for XKeysymToKeycode() */
	if (keyCode == java_awt_event_KeyEvent_VK_DELETE){
	    xevent->xkey.keycode = keyCode_XK_Delete;
	}
    }

    if (keysym >= 'A' && keysym <= 'Z') {
	xevent->xkey.state |= ShiftMask;
    }
    if (modifiers & java_awt_event_InputEvent_SHIFT_MASK) {
	xevent->xkey.state |= ShiftMask;
    }
    if (modifiers & java_awt_event_InputEvent_CTRL_MASK) {
	xevent->xkey.state |= ControlMask;
    }
    if (modifiers & java_awt_event_InputEvent_META_MASK) {
	xevent->xkey.state |= awt_MetaMask;
    }
    if (modifiers & java_awt_event_InputEvent_ALT_MASK) {
	xevent->xkey.state |= awt_AltMask;
    }
    if (modifiers & java_awt_event_InputEvent_BUTTON1_MASK) {
        xevent->xkey.state |= Button1Mask;
    }
    if (modifiers & java_awt_event_InputEvent_BUTTON2_MASK) {
        xevent->xkey.state |= Button2Mask;
    }
    if (modifiers & java_awt_event_InputEvent_BUTTON3_MASK) {
        xevent->xkey.state |= Button3Mask;
    }
}

static int first_call = True;

void
IIIMCF_keyevent_To_XKeyEvent(
    IIIMCF_keyevent *pkev,
    Display *dpy,
    Window w,
    XKeyEvent *kev
)
{
    if (first_call && dpy != (Display*)0) {
	setup_modifier_map(dpy);
	first_call = False;
    }

    memset(kev, 0, sizeof(*kev));
    
    if (0 == (pkev->modifier & 0x80000000)) {
	kev->type = KeyPress;
    } else {
	kev->type = KeyRelease;
    }
    kev->display = dpy;
    kev->window = w;
    kev->root = None;
    kev->subwindow = None;
    kev->same_screen = True;
    kev->time = pkev->time_stamp;

    modify_Event((XEvent*)kev, pkev->keycode,
		 pkev->keychar, (0x7fffffff & pkev->modifier));

    return;
}

/*
  XKeyEvent_To_IIIMCF_keyevent() :
     Convert X KeyEvent to IIIMP keyCode, keyChar, state values
 */
Bool
XKeyEvent_To_IIIMCF_keyevent(
    XKeyEvent *ev,
    IIIMCF_keyevent *pkev
)
{
    KeySym keysym;
    char buf[64];
    int len = sizeof(buf);
    int state;
    int i;

    pkev->keychar = 0;
    pkev->keycode = 0;
    pkev->time_stamp = ev->time;

    if (first_call && ev->display != (Display*)0) {
        setup_modifier_map(ev->display);
        first_call = False;
    }

    state = ev->state;
    if (state & LockMask){
        state -= LockMask;
        state |= 0x40000000;
    }

    if (state & awt_NumLockMask){
        state -= awt_NumLockMask;
    }

    if (state & awt_KanaLockMask){
        state -= awt_KanaLockMask;
        state |= 0x20; /* IM_ALT_GRAPH_MASK */
    }

    /* IIIMP's control_mask(1<<1) and X's control_mask(1<<2)is
       different, so it should be changed */
    if (state & ControlMask) {
        state -= (1<<2);
        state |= (1<<1);
    }

    pkev->modifier = state;
    /* Set mask with 0x80000000 to indicate the event is key release event */
    if (ev->type == KeyRelease)
        pkev->modifier |= 0x80000000;

    len = XLookupString(ev, buf, len - 1, &keysym, NULL);

#ifdef  linux
    /* Linux generates XK_Mode_switch at Shift + Henkan_Mode */
    if (state & ShiftMask && keysym == XK_Mode_switch)
      keysym = XK_Henkan_Mode;
#endif /* linux */

#ifdef	linux
    if (KanaMode != -1){
  	GetKanaFlag(ev->display);
    }	 

    if (KanaMode != -1){
	if (keysym == XK_Hiragana_Katakana){
	   int    (*oldhandler)(Display *, XErrorEvent *) = NULL;
	   Window   kana_w;
#ifdef	DEBUG
	    printf("Kanakey is pressed\n");
#endif
	    if (KanaMode == 1){
		KanaMode = 0;
#ifdef	DEBUG
		printf("	off\n");
#endif
	    } else {
		KanaMode = 1;
#ifdef	DEBUG
		printf("	on\n");
#endif
	    }

	    XSync(ev->display, False);
	    oldhandler = XSetErrorHandler(IgnoreError);

	    kana_w = XGetSelectionOwner(ev->display, kanawin_atom);
	    if (kana_w) {
		XChangeProperty(ev->display, kana_w, kanaflag_atom,
				XA_WINDOW, 32,
				PropModeReplace,
				(unsigned char*) &KanaMode, 1);
	    }

	    XSync(ev->display, False);
	    XSetErrorHandler(oldhandler);

	    return False;
	}
    }

    if (KanaMode == 1) {
	if (ev->state & ShiftMask) {
	    /* check kana_shift_keymapTable first is ShiftMask */
	    for (i = 0; kana_shift_keymapTable[i].awtKey != 0; i++) {
		if (kana_shift_keymapTable[i].keycode == ev->keycode) {
		    getAWTKeyCode2(kana_shift_keymapTable[i].x11Key,
				   &pkev->keycode, &pkev->keychar);
		    if (pkev->keycode) {
			return True;
		    }
		    break;
		}
	    }
	}

	for (i = 0; kana_normal_keymapTable[i].awtKey != 0; i++) {
	    if (kana_normal_keymapTable[i].keycode == ev->keycode) {
		getAWTKeyCode2(kana_normal_keymapTable[i].x11Key,
			       &pkev->keycode, &pkev->keychar);
		if (pkev->keycode) {
		    return True;
		}
		break;
	    }
	}

	for (i = 0; kana_shift_keymapTable[i].awtKey != 0; i++) {
	    if (kana_shift_keymapTable[i].keycode == ev->keycode) {
		getAWTKeyCode2(kana_shift_keymapTable[i].x11Key,
			       &pkev->keycode, &pkev->keychar);
		if (pkev->keycode) {
		    return True;
		}
		break;
	    }
	}
    }
#endif /* linux */

    /* store keycode for XK_Delete */
    if(keysym == XK_Delete && keyCode_XK_Delete == 0){
	keyCode_XK_Delete = ev->keycode;
    }

    if (keysym < 256) {
	pkev->keycode = getAWTKeyCode(keysym);
	if (pkev->keycode == 0 && (ev->state & ShiftMask)) {
	    /* when Shift key is pressed, need to get the normal keysym,
	       then get the AWT keycode */
	    if (ev->display != (Display*)0) {
		pkev->keycode = getAWTKeyCode(XKeycodeToKeysym(ev->display,
							       ev->keycode, 0));
	    }
	}
	if (pkev->keycode == 0) {
	    pkev->keycode = keysym;
	}
	pkev->keychar = keysym;
	return True;
    } else {
	pkev->keycode = getAWTKeyCode(keysym);

	/* This is needed to handle multiple definition of EuroSign on
	   Sun US/UK layout keyboard. The same keychar/keycode can not
	   used for keyboard layout emulation type of LE. */
	if (pkev->keycode == IIIMF_KEYCODE_EURO_SIGN) {
	  KeySym ks = XKeycodeToKeysym (ev->display, ev->keycode, 0);
	  pkev->keycode = getAWTKeyCode(ks);
	  pkev->keychar = 0x20ac;
	}
					
	switch (keysym) {
	  case XK_KP_Decimal:
	   pkev->keychar = '.';
	   break;
	  case XK_KP_Add:
	   pkev->keychar = '+';
	   break;
	  case XK_KP_Subtract:
	   pkev->keychar = '-';
	   break;
	  case XK_KP_Divide:
	   pkev->keychar = '/';
	   break;
	  case XK_KP_Multiply:
	   pkev->keychar = '*';
	   break;
	  case XK_KP_0:
	   pkev->keychar = '0';
	   break;
	  case XK_KP_1:
	   pkev->keychar = '1';
	   break;
	  case XK_KP_2:
	   pkev->keychar = '2';
	   break;
	  case XK_KP_3:
	   pkev->keychar = '3';
	   break;
	  case XK_KP_4:
	   pkev->keychar = '4';
	   break;
	  case XK_KP_5:
	   pkev->keychar = '5';
	   break;
	  case XK_KP_6:
	   pkev->keychar = '6';
	   break;
	  case XK_KP_7:
	   pkev->keychar = '7';
	   break;
	  case XK_KP_8:
	   pkev->keychar = '8';
	   break;
	  case XK_KP_9:
	   pkev->keychar = '9';
	   break;
	  case XK_dead_grave:
	   pkev->keychar = 0x300;
	   break;
	  case XK_dead_acute:
	   pkev->keychar = 0x301;
	   break;
	  case XK_dead_circumflex:
	   pkev->keychar = 0x302;
	   break;
	  case XK_dead_tilde:
	   pkev->keychar = 0x303;
	   break;
	  case XK_dead_macron:
	   pkev->keychar = 0x304;
	   break;
	  case XK_dead_breve:
	   pkev->keychar = 0x306;
	   break;
	  case XK_dead_abovedot:
	   pkev->keychar = 0x307;
	   break;
	  case XK_dead_diaeresis:
	   pkev->keychar = 0x308;
	   break;
	  case XK_dead_abovering:
	   pkev->keychar = 0x30a;
	   break;
	  case XK_dead_doubleacute:
	   pkev->keychar = 0x30b;
	   break;
	  case XK_dead_caron:
	   pkev->keychar = 0x30c;
	   break;
	  case XK_dead_cedilla:
	   pkev->keychar = 0x327;
	   break;
	  case XK_dead_ogonek:
	   pkev->keychar = 0x328;
	   break;
	  case XK_dead_iota:
	   pkev->keychar = 0x345;
	   break;
	  case XK_dead_voiced_sound:
	   pkev->keychar = 0x30f;
	   break;
	  case XK_dead_semivoiced_sound:
	   pkev->keychar = 0x30a;
	   break;
	  case SunXK_FA_Grave:
	   pkev->keychar = 0x300;
	   break;
	  case SunXK_FA_Circum:
	   pkev->keychar = 0x302;
	   break;
	  case SunXK_FA_Tilde:
	   pkev->keychar = 0x303;
	   break;
	  case SunXK_FA_Acute:
	   pkev->keychar = 0x301;
	   break;
	  case SunXK_FA_Diaeresis:
	   pkev->keychar = 0x308;
	   break;
	  case SunXK_FA_Cedilla:
	   pkev->keychar = 0x327;
	   break;
	}
	if (pkev->keycode) {
	    return True;
	}

	/* get Kana code */
	getAWTKeyCode2(keysym, &pkev->keycode, &pkev->keychar);

	if (pkev->keycode) {
	    return True;
	}

	if (pkev->keycode == 0 && (ev->state & ShiftMask)) {
	    /* when Shift key is pressed, need to get the normal keysym,
	       then get the AWT keycode */
	    pkev->keycode = getAWTKeyCode(XKeycodeToKeysym(ev->display,
							   ev->keycode, 0));
	}

	if (pkev->keycode) {
	    return True;
	}

	/* use generic KeySym to unicode mapping with keycode = 0 */
	pkev->keychar = keysymToUnicode(keysym);
	if (pkev->keychar != 0) {
	  return True;
	}
    }
    return False;
}

Bool
XKeysym_To_IIIMCF_keyevent(
    int keysym,
    int state,
    IIIMCF_keyevent *pkev
)
{
    pkev->keychar = 0;
    pkev->keycode = 0;
    pkev->time_stamp = 0;

    /* LockMask, NumLockMask, KanaLockMask should be ignored for
       Java Client compatibility */
    if (state & LockMask) {
	state -= LockMask;
    }
    if (state & awt_NumLockMask) {
	state -= awt_NumLockMask;
    }
    if (state & awt_KanaLockMask) {
	state -= awt_KanaLockMask;
    }

    /* IIIMP's control_mask(1<<1) and X's control_mask(1<<2)is
       different, so it should be changed */
    if (state & ControlMask) {
	state -= (1<<2);
	state |= (1<<1);
    }

    pkev->modifier = state;

#ifdef  linux
    /* Linux generates XK_Mode_switch at Shift + Henkan_Mode */
    if (state & ShiftMask && keysym == XK_Mode_switch)
      keysym = XK_Henkan_Mode;
#endif /* linux */

    if (keysym < 256) {
	if ((state & ControlMask)) {
	    if (isalpha(keysym)) {
		keysym = toupper(keysym);
	    }
	}
	pkev->keycode = getAWTKeyCode(keysym);
	if (pkev->keycode == 0) {
	    pkev->keycode = keysym;
	}
	pkev->keychar = keysym;
	return True;
    } else {
	pkev->keycode = getAWTKeyCode(keysym);
	switch (keysym) {
	  case XK_KP_Decimal:
	   pkev->keychar = '.';
	   break;
	  case XK_KP_Add:
	   pkev->keychar = '+';
	   break;
	  case XK_KP_Subtract:
	   pkev->keychar = '-';
	   break;
	  case XK_KP_Divide:
	   pkev->keychar = '/';
	   break;
	  case XK_KP_Multiply:
	   pkev->keychar = '*';
	   break;
	  case XK_KP_0:
	   pkev->keychar = '0';
	   break;
	  case XK_KP_1:
	   pkev->keychar = '1';
	   break;
	  case XK_KP_2:
	   pkev->keychar = '2';
	   break;
	  case XK_KP_3:
	   pkev->keychar = '3';
	   break;
	  case XK_KP_4:
	   pkev->keychar = '4';
	   break;
	  case XK_KP_5:
	   pkev->keychar = '5';
	   break;
	  case XK_KP_6:
	   pkev->keychar = '6';
	   break;
	  case XK_KP_7:
	   pkev->keychar = '7';
	   break;
	  case XK_KP_8:
	   pkev->keychar = '8';
	   break;
	  case XK_KP_9:
	   pkev->keychar = '9';
	   break;
	}
	if (pkev->keycode) {
	    return True;
	}

	/* get Kana code */
	getAWTKeyCode2(keysym, &pkev->keycode, &pkev->keychar);
	if (pkev->keycode) {
	    return True;
	}
    }

    return False;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
