/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
//
// defines Win32 platform dependent method implemetation
// for CompoundString class
//
#include "CompoundString.hh"
#include <string.h>
#include <stdlib.h>

CompoundString::CompoundString(const char astring[]) {
  if (astring == 0) {
    pBuffer = new char[1];
    pBuffer[0] = 0;
  } else {
    pBuffer = new char[strlen(astring) + 1];
    strcpy(pBuffer, astring);
  }
}

CompoundString::CompoundString(const wchar_t astring[]) {
  if (astring == 0) {
    pBuffer = new char[1];
    pBuffer[0] = 0;
  } else {
    int len = wcstombs(0, astring, 0); // 3rd argument is ignored
    if (len == -1) return;
    pBuffer = new char[len + 1];
    wcstombs(pBuffer, astring, len);
  }
}

CompoundString&
CompoundString::operator=(const CompoundString& a) {
  char *pTemp = new char[a.length() + 1];
  strcpy(pTemp, a.pBuffer);
  delete [] pBuffer;
  pBuffer = pTemp;
  return *this;
}

CompoundString
CompoundString::operator+(const CompoundString& a) const {
  CompoundString d;
  unsigned int len1 = length();
  unsigned int len2 = a.length();
  unsigned int len = len1 + len2 + 1;

  char *pTemp = new char[len];

  strcpy(pTemp, pBuffer);
  strcat(pTemp, a.pBuffer);

  d = pTemp;

  delete [] pTemp;
  return d;
}

CompoundString&
CompoundString::operator+=(const CompoundString& a) {
  unsigned int len1 = length();
  unsigned int len2 = a.length();
  unsigned int len = len1 + len2 + 1;

  char *pTemp = new char[len];

  strcpy(pTemp, pBuffer);
  strcat(pTemp, a.pBuffer);

  delete [] pBuffer;

  pBuffer = pTemp;
  return *this;
}

CompoundString&
CompoundString::operator-=(const CompoundString& a) {
  char *p;

  if (a.length() > length()) return *this;

  if ((p = strstr(pBuffer, a.pBuffer)) != 0) {
    unsigned int len = length() - a.length() + 1;
    unsigned int frontLen = p - pBuffer;
    unsigned int backLen = length() - frontLen - a.length();

    char *pTemp = new char[len];
    strncpy(pTemp, pBuffer, frontLen);
    strncat(pTemp, p + a.length(), backLen);
    pTemp[frontLen + backLen] = 0;
    delete [] pBuffer;
    pBuffer = pTemp;
  }
  return *this;
}

int
CompoundString::operator==(const CompoundString &a) const {
  return strcmp(pBuffer, a.pBuffer) ? 0 : 1;
}

int
CompoundString::compare(const char aBuffer[], int n) const {
  return !strncmp(pBuffer, aBuffer, n);
}

int
CompoundString::compare(const char aBuffer[]) const {
  return !strcmp(pBuffer, aBuffer);
}

int
CompoundString::search(const char aBuffer[]) const {
  char *p = strstr(pBuffer, aBuffer);
  return p == 0 ? -1: p - pBuffer;
}

unsigned int
CompoundString::length() const {
  return strlen(pBuffer);
}

