#include <config.h>
#include <stddef.h>
#include <stdlib.h>
#include <strings.h>
#include <sys/types.h>
#include <signal.h>
#include <pthread.h>
#include "IMBasicObject.hh"
#include "IMSignal.hh"
#include "IMSvr.hh"
#include "IMSvrArg.hh"
#include "IMLog.hh"
#include "IMUtil.hh"
#include "IMScheduler_MTPC.hh"

#ifdef HAVE_TLS
#include "IMTLS.hh"
#endif


// Tentatively use global variable iiimd_option_desktop.  Need
// to find a way to put this info into IMSvr and to make IMsvr
// accessible from individual threads.
bool	iiimd_option_desktop;
pid_t	iiimd_parentid;

// Tentatively use global variable desktop_user_name and
// desktop_node_name.  These variable are used when
// iiimd_option_desktop is true.
u16string *	desktop_user_name;
u16string *	desktop_node_name;

// Watch parent process.  When this thread detects termination
// of parent process, terminates iiimd (self) too.
void *
parent_watchdog(void * arg)
{
    // sleep while parent is alive
    while (1 != getppid()) {
	sleep(10);
    }

    // wait for timeout, then terminate iiimd
    sleep(20);
    kill(getpid(), SIGTERM);

    return NULL;
}

// When iiimd is started with -desktop option, this function
// starts parent_watchdog thread.  This function is to prevent
// orphan iiimd remains with no clients.
void
parent_watchdog_start()
{
    pthread_t		th;
    pthread_attr_t	attr;
    char *		option_desktop;

    if (false == iiimd_option_desktop) return;

    option_desktop = getenv("IIIMD_OPTION_DESKTOP");
    if (NULL != option_desktop) {
	if (0 == strcasecmp("continue", option_desktop)) {
	    // If IIIMD_OPTION_DESKTOP=continue, then iiimd will
	    // continue to run even after its parent exits.
	    // This feature is intended for debugging.
	    return;
	}
    }
	    
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

    pthread_create(&th, &attr, parent_watchdog, NULL);

    return;
}

int main(
    int argc,
    char **argv
)
{
    int exitcode;

    IMSvrArg arg(argc, argv);
    IMSvr svr(&arg);

    // Initialize singleton classes.

    //signal handling
    IMSignal *pimsignal = IMSignal::construct(&svr);
    if (!pimsignal) return IMSvr::IMSVR_SYSTEM_ERROR;
    //logging system
    IMLog *pimlog = IMLog::construct(argv[0]);
    if (!pimlog) return IMSvr::IMSVR_SYSTEM_ERROR;
    //scheduler
    IMScheduler *pimsch = IMScheduler_MTPC::construct();
    if (!pimsch) return IMSvr::IMSVR_SYSTEM_ERROR;
    //object manager
    IMObjectMgr *pimobjmgr = IMObjectMgr::construct();
    if (!pimobjmgr) return IMSvr::IMSVR_SYSTEM_ERROR;
#ifdef HAVE_TLS
    // tls manager
    IMTLS *ptls = IMTLS::construct();
    if (!ptls) return IMSvr::IMSVR_SYSTEM_ERROR;
#endif

    exitcode = svr.start();

    // cleanup
    IMSignal::cleanup();
    IMLog::cleanup();
    IMDaemon::cleanup();
#ifdef HAVE_TLS
    IMTLS::cleanup();
#endif

    return exitcode;
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
