/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <iiimp.h>
#include "LECustomData.hh"

IIIMP_card16 *LECustomData::empty_str = NULL;
iconv_t LECustomData::utf16to8_cd;
bool LECustomData::iconv_init = false;
size_t LECustomData::ICONV_BUF_SIZ = 256;
char *LECustomData::iconv_buf;
int LECustomData::id = 0;

LECustomData::LECustomData(
    IIIMP_aux_setvalues_v *pauxval
)
{
  id++;
  if (empty_str == NULL) {
    // initialize static member
    empty_str = new IIIMP_card16[1];
    empty_str[0] = 0;
  }
  if (!iconv_init) {
    utf16to8_cd = iconv_open ("UTF-8", "UTF-16");
    if (utf16to8_cd != (iconv_t)-1) {
      iconv_buf = new char[ICONV_BUF_SIZ];
      iconv_init = true;
    }
  }

  i_vector = new vector<IIIMP_card32>();
  s_vector = new vector<IIIMP_card16 *>();

  int int_count = pauxval->integer_value->count;
  for (int i = 0; i < int_count; i++) {
    i_vector->push_back (pauxval->integer_value->ptr[i]);
  }
  for (IIIMP_string *p = pauxval->string_value; p; p = p->next) {
    if (p->ptr == NULL) {
      s_vector->push_back (empty_str);
    } else {
      IIIMP_card16 *p16 = new IIIMP_card16[p->len + 1];
      memcpy (p16, p->ptr, p->len * 2);
      p16[p->len] = 0;
      s_vector->push_back (p16);
    }
  }
}

LECustomData::~LECustomData()
{
  vector<IIIMP_card16 *>::iterator itr;
  for (itr = s_vector->begin(); itr < s_vector->end(); itr++) {
    delete [] *itr;
  }

  delete i_vector;
  delete s_vector;
}

IMArgList
LECustomData::get_IMArgList ()
{
  /* id for (int) is 0, and id for (char *) is 1 */
  IMArgList list = new IMArg[get_IMArg_num()];
  int i = 0;

  vector<IIIMP_card32>::iterator iit;

  for (iit = i_vector->begin(); iit < i_vector->end(); iit++) {
    IMSetArg(list[i], 0, *iit);
    i++;
  }

  vector<IIIMP_card16 *>::iterator sit;
  for (sit = s_vector->begin(); sit < s_vector->end(); sit++) {
    char *ptr = make_utf8_charstr(*sit);
    IMSetArg(list[i], 1, ptr);
    i++;
  }

  return list;
}

char *
LECustomData::make_utf8_charstr(IIIMP_card16 * utf16)
{
  if (iconv_init) {
    const char *in_buf = (char *)utf16;
    size_t in_size = UTFSTR_len (utf16) * 2;
    if (in_size * 3 + 1 > ICONV_BUF_SIZ) {
      delete iconv_buf;
      ICONV_BUF_SIZ = in_size * 3 + 1;
      iconv_buf = new char [ICONV_BUF_SIZ];
    }
    size_t left = ICONV_BUF_SIZ;
    char *out_buf = iconv_buf;
    size_t ret = iconv (utf16to8_cd, &in_buf, &in_size, &out_buf, &left);
    if (ret != (size_t)-1) {
      iconv_buf[ICONV_BUF_SIZ - left] = '\0';
      return strdup (iconv_buf);
    }
  }
  return NULL;
}


int
LECustomData::get_IMArg_num ()
{
  return i_vector->size() + s_vector->size();
}
