/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 4 -*- */
#ifndef __IMSVRXMLCONF_HH__
#define __IMSVRXMLCONF_HH__

#include "basictype.hh"
#include "IMSvrCfg.hh"
#include <libxml/tree.h>

class IMSvrXMLConf : public IMSvrCfg {
private:
    IMSvr *ptarget;
    string filename;
    IMSocketAddressVec listenaddrvec;

    IMAuth::access_type get_access_type(xmlChar *key);

    string parse_text_node(xmlNodePtr &node);
    string parse_hostname_node(xmlNodePtr &node);
    string parse_port_node(xmlNodePtr &node);
    string parse_file_node(xmlNodePtr &node);
    void parse_listen_tcp_node(xmlNodePtr &node, bool ssl);
    void parse_listen_unix_node(xmlNodePtr &node, bool ssl);
    void parse_acl_node(xmlNodePtr &node);
    void parse_acls_node(xmlNodePtr &node);
    void parse_system_node(xmlNodePtr &node);
    void parse_user_node(xmlNodePtr &node);
    void parse_auth_node(xmlNodePtr &node);
    void parse_ssl_node(xmlNodePtr &node);
    void parse_server_node(xmlNodePtr &node);

    bool load(void);


public:
    virtual bool configure(IMSvr *pimsvr);
    IMSvrXMLConf(IMSvrCfg *pbase, const char *conffile);
    virtual ~IMSvrXMLConf();
};

#endif /* __IMSVRXMLCONF_HH__ */
