#ifndef IMSCHEDULER_HH_
#define IMSCHEDULER_HH_
#include <config.h>
#include <stdio.h>
#include "basictype.hh"

class IMProtocol;
class IMHandler;
class IMAccept;
class IMState;

class IMScheduler
{
    // singleton
    static IMScheduler *pimscheduler;
  protected:
    void register_singleton()
    { pimscheduler = this; }
  public:
    static IMScheduler *get_instance()
    {
	ASSERT(pimscheduler);
	return pimscheduler;
    }
   
    virtual int start(IMAccept *pima, IMProtocol *pimp, IMState *pims) = 0; 
    virtual int stop() = 0;
    IMScheduler() {}
};

#endif /* not IMSCHEDULER_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
