#ifndef IIIMP_HOTKEY_PROFILE_HH_
#define IIIMP_HOTKEY_PROFILE_HH_
#include "IMBasicObject.hh"
#include "IIIMPTrans.hh"
#include "SunIM.h"
#include "IMHotkey.hh"
#include "IMHotkeyPrimitive.hh"

class IIIMP_hotkey_profile
{
  IMHotkeyProfileList profile_list ;

  IIIMP_card16 default_hotkey_profile_id;
  IIIMP_card16 default_hotkey_trigger_notify_id;
  IIIMP_card16 default_hotkey_lang_switch_id;
  IIIMP_card16 default_hotkey_cycle_lang_switch_id;
  IIIMP_card16 default_hotkey_reverse_cycle_lang_switch_id;
  IIIMP_card16 default_hotkey_super_help_id;

  typedef map<size_t, IMHotkeyProfileStruct *> HotkeyProfileMap;
  HotkeyProfileMap hotkey_profile_map;

  void merge_default_hotkeys(IMHotkeyList &phklist);
  public:
    IIIMP_hotkey_profile();
    ~IIIMP_hotkey_profile();

    const IMHotkeyProfileList *get_profile_list() const 
    { return &profile_list; }

    const int get_default_hotkey_profile_id() const
    { return default_hotkey_profile_id; }

    const int get_default_hotkey_trigger_notify_id() const
    { return default_hotkey_trigger_notify_id; }

    const int get_default_hotkey_lang_switch_id() const
    { return default_hotkey_lang_switch_id; }

    const int get_default_hotkey_cycle_lang_switch_id() const
    { return default_hotkey_cycle_lang_switch_id; }

    const int get_default_hotkey_reverse_cycle_lang_switch_id() const
    { return default_hotkey_reverse_cycle_lang_switch_id; }

    const int get_default_hotkey_super_help_id() const
    { return default_hotkey_super_help_id; }

    const int get_unique_profile_id(int le_profile_id, IMLEName *lename);
    bool init_hotkey_profile_list(IMHotkeyProfileStruct *hkps, int count);

    bool add_super_hotkey_profiles(
	const u16string &curr_input_lang,
	const IMHotkeyStruct *hotkeys,
	int n_hotkeys
    );

    IMHotkeyStruct *get_super_hotkeys(const IMKeySpecList &triggerkeys,
				      const char          *language,
				      int                 *count_hotkeys);

    int register_hotkeys(void* registerer_id, IMHotkeyList *hklist); 
    // for someone to store
    // the hotkeys 
    // returns profile_id

    const IMKeySpecList *retrieve_trigger_keys(int profile_id);

    IIIMP_hotkey* retrive_hotkeys(IIIMP_data_s *pdata_s, int count, int *profile_id); 
    // convert list to 
    // array and register
    // the hotkeys with 
    // client
    int get_num_profiles() const { return profile_list.size(); }

    void* get_registerer_id_by_profile_id(int profile_id);
    void* get_profile_id_by_registerer_id(void* registerer_id);
    
};

#endif /* not IIIMP_HOTKEY_PROFILE_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
