/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package sun.awt.im.iiimp;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

import com.sun.iiim.*;

class ManageRule {

    private final static String PROTOCOL_DRIVER_NAME =
	"sun.awt.im.iiimp.ProtocolDriver";

    private final static String DEFAULT_PCE_RULE =
	"sun/awt/im/iiimp/sample.lwesyntax";

    private String ruleString = null;

    ManageRule(String rule) {
	ruleString = rule;
	parseRule(ruleString);
    }

    ManageRule(InputStreamReader reader) {
	StringBuffer sb = new StringBuffer();
	int ch;
	try {
	    for (; (ch = reader.read()) != -1;) {
		sb.append((char)ch);
	    }
	} catch(Exception e) {}
	ruleString = sb.toString();
	parseRule(ruleString);
    }

    public String toString() {
	return ruleString;
    }

    int size() {
	return imVector.size();
    }

    boolean contains(Object o) {
	Class c1 = o.getClass();
	for (int i = 0; i < imVector.size(); i++) {
	    Class c2 = imVector.get(i).getClass();
	    if (c1 == c2) {
		return true;
	    }
	}
	return false;
    }

    IIIMListener get(int i) {
	return (IIIMListener)imVector.get(i);
    }

    private Vector imVector;

    private PCE pce;
    private String ccdef;

    void setCCDEF(String ccdef) {
	this.ccdef = ccdef;
	if (pce != null) {
	    try {
		pce.pushSyntax(new LWESyntax(ccdef));
	    } catch(InvalidSyntaxException e) {
		debug(" err = " + e);
	    }
	}
    }

    private void parseRule(String ruleString) {
	imVector = new Vector();

	StringTokenizer st = new StringTokenizer(ruleString);
	imVector = new Vector();

	while(st.hasMoreTokens()) {
	    String className = st.nextToken();
	    Object obj;

	    try {
		if (className.equals(PROTOCOL_DRIVER_NAME)) {
		    obj = ProtocolDriver.getInstance();
		} else {
		    obj = Class.forName(className).newInstance();
		}
	    } catch(Exception e) {
		// ignore invalid entry in the rule
		continue;
	    }
	    if (obj == null) {
		continue;
	    }
	    if (obj instanceof IIIMListener) {
		if (obj instanceof PCE) {
		    // PCE setup
		    pce = (PCE)obj;
		    LWESyntax syntax = null;
		    if (ccdef == null) {
			ClassLoader loader = ClassLoader.getSystemClassLoader();
			InputStream is = loader.getResourceAsStream
			    (DEFAULT_PCE_RULE);
			InputStreamReader reader = new InputStreamReader(is);
			try {
			    syntax = new LWESyntax(reader);
			} catch(InvalidSyntaxException e) {
			    debug(" err : " + e);
			    continue;
			}
		    } else {
			try {
			    syntax = new LWESyntax(ccdef);
			} catch(InvalidSyntaxException e) {
			    debug(" err : " + e);
			    continue;
			}
		    }
		    ((PCE)obj).pushSyntax(syntax);
		} else if (obj instanceof ProtocolDriver) {
		    Manager.setPD((ProtocolDriver)obj);
		}
		imVector.add(obj);
	    }
	}
    }

    private void debug(String str) {
	if (Manager.DEBUG) {
	    System.err.println(str);
	}
    }
}
