/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package sun.awt.im.iiimp;

import java.awt.*;
import java.awt.im.*;
import java.awt.event.*;
import java.awt.font.TextHitInfo;
import com.sun.iiim.*;

class LookupWindow extends IIIMWindow implements IIIMLookupListener {

    // Window's default position in root window style
    private static final int LocateX;
    private static final int LocateY;
    // Create separated or composite window flexibility
    private LookupPane pane;
    // Input style
    private String style;
    // offset value
    private int offset = 24;
   
    int columHeight, columWidth;
    FontMetrics fm;

    static {
	Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        LocateX = (d.width*8/9);
        LocateY = (d.height*8/9); 
    }
    
    // No argument constructor, it is necessary for downloading
    public LookupWindow() {
        style = Manager.getProperty("iiimf.preedit.style");
        if(style == null) style = "ROOTWINDOW";      
        
        init();
    }
    
    void init() {
        window = new EventWindow(this);
                
	Font font = new Font("Monospaced", Font.PLAIN, 12);
	
        fm = window.getFontMetrics(font);
        int fontHeight = fm.getHeight();
        int fontWidth = fm.getMaxAdvance();
        int fontAscent = fm.getAscent();
        columWidth = fontWidth ;
        columHeight = fontHeight + 2;
        	
        window.setFont(font);
	
        pane = new LookupPane();
        pane.setFont(font);
        window.add(pane);

	window.pack();
    }
    
    protected void dispatchActionEvent(IIIMActionEvent e) {
	super.dispatchActionEvent(e);
    }

    // Listener method
    public void lookupStart(IIIMLookupEvent e) {
	if (pane == null) {
	    init();
	}
	pane.setTarget(getClientComponent());
	pane.setLookupWindow(this);
        pane.handleEvent(e);
    }

    public void lookupDone(IIIMLookupEvent e) {
        pane.handleEvent(e);
	window.setVisible(false);
    }

    public void lookupDraw(IIIMLookupEvent e) {
        pane.handleEvent(e);
	setTitle(e.getTitle());
	window.setSize(window.getPreferredSize());
	calculatePosition();  
	window.setVisible(true);
    }

    public void lookupProcess(IIIMLookupEvent e) {
        pane.handleEvent(e);
    }
    
    public void setStyle(String style) {
        this.style = style;
    }
    
    public String getStyle() {
        return style;
    }
    
    void setLocation(int x, int y) {
        window.setLocation(x,y);
    }
    
    void calculatePosition() {
        Component component = getClientComponent();
        
        Component frame = component;
        Insets inset = window.getInsets();
        
        while(!(frame instanceof Frame) && !(frame instanceof Dialog)) {
	    frame = frame.getParent();
	}
        
        if(style.equals("BELOWSPOT") 
            && component instanceof InputMethodRequests) {
                Rectangle rect = 
                    ((InputMethodRequests)component).getTextLocation(TextHitInfo.leading(0));
                Point point = new Point();
                point.x = rect.x;
                point.y = rect.y + (int)rect.getHeight() + offset;
                // Leave space for Preedit window
                point.y += (inset.top + inset.bottom + fm.getHeight());
                window.setLocation(point);            
        /*
         * ONSPOT style can used as root window
        else if(style.equals("ONSPOT") 
            && component instanceof InputMethodRequests) {
        */
        } else  {
            // For "ROOTWINDOW" style and component isn't InputMethodRequests
            // Place the window on the left-corner of client component
            
            Point point = frame.getLocation();
            Dimension size = frame.getSize();     

            double x = point.getX();
            // It must leave the position for PreeditWindow
            double y = point.getY() + size.getHeight() 
                + inset.top + inset.bottom + fm.getHeight();
            
            window.setLocation((int)x, (int)y);
            
  
        }
        
            // If window is out of screen, adjust it
            Point location = window.getLocation();
            double xl = location.getX();
            double yl = location.getY();
            Dimension dm = window.getSize();
            if((xl + dm.getWidth()) > screenWidth) 
                xl = screenWidth - dm.getWidth();
            if((yl + dm.getHeight()) > screenHeight) 
                yl = screenHeight - dm.getHeight();
            window.setLocation((int)xl, (int)yl);                  
    }
    
    synchronized void show() {
        if(window == null) init();
        window.setVisible(true);
    }
    
    private void setTitle(String str) {
        ((Dialog)window).setTitle(str);
    }
}
