/* GNOME INPUT METHOD SWITCHER
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include <signal.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkdrawingarea.h>
#include <gtk/gtksignal.h>
#include <panel-applet.h>
#include <gnome.h>

#include "gnome-im-switcher.h"
#include "widgets.h"
#include "preference.h"
#include "iiim-interface.h"

static gboolean
gimlet_applet_new (PanelApplet *applet, gpointer data)
{
  GimletWindow *gimlet;

#ifdef HAS_IIIM_PROPERTIES
  /*
   * This prevents invalid language list of gimlet
   * in the locale which has no runnning iiimd and
   * user's preference already exist in gconf registry
   * at different iiimd running locale.
   */
  char *pathname = "/usr/lib/iiim/iiimx-settings-init";
  /*
   * prevent the child process from becoming zombie process
   */
  struct sigaction sa;

  sa.sa_handler = SIG_IGN;
  sa.sa_flags = SA_NOCLDWAIT;
  sigemptyset (&sa.sa_mask);
  sigaction (SIGCHLD, &sa, NULL);

  if (access (pathname, X_OK) == 0)
    {
      pid_t pid;
      pid = fork();
      if (pid == 0)
	{
	  char *argv[2];
	  argv[0] = "iiimx-settings-init";
	  argv[1] = NULL;
	  execv (pathname, argv);
	  _exit(1);
	}
    }
#endif /* HAS_IIIM_PROPERTIES */  

  gimlet = g_new0 (GimletWindow, 1);

  gimlet->applet = applet;

  /* default preference settings */
  gimlet->conversion_on_start = TRUE;
  gimlet->input_lang_policy = FOLLOW_QUICK_ACCESS_MENU;

  gimlet->conversion_mode = FALSE;

  gimlet_preference_init (gimlet);

  gimlet_iiim_selection_set (gimlet);

  gimlet_init (gimlet);

  return TRUE;
}

static gboolean
imswitcher_applet_factory (PanelApplet *applet,
			   const gchar *iid, gpointer data)
{
  gboolean retval = FALSE;
	
  if (strcmp (iid, "OAFIID:GNOME_imswitcher") != 0)
    return FALSE;

  retval = gimlet_applet_new (applet, data);
	
  return retval;
}

PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_imswitcher_Factory",
                             PANEL_TYPE_APPLET,
                             "GNOME Input Method Applet",
                             "0",
                             imswitcher_applet_factory,
                             NULL);

