/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.surround.ISurroundWithTryCatchQuery;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryCatchRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class SurroundWithTryCatchAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public SurroundWithTryCatchAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.SurroundWithTryCatchAction_label);
        this.fEditor = editor;
        this.setEnabled(this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.surround_with_try_catch_action");
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        ICompilationUnit cu = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
        if (cu == null || !ElementValidator.checkValidateEdit((IJavaElement)cu, this.getShell(), SurroundWithTryCatchAction.getDialogTitle())) {
            return;
        }
        SurroundWithTryCatchRefactoring refactoring = SurroundWithTryCatchRefactoring.create(cu, selection, new Query(this.getShell()));
        if (refactoring == null) {
            return;
        }
        try {
            RefactoringStatus status = refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            if (status.hasFatalError()) {
                RefactoringStatusEntry entry = status.getEntryMatchingSeverity(4);
                MessageDialog.openInformation((Shell)this.getShell(), (String)SurroundWithTryCatchAction.getDialogTitle(), (String)entry.getMessage());
                if (entry.getContext() instanceof JavaStatusContext && this.fEditor != null) {
                    JavaStatusContext context = (JavaStatusContext)entry.getContext();
                    ISourceRange range = context.getSourceRange();
                    this.fEditor.setHighlightRange(range.getOffset(), range.getLength(), true);
                }
                return;
            }
            if (refactoring.stopExecution()) {
                return;
            }
            Change change = refactoring.createChange((IProgressMonitor)new NullProgressMonitor());
            change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
            PerformChangeOperation op = RefactoringUI.createUIAwareChangeOperation((Change)change);
            WorkbenchRunnableAdapter adapter = new WorkbenchRunnableAdapter((IWorkspaceRunnable)op);
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)new BusyIndicatorRunnableContext(), (IRunnableWithProgress)adapter, adapter.getSchedulingRule());
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, SurroundWithTryCatchAction.getDialogTitle(), RefactoringMessages.SurroundWithTryCatchAction_exception);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, SurroundWithTryCatchAction.getDialogTitle(), RefactoringMessages.SurroundWithTryCatchAction_exception);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(selection.getLength() > 0 && this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    private static String getDialogTitle() {
        return RefactoringMessages.SurroundWithTryCatchAction_dialog_title;
    }

    private static class Query
    implements ISurroundWithTryCatchQuery {
        private Shell fParent;

        public Query(Shell shell) {
            this.fParent = shell;
        }

        public boolean catchRuntimeException() {
            MessageDialog dialog = new MessageDialog(this, this.fParent, SurroundWithTryCatchAction.getDialogTitle(), null, RefactoringMessages.SurroundWithTryCatchAction_no_exceptions, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1){
                final /* synthetic */ Query this$1;
                {
                    this.this$1 = query;
                }

                protected void createButtonsForButtonBar(Composite parent) {
                    super.createButtonsForButtonBar(parent);
                    Button button = this.getButton(1);
                    if (button != null) {
                        button.setFocus();
                    }
                }
            };
            return dialog.open() == 0;
        }
    }
}

