/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;

public class OpenPropertiesWorkingSetAction
extends SelectionDispatchAction {
    public OpenPropertiesWorkingSetAction(IWorkbenchSite site) {
        super(site);
        this.setText(WorkingSetMessages.OpenPropertiesWorkingSetAction_label);
        this.setEnabled(false);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.getWorkingSet(selection) != null);
    }

    private IWorkingSet getWorkingSet(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IWorkingSet)) {
            return null;
        }
        IWorkingSet ws = (IWorkingSet)element;
        if (!ws.isEditable()) {
            return null;
        }
        return ws;
    }

    public void run(IStructuredSelection selection) {
        IWorkingSet ws = this.getWorkingSet(selection);
        if (ws == null) {
            return;
        }
        IWorkingSetEditWizard wizard = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetEditWizard(ws);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }
}

