/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;

public class JavaParameterListValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private int fPosition;
    private ITextViewer fViewer;
    private IContextInformation fInformation;
    private int fCurrentParameter;

    public void install(IContextInformation info, ITextViewer viewer, int documentPosition) {
        this.fPosition = documentPosition;
        this.fViewer = viewer;
        this.fInformation = info;
        this.fCurrentParameter = -1;
    }

    private int getCommentEnd(IDocument d, int pos, int end) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            if (curr != '*' || ++pos >= end || d.getChar(pos) != '/') continue;
            return pos + 1;
        }
        return end;
    }

    private int getStringEnd(IDocument d, int pos, int end, char ch) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            ++pos;
            if (curr == '\\') {
                ++pos;
                continue;
            }
            if (curr != ch) continue;
            return pos;
        }
        return end;
    }

    private int getCharCount(IDocument document, int start, int end, String increments, String decrements, boolean considerNesting) throws BadLocationException {
        Assert.isTrue(((increments.length() != 0 || decrements.length() != 0) && !increments.equals(decrements) ? 1 : 0) != 0);
        int nestingMode = 0;
        int nestingLevel = 0;
        int charCount = 0;
        int offset = start;
        block13: while (offset < end) {
            char curr = document.getChar(offset++);
            switch (curr) {
                case '/': {
                    if (offset >= end) continue block13;
                    char next = document.getChar(offset);
                    if (next == '*') {
                        offset = this.getCommentEnd(document, offset + 1, end);
                        break;
                    }
                    if (next != '/') continue block13;
                    offset = end;
                    break;
                }
                case '*': {
                    char next;
                    if (offset >= end || (next = document.getChar(offset)) != '/') continue block13;
                    charCount = 0;
                    ++offset;
                    break;
                }
                case '\"': 
                case '\'': {
                    offset = this.getStringEnd(document, offset, end, curr);
                    break;
                }
                case '[': {
                    if (considerNesting) {
                        if (nestingMode != 1 && nestingMode != 0) continue block13;
                        nestingMode = 1;
                        ++nestingLevel;
                        break;
                    }
                }
                case ']': {
                    if (considerNesting) {
                        if (nestingMode != true || --nestingLevel != 0) continue block13;
                        nestingMode = 0;
                        break;
                    }
                }
                case '(': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 3;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 3 && nestingMode != 0) continue block13;
                        nestingMode = 3;
                        ++nestingLevel;
                        break;
                    }
                }
                case ')': {
                    if (considerNesting) {
                        if (nestingMode != 3 || --nestingLevel != 0) continue block13;
                        nestingMode = 0;
                        break;
                    }
                }
                case '{': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 2;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 2 && nestingMode != 0) continue block13;
                        nestingMode = 2;
                        ++nestingLevel;
                        break;
                    }
                }
                case '}': {
                    if (considerNesting) {
                        if (nestingMode != 2 || --nestingLevel != 0) continue block13;
                        nestingMode = 0;
                        break;
                    }
                }
                case '<': {
                    if (considerNesting) {
                        if (nestingMode != 4 && (nestingMode != 0 || !this.checkGenericsHeuristic(document, offset - 1, start - 1))) continue block13;
                        nestingMode = 4;
                        ++nestingLevel;
                        break;
                    }
                }
                case '>': {
                    if (considerNesting) {
                        if (nestingMode != 4 || --nestingLevel != 0) continue block13;
                        nestingMode = 0;
                        break;
                    }
                }
                default: {
                    if (nestingLevel != 0) continue block13;
                    if (increments.indexOf(curr) >= 0) {
                        ++charCount;
                    }
                    if (decrements.indexOf(curr) < 0) continue block13;
                    --charCount;
                }
            }
        }
        return charCount;
    }

    private boolean checkGenericsHeuristic(IDocument document, int end, int bound) throws BadLocationException {
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        return scanner.looksLikeClassInstanceCreationBackward(end, bound);
    }

    public boolean isContextInformationValid(int position) {
        IDocument document;
        block5: {
            block4: {
                try {
                    if (position >= this.fPosition) break block4;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            document = this.fViewer.getDocument();
            IRegion line = document.getLineInformationOfOffset(this.fPosition);
            if (position >= line.getOffset() && position < document.getLength()) break block5;
            return false;
        }
        return this.getCharCount(document, this.fPosition, position, "(<", ")>", false) >= 0;
    }

    public boolean updatePresentation(int position, TextPresentation presentation) {
        int currentParameter = -1;
        try {
            currentParameter = this.getCharCount(this.fViewer.getDocument(), this.fPosition, position, ",", "", true);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (this.fCurrentParameter != -1 && currentParameter == this.fCurrentParameter) {
            return false;
        }
        presentation.clear();
        this.fCurrentParameter = currentParameter;
        String s = this.fInformation.getInformationDisplayString();
        int[] commas = this.computeCommaPositions(s);
        if (commas.length - 2 < this.fCurrentParameter) {
            presentation.addStyleRange(new StyleRange(0, s.length(), null, null, 0));
            return true;
        }
        int start = commas[this.fCurrentParameter] + 1;
        int end = commas[this.fCurrentParameter + 1];
        if (start > 0) {
            presentation.addStyleRange(new StyleRange(0, start, null, null, 0));
        }
        if (end > start) {
            presentation.addStyleRange(new StyleRange(start, end - start, null, null, 1));
        }
        if (end < s.length()) {
            presentation.addStyleRange(new StyleRange(end, s.length() - end, null, null, 0));
        }
        return true;
    }

    private int[] computeCommaPositions(String code) {
        int length = code.length();
        int pos = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        positions.add(new Integer(-1));
        while (pos < length && pos != -1) {
            char ch = code.charAt(pos);
            switch (ch) {
                case ',': {
                    positions.add(new Integer(pos));
                    break;
                }
                case '<': {
                    pos = code.indexOf(62, pos);
                    break;
                }
                case '[': {
                    pos = code.indexOf(93, pos);
                    break;
                }
            }
            if (pos == -1) continue;
            ++pos;
        }
        positions.add(new Integer(length));
        int[] fields = new int[positions.size()];
        int i = 0;
        while (i < fields.length) {
            fields[i] = (Integer)positions.get(i);
            ++i;
        }
        return fields;
    }
}

