/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class InterfaceIndicatorLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private ListenerList fListeners;
    private IElementChangedListener fChangeListener;

    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fChangeListener == null) {
            this.fChangeListener = new IntefaceIndicatorChangeListener();
            JavaCore.addElementChangedListener((IElementChangedListener)this.fChangeListener);
        }
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    public void dispose() {
        if (this.fChangeListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fChangeListener);
            this.fChangeListener = null;
        }
        if (this.fListeners != null) {
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                this.fListeners.remove(listeners[i]);
                ++i;
            }
            this.fListeners = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove((Object)listener);
        if (this.fListeners.isEmpty() && this.fChangeListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fChangeListener);
            this.fChangeListener = null;
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        try {
            ImageDescriptor overlay = this.getOverlay(element);
            if (overlay == null) {
                return;
            }
            decoration.addOverlay(overlay, 1);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }

    private ImageDescriptor getOverlay(Object element) throws JavaModelException {
        if (element instanceof ICompilationUnit) {
            ICompilationUnit unit = (ICompilationUnit)element;
            if (unit.isOpen()) {
                IType mainType = unit.findPrimaryType();
                if (mainType != null) {
                    return this.getOverlayFromFlags(mainType.getFlags());
                }
                return null;
            }
            String typeName = JavaCore.removeJavaLikeExtension((String)unit.getElementName());
            return this.getOverlayWithSearchEngine((ITypeRoot)unit, typeName);
        }
        if (element instanceof IClassFile) {
            IClassFile classFile = (IClassFile)element;
            if (classFile.isOpen()) {
                return this.getOverlayFromFlags(classFile.getType().getFlags());
            }
            String typeName = classFile.getType().getElementName();
            return this.getOverlayWithSearchEngine((ITypeRoot)classFile, typeName);
        }
        return null;
    }

    private ImageDescriptor getOverlayWithSearchEngine(ITypeRoot element, String typeName) {
        class Result
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            int modifiers;

            public Result(int modifiers) {
                this.modifiers = modifiers;
            }
        }
        SearchEngine engine = new SearchEngine();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{element});
        TypeNameRequestor requestor = new TypeNameRequestor(){

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                if (enclosingTypeNames.length == 0 && Flags.isPublic((int)modifiers)) {
                    throw new Result(modifiers);
                }
            }
        };
        try {
            String packName = element.getParent().getElementName();
            int matchRule = 8;
            engine.searchAllTypeNames(packName.toCharArray(), matchRule, typeName.toCharArray(), matchRule, 0, scope, requestor, 3, null);
        }
        catch (Result e) {
            return this.getOverlayFromFlags(e.modifiers);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private ImageDescriptor getOverlayFromFlags(int flags) {
        if (Flags.isAnnotation((int)flags)) {
            return JavaPluginImages.DESC_OVR_ANNOTATION;
        }
        if (Flags.isEnum((int)flags)) {
            return JavaPluginImages.DESC_OVR_ENUM;
        }
        if (Flags.isInterface((int)flags)) {
            return JavaPluginImages.DESC_OVR_INTERFACE;
        }
        if (Flags.isAbstract((int)flags)) {
            return JavaPluginImages.DESC_OVR_ABSTRACT_CLASS;
        }
        return null;
    }

    private void fireChange(IJavaElement[] elements) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object[])elements);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    private void processDelta(IJavaElementDelta delta, List result) {
        IJavaElement elem = delta.getElement();
        boolean isChanged = delta.getKind() == 4;
        boolean isRemoved = delta.getKind() == 2;
        int flags = delta.getFlags();
        switch (elem.getElementType()) {
            case 2: {
                if (isRemoved || isChanged && (flags & 0x400) != 0) {
                    return;
                }
                this.processChildrenDelta(delta, result);
                return;
            }
            case 3: {
                if (isRemoved || isChanged && ((flags & 0x8000) != 0 || (flags & 0x80) != 0)) {
                    return;
                }
                this.processChildrenDelta(delta, result);
                return;
            }
            case 4: {
                if (isRemoved) {
                    return;
                }
                this.processChildrenDelta(delta, result);
                return;
            }
            case 6: 
            case 7: {
                return;
            }
            case 1: {
                this.processChildrenDelta(delta, result);
                return;
            }
            case 5: {
                if (!JavaModelUtil.isPrimary((ICompilationUnit)elem)) {
                    return;
                }
                if (isChanged && ((flags & 1) != 0 || (flags & 0x4000) != 0)) {
                    if (delta.getAffectedChildren().length == 0) {
                        return;
                    }
                    result.add(elem);
                }
                return;
            }
        }
    }

    private boolean processChildrenDelta(IJavaElementDelta delta, List result) {
        IJavaElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processDelta(children[i], result);
            ++i;
        }
        return false;
    }

    private class IntefaceIndicatorChangeListener
    implements IElementChangedListener {
        private IntefaceIndicatorChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            ArrayList changed = new ArrayList();
            InterfaceIndicatorLabelDecorator.this.processDelta(event.getDelta(), changed);
            if (changed.size() == 0) {
                return;
            }
            InterfaceIndicatorLabelDecorator.this.fireChange(changed.toArray(new IJavaElement[changed.size()]));
        }
    }
}

