/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ParameterObjectFactory {
    private String fClassName;
    private ICompilationUnit fCompilationUnit;
    private boolean fCreateComments;
    private boolean fCreateGetter;
    private boolean fCreateSetter;
    private String fEnclosingType;
    private String fPackage;
    private List fVariables;

    public ParameterObjectFactory(ICompilationUnit cu) {
        this.fCompilationUnit = cu;
        this.fCreateComments = StubUtility.doAddComments(cu.getJavaProject());
    }

    public RefactoringStatus checkConditions() {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(Checks.checkTypeName(this.fClassName));
        return result;
    }

    public TypeDeclaration createClassDeclaration(ICompilationUnit unit, String declaringType, CompilationUnitRewrite cuRewrite) throws CoreException {
        AST ast = cuRewrite.getAST();
        TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
        typeDeclaration.setName(ast.newSimpleName(this.fClassName));
        List body = typeDeclaration.bodyDeclarations();
        Iterator iter = this.fVariables.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            if (!this.isValidField(pi)) continue;
            FieldDeclaration declaration = this.createField(pi, unit, cuRewrite);
            body.add(declaration);
        }
        MethodDeclaration constructor = this.createConstructor(unit, declaringType, cuRewrite);
        body.add(constructor);
        Iterator iter2 = this.fVariables.iterator();
        while (iter2.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter2.next();
            if (this.fCreateGetter && this.isValidField(pi)) {
                ASTNode getter = this.createGetter(pi, declaringType, unit, cuRewrite);
                body.add(getter);
            }
            if (!this.fCreateSetter || !this.isValidField(pi) || Modifier.isFinal((int)pi.getOldBinding().getModifiers())) continue;
            ASTNode setter = this.createSetter(pi, declaringType, unit, cuRewrite);
            body.add(setter);
        }
        return typeDeclaration;
    }

    private MethodDeclaration createConstructor(ICompilationUnit unit, String declaringTypeName, CompilationUnitRewrite cuRewrite) throws CoreException {
        String comment;
        AST ast = cuRewrite.getAST();
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        methodDeclaration.setName(ast.newSimpleName(this.fClassName));
        methodDeclaration.setConstructor(true);
        methodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        if (this.fCreateComments && (comment = CodeGeneration.getMethodComment(unit, declaringTypeName, methodDeclaration, null, lineDelimiter)) != null) {
            Javadoc doc = (Javadoc)cuRewrite.getASTRewrite().createStringPlaceholder(comment, 29);
            methodDeclaration.setJavadoc(doc);
        }
        List parameters = methodDeclaration.parameters();
        Block block = ast.newBlock();
        methodDeclaration.setBody(block);
        List statements = block.statements();
        ArrayList<ParameterInfo> validParameter = new ArrayList<ParameterInfo>();
        Iterator iter = this.fVariables.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            if (!this.isValidField(pi)) continue;
            validParameter.add(pi);
        }
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        Iterator iter2 = validParameter.iterator();
        while (iter2.hasNext()) {
            SimpleName leftHandSide;
            ParameterInfo pi = (ParameterInfo)iter2.next();
            SingleVariableDeclaration svd = ast.newSingleVariableDeclaration();
            ITypeBinding typeBinding = pi.getNewTypeBinding();
            if (!iter2.hasNext() && typeBinding.isArray() && pi.isOldVarargs()) {
                int dimensions = typeBinding.getDimensions();
                typeBinding = dimensions == 1 ? typeBinding.getComponentType() : typeBinding.createArrayType(dimensions - 1);
                svd.setVarargs(true);
            }
            String paramName = this.getParameterName(pi);
            Type fieldType = this.importBinding(typeBinding, cuRewrite);
            svd.setType(fieldType);
            svd.setName(ast.newSimpleName(paramName));
            parameters.add(svd);
            if (paramName.equals(pi.getNewName()) || StubUtility.useThisForFieldAccess(project)) {
                FieldAccess fieldAccess = ast.newFieldAccess();
                fieldAccess.setName(ast.newSimpleName(pi.getNewName()));
                fieldAccess.setExpression((Expression)ast.newThisExpression());
                leftHandSide = fieldAccess;
            } else {
                leftHandSide = ast.newSimpleName(pi.getNewName());
            }
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide((Expression)leftHandSide);
            assignment.setRightHandSide((Expression)ast.newSimpleName(paramName));
            statements.add(ast.newExpressionStatement((Expression)assignment));
        }
        return methodDeclaration;
    }

    private String getParameterName(ParameterInfo pi) {
        String fieldName = pi.getNewName();
        String strippedName = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)this.fCompilationUnit.getJavaProject(), (String)fieldName, (int)0);
        String[] suggestions = StubUtility.getVariableNameSuggestions(4, this.fCompilationUnit.getJavaProject(), strippedName, 0, null, true);
        return suggestions[0];
    }

    private Type importBinding(ITypeBinding typeBinding, CompilationUnitRewrite cuRewrite) {
        Type type = cuRewrite.getImportRewrite().addImport(typeBinding, cuRewrite.getAST());
        cuRewrite.getImportRemover().registerAddedImports(type);
        return type;
    }

    private FieldDeclaration createField(ParameterInfo pi, ICompilationUnit unit, CompilationUnitRewrite cuRewrite) throws CoreException {
        String comment;
        AST ast = cuRewrite.getAST();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        SimpleName fieldName = ast.newSimpleName(pi.getNewName());
        fragment.setName(fieldName);
        FieldDeclaration declaration = ast.newFieldDeclaration(fragment);
        if (this.fCreateComments && (comment = StubUtility.getFieldComment(unit, pi.getNewTypeName(), pi.getNewName(), lineDelim)) != null) {
            Javadoc doc = (Javadoc)cuRewrite.getASTRewrite().createStringPlaceholder(comment, 29);
            declaration.setJavadoc(doc);
        }
        int visibility = 1;
        if (this.fCreateGetter) {
            visibility = 2;
        }
        List modifiers = ast.newModifiers(visibility);
        declaration.modifiers().addAll(modifiers);
        declaration.setType(this.importBinding(pi.getNewTypeBinding(), cuRewrite));
        return declaration;
    }

    public Expression createFieldReadAccess(ParameterInfo pi, String paramName, AST ast) {
        if (!this.fCreateGetter) {
            return ast.newName(new String[]{paramName, pi.getNewName()});
        }
        MethodInvocation method = ast.newMethodInvocation();
        method.setName(ast.newSimpleName(this.getGetterName(pi, ast)));
        method.setExpression((Expression)ast.newSimpleName(paramName));
        return method;
    }

    private ASTNode createGetter(ParameterInfo pi, String declaringType, ICompilationUnit cu, CompilationUnitRewrite cuRewrite) throws CoreException {
        String comment;
        AST ast = cuRewrite.getAST();
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        String fieldName = pi.getNewName();
        String getterName = this.getGetterName(pi, ast);
        String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)cu);
        String bareFieldname = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)cu.getJavaProject(), (String)fieldName, (int)2);
        if (this.fCreateComments && (comment = CodeGeneration.getGetterComment(cu, declaringType, getterName, fieldName, pi.getNewTypeName(), bareFieldname, lineDelim)) != null) {
            methodDeclaration.setJavadoc((Javadoc)cuRewrite.getASTRewrite().createStringPlaceholder(comment, 29));
        }
        methodDeclaration.setName(ast.newSimpleName(getterName));
        methodDeclaration.setReturnType2(this.importBinding(pi.getNewTypeBinding(), cuRewrite));
        methodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        Block block = ast.newBlock();
        methodDeclaration.setBody(block);
        boolean useThis = StubUtility.useThisForFieldAccess(cu.getJavaProject());
        if (useThis) {
            fieldName = "this." + fieldName;
        }
        String bodyContent = CodeGeneration.getGetterMethodBodyContent(cu, declaringType, getterName, fieldName, lineDelim);
        ASTNode getterBody = cuRewrite.getASTRewrite().createStringPlaceholder(bodyContent, 21);
        block.statements().add(getterBody);
        return methodDeclaration;
    }

    public ExpressionStatement createInitializer(ParameterInfo pi, String paramName, CompilationUnitRewrite cuRewrite) {
        AST ast = cuRewrite.getAST();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName(pi.getOldName()));
        fragment.setInitializer(this.createFieldReadAccess(pi, paramName, ast));
        VariableDeclarationExpression declaration = ast.newVariableDeclarationExpression(fragment);
        IVariableBinding variable = pi.getOldBinding();
        declaration.setType(this.importBinding(pi.getNewTypeBinding(), cuRewrite));
        int modifiers = variable.getModifiers();
        List newModifiers = ast.newModifiers(modifiers);
        declaration.modifiers().addAll(newModifiers);
        return ast.newExpressionStatement((Expression)declaration);
    }

    private ASTNode createSetter(ParameterInfo pi, String declaringType, ICompilationUnit cu, CompilationUnitRewrite cuRewrite) throws CoreException {
        String comment;
        AST ast = cuRewrite.getAST();
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        String fieldName = pi.getNewName();
        String setterName = this.getSetterName(pi, ast);
        String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)cu);
        String bareFieldname = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)cu.getJavaProject(), (String)fieldName, (int)2);
        String paramName = StubUtility.suggestArgumentName(cu.getJavaProject(), bareFieldname, null);
        if (this.fCreateComments && (comment = CodeGeneration.getSetterComment(cu, declaringType, setterName, fieldName, pi.getNewTypeName(), paramName, bareFieldname, lineDelim)) != null) {
            methodDeclaration.setJavadoc((Javadoc)cuRewrite.getASTRewrite().createStringPlaceholder(comment, 29));
        }
        methodDeclaration.setName(ast.newSimpleName(setterName));
        methodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        SingleVariableDeclaration variable = ast.newSingleVariableDeclaration();
        variable.setType(this.importBinding(pi.getNewTypeBinding(), cuRewrite));
        variable.setName(ast.newSimpleName(paramName));
        methodDeclaration.parameters().add(variable);
        Block block = ast.newBlock();
        methodDeclaration.setBody(block);
        boolean useThis = StubUtility.useThisForFieldAccess(cu.getJavaProject());
        if (useThis || fieldName.equals(paramName)) {
            fieldName = "this." + fieldName;
        }
        String bodyContent = CodeGeneration.getSetterMethodBodyContent(this.fCompilationUnit, declaringType, setterName, fieldName, paramName, lineDelim);
        ASTNode setterBody = cuRewrite.getASTRewrite().createStringPlaceholder(bodyContent, 21);
        block.statements().add(setterBody);
        return methodDeclaration;
    }

    public Type createType(boolean asTopLevelClass, CompilationUnitRewrite cuRewrite, int position) {
        String concatenateName = null;
        concatenateName = asTopLevelClass ? JavaModelUtil.concatenateName(this.fPackage, this.fClassName) : JavaModelUtil.concatenateName(this.fEnclosingType, this.fClassName);
        ImportRewrite importRewrite = cuRewrite.getImportRewrite();
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(cuRewrite.getRoot(), position, importRewrite);
        String addedImport = importRewrite.addImport(concatenateName, (ImportRewrite.ImportRewriteContext)context);
        cuRewrite.getImportRemover().registerAddedImport(addedImport);
        AST ast = cuRewrite.getAST();
        return ast.newSimpleType(ast.newName(addedImport));
    }

    public String getClassName() {
        return this.fClassName;
    }

    public String getEnclosingType() {
        return this.fEnclosingType;
    }

    private String getGetterName(ParameterInfo pi, AST ast) {
        return this.suggestGetterName(pi, ast);
    }

    public String getPackage() {
        return this.fPackage;
    }

    public ParameterInfo getParameterInfo(String identifier) {
        Iterator iter = this.fVariables.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            if (!pi.getOldName().equals(identifier)) continue;
            return pi;
        }
        return null;
    }

    private String getSetterName(ParameterInfo pi, AST ast) {
        return this.suggestSetterName(pi, ast);
    }

    public boolean isCreateComments() {
        return this.fCreateComments;
    }

    public boolean isCreateGetter() {
        return this.fCreateGetter;
    }

    public boolean isCreateSetter() {
        return this.fCreateSetter;
    }

    private boolean isValidField(ParameterInfo pi) {
        return pi.isCreateField() && !pi.isAdded();
    }

    public void moveDown(ParameterInfo selected) {
        int idx = this.fVariables.indexOf(selected);
        Assert.isTrue((idx >= 0 && idx < this.fVariables.size() - 1 ? 1 : 0) != 0);
        int nextIdx = idx + 1;
        ParameterInfo next = (ParameterInfo)this.fVariables.get(nextIdx);
        if (next.isAdded()) {
            Assert.isTrue((++nextIdx <= this.fVariables.size() - 1 ? 1 : 0) != 0);
            next = (ParameterInfo)this.fVariables.get(nextIdx);
        }
        this.fVariables.set(idx, next);
        this.fVariables.set(nextIdx, selected);
    }

    public void moveUp(ParameterInfo selected) {
        int idx = this.fVariables.indexOf(selected);
        Assert.isTrue((idx > 0 ? 1 : 0) != 0);
        int prevIdx = idx - 1;
        ParameterInfo prev = (ParameterInfo)this.fVariables.get(prevIdx);
        if (prev.isAdded()) {
            Assert.isTrue((--prevIdx >= 0 ? 1 : 0) != 0);
            prev = (ParameterInfo)this.fVariables.get(prevIdx);
        }
        this.fVariables.set(idx, prev);
        this.fVariables.set(prevIdx, selected);
    }

    public void setClassName(String className) {
        this.fClassName = className;
    }

    public void setCreateComments(boolean selection) {
        this.fCreateComments = selection;
    }

    public void setCreateGetter(boolean createGetter) {
        this.fCreateGetter = createGetter;
    }

    public void setCreateSetter(boolean createSetter) {
        this.fCreateSetter = createSetter;
    }

    public void setEnclosingType(String enclosingType) {
        this.fEnclosingType = enclosingType;
    }

    public void setPackage(String typeQualifier) {
        this.fPackage = typeQualifier;
    }

    public void setVariables(List parameters) {
        this.fVariables = parameters;
    }

    private String suggestGetterName(ParameterInfo pi, AST ast) {
        ITypeBinding type = pi.getNewTypeBinding();
        boolean isBoolean = ast.resolveWellKnownType("boolean").isEqualTo((IBinding)type) || ast.resolveWellKnownType("java.lang.Boolean").isEqualTo((IBinding)type);
        return NamingConventions.suggestGetterName((IJavaProject)this.fCompilationUnit.getJavaProject(), (String)pi.getNewName(), (int)1, (boolean)isBoolean, null);
    }

    private String suggestSetterName(ParameterInfo pi, AST ast) {
        ITypeBinding type = pi.getNewTypeBinding();
        boolean isBoolean = ast.resolveWellKnownType("boolean").isEqualTo((IBinding)type) || ast.resolveWellKnownType("java.lang.Boolean").isEqualTo((IBinding)type);
        return NamingConventions.suggestSetterName((IJavaProject)this.fCompilationUnit.getJavaProject(), (String)pi.getNewName(), (int)1, (boolean)isBoolean, null);
    }

    public void updateParameterPosition(ParameterInfo parameterObjectReference) {
        this.fVariables.remove(parameterObjectReference);
        ListIterator<ParameterInfo> iterator = this.fVariables.listIterator();
        while (iterator.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iterator.next();
            if (!this.isValidField(pi)) continue;
            iterator.add(parameterObjectReference);
            return;
        }
    }
}

