/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.propertypages.BreakpointConditionEditor;
import org.eclipse.jdt.internal.debug.ui.propertypages.JavaBreakpointPage;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class JavaLineBreakpointPage
extends JavaBreakpointPage {
    private Button fEnableConditionButton;
    private BreakpointConditionEditor fConditionEditor;
    private Button fConditionIsTrue;
    private Button fConditionHasChanged;
    private Label fSuspendWhenLabel;
    private Button fFieldAccess;
    private Button fFieldModification;
    private Button fMethodEntry;
    private Button fMethodExit;
    private static final String fgWatchpointError = PropertyPageMessages.JavaLineBreakpointPage_0;
    private static final String fgMethodBreakpointError = PropertyPageMessages.JavaLineBreakpointPage_1;
    static /* synthetic */ Class class$0;

    protected void doStore() throws CoreException {
        IJavaLineBreakpoint breakpoint = (IJavaLineBreakpoint)this.getBreakpoint();
        super.doStore();
        if (this.fConditionEditor != null) {
            boolean enableCondition = this.fEnableConditionButton.getSelection();
            String condition = this.fConditionEditor.getCondition();
            boolean suspendOnTrue = this.fConditionIsTrue.getSelection();
            if (breakpoint.isConditionEnabled() != enableCondition) {
                breakpoint.setConditionEnabled(enableCondition);
            }
            if (!condition.equals(breakpoint.getCondition())) {
                breakpoint.setCondition(condition);
            }
            if (breakpoint.isConditionSuspendOnTrue() != suspendOnTrue) {
                breakpoint.setConditionSuspendOnTrue(suspendOnTrue);
            }
        }
        if (breakpoint instanceof IJavaWatchpoint) {
            IJavaWatchpoint watchpoint = (IJavaWatchpoint)this.getBreakpoint();
            boolean access = this.fFieldAccess.getSelection();
            boolean modification = this.fFieldModification.getSelection();
            if (access != watchpoint.isAccess()) {
                watchpoint.setAccess(access);
            }
            if (modification != watchpoint.isModification()) {
                watchpoint.setModification(modification);
            }
        }
        if (breakpoint instanceof IJavaMethodBreakpoint) {
            IJavaMethodBreakpoint methodBreakpoint = (IJavaMethodBreakpoint)this.getBreakpoint();
            boolean entry = this.fMethodEntry.getSelection();
            boolean exit = this.fMethodExit.getSelection();
            if (entry != methodBreakpoint.isEntry()) {
                methodBreakpoint.setEntry(entry);
            }
            if (exit != methodBreakpoint.isExit()) {
                methodBreakpoint.setExit(exit);
            }
        }
    }

    protected void createTypeSpecificLabels(Composite parent) {
        IJavaLineBreakpoint breakpoint = (IJavaLineBreakpoint)this.getBreakpoint();
        StringBuffer lineNumber = new StringBuffer(4);
        try {
            int lNumber = breakpoint.getLineNumber();
            if (lNumber > 0) {
                lineNumber.append(lNumber);
            }
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        if (lineNumber.length() > 0) {
            this.createLabel(parent, PropertyPageMessages.JavaLineBreakpointPage_2);
            Text text = SWTFactory.createText(parent, 8, 1, lineNumber.toString());
            text.setBackground(parent.getBackground());
        }
        try {
            IMember member = BreakpointUtils.getMember(breakpoint);
            if (member == null) {
                return;
            }
            String label = PropertyPageMessages.JavaLineBreakpointPage_3;
            if (breakpoint instanceof IJavaMethodBreakpoint) {
                label = PropertyPageMessages.JavaLineBreakpointPage_4;
            } else if (breakpoint instanceof IJavaWatchpoint) {
                label = PropertyPageMessages.JavaLineBreakpointPage_5;
            }
            this.createLabel(parent, label);
            Text text = SWTFactory.createText(parent, 8, 1, this.fJavaLabelProvider.getText((Object)member));
            text.setBackground(parent.getBackground());
        }
        catch (CoreException exception) {
            JDIDebugUIPlugin.log(exception);
        }
    }

    protected void createTypeSpecificEditors(Composite parent) throws CoreException {
        this.setTitle(PropertyPageMessages.JavaLineBreakpointPage_18);
        IJavaLineBreakpoint breakpoint = (IJavaLineBreakpoint)this.getBreakpoint();
        if (breakpoint.supportsCondition()) {
            this.createConditionEditor(parent);
        }
        if (breakpoint instanceof IJavaWatchpoint) {
            this.setTitle(PropertyPageMessages.JavaLineBreakpointPage_19);
            IJavaWatchpoint watchpoint = (IJavaWatchpoint)this.getBreakpoint();
            SelectionAdapter watchpointValidator = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    JavaLineBreakpointPage.this.validateWatchpoint();
                }
            };
            this.createLabel(parent, PropertyPageMessages.JavaLineBreakpointPage_6);
            this.fEnabledButton.addSelectionListener((SelectionListener)watchpointValidator);
            this.fFieldAccess = this.createCheckButton(parent, PropertyPageMessages.JavaLineBreakpointPage_7);
            this.fFieldAccess.setSelection(watchpoint.isAccess());
            this.fFieldAccess.addSelectionListener((SelectionListener)watchpointValidator);
            this.fFieldModification = this.createCheckButton(parent, PropertyPageMessages.JavaLineBreakpointPage_8);
            this.fFieldModification.setSelection(watchpoint.isModification());
            this.fFieldModification.addSelectionListener((SelectionListener)watchpointValidator);
        }
        if (breakpoint instanceof IJavaMethodBreakpoint) {
            this.setTitle(PropertyPageMessages.JavaLineBreakpointPage_20);
            IJavaMethodBreakpoint methodBreakpoint = (IJavaMethodBreakpoint)this.getBreakpoint();
            SelectionAdapter methodBreakpointValidator = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    JavaLineBreakpointPage.this.validateMethodBreakpoint();
                }
            };
            this.createLabel(parent, PropertyPageMessages.JavaLineBreakpointPage_9);
            this.fEnabledButton.addSelectionListener((SelectionListener)methodBreakpointValidator);
            this.fMethodEntry = this.createCheckButton(parent, PropertyPageMessages.JavaLineBreakpointPage_10);
            this.fMethodEntry.setSelection(methodBreakpoint.isEntry());
            this.fMethodEntry.addSelectionListener((SelectionListener)methodBreakpointValidator);
            this.fMethodExit = this.createCheckButton(parent, PropertyPageMessages.JavaLineBreakpointPage_11);
            this.fMethodExit.setSelection(methodBreakpoint.isExit());
            this.fMethodExit.addSelectionListener((SelectionListener)methodBreakpointValidator);
        }
    }

    private void validateWatchpoint() {
        if (this.fEnabledButton.getSelection() && !this.fFieldAccess.getSelection() && !this.fFieldModification.getSelection()) {
            this.addErrorMessage(fgWatchpointError);
        } else {
            this.removeErrorMessage(fgWatchpointError);
        }
    }

    private void validateMethodBreakpoint() {
        boolean valid = true;
        if (this.fEnabledButton.getSelection() && !this.fMethodEntry.getSelection() && !this.fMethodExit.getSelection()) {
            this.setErrorMessage(fgMethodBreakpointError);
            valid = false;
        } else {
            this.setErrorMessage(null);
        }
        this.setValid(valid);
    }

    private void createConditionEditor(Composite parent) throws CoreException {
        IJavaLineBreakpoint breakpoint = (IJavaLineBreakpoint)this.getBreakpoint();
        String label = null;
        if (BreakpointUtils.getType((IJavaBreakpoint)breakpoint) != null) {
            TriggerSequence keyBinding;
            IBindingService bindingService;
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((bindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) != null && (keyBinding = bindingService.getBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals")) != null) {
                label = MessageFormat.format((String)PropertyPageMessages.JavaLineBreakpointPage_12, (Object[])new String[]{keyBinding.format()});
            }
        }
        if (label == null) {
            label = PropertyPageMessages.JavaLineBreakpointPage_13;
        }
        Group conditionComposite = SWTFactory.createGroup(parent, "", 1, 1, 1808);
        this.fEnableConditionButton = this.createCheckButton((Composite)conditionComposite, label);
        this.fEnableConditionButton.setSelection(breakpoint.isConditionEnabled());
        this.fEnableConditionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaLineBreakpointPage.this.setConditionEnabled(JavaLineBreakpointPage.this.fEnableConditionButton.getSelection());
            }
        });
        this.fConditionEditor = new BreakpointConditionEditor((Composite)conditionComposite, this);
        this.fSuspendWhenLabel = this.createLabel((Composite)conditionComposite, PropertyPageMessages.JavaLineBreakpointPage_15);
        this.fConditionIsTrue = this.createRadioButton((Composite)conditionComposite, PropertyPageMessages.JavaLineBreakpointPage_16);
        this.fConditionHasChanged = this.createRadioButton((Composite)conditionComposite, PropertyPageMessages.JavaLineBreakpointPage_17);
        if (breakpoint.isConditionSuspendOnTrue()) {
            this.fConditionIsTrue.setSelection(true);
        } else {
            this.fConditionHasChanged.setSelection(true);
        }
        this.setConditionEnabled(this.fEnableConditionButton.getSelection());
    }

    private void setConditionEnabled(boolean enabled) {
        this.fConditionEditor.setEnabled(enabled);
        this.fSuspendWhenLabel.setEnabled(enabled);
        this.fConditionIsTrue.setEnabled(enabled);
        this.fConditionHasChanged.setEnabled(enabled);
    }

    public int convertHeightInCharsToPixels(int chars) {
        return super.convertHeightInCharsToPixels(chars);
    }

    public int convertWidthInCharsToPixels(int chars) {
        return super.convertWidthInCharsToPixels(chars);
    }

    public void dispose() {
        if (this.fConditionEditor != null) {
            this.fConditionEditor.dispose();
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.JAVA_LINE_BREAKPOINT_PROPERTY_PAGE);
    }
}

