/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.ant.internal.ui.AntSourceViewerConfiguration;
import org.eclipse.ant.internal.ui.editor.formatter.FormattingPreferences;
import org.eclipse.ant.internal.ui.editor.formatter.XmlFormatter;
import org.eclipse.ant.internal.ui.editor.text.AntDocumentSetupParticipant;
import org.eclipse.ant.internal.ui.preferences.AbstractAntEditorPreferencePage;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.AntPreviewerUpdater;
import org.eclipse.ant.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class AntCodeFormatterPreferencePage
extends AbstractAntEditorPreferencePage {
    private SourceViewer fPreviewViewer;
    private AntPreviewerUpdater fPreviewerUpdater;

    protected OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "formatter_wrap_long"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "formatter_align"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "formatter_max_line_length"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "formatter_tab_char"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "formatter_tab_size"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.getOverlayStore().load();
        this.getOverlayStore().start();
        int numColumns = 2;
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        Group indentationGroup = this.createGroup(numColumns, result, AntPreferencesMessages.AntCodeFormatterPreferencePage_0);
        String labelText = AntPreferencesMessages.AntCodeFormatterPreferencePage_1;
        String[] errorMessages = new String[]{AntPreferencesMessages.AntCodeFormatterPreferencePage_2, AntPreferencesMessages.AntCodeFormatterPreferencePage_3};
        this.addTextField((Composite)indentationGroup, labelText, "formatter_tab_size", 3, 0, errorMessages);
        labelText = AntPreferencesMessages.AntCodeFormatterPreferencePage_4;
        this.addCheckBox((Composite)indentationGroup, labelText, "formatter_tab_char", 1);
        Group wrappingGroup = this.createGroup(numColumns, result, AntPreferencesMessages.AntCodeFormatterPreferencePage_6);
        labelText = AntPreferencesMessages.AntCodeFormatterPreferencePage_7;
        errorMessages = new String[]{AntPreferencesMessages.AntCodeFormatterPreferencePage_8, AntPreferencesMessages.AntCodeFormatterPreferencePage_9};
        this.addTextField((Composite)wrappingGroup, labelText, "formatter_max_line_length", 3, 0, errorMessages);
        labelText = AntPreferencesMessages.AntCodeFormatterPreferencePage_10;
        this.addCheckBox((Composite)wrappingGroup, labelText, "formatter_wrap_long", 1);
        labelText = AntPreferencesMessages.AntCodeFormatterPreferencePage_5;
        this.addCheckBox((Composite)wrappingGroup, labelText, "formatter_align", 1);
        Label label = new Label(result, 16384);
        label.setText(AntPreferencesMessages.AntEditorPreferencePage_9);
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(result);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.initializeFields();
        this.applyDialogFont(result);
        return result;
    }

    private Group createGroup(int numColumns, Composite parent, String text) {
        Group group = new Group(parent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        gd.widthHint = 0;
        group.setLayoutData((Object)gd);
        group.setFont(parent.getFont());
        GridLayout layout = new GridLayout(numColumns, false);
        group.setLayout((Layout)layout);
        group.setText(text);
        return group;
    }

    private Control createPreviewer(Composite parent) {
        this.fPreviewViewer = new SourceViewer(parent, null, null, false, 2816);
        AntSourceViewerConfiguration configuration = new AntSourceViewerConfiguration();
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        this.fPreviewViewer.setEditable(false);
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.getOverlayStore(), EditorsUI.getPreferenceStore()});
        this.fPreviewerUpdater = new AntPreviewerUpdater(this.fPreviewViewer, configuration, (IPreferenceStore)store);
        String content = this.loadPreviewContentFromFile("FormatPreviewCode.txt");
        content = this.formatContent(content, (IPreferenceStore)store);
        Document document = new Document(content);
        new AntDocumentSetupParticipant().setup((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        return this.fPreviewViewer.getControl();
    }

    private String formatContent(String content, IPreferenceStore preferenceStore) {
        FormattingPreferences prefs = new FormattingPreferences();
        prefs.setPreferenceStore(preferenceStore);
        return XmlFormatter.format(content, prefs);
    }

    protected void handleDefaults() {
    }

    public void dispose() {
        super.dispose();
        if (this.fPreviewerUpdater != null) {
            this.fPreviewerUpdater.dispose();
        }
    }
}

