/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.internal.junit.launcher.TestSearchResult;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class JUnitBaseLaunchConfiguration
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String NO_DISPLAY_ATTR = "org.eclipse.jdt.junit.NO_DISPLAY";
    public static final String RUN_QUIETLY_MODE = "runQuietly";
    public static final String PORT_ATTR = "org.eclipse.jdt.junit.PORT";
    public static final String TESTTYPE_ATTR = "org.eclipse.jdt.junit.TESTTYPE";
    public static final String TESTNAME_ATTR = "org.eclipse.jdt.junit.TESTNAME";
    public static final String ATTR_KEEPRUNNING = "org.eclipse.jdt.junit.KEEPRUNNING_ATTR";
    public static final String LAUNCH_CONTAINER_ATTR = "org.eclipse.jdt.junit.CONTAINER";
    public static final String FAILURES_FILENAME_ATTR = "org.eclipse.jdt.junit.FAILURENAMES";
    public static final String TEST_KIND_ATTR = "org.eclipse.jdt.junit.TEST_KIND";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor pm) throws CoreException {
        if (mode.equals(RUN_QUIETLY_MODE)) {
            launch.setAttribute(NO_DISPLAY_ATTR, "true");
            mode = "run";
        }
        TestSearchResult testTypes = this.findTestTypes(configuration, pm);
        IVMInstall install = this.getVMInstall(configuration);
        IVMRunner runner = install.getVMRunner(mode);
        if (runner == null) {
            this.abort(Messages.format(JUnitMessages.JUnitBaseLaunchConfiguration_error_novmrunner, new String[]{install.getId()}), null, 106);
        }
        int port = SocketUtil.findFreePort();
        VMRunnerConfiguration runConfig = this.launchTypes(configuration, mode, testTypes, port);
        this.setDefaultSourceLocator(launch, configuration);
        launch.setAttribute(PORT_ATTR, Integer.toString(port));
        launch.setAttribute(TESTTYPE_ATTR, testTypes.getTypes()[0].getHandleIdentifier());
        runner.run(runConfig, launch, pm);
    }

    protected final TestSearchResult findTestTypes(ILaunchConfiguration configuration, IProgressMonitor pm) throws CoreException {
        boolean isJUnit4Configuration;
        ITestKind testKind;
        IJavaProject javaProject = this.getJavaProject(configuration);
        if (javaProject == null || !javaProject.exists()) {
            this.informAndAbort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_invalidproject, null, 107);
        }
        if (!TestSearchEngine.hasTestCaseType(javaProject)) {
            this.informAndAbort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_junitnotonpath, null, 10004);
        }
        if ((testKind = JUnitLaunchConfigurationConstants.getTestRunnerKind(configuration)).isNull()) {
            testKind = TestKindRegistry.getDefault().getKind("org.eclipse.jdt.junit.loader.junit3");
        }
        if ((isJUnit4Configuration = "org.eclipse.jdt.junit.loader.junit4".equals(testKind.getId())) && !TestSearchEngine.hasTestAnnotation(javaProject)) {
            this.informAndAbort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_junit4notonpath, null, 10004);
        }
        IJavaElement testTarget = this.getTestTarget(configuration, javaProject);
        HashSet result = new HashSet();
        testKind.getFinder().findTestsInContainer(testTarget, result, pm);
        if (result.isEmpty()) {
            String msg = Messages.format(JUnitMessages.JUnitLaunchConfigurationDelegate_error_notests_kind, testKind.getDisplayName());
            this.informAndAbort(msg, null, 101);
        }
        IType[] types = result.toArray(new IType[result.size()]);
        return new TestSearchResult(types, testKind);
    }

    private void informAndAbort(String message, Throwable exception, int code) throws CoreException {
        Status status = new Status(1, "org.eclipse.jdt.junit", code, message, exception);
        if (this.showStatusMessage((IStatus)status)) {
            throw new CoreException((IStatus)status);
        }
        this.abort(message, exception, code);
    }

    private final VMRunnerConfiguration launchTypes(ILaunchConfiguration configuration, String mode, TestSearchResult tests, int port) throws CoreException {
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String vmArgs = this.getVMArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, "");
        String[] envp = this.getEnvironment(configuration);
        VMRunnerConfiguration runConfig = this.createVMRunner(configuration, tests, port, mode);
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setEnvironment(envp);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        String[] bootpath = this.getBootpath(configuration);
        runConfig.setBootClassPath(bootpath);
        return runConfig;
    }

    private final IJavaElement getTestTarget(ILaunchConfiguration configuration, IJavaProject javaProject) throws CoreException {
        IType type;
        String containerHandle = configuration.getAttribute(LAUNCH_CONTAINER_ATTR, "");
        if (containerHandle.length() != 0) {
            IJavaElement element = JavaCore.create((String)containerHandle);
            if (element == null || !element.exists()) {
                this.informAndAbort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_input_element_deosn_not_exist, null, 101);
            }
            return element;
        }
        String testTypeName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        if (testTypeName.length() != 0 && (type = javaProject.findType(testTypeName = this.performStringSubstitution(testTypeName))) != null) {
            return type;
        }
        this.informAndAbort(JUnitMessages.JUnitLaunchConfigurationDelegate_input_type_does_not_exist, null, 101);
        return null;
    }

    private final String performStringSubstitution(String testTypeName) throws CoreException {
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(testTypeName);
    }

    private boolean showStatusMessage(final IStatus status) {
        final boolean[] success = new boolean[1];
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                Shell shell = JUnitPlugin.getActiveWorkbenchShell();
                if (shell == null) {
                    shell = JUnitBaseLaunchConfiguration.this.getDisplay().getActiveShell();
                }
                if (shell != null) {
                    MessageDialog.openInformation((Shell)shell, (String)JUnitMessages.JUnitLaunchConfigurationDelegate_dialog_title, (String)status.getMessage());
                    success[0] = true;
                }
            }
        });
        return success[0];
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit", code, message, exception));
    }

    protected abstract VMRunnerConfiguration createVMRunner(ILaunchConfiguration var1, TestSearchResult var2, int var3, String var4) throws CoreException;

    protected boolean keepAlive(ILaunchConfiguration config) {
        try {
            return config.getAttribute(ATTR_KEEPRUNNING, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected List getBasicArguments(ILaunchConfiguration configuration, int port, String runMode, TestSearchResult result) throws CoreException {
        ArrayList<String> argv = new ArrayList<String>();
        argv.add("-version");
        argv.add("3");
        argv.add("-port");
        argv.add(Integer.toString(port));
        if (this.keepAlive(configuration) && runMode.equals("debug")) {
            argv.add(0, "-keepalive");
        }
        String testLoaderId = result.getTestKind().getLoaderClassName();
        argv.add("-testLoaderClass");
        argv.add(testLoaderId);
        return argv;
    }
}

