/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.NameSet;
import org.eclipse.jdt.internal.core.builder.QualifiedNameSet;
import org.eclipse.jdt.internal.core.builder.StringSet;

public class ReferenceCollection {
    char[][][] qualifiedNameReferences;
    char[][] simpleNameReferences;
    static final char[][][] WellKnownQualifiedNames = new char[][][]{TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION, TypeConstants.JAVA_LANG_THROWABLE, TypeConstants.JAVA_LANG_OBJECT, TypeConstants.JAVA_LANG, new char[][]{TypeConstants.JAVA}, new char[][]{{'o', 'r', 'g'}}, new char[][]{{'c', 'o', 'm'}}, CharOperation.NO_CHAR_CHAR};
    static final char[][] WellKnownSimpleNames = new char[][]{TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION[2], TypeConstants.JAVA_LANG_THROWABLE[2], TypeConstants.JAVA_LANG_OBJECT[2], TypeConstants.JAVA, TypeConstants.LANG, {'o', 'r', 'g'}, {'c', 'o', 'm'}};
    static final char[][][] EmptyQualifiedNames = new char[0][][];
    static final char[][] EmptySimpleNames = CharOperation.NO_CHAR_CHAR;
    static final int MaxQualifiedNames = 7;
    static QualifiedNameSet[] InternedQualifiedNames = new QualifiedNameSet[7];
    static final int MaxSimpleNames = 30;
    static NameSet[] InternedSimpleNames = new NameSet[30];

    static {
        int i = 0;
        while (i < 7) {
            ReferenceCollection.InternedQualifiedNames[i] = new QualifiedNameSet(37);
            ++i;
        }
        i = 0;
        while (i < 30) {
            ReferenceCollection.InternedSimpleNames[i] = new NameSet(37);
            ++i;
        }
    }

    protected ReferenceCollection(char[][][] qualifiedNameReferences, char[][] simpleNameReferences) {
        this.qualifiedNameReferences = ReferenceCollection.internQualifiedNames(qualifiedNameReferences);
        this.simpleNameReferences = ReferenceCollection.internSimpleNames(simpleNameReferences, true);
    }

    void addDependencies(String[] typeNameDependencies) {
        Object qNames = new char[typeNameDependencies.length][][];
        int i = typeNameDependencies.length;
        while (--i >= 0) {
            qNames[i] = CharOperation.splitOn('.', typeNameDependencies[i].toCharArray());
        }
        qNames = ReferenceCollection.internQualifiedNames(qNames);
        i = ((char[][][])qNames).length;
        block1: while (--i >= 0) {
            char[][] qualifiedTypeName = qNames[i];
            while (!this.includes(qualifiedTypeName)) {
                int length;
                if (!this.includes(qualifiedTypeName[qualifiedTypeName.length - 1])) {
                    length = this.simpleNameReferences.length;
                    char[][] cArrayArray = new char[length + 1][];
                    this.simpleNameReferences = cArrayArray;
                    System.arraycopy(this.simpleNameReferences, 0, cArrayArray, 0, length);
                    this.simpleNameReferences[length] = qualifiedTypeName[qualifiedTypeName.length - 1];
                }
                length = this.qualifiedNameReferences.length;
                char[][][] cArrayArray = new char[length + 1][][];
                this.qualifiedNameReferences = cArrayArray;
                System.arraycopy(this.qualifiedNameReferences, 0, cArrayArray, 0, length);
                this.qualifiedNameReferences[length] = qualifiedTypeName;
                qualifiedTypeName = CharOperation.subarray(qualifiedTypeName, 0, qualifiedTypeName.length - 1);
                char[][][] temp = ReferenceCollection.internQualifiedNames(new char[][][]{qualifiedTypeName});
                if (temp == EmptyQualifiedNames) continue block1;
                qualifiedTypeName = temp[0];
            }
        }
    }

    boolean includes(char[] simpleName) {
        int i = 0;
        int l = this.simpleNameReferences.length;
        while (i < l) {
            if (simpleName == this.simpleNameReferences[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean includes(char[][] qualifiedName) {
        int i = 0;
        int l = this.qualifiedNameReferences.length;
        while (i < l) {
            if (qualifiedName == this.qualifiedNameReferences[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean includes(char[][][] qualifiedNames, char[][] simpleNames) {
        if (simpleNames == null || qualifiedNames == null) {
            if (simpleNames == null && qualifiedNames == null) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("Found well known match");
                }
                return true;
            }
            if (qualifiedNames == null) {
                int i = 0;
                int l = simpleNames.length;
                while (i < l) {
                    if (this.includes(simpleNames[i])) {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found match in well known package to " + new String(simpleNames[i]));
                        }
                        return true;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                int l = qualifiedNames.length;
                while (i < l) {
                    char[][] qualifiedName = qualifiedNames[i];
                    if (qualifiedName.length == 1 ? this.includes(qualifiedName[0]) : this.includes(qualifiedName)) {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found well known match in " + CharOperation.toString(qualifiedName));
                        }
                        return true;
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            int l = simpleNames.length;
            while (i < l) {
                if (this.includes(simpleNames[i])) {
                    int j = 0;
                    int m = qualifiedNames.length;
                    while (j < m) {
                        char[][] qualifiedName = qualifiedNames[j];
                        if (qualifiedName.length == 1 ? this.includes(qualifiedName[0]) : this.includes(qualifiedName)) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Found match in " + CharOperation.toString(qualifiedName) + " to " + new String(simpleNames[i]));
                            }
                            return true;
                        }
                        ++j;
                    }
                    return false;
                }
                ++i;
            }
        }
        return false;
    }

    static char[][][] internQualifiedNames(StringSet qualifiedStrings) {
        if (qualifiedStrings == null) {
            return EmptyQualifiedNames;
        }
        int length = qualifiedStrings.elementSize;
        if (length == 0) {
            return EmptyQualifiedNames;
        }
        char[][][] result = new char[length][][];
        String[] strings = qualifiedStrings.values;
        int i = 0;
        int l = strings.length;
        while (i < l) {
            if (strings[i] != null) {
                result[--length] = CharOperation.splitOn('/', strings[i].toCharArray());
            }
            ++i;
        }
        return ReferenceCollection.internQualifiedNames(result);
    }

    static char[][][] internQualifiedNames(char[][][] qualifiedNames) {
        if (qualifiedNames == null) {
            return EmptyQualifiedNames;
        }
        int length = qualifiedNames.length;
        if (length == 0) {
            return EmptyQualifiedNames;
        }
        char[][][] keepers = new char[length][][];
        int index = 0;
        int i = 0;
        while (i < length) {
            block7: {
                char[][] qualifiedName = qualifiedNames[i];
                int qLength = qualifiedName.length;
                int j = 0;
                int m = WellKnownQualifiedNames.length;
                while (j < m) {
                    char[][] wellKnownName = WellKnownQualifiedNames[j];
                    if (qLength > wellKnownName.length) break;
                    if (!CharOperation.equals(qualifiedName, wellKnownName)) {
                        ++j;
                        continue;
                    }
                    break block7;
                }
                QualifiedNameSet internedNames = InternedQualifiedNames[qLength <= 7 ? qLength - 1 : 0];
                qualifiedName = ReferenceCollection.internSimpleNames(qualifiedName, false);
                keepers[index++] = internedNames.add(qualifiedName);
            }
            ++i;
        }
        if (length > index) {
            if (index == 0) {
                return EmptyQualifiedNames;
            }
            char[][][] cArrayArray = keepers;
            keepers = new char[index][][];
            System.arraycopy(cArrayArray, 0, keepers, 0, index);
        }
        return keepers;
    }

    static char[][] internSimpleNames(StringSet simpleStrings) {
        if (simpleStrings == null) {
            return EmptySimpleNames;
        }
        int length = simpleStrings.elementSize;
        if (length == 0) {
            return EmptySimpleNames;
        }
        char[][] result = new char[length][];
        String[] strings = simpleStrings.values;
        int i = 0;
        int l = strings.length;
        while (i < l) {
            if (strings[i] != null) {
                result[--length] = strings[i].toCharArray();
            }
            ++i;
        }
        return ReferenceCollection.internSimpleNames(result, true);
    }

    static char[][] internSimpleNames(char[][] simpleNames, boolean removeWellKnown) {
        if (simpleNames == null) {
            return EmptySimpleNames;
        }
        int length = simpleNames.length;
        if (length == 0) {
            return EmptySimpleNames;
        }
        char[][] keepers = new char[length][];
        int index = 0;
        int i = 0;
        while (i < length) {
            block8: {
                char[] name = simpleNames[i];
                int sLength = name.length;
                int j = 0;
                int m = WellKnownSimpleNames.length;
                while (j < m) {
                    char[] wellKnownName = WellKnownSimpleNames[j];
                    if (sLength > wellKnownName.length) break;
                    if (CharOperation.equals(name, wellKnownName)) {
                        if (!removeWellKnown) {
                            keepers[index++] = WellKnownSimpleNames[j];
                        }
                        break block8;
                    }
                    ++j;
                }
                NameSet internedNames = InternedSimpleNames[sLength < 30 ? sLength : 0];
                keepers[index++] = internedNames.add(name);
            }
            ++i;
        }
        if (length > index) {
            if (index == 0) {
                return EmptySimpleNames;
            }
            char[][] cArrayArray = keepers;
            keepers = new char[index][];
            System.arraycopy(cArrayArray, 0, keepers, 0, index);
        }
        return keepers;
    }
}

