/* i386-darwin.macho-upxmain.h
   created from i386-darwin.macho-upxmain.exe, 4688 (0x1250) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I386_DARWIN_MACHO_UPXMAIN_EXE_SIZE    4688
#define STUB_I386_DARWIN_MACHO_UPXMAIN_EXE_ADLER32 0x8f7d68d7
#define STUB_I386_DARWIN_MACHO_UPXMAIN_EXE_CRC32   0x20172ebf

unsigned char stub_i386_darwin_macho_upxmain_exe[4688] = {
/* 0x0000 */ 206,250,237,254,  7,  0,  0,  0,  3,  0,  0,  0,  2,  0,  0,  0,
/* 0x0010 */   9,  0,  0,  0,104,  2,  0,  0,141,  0,  0,  0,  1,  0,  0,  0,
/* 0x0020 */  56,  0,  0,  0, 95, 95, 80, 65, 71, 69, 90, 69, 82, 79,  0,  0,
/* 0x0030 */   0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,
/* 0x0040 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0050 */   0,  0,  0,  0,  1,  0,  0,  0,192,  0,  0,  0, 95, 95, 84, 69,
/* 0x0060 */  88, 84,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,
/* 0x0070 */   0, 16,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  7,  0,  0,  0,
/* 0x0080 */   5,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0, 95, 95,116,101,
/* 0x0090 */ 120,116,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 95, 95, 84, 69,
/* 0x00a0 */  88, 84,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,100, 25,  0,  0,
/* 0x00b0 */  74,  6,  0,  0,100,  9,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,
/* 0x00c0 */   0,  0,  0,  0,  0,  4,  0,128,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x00d0 */  95, 95,117,110,119,105,110,100, 95,105,110,102,111,  0,  0,  0,
/* 0x00e0 */  95, 95, 84, 69, 88, 84,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x00f0 */ 176, 31,  0,  0, 72,  0,  0,  0,176, 15,  0,  0,  4,  0,  0,  0,
/* 0x0100 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0110 */   0,  0,  0,  0,  1,  0,  0,  0, 56,  0,  0,  0, 95, 95, 76, 73,
/* 0x0120 */  78, 75, 69, 68, 73, 84,  0,  0,  0,  0,  0,  0,  0, 32,  0,  0,
/* 0x0130 */  80,  2,  0,  0,  0, 16,  0,  0, 80,  2,  0,  0,  7,  0,  0,  0,
/* 0x0140 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 34,  0,  0,128,
/* 0x0150 */  48,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0160 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0170 */   0,  0,  0,  0,  0, 16,  0,  0,236,  0,  0,  0,  2,  0,  0,  0,
/* 0x0180 */  24,  0,  0,  0,236, 16,  0,  0, 17,  0,  0,  0,184, 17,  0,  0,
/* 0x0190 */ 152,  0,  0,  0, 11,  0,  0,  0, 80,  0,  0,  0,  0,  0,  0,  0,
/* 0x01a0 */   0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0, 16,  0,  0,  0,
/* 0x01b0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x01c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x01d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x01e0 */   0,  0,  0,  0, 14,  0,  0,  0, 28,  0,  0,  0, 12,  0,  0,  0,
/* 0x01f0 */  47,117,115,114, 47,108,105, 98, 47,100,121,108,100,  0,  0,  0,
/* 0x0200 */   5,  0,  0,  0, 80,  0,  0,  0,  1,  0,  0,  0, 16,  0,  0,  0,
/* 0x0210 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0220 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0230 */   0,  0,  0,  0,  0,  0,  0,  0,100, 25,  0,  0,  0,  0,  0,  0,
/* 0x0240 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0250 */  12,  0,  0,  0, 52,  0,  0,  0, 24,  0,  0,  0,  2,  0,  0,  0,
/* 0x0260 */  11,  2,125,  0,  0,  0,  1,  0, 47,117,115,114, 47,108,105, 98,
/* 0x0270 */  47,108,105, 98, 83,121,115,116,101,109, 46, 66, 46,100,121,108,
/* 0x0280 */ 105, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0290 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x02a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x02b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x02c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x02d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x02e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x02f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0300 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0310 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0320 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0330 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0340 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0350 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0360 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0370 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0380 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0390 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x03a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x03b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x03c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x03d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x03e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x03f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0400 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0410 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0420 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0430 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0440 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0450 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0460 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0470 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0480 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0490 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x04a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x04b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x04c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x04d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x04e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x04f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0500 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0510 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0520 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0530 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0540 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0550 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0560 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0570 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0580 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0590 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x05a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x05b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x05c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x05d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x05e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x05f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0600 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0610 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0620 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0630 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0640 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0650 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0660 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0670 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0680 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0690 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x06a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x06b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x06c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x06d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x06e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x06f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0700 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0710 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0720 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0730 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0740 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0750 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0760 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0770 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0780 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0790 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x07a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x07b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x07c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x07d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x07e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x07f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0800 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0810 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0820 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0830 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0840 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0850 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0860 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0870 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0880 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0890 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x08a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x08b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x08c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x08d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x08e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x08f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0900 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0910 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0920 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0930 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0940 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0950 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0960 */   0,  0,  0,  0,204, 85,137,229, 83, 87, 86,131,236, 44,139, 69,
/* 0x0970 */   8,141,120, 24,141, 77,208,137,121,  4,139, 93, 12,131,195,232,
/* 0x0980 */ 137, 25,139,117, 16,141, 85,216,137,114,  4,139, 64, 24,137,  2,
/* 0x0990 */ 141, 69,224,137,120,  4,137, 24,139, 93, 24,131,236,  8, 49,255,
/* 0x09a0 */  87, 83,232, 54,  1,  0,  0,131,196,  8, 49,210,137,241,255,117,
/* 0x09b0 */  28, 83,255,117, 32,106,255,141, 69,224, 80, 87,232,  1,  2,  0,
/* 0x09c0 */   0,131,196, 32,137,195,139, 78, 16,133,201, 15,132,  2,  1,  0,
/* 0x09d0 */   0,141, 70, 28,131, 56, 14,116, 13, 71,  3, 64,  4, 57,207,114,
/* 0x09e0 */ 243,233,237,  0,  0,  0,  3, 64,  8,131,236,  4, 49,255, 87, 87,
/* 0x09f0 */  80,232,153,  5,  0,  0,131,196, 16,137, 69,240,133,192, 15,136,
/* 0x0a00 */ 152,  0,  0,  0,131,236, 12, 87, 87,139, 69, 20,137,199, 87, 86,
/* 0x0a10 */ 255,117,240,232,111,  5,  0,  0,131,196, 32, 57,248,117,125,141,
/* 0x0a20 */  70, 16,137, 69,232, 49,219,199, 69,236,  0,  0,  0,  0,139,  6,
/* 0x0a30 */  61,190,186,254,202,116,  7, 61,202,254,186,190,117,107, 15,182,
/* 0x0a40 */  70,  7,141,  4,128,141,  4,133,  8,  0,  0,  0,131,236,  8, 80,
/* 0x0a50 */  86,232,249,  4,  0,  0,131,196, 16,139, 70,  4,133,192,116, 60,
/* 0x0a60 */  49,201,139, 85,232,131,122,248,  7,116, 10, 65,131,194, 20, 57,
/* 0x0a70 */ 193,114,242,235, 39,139, 26,133,219,116, 33,199, 69,236,  0,  0,
/* 0x0a80 */   0,  0,131,236, 12,106,  0, 83,139,125, 20, 87, 86,255,117,240,
/* 0x0a90 */ 232,242,  4,  0,  0,131,196, 32, 57,248,116,146,131,236, 12,106,
/* 0x0aa0 */ 127,232,213,  4,  0,  0,131,196, 16,131,236,  8, 49,192,137,241,
/* 0x0ab0 */ 137,218, 80, 80, 80,139,117,240, 86, 80,255,117,236,232,  0,  1,
/* 0x0ac0 */   0,  0,131,196, 32,137,195,131,236, 12, 86,232,187,  4,  0,  0,
/* 0x0ad0 */ 131,196, 16,137,216,131,196, 44, 94, 95, 91, 93,195, 85,137,229,
/* 0x0ae0 */  83, 87, 86,131,236, 28,137,215,137, 77,240,131, 63,  0, 15,132,
/* 0x0af0 */ 185,  0,  0,  0,131,236, 12,139, 77,240,141, 85,224,106, 12,232,
/* 0x0b00 */   8,  4,  0,  0,131,196, 16,139, 93,224,139,117,228,133,219, 15,
/* 0x0b10 */ 132,136,  0,  0,  0,141, 70,255, 57,216, 15,131,149,  0,  0,  0,
/* 0x0b20 */  59, 31, 15,135,141,  0,  0,  0, 57,222,115, 82,137, 93,236, 15,
/* 0x0b30 */ 182, 69,232,131,236, 12, 80,141, 69,236, 80,255,119,  4, 86,139,
/* 0x0b40 */  69,240,255,112,  4,255, 85,  8,131,196, 32,133,192,117,102, 57,
/* 0x0b50 */  93,236,117, 97,131,125, 12,  0,116, 26,138, 69,233,132,192,116,
/* 0x0b60 */  19, 15,182,192, 15,182, 77,234, 80, 81, 83,255,119,  4,255, 85,
/* 0x0b70 */  12,131,196, 16,139, 69,240,  1,112,  4, 41, 48,235, 18,139, 87,
/* 0x0b80 */   4,131,236, 12,139, 77,240, 86,232,127,  3,  0,  0,131,196, 16,
/* 0x0b90 */   1, 95,  4, 41, 31, 15,133, 89,255,255,255,235, 16,129,254, 85,
/* 0x0ba0 */  80, 88, 33,117, 16,139, 69,240,131, 56,  0,117,  8,131,196, 28,
/* 0x0bb0 */  94, 95, 91, 93,195,131,236, 12,106,127,232,188,  3,  0,  0,131,
/* 0x0bc0 */ 196, 16, 85,137,229, 83, 87, 86,131,236, 60,137, 85,216,139, 65,
/* 0x0bd0 */  16,137,198,133,192, 15,132, 76,  2,  0,  0, 49,210,131,125, 12,
/* 0x0be0 */   0, 15,149,194,141, 20, 82,137, 85,220,137, 77,204,141, 89, 28,
/* 0x0bf0 */ 199, 69,228,  0,  0,  0,  0, 49,192,199, 69,236,  0,  0,  0,  0,
/* 0x0c00 */  49,255,137,241,137, 69,232,139, 51,141, 86,252,131,250,  2, 15,
/* 0x0c10 */ 130,208,  0,  0,  0,129,254, 40,  0,  0,128, 15,132,230,  0,  0,
/* 0x0c20 */   0,131,254,  1, 15,133,236,  1,  0,  0,139, 83, 28,133,210,139,
/* 0x0c30 */  69,232, 15,132,225,  1,  0,  0,137, 85,200,139, 75, 36,137, 77,
/* 0x0c40 */ 184,139, 67, 24,  3, 69,236,137, 69,188,137,198,129,230,255, 15,
/* 0x0c50 */   0,  0,137, 69,196,137,194, 41,242,  1,206,137,117,224, 15,132,
/* 0x0c60 */ 195,  0,  0,  0,139, 69,220,141,  4,  6,137, 69,208,137,208,137,
/* 0x0c70 */  69,240, 49,210,133,192, 15,149,194,193,226,  4, 49,192,133,201,
/* 0x0c80 */  15,148,192,193,224, 12,131,125, 12,  0,190,  0, 16,  0,  0, 15,
/* 0x0c90 */  69,198,141, 68,  2,  2,137, 69,212,131,249,  1, 25,201, 11, 77,
/* 0x0ca0 */  16,139, 83, 32,  3, 85,216,139, 69,  8,190,  0,  0,  0,  0, 17,
/* 0x0cb0 */ 240,131,236,  4, 80, 82, 81,255,117,212,106,  3,255,117,208,255,
/* 0x0cc0 */ 117,240,232,204,  2,  0,  0,131,196, 32,131,125,240,  0,139, 77,
/* 0x0cd0 */ 236, 15, 68,200,137,194,131,248,255,137,200,139, 77,228,117, 77,
/* 0x0ce0 */ 233, 76,  1,  0,  0,131,123,  8,  1, 15,133, 39,  1,  0,  0,131,
/* 0x0cf0 */ 123, 12, 16,139, 69,232, 15,133, 29,  1,  0,  0,139, 67, 56,  3,
/* 0x0d00 */  69,236,233, 18,  1,  0,  0,139, 67,  8,139, 85,228, 57, 66, 32,
/* 0x0d10 */  15,135,  3,  1,  0,  0, 57, 66, 36, 15,134,250,  0,  0,  0,  3,
/* 0x0d20 */  66, 24,233,242,  0,  0,  0,139, 69,236,139, 77,228,137, 69,236,
/* 0x0d30 */ 131,125, 12,  0,137, 85,240,116, 49,131,123, 36,  0,116, 43,131,
/* 0x0d40 */ 123, 32,  0,117,  7,139, 69, 20,137, 16,137,217,131,236,  8,137,
/* 0x0d50 */ 206,139, 77, 12,141, 85,184,255,117, 28,255,117, 24,232,123,253,
/* 0x0d60 */ 255,255,139, 85,240,137,241,131,196, 16,137, 77,228,139, 69,224,
/* 0x0d70 */ 137,198,247,222,129,230,255, 15,  0,  0,116, 22,141,  4,  2,131,
/* 0x0d80 */ 236,  8, 86, 80,232,221,  1,  0,  0,139, 69,224,139, 85,240,131,
/* 0x0d90 */ 196, 16,133,192,137,193,116, 26,131,236,  4,255,115, 44, 81, 82,
/* 0x0da0 */ 232,218,  1,  0,  0,139, 77,224,139, 85,240,131,196, 16,133,192,
/* 0x0db0 */ 117,127,139, 69,196,  3, 69,200,  1,206,  1,242, 57,194,115, 43,
/* 0x0dc0 */ 133,210,116, 76,137,193, 41,209,131,236,  4, 49,192, 80, 80,106,
/* 0x0dd0 */ 255,104, 18, 16,  0,  0,255,115, 44, 81, 82,137,214,232,177,  1,
/* 0x0de0 */   0,  0,131,196, 32, 57,198,116, 39,235, 70,131,125, 12,  0,116,
/* 0x0df0 */  31,131,193,  3,129,225,255, 15,  0,  0,184,  3,  0,  0,  0, 57,
/* 0x0e00 */ 193,119, 13,131,236,  8, 81, 82,232,118,  1,  0,  0,131,196, 16,
/* 0x0e10 */ 139, 69,204,139, 72, 16,139, 69,232, 71,  3, 91,  4, 57,207, 15,
/* 0x0e20 */ 130,223,253,255,255,235,  2, 49,192,131,196, 60, 94, 95, 91, 93,
/* 0x0e30 */ 195,131,236, 12,106,127,232, 64,  1,  0,  0,131,196, 16, 85,137,
/* 0x0e40 */ 229, 83, 87, 86,129,236, 28, 64,  0,  0,232,  0,  0,  0,  0, 88,
/* 0x0e50 */ 139,117,  4,141, 85,  8,141,128,239,255,255,255, 37,  0,240,255,
/* 0x0e60 */ 255,139, 72, 16,133,201,137, 85,228,137,117,232,116, 44,131,200,
/* 0x0e70 */  28, 49,246,186, 76, 73, 78, 75,131, 56,  1,117, 19,139,120, 14,
/* 0x0e80 */ 187, 69, 68, 73, 84, 49,223,139, 88, 10, 49,211,  9,251,116, 12,
/* 0x0e90 */  70,  3, 64,  4, 57,206,114,224,235, 31,235, 29,139, 88, 24, 15,
/* 0x0ea0 */ 183,  3,  1,216,141, 75,  2,139,123,252,131,195,252,133,255,116,
/* 0x0eb0 */ 246, 41,251,137, 69,236,137, 77,240,139,117,228,137,240,131,192,
/* 0x0ec0 */ 248,131,236,  4,141,141,228,191,255,255, 80,255,117,240,255,117,
/* 0x0ed0 */ 236,104,  0, 64,  0,  0, 81, 87, 83,232,135,250,255,255,131,196,
/* 0x0ee0 */  32,137, 69,240,131,236,  8, 87, 83,232,149,  0,  0,  0,131,196,
/* 0x0ef0 */  16,139, 69,232,137, 70,252,139, 69,240,141,102,248,255,224, 49,
/* 0x0f00 */ 192,129,196, 28, 64,  0,  0, 94, 95, 91, 93,195, 85,137,229, 83,
/* 0x0f10 */  87, 86,131,236, 12,139, 69,  8,139, 49, 57,198,114, 37,133,192,
/* 0x0f20 */ 116, 18,139,113,  4, 49,255,138, 28, 62,136, 28, 58, 71, 57,248,
/* 0x0f30 */ 117,245,139, 49,  1, 65,  4, 41,198,137, 49,131,196, 12, 94, 95,
/* 0x0f40 */  91, 93,195,199,  4, 36,127,  0,  0,  0,232, 44,  0,  0,  0,139,
/* 0x0f50 */  84, 36,  4,139, 76, 36,  8,139,  2, 15,200,137,  2,131,233,  4,
/* 0x0f60 */ 141, 82,  4,119,242,195, 90, 88, 89, 81, 80, 82, 87,151, 49,192,
/* 0x0f70 */ 243,170, 95,195, 90, 15, 52,176,  4,235,  2,176,  1,235,  2,176,
/* 0x0f80 */  74,235,  2,176, 73,235,  2,176,153,235,  2,176,  6,235,  2,176,
/* 0x0f90 */   5,235,  2,176,197,235,  2,176,  3, 15,182,192,137,225, 13,  0,
/* 0x0fa0 */   0, 12,  0,232,204,255,255,255,115,  3,131,200,255,195,  0,  0,
/* 0x0fb0 */   1,  0,  0,  0, 28,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0,  0,
/* 0x0fc0 */   0,  0,  0,  0, 28,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fd0 */  52,  0,  0,  0, 52,  0,  0,  0,249, 15,  0,  0,  0,  0,  0,  0,
/* 0x0fe0 */  52,  0,  0,  0,  3,  0,  0,  0, 12,  0,  1,  0, 16,  0,  1,  0,
/* 0x0ff0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1000 */   0,  2, 95,  0, 12,115,116, 97,114,116,  0,113,  0, 10, 95,  0,
/* 0x1010 */  79,117,112,120, 95,109, 97,105,110,  0,118,109,  0,123, 98,  0,
/* 0x1020 */ 160,  1,119,114,105,116,101,  0,191,  1,101,120,105,116,  0,196,
/* 0x1030 */   1,112,114,101, 97,100,  0,211,  1, 99,108,111,115,101,  0,216,
/* 0x1040 */   1,111,112,101,110,  0,221,  1,114,101, 97,100,  0,231,  1,  0,
/* 0x1050 */   2,109,104, 95,101,120,101, 99,117,116,101, 95,104,101, 97,100,
/* 0x1060 */ 101,114,  0,109, 95, 98,122,101,114,111,  0,181,  1,  2,  0,  0,
/* 0x1070 */   0,  3,  0,228, 18,  0,  3,  0,229, 18,  0,  0,  4, 97,105,110,
/* 0x1080 */   0,155,  1,112,114,111,116,101, 99,116,  0,201,  1,117,110,109,
/* 0x1090 */  97,112,  0,206,  1,109, 97,112,  0,226,  1,  3,  0,190, 28,  0,
/* 0x10a0 */   0,  2,115,119, 97,112,  0,176,  1,122,101,114,111,  0,186,  1,
/* 0x10b0 */   3,  0,207, 30,  0,  3,  0,230, 30,  0,  3,  0,230, 30,  0,  3,
/* 0x10c0 */   0,247, 30,  0,  3,  0,251, 30,  0,  3,  0,255, 30,  0,  3,  0,
/* 0x10d0 */ 131, 31,  0,  3,  0,135, 31,  0,  3,  0,139, 31,  0,  3,  0,143,
/* 0x10e0 */  31,  0,  3,  0,147, 31,  0,  3,  0,151, 31,  0,  4,  0,  0,  0,
/* 0x10f0 */  15,  1,  0,  0,102, 31,  0,  0, 13,  0,  0,  0,  3,  0, 16,  0,
/* 0x1100 */   0, 16,  0,  0, 33,  0,  0,  0, 15,  1,  0,  0, 79, 31,  0,  0,
/* 0x1110 */  40,  0,  0,  0, 15,  1,  0,  0,102, 31,  0,  0, 47,  0,  0,  0,
/* 0x1120 */  15,  1,  0,  0,139, 31,  0,  0, 54,  0,  0,  0, 15,  1,  0,  0,
/* 0x1130 */ 123, 31,  0,  0, 60,  0,  0,  0, 15,  1,  0,  0, 62, 30,  0,  0,
/* 0x1140 */  66,  0,  0,  0, 15,  1,  0,  0,147, 31,  0,  0, 72,  0,  0,  0,
/* 0x1150 */  15,  1,  0,  0,127, 31,  0,  0, 82,  0,  0,  0, 15,  1,  0,  0,
/* 0x1160 */ 131, 31,  0,  0, 90,  0,  0,  0, 15,  1,  0,  0,143, 31,  0,  0,
/* 0x1170 */  96,  0,  0,  0, 15,  1,  0,  0,135, 31,  0,  0,103,  0,  0,  0,
/* 0x1180 */  15,  1,  0,  0,151, 31,  0,  0,109,  0,  0,  0, 15,  1,  0,  0,
/* 0x1190 */ 101, 25,  0,  0,119,  0,  0,  0, 15,  1,  0,  0,119, 31,  0,  0,
/* 0x11a0 */ 126,  0,  0,  0, 15,  1,  0,  0,100, 25,  0,  0,132,  0,  0,  0,
/* 0x11b0 */   1,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0, 95, 95, 95, 98,
/* 0x11c0 */ 122,101,114,111,  0, 95, 95,109,104, 95,101,120,101, 99,117,116,
/* 0x11d0 */ 101, 95,104,101, 97,100,101,114,  0, 95, 98,115,119, 97,112,  0,
/* 0x11e0 */  95, 98,122,101,114,111,  0, 95, 99,108,111,115,101,  0, 95,101,
/* 0x11f0 */ 120,105,116,  0, 95,109, 97,105,110,  0, 95,109,109, 97,112,  0,
/* 0x1200 */  95,109,112,114,111,116,101, 99,116,  0, 95,109,117,110,109, 97,
/* 0x1210 */ 112,  0, 95,111,112,101,110,  0, 95,112,114,101, 97,100,  0, 95,
/* 0x1220 */ 114,101, 97,100,  0, 95,117,112,120, 95,109, 97,105,110,  0, 95,
/* 0x1230 */ 119,114,105,116,101,  0,115,116, 97,114,116,  0,100,121,108,100,
/* 0x1240 */  95,115,116,117, 98, 95, 98,105,110,100,101,114,  0,  0,  0,  0
};
