#!/usr/bin/awk -f

# The caller must pass args: -v hfile=NAME rsync.1.md

BEGIN {
    heading = "/* DO NOT EDIT THIS FILE!  It is auto-generated from a list of values in " ARGV[1] "! */"
    if (hfile ~ /compress/) {
	define = "#define DEFAULT_DONT_COMPRESS"
	prefix = "*."
    } else {
	define = "#define DEFAULT_CVSIGNORE"
	prefix = ""
    }
    value_list = ""
}

/^    > [^ ]+$/ {
    gsub(/`/, "")
    if (value_list != "") value_list = value_list " "
    value_list = value_list prefix $2
    next
}

value_list ~ /\.gz / && hfile ~ /compress/ {
    exit
}

value_list ~ /SCCS / && hfile ~ /cvsignore/ {
    exit
}

value_list = ""

END {
    if (value_list != "")
	print heading "\n\n" define " \"" value_list "\"" > hfile
    else {
	print "Failed to find a value list in " ARGV[1] " for " hfile
	exit 1
    }
}
