# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=lunarlake -instruction-tables < %s | FileCheck %s

cmpxchg8b  (%rax)
cmpxchg16b (%rax)
lock cmpxchg8b  (%rax)
lock cmpxchg16b (%rax)

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  16     25    2.33    *      *            cmpxchg8b	(%rax)
# CHECK-NEXT:  22     32    2.83    *      *            cmpxchg16b	(%rax)
# CHECK-NEXT:  16     25    2.33    *      *            lock		cmpxchg8b	(%rax)
# CHECK-NEXT:  22     32    2.83    *      *            lock		cmpxchg16b	(%rax)

# CHECK:      Resources:
# CHECK-NEXT: [0]   - LNLPPort00
# CHECK-NEXT: [1]   - LNLPPort01
# CHECK-NEXT: [2]   - LNLPPort02
# CHECK-NEXT: [3]   - LNLPPort03
# CHECK-NEXT: [4]   - LNLPPort04
# CHECK-NEXT: [5]   - LNLPPort05
# CHECK-NEXT: [6]   - LNLPPort10
# CHECK-NEXT: [7]   - LNLPPort11
# CHECK-NEXT: [8]   - LNLPPort20
# CHECK-NEXT: [9]   - LNLPPort21
# CHECK-NEXT: [10]  - LNLPPort22
# CHECK-NEXT: [11]  - LNLPPort25
# CHECK-NEXT: [12]  - LNLPPort26
# CHECK-NEXT: [13]  - LNLPPort27
# CHECK-NEXT: [14]  - LNLPPortInvalid
# CHECK-NEXT: [15]  - LNLPVPort00
# CHECK-NEXT: [16]  - LNLPVPort01
# CHECK-NEXT: [17]  - LNLPVPort02
# CHECK-NEXT: [18]  - LNLPVPort03

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16]   [17]   [18]
# CHECK-NEXT: 16.33  9.00   12.33  5.00   12.33  5.00   2.00   2.00   1.33   1.33   1.33   1.33   1.33   1.33    -      -      -     2.00   2.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16]   [17]   [18]   Instructions:
# CHECK-NEXT: 3.00   2.67   3.00   0.67   3.00   0.67   0.50   0.50   0.33   0.33   0.33   0.33   0.33   0.33    -      -      -      -      -     cmpxchg8b	(%rax)
# CHECK-NEXT: 5.17   1.83   3.17   1.83   3.17   1.83   0.50   0.50   0.33   0.33   0.33   0.33   0.33   0.33    -      -      -     1.00   1.00   cmpxchg16b	(%rax)
# CHECK-NEXT: 3.00   2.67   3.00   0.67   3.00   0.67   0.50   0.50   0.33   0.33   0.33   0.33   0.33   0.33    -      -      -      -      -     lock		cmpxchg8b	(%rax)
# CHECK-NEXT: 5.17   1.83   3.17   1.83   3.17   1.83   0.50   0.50   0.33   0.33   0.33   0.33   0.33   0.33    -      -      -     1.00   1.00   lock		cmpxchg16b	(%rax)
