// RUN: llvm-mc -triple=amdgcn -mcpu=bonaire -show-encoding %s | FileCheck %s

v_nop_e64
// CHECK: [0x00,0x00,0x00,0xd3,0x00,0x00,0x00,0x00]

v_mov_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x02,0xd3,0x01,0x01,0x00,0x00]

v_mov_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x02,0xd3,0x01,0x01,0x00,0x00]

v_mov_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x02,0xd3,0xff,0x01,0x00,0x00]

v_mov_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x02,0xd3,0x01,0x00,0x00,0x00]

v_mov_b32_e64 v5, s103
// CHECK: [0x05,0x00,0x02,0xd3,0x67,0x00,0x00,0x00]

v_mov_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x02,0xd3,0x68,0x00,0x00,0x00]

v_mov_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x02,0xd3,0x69,0x00,0x00,0x00]

v_mov_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x02,0xd3,0x6a,0x00,0x00,0x00]

v_mov_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x02,0xd3,0x6b,0x00,0x00,0x00]

v_mov_b32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x02,0xd3,0x6c,0x00,0x00,0x00]

v_mov_b32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x02,0xd3,0x6d,0x00,0x00,0x00]

v_mov_b32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x02,0xd3,0x6e,0x00,0x00,0x00]

v_mov_b32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x02,0xd3,0x6f,0x00,0x00,0x00]

v_mov_b32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x02,0xd3,0x7b,0x00,0x00,0x00]

v_mov_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x02,0xd3,0x7c,0x00,0x00,0x00]

v_mov_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x02,0xd3,0x7e,0x00,0x00,0x00]

v_mov_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x02,0xd3,0x7f,0x00,0x00,0x00]

v_mov_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x02,0xd3,0x80,0x00,0x00,0x00]

v_mov_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x02,0xd3,0xc1,0x00,0x00,0x00]

v_mov_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x02,0xd3,0xf0,0x00,0x00,0x00]

v_mov_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x02,0xd3,0xf7,0x00,0x00,0x00]

v_mov_b32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x02,0xd3,0xfb,0x00,0x00,0x00]

v_mov_b32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x02,0xd3,0xfc,0x00,0x00,0x00]

v_mov_b32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x02,0xd3,0xfd,0x00,0x00,0x00]

v_mov_b32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x02,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, v[1:2]
// CHECK: [0x05,0x00,0x06,0xd3,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v255, v[1:2]
// CHECK: [0xff,0x00,0x06,0xd3,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, v[254:255]
// CHECK: [0x05,0x00,0x06,0xd3,0xfe,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[2:3]
// CHECK: [0x05,0x00,0x06,0xd3,0x02,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[4:5]
// CHECK: [0x05,0x00,0x06,0xd3,0x04,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[102:103]
// CHECK: [0x05,0x00,0x06,0xd3,0x66,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, flat_scratch
// CHECK: [0x05,0x00,0x06,0xd3,0x68,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, vcc
// CHECK: [0x05,0x00,0x06,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, tba
// CHECK: [0x05,0x00,0x06,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, tma
// CHECK: [0x05,0x00,0x06,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, ttmp[10:11]
// CHECK: [0x05,0x00,0x06,0xd3,0x7a,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, exec
// CHECK: [0x05,0x00,0x06,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, 0
// CHECK: [0x05,0x00,0x06,0xd3,0x80,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -1
// CHECK: [0x05,0x00,0x06,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, 0.5
// CHECK: [0x05,0x00,0x06,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -4.0
// CHECK: [0x05,0x00,0x06,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x06,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, src_execz
// CHECK: [0x05,0x00,0x06,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, src_scc
// CHECK: [0x05,0x00,0x06,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -v[1:2]
// CHECK: [0x05,0x00,0x06,0xd3,0x01,0x01,0x00,0x20]

v_cvt_i32_f64_e64 v5, |v[1:2]|
// CHECK: [0x05,0x01,0x06,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v1
// CHECK: [0x05,0x00,0x08,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[254:255], v1
// CHECK: [0xfe,0x00,0x08,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v255
// CHECK: [0x05,0x00,0x08,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], s1
// CHECK: [0x05,0x00,0x08,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], s103
// CHECK: [0x05,0x00,0x08,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], flat_scratch_lo
// CHECK: [0x05,0x00,0x08,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], flat_scratch_hi
// CHECK: [0x05,0x00,0x08,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], vcc_lo
// CHECK: [0x05,0x00,0x08,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], vcc_hi
// CHECK: [0x05,0x00,0x08,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], tba_lo
// CHECK: [0x05,0x00,0x08,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], tba_hi
// CHECK: [0x05,0x00,0x08,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], tma_lo
// CHECK: [0x05,0x00,0x08,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], tma_hi
// CHECK: [0x05,0x00,0x08,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], ttmp11
// CHECK: [0x05,0x00,0x08,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], m0
// CHECK: [0x05,0x00,0x08,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], exec_lo
// CHECK: [0x05,0x00,0x08,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], exec_hi
// CHECK: [0x05,0x00,0x08,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x08,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x08,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x08,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x08,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x08,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x08,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x08,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], src_lds_direct
// CHECK: [0x05,0x00,0x08,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v1 clamp
// CHECK: [0x05,0x08,0x08,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v1 mul:2
// CHECK: [0x05,0x00,0x08,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f64_i32_e64 v[5:6], v1 mul:4
// CHECK: [0x05,0x00,0x08,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f64_i32_e64 v[5:6], v1 div:2
// CHECK: [0x05,0x00,0x08,0xd3,0x01,0x01,0x00,0x18]

v_cvt_f32_i32_e64 v5, v1
// CHECK: [0x05,0x00,0x0a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v255, v1
// CHECK: [0xff,0x00,0x0a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, v255
// CHECK: [0x05,0x00,0x0a,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, s1
// CHECK: [0x05,0x00,0x0a,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, s103
// CHECK: [0x05,0x00,0x0a,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x0a,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x0a,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x0a,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x0a,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x0a,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x0a,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x0a,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x0a,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x0a,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, m0
// CHECK: [0x05,0x00,0x0a,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x0a,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x0a,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, 0
// CHECK: [0x05,0x00,0x0a,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, -1
// CHECK: [0x05,0x00,0x0a,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x0a,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x0a,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x0a,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x0a,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x0a,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x0a,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x0a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x0a,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f32_i32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x0a,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f32_i32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x0a,0xd3,0x01,0x01,0x00,0x18]

v_cvt_f32_u32_e64 v5, v1
// CHECK: [0x05,0x00,0x0c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v255, v1
// CHECK: [0xff,0x00,0x0c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, v255
// CHECK: [0x05,0x00,0x0c,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, s1
// CHECK: [0x05,0x00,0x0c,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, s103
// CHECK: [0x05,0x00,0x0c,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x0c,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x0c,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x0c,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x0c,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x0c,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x0c,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x0c,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x0c,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x0c,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, m0
// CHECK: [0x05,0x00,0x0c,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x0c,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x0c,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, 0
// CHECK: [0x05,0x00,0x0c,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, -1
// CHECK: [0x05,0x00,0x0c,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x0c,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x0c,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x0c,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x0c,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x0c,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x0c,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x0c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x0c,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f32_u32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x0c,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f32_u32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x0c,0xd3,0x01,0x01,0x00,0x18]

v_cvt_u32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x0e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x0e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x0e,0xd3,0xff,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x0e,0xd3,0x01,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x0e,0xd3,0x67,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x0e,0xd3,0x68,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x0e,0xd3,0x69,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x0e,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x0e,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x0e,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x0e,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x0e,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x0e,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x0e,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x0e,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x0e,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x0e,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x0e,0xd3,0x80,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x0e,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x0e,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x0e,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x0e,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x0e,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x0e,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x0e,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x0e,0xd3,0x01,0x01,0x00,0x20]

v_cvt_u32_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x0e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x10,0xd3,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x10,0xd3,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x10,0xd3,0xff,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x10,0xd3,0x01,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x10,0xd3,0x67,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x10,0xd3,0x68,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x10,0xd3,0x69,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x10,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x10,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x10,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x10,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x10,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x10,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x10,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x10,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x10,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x10,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x10,0xd3,0x80,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x10,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x10,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x10,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x10,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x10,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x10,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x10,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x10,0xd3,0x01,0x01,0x00,0x20]

v_cvt_i32_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x10,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x14,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x14,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x14,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x14,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x14,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x14,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x14,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x14,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x14,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x14,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x14,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x14,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x14,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x14,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x14,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x14,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x14,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x14,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x14,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x14,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x14,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x14,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x14,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x14,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x14,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x14,0xd3,0x01,0x01,0x00,0x20]

v_cvt_f16_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x14,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x16,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x16,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x16,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x16,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, s103
// CHECK: [0x05,0x00,0x16,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x16,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x16,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x16,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x16,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x16,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x16,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x16,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x16,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x16,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x16,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x16,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x16,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x16,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x16,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x16,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x16,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x16,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x16,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f32_f16_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x16,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f32_f16_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x16,0xd3,0x01,0x01,0x00,0x18]

v_cvt_rpi_i32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x18,0xd3,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x18,0xd3,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x18,0xd3,0xff,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x18,0xd3,0x01,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x18,0xd3,0x67,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x18,0xd3,0x68,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x18,0xd3,0x69,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x18,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x18,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x18,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x18,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x18,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x18,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x18,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x18,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x18,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x18,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x18,0xd3,0x80,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x18,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x18,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x18,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x18,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x18,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x18,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x18,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x18,0xd3,0x01,0x01,0x00,0x20]

v_cvt_rpi_i32_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x18,0xd3,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x1a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x1a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x1a,0xd3,0xff,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x1a,0xd3,0x01,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x1a,0xd3,0x67,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x1a,0xd3,0x68,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x1a,0xd3,0x69,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x1a,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x1a,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x1a,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x1a,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x1a,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x1a,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x1a,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x1a,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x1a,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x1a,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x1a,0xd3,0x80,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x1a,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x1a,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x1a,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x1a,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x1a,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x1a,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x1a,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x1a,0xd3,0x01,0x01,0x00,0x20]

v_cvt_flr_i32_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x1a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1
// CHECK: [0x05,0x00,0x1c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v255, v1
// CHECK: [0xff,0x00,0x1c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v255
// CHECK: [0x05,0x00,0x1c,0xd3,0xff,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, s1
// CHECK: [0x05,0x00,0x1c,0xd3,0x01,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, s103
// CHECK: [0x05,0x00,0x1c,0xd3,0x67,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x1c,0xd3,0x68,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x1c,0xd3,0x69,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x1c,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x1c,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x1c,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x1c,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x1c,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x1c,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x1c,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, m0
// CHECK: [0x05,0x00,0x1c,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x1c,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x1c,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, 0
// CHECK: [0x05,0x00,0x1c,0xd3,0x80,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, -1
// CHECK: [0x05,0x00,0x1c,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, 0.5
// CHECK: [0x05,0x00,0x1c,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, -4.0
// CHECK: [0x05,0x00,0x1c,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x1c,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, src_execz
// CHECK: [0x05,0x00,0x1c,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, src_scc
// CHECK: [0x05,0x00,0x1c,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x1c,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x1c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x1c,0xd3,0x01,0x01,0x00,0x08]

v_cvt_off_f32_i4_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x1c,0xd3,0x01,0x01,0x00,0x10]

v_cvt_off_f32_i4_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x1c,0xd3,0x01,0x01,0x00,0x18]

v_cvt_f32_f64_e64 v5, v[1:2]
// CHECK: [0x05,0x00,0x1e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v255, v[1:2]
// CHECK: [0xff,0x00,0x1e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[254:255]
// CHECK: [0x05,0x00,0x1e,0xd3,0xfe,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[2:3]
// CHECK: [0x05,0x00,0x1e,0xd3,0x02,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[4:5]
// CHECK: [0x05,0x00,0x1e,0xd3,0x04,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[102:103]
// CHECK: [0x05,0x00,0x1e,0xd3,0x66,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, flat_scratch
// CHECK: [0x05,0x00,0x1e,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, vcc
// CHECK: [0x05,0x00,0x1e,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, tba
// CHECK: [0x05,0x00,0x1e,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, tma
// CHECK: [0x05,0x00,0x1e,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, ttmp[10:11]
// CHECK: [0x05,0x00,0x1e,0xd3,0x7a,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, exec
// CHECK: [0x05,0x00,0x1e,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, 0
// CHECK: [0x05,0x00,0x1e,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -1
// CHECK: [0x05,0x00,0x1e,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, 0.5
// CHECK: [0x05,0x00,0x1e,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -4.0
// CHECK: [0x05,0x00,0x1e,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x1e,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, src_execz
// CHECK: [0x05,0x00,0x1e,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, src_scc
// CHECK: [0x05,0x00,0x1e,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -v[1:2]
// CHECK: [0x05,0x00,0x1e,0xd3,0x01,0x01,0x00,0x20]

v_cvt_f32_f64_e64 v5, |v[1:2]|
// CHECK: [0x05,0x01,0x1e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[1:2] clamp
// CHECK: [0x05,0x08,0x1e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[1:2] mul:2
// CHECK: [0x05,0x00,0x1e,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f32_f64_e64 v5, v[1:2] mul:4
// CHECK: [0x05,0x00,0x1e,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f32_f64_e64 v5, v[1:2] div:2
// CHECK: [0x05,0x00,0x1e,0xd3,0x01,0x01,0x00,0x18]

v_cvt_f64_f32_e64 v[5:6], v1
// CHECK: [0x05,0x00,0x20,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[254:255], v1
// CHECK: [0xfe,0x00,0x20,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v255
// CHECK: [0x05,0x00,0x20,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], s1
// CHECK: [0x05,0x00,0x20,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], s103
// CHECK: [0x05,0x00,0x20,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], flat_scratch_lo
// CHECK: [0x05,0x00,0x20,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], flat_scratch_hi
// CHECK: [0x05,0x00,0x20,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], vcc_lo
// CHECK: [0x05,0x00,0x20,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], vcc_hi
// CHECK: [0x05,0x00,0x20,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], tba_lo
// CHECK: [0x05,0x00,0x20,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], tba_hi
// CHECK: [0x05,0x00,0x20,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], tma_lo
// CHECK: [0x05,0x00,0x20,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], tma_hi
// CHECK: [0x05,0x00,0x20,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], ttmp11
// CHECK: [0x05,0x00,0x20,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], m0
// CHECK: [0x05,0x00,0x20,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], exec_lo
// CHECK: [0x05,0x00,0x20,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], exec_hi
// CHECK: [0x05,0x00,0x20,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x20,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x20,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x20,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x20,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x20,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x20,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x20,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], src_lds_direct
// CHECK: [0x05,0x00,0x20,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -v1
// CHECK: [0x05,0x00,0x20,0xd3,0x01,0x01,0x00,0x20]

v_cvt_f64_f32_e64 v[5:6], |v1|
// CHECK: [0x05,0x01,0x20,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v1 clamp
// CHECK: [0x05,0x08,0x20,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v1 mul:2
// CHECK: [0x05,0x00,0x20,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f64_f32_e64 v[5:6], v1 mul:4
// CHECK: [0x05,0x00,0x20,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f64_f32_e64 v[5:6], v1 div:2
// CHECK: [0x05,0x00,0x20,0xd3,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte0_e64 v5, v1
// CHECK: [0x05,0x00,0x22,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v255, v1
// CHECK: [0xff,0x00,0x22,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, v255
// CHECK: [0x05,0x00,0x22,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, s1
// CHECK: [0x05,0x00,0x22,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, s103
// CHECK: [0x05,0x00,0x22,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x22,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x22,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x22,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x22,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x22,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x22,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x22,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x22,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x22,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, m0
// CHECK: [0x05,0x00,0x22,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x22,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x22,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, 0
// CHECK: [0x05,0x00,0x22,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, -1
// CHECK: [0x05,0x00,0x22,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, 0.5
// CHECK: [0x05,0x00,0x22,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, -4.0
// CHECK: [0x05,0x00,0x22,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x22,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, src_execz
// CHECK: [0x05,0x00,0x22,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, src_scc
// CHECK: [0x05,0x00,0x22,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x22,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, v1
// CHECK: [0x05,0x00,0x24,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v255, v1
// CHECK: [0xff,0x00,0x24,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, v255
// CHECK: [0x05,0x00,0x24,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, s1
// CHECK: [0x05,0x00,0x24,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, s103
// CHECK: [0x05,0x00,0x24,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x24,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x24,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x24,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x24,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x24,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x24,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x24,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x24,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x24,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, m0
// CHECK: [0x05,0x00,0x24,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x24,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x24,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, 0
// CHECK: [0x05,0x00,0x24,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, -1
// CHECK: [0x05,0x00,0x24,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, 0.5
// CHECK: [0x05,0x00,0x24,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, -4.0
// CHECK: [0x05,0x00,0x24,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x24,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, src_execz
// CHECK: [0x05,0x00,0x24,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, src_scc
// CHECK: [0x05,0x00,0x24,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x24,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, v1
// CHECK: [0x05,0x00,0x26,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v255, v1
// CHECK: [0xff,0x00,0x26,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, v255
// CHECK: [0x05,0x00,0x26,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, s1
// CHECK: [0x05,0x00,0x26,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, s103
// CHECK: [0x05,0x00,0x26,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x26,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x26,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x26,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x26,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x26,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x26,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x26,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x26,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x26,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, m0
// CHECK: [0x05,0x00,0x26,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x26,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x26,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, 0
// CHECK: [0x05,0x00,0x26,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, -1
// CHECK: [0x05,0x00,0x26,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, 0.5
// CHECK: [0x05,0x00,0x26,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, -4.0
// CHECK: [0x05,0x00,0x26,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x26,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, src_execz
// CHECK: [0x05,0x00,0x26,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, src_scc
// CHECK: [0x05,0x00,0x26,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x26,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, v1
// CHECK: [0x05,0x00,0x28,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v255, v1
// CHECK: [0xff,0x00,0x28,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, v255
// CHECK: [0x05,0x00,0x28,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, s1
// CHECK: [0x05,0x00,0x28,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, s103
// CHECK: [0x05,0x00,0x28,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x28,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x28,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x28,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x28,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x28,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x28,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x28,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x28,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x28,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, m0
// CHECK: [0x05,0x00,0x28,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x28,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x28,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, 0
// CHECK: [0x05,0x00,0x28,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, -1
// CHECK: [0x05,0x00,0x28,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, 0.5
// CHECK: [0x05,0x00,0x28,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, -4.0
// CHECK: [0x05,0x00,0x28,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x28,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, src_execz
// CHECK: [0x05,0x00,0x28,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, src_scc
// CHECK: [0x05,0x00,0x28,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x28,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, v[1:2]
// CHECK: [0x05,0x00,0x2a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v255, v[1:2]
// CHECK: [0xff,0x00,0x2a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, v[254:255]
// CHECK: [0x05,0x00,0x2a,0xd3,0xfe,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[2:3]
// CHECK: [0x05,0x00,0x2a,0xd3,0x02,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[4:5]
// CHECK: [0x05,0x00,0x2a,0xd3,0x04,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[102:103]
// CHECK: [0x05,0x00,0x2a,0xd3,0x66,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, flat_scratch
// CHECK: [0x05,0x00,0x2a,0xd3,0x68,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, vcc
// CHECK: [0x05,0x00,0x2a,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, tba
// CHECK: [0x05,0x00,0x2a,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, tma
// CHECK: [0x05,0x00,0x2a,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, ttmp[10:11]
// CHECK: [0x05,0x00,0x2a,0xd3,0x7a,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, exec
// CHECK: [0x05,0x00,0x2a,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, 0
// CHECK: [0x05,0x00,0x2a,0xd3,0x80,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -1
// CHECK: [0x05,0x00,0x2a,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, 0.5
// CHECK: [0x05,0x00,0x2a,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -4.0
// CHECK: [0x05,0x00,0x2a,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x2a,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, src_execz
// CHECK: [0x05,0x00,0x2a,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, src_scc
// CHECK: [0x05,0x00,0x2a,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -v[1:2]
// CHECK: [0x05,0x00,0x2a,0xd3,0x01,0x01,0x00,0x20]

v_cvt_u32_f64_e64 v5, |v[1:2]|
// CHECK: [0x05,0x01,0x2a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v1
// CHECK: [0x05,0x00,0x2c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[254:255], v1
// CHECK: [0xfe,0x00,0x2c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v255
// CHECK: [0x05,0x00,0x2c,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], s1
// CHECK: [0x05,0x00,0x2c,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], s103
// CHECK: [0x05,0x00,0x2c,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], flat_scratch_lo
// CHECK: [0x05,0x00,0x2c,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], flat_scratch_hi
// CHECK: [0x05,0x00,0x2c,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], vcc_lo
// CHECK: [0x05,0x00,0x2c,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], vcc_hi
// CHECK: [0x05,0x00,0x2c,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], tba_lo
// CHECK: [0x05,0x00,0x2c,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], tba_hi
// CHECK: [0x05,0x00,0x2c,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], tma_lo
// CHECK: [0x05,0x00,0x2c,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], tma_hi
// CHECK: [0x05,0x00,0x2c,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], ttmp11
// CHECK: [0x05,0x00,0x2c,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], m0
// CHECK: [0x05,0x00,0x2c,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], exec_lo
// CHECK: [0x05,0x00,0x2c,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], exec_hi
// CHECK: [0x05,0x00,0x2c,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x2c,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x2c,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x2c,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x2c,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x2c,0xd3,0xfb,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x2c,0xd3,0xfc,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x2c,0xd3,0xfd,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], src_lds_direct
// CHECK: [0x05,0x00,0x2c,0xd3,0xfe,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v1 clamp
// CHECK: [0x05,0x08,0x2c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v1 mul:2
// CHECK: [0x05,0x00,0x2c,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f64_u32_e64 v[5:6], v1 mul:4
// CHECK: [0x05,0x00,0x2c,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f64_u32_e64 v[5:6], v1 div:2
// CHECK: [0x05,0x00,0x2c,0xd3,0x01,0x01,0x00,0x18]

v_trunc_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x2e,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x2e,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x2e,0xd3,0xfe,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x2e,0xd3,0x02,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x2e,0xd3,0x04,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x2e,0xd3,0x66,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x2e,0xd3,0x68,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x2e,0xd3,0x6a,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x2e,0xd3,0x6c,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x2e,0xd3,0x6e,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x2e,0xd3,0x7a,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x2e,0xd3,0x7e,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x2e,0xd3,0x80,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x2e,0xd3,0xc1,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x2e,0xd3,0xf0,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x2e,0xd3,0xf7,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x2e,0xd3,0xfb,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x2e,0xd3,0xfc,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x2e,0xd3,0xfd,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x2e,0xd3,0x01,0x01,0x00,0x20]

v_trunc_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x2e,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x2e,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x2e,0xd3,0x01,0x01,0x00,0x08]

v_trunc_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x2e,0xd3,0x01,0x01,0x00,0x10]

v_trunc_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x2e,0xd3,0x01,0x01,0x00,0x18]

v_ceil_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x30,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x30,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x30,0xd3,0xfe,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x30,0xd3,0x02,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x30,0xd3,0x04,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x30,0xd3,0x66,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x30,0xd3,0x68,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x30,0xd3,0x6a,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x30,0xd3,0x6c,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x30,0xd3,0x6e,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x30,0xd3,0x7a,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x30,0xd3,0x7e,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x30,0xd3,0x80,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x30,0xd3,0xc1,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x30,0xd3,0xf0,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x30,0xd3,0xf7,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x30,0xd3,0xfb,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x30,0xd3,0xfc,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x30,0xd3,0xfd,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x30,0xd3,0x01,0x01,0x00,0x20]

v_ceil_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x30,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x30,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x30,0xd3,0x01,0x01,0x00,0x08]

v_ceil_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x30,0xd3,0x01,0x01,0x00,0x10]

v_ceil_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x30,0xd3,0x01,0x01,0x00,0x18]

v_rndne_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x32,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x32,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x32,0xd3,0xfe,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x32,0xd3,0x02,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x32,0xd3,0x04,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x32,0xd3,0x66,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x32,0xd3,0x68,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x32,0xd3,0x6a,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x32,0xd3,0x6c,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x32,0xd3,0x6e,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x32,0xd3,0x7a,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x32,0xd3,0x7e,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x32,0xd3,0x80,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x32,0xd3,0xc1,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x32,0xd3,0xf0,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x32,0xd3,0xf7,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x32,0xd3,0xfb,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x32,0xd3,0xfc,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x32,0xd3,0xfd,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x32,0xd3,0x01,0x01,0x00,0x20]

v_rndne_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x32,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x32,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x32,0xd3,0x01,0x01,0x00,0x08]

v_rndne_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x32,0xd3,0x01,0x01,0x00,0x10]

v_rndne_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x32,0xd3,0x01,0x01,0x00,0x18]

v_floor_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x34,0xd3,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x34,0xd3,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x34,0xd3,0xfe,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x34,0xd3,0x02,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x34,0xd3,0x04,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x34,0xd3,0x66,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x34,0xd3,0x68,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x34,0xd3,0x6a,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x34,0xd3,0x6c,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x34,0xd3,0x6e,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x34,0xd3,0x7a,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x34,0xd3,0x7e,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x34,0xd3,0x80,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x34,0xd3,0xc1,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x34,0xd3,0xf0,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x34,0xd3,0xf7,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x34,0xd3,0xfb,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x34,0xd3,0xfc,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x34,0xd3,0xfd,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x34,0xd3,0x01,0x01,0x00,0x20]

v_floor_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x34,0xd3,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x34,0xd3,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x34,0xd3,0x01,0x01,0x00,0x08]

v_floor_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x34,0xd3,0x01,0x01,0x00,0x10]

v_floor_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x34,0xd3,0x01,0x01,0x00,0x18]

v_fract_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x40,0xd3,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x40,0xd3,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x40,0xd3,0xff,0x01,0x00,0x00]

v_fract_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x40,0xd3,0x01,0x00,0x00,0x00]

v_fract_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x40,0xd3,0x67,0x00,0x00,0x00]

v_fract_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x40,0xd3,0x68,0x00,0x00,0x00]

v_fract_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x40,0xd3,0x69,0x00,0x00,0x00]

v_fract_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x40,0xd3,0x6a,0x00,0x00,0x00]

v_fract_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x40,0xd3,0x6b,0x00,0x00,0x00]

v_fract_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x40,0xd3,0x6c,0x00,0x00,0x00]

v_fract_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x40,0xd3,0x6d,0x00,0x00,0x00]

v_fract_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x40,0xd3,0x6e,0x00,0x00,0x00]

v_fract_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x40,0xd3,0x6f,0x00,0x00,0x00]

v_fract_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x40,0xd3,0x7b,0x00,0x00,0x00]

v_fract_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x40,0xd3,0x7c,0x00,0x00,0x00]

v_fract_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x40,0xd3,0x7e,0x00,0x00,0x00]

v_fract_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x40,0xd3,0x7f,0x00,0x00,0x00]

v_fract_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x40,0xd3,0x80,0x00,0x00,0x00]

v_fract_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x40,0xd3,0xc1,0x00,0x00,0x00]

v_fract_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x40,0xd3,0xf0,0x00,0x00,0x00]

v_fract_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x40,0xd3,0xf7,0x00,0x00,0x00]

v_fract_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x40,0xd3,0xfb,0x00,0x00,0x00]

v_fract_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x40,0xd3,0xfc,0x00,0x00,0x00]

v_fract_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x40,0xd3,0xfd,0x00,0x00,0x00]

v_fract_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x40,0xd3,0xfe,0x00,0x00,0x00]

v_fract_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x40,0xd3,0x01,0x01,0x00,0x20]

v_fract_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x40,0xd3,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x40,0xd3,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x40,0xd3,0x01,0x01,0x00,0x08]

v_fract_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x40,0xd3,0x01,0x01,0x00,0x10]

v_fract_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x40,0xd3,0x01,0x01,0x00,0x18]

v_trunc_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x42,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x42,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x42,0xd3,0xff,0x01,0x00,0x00]

v_trunc_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x42,0xd3,0x01,0x00,0x00,0x00]

v_trunc_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x42,0xd3,0x67,0x00,0x00,0x00]

v_trunc_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x42,0xd3,0x68,0x00,0x00,0x00]

v_trunc_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x42,0xd3,0x69,0x00,0x00,0x00]

v_trunc_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x42,0xd3,0x6a,0x00,0x00,0x00]

v_trunc_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x42,0xd3,0x6b,0x00,0x00,0x00]

v_trunc_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x42,0xd3,0x6c,0x00,0x00,0x00]

v_trunc_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x42,0xd3,0x6d,0x00,0x00,0x00]

v_trunc_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x42,0xd3,0x6e,0x00,0x00,0x00]

v_trunc_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x42,0xd3,0x6f,0x00,0x00,0x00]

v_trunc_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x42,0xd3,0x7b,0x00,0x00,0x00]

v_trunc_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x42,0xd3,0x7c,0x00,0x00,0x00]

v_trunc_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x42,0xd3,0x7e,0x00,0x00,0x00]

v_trunc_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x42,0xd3,0x7f,0x00,0x00,0x00]

v_trunc_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x42,0xd3,0x80,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x42,0xd3,0xc1,0x00,0x00,0x00]

v_trunc_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x42,0xd3,0xf0,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x42,0xd3,0xf7,0x00,0x00,0x00]

v_trunc_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x42,0xd3,0xfb,0x00,0x00,0x00]

v_trunc_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x42,0xd3,0xfc,0x00,0x00,0x00]

v_trunc_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x42,0xd3,0xfd,0x00,0x00,0x00]

v_trunc_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x42,0xd3,0xfe,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x42,0xd3,0x01,0x01,0x00,0x20]

v_trunc_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x42,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x42,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x42,0xd3,0x01,0x01,0x00,0x08]

v_trunc_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x42,0xd3,0x01,0x01,0x00,0x10]

v_trunc_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x42,0xd3,0x01,0x01,0x00,0x18]

v_ceil_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x44,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x44,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x44,0xd3,0xff,0x01,0x00,0x00]

v_ceil_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x44,0xd3,0x01,0x00,0x00,0x00]

v_ceil_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x44,0xd3,0x67,0x00,0x00,0x00]

v_ceil_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x44,0xd3,0x68,0x00,0x00,0x00]

v_ceil_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x44,0xd3,0x69,0x00,0x00,0x00]

v_ceil_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x44,0xd3,0x6a,0x00,0x00,0x00]

v_ceil_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x44,0xd3,0x6b,0x00,0x00,0x00]

v_ceil_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x44,0xd3,0x6c,0x00,0x00,0x00]

v_ceil_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x44,0xd3,0x6d,0x00,0x00,0x00]

v_ceil_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x44,0xd3,0x6e,0x00,0x00,0x00]

v_ceil_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x44,0xd3,0x6f,0x00,0x00,0x00]

v_ceil_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x44,0xd3,0x7b,0x00,0x00,0x00]

v_ceil_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x44,0xd3,0x7c,0x00,0x00,0x00]

v_ceil_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x44,0xd3,0x7e,0x00,0x00,0x00]

v_ceil_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x44,0xd3,0x7f,0x00,0x00,0x00]

v_ceil_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x44,0xd3,0x80,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x44,0xd3,0xc1,0x00,0x00,0x00]

v_ceil_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x44,0xd3,0xf0,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x44,0xd3,0xf7,0x00,0x00,0x00]

v_ceil_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x44,0xd3,0xfb,0x00,0x00,0x00]

v_ceil_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x44,0xd3,0xfc,0x00,0x00,0x00]

v_ceil_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x44,0xd3,0xfd,0x00,0x00,0x00]

v_ceil_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x44,0xd3,0xfe,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x44,0xd3,0x01,0x01,0x00,0x20]

v_ceil_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x44,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x44,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x44,0xd3,0x01,0x01,0x00,0x08]

v_ceil_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x44,0xd3,0x01,0x01,0x00,0x10]

v_ceil_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x44,0xd3,0x01,0x01,0x00,0x18]

v_rndne_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x46,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x46,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x46,0xd3,0xff,0x01,0x00,0x00]

v_rndne_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x46,0xd3,0x01,0x00,0x00,0x00]

v_rndne_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x46,0xd3,0x67,0x00,0x00,0x00]

v_rndne_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x46,0xd3,0x68,0x00,0x00,0x00]

v_rndne_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x46,0xd3,0x69,0x00,0x00,0x00]

v_rndne_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x46,0xd3,0x6a,0x00,0x00,0x00]

v_rndne_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x46,0xd3,0x6b,0x00,0x00,0x00]

v_rndne_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x46,0xd3,0x6c,0x00,0x00,0x00]

v_rndne_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x46,0xd3,0x6d,0x00,0x00,0x00]

v_rndne_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x46,0xd3,0x6e,0x00,0x00,0x00]

v_rndne_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x46,0xd3,0x6f,0x00,0x00,0x00]

v_rndne_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x46,0xd3,0x7b,0x00,0x00,0x00]

v_rndne_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x46,0xd3,0x7c,0x00,0x00,0x00]

v_rndne_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x46,0xd3,0x7e,0x00,0x00,0x00]

v_rndne_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x46,0xd3,0x7f,0x00,0x00,0x00]

v_rndne_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x46,0xd3,0x80,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x46,0xd3,0xc1,0x00,0x00,0x00]

v_rndne_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x46,0xd3,0xf0,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x46,0xd3,0xf7,0x00,0x00,0x00]

v_rndne_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x46,0xd3,0xfb,0x00,0x00,0x00]

v_rndne_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x46,0xd3,0xfc,0x00,0x00,0x00]

v_rndne_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x46,0xd3,0xfd,0x00,0x00,0x00]

v_rndne_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x46,0xd3,0xfe,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x46,0xd3,0x01,0x01,0x00,0x20]

v_rndne_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x46,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x46,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x46,0xd3,0x01,0x01,0x00,0x08]

v_rndne_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x46,0xd3,0x01,0x01,0x00,0x10]

v_rndne_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x46,0xd3,0x01,0x01,0x00,0x18]

v_floor_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x48,0xd3,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x48,0xd3,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x48,0xd3,0xff,0x01,0x00,0x00]

v_floor_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x48,0xd3,0x01,0x00,0x00,0x00]

v_floor_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x48,0xd3,0x67,0x00,0x00,0x00]

v_floor_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x48,0xd3,0x68,0x00,0x00,0x00]

v_floor_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x48,0xd3,0x69,0x00,0x00,0x00]

v_floor_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x48,0xd3,0x6a,0x00,0x00,0x00]

v_floor_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x48,0xd3,0x6b,0x00,0x00,0x00]

v_floor_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x48,0xd3,0x6c,0x00,0x00,0x00]

v_floor_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x48,0xd3,0x6d,0x00,0x00,0x00]

v_floor_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x48,0xd3,0x6e,0x00,0x00,0x00]

v_floor_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x48,0xd3,0x6f,0x00,0x00,0x00]

v_floor_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x48,0xd3,0x7b,0x00,0x00,0x00]

v_floor_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x48,0xd3,0x7c,0x00,0x00,0x00]

v_floor_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x48,0xd3,0x7e,0x00,0x00,0x00]

v_floor_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x48,0xd3,0x7f,0x00,0x00,0x00]

v_floor_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x48,0xd3,0x80,0x00,0x00,0x00]

v_floor_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x48,0xd3,0xc1,0x00,0x00,0x00]

v_floor_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x48,0xd3,0xf0,0x00,0x00,0x00]

v_floor_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x48,0xd3,0xf7,0x00,0x00,0x00]

v_floor_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x48,0xd3,0xfb,0x00,0x00,0x00]

v_floor_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x48,0xd3,0xfc,0x00,0x00,0x00]

v_floor_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x48,0xd3,0xfd,0x00,0x00,0x00]

v_floor_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x48,0xd3,0xfe,0x00,0x00,0x00]

v_floor_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x48,0xd3,0x01,0x01,0x00,0x20]

v_floor_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x48,0xd3,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x48,0xd3,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x48,0xd3,0x01,0x01,0x00,0x08]

v_floor_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x48,0xd3,0x01,0x01,0x00,0x10]

v_floor_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x48,0xd3,0x01,0x01,0x00,0x18]

v_exp_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x4a,0xd3,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x4a,0xd3,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x4a,0xd3,0xff,0x01,0x00,0x00]

v_exp_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x4a,0xd3,0x01,0x00,0x00,0x00]

v_exp_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x4a,0xd3,0x67,0x00,0x00,0x00]

v_exp_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x4a,0xd3,0x68,0x00,0x00,0x00]

v_exp_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x4a,0xd3,0x69,0x00,0x00,0x00]

v_exp_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x4a,0xd3,0x6a,0x00,0x00,0x00]

v_exp_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x4a,0xd3,0x6b,0x00,0x00,0x00]

v_exp_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x4a,0xd3,0x6c,0x00,0x00,0x00]

v_exp_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x4a,0xd3,0x6d,0x00,0x00,0x00]

v_exp_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x4a,0xd3,0x6e,0x00,0x00,0x00]

v_exp_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x4a,0xd3,0x6f,0x00,0x00,0x00]

v_exp_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x4a,0xd3,0x7b,0x00,0x00,0x00]

v_exp_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x4a,0xd3,0x7c,0x00,0x00,0x00]

v_exp_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x4a,0xd3,0x7e,0x00,0x00,0x00]

v_exp_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x4a,0xd3,0x7f,0x00,0x00,0x00]

v_exp_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x4a,0xd3,0x80,0x00,0x00,0x00]

v_exp_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x4a,0xd3,0xc1,0x00,0x00,0x00]

v_exp_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x4a,0xd3,0xf0,0x00,0x00,0x00]

v_exp_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x4a,0xd3,0xf7,0x00,0x00,0x00]

v_exp_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x4a,0xd3,0xfb,0x00,0x00,0x00]

v_exp_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x4a,0xd3,0xfc,0x00,0x00,0x00]

v_exp_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x4a,0xd3,0xfd,0x00,0x00,0x00]

v_exp_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x4a,0xd3,0xfe,0x00,0x00,0x00]

v_exp_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x4a,0xd3,0x01,0x01,0x00,0x20]

v_exp_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x4a,0xd3,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x4a,0xd3,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x4a,0xd3,0x01,0x01,0x00,0x08]

v_exp_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x4a,0xd3,0x01,0x01,0x00,0x10]

v_exp_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x4a,0xd3,0x01,0x01,0x00,0x18]

v_log_clamp_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x4c,0xd3,0x01,0x01,0x00,0x00]

v_log_clamp_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x4c,0xd3,0x01,0x01,0x00,0x00]

v_log_clamp_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x4c,0xd3,0xff,0x01,0x00,0x00]

v_log_clamp_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x4c,0xd3,0x01,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x4c,0xd3,0x67,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x4c,0xd3,0x68,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x4c,0xd3,0x69,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x4c,0xd3,0x6a,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x4c,0xd3,0x6b,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x4c,0xd3,0x6c,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x4c,0xd3,0x6d,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x4c,0xd3,0x6e,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x4c,0xd3,0x6f,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x4c,0xd3,0x7b,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x4c,0xd3,0x7c,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x4c,0xd3,0x7e,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x4c,0xd3,0x7f,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x4c,0xd3,0x80,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x4c,0xd3,0xc1,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x4c,0xd3,0xf0,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x4c,0xd3,0xf7,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x4c,0xd3,0xfb,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x4c,0xd3,0xfc,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x4c,0xd3,0xfd,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x4c,0xd3,0xfe,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x4c,0xd3,0x01,0x01,0x00,0x20]

v_log_clamp_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x4c,0xd3,0x01,0x01,0x00,0x00]

v_log_clamp_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x4c,0xd3,0x01,0x01,0x00,0x00]

v_log_clamp_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x4c,0xd3,0x01,0x01,0x00,0x08]

v_log_clamp_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x4c,0xd3,0x01,0x01,0x00,0x10]

v_log_clamp_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x4c,0xd3,0x01,0x01,0x00,0x18]

v_log_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x4e,0xd3,0x01,0x01,0x00,0x00]

v_log_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x4e,0xd3,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x4e,0xd3,0xff,0x01,0x00,0x00]

v_log_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x4e,0xd3,0x01,0x00,0x00,0x00]

v_log_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x4e,0xd3,0x67,0x00,0x00,0x00]

v_log_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x4e,0xd3,0x68,0x00,0x00,0x00]

v_log_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x4e,0xd3,0x69,0x00,0x00,0x00]

v_log_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x4e,0xd3,0x6a,0x00,0x00,0x00]

v_log_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x4e,0xd3,0x6b,0x00,0x00,0x00]

v_log_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x4e,0xd3,0x6c,0x00,0x00,0x00]

v_log_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x4e,0xd3,0x6d,0x00,0x00,0x00]

v_log_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x4e,0xd3,0x6e,0x00,0x00,0x00]

v_log_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x4e,0xd3,0x6f,0x00,0x00,0x00]

v_log_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x4e,0xd3,0x7b,0x00,0x00,0x00]

v_log_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x4e,0xd3,0x7c,0x00,0x00,0x00]

v_log_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x4e,0xd3,0x7e,0x00,0x00,0x00]

v_log_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x4e,0xd3,0x7f,0x00,0x00,0x00]

v_log_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x4e,0xd3,0x80,0x00,0x00,0x00]

v_log_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x4e,0xd3,0xc1,0x00,0x00,0x00]

v_log_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x4e,0xd3,0xf0,0x00,0x00,0x00]

v_log_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x4e,0xd3,0xf7,0x00,0x00,0x00]

v_log_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x4e,0xd3,0xfb,0x00,0x00,0x00]

v_log_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x4e,0xd3,0xfc,0x00,0x00,0x00]

v_log_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x4e,0xd3,0xfd,0x00,0x00,0x00]

v_log_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x4e,0xd3,0xfe,0x00,0x00,0x00]

v_log_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x4e,0xd3,0x01,0x01,0x00,0x20]

v_log_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x4e,0xd3,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x4e,0xd3,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x4e,0xd3,0x01,0x01,0x00,0x08]

v_log_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x4e,0xd3,0x01,0x01,0x00,0x10]

v_log_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x4e,0xd3,0x01,0x01,0x00,0x18]

v_rcp_clamp_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x50,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x50,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x50,0xd3,0xff,0x01,0x00,0x00]

v_rcp_clamp_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x50,0xd3,0x01,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x50,0xd3,0x67,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x50,0xd3,0x68,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x50,0xd3,0x69,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x50,0xd3,0x6a,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x50,0xd3,0x6b,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x50,0xd3,0x6c,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x50,0xd3,0x6d,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x50,0xd3,0x6e,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x50,0xd3,0x6f,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x50,0xd3,0x7b,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x50,0xd3,0x7c,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x50,0xd3,0x7e,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x50,0xd3,0x7f,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x50,0xd3,0x80,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x50,0xd3,0xc1,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x50,0xd3,0xf0,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x50,0xd3,0xf7,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x50,0xd3,0xfb,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x50,0xd3,0xfc,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x50,0xd3,0xfd,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x50,0xd3,0xfe,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x50,0xd3,0x01,0x01,0x00,0x20]

v_rcp_clamp_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x50,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x50,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x50,0xd3,0x01,0x01,0x00,0x08]

v_rcp_clamp_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x50,0xd3,0x01,0x01,0x00,0x10]

v_rcp_clamp_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x50,0xd3,0x01,0x01,0x00,0x18]

v_rcp_legacy_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x52,0xd3,0x01,0x01,0x00,0x00]

v_rcp_legacy_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x52,0xd3,0x01,0x01,0x00,0x00]

v_rcp_legacy_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x52,0xd3,0xff,0x01,0x00,0x00]

v_rcp_legacy_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x52,0xd3,0x01,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x52,0xd3,0x67,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x52,0xd3,0x68,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x52,0xd3,0x69,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x52,0xd3,0x6a,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x52,0xd3,0x6b,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x52,0xd3,0x6c,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x52,0xd3,0x6d,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x52,0xd3,0x6e,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x52,0xd3,0x6f,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x52,0xd3,0x7b,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x52,0xd3,0x7c,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x52,0xd3,0x7e,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x52,0xd3,0x7f,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x52,0xd3,0x80,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x52,0xd3,0xc1,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x52,0xd3,0xf0,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x52,0xd3,0xf7,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x52,0xd3,0xfb,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x52,0xd3,0xfc,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x52,0xd3,0xfd,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x52,0xd3,0xfe,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x52,0xd3,0x01,0x01,0x00,0x20]

v_rcp_legacy_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x52,0xd3,0x01,0x01,0x00,0x00]

v_rcp_legacy_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x52,0xd3,0x01,0x01,0x00,0x00]

v_rcp_legacy_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x52,0xd3,0x01,0x01,0x00,0x08]

v_rcp_legacy_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x52,0xd3,0x01,0x01,0x00,0x10]

v_rcp_legacy_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x52,0xd3,0x01,0x01,0x00,0x18]

v_rcp_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x54,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x54,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x54,0xd3,0xff,0x01,0x00,0x00]

v_rcp_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x54,0xd3,0x01,0x00,0x00,0x00]

v_rcp_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x54,0xd3,0x67,0x00,0x00,0x00]

v_rcp_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x54,0xd3,0x68,0x00,0x00,0x00]

v_rcp_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x54,0xd3,0x69,0x00,0x00,0x00]

v_rcp_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x54,0xd3,0x6a,0x00,0x00,0x00]

v_rcp_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x54,0xd3,0x6b,0x00,0x00,0x00]

v_rcp_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x54,0xd3,0x6c,0x00,0x00,0x00]

v_rcp_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x54,0xd3,0x6d,0x00,0x00,0x00]

v_rcp_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x54,0xd3,0x6e,0x00,0x00,0x00]

v_rcp_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x54,0xd3,0x6f,0x00,0x00,0x00]

v_rcp_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x54,0xd3,0x7b,0x00,0x00,0x00]

v_rcp_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x54,0xd3,0x7c,0x00,0x00,0x00]

v_rcp_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x54,0xd3,0x7e,0x00,0x00,0x00]

v_rcp_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x54,0xd3,0x7f,0x00,0x00,0x00]

v_rcp_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x54,0xd3,0x80,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x54,0xd3,0xc1,0x00,0x00,0x00]

v_rcp_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x54,0xd3,0xf0,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x54,0xd3,0xf7,0x00,0x00,0x00]

v_rcp_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x54,0xd3,0xfb,0x00,0x00,0x00]

v_rcp_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x54,0xd3,0xfc,0x00,0x00,0x00]

v_rcp_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x54,0xd3,0xfd,0x00,0x00,0x00]

v_rcp_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x54,0xd3,0xfe,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x54,0xd3,0x01,0x01,0x00,0x20]

v_rcp_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x54,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x54,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x54,0xd3,0x01,0x01,0x00,0x08]

v_rcp_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x54,0xd3,0x01,0x01,0x00,0x10]

v_rcp_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x54,0xd3,0x01,0x01,0x00,0x18]

v_rcp_iflag_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x56,0xd3,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x56,0xd3,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x56,0xd3,0xff,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x56,0xd3,0x01,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x56,0xd3,0x67,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x56,0xd3,0x68,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x56,0xd3,0x69,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x56,0xd3,0x6a,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x56,0xd3,0x6b,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x56,0xd3,0x6c,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x56,0xd3,0x6d,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x56,0xd3,0x6e,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x56,0xd3,0x6f,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x56,0xd3,0x7b,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x56,0xd3,0x7c,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x56,0xd3,0x7e,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x56,0xd3,0x7f,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x56,0xd3,0x80,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x56,0xd3,0xc1,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x56,0xd3,0xf0,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x56,0xd3,0xf7,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x56,0xd3,0xfb,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x56,0xd3,0xfc,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x56,0xd3,0xfd,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x56,0xd3,0xfe,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x56,0xd3,0x01,0x01,0x00,0x20]

v_rcp_iflag_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x56,0xd3,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x56,0xd3,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x56,0xd3,0x01,0x01,0x00,0x08]

v_rcp_iflag_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x56,0xd3,0x01,0x01,0x00,0x10]

v_rcp_iflag_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x56,0xd3,0x01,0x01,0x00,0x18]

v_rsq_clamp_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x58,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x58,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x58,0xd3,0xff,0x01,0x00,0x00]

v_rsq_clamp_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x58,0xd3,0x01,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x58,0xd3,0x67,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x58,0xd3,0x68,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x58,0xd3,0x69,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x58,0xd3,0x6a,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x58,0xd3,0x6b,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x58,0xd3,0x6c,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x58,0xd3,0x6d,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x58,0xd3,0x6e,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x58,0xd3,0x6f,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x58,0xd3,0x7b,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x58,0xd3,0x7c,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x58,0xd3,0x7e,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x58,0xd3,0x7f,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x58,0xd3,0x80,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x58,0xd3,0xc1,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x58,0xd3,0xf0,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x58,0xd3,0xf7,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x58,0xd3,0xfb,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x58,0xd3,0xfc,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x58,0xd3,0xfd,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x58,0xd3,0xfe,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x58,0xd3,0x01,0x01,0x00,0x20]

v_rsq_clamp_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x58,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x58,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x58,0xd3,0x01,0x01,0x00,0x08]

v_rsq_clamp_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x58,0xd3,0x01,0x01,0x00,0x10]

v_rsq_clamp_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x58,0xd3,0x01,0x01,0x00,0x18]

v_rsq_legacy_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x5a,0xd3,0x01,0x01,0x00,0x00]

v_rsq_legacy_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x5a,0xd3,0x01,0x01,0x00,0x00]

v_rsq_legacy_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x5a,0xd3,0xff,0x01,0x00,0x00]

v_rsq_legacy_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x5a,0xd3,0x01,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x5a,0xd3,0x67,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x5a,0xd3,0x68,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x5a,0xd3,0x69,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x5a,0xd3,0x6a,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x5a,0xd3,0x6b,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x5a,0xd3,0x6c,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x5a,0xd3,0x6d,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x5a,0xd3,0x6e,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x5a,0xd3,0x6f,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x5a,0xd3,0x7b,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x5a,0xd3,0x7c,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x5a,0xd3,0x7e,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x5a,0xd3,0x7f,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x5a,0xd3,0x80,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x5a,0xd3,0xc1,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x5a,0xd3,0xf0,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x5a,0xd3,0xf7,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x5a,0xd3,0xfb,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x5a,0xd3,0xfc,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x5a,0xd3,0xfd,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x5a,0xd3,0xfe,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x5a,0xd3,0x01,0x01,0x00,0x20]

v_rsq_legacy_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x5a,0xd3,0x01,0x01,0x00,0x00]

v_rsq_legacy_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x5a,0xd3,0x01,0x01,0x00,0x00]

v_rsq_legacy_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x5a,0xd3,0x01,0x01,0x00,0x08]

v_rsq_legacy_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x5a,0xd3,0x01,0x01,0x00,0x10]

v_rsq_legacy_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x5a,0xd3,0x01,0x01,0x00,0x18]

v_rsq_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x5c,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x5c,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x5c,0xd3,0xff,0x01,0x00,0x00]

v_rsq_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x5c,0xd3,0x01,0x00,0x00,0x00]

v_rsq_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x5c,0xd3,0x67,0x00,0x00,0x00]

v_rsq_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x5c,0xd3,0x68,0x00,0x00,0x00]

v_rsq_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x5c,0xd3,0x69,0x00,0x00,0x00]

v_rsq_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x5c,0xd3,0x6a,0x00,0x00,0x00]

v_rsq_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x5c,0xd3,0x6b,0x00,0x00,0x00]

v_rsq_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x5c,0xd3,0x6c,0x00,0x00,0x00]

v_rsq_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x5c,0xd3,0x6d,0x00,0x00,0x00]

v_rsq_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x5c,0xd3,0x6e,0x00,0x00,0x00]

v_rsq_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x5c,0xd3,0x6f,0x00,0x00,0x00]

v_rsq_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x5c,0xd3,0x7b,0x00,0x00,0x00]

v_rsq_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x5c,0xd3,0x7c,0x00,0x00,0x00]

v_rsq_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x5c,0xd3,0x7e,0x00,0x00,0x00]

v_rsq_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x5c,0xd3,0x7f,0x00,0x00,0x00]

v_rsq_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x5c,0xd3,0x80,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x5c,0xd3,0xc1,0x00,0x00,0x00]

v_rsq_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x5c,0xd3,0xf0,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x5c,0xd3,0xf7,0x00,0x00,0x00]

v_rsq_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x5c,0xd3,0xfb,0x00,0x00,0x00]

v_rsq_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x5c,0xd3,0xfc,0x00,0x00,0x00]

v_rsq_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x5c,0xd3,0xfd,0x00,0x00,0x00]

v_rsq_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x5c,0xd3,0xfe,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x5c,0xd3,0x01,0x01,0x00,0x20]

v_rsq_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x5c,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x5c,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x5c,0xd3,0x01,0x01,0x00,0x08]

v_rsq_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x5c,0xd3,0x01,0x01,0x00,0x10]

v_rsq_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x5c,0xd3,0x01,0x01,0x00,0x18]

v_rcp_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x5e,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x5e,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x5e,0xd3,0xfe,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x5e,0xd3,0x02,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x5e,0xd3,0x04,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x5e,0xd3,0x66,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x5e,0xd3,0x68,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x5e,0xd3,0x6a,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x5e,0xd3,0x6c,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x5e,0xd3,0x6e,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x5e,0xd3,0x7a,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x5e,0xd3,0x7e,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x5e,0xd3,0x80,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x5e,0xd3,0xc1,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x5e,0xd3,0xf0,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x5e,0xd3,0xf7,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x5e,0xd3,0xfb,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x5e,0xd3,0xfc,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x5e,0xd3,0xfd,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x5e,0xd3,0x01,0x01,0x00,0x20]

v_rcp_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x5e,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x5e,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x5e,0xd3,0x01,0x01,0x00,0x08]

v_rcp_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x5e,0xd3,0x01,0x01,0x00,0x10]

v_rcp_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x5e,0xd3,0x01,0x01,0x00,0x18]

v_rcp_clamp_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x60,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x60,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x60,0xd3,0xfe,0x01,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x60,0xd3,0x02,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x60,0xd3,0x04,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x60,0xd3,0x66,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x60,0xd3,0x68,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x60,0xd3,0x6a,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x60,0xd3,0x6c,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x60,0xd3,0x6e,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x60,0xd3,0x7a,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x60,0xd3,0x7e,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x60,0xd3,0x80,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x60,0xd3,0xc1,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x60,0xd3,0xf0,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x60,0xd3,0xf7,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x60,0xd3,0xfb,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x60,0xd3,0xfc,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x60,0xd3,0xfd,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x60,0xd3,0x01,0x01,0x00,0x20]

v_rcp_clamp_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x60,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x60,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x60,0xd3,0x01,0x01,0x00,0x08]

v_rcp_clamp_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x60,0xd3,0x01,0x01,0x00,0x10]

v_rcp_clamp_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x60,0xd3,0x01,0x01,0x00,0x18]

v_rsq_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x62,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x62,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x62,0xd3,0xfe,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x62,0xd3,0x02,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x62,0xd3,0x04,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x62,0xd3,0x66,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x62,0xd3,0x68,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x62,0xd3,0x6a,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x62,0xd3,0x6c,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x62,0xd3,0x6e,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x62,0xd3,0x7a,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x62,0xd3,0x7e,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x62,0xd3,0x80,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x62,0xd3,0xc1,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x62,0xd3,0xf0,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x62,0xd3,0xf7,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x62,0xd3,0xfb,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x62,0xd3,0xfc,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x62,0xd3,0xfd,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x62,0xd3,0x01,0x01,0x00,0x20]

v_rsq_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x62,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x62,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x62,0xd3,0x01,0x01,0x00,0x08]

v_rsq_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x62,0xd3,0x01,0x01,0x00,0x10]

v_rsq_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x62,0xd3,0x01,0x01,0x00,0x18]

v_rsq_clamp_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x64,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x64,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x64,0xd3,0xfe,0x01,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x64,0xd3,0x02,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x64,0xd3,0x04,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x64,0xd3,0x66,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x64,0xd3,0x68,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x64,0xd3,0x6a,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x64,0xd3,0x6c,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x64,0xd3,0x6e,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x64,0xd3,0x7a,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x64,0xd3,0x7e,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x64,0xd3,0x80,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x64,0xd3,0xc1,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x64,0xd3,0xf0,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x64,0xd3,0xf7,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x64,0xd3,0xfb,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x64,0xd3,0xfc,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x64,0xd3,0xfd,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x64,0xd3,0x01,0x01,0x00,0x20]

v_rsq_clamp_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x64,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x64,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x64,0xd3,0x01,0x01,0x00,0x08]

v_rsq_clamp_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x64,0xd3,0x01,0x01,0x00,0x10]

v_rsq_clamp_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x64,0xd3,0x01,0x01,0x00,0x18]

v_sqrt_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x66,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x66,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x66,0xd3,0xff,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x66,0xd3,0x01,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x66,0xd3,0x67,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x66,0xd3,0x68,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x66,0xd3,0x69,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x66,0xd3,0x6a,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x66,0xd3,0x6b,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x66,0xd3,0x6c,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x66,0xd3,0x6d,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x66,0xd3,0x6e,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x66,0xd3,0x6f,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x66,0xd3,0x7b,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x66,0xd3,0x7c,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x66,0xd3,0x7e,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x66,0xd3,0x7f,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x66,0xd3,0x80,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x66,0xd3,0xc1,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x66,0xd3,0xf0,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x66,0xd3,0xf7,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x66,0xd3,0xfb,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x66,0xd3,0xfc,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x66,0xd3,0xfd,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x66,0xd3,0xfe,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x66,0xd3,0x01,0x01,0x00,0x20]

v_sqrt_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x66,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x66,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x66,0xd3,0x01,0x01,0x00,0x08]

v_sqrt_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x66,0xd3,0x01,0x01,0x00,0x10]

v_sqrt_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x66,0xd3,0x01,0x01,0x00,0x18]

v_sqrt_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x68,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x68,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x68,0xd3,0xfe,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x68,0xd3,0x02,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x68,0xd3,0x04,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x68,0xd3,0x66,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x68,0xd3,0x68,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x68,0xd3,0x6a,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x68,0xd3,0x6c,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x68,0xd3,0x6e,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x68,0xd3,0x7a,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x68,0xd3,0x7e,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x68,0xd3,0x80,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x68,0xd3,0xc1,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x68,0xd3,0xf0,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x68,0xd3,0xf7,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x68,0xd3,0xfb,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x68,0xd3,0xfc,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x68,0xd3,0xfd,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x68,0xd3,0x01,0x01,0x00,0x20]

v_sqrt_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x68,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x68,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x68,0xd3,0x01,0x01,0x00,0x08]

v_sqrt_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x68,0xd3,0x01,0x01,0x00,0x10]

v_sqrt_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x68,0xd3,0x01,0x01,0x00,0x18]

v_sin_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x6a,0xd3,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x6a,0xd3,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x6a,0xd3,0xff,0x01,0x00,0x00]

v_sin_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x6a,0xd3,0x01,0x00,0x00,0x00]

v_sin_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x6a,0xd3,0x67,0x00,0x00,0x00]

v_sin_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x6a,0xd3,0x68,0x00,0x00,0x00]

v_sin_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x6a,0xd3,0x69,0x00,0x00,0x00]

v_sin_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x6a,0xd3,0x6a,0x00,0x00,0x00]

v_sin_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x6a,0xd3,0x6b,0x00,0x00,0x00]

v_sin_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x6a,0xd3,0x6c,0x00,0x00,0x00]

v_sin_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x6a,0xd3,0x6d,0x00,0x00,0x00]

v_sin_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x6a,0xd3,0x6e,0x00,0x00,0x00]

v_sin_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x6a,0xd3,0x6f,0x00,0x00,0x00]

v_sin_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x6a,0xd3,0x7b,0x00,0x00,0x00]

v_sin_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x6a,0xd3,0x7c,0x00,0x00,0x00]

v_sin_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x6a,0xd3,0x7e,0x00,0x00,0x00]

v_sin_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x6a,0xd3,0x7f,0x00,0x00,0x00]

v_sin_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x6a,0xd3,0x80,0x00,0x00,0x00]

v_sin_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x6a,0xd3,0xc1,0x00,0x00,0x00]

v_sin_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x6a,0xd3,0xf0,0x00,0x00,0x00]

v_sin_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x6a,0xd3,0xf7,0x00,0x00,0x00]

v_sin_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x6a,0xd3,0xfb,0x00,0x00,0x00]

v_sin_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x6a,0xd3,0xfc,0x00,0x00,0x00]

v_sin_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x6a,0xd3,0xfd,0x00,0x00,0x00]

v_sin_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x6a,0xd3,0xfe,0x00,0x00,0x00]

v_sin_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x6a,0xd3,0x01,0x01,0x00,0x20]

v_sin_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x6a,0xd3,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x6a,0xd3,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x6a,0xd3,0x01,0x01,0x00,0x08]

v_sin_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x6a,0xd3,0x01,0x01,0x00,0x10]

v_sin_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x6a,0xd3,0x01,0x01,0x00,0x18]

v_cos_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x6c,0xd3,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x6c,0xd3,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x6c,0xd3,0xff,0x01,0x00,0x00]

v_cos_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x6c,0xd3,0x01,0x00,0x00,0x00]

v_cos_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x6c,0xd3,0x67,0x00,0x00,0x00]

v_cos_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x6c,0xd3,0x68,0x00,0x00,0x00]

v_cos_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x6c,0xd3,0x69,0x00,0x00,0x00]

v_cos_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x6c,0xd3,0x6a,0x00,0x00,0x00]

v_cos_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x6c,0xd3,0x6b,0x00,0x00,0x00]

v_cos_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x6c,0xd3,0x6c,0x00,0x00,0x00]

v_cos_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x6c,0xd3,0x6d,0x00,0x00,0x00]

v_cos_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x6c,0xd3,0x6e,0x00,0x00,0x00]

v_cos_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x6c,0xd3,0x6f,0x00,0x00,0x00]

v_cos_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x6c,0xd3,0x7b,0x00,0x00,0x00]

v_cos_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x6c,0xd3,0x7c,0x00,0x00,0x00]

v_cos_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x6c,0xd3,0x7e,0x00,0x00,0x00]

v_cos_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x6c,0xd3,0x7f,0x00,0x00,0x00]

v_cos_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x6c,0xd3,0x80,0x00,0x00,0x00]

v_cos_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x6c,0xd3,0xc1,0x00,0x00,0x00]

v_cos_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x6c,0xd3,0xf0,0x00,0x00,0x00]

v_cos_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x6c,0xd3,0xf7,0x00,0x00,0x00]

v_cos_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x6c,0xd3,0xfb,0x00,0x00,0x00]

v_cos_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x6c,0xd3,0xfc,0x00,0x00,0x00]

v_cos_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x6c,0xd3,0xfd,0x00,0x00,0x00]

v_cos_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x6c,0xd3,0xfe,0x00,0x00,0x00]

v_cos_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x6c,0xd3,0x01,0x01,0x00,0x20]

v_cos_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x6c,0xd3,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x6c,0xd3,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x6c,0xd3,0x01,0x01,0x00,0x08]

v_cos_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x6c,0xd3,0x01,0x01,0x00,0x10]

v_cos_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x6c,0xd3,0x01,0x01,0x00,0x18]

v_not_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x6e,0xd3,0x01,0x01,0x00,0x00]

v_not_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x6e,0xd3,0x01,0x01,0x00,0x00]

v_not_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x6e,0xd3,0xff,0x01,0x00,0x00]

v_not_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x6e,0xd3,0x01,0x00,0x00,0x00]

v_not_b32_e64 v5, s103
// CHECK: [0x05,0x00,0x6e,0xd3,0x67,0x00,0x00,0x00]

v_not_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x6e,0xd3,0x68,0x00,0x00,0x00]

v_not_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x6e,0xd3,0x69,0x00,0x00,0x00]

v_not_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x6e,0xd3,0x6a,0x00,0x00,0x00]

v_not_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x6e,0xd3,0x6b,0x00,0x00,0x00]

v_not_b32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x6e,0xd3,0x6c,0x00,0x00,0x00]

v_not_b32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x6e,0xd3,0x6d,0x00,0x00,0x00]

v_not_b32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x6e,0xd3,0x6e,0x00,0x00,0x00]

v_not_b32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x6e,0xd3,0x6f,0x00,0x00,0x00]

v_not_b32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x6e,0xd3,0x7b,0x00,0x00,0x00]

v_not_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x6e,0xd3,0x7c,0x00,0x00,0x00]

v_not_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x6e,0xd3,0x7e,0x00,0x00,0x00]

v_not_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x6e,0xd3,0x7f,0x00,0x00,0x00]

v_not_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x6e,0xd3,0x80,0x00,0x00,0x00]

v_not_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x6e,0xd3,0xc1,0x00,0x00,0x00]

v_not_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x6e,0xd3,0xf0,0x00,0x00,0x00]

v_not_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x6e,0xd3,0xf7,0x00,0x00,0x00]

v_not_b32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x6e,0xd3,0xfb,0x00,0x00,0x00]

v_not_b32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x6e,0xd3,0xfc,0x00,0x00,0x00]

v_not_b32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x6e,0xd3,0xfd,0x00,0x00,0x00]

v_not_b32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x6e,0xd3,0xfe,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x70,0xd3,0x01,0x01,0x00,0x00]

v_bfrev_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x70,0xd3,0x01,0x01,0x00,0x00]

v_bfrev_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x70,0xd3,0xff,0x01,0x00,0x00]

v_bfrev_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x70,0xd3,0x01,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, s103
// CHECK: [0x05,0x00,0x70,0xd3,0x67,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x70,0xd3,0x68,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x70,0xd3,0x69,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x70,0xd3,0x6a,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x70,0xd3,0x6b,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x70,0xd3,0x6c,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x70,0xd3,0x6d,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x70,0xd3,0x6e,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x70,0xd3,0x6f,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x70,0xd3,0x7b,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x70,0xd3,0x7c,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x70,0xd3,0x7e,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x70,0xd3,0x7f,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x70,0xd3,0x80,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x70,0xd3,0xc1,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x70,0xd3,0xf0,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x70,0xd3,0xf7,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x70,0xd3,0xfb,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x70,0xd3,0xfc,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x70,0xd3,0xfd,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x70,0xd3,0xfe,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, v1
// CHECK: [0x05,0x00,0x72,0xd3,0x01,0x01,0x00,0x00]

v_ffbh_u32_e64 v255, v1
// CHECK: [0xff,0x00,0x72,0xd3,0x01,0x01,0x00,0x00]

v_ffbh_u32_e64 v5, v255
// CHECK: [0x05,0x00,0x72,0xd3,0xff,0x01,0x00,0x00]

v_ffbh_u32_e64 v5, s1
// CHECK: [0x05,0x00,0x72,0xd3,0x01,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, s103
// CHECK: [0x05,0x00,0x72,0xd3,0x67,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x72,0xd3,0x68,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x72,0xd3,0x69,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x72,0xd3,0x6a,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x72,0xd3,0x6b,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x72,0xd3,0x6c,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x72,0xd3,0x6d,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x72,0xd3,0x6e,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x72,0xd3,0x6f,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x72,0xd3,0x7b,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, m0
// CHECK: [0x05,0x00,0x72,0xd3,0x7c,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x72,0xd3,0x7e,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x72,0xd3,0x7f,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, 0
// CHECK: [0x05,0x00,0x72,0xd3,0x80,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, -1
// CHECK: [0x05,0x00,0x72,0xd3,0xc1,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x72,0xd3,0xf0,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x72,0xd3,0xf7,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x72,0xd3,0xfb,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x72,0xd3,0xfc,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x72,0xd3,0xfd,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x72,0xd3,0xfe,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x74,0xd3,0x01,0x01,0x00,0x00]

v_ffbl_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x74,0xd3,0x01,0x01,0x00,0x00]

v_ffbl_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x74,0xd3,0xff,0x01,0x00,0x00]

v_ffbl_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x74,0xd3,0x01,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, s103
// CHECK: [0x05,0x00,0x74,0xd3,0x67,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x74,0xd3,0x68,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x74,0xd3,0x69,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x74,0xd3,0x6a,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x74,0xd3,0x6b,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x74,0xd3,0x6c,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x74,0xd3,0x6d,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x74,0xd3,0x6e,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x74,0xd3,0x6f,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x74,0xd3,0x7b,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x74,0xd3,0x7c,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x74,0xd3,0x7e,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x74,0xd3,0x7f,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x74,0xd3,0x80,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x74,0xd3,0xc1,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x74,0xd3,0xf0,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x74,0xd3,0xf7,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x74,0xd3,0xfb,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x74,0xd3,0xfc,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x74,0xd3,0xfd,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x74,0xd3,0xfe,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, v1
// CHECK: [0x05,0x00,0x76,0xd3,0x01,0x01,0x00,0x00]

v_ffbh_i32_e64 v255, v1
// CHECK: [0xff,0x00,0x76,0xd3,0x01,0x01,0x00,0x00]

v_ffbh_i32_e64 v5, v255
// CHECK: [0x05,0x00,0x76,0xd3,0xff,0x01,0x00,0x00]

v_ffbh_i32_e64 v5, s1
// CHECK: [0x05,0x00,0x76,0xd3,0x01,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, s103
// CHECK: [0x05,0x00,0x76,0xd3,0x67,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x76,0xd3,0x68,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x76,0xd3,0x69,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x76,0xd3,0x6a,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x76,0xd3,0x6b,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x76,0xd3,0x6c,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x76,0xd3,0x6d,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x76,0xd3,0x6e,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x76,0xd3,0x6f,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x76,0xd3,0x7b,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, m0
// CHECK: [0x05,0x00,0x76,0xd3,0x7c,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x76,0xd3,0x7e,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x76,0xd3,0x7f,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, 0
// CHECK: [0x05,0x00,0x76,0xd3,0x80,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, -1
// CHECK: [0x05,0x00,0x76,0xd3,0xc1,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x76,0xd3,0xf0,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x76,0xd3,0xf7,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x76,0xd3,0xfb,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x76,0xd3,0xfc,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x76,0xd3,0xfd,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x76,0xd3,0xfe,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, v[1:2]
// CHECK: [0x05,0x00,0x78,0xd3,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v255, v[1:2]
// CHECK: [0xff,0x00,0x78,0xd3,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, v[254:255]
// CHECK: [0x05,0x00,0x78,0xd3,0xfe,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[2:3]
// CHECK: [0x05,0x00,0x78,0xd3,0x02,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[4:5]
// CHECK: [0x05,0x00,0x78,0xd3,0x04,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[102:103]
// CHECK: [0x05,0x00,0x78,0xd3,0x66,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, flat_scratch
// CHECK: [0x05,0x00,0x78,0xd3,0x68,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, vcc
// CHECK: [0x05,0x00,0x78,0xd3,0x6a,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, tba
// CHECK: [0x05,0x00,0x78,0xd3,0x6c,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, tma
// CHECK: [0x05,0x00,0x78,0xd3,0x6e,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, ttmp[10:11]
// CHECK: [0x05,0x00,0x78,0xd3,0x7a,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, exec
// CHECK: [0x05,0x00,0x78,0xd3,0x7e,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, 0
// CHECK: [0x05,0x00,0x78,0xd3,0x80,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -1
// CHECK: [0x05,0x00,0x78,0xd3,0xc1,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, 0.5
// CHECK: [0x05,0x00,0x78,0xd3,0xf0,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -4.0
// CHECK: [0x05,0x00,0x78,0xd3,0xf7,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x78,0xd3,0xfb,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, src_execz
// CHECK: [0x05,0x00,0x78,0xd3,0xfc,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, src_scc
// CHECK: [0x05,0x00,0x78,0xd3,0xfd,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -v[1:2]
// CHECK: [0x05,0x00,0x78,0xd3,0x01,0x01,0x00,0x20]

v_frexp_exp_i32_f64_e64 v5, |v[1:2]|
// CHECK: [0x05,0x01,0x78,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x7a,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x7a,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x7a,0xd3,0xfe,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x7a,0xd3,0x02,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x7a,0xd3,0x04,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x7a,0xd3,0x66,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x7a,0xd3,0x68,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x7a,0xd3,0x6a,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x7a,0xd3,0x6c,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x7a,0xd3,0x6e,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x7a,0xd3,0x7a,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x7a,0xd3,0x7e,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x7a,0xd3,0x80,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x7a,0xd3,0xc1,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x7a,0xd3,0xf0,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x7a,0xd3,0xf7,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x7a,0xd3,0xfb,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x7a,0xd3,0xfc,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x7a,0xd3,0xfd,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x7a,0xd3,0x01,0x01,0x00,0x20]

v_frexp_mant_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x7a,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x7a,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x7a,0xd3,0x01,0x01,0x00,0x08]

v_frexp_mant_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x7a,0xd3,0x01,0x01,0x00,0x10]

v_frexp_mant_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x7a,0xd3,0x01,0x01,0x00,0x18]

v_fract_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x7c,0xd3,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x7c,0xd3,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x7c,0xd3,0xfe,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x7c,0xd3,0x02,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x7c,0xd3,0x04,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x7c,0xd3,0x66,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x7c,0xd3,0x68,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x7c,0xd3,0x6a,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x7c,0xd3,0x6c,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x7c,0xd3,0x6e,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x7c,0xd3,0x7a,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x7c,0xd3,0x7e,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x7c,0xd3,0x80,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x7c,0xd3,0xc1,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x7c,0xd3,0xf0,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x7c,0xd3,0xf7,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x7c,0xd3,0xfb,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x7c,0xd3,0xfc,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x7c,0xd3,0xfd,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x7c,0xd3,0x01,0x01,0x00,0x20]

v_fract_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x7c,0xd3,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x7c,0xd3,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x7c,0xd3,0x01,0x01,0x00,0x08]

v_fract_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x7c,0xd3,0x01,0x01,0x00,0x10]

v_fract_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x7c,0xd3,0x01,0x01,0x00,0x18]

v_frexp_exp_i32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x7e,0xd3,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x7e,0xd3,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x7e,0xd3,0xff,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x7e,0xd3,0x01,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x7e,0xd3,0x67,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x7e,0xd3,0x68,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x7e,0xd3,0x69,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x7e,0xd3,0x6a,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x7e,0xd3,0x6b,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x7e,0xd3,0x6c,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x7e,0xd3,0x6d,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x7e,0xd3,0x6e,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x7e,0xd3,0x6f,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x7e,0xd3,0x7b,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x7e,0xd3,0x7c,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x7e,0xd3,0x7e,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x7e,0xd3,0x7f,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x7e,0xd3,0x80,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x7e,0xd3,0xc1,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x7e,0xd3,0xf0,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x7e,0xd3,0xf7,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x7e,0xd3,0xfb,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x7e,0xd3,0xfc,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x7e,0xd3,0xfd,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x7e,0xd3,0xfe,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x80,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x80,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x80,0xd3,0xff,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x80,0xd3,0x01,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x80,0xd3,0x67,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x80,0xd3,0x68,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x80,0xd3,0x69,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x80,0xd3,0x6a,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x80,0xd3,0x6b,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x80,0xd3,0x6c,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x80,0xd3,0x6d,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x80,0xd3,0x6e,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x80,0xd3,0x6f,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x80,0xd3,0x7b,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x80,0xd3,0x7c,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x80,0xd3,0x7e,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x80,0xd3,0x7f,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x80,0xd3,0x80,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x80,0xd3,0xc1,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x80,0xd3,0xf0,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x80,0xd3,0xf7,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x80,0xd3,0xfb,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x80,0xd3,0xfc,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x80,0xd3,0xfd,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x80,0xd3,0xfe,0x00,0x00,0x00]

v_clrexcp_e64
// CHECK: [0x00,0x00,0x82,0xd3,0x00,0x00,0x00,0x00]

v_movreld_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x84,0xd3,0x01,0x01,0x00,0x00]

v_movreld_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x84,0xd3,0x01,0x01,0x00,0x00]

v_movreld_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x84,0xd3,0xff,0x01,0x00,0x00]

v_movreld_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x84,0xd3,0x7c,0x00,0x00,0x00]

v_movreld_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x84,0xd3,0x80,0x00,0x00,0x00]

v_movreld_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x84,0xd3,0xc1,0x00,0x00,0x00]

v_movreld_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x84,0xd3,0xf0,0x00,0x00,0x00]

v_movreld_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x84,0xd3,0xf7,0x00,0x00,0x00]

v_movreld_b32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x84,0xd3,0xfe,0x00,0x00,0x00]

v_movrels_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x86,0xd3,0x01,0x01,0x00,0x00]

v_movrels_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x86,0xd3,0x01,0x01,0x00,0x00]

v_movrels_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x86,0xd3,0xff,0x01,0x00,0x00]

v_movrelsd_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x88,0xd3,0x01,0x01,0x00,0x00]

v_movrelsd_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x88,0xd3,0x01,0x01,0x00,0x00]

v_movrelsd_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x88,0xd3,0xff,0x01,0x00,0x00]

v_log_legacy_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x8a,0xd3,0x01,0x01,0x00,0x00]

v_log_legacy_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x8a,0xd3,0x01,0x01,0x00,0x00]

v_log_legacy_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x8a,0xd3,0xff,0x01,0x00,0x00]

v_log_legacy_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x8a,0xd3,0x01,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x8a,0xd3,0x67,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x8a,0xd3,0x68,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x8a,0xd3,0x69,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x8a,0xd3,0x6a,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x8a,0xd3,0x6b,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x8a,0xd3,0x6c,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x8a,0xd3,0x6d,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x8a,0xd3,0x6e,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x8a,0xd3,0x6f,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x8a,0xd3,0x7b,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x8a,0xd3,0x7c,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x8a,0xd3,0x7e,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x8a,0xd3,0x7f,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x8a,0xd3,0x80,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x8a,0xd3,0xc1,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x8a,0xd3,0xf0,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x8a,0xd3,0xf7,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x8a,0xd3,0xfb,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x8a,0xd3,0xfc,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x8a,0xd3,0xfd,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x8a,0xd3,0xfe,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x8a,0xd3,0x01,0x01,0x00,0x20]

v_log_legacy_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x8a,0xd3,0x01,0x01,0x00,0x00]

v_log_legacy_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x8a,0xd3,0x01,0x01,0x00,0x00]

v_log_legacy_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x8a,0xd3,0x01,0x01,0x00,0x08]

v_log_legacy_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x8a,0xd3,0x01,0x01,0x00,0x10]

v_log_legacy_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x8a,0xd3,0x01,0x01,0x00,0x18]

v_exp_legacy_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x8c,0xd3,0x01,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x8c,0xd3,0x01,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x8c,0xd3,0xff,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x8c,0xd3,0x01,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x8c,0xd3,0x67,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x8c,0xd3,0x68,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x8c,0xd3,0x69,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x8c,0xd3,0x6a,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x8c,0xd3,0x6b,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x8c,0xd3,0x6c,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x8c,0xd3,0x6d,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x8c,0xd3,0x6e,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x8c,0xd3,0x6f,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x8c,0xd3,0x7b,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x8c,0xd3,0x7c,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x8c,0xd3,0x7e,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x8c,0xd3,0x7f,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x8c,0xd3,0x80,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x8c,0xd3,0xc1,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x8c,0xd3,0xf0,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x8c,0xd3,0xf7,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x8c,0xd3,0xfb,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x8c,0xd3,0xfc,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x8c,0xd3,0xfd,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x8c,0xd3,0xfe,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x8c,0xd3,0x01,0x01,0x00,0x20]

v_exp_legacy_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x8c,0xd3,0x01,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x8c,0xd3,0x01,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x8c,0xd3,0x01,0x01,0x00,0x08]

v_exp_legacy_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x8c,0xd3,0x01,0x01,0x00,0x10]

v_exp_legacy_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x8c,0xd3,0x01,0x01,0x00,0x18]

v_cndmask_b32_e64 v5, v1, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0x1a,0x00]

v_cndmask_b32_e64 v255, v1, v2, s[6:7]
// CHECK: [0xff,0x00,0x00,0xd2,0x01,0x05,0x1a,0x00]

v_cndmask_b32_e64 v5, v255, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0xff,0x05,0x1a,0x00]

v_cndmask_b32_e64 v5, 0, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x80,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, -1, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0xc1,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, 0.5, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0xf0,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, -4.0, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0xf7,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, src_lds_direct, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0xfe,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, v1, v255, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0xff,0x1b,0x00]

v_cndmask_b32_e64 v5, v1, 0, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x01,0x19,0x00]

v_cndmask_b32_e64 v5, v1, -1, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x83,0x19,0x00]

v_cndmask_b32_e64 v5, v1, 0.5, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0xe1,0x19,0x00]

v_cndmask_b32_e64 v5, v1, -4.0, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0xef,0x19,0x00]

v_cndmask_b32_e64 v5, v1, v2, s[8:9]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0x22,0x00]

v_cndmask_b32_e64 v5, v1, v2, s[102:103]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0x9a,0x01]

v_cndmask_b32_e64 v5, v1, v2, flat_scratch
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0xa2,0x01]

v_cndmask_b32_e64 v5, v1, v2, vcc
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0xaa,0x01]

v_cndmask_b32_e64 v5, v1, v2, tba
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0xb2,0x01]

v_cndmask_b32_e64 v5, v1, v2, tma
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0xba,0x01]

v_cndmask_b32_e64 v5, v1, v2, ttmp[10:11]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0xea,0x01]

v_cndmask_b32_e64 v5, -v1, |v2|, vcc
// CHECK: encoding: [0x05,0x02,0x00,0xd2,0x01,0x05,0xaa,0x21]

v_cndmask_b32_e64 v5, |v1|, -v2, vcc
// CHECK: encoding: [0x05,0x01,0x00,0xd2,0x01,0x05,0xaa,0x41]

v_cndmask_b32_e64 v5, -|v1|, -|v2|, vcc
// CHECK: encoding: [0x05,0x03,0x00,0xd2,0x01,0x05,0xaa,0x61]

v_add_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x00]

v_add_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x06,0xd2,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x06,0xd2,0xff,0x05,0x02,0x00]

v_add_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x04,0x02,0x00]

v_add_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x67,0x04,0x02,0x00]

v_add_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x68,0x04,0x02,0x00]

v_add_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x69,0x04,0x02,0x00]

v_add_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x6a,0x04,0x02,0x00]

v_add_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x6b,0x04,0x02,0x00]

v_add_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x6c,0x04,0x02,0x00]

v_add_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x6d,0x04,0x02,0x00]

v_add_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x6e,0x04,0x02,0x00]

v_add_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x6f,0x04,0x02,0x00]

v_add_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x7b,0x04,0x02,0x00]

v_add_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x7c,0x04,0x02,0x00]

v_add_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x7e,0x04,0x02,0x00]

v_add_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x7f,0x04,0x02,0x00]

v_add_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x80,0x04,0x02,0x00]

v_add_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x06,0xd2,0xc1,0x04,0x02,0x00]

v_add_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x06,0xd2,0xf0,0x04,0x02,0x00]

v_add_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x06,0xd2,0xf7,0x04,0x02,0x00]

v_add_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x06,0xd2,0xfb,0x04,0x02,0x00]

v_add_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x06,0xd2,0xfc,0x04,0x02,0x00]

v_add_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x06,0xd2,0xfd,0x04,0x02,0x00]

v_add_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x06,0xd2,0xfe,0x04,0x02,0x00]

v_add_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xff,0x03,0x00]

v_add_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x00,0x00]

v_add_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xcf,0x00,0x00]

v_add_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xd1,0x00,0x00]

v_add_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xd3,0x00,0x00]

v_add_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xd5,0x00,0x00]

v_add_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xd7,0x00,0x00]

v_add_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xd9,0x00,0x00]

v_add_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xdb,0x00,0x00]

v_add_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xdd,0x00,0x00]

v_add_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xdf,0x00,0x00]

v_add_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xf7,0x00,0x00]

v_add_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xf9,0x00,0x00]

v_add_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xfd,0x00,0x00]

v_add_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xff,0x00,0x00]

v_add_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x01,0x01,0x00]

v_add_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x83,0x01,0x00]

v_add_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xe1,0x01,0x00]

v_add_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xef,0x01,0x00]

v_add_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xf7,0x01,0x00]

v_add_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xf9,0x01,0x00]

v_add_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xfb,0x01,0x00]

v_add_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x20]

v_add_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x40]

v_add_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x60]

v_add_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x06,0xd2,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x06,0xd2,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x06,0xd2,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x06,0xd2,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x08]

v_add_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x10]

v_add_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x18]

v_sub_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x08,0xd2,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x08,0xd2,0xff,0x05,0x02,0x00]

v_sub_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x04,0x02,0x00]

v_sub_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x67,0x04,0x02,0x00]

v_sub_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x68,0x04,0x02,0x00]

v_sub_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x69,0x04,0x02,0x00]

v_sub_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x6a,0x04,0x02,0x00]

v_sub_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x6b,0x04,0x02,0x00]

v_sub_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x6c,0x04,0x02,0x00]

v_sub_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x6d,0x04,0x02,0x00]

v_sub_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x6e,0x04,0x02,0x00]

v_sub_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x6f,0x04,0x02,0x00]

v_sub_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x7b,0x04,0x02,0x00]

v_sub_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x7c,0x04,0x02,0x00]

v_sub_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x7e,0x04,0x02,0x00]

v_sub_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x7f,0x04,0x02,0x00]

v_sub_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x80,0x04,0x02,0x00]

v_sub_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x08,0xd2,0xc1,0x04,0x02,0x00]

v_sub_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x08,0xd2,0xf0,0x04,0x02,0x00]

v_sub_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x08,0xd2,0xf7,0x04,0x02,0x00]

v_sub_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x08,0xd2,0xfb,0x04,0x02,0x00]

v_sub_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x08,0xd2,0xfc,0x04,0x02,0x00]

v_sub_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x08,0xd2,0xfd,0x04,0x02,0x00]

v_sub_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x08,0xd2,0xfe,0x04,0x02,0x00]

v_sub_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xff,0x03,0x00]

v_sub_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x00,0x00]

v_sub_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xcf,0x00,0x00]

v_sub_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xd1,0x00,0x00]

v_sub_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xd3,0x00,0x00]

v_sub_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xd5,0x00,0x00]

v_sub_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xd7,0x00,0x00]

v_sub_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xd9,0x00,0x00]

v_sub_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xdb,0x00,0x00]

v_sub_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xdd,0x00,0x00]

v_sub_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xdf,0x00,0x00]

v_sub_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xf7,0x00,0x00]

v_sub_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xf9,0x00,0x00]

v_sub_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xfd,0x00,0x00]

v_sub_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xff,0x00,0x00]

v_sub_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x01,0x01,0x00]

v_sub_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x83,0x01,0x00]

v_sub_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xe1,0x01,0x00]

v_sub_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xef,0x01,0x00]

v_sub_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xf7,0x01,0x00]

v_sub_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xf9,0x01,0x00]

v_sub_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xfb,0x01,0x00]

v_sub_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x20]

v_sub_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x40]

v_sub_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x60]

v_sub_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x08,0xd2,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x08,0xd2,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x08,0xd2,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x08,0xd2,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x08]

v_sub_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x10]

v_sub_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x18]

v_subrev_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x0a,0xd2,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0xff,0x05,0x02,0x00]

v_subrev_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x04,0x02,0x00]

v_subrev_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x67,0x04,0x02,0x00]

v_subrev_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x68,0x04,0x02,0x00]

v_subrev_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x69,0x04,0x02,0x00]

v_subrev_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x6a,0x04,0x02,0x00]

v_subrev_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x6b,0x04,0x02,0x00]

v_subrev_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x6c,0x04,0x02,0x00]

v_subrev_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x6d,0x04,0x02,0x00]

v_subrev_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x6e,0x04,0x02,0x00]

v_subrev_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x6f,0x04,0x02,0x00]

v_subrev_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x7b,0x04,0x02,0x00]

v_subrev_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x7c,0x04,0x02,0x00]

v_subrev_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x7e,0x04,0x02,0x00]

v_subrev_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x7f,0x04,0x02,0x00]

v_subrev_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x80,0x04,0x02,0x00]

v_subrev_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0xc1,0x04,0x02,0x00]

v_subrev_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0xf0,0x04,0x02,0x00]

v_subrev_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0xf7,0x04,0x02,0x00]

v_subrev_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0xfb,0x04,0x02,0x00]

v_subrev_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0xfc,0x04,0x02,0x00]

v_subrev_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0xfd,0x04,0x02,0x00]

v_subrev_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xff,0x03,0x00]

v_subrev_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x00,0x00]

v_subrev_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xcf,0x00,0x00]

v_subrev_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xd1,0x00,0x00]

v_subrev_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xd3,0x00,0x00]

v_subrev_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xd5,0x00,0x00]

v_subrev_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xd7,0x00,0x00]

v_subrev_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xd9,0x00,0x00]

v_subrev_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xdb,0x00,0x00]

v_subrev_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xdd,0x00,0x00]

v_subrev_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xdf,0x00,0x00]

v_subrev_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xf7,0x00,0x00]

v_subrev_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xf9,0x00,0x00]

v_subrev_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xfd,0x00,0x00]

v_subrev_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xff,0x00,0x00]

v_subrev_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x01,0x01,0x00]

v_subrev_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x83,0x01,0x00]

v_subrev_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xe1,0x01,0x00]

v_subrev_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xef,0x01,0x00]

v_subrev_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xf7,0x01,0x00]

v_subrev_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xf9,0x01,0x00]

v_subrev_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xfb,0x01,0x00]

v_subrev_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x20]

v_subrev_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x40]

v_subrev_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x60]

v_subrev_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x0a,0xd2,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x0a,0xd2,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x0a,0xd2,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x0a,0xd2,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x08]

v_subrev_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x10]

v_subrev_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x18]

v_mac_legacy_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x0c,0xd2,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0xff,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x67,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x68,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x69,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x6a,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x6b,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x6c,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x6d,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x6e,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x6f,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x7b,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x7c,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x7e,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x7f,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x80,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0xc1,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0xf0,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0xf7,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0xfb,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0xfc,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0xfd,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0xfe,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xff,0x03,0x00]

v_mac_legacy_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xcf,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xd1,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xd3,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xd5,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xd7,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xd9,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xdb,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xdd,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xdf,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xf7,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xf9,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xfd,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xff,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x01,0x01,0x00]

v_mac_legacy_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x83,0x01,0x00]

v_mac_legacy_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xe1,0x01,0x00]

v_mac_legacy_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xef,0x01,0x00]

v_mac_legacy_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xf7,0x01,0x00]

v_mac_legacy_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xf9,0x01,0x00]

v_mac_legacy_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xfb,0x01,0x00]

v_mac_legacy_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x20]

v_mac_legacy_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x40]

v_mac_legacy_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x60]

v_mac_legacy_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x0c,0xd2,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x0c,0xd2,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x0c,0xd2,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x0c,0xd2,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x08]

v_mac_legacy_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x10]

v_mac_legacy_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x18]

v_mul_legacy_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x0e,0xd2,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0xff,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x67,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x68,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x69,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x6a,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x6b,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x6c,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x6d,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x6e,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x6f,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x7b,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x7c,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x7e,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x7f,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x80,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0xc1,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0xf0,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0xf7,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0xfb,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0xfc,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0xfd,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0xfe,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xff,0x03,0x00]

v_mul_legacy_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xcf,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xd1,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xd3,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xd5,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xd7,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xd9,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xdb,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xdd,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xdf,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xf7,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xf9,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xfd,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xff,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x01,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x83,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xe1,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xef,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xf7,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xf9,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xfb,0x01,0x00]

v_mul_legacy_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x20]

v_mul_legacy_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x40]

v_mul_legacy_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x60]

v_mul_legacy_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x0e,0xd2,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x0e,0xd2,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x0e,0xd2,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x0e,0xd2,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x08]

v_mul_legacy_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x10]

v_mul_legacy_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x18]

v_mul_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x10,0xd2,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x10,0xd2,0xff,0x05,0x02,0x00]

v_mul_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x04,0x02,0x00]

v_mul_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x67,0x04,0x02,0x00]

v_mul_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x68,0x04,0x02,0x00]

v_mul_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x69,0x04,0x02,0x00]

v_mul_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x6a,0x04,0x02,0x00]

v_mul_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x6b,0x04,0x02,0x00]

v_mul_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x6c,0x04,0x02,0x00]

v_mul_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x6d,0x04,0x02,0x00]

v_mul_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x6e,0x04,0x02,0x00]

v_mul_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x6f,0x04,0x02,0x00]

v_mul_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x7b,0x04,0x02,0x00]

v_mul_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x7c,0x04,0x02,0x00]

v_mul_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x7e,0x04,0x02,0x00]

v_mul_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x7f,0x04,0x02,0x00]

v_mul_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x80,0x04,0x02,0x00]

v_mul_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x10,0xd2,0xc1,0x04,0x02,0x00]

v_mul_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x10,0xd2,0xf0,0x04,0x02,0x00]

v_mul_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x10,0xd2,0xf7,0x04,0x02,0x00]

v_mul_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x10,0xd2,0xfb,0x04,0x02,0x00]

v_mul_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x10,0xd2,0xfc,0x04,0x02,0x00]

v_mul_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x10,0xd2,0xfd,0x04,0x02,0x00]

v_mul_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x10,0xd2,0xfe,0x04,0x02,0x00]

v_mul_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xff,0x03,0x00]

v_mul_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x00,0x00]

v_mul_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xcf,0x00,0x00]

v_mul_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xd1,0x00,0x00]

v_mul_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xd3,0x00,0x00]

v_mul_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xd5,0x00,0x00]

v_mul_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xd7,0x00,0x00]

v_mul_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xd9,0x00,0x00]

v_mul_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xdb,0x00,0x00]

v_mul_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xdd,0x00,0x00]

v_mul_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xdf,0x00,0x00]

v_mul_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xf7,0x00,0x00]

v_mul_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xf9,0x00,0x00]

v_mul_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xfd,0x00,0x00]

v_mul_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xff,0x00,0x00]

v_mul_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x01,0x01,0x00]

v_mul_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x83,0x01,0x00]

v_mul_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xe1,0x01,0x00]

v_mul_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xef,0x01,0x00]

v_mul_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xf7,0x01,0x00]

v_mul_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xf9,0x01,0x00]

v_mul_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xfb,0x01,0x00]

v_mul_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x20]

v_mul_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x40]

v_mul_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x60]

v_mul_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x10,0xd2,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x10,0xd2,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x10,0xd2,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x10,0xd2,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x08]

v_mul_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x10]

v_mul_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x18]

v_mul_i32_i24_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0x05,0x02,0x00]

v_mul_i32_i24_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x12,0xd2,0x01,0x05,0x02,0x00]

v_mul_i32_i24_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x12,0xd2,0xff,0x05,0x02,0x00]

v_mul_i32_i24_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x67,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x68,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x69,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x6a,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x6b,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x6c,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x6d,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x6e,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x6f,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x7b,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x7c,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x7e,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x7f,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x80,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x12,0xd2,0xc1,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x12,0xd2,0xf0,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x12,0xd2,0xf7,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x12,0xd2,0xfb,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x12,0xd2,0xfc,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x12,0xd2,0xfd,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x12,0xd2,0xfe,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xff,0x03,0x00]

v_mul_i32_i24_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0x05,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xcf,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xd1,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xd3,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xd5,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xd7,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xd9,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xdb,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xdd,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xdf,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xf7,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xf9,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xfd,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xff,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0x01,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0x83,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xe1,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xef,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xf7,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xf9,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xfb,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x14,0xd2,0x01,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x14,0xd2,0xff,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x67,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x68,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x69,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x6a,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x6b,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x6c,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x6d,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x6e,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x6f,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x7b,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x7c,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x7e,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x7f,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x80,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x14,0xd2,0xc1,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x14,0xd2,0xf0,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x14,0xd2,0xf7,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x14,0xd2,0xfb,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x14,0xd2,0xfc,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x14,0xd2,0xfd,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x14,0xd2,0xfe,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xff,0x03,0x00]

v_mul_hi_i32_i24_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0x05,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xcf,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xd1,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xd3,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xd5,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xd7,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xd9,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xdb,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xdd,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xdf,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xf7,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xf9,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xfd,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xff,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0x01,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0x83,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xe1,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xef,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xf7,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xf9,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xfb,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0x05,0x02,0x00]

v_mul_u32_u24_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x16,0xd2,0x01,0x05,0x02,0x00]

v_mul_u32_u24_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x16,0xd2,0xff,0x05,0x02,0x00]

v_mul_u32_u24_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x67,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x68,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x69,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x6a,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x6b,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x6c,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x6d,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x6e,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x6f,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x7b,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x7c,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x7e,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x7f,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x80,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x16,0xd2,0xc1,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x16,0xd2,0xf0,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x16,0xd2,0xf7,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x16,0xd2,0xfb,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x16,0xd2,0xfc,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x16,0xd2,0xfd,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x16,0xd2,0xfe,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xff,0x03,0x00]

v_mul_u32_u24_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0x05,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xcf,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xd1,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xd3,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xd5,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xd7,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xd9,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xdb,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xdd,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xdf,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xf7,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xf9,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xfd,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xff,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0x01,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0x83,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xe1,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xef,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xf7,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xf9,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xfb,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x18,0xd2,0x01,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x18,0xd2,0xff,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x67,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x68,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x69,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x6a,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x6b,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x6c,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x6d,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x6e,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x6f,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x7b,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x7c,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x7e,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x7f,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x80,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x18,0xd2,0xc1,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x18,0xd2,0xf0,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x18,0xd2,0xf7,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x18,0xd2,0xfb,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x18,0xd2,0xfc,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x18,0xd2,0xfd,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x18,0xd2,0xfe,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xff,0x03,0x00]

v_mul_hi_u32_u24_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0x05,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xcf,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xd1,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xd3,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xd5,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xd7,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xd9,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xdb,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xdd,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xdf,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xf7,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xf9,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xfd,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xff,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0x01,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0x83,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xe1,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xef,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xf7,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xf9,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xfb,0x01,0x00]

v_min_legacy_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x00]

v_min_legacy_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x1a,0xd2,0x01,0x05,0x02,0x00]

v_min_legacy_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0xff,0x05,0x02,0x00]

v_min_legacy_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x67,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x68,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x69,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x6a,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x6b,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x6c,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x6d,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x6e,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x6f,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x7b,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x7c,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x7e,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x7f,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x80,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0xc1,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0xf0,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0xf7,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0xfb,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0xfc,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0xfd,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0xfe,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xff,0x03,0x00]

v_min_legacy_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xcf,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xd1,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xd3,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xd5,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xd7,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xd9,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xdb,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xdd,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xdf,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xf7,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xf9,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xfd,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xff,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x01,0x01,0x00]

v_min_legacy_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x83,0x01,0x00]

v_min_legacy_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xe1,0x01,0x00]

v_min_legacy_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xef,0x01,0x00]

v_min_legacy_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xf7,0x01,0x00]

v_min_legacy_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xf9,0x01,0x00]

v_min_legacy_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xfb,0x01,0x00]

v_min_legacy_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x20]

v_min_legacy_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x40]

v_min_legacy_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x60]

v_min_legacy_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x1a,0xd2,0x01,0x05,0x02,0x00]

v_min_legacy_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x1a,0xd2,0x01,0x05,0x02,0x00]

v_min_legacy_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x1a,0xd2,0x01,0x05,0x02,0x00]

v_min_legacy_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x1a,0xd2,0x01,0x05,0x02,0x00]

v_min_legacy_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x08]

v_min_legacy_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x10]

v_min_legacy_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x18]

v_max_legacy_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x00]

v_max_legacy_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x1c,0xd2,0x01,0x05,0x02,0x00]

v_max_legacy_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0xff,0x05,0x02,0x00]

v_max_legacy_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x67,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x68,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x69,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x6a,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x6b,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x6c,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x6d,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x6e,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x6f,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x7b,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x7c,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x7e,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x7f,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x80,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0xc1,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0xf0,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0xf7,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0xfb,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0xfc,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0xfd,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0xfe,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xff,0x03,0x00]

v_max_legacy_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xcf,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xd1,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xd3,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xd5,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xd7,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xd9,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xdb,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xdd,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xdf,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xf7,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xf9,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xfd,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xff,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x01,0x01,0x00]

v_max_legacy_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x83,0x01,0x00]

v_max_legacy_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xe1,0x01,0x00]

v_max_legacy_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xef,0x01,0x00]

v_max_legacy_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xf7,0x01,0x00]

v_max_legacy_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xf9,0x01,0x00]

v_max_legacy_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xfb,0x01,0x00]

v_max_legacy_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x20]

v_max_legacy_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x40]

v_max_legacy_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x60]

v_max_legacy_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x1c,0xd2,0x01,0x05,0x02,0x00]

v_max_legacy_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x1c,0xd2,0x01,0x05,0x02,0x00]

v_max_legacy_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x1c,0xd2,0x01,0x05,0x02,0x00]

v_max_legacy_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x1c,0xd2,0x01,0x05,0x02,0x00]

v_max_legacy_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x08]

v_max_legacy_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x10]

v_max_legacy_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x18]

v_min_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x00]

v_min_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x1e,0xd2,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0xff,0x05,0x02,0x00]

v_min_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x04,0x02,0x00]

v_min_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x67,0x04,0x02,0x00]

v_min_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x68,0x04,0x02,0x00]

v_min_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x69,0x04,0x02,0x00]

v_min_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x6a,0x04,0x02,0x00]

v_min_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x6b,0x04,0x02,0x00]

v_min_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x6c,0x04,0x02,0x00]

v_min_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x6d,0x04,0x02,0x00]

v_min_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x6e,0x04,0x02,0x00]

v_min_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x6f,0x04,0x02,0x00]

v_min_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x7b,0x04,0x02,0x00]

v_min_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x7c,0x04,0x02,0x00]

v_min_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x7e,0x04,0x02,0x00]

v_min_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x7f,0x04,0x02,0x00]

v_min_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x80,0x04,0x02,0x00]

v_min_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0xc1,0x04,0x02,0x00]

v_min_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0xf0,0x04,0x02,0x00]

v_min_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0xf7,0x04,0x02,0x00]

v_min_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0xfb,0x04,0x02,0x00]

v_min_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0xfc,0x04,0x02,0x00]

v_min_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0xfd,0x04,0x02,0x00]

v_min_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0xfe,0x04,0x02,0x00]

v_min_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xff,0x03,0x00]

v_min_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x00,0x00]

v_min_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xcf,0x00,0x00]

v_min_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xd1,0x00,0x00]

v_min_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xd3,0x00,0x00]

v_min_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xd5,0x00,0x00]

v_min_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xd7,0x00,0x00]

v_min_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xd9,0x00,0x00]

v_min_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xdb,0x00,0x00]

v_min_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xdd,0x00,0x00]

v_min_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xdf,0x00,0x00]

v_min_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xf7,0x00,0x00]

v_min_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xf9,0x00,0x00]

v_min_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xfd,0x00,0x00]

v_min_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xff,0x00,0x00]

v_min_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x01,0x01,0x00]

v_min_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x83,0x01,0x00]

v_min_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xe1,0x01,0x00]

v_min_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xef,0x01,0x00]

v_min_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xf7,0x01,0x00]

v_min_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xf9,0x01,0x00]

v_min_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xfb,0x01,0x00]

v_min_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x20]

v_min_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x40]

v_min_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x60]

v_min_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x1e,0xd2,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x1e,0xd2,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x1e,0xd2,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x1e,0xd2,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x08]

v_min_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x10]

v_min_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x18]

v_max_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x00]

v_max_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x20,0xd2,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x20,0xd2,0xff,0x05,0x02,0x00]

v_max_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x04,0x02,0x00]

v_max_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x67,0x04,0x02,0x00]

v_max_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x68,0x04,0x02,0x00]

v_max_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x69,0x04,0x02,0x00]

v_max_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x6a,0x04,0x02,0x00]

v_max_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x6b,0x04,0x02,0x00]

v_max_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x6c,0x04,0x02,0x00]

v_max_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x6d,0x04,0x02,0x00]

v_max_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x6e,0x04,0x02,0x00]

v_max_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x6f,0x04,0x02,0x00]

v_max_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x7b,0x04,0x02,0x00]

v_max_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x7c,0x04,0x02,0x00]

v_max_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x7e,0x04,0x02,0x00]

v_max_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x7f,0x04,0x02,0x00]

v_max_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x80,0x04,0x02,0x00]

v_max_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x20,0xd2,0xc1,0x04,0x02,0x00]

v_max_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x20,0xd2,0xf0,0x04,0x02,0x00]

v_max_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x20,0xd2,0xf7,0x04,0x02,0x00]

v_max_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x20,0xd2,0xfb,0x04,0x02,0x00]

v_max_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x20,0xd2,0xfc,0x04,0x02,0x00]

v_max_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x20,0xd2,0xfd,0x04,0x02,0x00]

v_max_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x20,0xd2,0xfe,0x04,0x02,0x00]

v_max_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xff,0x03,0x00]

v_max_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x00,0x00]

v_max_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xcf,0x00,0x00]

v_max_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xd1,0x00,0x00]

v_max_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xd3,0x00,0x00]

v_max_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xd5,0x00,0x00]

v_max_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xd7,0x00,0x00]

v_max_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xd9,0x00,0x00]

v_max_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xdb,0x00,0x00]

v_max_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xdd,0x00,0x00]

v_max_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xdf,0x00,0x00]

v_max_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xf7,0x00,0x00]

v_max_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xf9,0x00,0x00]

v_max_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xfd,0x00,0x00]

v_max_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xff,0x00,0x00]

v_max_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x01,0x01,0x00]

v_max_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x83,0x01,0x00]

v_max_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xe1,0x01,0x00]

v_max_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xef,0x01,0x00]

v_max_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xf7,0x01,0x00]

v_max_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xf9,0x01,0x00]

v_max_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xfb,0x01,0x00]

v_max_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x20]

v_max_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x40]

v_max_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x60]

v_max_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x20,0xd2,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x20,0xd2,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x20,0xd2,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x20,0xd2,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x08]

v_max_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x10]

v_max_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x18]

v_min_i32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0x05,0x02,0x00]

v_min_i32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x22,0xd2,0x01,0x05,0x02,0x00]

v_min_i32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x22,0xd2,0xff,0x05,0x02,0x00]

v_min_i32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0x04,0x02,0x00]

v_min_i32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x67,0x04,0x02,0x00]

v_min_i32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x68,0x04,0x02,0x00]

v_min_i32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x69,0x04,0x02,0x00]

v_min_i32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x6a,0x04,0x02,0x00]

v_min_i32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x6b,0x04,0x02,0x00]

v_min_i32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x6c,0x04,0x02,0x00]

v_min_i32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x6d,0x04,0x02,0x00]

v_min_i32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x6e,0x04,0x02,0x00]

v_min_i32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x6f,0x04,0x02,0x00]

v_min_i32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x7b,0x04,0x02,0x00]

v_min_i32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x7c,0x04,0x02,0x00]

v_min_i32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x7e,0x04,0x02,0x00]

v_min_i32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x7f,0x04,0x02,0x00]

v_min_i32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x80,0x04,0x02,0x00]

v_min_i32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x22,0xd2,0xc1,0x04,0x02,0x00]

v_min_i32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x22,0xd2,0xf0,0x04,0x02,0x00]

v_min_i32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x22,0xd2,0xf7,0x04,0x02,0x00]

v_min_i32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x22,0xd2,0xfb,0x04,0x02,0x00]

v_min_i32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x22,0xd2,0xfc,0x04,0x02,0x00]

v_min_i32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x22,0xd2,0xfd,0x04,0x02,0x00]

v_min_i32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x22,0xd2,0xfe,0x04,0x02,0x00]

v_min_i32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xff,0x03,0x00]

v_min_i32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0x05,0x00,0x00]

v_min_i32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xcf,0x00,0x00]

v_min_i32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xd1,0x00,0x00]

v_min_i32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xd3,0x00,0x00]

v_min_i32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xd5,0x00,0x00]

v_min_i32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xd7,0x00,0x00]

v_min_i32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xd9,0x00,0x00]

v_min_i32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xdb,0x00,0x00]

v_min_i32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xdd,0x00,0x00]

v_min_i32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xdf,0x00,0x00]

v_min_i32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xf7,0x00,0x00]

v_min_i32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xf9,0x00,0x00]

v_min_i32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xfd,0x00,0x00]

v_min_i32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xff,0x00,0x00]

v_min_i32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0x01,0x01,0x00]

v_min_i32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0x83,0x01,0x00]

v_min_i32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xe1,0x01,0x00]

v_min_i32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xef,0x01,0x00]

v_min_i32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xf7,0x01,0x00]

v_min_i32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xf9,0x01,0x00]

v_min_i32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xfb,0x01,0x00]

v_max_i32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0x05,0x02,0x00]

v_max_i32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x24,0xd2,0x01,0x05,0x02,0x00]

v_max_i32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x24,0xd2,0xff,0x05,0x02,0x00]

v_max_i32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0x04,0x02,0x00]

v_max_i32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x67,0x04,0x02,0x00]

v_max_i32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x68,0x04,0x02,0x00]

v_max_i32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x69,0x04,0x02,0x00]

v_max_i32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x6a,0x04,0x02,0x00]

v_max_i32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x6b,0x04,0x02,0x00]

v_max_i32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x6c,0x04,0x02,0x00]

v_max_i32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x6d,0x04,0x02,0x00]

v_max_i32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x6e,0x04,0x02,0x00]

v_max_i32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x6f,0x04,0x02,0x00]

v_max_i32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x7b,0x04,0x02,0x00]

v_max_i32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x7c,0x04,0x02,0x00]

v_max_i32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x7e,0x04,0x02,0x00]

v_max_i32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x7f,0x04,0x02,0x00]

v_max_i32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x80,0x04,0x02,0x00]

v_max_i32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x24,0xd2,0xc1,0x04,0x02,0x00]

v_max_i32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x24,0xd2,0xf0,0x04,0x02,0x00]

v_max_i32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x24,0xd2,0xf7,0x04,0x02,0x00]

v_max_i32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x24,0xd2,0xfb,0x04,0x02,0x00]

v_max_i32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x24,0xd2,0xfc,0x04,0x02,0x00]

v_max_i32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x24,0xd2,0xfd,0x04,0x02,0x00]

v_max_i32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x24,0xd2,0xfe,0x04,0x02,0x00]

v_max_i32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xff,0x03,0x00]

v_max_i32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0x05,0x00,0x00]

v_max_i32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xcf,0x00,0x00]

v_max_i32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xd1,0x00,0x00]

v_max_i32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xd3,0x00,0x00]

v_max_i32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xd5,0x00,0x00]

v_max_i32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xd7,0x00,0x00]

v_max_i32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xd9,0x00,0x00]

v_max_i32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xdb,0x00,0x00]

v_max_i32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xdd,0x00,0x00]

v_max_i32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xdf,0x00,0x00]

v_max_i32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xf7,0x00,0x00]

v_max_i32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xf9,0x00,0x00]

v_max_i32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xfd,0x00,0x00]

v_max_i32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xff,0x00,0x00]

v_max_i32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0x01,0x01,0x00]

v_max_i32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0x83,0x01,0x00]

v_max_i32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xe1,0x01,0x00]

v_max_i32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xef,0x01,0x00]

v_max_i32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xf7,0x01,0x00]

v_max_i32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xf9,0x01,0x00]

v_max_i32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xfb,0x01,0x00]

v_min_u32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0x05,0x02,0x00]

v_min_u32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x26,0xd2,0x01,0x05,0x02,0x00]

v_min_u32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x26,0xd2,0xff,0x05,0x02,0x00]

v_min_u32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0x04,0x02,0x00]

v_min_u32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x67,0x04,0x02,0x00]

v_min_u32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x68,0x04,0x02,0x00]

v_min_u32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x69,0x04,0x02,0x00]

v_min_u32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x6a,0x04,0x02,0x00]

v_min_u32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x6b,0x04,0x02,0x00]

v_min_u32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x6c,0x04,0x02,0x00]

v_min_u32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x6d,0x04,0x02,0x00]

v_min_u32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x6e,0x04,0x02,0x00]

v_min_u32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x6f,0x04,0x02,0x00]

v_min_u32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x7b,0x04,0x02,0x00]

v_min_u32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x7c,0x04,0x02,0x00]

v_min_u32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x7e,0x04,0x02,0x00]

v_min_u32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x7f,0x04,0x02,0x00]

v_min_u32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x80,0x04,0x02,0x00]

v_min_u32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x26,0xd2,0xc1,0x04,0x02,0x00]

v_min_u32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x26,0xd2,0xf0,0x04,0x02,0x00]

v_min_u32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x26,0xd2,0xf7,0x04,0x02,0x00]

v_min_u32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x26,0xd2,0xfb,0x04,0x02,0x00]

v_min_u32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x26,0xd2,0xfc,0x04,0x02,0x00]

v_min_u32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x26,0xd2,0xfd,0x04,0x02,0x00]

v_min_u32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x26,0xd2,0xfe,0x04,0x02,0x00]

v_min_u32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xff,0x03,0x00]

v_min_u32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0x05,0x00,0x00]

v_min_u32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xcf,0x00,0x00]

v_min_u32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xd1,0x00,0x00]

v_min_u32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xd3,0x00,0x00]

v_min_u32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xd5,0x00,0x00]

v_min_u32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xd7,0x00,0x00]

v_min_u32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xd9,0x00,0x00]

v_min_u32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xdb,0x00,0x00]

v_min_u32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xdd,0x00,0x00]

v_min_u32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xdf,0x00,0x00]

v_min_u32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xf7,0x00,0x00]

v_min_u32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xf9,0x00,0x00]

v_min_u32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xfd,0x00,0x00]

v_min_u32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xff,0x00,0x00]

v_min_u32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0x01,0x01,0x00]

v_min_u32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0x83,0x01,0x00]

v_min_u32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xe1,0x01,0x00]

v_min_u32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xef,0x01,0x00]

v_min_u32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xf7,0x01,0x00]

v_min_u32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xf9,0x01,0x00]

v_min_u32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xfb,0x01,0x00]

v_max_u32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0x05,0x02,0x00]

v_max_u32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x28,0xd2,0x01,0x05,0x02,0x00]

v_max_u32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x28,0xd2,0xff,0x05,0x02,0x00]

v_max_u32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0x04,0x02,0x00]

v_max_u32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x67,0x04,0x02,0x00]

v_max_u32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x68,0x04,0x02,0x00]

v_max_u32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x69,0x04,0x02,0x00]

v_max_u32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x6a,0x04,0x02,0x00]

v_max_u32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x6b,0x04,0x02,0x00]

v_max_u32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x6c,0x04,0x02,0x00]

v_max_u32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x6d,0x04,0x02,0x00]

v_max_u32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x6e,0x04,0x02,0x00]

v_max_u32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x6f,0x04,0x02,0x00]

v_max_u32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x7b,0x04,0x02,0x00]

v_max_u32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x7c,0x04,0x02,0x00]

v_max_u32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x7e,0x04,0x02,0x00]

v_max_u32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x7f,0x04,0x02,0x00]

v_max_u32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x80,0x04,0x02,0x00]

v_max_u32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x28,0xd2,0xc1,0x04,0x02,0x00]

v_max_u32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x28,0xd2,0xf0,0x04,0x02,0x00]

v_max_u32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x28,0xd2,0xf7,0x04,0x02,0x00]

v_max_u32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x28,0xd2,0xfb,0x04,0x02,0x00]

v_max_u32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x28,0xd2,0xfc,0x04,0x02,0x00]

v_max_u32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x28,0xd2,0xfd,0x04,0x02,0x00]

v_max_u32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x28,0xd2,0xfe,0x04,0x02,0x00]

v_max_u32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xff,0x03,0x00]

v_max_u32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0x05,0x00,0x00]

v_max_u32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xcf,0x00,0x00]

v_max_u32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xd1,0x00,0x00]

v_max_u32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xd3,0x00,0x00]

v_max_u32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xd5,0x00,0x00]

v_max_u32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xd7,0x00,0x00]

v_max_u32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xd9,0x00,0x00]

v_max_u32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xdb,0x00,0x00]

v_max_u32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xdd,0x00,0x00]

v_max_u32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xdf,0x00,0x00]

v_max_u32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xf7,0x00,0x00]

v_max_u32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xf9,0x00,0x00]

v_max_u32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xfd,0x00,0x00]

v_max_u32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xff,0x00,0x00]

v_max_u32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0x01,0x01,0x00]

v_max_u32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0x83,0x01,0x00]

v_max_u32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xe1,0x01,0x00]

v_max_u32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xef,0x01,0x00]

v_max_u32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xf7,0x01,0x00]

v_max_u32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xf9,0x01,0x00]

v_max_u32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xfb,0x01,0x00]

v_lshr_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0x05,0x02,0x00]

v_lshr_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x2a,0xd2,0x01,0x05,0x02,0x00]

v_lshr_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0xff,0x05,0x02,0x00]

v_lshr_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0x04,0x02,0x00]

v_lshr_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x67,0x04,0x02,0x00]

v_lshr_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x68,0x04,0x02,0x00]

v_lshr_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x69,0x04,0x02,0x00]

v_lshr_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x6a,0x04,0x02,0x00]

v_lshr_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x6b,0x04,0x02,0x00]

v_lshr_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x6c,0x04,0x02,0x00]

v_lshr_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x6d,0x04,0x02,0x00]

v_lshr_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x6e,0x04,0x02,0x00]

v_lshr_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x6f,0x04,0x02,0x00]

v_lshr_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x7b,0x04,0x02,0x00]

v_lshr_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x7c,0x04,0x02,0x00]

v_lshr_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x7e,0x04,0x02,0x00]

v_lshr_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x7f,0x04,0x02,0x00]

v_lshr_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x80,0x04,0x02,0x00]

v_lshr_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0xc1,0x04,0x02,0x00]

v_lshr_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0xf0,0x04,0x02,0x00]

v_lshr_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0xf7,0x04,0x02,0x00]

v_lshr_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0xfb,0x04,0x02,0x00]

v_lshr_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0xfc,0x04,0x02,0x00]

v_lshr_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0xfd,0x04,0x02,0x00]

v_lshr_b32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0xfe,0x04,0x02,0x00]

v_lshr_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xff,0x03,0x00]

v_lshr_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0x05,0x00,0x00]

v_lshr_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xcf,0x00,0x00]

v_lshr_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xd1,0x00,0x00]

v_lshr_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xd3,0x00,0x00]

v_lshr_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xd5,0x00,0x00]

v_lshr_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xd7,0x00,0x00]

v_lshr_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xd9,0x00,0x00]

v_lshr_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xdb,0x00,0x00]

v_lshr_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xdd,0x00,0x00]

v_lshr_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xdf,0x00,0x00]

v_lshr_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xf7,0x00,0x00]

v_lshr_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xf9,0x00,0x00]

v_lshr_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xfd,0x00,0x00]

v_lshr_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xff,0x00,0x00]

v_lshr_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0x01,0x01,0x00]

v_lshr_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0x83,0x01,0x00]

v_lshr_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xe1,0x01,0x00]

v_lshr_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xef,0x01,0x00]

v_lshr_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xf7,0x01,0x00]

v_lshr_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xf9,0x01,0x00]

v_lshr_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xfb,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0x05,0x02,0x00]

v_lshrrev_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x2c,0xd2,0x01,0x05,0x02,0x00]

v_lshrrev_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0xff,0x05,0x02,0x00]

v_lshrrev_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x67,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x68,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x69,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x6a,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x6b,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x6c,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x6d,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x6e,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x6f,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x7b,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x7c,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x7e,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x7f,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x80,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0xc1,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0xf0,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0xf7,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0xfb,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0xfc,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0xfd,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xff,0x03,0x00]

v_lshrrev_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0x05,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xcf,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xd1,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xd3,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xd5,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xd7,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xd9,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xdb,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xdd,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xdf,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xf7,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xf9,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xfd,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xff,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0x01,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0x83,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xe1,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xef,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xf7,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xf9,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xfb,0x01,0x00]

v_ashr_i32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0x05,0x02,0x00]

v_ashr_i32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x2e,0xd2,0x01,0x05,0x02,0x00]

v_ashr_i32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0xff,0x05,0x02,0x00]

v_ashr_i32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0x04,0x02,0x00]

v_ashr_i32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x67,0x04,0x02,0x00]

v_ashr_i32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x68,0x04,0x02,0x00]

v_ashr_i32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x69,0x04,0x02,0x00]

v_ashr_i32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x6a,0x04,0x02,0x00]

v_ashr_i32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x6b,0x04,0x02,0x00]

v_ashr_i32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x6c,0x04,0x02,0x00]

v_ashr_i32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x6d,0x04,0x02,0x00]

v_ashr_i32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x6e,0x04,0x02,0x00]

v_ashr_i32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x6f,0x04,0x02,0x00]

v_ashr_i32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x7b,0x04,0x02,0x00]

v_ashr_i32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x7c,0x04,0x02,0x00]

v_ashr_i32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x7e,0x04,0x02,0x00]

v_ashr_i32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x7f,0x04,0x02,0x00]

v_ashr_i32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x80,0x04,0x02,0x00]

v_ashr_i32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0xc1,0x04,0x02,0x00]

v_ashr_i32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0xf0,0x04,0x02,0x00]

v_ashr_i32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0xf7,0x04,0x02,0x00]

v_ashr_i32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0xfb,0x04,0x02,0x00]

v_ashr_i32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0xfc,0x04,0x02,0x00]

v_ashr_i32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0xfd,0x04,0x02,0x00]

v_ashr_i32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0xfe,0x04,0x02,0x00]

v_ashr_i32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xff,0x03,0x00]

v_ashr_i32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0x05,0x00,0x00]

v_ashr_i32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xcf,0x00,0x00]

v_ashr_i32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xd1,0x00,0x00]

v_ashr_i32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xd3,0x00,0x00]

v_ashr_i32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xd5,0x00,0x00]

v_ashr_i32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xd7,0x00,0x00]

v_ashr_i32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xd9,0x00,0x00]

v_ashr_i32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xdb,0x00,0x00]

v_ashr_i32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xdd,0x00,0x00]

v_ashr_i32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xdf,0x00,0x00]

v_ashr_i32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xf7,0x00,0x00]

v_ashr_i32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xf9,0x00,0x00]

v_ashr_i32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xfd,0x00,0x00]

v_ashr_i32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xff,0x00,0x00]

v_ashr_i32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0x01,0x01,0x00]

v_ashr_i32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0x83,0x01,0x00]

v_ashr_i32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xe1,0x01,0x00]

v_ashr_i32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xef,0x01,0x00]

v_ashr_i32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xf7,0x01,0x00]

v_ashr_i32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xf9,0x01,0x00]

v_ashr_i32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xfb,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0x05,0x02,0x00]

v_ashrrev_i32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x30,0xd2,0x01,0x05,0x02,0x00]

v_ashrrev_i32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x30,0xd2,0xff,0x05,0x02,0x00]

v_ashrrev_i32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x67,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x68,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x69,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x6a,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x6b,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x6c,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x6d,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x6e,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x6f,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x7b,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x7c,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x7e,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x7f,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x80,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x30,0xd2,0xc1,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x30,0xd2,0xf0,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x30,0xd2,0xf7,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x30,0xd2,0xfb,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x30,0xd2,0xfc,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x30,0xd2,0xfd,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xff,0x03,0x00]

v_ashrrev_i32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0x05,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xcf,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xd1,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xd3,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xd5,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xd7,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xd9,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xdb,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xdd,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xdf,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xf7,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xf9,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xfd,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xff,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0x01,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0x83,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xe1,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xef,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xf7,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xf9,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xfb,0x01,0x00]

v_lshl_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0x05,0x02,0x00]

v_lshl_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x32,0xd2,0x01,0x05,0x02,0x00]

v_lshl_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x32,0xd2,0xff,0x05,0x02,0x00]

v_lshl_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0x04,0x02,0x00]

v_lshl_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x67,0x04,0x02,0x00]

v_lshl_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x68,0x04,0x02,0x00]

v_lshl_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x69,0x04,0x02,0x00]

v_lshl_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x6a,0x04,0x02,0x00]

v_lshl_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x6b,0x04,0x02,0x00]

v_lshl_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x6c,0x04,0x02,0x00]

v_lshl_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x6d,0x04,0x02,0x00]

v_lshl_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x6e,0x04,0x02,0x00]

v_lshl_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x6f,0x04,0x02,0x00]

v_lshl_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x7b,0x04,0x02,0x00]

v_lshl_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x7c,0x04,0x02,0x00]

v_lshl_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x7e,0x04,0x02,0x00]

v_lshl_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x7f,0x04,0x02,0x00]

v_lshl_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x80,0x04,0x02,0x00]

v_lshl_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x32,0xd2,0xc1,0x04,0x02,0x00]

v_lshl_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x32,0xd2,0xf0,0x04,0x02,0x00]

v_lshl_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x32,0xd2,0xf7,0x04,0x02,0x00]

v_lshl_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x32,0xd2,0xfb,0x04,0x02,0x00]

v_lshl_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x32,0xd2,0xfc,0x04,0x02,0x00]

v_lshl_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x32,0xd2,0xfd,0x04,0x02,0x00]

v_lshl_b32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x32,0xd2,0xfe,0x04,0x02,0x00]

v_lshl_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xff,0x03,0x00]

v_lshl_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0x05,0x00,0x00]

v_lshl_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xcf,0x00,0x00]

v_lshl_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xd1,0x00,0x00]

v_lshl_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xd3,0x00,0x00]

v_lshl_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xd5,0x00,0x00]

v_lshl_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xd7,0x00,0x00]

v_lshl_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xd9,0x00,0x00]

v_lshl_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xdb,0x00,0x00]

v_lshl_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xdd,0x00,0x00]

v_lshl_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xdf,0x00,0x00]

v_lshl_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xf7,0x00,0x00]

v_lshl_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xf9,0x00,0x00]

v_lshl_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xfd,0x00,0x00]

v_lshl_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xff,0x00,0x00]

v_lshl_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0x01,0x01,0x00]

v_lshl_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0x83,0x01,0x00]

v_lshl_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xe1,0x01,0x00]

v_lshl_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xef,0x01,0x00]

v_lshl_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xf7,0x01,0x00]

v_lshl_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xf9,0x01,0x00]

v_lshl_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xfb,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0x05,0x02,0x00]

v_lshlrev_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x34,0xd2,0x01,0x05,0x02,0x00]

v_lshlrev_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x34,0xd2,0xff,0x05,0x02,0x00]

v_lshlrev_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x67,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x68,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x69,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x6a,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x6b,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x6c,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x6d,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x6e,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x6f,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x7b,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x7c,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x7e,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x7f,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x80,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x34,0xd2,0xc1,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x34,0xd2,0xf0,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x34,0xd2,0xf7,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x34,0xd2,0xfb,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x34,0xd2,0xfc,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x34,0xd2,0xfd,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xff,0x03,0x00]

v_lshlrev_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0x05,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xcf,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xd1,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xd3,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xd5,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xd7,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xd9,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xdb,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xdd,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xdf,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xf7,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xf9,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xfd,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xff,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0x01,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0x83,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xe1,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xef,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xf7,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xf9,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xfb,0x01,0x00]

v_and_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0x05,0x02,0x00]

v_and_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x36,0xd2,0x01,0x05,0x02,0x00]

v_and_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x36,0xd2,0xff,0x05,0x02,0x00]

v_and_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0x04,0x02,0x00]

v_and_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x67,0x04,0x02,0x00]

v_and_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x68,0x04,0x02,0x00]

v_and_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x69,0x04,0x02,0x00]

v_and_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x6a,0x04,0x02,0x00]

v_and_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x6b,0x04,0x02,0x00]

v_and_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x6c,0x04,0x02,0x00]

v_and_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x6d,0x04,0x02,0x00]

v_and_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x6e,0x04,0x02,0x00]

v_and_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x6f,0x04,0x02,0x00]

v_and_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x7b,0x04,0x02,0x00]

v_and_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x7c,0x04,0x02,0x00]

v_and_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x7e,0x04,0x02,0x00]

v_and_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x7f,0x04,0x02,0x00]

v_and_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x80,0x04,0x02,0x00]

v_and_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x36,0xd2,0xc1,0x04,0x02,0x00]

v_and_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x36,0xd2,0xf0,0x04,0x02,0x00]

v_and_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x36,0xd2,0xf7,0x04,0x02,0x00]

v_and_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x36,0xd2,0xfb,0x04,0x02,0x00]

v_and_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x36,0xd2,0xfc,0x04,0x02,0x00]

v_and_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x36,0xd2,0xfd,0x04,0x02,0x00]

v_and_b32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x36,0xd2,0xfe,0x04,0x02,0x00]

v_and_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xff,0x03,0x00]

v_and_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0x05,0x00,0x00]

v_and_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xcf,0x00,0x00]

v_and_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xd1,0x00,0x00]

v_and_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xd3,0x00,0x00]

v_and_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xd5,0x00,0x00]

v_and_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xd7,0x00,0x00]

v_and_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xd9,0x00,0x00]

v_and_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xdb,0x00,0x00]

v_and_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xdd,0x00,0x00]

v_and_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xdf,0x00,0x00]

v_and_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xf7,0x00,0x00]

v_and_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xf9,0x00,0x00]

v_and_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xfd,0x00,0x00]

v_and_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xff,0x00,0x00]

v_and_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0x01,0x01,0x00]

v_and_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0x83,0x01,0x00]

v_and_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xe1,0x01,0x00]

v_and_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xef,0x01,0x00]

v_and_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xf7,0x01,0x00]

v_and_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xf9,0x01,0x00]

v_and_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xfb,0x01,0x00]

v_or_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0x05,0x02,0x00]

v_or_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x38,0xd2,0x01,0x05,0x02,0x00]

v_or_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x38,0xd2,0xff,0x05,0x02,0x00]

v_or_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0x04,0x02,0x00]

v_or_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x67,0x04,0x02,0x00]

v_or_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x68,0x04,0x02,0x00]

v_or_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x69,0x04,0x02,0x00]

v_or_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x6a,0x04,0x02,0x00]

v_or_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x6b,0x04,0x02,0x00]

v_or_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x6c,0x04,0x02,0x00]

v_or_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x6d,0x04,0x02,0x00]

v_or_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x6e,0x04,0x02,0x00]

v_or_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x6f,0x04,0x02,0x00]

v_or_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x7b,0x04,0x02,0x00]

v_or_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x7c,0x04,0x02,0x00]

v_or_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x7e,0x04,0x02,0x00]

v_or_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x7f,0x04,0x02,0x00]

v_or_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x80,0x04,0x02,0x00]

v_or_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x38,0xd2,0xc1,0x04,0x02,0x00]

v_or_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x38,0xd2,0xf0,0x04,0x02,0x00]

v_or_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x38,0xd2,0xf7,0x04,0x02,0x00]

v_or_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x38,0xd2,0xfb,0x04,0x02,0x00]

v_or_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x38,0xd2,0xfc,0x04,0x02,0x00]

v_or_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x38,0xd2,0xfd,0x04,0x02,0x00]

v_or_b32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x38,0xd2,0xfe,0x04,0x02,0x00]

v_or_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xff,0x03,0x00]

v_or_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0x05,0x00,0x00]

v_or_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xcf,0x00,0x00]

v_or_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xd1,0x00,0x00]

v_or_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xd3,0x00,0x00]

v_or_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xd5,0x00,0x00]

v_or_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xd7,0x00,0x00]

v_or_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xd9,0x00,0x00]

v_or_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xdb,0x00,0x00]

v_or_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xdd,0x00,0x00]

v_or_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xdf,0x00,0x00]

v_or_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xf7,0x00,0x00]

v_or_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xf9,0x00,0x00]

v_or_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xfd,0x00,0x00]

v_or_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xff,0x00,0x00]

v_or_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0x01,0x01,0x00]

v_or_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0x83,0x01,0x00]

v_or_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xe1,0x01,0x00]

v_or_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xef,0x01,0x00]

v_or_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xf7,0x01,0x00]

v_or_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xf9,0x01,0x00]

v_or_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xfb,0x01,0x00]

v_xor_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0x05,0x02,0x00]

v_xor_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x3a,0xd2,0x01,0x05,0x02,0x00]

v_xor_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0xff,0x05,0x02,0x00]

v_xor_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0x04,0x02,0x00]

v_xor_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x67,0x04,0x02,0x00]

v_xor_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x68,0x04,0x02,0x00]

v_xor_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x69,0x04,0x02,0x00]

v_xor_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x6a,0x04,0x02,0x00]

v_xor_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x6b,0x04,0x02,0x00]

v_xor_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x6c,0x04,0x02,0x00]

v_xor_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x6d,0x04,0x02,0x00]

v_xor_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x6e,0x04,0x02,0x00]

v_xor_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x6f,0x04,0x02,0x00]

v_xor_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x7b,0x04,0x02,0x00]

v_xor_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x7c,0x04,0x02,0x00]

v_xor_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x7e,0x04,0x02,0x00]

v_xor_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x7f,0x04,0x02,0x00]

v_xor_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x80,0x04,0x02,0x00]

v_xor_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0xc1,0x04,0x02,0x00]

v_xor_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0xf0,0x04,0x02,0x00]

v_xor_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0xf7,0x04,0x02,0x00]

v_xor_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0xfb,0x04,0x02,0x00]

v_xor_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0xfc,0x04,0x02,0x00]

v_xor_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0xfd,0x04,0x02,0x00]

v_xor_b32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0xfe,0x04,0x02,0x00]

v_xor_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xff,0x03,0x00]

v_xor_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0x05,0x00,0x00]

v_xor_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xcf,0x00,0x00]

v_xor_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xd1,0x00,0x00]

v_xor_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xd3,0x00,0x00]

v_xor_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xd5,0x00,0x00]

v_xor_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xd7,0x00,0x00]

v_xor_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xd9,0x00,0x00]

v_xor_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xdb,0x00,0x00]

v_xor_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xdd,0x00,0x00]

v_xor_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xdf,0x00,0x00]

v_xor_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xf7,0x00,0x00]

v_xor_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xf9,0x00,0x00]

v_xor_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xfd,0x00,0x00]

v_xor_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xff,0x00,0x00]

v_xor_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0x01,0x01,0x00]

v_xor_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0x83,0x01,0x00]

v_xor_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xe1,0x01,0x00]

v_xor_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xef,0x01,0x00]

v_xor_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xf7,0x01,0x00]

v_xor_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xf9,0x01,0x00]

v_xor_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xfb,0x01,0x00]

v_bfm_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0x05,0x02,0x00]

v_bfm_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x3c,0xd2,0x01,0x05,0x02,0x00]

v_bfm_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0xff,0x05,0x02,0x00]

v_bfm_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0x04,0x02,0x00]

v_bfm_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x67,0x04,0x02,0x00]

v_bfm_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x68,0x04,0x02,0x00]

v_bfm_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x69,0x04,0x02,0x00]

v_bfm_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x6a,0x04,0x02,0x00]

v_bfm_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x6b,0x04,0x02,0x00]

v_bfm_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x6c,0x04,0x02,0x00]

v_bfm_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x6d,0x04,0x02,0x00]

v_bfm_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x6e,0x04,0x02,0x00]

v_bfm_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x6f,0x04,0x02,0x00]

v_bfm_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x7b,0x04,0x02,0x00]

v_bfm_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x7c,0x04,0x02,0x00]

v_bfm_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x7e,0x04,0x02,0x00]

v_bfm_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x7f,0x04,0x02,0x00]

v_bfm_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x80,0x04,0x02,0x00]

v_bfm_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0xc1,0x04,0x02,0x00]

v_bfm_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0xf0,0x04,0x02,0x00]

v_bfm_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0xf7,0x04,0x02,0x00]

v_bfm_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0xfb,0x04,0x02,0x00]

v_bfm_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0xfc,0x04,0x02,0x00]

v_bfm_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0xfd,0x04,0x02,0x00]

v_bfm_b32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0xfe,0x04,0x02,0x00]

v_bfm_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xff,0x03,0x00]

v_bfm_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0x05,0x00,0x00]

v_bfm_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xcf,0x00,0x00]

v_bfm_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xd1,0x00,0x00]

v_bfm_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xd3,0x00,0x00]

v_bfm_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xd5,0x00,0x00]

v_bfm_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xd7,0x00,0x00]

v_bfm_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xd9,0x00,0x00]

v_bfm_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xdb,0x00,0x00]

v_bfm_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xdd,0x00,0x00]

v_bfm_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xdf,0x00,0x00]

v_bfm_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xf7,0x00,0x00]

v_bfm_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xf9,0x00,0x00]

v_bfm_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xfd,0x00,0x00]

v_bfm_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xff,0x00,0x00]

v_bfm_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0x01,0x01,0x00]

v_bfm_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0x83,0x01,0x00]

v_bfm_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xe1,0x01,0x00]

v_bfm_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xef,0x01,0x00]

v_bfm_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xf7,0x01,0x00]

v_bfm_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xf9,0x01,0x00]

v_bfm_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xfb,0x01,0x00]

v_mac_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x3e,0xd2,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0xff,0x05,0x02,0x00]

v_mac_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x04,0x02,0x00]

v_mac_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x67,0x04,0x02,0x00]

v_mac_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x68,0x04,0x02,0x00]

v_mac_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x69,0x04,0x02,0x00]

v_mac_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x6a,0x04,0x02,0x00]

v_mac_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x6b,0x04,0x02,0x00]

v_mac_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x6c,0x04,0x02,0x00]

v_mac_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x6d,0x04,0x02,0x00]

v_mac_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x6e,0x04,0x02,0x00]

v_mac_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x6f,0x04,0x02,0x00]

v_mac_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x7b,0x04,0x02,0x00]

v_mac_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x7c,0x04,0x02,0x00]

v_mac_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x7e,0x04,0x02,0x00]

v_mac_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x7f,0x04,0x02,0x00]

v_mac_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x80,0x04,0x02,0x00]

v_mac_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0xc1,0x04,0x02,0x00]

v_mac_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0xf0,0x04,0x02,0x00]

v_mac_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0xf7,0x04,0x02,0x00]

v_mac_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0xfb,0x04,0x02,0x00]

v_mac_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0xfc,0x04,0x02,0x00]

v_mac_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0xfd,0x04,0x02,0x00]

v_mac_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0xfe,0x04,0x02,0x00]

v_mac_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xff,0x03,0x00]

v_mac_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x00,0x00]

v_mac_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xcf,0x00,0x00]

v_mac_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xd1,0x00,0x00]

v_mac_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xd3,0x00,0x00]

v_mac_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xd5,0x00,0x00]

v_mac_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xd7,0x00,0x00]

v_mac_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xd9,0x00,0x00]

v_mac_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xdb,0x00,0x00]

v_mac_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xdd,0x00,0x00]

v_mac_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xdf,0x00,0x00]

v_mac_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xf7,0x00,0x00]

v_mac_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xf9,0x00,0x00]

v_mac_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xfd,0x00,0x00]

v_mac_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xff,0x00,0x00]

v_mac_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x01,0x01,0x00]

v_mac_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x83,0x01,0x00]

v_mac_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xe1,0x01,0x00]

v_mac_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xef,0x01,0x00]

v_mac_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xf7,0x01,0x00]

v_mac_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xf9,0x01,0x00]

v_mac_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xfb,0x01,0x00]

v_mac_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x20]

v_mac_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x40]

v_mac_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x60]

v_mac_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x3e,0xd2,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x3e,0xd2,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x3e,0xd2,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x3e,0xd2,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x08]

v_mac_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x10]

v_mac_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x18]

v_bcnt_u32_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0x05,0x02,0x00]

v_bcnt_u32_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x44,0xd2,0x01,0x05,0x02,0x00]

v_bcnt_u32_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x44,0xd2,0xff,0x05,0x02,0x00]

v_bcnt_u32_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x67,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x68,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x69,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x6a,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x6b,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x6c,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x6d,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x6e,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x6f,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x7b,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x7c,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x7e,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x7f,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x80,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x44,0xd2,0xc1,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x44,0xd2,0xf0,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x44,0xd2,0xf7,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x44,0xd2,0xfb,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x44,0xd2,0xfc,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x44,0xd2,0xfd,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x44,0xd2,0xfe,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xff,0x03,0x00]

v_bcnt_u32_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0x05,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xcf,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xd1,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xd3,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xd5,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xd7,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xd9,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xdb,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xdd,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xdf,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xf7,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xf9,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xfd,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xff,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0x01,0x01,0x00]

v_bcnt_u32_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0x83,0x01,0x00]

v_bcnt_u32_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xe1,0x01,0x00]

v_bcnt_u32_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xef,0x01,0x00]

v_bcnt_u32_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xf7,0x01,0x00]

v_bcnt_u32_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xf9,0x01,0x00]

v_bcnt_u32_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xfb,0x01,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x46,0xd2,0x01,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x46,0xd2,0xff,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x67,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x68,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x69,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x6a,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x6b,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x6c,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x6d,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x6e,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x6f,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x7b,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x7c,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x7e,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x7f,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x80,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x46,0xd2,0xc1,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x46,0xd2,0xf0,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x46,0xd2,0xf7,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x46,0xd2,0xfb,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x46,0xd2,0xfc,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x46,0xd2,0xfd,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x46,0xd2,0xfe,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xff,0x03,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0x05,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xcf,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xd1,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xd3,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xd5,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xd7,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xd9,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xdb,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xdd,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xdf,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xf7,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xf9,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xfd,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xff,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0x01,0x01,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0x83,0x01,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xe1,0x01,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xef,0x01,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xf7,0x01,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xf9,0x01,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xfb,0x01,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x48,0xd2,0x01,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x48,0xd2,0xff,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x67,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x68,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x69,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x6a,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x6b,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x6c,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x6d,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x6e,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x6f,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x7b,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x7c,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x7e,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x7f,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x80,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x48,0xd2,0xc1,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x48,0xd2,0xf0,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x48,0xd2,0xf7,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x48,0xd2,0xfb,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x48,0xd2,0xfc,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x48,0xd2,0xfd,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x48,0xd2,0xfe,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xff,0x03,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0x05,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xcf,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xd1,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xd3,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xd5,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xd7,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xd9,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xdb,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xdd,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xdf,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xf7,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xf9,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xfd,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xff,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0x01,0x01,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0x83,0x01,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xe1,0x01,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xef,0x01,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xf7,0x01,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xf9,0x01,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xfb,0x01,0x00]

v_add_i32_e64 v5, s[12:13], v1, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v255, s[12:13], v1, v2
// CHECK: [0xff,0x0c,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, s[14:15], v1, v2
// CHECK: [0x05,0x0e,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, s[102:103], v1, v2
// CHECK: [0x05,0x66,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, flat_scratch, v1, v2
// CHECK: [0x05,0x68,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, vcc, v1, v2
// CHECK: [0x05,0x6a,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, tba, v1, v2
// CHECK: [0x05,0x6c,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, tma, v1, v2
// CHECK: [0x05,0x6e,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, ttmp[10:11], v1, v2
// CHECK: [0x05,0x7a,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, s[12:13], v255, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0xff,0x05,0x02,0x00]

v_add_i32_e64 v5, s[12:13], s1, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], s103, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x67,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], flat_scratch_lo, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x68,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], flat_scratch_hi, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x69,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], vcc_lo, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x6a,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], vcc_hi, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x6b,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], tba_lo, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x6c,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], tba_hi, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x6d,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], tma_lo, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x6e,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], tma_hi, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x6f,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], ttmp11, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x7b,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], m0, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x7c,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], exec_lo, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x7e,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], exec_hi, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x7f,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], 0, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x80,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], -1, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0xc1,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], 0.5, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0xf0,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], -4.0, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0xf7,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], src_vccz, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0xfb,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], src_execz, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0xfc,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], src_scc, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0xfd,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], src_lds_direct, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0xfe,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], v1, v255
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xff,0x03,0x00]

v_add_i32_e64 v5, s[12:13], v1, s2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0x05,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, s103
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xcf,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, flat_scratch_lo
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xd1,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, flat_scratch_hi
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xd3,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, vcc_lo
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xd5,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, vcc_hi
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xd7,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, tba_lo
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xd9,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, tba_hi
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xdb,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, tma_lo
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xdd,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, tma_hi
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xdf,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, ttmp11
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xf7,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, m0
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xf9,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, exec_lo
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xfd,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, exec_hi
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xff,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, 0
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0x01,0x01,0x00]

v_add_i32_e64 v5, s[12:13], v1, -1
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0x83,0x01,0x00]

v_add_i32_e64 v5, s[12:13], v1, 0.5
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xe1,0x01,0x00]

v_add_i32_e64 v5, s[12:13], v1, -4.0
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xef,0x01,0x00]

v_add_i32_e64 v5, s[12:13], v1, src_vccz
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xf7,0x01,0x00]

v_add_i32_e64 v5, s[12:13], v1, src_execz
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xf9,0x01,0x00]

v_add_i32_e64 v5, s[12:13], v1, src_scc
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xfb,0x01,0x00]

v_sub_i32_e64 v5, s[12:13], v1, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v255, s[12:13], v1, v2
// CHECK: [0xff,0x0c,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, s[14:15], v1, v2
// CHECK: [0x05,0x0e,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, s[102:103], v1, v2
// CHECK: [0x05,0x66,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, flat_scratch, v1, v2
// CHECK: [0x05,0x68,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, vcc, v1, v2
// CHECK: [0x05,0x6a,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, tba, v1, v2
// CHECK: [0x05,0x6c,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, tma, v1, v2
// CHECK: [0x05,0x6e,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, ttmp[10:11], v1, v2
// CHECK: [0x05,0x7a,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], v255, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0xff,0x05,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], s1, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], s103, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x67,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], flat_scratch_lo, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x68,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], flat_scratch_hi, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x69,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], vcc_lo, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x6a,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], vcc_hi, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x6b,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], tba_lo, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x6c,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], tba_hi, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x6d,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], tma_lo, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x6e,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], tma_hi, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x6f,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], ttmp11, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x7b,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], m0, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x7c,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], exec_lo, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x7e,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], exec_hi, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x7f,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], 0, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x80,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], -1, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0xc1,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], 0.5, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0xf0,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], -4.0, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0xf7,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], src_vccz, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0xfb,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], src_execz, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0xfc,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], src_scc, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0xfd,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], src_lds_direct, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0xfe,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], v1, v255
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xff,0x03,0x00]

v_sub_i32_e64 v5, s[12:13], v1, s2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0x05,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, s103
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xcf,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, flat_scratch_lo
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xd1,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, flat_scratch_hi
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xd3,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, vcc_lo
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xd5,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, vcc_hi
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xd7,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, tba_lo
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xd9,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, tba_hi
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xdb,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, tma_lo
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xdd,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, tma_hi
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xdf,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, ttmp11
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xf7,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, m0
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xf9,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, exec_lo
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xfd,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, exec_hi
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xff,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, 0
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0x01,0x01,0x00]

v_sub_i32_e64 v5, s[12:13], v1, -1
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0x83,0x01,0x00]

v_sub_i32_e64 v5, s[12:13], v1, 0.5
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xe1,0x01,0x00]

v_sub_i32_e64 v5, s[12:13], v1, -4.0
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xef,0x01,0x00]

v_sub_i32_e64 v5, s[12:13], v1, src_vccz
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xf7,0x01,0x00]

v_sub_i32_e64 v5, s[12:13], v1, src_execz
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xf9,0x01,0x00]

v_sub_i32_e64 v5, s[12:13], v1, src_scc
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xfb,0x01,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0x05,0x02,0x00]

v_subrev_i32_e64 v255, s[12:13], v1, v2
// CHECK: [0xff,0x0c,0x4e,0xd2,0x01,0x05,0x02,0x00]

v_subrev_i32_e64 v5, s[14:15], v1, v2
// CHECK: [0x05,0x0e,0x4e,0xd2,0x01,0x05,0x02,0x00]

v_subrev_i32_e64 v5, s[102:103], v1, v2
// CHECK: [0x05,0x66,0x4e,0xd2,0x01,0x05,0x02,0x00]

v_subrev_i32_e64 v5, flat_scratch, v1, v2
// CHECK: [0x05,0x68,0x4e,0xd2,0x01,0x05,0x02,0x00]

v_subrev_i32_e64 v5, vcc, v1, v2
// CHECK: [0x05,0x6a,0x4e,0xd2,0x01,0x05,0x02,0x00]

v_subrev_i32_e64 v5, tba, v1, v2
// CHECK: [0x05,0x6c,0x4e,0xd2,0x01,0x05,0x02,0x00]

v_subrev_i32_e64 v5, tma, v1, v2
// CHECK: [0x05,0x6e,0x4e,0xd2,0x01,0x05,0x02,0x00]

v_subrev_i32_e64 v5, ttmp[10:11], v1, v2
// CHECK: [0x05,0x7a,0x4e,0xd2,0x01,0x05,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], v255, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0xff,0x05,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], s1, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], s103, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x67,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], flat_scratch_lo, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x68,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], flat_scratch_hi, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x69,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], vcc_lo, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x6a,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], vcc_hi, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x6b,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], tba_lo, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x6c,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], tba_hi, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x6d,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], tma_lo, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x6e,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], tma_hi, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x6f,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], ttmp11, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x7b,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], m0, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x7c,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], exec_lo, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x7e,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], exec_hi, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x7f,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], 0, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x80,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], -1, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0xc1,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], 0.5, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0xf0,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], -4.0, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0xf7,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], src_vccz, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0xfb,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], src_execz, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0xfc,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], src_scc, v2
// CHECK: [0x05,0x0c,0x4e,0xd2,0xfd,0x04,0x02,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, v255
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xff,0x03,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, s2
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0x05,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, s103
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xcf,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, flat_scratch_lo
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xd1,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, flat_scratch_hi
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xd3,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, vcc_lo
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xd5,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, vcc_hi
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xd7,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, tba_lo
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xd9,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, tba_hi
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xdb,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, tma_lo
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xdd,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, tma_hi
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xdf,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, ttmp11
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xf7,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, m0
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xf9,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, exec_lo
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xfd,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, exec_hi
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xff,0x00,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, 0
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0x01,0x01,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, -1
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0x83,0x01,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, 0.5
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xe1,0x01,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, -4.0
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xef,0x01,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, src_vccz
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xf7,0x01,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, src_execz
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xf9,0x01,0x00]

v_subrev_i32_e64 v5, s[12:13], v1, src_scc
// CHECK: [0x05,0x0c,0x4e,0xd2,0x01,0xfb,0x01,0x00]

v_addc_u32_e64 v5, s[12:13], v1, v2, s[6:7]
// CHECK: [0x05,0x0c,0x50,0xd2,0x01,0x05,0x1a,0x00]

v_addc_u32_e64 v255, s[12:13], v1, v2, s[6:7]
// CHECK: [0xff,0x0c,0x50,0xd2,0x01,0x05,0x1a,0x00]

v_addc_u32_e64 v5, s[14:15], v1, v2, s[6:7]
// CHECK: [0x05,0x0e,0x50,0xd2,0x01,0x05,0x1a,0x00]

v_addc_u32_e64 v5, s[102:103], v1, v2, s[6:7]
// CHECK: [0x05,0x66,0x50,0xd2,0x01,0x05,0x1a,0x00]

v_addc_u32_e64 v5, flat_scratch, v1, v2, s[6:7]
// CHECK: [0x05,0x68,0x50,0xd2,0x01,0x05,0x1a,0x00]

v_addc_u32_e64 v5, vcc, v1, v2, s[6:7]
// CHECK: [0x05,0x6a,0x50,0xd2,0x01,0x05,0x1a,0x00]

v_addc_u32_e64 v5, tba, v1, v2, s[6:7]
// CHECK: [0x05,0x6c,0x50,0xd2,0x01,0x05,0x1a,0x00]

v_addc_u32_e64 v5, tma, v1, v2, s[6:7]
// CHECK: [0x05,0x6e,0x50,0xd2,0x01,0x05,0x1a,0x00]

v_addc_u32_e64 v5, ttmp[10:11], v1, v2, s[6:7]
// CHECK: [0x05,0x7a,0x50,0xd2,0x01,0x05,0x1a,0x00]

v_addc_u32_e64 v5, s[12:13], v255, v2, s[6:7]
// CHECK: [0x05,0x0c,0x50,0xd2,0xff,0x05,0x1a,0x00]

v_addc_u32_e64 v5, s[12:13], 0, v2, s[6:7]
// CHECK: [0x05,0x0c,0x50,0xd2,0x80,0x04,0x1a,0x00]

v_addc_u32_e64 v5, s[12:13], -1, v2, s[6:7]
// CHECK: [0x05,0x0c,0x50,0xd2,0xc1,0x04,0x1a,0x00]

v_addc_u32_e64 v5, s[12:13], 0.5, v2, s[6:7]
// CHECK: [0x05,0x0c,0x50,0xd2,0xf0,0x04,0x1a,0x00]

v_addc_u32_e64 v5, s[12:13], -4.0, v2, s[6:7]
// CHECK: [0x05,0x0c,0x50,0xd2,0xf7,0x04,0x1a,0x00]

v_addc_u32_e64 v5, s[12:13], src_lds_direct, v2, s[6:7]
// CHECK: [0x05,0x0c,0x50,0xd2,0xfe,0x04,0x1a,0x00]

v_addc_u32_e64 v5, s[12:13], v1, v255, s[6:7]
// CHECK: [0x05,0x0c,0x50,0xd2,0x01,0xff,0x1b,0x00]

v_addc_u32_e64 v5, s[12:13], v1, 0, s[6:7]
// CHECK: [0x05,0x0c,0x50,0xd2,0x01,0x01,0x19,0x00]

v_addc_u32_e64 v5, s[12:13], v1, -1, s[6:7]
// CHECK: [0x05,0x0c,0x50,0xd2,0x01,0x83,0x19,0x00]

v_addc_u32_e64 v5, s[12:13], v1, 0.5, s[6:7]
// CHECK: [0x05,0x0c,0x50,0xd2,0x01,0xe1,0x19,0x00]

v_addc_u32_e64 v5, s[12:13], v1, -4.0, s[6:7]
// CHECK: [0x05,0x0c,0x50,0xd2,0x01,0xef,0x19,0x00]

v_addc_u32_e64 v5, s[12:13], v1, v2, s[8:9]
// CHECK: [0x05,0x0c,0x50,0xd2,0x01,0x05,0x22,0x00]

v_addc_u32_e64 v5, s[12:13], v1, v2, s[102:103]
// CHECK: [0x05,0x0c,0x50,0xd2,0x01,0x05,0x9a,0x01]

v_addc_u32_e64 v5, s[12:13], v1, v2, flat_scratch
// CHECK: [0x05,0x0c,0x50,0xd2,0x01,0x05,0xa2,0x01]

v_addc_u32_e64 v5, s[12:13], v1, v2, vcc
// CHECK: [0x05,0x0c,0x50,0xd2,0x01,0x05,0xaa,0x01]

v_addc_u32_e64 v5, s[12:13], v1, v2, tba
// CHECK: [0x05,0x0c,0x50,0xd2,0x01,0x05,0xb2,0x01]

v_addc_u32_e64 v5, s[12:13], v1, v2, tma
// CHECK: [0x05,0x0c,0x50,0xd2,0x01,0x05,0xba,0x01]

v_addc_u32_e64 v5, s[12:13], v1, v2, ttmp[10:11]
// CHECK: [0x05,0x0c,0x50,0xd2,0x01,0x05,0xea,0x01]

v_subb_u32_e64 v5, s[12:13], v1, v2, s[6:7]
// CHECK: [0x05,0x0c,0x52,0xd2,0x01,0x05,0x1a,0x00]

v_subb_u32_e64 v255, s[12:13], v1, v2, s[6:7]
// CHECK: [0xff,0x0c,0x52,0xd2,0x01,0x05,0x1a,0x00]

v_subb_u32_e64 v5, s[14:15], v1, v2, s[6:7]
// CHECK: [0x05,0x0e,0x52,0xd2,0x01,0x05,0x1a,0x00]

v_subb_u32_e64 v5, s[102:103], v1, v2, s[6:7]
// CHECK: [0x05,0x66,0x52,0xd2,0x01,0x05,0x1a,0x00]

v_subb_u32_e64 v5, flat_scratch, v1, v2, s[6:7]
// CHECK: [0x05,0x68,0x52,0xd2,0x01,0x05,0x1a,0x00]

v_subb_u32_e64 v5, vcc, v1, v2, s[6:7]
// CHECK: [0x05,0x6a,0x52,0xd2,0x01,0x05,0x1a,0x00]

v_subb_u32_e64 v5, tba, v1, v2, s[6:7]
// CHECK: [0x05,0x6c,0x52,0xd2,0x01,0x05,0x1a,0x00]

v_subb_u32_e64 v5, tma, v1, v2, s[6:7]
// CHECK: [0x05,0x6e,0x52,0xd2,0x01,0x05,0x1a,0x00]

v_subb_u32_e64 v5, ttmp[10:11], v1, v2, s[6:7]
// CHECK: [0x05,0x7a,0x52,0xd2,0x01,0x05,0x1a,0x00]

v_subb_u32_e64 v5, s[12:13], v255, v2, s[6:7]
// CHECK: [0x05,0x0c,0x52,0xd2,0xff,0x05,0x1a,0x00]

v_subb_u32_e64 v5, s[12:13], 0, v2, s[6:7]
// CHECK: [0x05,0x0c,0x52,0xd2,0x80,0x04,0x1a,0x00]

v_subb_u32_e64 v5, s[12:13], -1, v2, s[6:7]
// CHECK: [0x05,0x0c,0x52,0xd2,0xc1,0x04,0x1a,0x00]

v_subb_u32_e64 v5, s[12:13], 0.5, v2, s[6:7]
// CHECK: [0x05,0x0c,0x52,0xd2,0xf0,0x04,0x1a,0x00]

v_subb_u32_e64 v5, s[12:13], -4.0, v2, s[6:7]
// CHECK: [0x05,0x0c,0x52,0xd2,0xf7,0x04,0x1a,0x00]

v_subb_u32_e64 v5, s[12:13], src_lds_direct, v2, s[6:7]
// CHECK: [0x05,0x0c,0x52,0xd2,0xfe,0x04,0x1a,0x00]

v_subb_u32_e64 v5, s[12:13], v1, v255, s[6:7]
// CHECK: [0x05,0x0c,0x52,0xd2,0x01,0xff,0x1b,0x00]

v_subb_u32_e64 v5, s[12:13], v1, 0, s[6:7]
// CHECK: [0x05,0x0c,0x52,0xd2,0x01,0x01,0x19,0x00]

v_subb_u32_e64 v5, s[12:13], v1, -1, s[6:7]
// CHECK: [0x05,0x0c,0x52,0xd2,0x01,0x83,0x19,0x00]

v_subb_u32_e64 v5, s[12:13], v1, 0.5, s[6:7]
// CHECK: [0x05,0x0c,0x52,0xd2,0x01,0xe1,0x19,0x00]

v_subb_u32_e64 v5, s[12:13], v1, -4.0, s[6:7]
// CHECK: [0x05,0x0c,0x52,0xd2,0x01,0xef,0x19,0x00]

v_subb_u32_e64 v5, s[12:13], v1, v2, s[8:9]
// CHECK: [0x05,0x0c,0x52,0xd2,0x01,0x05,0x22,0x00]

v_subb_u32_e64 v5, s[12:13], v1, v2, s[102:103]
// CHECK: [0x05,0x0c,0x52,0xd2,0x01,0x05,0x9a,0x01]

v_subb_u32_e64 v5, s[12:13], v1, v2, flat_scratch
// CHECK: [0x05,0x0c,0x52,0xd2,0x01,0x05,0xa2,0x01]

v_subb_u32_e64 v5, s[12:13], v1, v2, vcc
// CHECK: [0x05,0x0c,0x52,0xd2,0x01,0x05,0xaa,0x01]

v_subb_u32_e64 v5, s[12:13], v1, v2, tba
// CHECK: [0x05,0x0c,0x52,0xd2,0x01,0x05,0xb2,0x01]

v_subb_u32_e64 v5, s[12:13], v1, v2, tma
// CHECK: [0x05,0x0c,0x52,0xd2,0x01,0x05,0xba,0x01]

v_subb_u32_e64 v5, s[12:13], v1, v2, ttmp[10:11]
// CHECK: [0x05,0x0c,0x52,0xd2,0x01,0x05,0xea,0x01]

v_subbrev_u32_e64 v5, s[12:13], v1, v2, s[6:7]
// CHECK: [0x05,0x0c,0x54,0xd2,0x01,0x05,0x1a,0x00]

v_subbrev_u32_e64 v255, s[12:13], v1, v2, s[6:7]
// CHECK: [0xff,0x0c,0x54,0xd2,0x01,0x05,0x1a,0x00]

v_subbrev_u32_e64 v5, s[14:15], v1, v2, s[6:7]
// CHECK: [0x05,0x0e,0x54,0xd2,0x01,0x05,0x1a,0x00]

v_subbrev_u32_e64 v5, s[102:103], v1, v2, s[6:7]
// CHECK: [0x05,0x66,0x54,0xd2,0x01,0x05,0x1a,0x00]

v_subbrev_u32_e64 v5, flat_scratch, v1, v2, s[6:7]
// CHECK: [0x05,0x68,0x54,0xd2,0x01,0x05,0x1a,0x00]

v_subbrev_u32_e64 v5, vcc, v1, v2, s[6:7]
// CHECK: [0x05,0x6a,0x54,0xd2,0x01,0x05,0x1a,0x00]

v_subbrev_u32_e64 v5, tba, v1, v2, s[6:7]
// CHECK: [0x05,0x6c,0x54,0xd2,0x01,0x05,0x1a,0x00]

v_subbrev_u32_e64 v5, tma, v1, v2, s[6:7]
// CHECK: [0x05,0x6e,0x54,0xd2,0x01,0x05,0x1a,0x00]

v_subbrev_u32_e64 v5, ttmp[10:11], v1, v2, s[6:7]
// CHECK: [0x05,0x7a,0x54,0xd2,0x01,0x05,0x1a,0x00]

v_subbrev_u32_e64 v5, s[12:13], v255, v2, s[6:7]
// CHECK: [0x05,0x0c,0x54,0xd2,0xff,0x05,0x1a,0x00]

v_subbrev_u32_e64 v5, s[12:13], 0, v2, s[6:7]
// CHECK: [0x05,0x0c,0x54,0xd2,0x80,0x04,0x1a,0x00]

v_subbrev_u32_e64 v5, s[12:13], -1, v2, s[6:7]
// CHECK: [0x05,0x0c,0x54,0xd2,0xc1,0x04,0x1a,0x00]

v_subbrev_u32_e64 v5, s[12:13], 0.5, v2, s[6:7]
// CHECK: [0x05,0x0c,0x54,0xd2,0xf0,0x04,0x1a,0x00]

v_subbrev_u32_e64 v5, s[12:13], -4.0, v2, s[6:7]
// CHECK: [0x05,0x0c,0x54,0xd2,0xf7,0x04,0x1a,0x00]

v_subbrev_u32_e64 v5, s[12:13], v1, v255, s[6:7]
// CHECK: [0x05,0x0c,0x54,0xd2,0x01,0xff,0x1b,0x00]

v_subbrev_u32_e64 v5, s[12:13], v1, 0, s[6:7]
// CHECK: [0x05,0x0c,0x54,0xd2,0x01,0x01,0x19,0x00]

v_subbrev_u32_e64 v5, s[12:13], v1, -1, s[6:7]
// CHECK: [0x05,0x0c,0x54,0xd2,0x01,0x83,0x19,0x00]

v_subbrev_u32_e64 v5, s[12:13], v1, 0.5, s[6:7]
// CHECK: [0x05,0x0c,0x54,0xd2,0x01,0xe1,0x19,0x00]

v_subbrev_u32_e64 v5, s[12:13], v1, -4.0, s[6:7]
// CHECK: [0x05,0x0c,0x54,0xd2,0x01,0xef,0x19,0x00]

v_subbrev_u32_e64 v5, s[12:13], v1, v2, s[8:9]
// CHECK: [0x05,0x0c,0x54,0xd2,0x01,0x05,0x22,0x00]

v_subbrev_u32_e64 v5, s[12:13], v1, v2, s[102:103]
// CHECK: [0x05,0x0c,0x54,0xd2,0x01,0x05,0x9a,0x01]

v_subbrev_u32_e64 v5, s[12:13], v1, v2, flat_scratch
// CHECK: [0x05,0x0c,0x54,0xd2,0x01,0x05,0xa2,0x01]

v_subbrev_u32_e64 v5, s[12:13], v1, v2, vcc
// CHECK: [0x05,0x0c,0x54,0xd2,0x01,0x05,0xaa,0x01]

v_subbrev_u32_e64 v5, s[12:13], v1, v2, tba
// CHECK: [0x05,0x0c,0x54,0xd2,0x01,0x05,0xb2,0x01]

v_subbrev_u32_e64 v5, s[12:13], v1, v2, tma
// CHECK: [0x05,0x0c,0x54,0xd2,0x01,0x05,0xba,0x01]

v_subbrev_u32_e64 v5, s[12:13], v1, v2, ttmp[10:11]
// CHECK: [0x05,0x0c,0x54,0xd2,0x01,0x05,0xea,0x01]

v_ldexp_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0x05,0x02,0x00]

v_ldexp_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x56,0xd2,0x01,0x05,0x02,0x00]

v_ldexp_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x56,0xd2,0xff,0x05,0x02,0x00]

v_ldexp_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x67,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x68,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x69,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x6a,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x6b,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x6c,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x6d,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x6e,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x6f,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x7b,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x7c,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x7e,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x7f,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x80,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x56,0xd2,0xc1,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x56,0xd2,0xf0,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x56,0xd2,0xf7,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x56,0xd2,0xfb,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x56,0xd2,0xfc,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x56,0xd2,0xfd,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x56,0xd2,0xfe,0x04,0x02,0x00]

v_ldexp_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xff,0x03,0x00]

v_ldexp_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0x05,0x00,0x00]

v_ldexp_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xcf,0x00,0x00]

v_ldexp_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xd1,0x00,0x00]

v_ldexp_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xd3,0x00,0x00]

v_ldexp_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xd5,0x00,0x00]

v_ldexp_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xd7,0x00,0x00]

v_ldexp_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xd9,0x00,0x00]

v_ldexp_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xdb,0x00,0x00]

v_ldexp_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xdd,0x00,0x00]

v_ldexp_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xdf,0x00,0x00]

v_ldexp_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xf7,0x00,0x00]

v_ldexp_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xf9,0x00,0x00]

v_ldexp_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xfd,0x00,0x00]

v_ldexp_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xff,0x00,0x00]

v_ldexp_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0x01,0x01,0x00]

v_ldexp_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0x83,0x01,0x00]

v_ldexp_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xe1,0x01,0x00]

v_ldexp_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xef,0x01,0x00]

v_ldexp_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xf7,0x01,0x00]

v_ldexp_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xf9,0x01,0x00]

v_ldexp_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0xfb,0x01,0x00]

v_ldexp_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0x05,0x02,0x20]

v_ldexp_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x56,0xd2,0x01,0x05,0x02,0x00]

v_ldexp_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x56,0xd2,0x01,0x05,0x02,0x00]

v_ldexp_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0x05,0x02,0x08]

v_ldexp_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0x05,0x02,0x10]

v_ldexp_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x56,0xd2,0x01,0x05,0x02,0x18]

v_cvt_pkaccum_u8_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x58,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x58,0xd2,0xff,0x05,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x67,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x68,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x69,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x6a,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x6b,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x6c,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x6d,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x6e,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x6f,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x7b,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x7c,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x7e,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x7f,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x80,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x58,0xd2,0xc1,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x58,0xd2,0xf0,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x58,0xd2,0xf7,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x58,0xd2,0xfb,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x58,0xd2,0xfc,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x58,0xd2,0xfd,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x58,0xd2,0xfe,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xff,0x03,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0x05,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xcf,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xd1,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xd3,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xd5,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xd7,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xd9,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xdb,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xdd,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xdf,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xf7,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xf9,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xfd,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xff,0x00,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0x01,0x01,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0x83,0x01,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xe1,0x01,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xef,0x01,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xf7,0x01,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xf9,0x01,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0xfb,0x01,0x00]

v_cvt_pkaccum_u8_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x58,0xd2,0x01,0x05,0x02,0x20]

v_cvt_pkaccum_u8_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x58,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x5a,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0xff,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x67,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x68,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x69,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x6a,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x6b,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x6c,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x6d,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x6e,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x6f,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x7b,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x7c,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x7e,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x7f,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x80,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0xc1,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0xf0,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0xf7,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0xfb,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0xfc,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0xfd,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0xfe,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xff,0x03,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0x05,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xcf,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xd1,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xd3,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xd5,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xd7,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xd9,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xdb,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xdd,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xdf,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xf7,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xf9,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xfd,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xff,0x00,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0x01,0x01,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0x83,0x01,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xe1,0x01,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xef,0x01,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xf7,0x01,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xf9,0x01,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0xfb,0x01,0x00]

v_cvt_pknorm_i16_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0x05,0x02,0x20]

v_cvt_pknorm_i16_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0x05,0x02,0x40]

v_cvt_pknorm_i16_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x5a,0xd2,0x01,0x05,0x02,0x60]

v_cvt_pknorm_i16_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x5a,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x5a,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x5a,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x5c,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0xff,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x67,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x68,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x69,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x6a,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x6b,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x6c,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x6d,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x6e,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x6f,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x7b,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x7c,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x7e,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x7f,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x80,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0xc1,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0xf0,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0xf7,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0xfb,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0xfc,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0xfd,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0xfe,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xff,0x03,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0x05,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xcf,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xd1,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xd3,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xd5,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xd7,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xd9,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xdb,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xdd,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xdf,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xf7,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xf9,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xfd,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xff,0x00,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0x01,0x01,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0x83,0x01,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xe1,0x01,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xef,0x01,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xf7,0x01,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xf9,0x01,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0xfb,0x01,0x00]

v_cvt_pknorm_u16_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0x05,0x02,0x20]

v_cvt_pknorm_u16_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0x05,0x02,0x40]

v_cvt_pknorm_u16_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x5c,0xd2,0x01,0x05,0x02,0x60]

v_cvt_pknorm_u16_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x5c,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x5c,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x5c,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x5e,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0xff,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x67,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x68,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x69,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x6a,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x6b,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x6c,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x6d,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x6e,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x6f,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x7b,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x7c,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x7e,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x7f,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x80,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0xc1,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0xf0,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0xf7,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0xfb,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0xfc,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0xfd,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0xfe,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xff,0x03,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0x05,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xcf,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xd1,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xd3,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xd5,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xd7,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xd9,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xdb,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xdd,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xdf,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xf7,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xf9,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xfd,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xff,0x00,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0x01,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0x83,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xe1,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xef,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xf7,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xf9,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0xfb,0x01,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0x05,0x02,0x20]

v_cvt_pkrtz_f16_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0x05,0x02,0x40]

v_cvt_pkrtz_f16_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x5e,0xd2,0x01,0x05,0x02,0x60]

v_cvt_pkrtz_f16_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x5e,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x5e,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x5e,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pk_u16_u32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x60,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x60,0xd2,0xff,0x05,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x67,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x68,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x69,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x6a,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x6b,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x6c,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x6d,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x6e,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x6f,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x7b,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x7c,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x7e,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x7f,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x60,0xd2,0x80,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x60,0xd2,0xc1,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x60,0xd2,0xf0,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x60,0xd2,0xf7,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x60,0xd2,0xfb,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x60,0xd2,0xfc,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x60,0xd2,0xfd,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x60,0xd2,0xfe,0x04,0x02,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xff,0x03,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0x05,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xcf,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xd1,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xd3,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xd5,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xd7,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xd9,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xdb,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xdd,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xdf,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xf7,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xf9,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xfd,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xff,0x00,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0x01,0x01,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0x83,0x01,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xe1,0x01,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xef,0x01,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xf7,0x01,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xf9,0x01,0x00]

v_cvt_pk_u16_u32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x60,0xd2,0x01,0xfb,0x01,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pk_i16_i32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x62,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x62,0xd2,0xff,0x05,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x67,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x68,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x69,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x6a,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x6b,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x6c,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x6d,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x6e,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x6f,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x7b,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x7c,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x7e,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x7f,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x62,0xd2,0x80,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x62,0xd2,0xc1,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x62,0xd2,0xf0,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x62,0xd2,0xf7,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x62,0xd2,0xfb,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x62,0xd2,0xfc,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x62,0xd2,0xfd,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x62,0xd2,0xfe,0x04,0x02,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xff,0x03,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0x05,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xcf,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xd1,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xd3,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xd5,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xd7,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xd9,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xdb,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xdd,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xdf,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xf7,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xf9,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xfd,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xff,0x00,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0x01,0x01,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0x83,0x01,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xe1,0x01,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xef,0x01,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xf7,0x01,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xf9,0x01,0x00]

v_cvt_pk_i16_i32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x62,0xd2,0x01,0xfb,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x00,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x00,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x00,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x00,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x00,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x00,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x00,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0xff,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x67,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x68,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x69,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x80,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xff,0x03,0x00]

v_cmp_f_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0x05,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xff,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0x01,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0x83,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xef,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0x05,0x02,0x20]

v_cmp_f_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0x05,0x02,0x40]

v_cmp_f_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x00,0xd0,0x01,0x05,0x02,0x60]

v_cmp_f_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x00,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x00,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x00,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x02,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x02,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x02,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x02,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x02,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x02,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x02,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0xff,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x67,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x68,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x69,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xff,0x03,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0x05,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xff,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xef,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0x05,0x02,0x20]

v_cmp_lt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0x05,0x02,0x40]

v_cmp_lt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x02,0xd0,0x01,0x05,0x02,0x60]

v_cmp_lt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x02,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x02,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x02,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x04,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x04,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x04,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x04,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x04,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x04,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x04,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0xff,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x67,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x68,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x69,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x80,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xff,0x03,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0x05,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xff,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0x01,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0x83,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xef,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0x05,0x02,0x20]

v_cmp_eq_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0x05,0x02,0x40]

v_cmp_eq_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x04,0xd0,0x01,0x05,0x02,0x60]

v_cmp_eq_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x04,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x04,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x04,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x06,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x06,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x06,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x06,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x06,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x06,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x06,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0xff,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x67,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x68,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x69,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x80,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xff,0x03,0x00]

v_cmp_le_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0x05,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xff,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0x01,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0x83,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xef,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0x05,0x02,0x20]

v_cmp_le_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0x05,0x02,0x40]

v_cmp_le_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x06,0xd0,0x01,0x05,0x02,0x60]

v_cmp_le_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x06,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x06,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x06,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x08,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x08,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x08,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x08,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x08,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x08,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x08,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0xff,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x67,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x68,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x69,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x80,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xff,0x03,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0x05,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xff,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0x01,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0x83,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xef,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0x05,0x02,0x20]

v_cmp_gt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0x05,0x02,0x40]

v_cmp_gt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x08,0xd0,0x01,0x05,0x02,0x60]

v_cmp_gt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x08,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x08,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x08,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x0a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x0a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x0a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x0a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x0a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x0a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x0a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0xff,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x67,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x68,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x69,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xff,0x03,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0x05,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xff,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xef,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0x05,0x02,0x20]

v_cmp_lg_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0x05,0x02,0x40]

v_cmp_lg_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x0a,0xd0,0x01,0x05,0x02,0x60]

v_cmp_lg_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x0a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x0a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x0a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x0c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x0c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x0c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x0c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x0c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x0c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x0c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x68,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x69,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0x05,0x02,0x20]

v_cmp_ge_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0x05,0x02,0x40]

v_cmp_ge_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x0c,0xd0,0x01,0x05,0x02,0x60]

v_cmp_ge_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x0c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x0c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x0c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x0e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x0e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x0e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x0e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x0e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x0e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x0e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0xff,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x67,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x68,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x69,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x80,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xff,0x03,0x00]

v_cmp_o_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0x05,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xff,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0x01,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0x83,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xef,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0x05,0x02,0x20]

v_cmp_o_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0x05,0x02,0x40]

v_cmp_o_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x0e,0xd0,0x01,0x05,0x02,0x60]

v_cmp_o_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x0e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x0e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x0e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xff,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x67,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x68,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x69,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x80,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xff,0x03,0x00]

v_cmp_u_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x05,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xff,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x01,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x83,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xef,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x05,0x02,0x20]

v_cmp_u_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x05,0x02,0x40]

v_cmp_u_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x05,0x02,0x60]

v_cmp_u_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xff,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x67,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x68,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x69,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xff,0x03,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0x05,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xff,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nge_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nge_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nge_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xff,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x67,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x68,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x69,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xff,0x03,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x05,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xff,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nlg_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nlg_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nlg_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x16,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x16,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x16,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x16,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x16,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x16,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x16,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x68,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x69,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0x05,0x02,0x20]

v_cmp_ngt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0x05,0x02,0x40]

v_cmp_ngt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x16,0xd0,0x01,0x05,0x02,0x60]

v_cmp_ngt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x16,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x16,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x16,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x18,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x18,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x18,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x18,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x18,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x18,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x18,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0xff,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x67,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x68,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x69,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xff,0x03,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0x05,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xff,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nle_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nle_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x18,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nle_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x18,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x18,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x18,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x1a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x1a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x1a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x1a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x1a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x1a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x1a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0xff,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x67,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x68,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x69,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x80,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xff,0x03,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0x05,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xff,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0x01,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0x83,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xef,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0x05,0x02,0x20]

v_cmp_neq_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0x05,0x02,0x40]

v_cmp_neq_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x1a,0xd0,0x01,0x05,0x02,0x60]

v_cmp_neq_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x1a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x1a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x1a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x1c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x1c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x1c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x1c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x1c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x1c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x1c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0xff,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x67,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x68,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x69,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xff,0x03,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0x05,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xff,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nlt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nlt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x1c,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nlt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x1c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x1c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x1c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x1e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x1e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x1e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x1e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x1e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x1e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x1e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0xff,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x67,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x68,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x69,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x6d,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x6f,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x80,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xff,0x03,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0x05,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xd3,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xdb,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xdf,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xff,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0x01,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0x83,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xef,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0x05,0x02,0x20]

v_cmp_tru_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0x05,0x02,0x40]

v_cmp_tru_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x1e,0xd0,0x01,0x05,0x02,0x60]

v_cmp_tru_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x1e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x1e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x1e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_f_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_f_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_f_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_lt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_lt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_lt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_eq_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_eq_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_eq_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_le_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_le_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_le_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_gt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_gt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_gt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_lg_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_lg_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_lg_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_ge_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_ge_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_ge_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_o_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_o_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_o_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_u_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_u_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_u_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nge_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nge_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nge_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nlg_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nlg_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nlg_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_ngt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_ngt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_ngt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nle_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nle_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nle_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_neq_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_neq_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_neq_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nlt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nlt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nlt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x69,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x6d,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x6f,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xd3,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xdb,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xdf,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_tru_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_tru_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_tru_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x02,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x04,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x66,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x68,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x80,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x09,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x01,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x83,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xef,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x05,0x02,0x20]

v_cmp_f_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x05,0x02,0x40]

v_cmp_f_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x05,0x02,0x60]

v_cmp_f_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x02,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x04,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x66,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x68,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x09,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xef,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x05,0x02,0x20]

v_cmp_lt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x05,0x02,0x40]

v_cmp_lt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x05,0x02,0x60]

v_cmp_lt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x02,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x04,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x66,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x68,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x80,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x09,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x01,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x83,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xef,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x05,0x02,0x20]

v_cmp_eq_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x05,0x02,0x40]

v_cmp_eq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x05,0x02,0x60]

v_cmp_eq_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x02,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x04,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x66,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x68,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x80,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x09,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x01,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x83,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xef,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x05,0x02,0x20]

v_cmp_le_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x05,0x02,0x40]

v_cmp_le_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x05,0x02,0x60]

v_cmp_le_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x02,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x04,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x66,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x68,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x80,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x09,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x01,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x83,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xef,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x05,0x02,0x20]

v_cmp_gt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x05,0x02,0x40]

v_cmp_gt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x05,0x02,0x60]

v_cmp_gt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x02,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x04,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x66,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x68,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x09,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xef,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x05,0x02,0x20]

v_cmp_lg_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x05,0x02,0x40]

v_cmp_lg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x05,0x02,0x60]

v_cmp_lg_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x02,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x04,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x68,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x09,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x05,0x02,0x20]

v_cmp_ge_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x05,0x02,0x40]

v_cmp_ge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x05,0x02,0x60]

v_cmp_ge_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x02,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x04,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x66,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x68,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x80,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x09,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x01,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x83,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xef,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x05,0x02,0x20]

v_cmp_o_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x05,0x02,0x40]

v_cmp_o_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x05,0x02,0x60]

v_cmp_o_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x02,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x04,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x66,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x68,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x80,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x09,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x01,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x83,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xef,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x05,0x02,0x20]

v_cmp_u_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x05,0x02,0x40]

v_cmp_u_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x05,0x02,0x60]

v_cmp_u_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x02,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x04,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x68,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x09,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nge_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nge_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x02,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x04,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x68,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x09,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nlg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nlg_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x02,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x04,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x68,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x09,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x05,0x02,0x20]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x05,0x02,0x40]

v_cmp_ngt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x05,0x02,0x60]

v_cmp_ngt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x02,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x04,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x68,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x09,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nle_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nle_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nle_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x02,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x04,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x66,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x68,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x80,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x09,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x01,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x83,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xef,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x05,0x02,0x20]

v_cmp_neq_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x05,0x02,0x40]

v_cmp_neq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x05,0x02,0x60]

v_cmp_neq_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x02,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x04,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x68,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x09,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nlt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nlt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x02,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x04,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x66,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x68,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x6c,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x6e,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x80,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x09,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xd1,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xd9,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xdd,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x01,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x83,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xef,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x05,0x02,0x20]

v_cmp_tru_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x05,0x02,0x40]

v_cmp_tru_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x05,0x02,0x60]

v_cmp_tru_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_f_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_f_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_f_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_lt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_lt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_eq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_eq_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_le_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_le_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_le_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_gt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_gt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_lg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_lg_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_ge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_ge_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_o_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_o_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_o_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_u_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_u_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_u_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nge_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nlg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nlg_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_ngt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_ngt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nle_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nle_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_neq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_neq_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nlt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nlt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x68,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x6c,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x6e,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xd1,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xd9,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xdd,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_tru_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_tru_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x80,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x80,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x80,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x80,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x80,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x80,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x80,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0xff,0x05,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x67,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x68,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x69,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x80,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xff,0x03,0x00]

v_cmps_f_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0x05,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xff,0x00,0x00]

v_cmps_f_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0x01,0x01,0x00]

v_cmps_f_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0x83,0x01,0x00]

v_cmps_f_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_f_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xef,0x01,0x00]

v_cmps_f_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_f_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_f_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_f_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0x05,0x02,0x20]

v_cmps_f_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0x05,0x02,0x40]

v_cmps_f_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x80,0xd0,0x01,0x05,0x02,0x60]

v_cmps_f_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x80,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x80,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x80,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x82,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x82,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x82,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x82,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x82,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x82,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x82,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0xff,0x05,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x67,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x68,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x69,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x80,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xff,0x03,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0x05,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xff,0x00,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0x01,0x01,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0x83,0x01,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xef,0x01,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_lt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0x05,0x02,0x20]

v_cmps_lt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0x05,0x02,0x40]

v_cmps_lt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x82,0xd0,0x01,0x05,0x02,0x60]

v_cmps_lt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x82,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x82,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x82,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x84,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x84,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x84,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x84,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x84,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x84,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x84,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0xff,0x05,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x67,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x68,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x69,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x80,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xff,0x03,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0x05,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xff,0x00,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0x01,0x01,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0x83,0x01,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xef,0x01,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_eq_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0x05,0x02,0x20]

v_cmps_eq_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0x05,0x02,0x40]

v_cmps_eq_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x84,0xd0,0x01,0x05,0x02,0x60]

v_cmps_eq_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x84,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x84,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x84,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x86,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x86,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x86,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x86,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x86,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x86,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x86,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0xff,0x05,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x67,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x68,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x69,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x80,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xff,0x03,0x00]

v_cmps_le_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0x05,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xff,0x00,0x00]

v_cmps_le_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0x01,0x01,0x00]

v_cmps_le_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0x83,0x01,0x00]

v_cmps_le_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_le_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xef,0x01,0x00]

v_cmps_le_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_le_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_le_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_le_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0x05,0x02,0x20]

v_cmps_le_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0x05,0x02,0x40]

v_cmps_le_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x86,0xd0,0x01,0x05,0x02,0x60]

v_cmps_le_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x86,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x86,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x86,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x88,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x88,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x88,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x88,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x88,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x88,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x88,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0xff,0x05,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x67,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x68,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x69,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x80,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xff,0x03,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0x05,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xff,0x00,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0x01,0x01,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0x83,0x01,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xef,0x01,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_gt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0x05,0x02,0x20]

v_cmps_gt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0x05,0x02,0x40]

v_cmps_gt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x88,0xd0,0x01,0x05,0x02,0x60]

v_cmps_gt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x88,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x88,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x88,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x8a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x8a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x8a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x8a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x8a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x8a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x8a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0xff,0x05,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x67,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x68,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x69,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x80,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xff,0x03,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0x05,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xff,0x00,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0x01,0x01,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0x83,0x01,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xef,0x01,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_lg_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0x05,0x02,0x20]

v_cmps_lg_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0x05,0x02,0x40]

v_cmps_lg_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x8a,0xd0,0x01,0x05,0x02,0x60]

v_cmps_lg_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x8a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x8a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x8a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x8c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x8c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x8c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x8c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x8c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x8c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x8c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0xff,0x05,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x67,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x68,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x69,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x80,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xff,0x03,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0x05,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xff,0x00,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0x01,0x01,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0x83,0x01,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xef,0x01,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_ge_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0x05,0x02,0x20]

v_cmps_ge_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0x05,0x02,0x40]

v_cmps_ge_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x8c,0xd0,0x01,0x05,0x02,0x60]

v_cmps_ge_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x8c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x8c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x8c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x8e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x8e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x8e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x8e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x8e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x8e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x8e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0xff,0x05,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x67,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x68,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x69,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x80,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xff,0x03,0x00]

v_cmps_o_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0x05,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xff,0x00,0x00]

v_cmps_o_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0x01,0x01,0x00]

v_cmps_o_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0x83,0x01,0x00]

v_cmps_o_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_o_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xef,0x01,0x00]

v_cmps_o_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_o_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_o_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_o_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0x05,0x02,0x20]

v_cmps_o_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0x05,0x02,0x40]

v_cmps_o_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x8e,0xd0,0x01,0x05,0x02,0x60]

v_cmps_o_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x8e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x8e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x8e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x90,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x90,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x90,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x90,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x90,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x90,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x90,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0xff,0x05,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x67,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x68,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x69,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x80,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xff,0x03,0x00]

v_cmps_u_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0x05,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xff,0x00,0x00]

v_cmps_u_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0x01,0x01,0x00]

v_cmps_u_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0x83,0x01,0x00]

v_cmps_u_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_u_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xef,0x01,0x00]

v_cmps_u_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_u_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_u_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_u_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0x05,0x02,0x20]

v_cmps_u_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0x05,0x02,0x40]

v_cmps_u_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x90,0xd0,0x01,0x05,0x02,0x60]

v_cmps_u_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x90,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x90,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x90,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x92,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x92,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x92,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x92,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x92,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x92,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x92,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0xff,0x05,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x67,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x68,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x69,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x80,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xff,0x03,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0x05,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xff,0x00,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0x01,0x01,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0x83,0x01,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xef,0x01,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_nge_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0x05,0x02,0x20]

v_cmps_nge_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0x05,0x02,0x40]

v_cmps_nge_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x92,0xd0,0x01,0x05,0x02,0x60]

v_cmps_nge_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x92,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x92,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x92,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x94,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x94,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x94,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x94,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x94,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x94,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x94,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0xff,0x05,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x67,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x68,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x69,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x80,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xff,0x03,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0x05,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xff,0x00,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0x01,0x01,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0x83,0x01,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xef,0x01,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_nlg_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0x05,0x02,0x20]

v_cmps_nlg_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0x05,0x02,0x40]

v_cmps_nlg_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x94,0xd0,0x01,0x05,0x02,0x60]

v_cmps_nlg_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x94,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x94,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x94,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x96,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x96,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x96,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x96,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x96,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x96,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x96,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0xff,0x05,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x67,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x68,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x69,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x80,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xff,0x03,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0x05,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xff,0x00,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0x01,0x01,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0x83,0x01,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xef,0x01,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_ngt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0x05,0x02,0x20]

v_cmps_ngt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0x05,0x02,0x40]

v_cmps_ngt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x96,0xd0,0x01,0x05,0x02,0x60]

v_cmps_ngt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x96,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x96,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x96,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x98,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x98,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x98,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x98,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x98,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x98,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x98,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0xff,0x05,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x67,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x68,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x69,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x80,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xff,0x03,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0x05,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xff,0x00,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0x01,0x01,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0x83,0x01,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xef,0x01,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_nle_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0x05,0x02,0x20]

v_cmps_nle_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0x05,0x02,0x40]

v_cmps_nle_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x98,0xd0,0x01,0x05,0x02,0x60]

v_cmps_nle_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x98,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x98,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x98,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x9a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x9a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x9a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x9a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x9a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x9a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x9a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0xff,0x05,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x67,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x68,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x69,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x80,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xff,0x03,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0x05,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xff,0x00,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0x01,0x01,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0x83,0x01,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xef,0x01,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_neq_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0x05,0x02,0x20]

v_cmps_neq_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0x05,0x02,0x40]

v_cmps_neq_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x9a,0xd0,0x01,0x05,0x02,0x60]

v_cmps_neq_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x9a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x9a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x9a,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x9c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x9c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x9c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x9c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x9c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x9c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x9c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0xff,0x05,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x67,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x68,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x69,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x80,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xff,0x03,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0x05,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xff,0x00,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0x01,0x01,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0x83,0x01,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xef,0x01,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_nlt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0x05,0x02,0x20]

v_cmps_nlt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0x05,0x02,0x40]

v_cmps_nlt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x9c,0xd0,0x01,0x05,0x02,0x60]

v_cmps_nlt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x9c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x9c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x9c,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x9e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x9e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x9e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x9e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x9e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x9e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x9e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0xff,0x05,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x67,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x68,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x69,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x6b,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x6d,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x6f,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x7b,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x7c,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x7f,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x80,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0xfe,0x04,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xff,0x03,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0x05,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xcf,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xd3,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xd7,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xdb,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xdf,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xf7,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xf9,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xff,0x00,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0x01,0x01,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0x83,0x01,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xef,0x01,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_tru_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0x05,0x02,0x20]

v_cmps_tru_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0x05,0x02,0x40]

v_cmps_tru_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x9e,0xd0,0x01,0x05,0x02,0x60]

v_cmps_tru_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x9e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x9e,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x9e,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_f_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_f_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_f_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_f_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_lt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_lt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_lt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_lt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_eq_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_eq_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_eq_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_eq_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_le_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_le_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_le_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_le_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_gt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_gt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_gt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_gt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_lg_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_lg_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_lg_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_lg_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_ge_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_ge_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_ge_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_ge_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_o_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_o_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_o_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_o_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_u_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_u_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_u_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_u_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_nge_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_nge_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_nge_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_nge_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_nlg_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_nlg_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_nlg_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_ngt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_ngt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_ngt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_nle_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_nle_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_nle_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_nle_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_neq_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_neq_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_neq_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_neq_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_nlt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_nlt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_nlt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xff,0x05,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x67,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x69,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x6b,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x6d,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x6f,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x7b,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x7c,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x7f,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xfe,0x04,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xff,0x03,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0x05,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xcf,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xd3,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xd7,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xdb,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xdf,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xf7,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xf9,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xff,0x00,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_tru_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_tru_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_tru_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_tru_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x02,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x04,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x66,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x68,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x80,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0x09,0x00,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0x01,0x01,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0x83,0x01,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xef,0x01,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_f_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0x05,0x02,0x20]

v_cmps_f_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0x05,0x02,0x40]

v_cmps_f_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0x05,0x02,0x60]

v_cmps_f_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_f_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x02,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x04,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x66,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x68,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x80,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0x09,0x00,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0x01,0x01,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0x83,0x01,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xef,0x01,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_lt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0x05,0x02,0x20]

v_cmps_lt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0x05,0x02,0x40]

v_cmps_lt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0x05,0x02,0x60]

v_cmps_lt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x02,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x04,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x66,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x68,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x80,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0x09,0x00,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0x01,0x01,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0x83,0x01,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xef,0x01,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_eq_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0x05,0x02,0x20]

v_cmps_eq_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0x05,0x02,0x40]

v_cmps_eq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0x05,0x02,0x60]

v_cmps_eq_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_eq_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x02,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x04,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x66,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x68,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x80,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0x09,0x00,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0x01,0x01,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0x83,0x01,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xef,0x01,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_le_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0x05,0x02,0x20]

v_cmps_le_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0x05,0x02,0x40]

v_cmps_le_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0x05,0x02,0x60]

v_cmps_le_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_le_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x02,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x04,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x66,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x68,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x80,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0x09,0x00,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0x01,0x01,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0x83,0x01,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xef,0x01,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_gt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0x05,0x02,0x20]

v_cmps_gt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0x05,0x02,0x40]

v_cmps_gt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0x05,0x02,0x60]

v_cmps_gt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_gt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x02,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x04,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x66,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x68,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x80,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0x09,0x00,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0x01,0x01,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0x83,0x01,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xef,0x01,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_lg_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0x05,0x02,0x20]

v_cmps_lg_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0x05,0x02,0x40]

v_cmps_lg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0x05,0x02,0x60]

v_cmps_lg_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmps_lg_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x02,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x04,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x66,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x68,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x80,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0x09,0x00,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0x01,0x01,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0x83,0x01,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xef,0x01,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_ge_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0x05,0x02,0x20]

v_cmps_ge_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0x05,0x02,0x40]

v_cmps_ge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0x05,0x02,0x60]

v_cmps_ge_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ge_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x02,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x04,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x66,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x68,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x80,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0x09,0x00,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0x01,0x01,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0x83,0x01,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xef,0x01,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_o_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0x05,0x02,0x20]

v_cmps_o_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0x05,0x02,0x40]

v_cmps_o_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0x05,0x02,0x60]

v_cmps_o_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmps_o_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x02,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x04,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x66,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x68,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x80,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0x09,0x00,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0x01,0x01,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0x83,0x01,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xef,0x01,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_u_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0x05,0x02,0x20]

v_cmps_u_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0x05,0x02,0x40]

v_cmps_u_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0x05,0x02,0x60]

v_cmps_u_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_u_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x02,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x04,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x66,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x68,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x80,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0x09,0x00,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0x01,0x01,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0x83,0x01,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xef,0x01,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_nge_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0x05,0x02,0x20]

v_cmps_nge_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0x05,0x02,0x40]

v_cmps_nge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0x05,0x02,0x60]

v_cmps_nge_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nge_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x02,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x04,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x66,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x68,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x80,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0x09,0x00,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0x01,0x01,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0x83,0x01,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xef,0x01,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_nlg_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0x05,0x02,0x20]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0x05,0x02,0x40]

v_cmps_nlg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0x05,0x02,0x60]

v_cmps_nlg_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlg_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x02,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x04,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x66,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x68,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x80,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0x09,0x00,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0x01,0x01,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0x83,0x01,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xef,0x01,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_ngt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0x05,0x02,0x20]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0x05,0x02,0x40]

v_cmps_ngt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0x05,0x02,0x60]

v_cmps_ngt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_ngt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x02,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x04,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x66,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x68,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x80,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0x09,0x00,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0x01,0x01,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0x83,0x01,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xef,0x01,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_nle_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0x05,0x02,0x20]

v_cmps_nle_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0x05,0x02,0x40]

v_cmps_nle_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0x05,0x02,0x60]

v_cmps_nle_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nle_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x02,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x04,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x66,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x68,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x80,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0x09,0x00,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0x01,0x01,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0x83,0x01,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xef,0x01,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_neq_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0x05,0x02,0x20]

v_cmps_neq_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0x05,0x02,0x40]

v_cmps_neq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0x05,0x02,0x60]

v_cmps_neq_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmps_neq_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xdc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xdc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xdc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xdc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xdc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xdc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xdc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x02,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x04,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x66,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x68,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x80,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0x09,0x00,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0x01,0x01,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0x83,0x01,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0xef,0x01,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_nlt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0x05,0x02,0x20]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0x05,0x02,0x40]

v_cmps_nlt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xdc,0xd0,0x01,0x05,0x02,0x60]

v_cmps_nlt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xdc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xdc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_nlt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xdc,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xde,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xde,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xde,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xde,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xde,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xde,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xde,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0xfe,0x05,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x02,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x04,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x66,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x68,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x6a,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x6c,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x6e,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x7a,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x7e,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x80,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0xc1,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0xf0,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0xf7,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0xfb,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0xfc,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0xfd,0x04,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0xfd,0x03,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0x09,0x00,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0x0d,0x00,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0xcd,0x00,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0xd1,0x00,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0xd5,0x00,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0xd9,0x00,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0xdd,0x00,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0xf5,0x00,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0xfd,0x00,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0x01,0x01,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0x83,0x01,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0xe1,0x01,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0xef,0x01,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0xf7,0x01,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0xf9,0x01,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0xfb,0x01,0x00]

v_cmps_tru_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0x05,0x02,0x20]

v_cmps_tru_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0x05,0x02,0x40]

v_cmps_tru_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xde,0xd0,0x01,0x05,0x02,0x60]

v_cmps_tru_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xde,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xde,0xd0,0x01,0x05,0x02,0x00]

v_cmps_tru_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xde,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xe0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xe0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xe0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xe0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xe0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xe0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xe0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_f_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_f_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xe0,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_f_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xe0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xe0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_f_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xe0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xe2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xe2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xe2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xe2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xe2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xe2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xe2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_lt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_lt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xe2,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_lt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xe2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xe2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xe2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xe4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xe4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xe4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xe4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xe4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xe4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xe4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_eq_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_eq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xe4,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_eq_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xe4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xe4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_eq_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xe4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xe6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xe6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xe6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xe6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xe6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xe6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xe6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_le_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_le_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xe6,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_le_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xe6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xe6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_le_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xe6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xe8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xe8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xe8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xe8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xe8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xe8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xe8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_gt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_gt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xe8,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_gt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xe8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xe8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_gt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xe8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xea,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xea,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xea,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xea,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xea,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xea,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xea,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_lg_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_lg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xea,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_lg_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xea,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xea,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_lg_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xea,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xec,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xec,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xec,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xec,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xec,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xec,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xec,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_ge_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_ge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xec,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_ge_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xec,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xec,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ge_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xec,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xee,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xee,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xee,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xee,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xee,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xee,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xee,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_o_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_o_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xee,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_o_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xee,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xee,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_o_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xee,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xf0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xf0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xf0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xf0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xf0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xf0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xf0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_u_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_u_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xf0,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_u_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xf0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xf0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_u_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xf0,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xf2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xf2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xf2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xf2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xf2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xf2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xf2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_nge_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_nge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xf2,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_nge_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xf2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xf2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nge_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xf2,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xf4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xf4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xf4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xf4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xf4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xf4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xf4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_nlg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xf4,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_nlg_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xf4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xf4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlg_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xf4,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xf6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xf6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xf6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xf6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xf6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xf6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xf6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_ngt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xf6,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_ngt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xf6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xf6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_ngt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xf6,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xf8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xf8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xf8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xf8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xf8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xf8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xf8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_nle_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_nle_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xf8,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_nle_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xf8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xf8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nle_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xf8,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xfa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xfa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xfa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xfa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xfa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xfa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xfa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_neq_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_neq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xfa,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_neq_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xfa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xfa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_neq_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xfa,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xfc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xfc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xfc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xfc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xfc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xfc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xfc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_nlt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xfc,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_nlt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xfc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xfc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_nlt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xfc,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0xfe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f64_e64 s[102:103], v[1:2], v[2:3]
// CHECK: [0x66,0x00,0xfe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x68,0x00,0xfe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0xfe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f64_e64 tba, v[1:2], v[2:3]
// CHECK: [0x6c,0x00,0xfe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f64_e64 tma, v[1:2], v[2:3]
// CHECK: [0x6e,0x00,0xfe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f64_e64 ttmp[10:11], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0xfe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0xfe,0x05,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x02,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x04,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], s[102:103], v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x66,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x68,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x6a,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], tba, v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x6c,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], tma, v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x6e,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], ttmp[10:11], v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x7a,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x7e,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x80,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0xc1,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0xf0,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0xf7,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0xfb,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0xfc,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0xfd,0x04,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0xfd,0x03,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0x09,0x00,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0x0d,0x00,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], s[102:103]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0xcd,0x00,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0xd1,0x00,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0xd5,0x00,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], tba
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0xd9,0x00,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], tma
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0xdd,0x00,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], ttmp[10:11]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0xf5,0x00,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0xfd,0x00,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0x01,0x01,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0x83,0x01,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0xe1,0x01,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0xef,0x01,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0xf7,0x01,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0xf9,0x01,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0xfb,0x01,0x00]

v_cmpsx_tru_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0x05,0x02,0x20]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0x05,0x02,0x40]

v_cmpsx_tru_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0xfe,0xd0,0x01,0x05,0x02,0x60]

v_cmpsx_tru_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0xfe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0xfe,0xd0,0x01,0x05,0x02,0x00]

v_cmpsx_tru_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0xfe,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x00,0xd1,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x00,0xd1,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x00,0xd1,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x00,0xd1,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x00,0xd1,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x00,0xd1,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x00,0xd1,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0xff,0x05,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x67,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x68,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x69,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x6a,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x6b,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x6c,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x6d,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x6e,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x6f,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x7b,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x7c,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x7e,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x7f,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0x80,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0xc1,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0xf0,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0xf7,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0xfb,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0xfc,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0xfd,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x00,0xd1,0xfe,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xff,0x03,0x00]

v_cmp_f_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0x05,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xcf,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xd1,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xd3,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xd5,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xd7,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xd9,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xdb,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xdd,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xdf,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xf7,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xf9,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xfd,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xff,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0x01,0x01,0x00]

v_cmp_f_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0x83,0x01,0x00]

v_cmp_f_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xe1,0x01,0x00]

v_cmp_f_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xef,0x01,0x00]

v_cmp_f_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xf7,0x01,0x00]

v_cmp_f_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xf9,0x01,0x00]

v_cmp_f_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x00,0xd1,0x01,0xfb,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x02,0xd1,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x02,0xd1,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x02,0xd1,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x02,0xd1,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x02,0xd1,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x02,0xd1,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x02,0xd1,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0xff,0x05,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x67,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x68,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x69,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x6a,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x6b,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x6c,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x6d,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x6e,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x6f,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x7b,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x7c,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x7e,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x7f,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0x80,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0xc1,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0xf0,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0xf7,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0xfb,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0xfc,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0xfd,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x02,0xd1,0xfe,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xff,0x03,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0x05,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xcf,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xd1,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xd3,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xd5,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xd7,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xd9,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xdb,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xdd,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xdf,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xf7,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xf9,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xfd,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xff,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0x01,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0x83,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xe1,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xef,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xf7,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xf9,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x02,0xd1,0x01,0xfb,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x04,0xd1,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x04,0xd1,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x04,0xd1,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x04,0xd1,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x04,0xd1,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x04,0xd1,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x04,0xd1,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0xff,0x05,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x67,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x68,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x69,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x6a,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x6b,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x6c,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x6d,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x6e,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x6f,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x7b,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x7c,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x7e,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x7f,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0x80,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0xc1,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0xf0,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0xf7,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0xfb,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0xfc,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0xfd,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x04,0xd1,0xfe,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xff,0x03,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0x05,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xcf,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xd1,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xd3,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xd5,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xd7,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xd9,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xdb,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xdd,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xdf,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xf7,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xf9,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xfd,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xff,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0x01,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0x83,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xe1,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xef,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xf7,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xf9,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x04,0xd1,0x01,0xfb,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x06,0xd1,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x06,0xd1,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x06,0xd1,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x06,0xd1,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x06,0xd1,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x06,0xd1,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x06,0xd1,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0xff,0x05,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x67,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x68,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x69,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x6a,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x6b,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x6c,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x6d,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x6e,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x6f,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x7b,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x7c,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x7e,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x7f,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0x80,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0xc1,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0xf0,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0xf7,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0xfb,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0xfc,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0xfd,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x06,0xd1,0xfe,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xff,0x03,0x00]

v_cmp_le_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0x05,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xcf,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xd1,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xd3,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xd5,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xd7,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xd9,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xdb,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xdd,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xdf,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xf7,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xf9,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xfd,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xff,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0x01,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0x83,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xe1,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xef,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xf7,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xf9,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x06,0xd1,0x01,0xfb,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x08,0xd1,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x08,0xd1,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x08,0xd1,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x08,0xd1,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x08,0xd1,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x08,0xd1,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x08,0xd1,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0xff,0x05,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x67,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x68,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x69,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x6a,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x6b,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x6c,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x6d,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x6e,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x6f,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x7b,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x7c,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x7e,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x7f,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0x80,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0xc1,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0xf0,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0xf7,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0xfb,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0xfc,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0xfd,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x08,0xd1,0xfe,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xff,0x03,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0x05,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xcf,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xd1,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xd3,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xd5,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xd7,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xd9,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xdb,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xdd,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xdf,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xf7,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xf9,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xfd,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xff,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0x01,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0x83,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xe1,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xef,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xf7,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xf9,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x08,0xd1,0x01,0xfb,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 tba, v1, v2
// CHECK: [0x6c,0x00,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 tma, v1, v2
// CHECK: [0x6e,0x00,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 ttmp[10:11], v1, v2
// CHECK: [0x7a,0x00,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0xff,0x05,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], s103, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x67,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x68,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x69,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x6a,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x6b,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], tba_lo, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x6c,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], tba_hi, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x6d,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], tma_lo, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x6e,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], tma_hi, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x6f,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], ttmp11, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x7b,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x7c,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x7e,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x7f,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x80,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0xc1,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0xf0,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0xf7,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0xfb,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0xfc,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0xfd,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x0a,0xd1,0xfe,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xff,0x03,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0x05,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, s103
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xcf,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xd1,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xd3,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xd5,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xd7,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, tba_lo
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xd9,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, tba_hi
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xdb,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, tma_lo
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xdd,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, tma_hi
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xdf,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, ttmp11
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xf7,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xf9,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xfd,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xff,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0x01,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0x83,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xe1,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xef,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xf7,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xf9,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x0a,0xd1,0x01,0xfb,0x01,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x0c,0xd1,0x01,0x05,0x02,0x00]

v_cmp_ge_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x0c,0xd1,0x01,0x05,0x02,0x00]

v_cmp_ge_i32_e64 s[102:103], v1, v2
// CHECK: [0x66,0x00,0x0c,0xd1,0x01,0x05,0x02,0x00]

v_cmp_ge_i32_e64 flat_scratch, v1, v2
// CHECK: [0x68,0x00,0x0c,0