; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=riscv32 -mattr=+f -target-abi ilp32f \
; RUN:    -global-isel -stop-after=irtranslator -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV32-ILP32FD,RV32-ILP32F %s
; RUN: llc -mtriple=riscv32 -mattr=+d -target-abi ilp32d \
; RUN:    -global-isel -stop-after=irtranslator -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV32-ILP32FD,RV32-ILP32D %s

; This file contains tests that should have identical output for the ilp32f
; and ilp32d ABIs.

define i32 @callee_float_in_fpr(i32 %a, float %b) nounwind {
  ; RV32-ILP32FD-LABEL: name: callee_float_in_fpr
  ; RV32-ILP32FD: bb.1 (%ir-block.0):
  ; RV32-ILP32FD-NEXT:   liveins: $x10, $f10_f
  ; RV32-ILP32FD-NEXT: {{  $}}
  ; RV32-ILP32FD-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32FD-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $f10_f
  ; RV32-ILP32FD-NEXT:   [[FPTOSI:%[0-9]+]]:_(s32) = G_FPTOSI [[COPY1]](s32)
  ; RV32-ILP32FD-NEXT:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[COPY]], [[FPTOSI]]
  ; RV32-ILP32FD-NEXT:   $x10 = COPY [[ADD]](s32)
  ; RV32-ILP32FD-NEXT:   PseudoRET implicit $x10
  %b_fptosi = fptosi float %b to i32
  %1 = add i32 %a, %b_fptosi
  ret i32 %1
}

define i32 @caller_float_in_fpr() nounwind {
  ; RV32-ILP32F-LABEL: name: caller_float_in_fpr
  ; RV32-ILP32F: bb.1 (%ir-block.0):
  ; RV32-ILP32F-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; RV32-ILP32F-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_FCONSTANT float 2.000000e+00
  ; RV32-ILP32F-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32F-NEXT:   $x10 = COPY [[C]](s32)
  ; RV32-ILP32F-NEXT:   $f10_f = COPY [[C1]](s32)
  ; RV32-ILP32F-NEXT:   PseudoCALL target-flags(riscv-call) @callee_float_in_fpr, csr_ilp32f_lp64f, implicit-def $x1, implicit $x10, implicit $f10_f, implicit-def $x10
  ; RV32-ILP32F-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32F-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32F-NEXT:   $x10 = COPY [[COPY]](s32)
  ; RV32-ILP32F-NEXT:   PseudoRET implicit $x10
  ;
  ; RV32-ILP32D-LABEL: name: caller_float_in_fpr
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; RV32-ILP32D-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_FCONSTANT float 2.000000e+00
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[C]](s32)
  ; RV32-ILP32D-NEXT:   $f10_f = COPY [[C1]](s32)
  ; RV32-ILP32D-NEXT:   PseudoCALL target-flags(riscv-call) @callee_float_in_fpr, csr_ilp32d_lp64d, implicit-def $x1, implicit $x10, implicit $f10_f, implicit-def $x10
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[COPY]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %1 = call i32 @callee_float_in_fpr(i32 1, float 2.0)
  ret i32 %1
}

; Must keep define on a single line due to an update_llc_test_checks.py limitation
define i32 @callee_float_in_fpr_exhausted_gprs(i64 %a, i64 %b, i64 %c, i64 %d, i32 %e, float %f) nounwind {
  ; RV32-ILP32FD-LABEL: name: callee_float_in_fpr_exhausted_gprs
  ; RV32-ILP32FD: bb.1 (%ir-block.0):
  ; RV32-ILP32FD-NEXT:   liveins: $x10, $x11, $x12, $x13, $x14, $x15, $x16, $x17, $f10_f
  ; RV32-ILP32FD-NEXT: {{  $}}
  ; RV32-ILP32FD-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32FD-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x11
  ; RV32-ILP32FD-NEXT:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; RV32-ILP32FD-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $x12
  ; RV32-ILP32FD-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $x13
  ; RV32-ILP32FD-NEXT:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; RV32-ILP32FD-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $x14
  ; RV32-ILP32FD-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $x15
  ; RV32-ILP32FD-NEXT:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY4]](s32), [[COPY5]](s32)
  ; RV32-ILP32FD-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $x16
  ; RV32-ILP32FD-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $x17
  ; RV32-ILP32FD-NEXT:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY6]](s32), [[COPY7]](s32)
  ; RV32-ILP32FD-NEXT:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; RV32-ILP32FD-NEXT:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p0) :: (load (s32) from %fixed-stack.0, align 16)
  ; RV32-ILP32FD-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $f10_f
  ; RV32-ILP32FD-NEXT:   [[FPTOSI:%[0-9]+]]:_(s32) = G_FPTOSI [[COPY8]](s32)
  ; RV32-ILP32FD-NEXT:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[LOAD]], [[FPTOSI]]
  ; RV32-ILP32FD-NEXT:   $x10 = COPY [[ADD]](s32)
  ; RV32-ILP32FD-NEXT:   PseudoRET implicit $x10
  %f_fptosi = fptosi float %f to i32
  %1 = add i32 %e, %f_fptosi
  ret i32 %1
}

define i32 @caller_float_in_fpr_exhausted_gprs() nounwind {
  ; RV32-ILP32F-LABEL: name: caller_float_in_fpr_exhausted_gprs
  ; RV32-ILP32F: bb.1 (%ir-block.0):
  ; RV32-ILP32F-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; RV32-ILP32F-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; RV32-ILP32F-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; RV32-ILP32F-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; RV32-ILP32F-NEXT:   [[C4:%[0-9]+]]:_(s32) = G_CONSTANT i32 5
  ; RV32-ILP32F-NEXT:   [[C5:%[0-9]+]]:_(s32) = G_FCONSTANT float 6.000000e+00
  ; RV32-ILP32F-NEXT:   ADJCALLSTACKDOWN 4, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32F-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C]](s64)
  ; RV32-ILP32F-NEXT:   [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C1]](s64)
  ; RV32-ILP32F-NEXT:   [[UV4:%[0-9]+]]:_(s32), [[UV5:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C2]](s64)
  ; RV32-ILP32F-NEXT:   [[UV6:%[0-9]+]]:_(s32), [[UV7:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C3]](s64)
  ; RV32-ILP32F-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x2
  ; RV32-ILP32F-NEXT:   [[C6:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; RV32-ILP32F-NEXT:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C6]](s32)
  ; RV32-ILP32F-NEXT:   G_STORE [[C4]](s32), [[PTR_ADD]](p0) :: (store (s32) into stack, align 16)
  ; RV32-ILP32F-NEXT:   $x10 = COPY [[UV]](s32)
  ; RV32-ILP32F-NEXT:   $x11 = COPY [[UV1]](s32)
  ; RV32-ILP32F-NEXT:   $x12 = COPY [[UV2]](s32)
  ; RV32-ILP32F-NEXT:   $x13 = COPY [[UV3]](s32)
  ; RV32-ILP32F-NEXT:   $x14 = COPY [[UV4]](s32)
  ; RV32-ILP32F-NEXT:   $x15 = COPY [[UV5]](s32)
  ; RV32-ILP32F-NEXT:   $x16 = COPY [[UV6]](s32)
  ; RV32-ILP32F-NEXT:   $x17 = COPY [[UV7]](s32)
  ; RV32-ILP32F-NEXT:   $f10_f = COPY [[C5]](s32)
  ; RV32-ILP32F-NEXT:   PseudoCALL target-flags(riscv-call) @callee_float_in_fpr_exhausted_gprs, csr_ilp32f_lp64f, implicit-def $x1, implicit $x10, implicit $x11, implicit $x12, implicit $x13, implicit $x14, implicit $x15, implicit $x16, implicit $x17, implicit $f10_f, implicit-def $x10
  ; RV32-ILP32F-NEXT:   ADJCALLSTACKUP 4, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32F-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32F-NEXT:   $x10 = COPY [[COPY1]](s32)
  ; RV32-ILP32F-NEXT:   PseudoRET implicit $x10
  ;
  ; RV32-ILP32D-LABEL: name: caller_float_in_fpr_exhausted_gprs
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; RV32-ILP32D-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; RV32-ILP32D-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; RV32-ILP32D-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; RV32-ILP32D-NEXT:   [[C4:%[0-9]+]]:_(s32) = G_CONSTANT i32 5
  ; RV32-ILP32D-NEXT:   [[C5:%[0-9]+]]:_(s32) = G_FCONSTANT float 6.000000e+00
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKDOWN 4, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C]](s64)
  ; RV32-ILP32D-NEXT:   [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C1]](s64)
  ; RV32-ILP32D-NEXT:   [[UV4:%[0-9]+]]:_(s32), [[UV5:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C2]](s64)
  ; RV32-ILP32D-NEXT:   [[UV6:%[0-9]+]]:_(s32), [[UV7:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C3]](s64)
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x2
  ; RV32-ILP32D-NEXT:   [[C6:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; RV32-ILP32D-NEXT:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C6]](s32)
  ; RV32-ILP32D-NEXT:   G_STORE [[C4]](s32), [[PTR_ADD]](p0) :: (store (s32) into stack, align 16)
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[UV]](s32)
  ; RV32-ILP32D-NEXT:   $x11 = COPY [[UV1]](s32)
  ; RV32-ILP32D-NEXT:   $x12 = COPY [[UV2]](s32)
  ; RV32-ILP32D-NEXT:   $x13 = COPY [[UV3]](s32)
  ; RV32-ILP32D-NEXT:   $x14 = COPY [[UV4]](s32)
  ; RV32-ILP32D-NEXT:   $x15 = COPY [[UV5]](s32)
  ; RV32-ILP32D-NEXT:   $x16 = COPY [[UV6]](s32)
  ; RV32-ILP32D-NEXT:   $x17 = COPY [[UV7]](s32)
  ; RV32-ILP32D-NEXT:   $f10_f = COPY [[C5]](s32)
  ; RV32-ILP32D-NEXT:   PseudoCALL target-flags(riscv-call) @callee_float_in_fpr_exhausted_gprs, csr_ilp32d_lp64d, implicit-def $x1, implicit $x10, implicit $x11, implicit $x12, implicit $x13, implicit $x14, implicit $x15, implicit $x16, implicit $x17, implicit $f10_f, implicit-def $x10
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKUP 4, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[COPY1]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %1 = call i32 @callee_float_in_fpr_exhausted_gprs(
      i64 1, i64 2, i64 3, i64 4, i32 5, float 6.0)
  ret i32 %1
}

; Must keep define on a single line due to an update_llc_test_checks.py limitation
define i32 @callee_float_in_gpr_exhausted_fprs(float %a, float %b, float %c, float %d, float %e, float %f, float %g, float %h, float %i) nounwind {
  ; RV32-ILP32FD-LABEL: name: callee_float_in_gpr_exhausted_fprs
  ; RV32-ILP32FD: bb.1 (%ir-block.0):
  ; RV32-ILP32FD-NEXT:   liveins: $x10, $f10_f, $f11_f, $f12_f, $f13_f, $f14_f, $f15_f, $f16_f, $f17_f
  ; RV32-ILP32FD-NEXT: {{  $}}
  ; RV32-ILP32FD-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $f10_f
  ; RV32-ILP32FD-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $f11_f
  ; RV32-ILP32FD-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $f12_f
  ; RV32-ILP32FD-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $f13_f
  ; RV32-ILP32FD-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $f14_f
  ; RV32-ILP32FD-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $f15_f
  ; RV32-ILP32FD-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $f16_f
  ; RV32-ILP32FD-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $f17_f
  ; RV32-ILP32FD-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32FD-NEXT:   [[FPTOSI:%[0-9]+]]:_(s32) = G_FPTOSI [[COPY7]](s32)
  ; RV32-ILP32FD-NEXT:   [[FPTOSI1:%[0-9]+]]:_(s32) = G_FPTOSI [[COPY8]](s32)
  ; RV32-ILP32FD-NEXT:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[FPTOSI]], [[FPTOSI1]]
  ; RV32-ILP32FD-NEXT:   $x10 = COPY [[ADD]](s32)
  ; RV32-ILP32FD-NEXT:   PseudoRET implicit $x10
  %h_fptosi = fptosi float %h to i32
  %i_fptosi = fptosi float %i to i32
  %1 = add i32 %h_fptosi, %i_fptosi
  ret i32 %1
}

define i32 @caller_float_in_gpr_exhausted_fprs() nounwind {
  ; RV32-ILP32F-LABEL: name: caller_float_in_gpr_exhausted_fprs
  ; RV32-ILP32F: bb.1 (%ir-block.0):
  ; RV32-ILP32F-NEXT:   [[C:%[0-9]+]]:_(s32) = G_FCONSTANT float 1.000000e+00
  ; RV32-ILP32F-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_FCONSTANT float 2.000000e+00
  ; RV32-ILP32F-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_FCONSTANT float 3.000000e+00
  ; RV32-ILP32F-NEXT:   [[C3:%[0-9]+]]:_(s32) = G_FCONSTANT float 4.000000e+00
  ; RV32-ILP32F-NEXT:   [[C4:%[0-9]+]]:_(s32) = G_FCONSTANT float 5.000000e+00
  ; RV32-ILP32F-NEXT:   [[C5:%[0-9]+]]:_(s32) = G_FCONSTANT float 6.000000e+00
  ; RV32-ILP32F-NEXT:   [[C6:%[0-9]+]]:_(s32) = G_FCONSTANT float 7.000000e+00
  ; RV32-ILP32F-NEXT:   [[C7:%[0-9]+]]:_(s32) = G_FCONSTANT float 8.000000e+00
  ; RV32-ILP32F-NEXT:   [[C8:%[0-9]+]]:_(s32) = G_FCONSTANT float 9.000000e+00
  ; RV32-ILP32F-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32F-NEXT:   $f10_f = COPY [[C]](s32)
  ; RV32-ILP32F-NEXT:   $f11_f = COPY [[C1]](s32)
  ; RV32-ILP32F-NEXT:   $f12_f = COPY [[C2]](s32)
  ; RV32-ILP32F-NEXT:   $f13_f = COPY [[C3]](s32)
  ; RV32-ILP32F-NEXT:   $f14_f = COPY [[C4]](s32)
  ; RV32-ILP32F-NEXT:   $f15_f = COPY [[C5]](s32)
  ; RV32-ILP32F-NEXT:   $f16_f = COPY [[C6]](s32)
  ; RV32-ILP32F-NEXT:   $f17_f = COPY [[C7]](s32)
  ; RV32-ILP32F-NEXT:   $x10 = COPY [[C8]](s32)
  ; RV32-ILP32F-NEXT:   PseudoCALL target-flags(riscv-call) @callee_float_in_gpr_exhausted_fprs, csr_ilp32f_lp64f, implicit-def $x1, implicit $f10_f, implicit $f11_f, implicit $f12_f, implicit $f13_f, implicit $f14_f, implicit $f15_f, implicit $f16_f, implicit $f17_f, implicit $x10, implicit-def $x10
  ; RV32-ILP32F-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32F-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32F-NEXT:   $x10 = COPY [[COPY]](s32)
  ; RV32-ILP32F-NEXT:   PseudoRET implicit $x10
  ;
  ; RV32-ILP32D-LABEL: name: caller_float_in_gpr_exhausted_fprs
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   [[C:%[0-9]+]]:_(s32) = G_FCONSTANT float 1.000000e+00
  ; RV32-ILP32D-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_FCONSTANT float 2.000000e+00
  ; RV32-ILP32D-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_FCONSTANT float 3.000000e+00
  ; RV32-ILP32D-NEXT:   [[C3:%[0-9]+]]:_(s32) = G_FCONSTANT float 4.000000e+00
  ; RV32-ILP32D-NEXT:   [[C4:%[0-9]+]]:_(s32) = G_FCONSTANT float 5.000000e+00
  ; RV32-ILP32D-NEXT:   [[C5:%[0-9]+]]:_(s32) = G_FCONSTANT float 6.000000e+00
  ; RV32-ILP32D-NEXT:   [[C6:%[0-9]+]]:_(s32) = G_FCONSTANT float 7.000000e+00
  ; RV32-ILP32D-NEXT:   [[C7:%[0-9]+]]:_(s32) = G_FCONSTANT float 8.000000e+00
  ; RV32-ILP32D-NEXT:   [[C8:%[0-9]+]]:_(s32) = G_FCONSTANT float 9.000000e+00
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   $f10_f = COPY [[C]](s32)
  ; RV32-ILP32D-NEXT:   $f11_f = COPY [[C1]](s32)
  ; RV32-ILP32D-NEXT:   $f12_f = COPY [[C2]](s32)
  ; RV32-ILP32D-NEXT:   $f13_f = COPY [[C3]](s32)
  ; RV32-ILP32D-NEXT:   $f14_f = COPY [[C4]](s32)
  ; RV32-ILP32D-NEXT:   $f15_f = COPY [[C5]](s32)
  ; RV32-ILP32D-NEXT:   $f16_f = COPY [[C6]](s32)
  ; RV32-ILP32D-NEXT:   $f17_f = COPY [[C7]](s32)
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[C8]](s32)
  ; RV32-ILP32D-NEXT:   PseudoCALL target-flags(riscv-call) @callee_float_in_gpr_exhausted_fprs, csr_ilp32d_lp64d, implicit-def $x1, implicit $f10_f, implicit $f11_f, implicit $f12_f, implicit $f13_f, implicit $f14_f, implicit $f15_f, implicit $f16_f, implicit $f17_f, implicit $x10, implicit-def $x10
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[COPY]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %1 = call i32 @callee_float_in_gpr_exhausted_fprs(
      float 1.0, float 2.0, float 3.0, float 4.0, float 5.0, float 6.0,
      float 7.0, float 8.0, float 9.0)
  ret i32 %1
}

; Must keep define on a single line due to an update_llc_test_checks.py limitation
define i32 @callee_float_on_stack_exhausted_gprs_fprs(i64 %a, float %b, i64 %c, float %d, i64 %e, float %f, i64 %g, float %h, float %i, float %j, float %k, float %l, float %m) nounwind {
  ; RV32-ILP32FD-LABEL: name: callee_float_on_stack_exhausted_gprs_fprs
  ; RV32-ILP32FD: bb.1 (%ir-block.0):
  ; RV32-ILP32FD-NEXT:   liveins: $x10, $x11, $x12, $x13, $x14, $x15, $x16, $x17, $f10_f, $f11_f, $f12_f, $f13_f, $f14_f, $f15_f, $f16_f, $f17_f
  ; RV32-ILP32FD-NEXT: {{  $}}
  ; RV32-ILP32FD-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32FD-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x11
  ; RV32-ILP32FD-NEXT:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; RV32-ILP32FD-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $f10_f
  ; RV32-ILP32FD-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $x12
  ; RV32-ILP32FD-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $x13
  ; RV32-ILP32FD-NEXT:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY3]](s32), [[COPY4]](s32)
  ; RV32-ILP32FD-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $f11_f
  ; RV32-ILP32FD-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $x14
  ; RV32-ILP32FD-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $x15
  ; RV32-ILP32FD-NEXT:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY6]](s32), [[COPY7]](s32)
  ; RV32-ILP32FD-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $f12_f
  ; RV32-ILP32FD-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $x16
  ; RV32-ILP32FD-NEXT:   [[COPY10:%[0-9]+]]:_(s32) = COPY $x17
  ; RV32-ILP32FD-NEXT:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY9]](s32), [[COPY10]](s32)
  ; RV32-ILP32FD-NEXT:   [[COPY11:%[0-9]+]]:_(s32) = COPY $f13_f
  ; RV32-ILP32FD-NEXT:   [[COPY12:%[0-9]+]]:_(s32) = COPY $f14_f
  ; RV32-ILP32FD-NEXT:   [[COPY13:%[0-9]+]]:_(s32) = COPY $f15_f
  ; RV32-ILP32FD-NEXT:   [[COPY14:%[0-9]+]]:_(s32) = COPY $f16_f
  ; RV32-ILP32FD-NEXT:   [[COPY15:%[0-9]+]]:_(s32) = COPY $f17_f
  ; RV32-ILP32FD-NEXT:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; RV32-ILP32FD-NEXT:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p0) :: (load (s32) from %fixed-stack.0, align 16)
  ; RV32-ILP32FD-NEXT:   [[TRUNC:%[0-9]+]]:_(s32) = G_TRUNC [[MV3]](s64)
  ; RV32-ILP32FD-NEXT:   [[FPTOSI:%[0-9]+]]:_(s32) = G_FPTOSI [[LOAD]](s32)
  ; RV32-ILP32FD-NEXT:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[TRUNC]], [[FPTOSI]]
  ; RV32-ILP32FD-NEXT:   $x10 = COPY [[ADD]](s32)
  ; RV32-ILP32FD-NEXT:   PseudoRET implicit $x10
  %g_trunc = trunc i64 %g to i32
  %m_fptosi = fptosi float %m to i32
  %1 = add i32 %g_trunc, %m_fptosi
  ret i32 %1
}

define i32 @caller_float_on_stack_exhausted_gprs_fprs() nounwind {
  ; RV32-ILP32F-LABEL: name: caller_float_on_stack_exhausted_gprs_fprs
  ; RV32-ILP32F: bb.1 (%ir-block.0):
  ; RV32-ILP32F-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; RV32-ILP32F-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_FCONSTANT float 2.000000e+00
  ; RV32-ILP32F-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; RV32-ILP32F-NEXT:   [[C3:%[0-9]+]]:_(s32) = G_FCONSTANT float 4.000000e+00
  ; RV32-ILP32F-NEXT:   [[C4:%[0-9]+]]:_(s64) = G_CONSTANT i64 5
  ; RV32-ILP32F-NEXT:   [[C5:%[0-9]+]]:_(s32) = G_FCONSTANT float 6.000000e+00
  ; RV32-ILP32F-NEXT:   [[C6:%[0-9]+]]:_(s64) = G_CONSTANT i64 7
  ; RV32-ILP32F-NEXT:   [[C7:%[0-9]+]]:_(s32) = G_FCONSTANT float 8.000000e+00
  ; RV32-ILP32F-NEXT:   [[C8:%[0-9]+]]:_(s32) = G_FCONSTANT float 9.000000e+00
  ; RV32-ILP32F-NEXT:   [[C9:%[0-9]+]]:_(s32) = G_FCONSTANT float 1.000000e+01
  ; RV32-ILP32F-NEXT:   [[C10:%[0-9]+]]:_(s32) = G_FCONSTANT float 1.100000e+01
  ; RV32-ILP32F-NEXT:   [[C11:%[0-9]+]]:_(s32) = G_FCONSTANT float 1.200000e+01
  ; RV32-ILP32F-NEXT:   [[C12:%[0-9]+]]:_(s32) = G_FCONSTANT float 1.300000e+01
  ; RV32-ILP32F-NEXT:   ADJCALLSTACKDOWN 4, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32F-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C]](s64)
  ; RV32-ILP32F-NEXT:   [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C2]](s64)
  ; RV32-ILP32F-NEXT:   [[UV4:%[0-9]+]]:_(s32), [[UV5:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C4]](s64)
  ; RV32-ILP32F-NEXT:   [[UV6:%[0-9]+]]:_(s32), [[UV7:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C6]](s64)
  ; RV32-ILP32F-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x2
  ; RV32-ILP32F-NEXT:   [[C13:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; RV32-ILP32F-NEXT:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C13]](s32)
  ; RV32-ILP32F-NEXT:   G_STORE [[C12]](s32), [[PTR_ADD]](p0) :: (store (s32) into stack, align 16)
  ; RV32-ILP32F-NEXT:   $x10 = COPY [[UV]](s32)
  ; RV32-ILP32F-NEXT:   $x11 = COPY [[UV1]](s32)
  ; RV32-ILP32F-NEXT:   $f10_f = COPY [[C1]](s32)
  ; RV32-ILP32F-NEXT:   $x12 = COPY [[UV2]](s32)
  ; RV32-ILP32F-NEXT:   $x13 = COPY [[UV3]](s32)
  ; RV32-ILP32F-NEXT:   $f11_f = COPY [[C3]](s32)
  ; RV32-ILP32F-NEXT:   $x14 = COPY [[UV4]](s32)
  ; RV32-ILP32F-NEXT:   $x15 = COPY [[UV5]](s32)
  ; RV32-ILP32F-NEXT:   $f12_f = COPY [[C5]](s32)
  ; RV32-ILP32F-NEXT:   $x16 = COPY [[UV6]](s32)
  ; RV32-ILP32F-NEXT:   $x17 = COPY [[UV7]](s32)
  ; RV32-ILP32F-NEXT:   $f13_f = COPY [[C7]](s32)
  ; RV32-ILP32F-NEXT:   $f14_f = COPY [[C8]](s32)
  ; RV32-ILP32F-NEXT:   $f15_f = COPY [[C9]](s32)
  ; RV32-ILP32F-NEXT:   $f16_f = COPY [[C10]](s32)
  ; RV32-ILP32F-NEXT:   $f17_f = COPY [[C11]](s32)
  ; RV32-ILP32F-NEXT:   PseudoCALL target-flags(riscv-call) @callee_float_on_stack_exhausted_gprs_fprs, csr_ilp32f_lp64f, implicit-def $x1, implicit $x10, implicit $x11, implicit $f10_f, implicit $x12, implicit $x13, implicit $f11_f, implicit $x14, implicit $x15, implicit $f12_f, implicit $x16, implicit $x17, implicit $f13_f, implicit $f14_f, implicit $f15_f, implicit $f16_f, implicit $f17_f, implicit-def $x10
  ; RV32-ILP32F-NEXT:   ADJCALLSTACKUP 4, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32F-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32F-NEXT:   $x10 = COPY [[COPY1]](s32)
  ; RV32-ILP32F-NEXT:   PseudoRET implicit $x10
  ;
  ; RV32-ILP32D-LABEL: name: caller_float_on_stack_exhausted_gprs_fprs
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; RV32-ILP32D-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_FCONSTANT float 2.000000e+00
  ; RV32-ILP32D-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; RV32-ILP32D-NEXT:   [[C3:%[0-9]+]]:_(s32) = G_FCONSTANT float 4.000000e+00
  ; RV32-ILP32D-NEXT:   [[C4:%[0-9]+]]:_(s64) = G_CONSTANT i64 5
  ; RV32-ILP32D-NEXT:   [[C5:%[0-9]+]]:_(s32) = G_FCONSTANT float 6.000000e+00
  ; RV32-ILP32D-NEXT:   [[C6:%[0-9]+]]:_(s64) = G_CONSTANT i64 7
  ; RV32-ILP32D-NEXT:   [[C7:%[0-9]+]]:_(s32) = G_FCONSTANT float 8.000000e+00
  ; RV32-ILP32D-NEXT:   [[C8:%[0-9]+]]:_(s32) = G_FCONSTANT float 9.000000e+00
  ; RV32-ILP32D-NEXT:   [[C9:%[0-9]+]]:_(s32) = G_FCONSTANT float 1.000000e+01
  ; RV32-ILP32D-NEXT:   [[C10:%[0-9]+]]:_(s32) = G_FCONSTANT float 1.100000e+01
  ; RV32-ILP32D-NEXT:   [[C11:%[0-9]+]]:_(s32) = G_FCONSTANT float 1.200000e+01
  ; RV32-ILP32D-NEXT:   [[C12:%[0-9]+]]:_(s32) = G_FCONSTANT float 1.300000e+01
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKDOWN 4, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C]](s64)
  ; RV32-ILP32D-NEXT:   [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C2]](s64)
  ; RV32-ILP32D-NEXT:   [[UV4:%[0-9]+]]:_(s32), [[UV5:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C4]](s64)
  ; RV32-ILP32D-NEXT:   [[UV6:%[0-9]+]]:_(s32), [[UV7:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C6]](s64)
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x2
  ; RV32-ILP32D-NEXT:   [[C13:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; RV32-ILP32D-NEXT:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C13]](s32)
  ; RV32-ILP32D-NEXT:   G_STORE [[C12]](s32), [[PTR_ADD]](p0) :: (store (s32) into stack, align 16)
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[UV]](s32)
  ; RV32-ILP32D-NEXT:   $x11 = COPY [[UV1]](s32)
  ; RV32-ILP32D-NEXT:   $f10_f = COPY [[C1]](s32)
  ; RV32-ILP32D-NEXT:   $x12 = COPY [[UV2]](s32)
  ; RV32-ILP32D-NEXT:   $x13 = COPY [[UV3]](s32)
  ; RV32-ILP32D-NEXT:   $f11_f = COPY [[C3]](s32)
  ; RV32-ILP32D-NEXT:   $x14 = COPY [[UV4]](s32)
  ; RV32-ILP32D-NEXT:   $x15 = COPY [[UV5]](s32)
  ; RV32-ILP32D-NEXT:   $f12_f = COPY [[C5]](s32)
  ; RV32-ILP32D-NEXT:   $x16 = COPY [[UV6]](s32)
  ; RV32-ILP32D-NEXT:   $x17 = COPY [[UV7]](s32)
  ; RV32-ILP32D-NEXT:   $f13_f = COPY [[C7]](s32)
  ; RV32-ILP32D-NEXT:   $f14_f = COPY [[C8]](s32)
  ; RV32-ILP32D-NEXT:   $f15_f = COPY [[C9]](s32)
  ; RV32-ILP32D-NEXT:   $f16_f = COPY [[C10]](s32)
  ; RV32-ILP32D-NEXT:   $f17_f = COPY [[C11]](s32)
  ; RV32-ILP32D-NEXT:   PseudoCALL target-flags(riscv-call) @callee_float_on_stack_exhausted_gprs_fprs, csr_ilp32d_lp64d, implicit-def $x1, implicit $x10, implicit $x11, implicit $f10_f, implicit $x12, implicit $x13, implicit $f11_f, implicit $x14, implicit $x15, implicit $f12_f, implicit $x16, implicit $x17, implicit $f13_f, implicit $f14_f, implicit $f15_f, implicit $f16_f, implicit $f17_f, implicit-def $x10
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKUP 4, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[COPY1]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %1 = call i32 @callee_float_on_stack_exhausted_gprs_fprs(
      i64 1, float 2.0, i64 3, float 4.0, i64 5, float 6.0, i64 7, float 8.0,
      float 9.0, float 10.0, float 11.0, float 12.0, float 13.0)
  ret i32 %1
}

define float @callee_float_ret() nounwind {
  ; RV32-ILP32FD-LABEL: name: callee_float_ret
  ; RV32-ILP32FD: bb.1 (%ir-block.0):
  ; RV32-ILP32FD-NEXT:   [[C:%[0-9]+]]:_(s32) = G_FCONSTANT float 1.000000e+00
  ; RV32-ILP32FD-NEXT:   $f10_f = COPY [[C]](s32)
  ; RV32-ILP32FD-NEXT:   PseudoRET implicit $f10_f
  ret float 1.0
}

define i32 @caller_float_ret() nounwind {
  ; RV32-ILP32F-LABEL: name: caller_float_ret
  ; RV32-ILP32F: bb.1 (%ir-block.0):
  ; RV32-ILP32F-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32F-NEXT:   PseudoCALL target-flags(riscv-call) @callee_float_ret, csr_ilp32f_lp64f, implicit-def $x1, implicit-def $f10_f
  ; RV32-ILP32F-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32F-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $f10_f
  ; RV32-ILP32F-NEXT:   $x10 = COPY [[COPY]](s32)
  ; RV32-ILP32F-NEXT:   PseudoRET implicit $x10
  ;
  ; RV32-ILP32D-LABEL: name: caller_float_ret
  ; RV32-ILP32D: bb.1 (%ir-block.0):
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   PseudoCALL target-flags(riscv-call) @callee_float_ret, csr_ilp32d_lp64d, implicit-def $x1, implicit-def $f10_f
  ; RV32-ILP32D-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $x2, implicit $x2
  ; RV32-ILP32D-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $f10_f
  ; RV32-ILP32D-NEXT:   $x10 = COPY [[COPY]](s32)
  ; RV32-ILP32D-NEXT:   PseudoRET implicit $x10
  %1 = call float @callee_float_ret()
  %2 = bitcast float %1 to i32
  ret i32 %2
}
