; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"

declare void @use(i16)

define void @test_loop_add_rec_used_in_adjacent_loop(i8 %len.n, i16 %a) {
; CHECK-LABEL: @test_loop_add_rec_used_in_adjacent_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LEN:%.*]] = zext i8 [[LEN_N:%.*]] to i16
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp uge i16 [[LEN]], [[A:%.*]]
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_1_PH:%.*]]
; CHECK:       loop.1.ph:
; CHECK-NEXT:    br label [[LOOP_1:%.*]]
; CHECK:       loop.1:
; CHECK-NEXT:    [[IV:%.*]] = phi i16 [ 0, [[LOOP_1_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP_1]] ]
; CHECK-NEXT:    [[C_0:%.*]] = icmp eq i16 [[IV]], [[A]]
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i16 [[IV]], 1
; CHECK-NEXT:    br i1 [[C_0]], label [[LOOP_2_HEADER:%.*]], label [[LOOP_1]]
; CHECK:       loop.2.header:
; CHECK-NEXT:    [[IV_2:%.*]] = phi i16 [ [[IV]], [[LOOP_1]] ], [ [[IV]], [[LOOP_2_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i16 [[IV_2]], [[LEN]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult i16 [[IV_2]], [[A]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 true, [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_2_LATCH]], label [[EXIT]]
; CHECK:       loop.2.latch:
; CHECK-NEXT:    call void @use(i16 [[IV_2]])
; CHECK-NEXT:    br label [[LOOP_2_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %len = zext i8 %len.n to i16
  %len.neg = icmp uge i16 %len, %a
  br i1 %len.neg, label %exit, label %loop.1.ph

loop.1.ph:
  br label %loop.1

loop.1:
  %iv = phi i16 [ 0, %loop.1.ph ], [ %iv.next, %loop.1 ]
  %c.0 = icmp eq i16 %iv, %a
  %iv.next = add nuw nsw i16 %iv, 1
  br i1 %c.0, label %loop.2.header, label %loop.1

loop.2.header:
  %iv.2 = phi i16 [ %iv, %loop.1 ], [ %iv, %loop.2.latch ]
  %c = icmp eq i16 %iv.2, %len
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge i16 %iv.2, 0
  %t.2 = icmp ult i16 %iv.2, %a
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.2.latch, label %exit

loop.2.latch:
  call void @use(i16 %iv.2)
  br label %loop.2.header

exit:
  ret void
}

define void @test_adjacen_loops_pointer_iv_crash() {
; CHECK-LABEL: @test_adjacen_loops_pointer_iv_crash(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_1:%.*]]
; CHECK:       loop.1:
; CHECK-NEXT:    [[IV_1:%.*]] = phi ptr [ null, [[ENTRY:%.*]] ], [ [[IV_1_NEXT:%.*]], [[LOOP_1]] ]
; CHECK-NEXT:    [[IV_1_NEXT]] = getelementptr ptr, ptr [[IV_1]], i32 1
; CHECK-NEXT:    br i1 false, label [[LOOP_1]], label [[LOOP_2:%.*]]
; CHECK:       loop.2:
; CHECK-NEXT:    [[__FIRST_ADDR_1_LCSSA:%.*]] = phi ptr [ [[IV_1]], [[LOOP_1]] ], [ [[IV_1]], [[LOOP_2_LATCH:%.*]] ]
; CHECK-NEXT:    [[CMP7:%.*]] = icmp eq ptr [[__FIRST_ADDR_1_LCSSA]], null
; CHECK-NEXT:    br i1 [[CMP7]], label [[IF_THEN8:%.*]], label [[LOOP_2_LATCH]]
; CHECK:       if.then8:
; CHECK-NEXT:    ret void
; CHECK:       loop.2.latch:
; CHECK-NEXT:    br label [[LOOP_2]]
;
entry:
  br label %loop.1

loop.1:
  %iv.1 = phi ptr [ null, %entry ], [ %iv.1.next, %loop.1 ]
  %iv.1.next = getelementptr ptr, ptr %iv.1, i32 1
  br i1 false, label %loop.1, label %loop.2

loop.2:
  %__first.addr.1.lcssa = phi ptr [ %iv.1, %loop.1 ], [ %iv.1, %loop.2.latch ]
  %cmp7 = icmp eq ptr %__first.addr.1.lcssa, null
  br i1 %cmp7, label %if.then8, label %loop.2.latch

if.then8:                                         ; preds = %do.body
  ret void

loop.2.latch:
  br label %loop.2
}

