; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=tonga -verify-machineinstrs < %s | FileCheck -check-prefixes=PREGFX10-UNPACKED %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx810 -verify-machineinstrs < %s | FileCheck -check-prefixes=PREGFX10-PACKED %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=PREGFX10-PACKED %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-PACKED %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 -amdgpu-enable-vopd=0 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11-PACKED %s

define amdgpu_kernel void @tbuffer_store_d16_x(ptr addrspace(8) %rsrc, half %data, i32 %vindex) {
; PREGFX10-UNPACKED-LABEL: tbuffer_store_d16_x:
; PREGFX10-UNPACKED:       ; %bb.0: ; %main_body
; PREGFX10-UNPACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; PREGFX10-UNPACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; PREGFX10-UNPACKED-NEXT:    s_waitcnt lgkmcnt(0)
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v0, s4
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v1, s5
; PREGFX10-UNPACKED-NEXT:    tbuffer_store_format_d16_x v0, v1, s[0:3], 0 format:[BUF_NUM_FORMAT_USCALED] idxen
; PREGFX10-UNPACKED-NEXT:    s_endpgm
;
; PREGFX10-PACKED-LABEL: tbuffer_store_d16_x:
; PREGFX10-PACKED:       ; %bb.0: ; %main_body
; PREGFX10-PACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; PREGFX10-PACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; PREGFX10-PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; PREGFX10-PACKED-NEXT:    v_mov_b32_e32 v0, s4
; PREGFX10-PACKED-NEXT:    v_mov_b32_e32 v1, s5
; PREGFX10-PACKED-NEXT:    tbuffer_store_format_d16_x v0, v1, s[0:3], 0 format:[BUF_NUM_FORMAT_USCALED] idxen
; PREGFX10-PACKED-NEXT:    s_endpgm
;
; GFX10-PACKED-LABEL: tbuffer_store_d16_x:
; GFX10-PACKED:       ; %bb.0: ; %main_body
; GFX10-PACKED-NEXT:    s_clause 0x1
; GFX10-PACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GFX10-PACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX10-PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PACKED-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-PACKED-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-PACKED-NEXT:    tbuffer_store_format_d16_x v0, v1, s[0:3], 0 format:[BUF_FMT_10_11_11_SSCALED] idxen
; GFX10-PACKED-NEXT:    s_endpgm
;
; GFX11-PACKED-LABEL: tbuffer_store_d16_x:
; GFX11-PACKED:       ; %bb.0: ; %main_body
; GFX11-PACKED-NEXT:    s_clause 0x1
; GFX11-PACKED-NEXT:    s_load_b64 s[6:7], s[4:5], 0x10
; GFX11-PACKED-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-PACKED-NEXT:    v_mov_b32_e32 v0, s6
; GFX11-PACKED-NEXT:    v_mov_b32_e32 v1, s7
; GFX11-PACKED-NEXT:    tbuffer_store_d16_format_x v0, v1, s[0:3], 0 format:[BUF_FMT_10_10_10_2_SNORM] idxen
; GFX11-PACKED-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.ptr.tbuffer.store.f16(half %data, ptr addrspace(8) %rsrc, i32 %vindex, i32 0, i32 0, i32 33, i32 0)
  ret void
}

define amdgpu_kernel void @tbuffer_store_d16_xy(ptr addrspace(8) %rsrc, <2 x half> %data, i32 %vindex) {
; PREGFX10-UNPACKED-LABEL: tbuffer_store_d16_xy:
; PREGFX10-UNPACKED:       ; %bb.0: ; %main_body
; PREGFX10-UNPACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; PREGFX10-UNPACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; PREGFX10-UNPACKED-NEXT:    s_waitcnt lgkmcnt(0)
; PREGFX10-UNPACKED-NEXT:    s_lshr_b32 s6, s4, 16
; PREGFX10-UNPACKED-NEXT:    s_and_b32 s4, s4, 0xffff
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v0, s4
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v1, s6
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v2, s5
; PREGFX10-UNPACKED-NEXT:    tbuffer_store_format_d16_xy v[0:1], v2, s[0:3], 0 format:[BUF_NUM_FORMAT_USCALED] idxen
; PREGFX10-UNPACKED-NEXT:    s_endpgm
;
; PREGFX10-PACKED-LABEL: tbuffer_store_d16_xy:
; PREGFX10-PACKED:       ; %bb.0: ; %main_body
; PREGFX10-PACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; PREGFX10-PACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; PREGFX10-PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; PREGFX10-PACKED-NEXT:    v_mov_b32_e32 v0, s4
; PREGFX10-PACKED-NEXT:    v_mov_b32_e32 v1, s5
; PREGFX10-PACKED-NEXT:    tbuffer_store_format_d16_xy v0, v1, s[0:3], 0 format:[BUF_NUM_FORMAT_USCALED] idxen
; PREGFX10-PACKED-NEXT:    s_endpgm
;
; GFX10-PACKED-LABEL: tbuffer_store_d16_xy:
; GFX10-PACKED:       ; %bb.0: ; %main_body
; GFX10-PACKED-NEXT:    s_clause 0x1
; GFX10-PACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GFX10-PACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX10-PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PACKED-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-PACKED-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-PACKED-NEXT:    tbuffer_store_format_d16_xy v0, v1, s[0:3], 0 format:[BUF_FMT_10_11_11_SSCALED] idxen
; GFX10-PACKED-NEXT:    s_endpgm
;
; GFX11-PACKED-LABEL: tbuffer_store_d16_xy:
; GFX11-PACKED:       ; %bb.0: ; %main_body
; GFX11-PACKED-NEXT:    s_clause 0x1
; GFX11-PACKED-NEXT:    s_load_b64 s[6:7], s[4:5], 0x10
; GFX11-PACKED-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-PACKED-NEXT:    v_mov_b32_e32 v0, s6
; GFX11-PACKED-NEXT:    v_mov_b32_e32 v1, s7
; GFX11-PACKED-NEXT:    tbuffer_store_d16_format_xy v0, v1, s[0:3], 0 format:[BUF_FMT_10_10_10_2_SNORM] idxen
; GFX11-PACKED-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.ptr.tbuffer.store.v2f16(<2 x half> %data, ptr addrspace(8) %rsrc, i32 %vindex, i32 0, i32 0, i32 33, i32 0)
  ret void
}

define amdgpu_kernel void @tbuffer_store_d16_xyz(ptr addrspace(8) %rsrc, <4 x half> %data, i32 %vindex) {
; PREGFX10-UNPACKED-LABEL: tbuffer_store_d16_xyz:
; PREGFX10-UNPACKED:       ; %bb.0: ; %main_body
; PREGFX10-UNPACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; PREGFX10-UNPACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; PREGFX10-UNPACKED-NEXT:    s_load_dword s6, s[8:9], 0x18
; PREGFX10-UNPACKED-NEXT:    s_waitcnt lgkmcnt(0)
; PREGFX10-UNPACKED-NEXT:    s_and_b32 s5, s5, 0xffff
; PREGFX10-UNPACKED-NEXT:    s_lshr_b32 s7, s4, 16
; PREGFX10-UNPACKED-NEXT:    s_and_b32 s4, s4, 0xffff
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v0, s4
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v1, s7
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v2, s5
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v3, s6
; PREGFX10-UNPACKED-NEXT:    tbuffer_store_format_d16_xyz v[0:2], v3, s[0:3], 0 format:[BUF_NUM_FORMAT_USCALED] idxen
; PREGFX10-UNPACKED-NEXT:    s_endpgm
;
; PREGFX10-PACKED-LABEL: tbuffer_store_d16_xyz:
; PREGFX10-PACKED:       ; %bb.0: ; %main_body
; PREGFX10-PACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; PREGFX10-PACKED-NEXT:    s_load_dword s6, s[8:9], 0x18
; PREGFX10-PACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; PREGFX10-PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; PREGFX10-PACKED-NEXT:    s_and_b32 s5, s5, 0xffff
; PREGFX10-PACKED-NEXT:    v_mov_b32_e32 v0, s4
; PREGFX10-PACKED-NEXT:    v_mov_b32_e32 v1, s5
; PREGFX10-PACKED-NEXT:    v_mov_b32_e32 v2, s6
; PREGFX10-PACKED-NEXT:    tbuffer_store_format_d16_xyz v[0:1], v2, s[0:3], 0 format:[BUF_NUM_FORMAT_USCALED] idxen
; PREGFX10-PACKED-NEXT:    s_endpgm
;
; GFX10-PACKED-LABEL: tbuffer_store_d16_xyz:
; GFX10-PACKED:       ; %bb.0: ; %main_body
; GFX10-PACKED-NEXT:    s_clause 0x2
; GFX10-PACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GFX10-PACKED-NEXT:    s_load_dword s6, s[8:9], 0x18
; GFX10-PACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX10-PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PACKED-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX10-PACKED-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-PACKED-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-PACKED-NEXT:    v_mov_b32_e32 v2, s6
; GFX10-PACKED-NEXT:    tbuffer_store_format_d16_xyz v[0:1], v2, s[0:3], 0 format:[BUF_FMT_10_11_11_SSCALED] idxen
; GFX10-PACKED-NEXT:    s_endpgm
;
; GFX11-PACKED-LABEL: tbuffer_store_d16_xyz:
; GFX11-PACKED:       ; %bb.0: ; %main_body
; GFX11-PACKED-NEXT:    s_clause 0x2
; GFX11-PACKED-NEXT:    s_load_b64 s[6:7], s[4:5], 0x10
; GFX11-PACKED-NEXT:    s_load_b32 s8, s[4:5], 0x18
; GFX11-PACKED-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-PACKED-NEXT:    s_and_b32 s4, s7, 0xffff
; GFX11-PACKED-NEXT:    v_mov_b32_e32 v0, s6
; GFX11-PACKED-NEXT:    v_mov_b32_e32 v1, s4
; GFX11-PACKED-NEXT:    v_mov_b32_e32 v2, s8
; GFX11-PACKED-NEXT:    tbuffer_store_d16_format_xyz v[0:1], v2, s[0:3], 0 format:[BUF_FMT_10_10_10_2_SNORM] idxen
; GFX11-PACKED-NEXT:    s_endpgm
main_body:
  %data_subvec = shufflevector <4 x half> %data, <4 x half> undef, <3 x i32> <i32 0, i32 1, i32 2>
  call void @llvm.amdgcn.struct.ptr.tbuffer.store.v3f16(<3 x half> %data_subvec, ptr addrspace(8) %rsrc, i32 %vindex, i32 0, i32 0, i32 33, i32 0)
  ret void
}

define amdgpu_kernel void @tbuffer_store_d16_xyzw(ptr addrspace(8) %rsrc, <4 x half> %data, i32 %vindex) {
; PREGFX10-UNPACKED-LABEL: tbuffer_store_d16_xyzw:
; PREGFX10-UNPACKED:       ; %bb.0: ; %main_body
; PREGFX10-UNPACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; PREGFX10-UNPACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; PREGFX10-UNPACKED-NEXT:    s_load_dword s6, s[8:9], 0x18
; PREGFX10-UNPACKED-NEXT:    s_waitcnt lgkmcnt(0)
; PREGFX10-UNPACKED-NEXT:    s_lshr_b32 s7, s5, 16
; PREGFX10-UNPACKED-NEXT:    s_and_b32 s5, s5, 0xffff
; PREGFX10-UNPACKED-NEXT:    s_lshr_b32 s8, s4, 16
; PREGFX10-UNPACKED-NEXT:    s_and_b32 s4, s4, 0xffff
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v0, s4
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v1, s8
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v2, s5
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v3, s7
; PREGFX10-UNPACKED-NEXT:    v_mov_b32_e32 v4, s6
; PREGFX10-UNPACKED-NEXT:    tbuffer_store_format_d16_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_NUM_FORMAT_USCALED] idxen
; PREGFX10-UNPACKED-NEXT:    s_endpgm
;
; PREGFX10-PACKED-LABEL: tbuffer_store_d16_xyzw:
; PREGFX10-PACKED:       ; %bb.0: ; %main_body
; PREGFX10-PACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; PREGFX10-PACKED-NEXT:    s_load_dword s6, s[8:9], 0x18
; PREGFX10-PACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; PREGFX10-PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; PREGFX10-PACKED-NEXT:    v_mov_b32_e32 v0, s4
; PREGFX10-PACKED-NEXT:    v_mov_b32_e32 v1, s5
; PREGFX10-PACKED-NEXT:    v_mov_b32_e32 v2, s6
; PREGFX10-PACKED-NEXT:    tbuffer_store_format_d16_xyzw v[0:1], v2, s[0:3], 0 format:[BUF_NUM_FORMAT_USCALED] idxen
; PREGFX10-PACKED-NEXT:    s_endpgm
;
; GFX10-PACKED-LABEL: tbuffer_store_d16_xyzw:
; GFX10-PACKED:       ; %bb.0: ; %main_body
; GFX10-PACKED-NEXT:    s_clause 0x2
; GFX10-PACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GFX10-PACKED-NEXT:    s_load_dword s6, s[8:9], 0x18
; GFX10-PACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX10-PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PACKED-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-PACKED-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-PACKED-NEXT:    v_mov_b32_e32 v2, s6
; GFX10-PACKED-NEXT:    tbuffer_store_format_d16_xyzw v[0:1], v2, s[0:3], 0 format:[BUF_FMT_10_11_11_SSCALED] idxen
; GFX10-PACKED-NEXT:    s_endpgm
;
; GFX11-PACKED-LABEL: tbuffer_store_d16_xyzw:
; GFX11-PACKED:       ; %bb.0: ; %main_body
; GFX11-PACKED-NEXT:    s_clause 0x2
; GFX11-PACKED-NEXT:    s_load_b64 s[6:7], s[4:5], 0x10
; GFX11-PACKED-NEXT:    s_load_b32 s8, s[4:5], 0x18
; GFX11-PACKED-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-PACKED-NEXT:    v_mov_b32_e32 v0, s6
; GFX11-PACKED-NEXT:    v_mov_b32_e32 v1, s7
; GFX11-PACKED-NEXT:    v_mov_b32_e32 v2, s8
; GFX11-PACKED-NEXT:    tbuffer_store_d16_format_xyzw v[0:1], v2, s[0:3], 0 format:[BUF_FMT_10_10_10_2_SNORM] idxen
; GFX11-PACKED-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.ptr.tbuffer.store.v4f16(<4 x half> %data, ptr addrspace(8) %rsrc, i32 %vindex, i32 0, i32 0, i32 33, i32 0)
  ret void
}

declare void @llvm.amdgcn.struct.ptr.tbuffer.store.f16(half, ptr addrspace(8), i32, i32, i32, i32, i32)
declare void @llvm.amdgcn.struct.ptr.tbuffer.store.v2f16(<2 x half>, ptr addrspace(8), i32, i32, i32, i32, i32)
declare void @llvm.amdgcn.struct.ptr.tbuffer.store.v3f16(<3 x half>, ptr addrspace(8), i32, i32, i32, i32, i32)
declare void @llvm.amdgcn.struct.ptr.tbuffer.store.v4f16(<4 x half>, ptr addrspace(8), i32, i32, i32, i32, i32)
