; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='print<scalar-evolution>' -scalar-evolution-classify-expressions=0 -disable-output %s 2>&1 | FileCheck %s

; The UDiv in the latch may never be executed. The backedge-taken-count
; expressions must account for the fact that evaluating the UDiv
; unconditionally may trigger UB.
define i64 @multi_exit_exit_count_with_udiv_by_value_in_latch(ptr %dst, i64 %N) {
; CHECK-LABEL: 'multi_exit_exit_count_with_udiv_by_value_in_latch'
; CHECK-NEXT:  Determining loop execution counts for: @multi_exit_exit_count_with_udiv_by_value_in_latch
; CHECK-NEXT:  Loop %loop.header: <multiple exits> backedge-taken count is ((0 smax %N) umin_seq (42 /u %N))
; CHECK-NEXT:    exit count for loop.header: (0 smax %N)
; CHECK-NEXT:    exit count for loop.latch: (42 /u %N)
; CHECK-NEXT:  Loop %loop.header: constant max backedge-taken count is i64 42
; CHECK-NEXT:  Loop %loop.header: symbolic max backedge-taken count is ((0 smax %N) umin_seq (42 /u %N))
; CHECK-NEXT:    symbolic max exit count for loop.header: (0 smax %N)
; CHECK-NEXT:    symbolic max exit count for loop.latch: (42 /u %N)
; CHECK-NEXT:  Loop %loop.header: Trip multiple is 1
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %gep = getelementptr inbounds i32, ptr %dst, i64 %iv
  store i32 1, ptr %gep
  %c.0 = icmp slt i64 %iv, %N
  br i1 %c.0, label %loop.latch, label %exit

loop.latch:
  %iv.next = add i64 %iv, 1
  %d = udiv i64 42, %N
  %c.1 = icmp slt i64 %iv, %d
  br i1 %c.1, label %loop.header, label %exit

exit:
  %p = phi i64 [ 1, %loop.header ], [ 0, %loop.latch]
  ret i64 %p
}

; The UDiv in the latch may never be executed. The backedge-taken-count
; expressions must account for the fact that evaluating the UDiv
; unconditionally may trigger UB.
define i64 @multi_exit_exit_count_with_udiv_by_value_in_latch_different_bounds(ptr %dst, i64 %N, i64 %M) {
; CHECK-LABEL: 'multi_exit_exit_count_with_udiv_by_value_in_latch_different_bounds'
; CHECK-NEXT:  Determining loop execution counts for: @multi_exit_exit_count_with_udiv_by_value_in_latch_different_bounds
; CHECK-NEXT:  Loop %loop.header: <multiple exits> backedge-taken count is ((0 smax %N) umin_seq (42 /u %M))
; CHECK-NEXT:    exit count for loop.header: (0 smax %N)
; CHECK-NEXT:    exit count for loop.latch: (42 /u %M)
; CHECK-NEXT:  Loop %loop.header: constant max backedge-taken count is i64 42
; CHECK-NEXT:  Loop %loop.header: symbolic max backedge-taken count is ((0 smax %N) umin_seq (42 /u %M))
; CHECK-NEXT:    symbolic max exit count for loop.header: (0 smax %N)
; CHECK-NEXT:    symbolic max exit count for loop.latch: (42 /u %M)
; CHECK-NEXT:  Loop %loop.header: Trip multiple is 1
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %gep = getelementptr inbounds i32, ptr %dst, i64 %iv
  store i32 1, ptr %gep
  %c.0 = icmp slt i64 %iv, %N
  br i1 %c.0, label %loop.latch, label %exit

loop.latch:
  %iv.next = add i64 %iv, 1
  %d = udiv i64 42, %M
  %c.1 = icmp slt i64 %iv, %d
  br i1 %c.1, label %loop.header, label %exit

exit:
  %p = phi i64 [ 1, %loop.header ], [ 0, %loop.latch]
  ret i64 %p
}

; The UDiv in the latch cannot trigger UB, evaluating it unconditionally in the
; trip count expression is fine.
define i64 @multi_exit_exit_count_with_udiv_by_constant_in_latch(ptr %dst, i64 %N) {
; CHECK-LABEL: 'multi_exit_exit_count_with_udiv_by_constant_in_latch'
; CHECK-NEXT:  Determining loop execution counts for: @multi_exit_exit_count_with_udiv_by_constant_in_latch
; CHECK-NEXT:  Loop %loop.header: <multiple exits> backedge-taken count is ((%N /u 42) umin (0 smax %N))
; CHECK-NEXT:    exit count for loop.header: (0 smax %N)
; CHECK-NEXT:    exit count for loop.latch: (%N /u 42)
; CHECK-NEXT:  Loop %loop.header: constant max backedge-taken count is i64 439208192231179800
; CHECK-NEXT:  Loop %loop.header: symbolic max backedge-taken count is ((%N /u 42) umin (0 smax %N))
; CHECK-NEXT:    symbolic max exit count for loop.header: (0 smax %N)
; CHECK-NEXT:    symbolic max exit count for loop.latch: (%N /u 42)
; CHECK-NEXT:  Loop %loop.header: Trip multiple is 1
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %gep = getelementptr inbounds i32, ptr %dst, i64 %iv
  store i32 1, ptr %gep
  %c.0 = icmp slt i64 %iv, %N
  br i1 %c.0, label %loop.latch, label %exit

loop.latch:
  %iv.next = add i64 %iv, 1
  %d = udiv i64 %N, 42
  %c.1 = icmp slt i64 %iv, %d
  br i1 %c.1, label %loop.header, label %exit

exit:
  %p = phi i64 [ 1, %loop.header ], [ 0, %loop.latch]
  ret i64 %p
}
