; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -verify-machineinstrs -enable-machine-outliner -mtriple aarch64 %s -o - | \
; RUN:   FileCheck %s --check-prefixes CHECK,V8A
; RUN: llc -verify-machineinstrs -enable-machine-outliner -mtriple aarch64 -mattr=+v8.3a %s -o - | \
; RUN:   FileCheck %s --check-prefixes CHECK,V83A

define i64 @a(i64 %x) "sign-return-address"="non-leaf" "sign-return-address-key"="b_key" {
; V8A-LABEL: a:
; V8A:       // %bb.0:
; V8A-NEXT:    .cfi_b_key_frame
; V8A-NEXT:    .cfi_negate_ra_state
; V8A-NEXT:    hint #27
; V8A-NEXT:    sub sp, sp, #32
; V8A-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; V8A-NEXT:    .cfi_def_cfa_offset 32
; V8A-NEXT:    .cfi_offset w30, -16
; V8A-NEXT:    bl OUTLINED_FUNCTION_0
; V8A-NEXT:    //APP
; V8A-NEXT:    mov x30, x0
; V8A-NEXT:    //NO_APP
; V8A-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; V8A-NEXT:    add sp, sp, #32
; V8A-NEXT:    hint #31
; V8A-NEXT:    ret
;
; V83A-LABEL: a:
; V83A:       // %bb.0:
; V83A-NEXT:    .cfi_b_key_frame
; V83A-NEXT:    .cfi_negate_ra_state
; V83A-NEXT:    pacibsp
; V83A-NEXT:    sub sp, sp, #32
; V83A-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; V83A-NEXT:    .cfi_def_cfa_offset 32
; V83A-NEXT:    .cfi_offset w30, -16
; V83A-NEXT:    bl OUTLINED_FUNCTION_0
; V83A-NEXT:    //APP
; V83A-NEXT:    mov x30, x0
; V83A-NEXT:    //NO_APP
; V83A-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; V83A-NEXT:    add sp, sp, #32
; V83A-NEXT:    retab
  %1 = alloca i32, align 4
  %2 = alloca i32, align 4
  %3 = alloca i32, align 4
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  store i32 1, ptr %1, align 4
  store i32 2, ptr %2, align 4
  store i32 3, ptr %3, align 4
  store i32 4, ptr %4, align 4
  store i32 5, ptr %5, align 4
  store i32 6, ptr %6, align 4
  call void asm sideeffect "mov x30, $0", "r,~{lr}"(i64 %x) #1
  ret i64 %x
}

define i64 @b(i64 %x) "sign-return-address"="non-leaf" "sign-return-address-key"="b_key" {
; V8A-LABEL: b:
; V8A:       // %bb.0:
; V8A-NEXT:    .cfi_b_key_frame
; V8A-NEXT:    .cfi_negate_ra_state
; V8A-NEXT:    hint #27
; V8A-NEXT:    sub sp, sp, #32
; V8A-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; V8A-NEXT:    .cfi_def_cfa_offset 32
; V8A-NEXT:    .cfi_offset w30, -16
; V8A-NEXT:    bl OUTLINED_FUNCTION_0
; V8A-NEXT:    //APP
; V8A-NEXT:    mov x30, x0
; V8A-NEXT:    //NO_APP
; V8A-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; V8A-NEXT:    add sp, sp, #32
; V8A-NEXT:    hint #31
; V8A-NEXT:    ret
;
; V83A-LABEL: b:
; V83A:       // %bb.0:
; V83A-NEXT:    .cfi_b_key_frame
; V83A-NEXT:    .cfi_negate_ra_state
; V83A-NEXT:    pacibsp
; V83A-NEXT:    sub sp, sp, #32
; V83A-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; V83A-NEXT:    .cfi_def_cfa_offset 32
; V83A-NEXT:    .cfi_offset w30, -16
; V83A-NEXT:    bl OUTLINED_FUNCTION_0
; V83A-NEXT:    //APP
; V83A-NEXT:    mov x30, x0
; V83A-NEXT:    //NO_APP
; V83A-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; V83A-NEXT:    add sp, sp, #32
; V83A-NEXT:    retab
  %1 = alloca i32, align 4
  %2 = alloca i32, align 4
  %3 = alloca i32, align 4
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  store i32 1, ptr %1, align 4
  store i32 2, ptr %2, align 4
  store i32 3, ptr %3, align 4
  store i32 4, ptr %4, align 4
  store i32 5, ptr %5, align 4
  store i32 6, ptr %6, align 4
  call void asm sideeffect "mov x30, $0", "r,~{lr}"(i64 %x) #1
  ret i64 %x
}

define i64 @c(i64 %x) "sign-return-address"="non-leaf" "sign-return-address-key"="b_key" {
; V8A-LABEL: c:
; V8A:       // %bb.0:
; V8A-NEXT:    .cfi_b_key_frame
; V8A-NEXT:    .cfi_negate_ra_state
; V8A-NEXT:    hint #27
; V8A-NEXT:    sub sp, sp, #32
; V8A-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; V8A-NEXT:    .cfi_def_cfa_offset 32
; V8A-NEXT:    .cfi_offset w30, -16
; V8A-NEXT:    bl OUTLINED_FUNCTION_0
; V8A-NEXT:    //APP
; V8A-NEXT:    mov x30, x0
; V8A-NEXT:    //NO_APP
; V8A-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; V8A-NEXT:    add sp, sp, #32
; V8A-NEXT:    hint #31
; V8A-NEXT:    ret
;
; V83A-LABEL: c:
; V83A:       // %bb.0:
; V83A-NEXT:    .cfi_b_key_frame
; V83A-NEXT:    .cfi_negate_ra_state
; V83A-NEXT:    pacibsp
; V83A-NEXT:    sub sp, sp, #32
; V83A-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; V83A-NEXT:    .cfi_def_cfa_offset 32
; V83A-NEXT:    .cfi_offset w30, -16
; V83A-NEXT:    bl OUTLINED_FUNCTION_0
; V83A-NEXT:    //APP
; V83A-NEXT:    mov x30, x0
; V83A-NEXT:    //NO_APP
; V83A-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; V83A-NEXT:    add sp, sp, #32
; V83A-NEXT:    retab
  %1 = alloca i32, align 4
  %2 = alloca i32, align 4
  %3 = alloca i32, align 4
  %4 = alloca i32, align 4
  %5 = alloca i32, align 4
  %6 = alloca i32, align 4
  store i32 1, ptr %1, align 4
  store i32 2, ptr %2, align 4
  store i32 3, ptr %3, align 4
  store i32 4, ptr %4, align 4
  store i32 5, ptr %5, align 4
  store i32 6, ptr %6, align 4
  call void asm sideeffect "mov x30, $0", "r,~{lr}"(i64 %x) #1
  ret i64 %x
}

;; Outlined function is leaf-function => don't sign it
; CHECK-LABEL:      OUTLINED_FUNCTION_0:
; CHECK-NOT:            .cfi_b_key_frame
; CHECK-NOT:            paci{{[a,b]}}sp
; CHECK-NOT:            hint #2{{[5,7]}}
; CHECK-NOT:            .cfi_negate_ra_state
; CHECK-NOT:            auti{{[a,b]}}sp
