/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 32 "parser.y"

/** @endcond */

// local
#include "pjl_config.h"                 /* must go first */
#include "c_ast.h"
#include "c_ast_check.h"
#include "c_ast_util.h"
#include "c_keyword.h"
#include "c_lang.h"
#include "c_operator.h"
#include "c_sglob.h"
#include "c_sname.h"
#include "c_type.h"
#include "c_typedef.h"
#include "cdecl.h"
#include "cdecl_keyword.h"
#include "color.h"
#ifdef ENABLE_CDECL_DEBUG
#include "dump.h"
#endif /* ENABLE_CDECL_DEBUG */
#include "did_you_mean.h"
#include "english.h"
#include "gibberish.h"
#include "help.h"
#include "lexer.h"
#include "literals.h"
#include "options.h"
#include "print.h"
#include "set_options.h"
#include "slist.h"
#include "types.h"
#include "util.h"

/// @cond DOXYGEN_IGNORE

// standard
#include <assert.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

// Silence these warnings for Bison-generated code.
#ifdef __GNUC__
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wconversion"
# pragma GCC diagnostic ignored "-Wredundant-decls"
# pragma GCC diagnostic ignored "-Wunreachable-code"
#endif /* __GNUC__ */

// Developer aid for tracing when Bison %destructors are called.
#if 0
#define DTRACE                    EPRINTF( "%d: destructor\n", __LINE__ )
#else
#define DTRACE                    NO_OP
#endif

#ifdef ENABLE_CDECL_DEBUG
#define IF_DEBUG(...) \
  BLOCK( if ( opt_cdecl_debug ) { __VA_ARGS__ } )
#else
#define IF_DEBUG(...)             NO_OP
#endif /* ENABLE_CDECL_DEBUG */

/// @endcond

///////////////////////////////////////////////////////////////////////////////

/**
 * @defgroup parser-group Parser
 * Helper macros, data structures, variables, functions, and the grammar for
 * C/C++ declarations.
 * @{
 */

/**
 * Calls #elaborate_error_dym() with #DYM_NONE.
 *
 * @param ... Arguments passed to fl_elaborate_error().
 *
 * @note This must be used _only_ after an `error` token, e.g.:
 * ```
 *  | Y_define error
 *    {
 *      elaborate_error( "name expected" );
 *    }
 * ```
 * @note A newline _is_ printed.
 *
 * @sa elaborate_error_dym()
 * @sa keyword_expected()
 * @sa punct_expected()
 */
#define elaborate_error(...) \
  elaborate_error_dym( DYM_NONE, __VA_ARGS__ )

/**
 * Calls fl_elaborate_error() followed by #PARSE_ABORT().
 *
 * @param DYM_KINDS The bitwise-or of \ref dym_kind_t things possibly meant.
 * @param ... Arguments passed to fl_elaborate_error().
 *
 * @note This must be used _only_ after an `error` token, e.g.:
 * ```
 *  | error
 *    {
 *      elaborate_error_dym( DYM_COMMANDS, "unexpected token" );
 *    }
 * ```
 * @note A newline _is_ printed.
 *
 * @sa elaborate_error()
 * @sa keyword_expected()
 * @sa punct_expected()
 */
#define elaborate_error_dym(DYM_KINDS,...) BLOCK( \
  fl_elaborate_error( __FILE__, __LINE__, (DYM_KINDS), __VA_ARGS__ ); PARSE_ABORT(); )

/**
 * Checks whether the type currently being declared (`enum`, `struct`,
 * `typedef`, or `union`) is nested within some other type (`struct` or
 * `union`) and whether the current language is C: if not, prints an error
 * message.
 *
 * @remarks In debug mode, also includes the file & line where the function was
 * called from in the error message.
 *
 * @param TYPE_LOC The location of the type declaration.
 * @return Returns `true` only if the type currently being declared is either
 * not nested or the current language is C++.
 *
 * @sa fl_is_nested_type_ok()
 */
#define is_nested_type_ok(TYPE_LOC) \
  fl_is_nested_type_ok( __FILE__, __LINE__, (TYPE_LOC) )

/**
 * Calls fl_keyword_expected() followed by #PARSE_ABORT().
 *
 * @param KEYWORD A keyword literal.
 *
 * @note This must be used _only_ after an `error` token, e.g.:
 * ```
 *  : Y_virtual
 *  | error
 *    {
 *      keyword_expected( L_virtual );
 *    }
 * ```
 *
 * @sa elaborate_error()
 * @sa elaborate_error_dym()
 * @sa punct_expected()
 */
#define keyword_expected(KEYWORD) BLOCK ( \
  fl_keyword_expected( __FILE__, __LINE__, (KEYWORD) ); PARSE_ABORT(); )

/**
 * Aborts the current parse after an error message has been printed.
 *
 * @sa #PARSE_ASSERT()
 */
#define PARSE_ABORT() \
  BLOCK( parse_cleanup( /*fatal_error=*/true ); YYABORT; )

/**
 * Evaluates \a EXPR: if `false`, calls #PARSE_ABORT().
 *
 * @param EXPR The expression to evalulate.
 */
#define PARSE_ASSERT(EXPR)        BLOCK( if ( !(EXPR) ) PARSE_ABORT(); )

/**
 * Calls fl_punct_expected() followed by #PARSE_ABORT().
 *
 * @param PUNCT The punctuation character that was expected.
 *
 * @note This must be used _only_ after an `error` token, e.g.:
 * ```
 *  : ','
 *  | error
 *    {
 *      punct_expected( ',' );
 *    }
 * ```
 *
 * @sa elaborate_error()
 * @sa elaborate_error_dym()
 * @sa keyword_expected()
 */
#define punct_expected(PUNCT) BLOCK( \
  fl_punct_expected( __FILE__, __LINE__, (PUNCT) ); PARSE_ABORT(); )

/**
 * Show all (as opposed to only those that are supported in the current
 * language) predefined, user, or both types.
 */
#define SHOW_ALL_TYPES            0x10u

/**
* Show only predefined types that are valid in the current language.
*/
#define SHOW_PREDEFINED_TYPES     (1u << 0)

/**
 * Show only user-defined types that were defined in the current language or
 * earlier.
 */
#define SHOW_USER_DEFINED_TYPES   (1u << 1)

/** @} */

///////////////////////////////////////////////////////////////////////////////

/**
 * @defgroup parser-dump-group Debugging Macros
 * Macros that are used to dump a trace during parsing when \ref
 * opt_cdecl_debug is `true`.
 * @ingroup parser-group
 * @{
 */

/**
 * Dumps an AST.
 *
 * @param KEY The key name to print.
 * @param AST The AST to dump.
 *
 * @sa #DUMP_AST_LIST()
 * @sa #DUMP_AST_PAIR()
 */
#define DUMP_AST(KEY,AST) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); c_ast_dump( (AST), stdout ); )

/**
 * Dumps an s_list of AST.
 *
 * @param KEY The key name to print.
 * @param AST_LIST The \ref slist of AST to dump.
 *
 * @sa #DUMP_AST()
 * @sa #DUMP_AST_PAIR()
 */
#define DUMP_AST_LIST(KEY,AST_LIST) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); c_ast_list_dump( &(AST_LIST), stdout ); )

/**
 * Dump a \ref c_ast_pair.
 *
 * @param KEY The key name to print.
 * @param ASTP The \ref c_ast_pair to dump.
 *
 * @sa #DUMP_AST()
 */
#define DUMP_AST_PAIR(KEY,ASTP) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); c_ast_pair_dump( &(ASTP), stdout ); )

/**
 * Dumps a `bool`.
 *
 * @param KEY The key name to print.
 * @param BOOL The `bool` to dump.
 *
 * @sa #DUMP_KEY()
 */
#define DUMP_BOOL(KEY,BOOL)  IF_DEBUG(  \
  DUMP_KEY( KEY ": " ); bool_dump( (BOOL), stdout ); )

/**
 * Dumps a comma followed by a newline the _second_ and subsequent times it's
 * called used to separate items being dumped.
 */
#define DUMP_COMMA                fput_sep( ",\n", &dump_comma, stdout )

/**
 * Ends a dump block.
 *
 * @sa #DUMP_START()
 */
#define DUMP_END()                IF_DEBUG( PUTS( "\n}\n\n" ); )

/**
 * Possibly dumps a comma and a newline followed by the `printf()` arguments
 * &mdash; used for printing a key followed by a value.
 *
 * @param ... The `printf()` arguments.
 */
#define DUMP_KEY(...) IF_DEBUG( \
  DUMP_COMMA; PRINTF( "  " __VA_ARGS__ ); )

/**
 * Dumps an integer.
 *
 * @param KEY The key name to print.
 * @param NUM The integer to dump.
 *
 * @sa #DUMP_KEY()
 * @sa #DUMP_STR()
 */
#define DUMP_INT(KEY,NUM) \
  DUMP_KEY( KEY ": %d", STATIC_CAST( int, (NUM) ) )

/**
 * Dumps a scoped name.
 *
 * @param KEY The key name to print.
 * @param SNAME The scoped name to dump.
 *
 * @sa #DUMP_KEY()
 * @sa #DUMP_SNAME_LIST()
 * @sa #DUMP_STR()
 */
#define DUMP_SNAME(KEY,SNAME) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); c_sname_dump( &(SNAME), stdout ); )

/**
 * Dumps a list of scoped names.
 *
 * @param KEY The key name to print.
 * @param LIST The list of scoped names to dump.
 *
 * @sa #DUMP_KEY()
 * @sa #DUMP_SNAME()
 */
#define DUMP_SNAME_LIST(KEY,LIST) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); c_sname_list_dump( &(LIST), stdout ); )

#ifdef ENABLE_CDECL_DEBUG
/**
 * @def DUMP_START
 *
 * Starts a dump block.  The dump block _must_ end with #DUMP_END().  If a rule
 * has a result, it should be dumped as the final thing before the #DUMP_END()
 * repeating the name of the rule, e.g.:
 * ```
 *  DUMP_START( "rule",                 // <-- This rule name ...
 *              "subrule_1 name subrule_2" );
 *  DUMP_AST( "subrule_1", $1 );
 *  DUMP_STR( "name", $2 );
 *  DUMP_AST( "subrule_2", $3 );
 *  // ...
 *  DUMP_AST( "rule", $$ );             // <-- ... is repeated here.
 *  DUMP_END();
 * ```
 *
 * @param NAME The grammar production name.
 * @param RULE The grammar production rule.
 *
 * @sa #DUMP_AST
 * @sa #DUMP_AST_LIST
 * @sa #DUMP_BOOL
 * @sa #DUMP_END
 * @sa #DUMP_INT
 * @sa #DUMP_SNAME
 * @sa #DUMP_STR
 * @sa #DUMP_TID
 * @sa #DUMP_TYPE
 */
#define DUMP_START(NAME,RULE)         \
  bool dump_comma = false; IF_DEBUG(  \
  PUTS( NAME ": {\n  rule: " ); str_dump( (RULE), stdout ); PUTS( ",\n" ); )
#else
#define DUMP_START(NAME,RULE)     NO_OP
#endif

/**
 * Dumps a C string.
 *
 * @param KEY The key name to print.
 * @param STR The C string to dump.
 *
 * @sa #DUMP_INT()
 * @sa #DUMP_SNAME()
 */
#define DUMP_STR(KEY,STR) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); str_dump( (STR), stdout ); )

/**
 * Dumps a \ref c_tid_t.
 *
 * @param KEY The key name to print.
 * @param TID The \ref c_tid_t to dump.
 *
 * @sa #DUMP_TYPE()
 */
#define DUMP_TID(KEY,TID) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); c_tid_dump( (TID), stdout ); )

/**
 * Dumps a \ref c_type.
 *
 * @param KEY The key name to print.
 * @param TYPE The \ref c_type to dump.
 *
 * @sa #DUMP_TID()
 */
#define DUMP_TYPE(KEY,TYPE) IF_DEBUG( \
  DUMP_KEY( KEY ": " ); c_type_dump( &(TYPE), stdout ); )

/** @} */

/**
 * Shorthand for calling unsupported() with \a LANG_MACRO.
 *
 * @param LANG_MACRO A `LANG_*` macro without the `LANG_` prefix.
 *
 * @sa unsupported()
 */
#define UNSUPPORTED(LANG_MACRO)   unsupported( LANG_##LANG_MACRO )

///////////////////////////////////////////////////////////////////////////////

/**
 * @addtogroup parser-group
 * @{
 */

/**
 * Inherited attributes.
 */
struct in_attr {
  c_alignas_t   align;            ///< Alignment, if any.
  unsigned      ast_depth;        ///< Parentheses nesting depth.
  c_sname_t     current_scope;    ///< C++ only: current scope, if any.
  bool          is_implicit_int;  ///< Created implicit `int` AST?
  bool          is_typename;      ///< C++ only: `typename` specified?
  c_operator_t const *operator;   ///< C++ only: current operator, if any.
  c_ast_list_t  type_ast_stack;   ///< Type AST stack.
  c_ast_t      *typedef_ast;      ///< AST of `typedef` being declared.
  c_ast_list_t  typedef_ast_list; ///< AST nodes of `typedef` being declared.
  rb_node_t    *typedef_rb;       ///< Red-black node for temporary `typedef`.
};
typedef struct in_attr in_attr_t;

/**
 * Information for show_type_visitor().
 */
struct show_type_info {
  unsigned  show_which;                 ///< Predefined, user, or both?
  unsigned  gib_flags;                  ///< Gibberish flags.
  c_sglob_t sglob;                      ///< Scoped glob to match, if any.
};
typedef struct show_type_info show_type_info_t;

// local functions
NODISCARD
static bool c_ast_free_if_placeholder( c_ast_t* );

PJL_PRINTF_LIKE_FUNC(4)
static void fl_elaborate_error( char const*, int, dym_kind_t, char const*,
                                ... );

// local variables
static c_ast_list_t   gc_ast_list;      ///< c_ast nodes freed after parse.
static in_attr_t      in_attr;          ///< Inherited attributes.
static c_ast_list_t   typedef_ast_list; ///< List of ASTs for `typedef`s.

////////// inline functions ///////////////////////////////////////////////////

/**
 * Garbage-collect the AST nodes on \a ast_list but does _not_ free \a ast_list
 * itself.
 *
 * @param ast_list The AST list to free the nodes of.
 *
 * @sa c_ast_list_cleanup()
 * @sa c_ast_new_gc()
 * @sa c_ast_pair_new_gc()
 */
static inline void c_ast_list_gc( c_ast_list_t *ast_list ) {
  slist_cleanup( ast_list, POINTER_CAST( slist_free_fn_t, &c_ast_free ) );
}

/**
 * Creates a new AST and adds it to \ref gc_ast_list.
 *
 * @param kind The kind of AST to create.
 * @param loc A pointer to the token location data.
 * @return Returns a pointer to a new AST.
 *
 * @sa c_ast_pair_new_gc()
 */
NODISCARD
static inline c_ast_t* c_ast_new_gc( c_ast_kind_t kind, c_loc_t const *loc ) {
  return c_ast_new( kind, in_attr.ast_depth, loc, &gc_ast_list );
}

/**
 * Set our mode to deciphering gibberish into English.
 */
static inline void gibberish_to_english( void ) {
  cdecl_mode = CDECL_GIBBERISH_TO_ENGLISH;
  lexer_find &= ~LEXER_FIND_CDECL_KEYWORDS;
}

/**
 * Peeks at the type AST at the top of the
 * \ref in_attr.type_ast_stack "type AST inherited attribute stack".
 *
 * @return Returns said AST.
 *
 * @sa ia_type_ast_pop()
 * @sa ia_type_ast_push()
 */
NODISCARD
static inline c_ast_t* ia_type_ast_peek( void ) {
  return slist_front( &in_attr.type_ast_stack );
}

/**
 * Pops a type AST from the
 * \ref in_attr.type_ast_stack "type AST inherited attribute stack".
 *
 * @return Returns said AST.
 *
 * @sa ia_type_ast_peek()
 * @sa ia_type_ast_push()
 */
PJL_DISCARD
static inline c_ast_t* ia_type_ast_pop( void ) {
  return slist_pop_front( &in_attr.type_ast_stack );
}

/**
 * Pushes a type AST onto the
 * \ref in_attr.type_ast_stack "type AST inherited attribute  stack".
 *
 * @param ast The AST to push.
 *
 * @sa ia_type_ast_peek()
 * @sa ia_type_ast_pop()
 */
static inline void ia_type_ast_push( c_ast_t *ast ) {
  slist_push_front( &in_attr.type_ast_stack, ast );
}

/**
 * Cleans-up all memory associated with \a sti but does _not_ free \a sti
 * itself.
 *
 * @param sti The \ref show_type_info to clean up.
 *
 * @sa sti_init()
 */
static inline void sti_cleanup( show_type_info_t *sti ) {
  c_sglob_cleanup( &sti->sglob );
  MEM_ZERO( sti );
}

/**
 * Checks if the current language is _not_ among \a lang_ids.
 *
 * @param lang_ids The bitwise-or of language(s).
 * @return Returns `true` only if **cdecl** has been initialized and \ref
 * opt_lang is _not_ among \a lang_ids.
 *
 * @sa #UNSUPPORTED()
 */
NODISCARD
static inline bool unsupported( c_lang_id_t lang_ids ) {
  return !opt_lang_is_any( lang_ids ) && cdecl_initialized;
}

////////// local functions ////////////////////////////////////////////////////

/**
 * Adds a type to the global set.
 *
 * @param type_ast The AST of the type to add.
 * @param gib_flags The gibberish flags to use; must only be one of
 * #C_GIB_NONE, #C_GIB_TYPEDEF, or #C_GIB_USING.
 * @return Returns `true` either if the type was added or it's equivalent to an
 * existing type; `false` if a different type already exists having the same
 * name.
 */
NODISCARD
static bool add_type( c_ast_t const *type_ast, unsigned gib_flags ) {
  assert( type_ast != NULL );

  c_ast_t const *const leaf_ast = c_ast_leaf( type_ast );
  if ( c_ast_is_tid_any( leaf_ast, TB_AUTO ) ) {
    print_error( &leaf_ast->loc,
      "\"%s\" illegal in type definition\n",
      c_type_name_error( &leaf_ast->type )
    );
    return false;
  }

  rb_node_t const *const typedef_rb = c_typedef_add( type_ast, gib_flags );
  c_typedef_t const *const tdef = typedef_rb->data;

  if ( tdef->ast == type_ast ) {
    //
    // Type was added: we have to move the AST from the gc_ast_list so it won't
    // be garbage collected at the end of the parse to a separate
    // typedef_ast_list that's freed only at program termination.
    //
    // But first, free all orphaned placeholder AST nodes.  (For a non-type-
    // defining parse, this step isn't necessary since all nodes are freed at
    // the end of the parse anyway.)
    //
    slist_free_if(
      &gc_ast_list, POINTER_CAST( slist_pred_fn_t, &c_ast_free_if_placeholder )
    );
    slist_push_list_back( &typedef_ast_list, &gc_ast_list );
  }
  else {
    //
    // Type was NOT added because a previously declared type having the same
    // name was returned: check if the types are equal.
    //
    // In C, multiple typedef declarations having the same name are allowed
    // only if the types are equivalent:
    //
    //      typedef int T;
    //      typedef int T;                // OK
    //      typedef double T;             // error: types aren't equivalent
    //
    if ( !c_ast_equal( type_ast, tdef->ast ) ) {
      print_error( &type_ast->loc,
        "\"%s\": type redefinition with different type; original is: ",
        c_sname_full_name( &type_ast->sname )
      );
      print_type( tdef, stderr );
      return false;
    }
  }

  return true;
}

/**
 * Prints a warning that the attribute \a keyword syntax is not supported (and
 * ignored).
 *
 * @param loc The source location of \a keyword.
 * @param keyword The attribute syntax keyword, e.g., `__attribute__` or
 * `__declspec`.
 */
static void attr_syntax_not_supported( c_loc_t const *loc,
                                       char const *keyword ) {
  assert( loc != NULL );
  assert( keyword != NULL );

  print_warning( loc,
    "\"%s\" not supported by %s (ignoring)", keyword, CDECL
  );
  if ( OPT_LANG_IS( ATTRIBUTES ) )
    print_hint( "[[...]]" );
  else
    EPUTC( '\n' );
}

/**
 * A predicate function for slist_free_if() that checks whether \a ast is a
 * #K_PLACEHOLDER: if so, c_ast_free()s it.
 *
 * @param ast The AST to check.
 * @return Returns `true` only if \a ast is a #K_PLACEHOLDER.
 */
static bool c_ast_free_if_placeholder( c_ast_t *ast ) {
  if ( ast->kind == K_PLACEHOLDER ) {
    assert( c_ast_is_orphan( ast ) );
    c_ast_free( ast );
    return true;
  }
  return false;
}

/**
 * Checks whether `typename` is OK since the type's name is a qualified name.
 *
 * @param ast The AST to check.
 * @return Returns `true` only upon success.
 */
NODISCARD
bool c_ast_is_typename_ok( c_ast_t const *ast ) {
  c_ast_t const *const raw_ast = c_ast_untypedef( ast );
  if ( c_sname_count( &raw_ast->sname ) < 2 ) {
    print_error( &ast->loc, "qualified name expected after \"typename\"\n" );
    return false;
  }
  return true;
}

/**
 * Checks whether the type currently being declared (`enum`, `struct`,
 * `typedef`, or `union`) is nested within some other type (`struct` or
 * `union`) and whether the current language is C: if not, prints an error
 * message.
 *
 * @note It is unnecessary to check either when a `class` is being declared or
 * when a type is being declared within a `namespace` since those are not legal
 * in C anyway.
 *
 * @note This function isn't normally called directly; use the
 * #is_nested_type_ok() macro instead.
 *
 * @param file The name of the file where this function was called from.
 * @param line The line number within \a file where this function was called
 * from.
 * @param type_loc The location of the type declaration.
 * @return Returns `true` only if the type currently being declared is either
 * not nested or the current language is C++.
 */
NODISCARD
static bool fl_is_nested_type_ok( char const *file, int line,
                                  c_loc_t const *type_loc ) {
  assert( type_loc != NULL );
  if ( !c_sname_empty( &in_attr.current_scope ) &&
       !OPT_LANG_IS( NESTED_TYPES ) ) {
    fl_print_error( file, line, type_loc,
      "nested types not supported%s\n",
      C_LANG_WHICH( NESTED_TYPES )
    );
    return false;
  }
  return true;
}

/**
 * A special case of fl_elaborate_error() that prevents oddly worded error
 * messages where a C/C++ keyword is expected, but that keyword isn't a keyword
 * either until a later version of the language or in a different language;
 * hence, the lexer will return the keyword as the `Y_NAME` token instead of
 * the keyword token.
 *
 * For example, if fl_elaborate_error() were used for the following \b cdecl
 * command when the current language is C, you'd get the following:
 * ```
 * declare f as virtual function returning void
 *              ^
 * 14: syntax error: "virtual": "virtual" expected; not a keyword until C++98
 * ```
 * because it's really this:
 * ```
 * ... "virtual" [the name]": "virtual" [the token] expected ...
 * ```
 * and that looks odd.
 *
 * @note This function isn't normally called directly; use the
 * #keyword_expected() macro instead.
 *
 * @param file The name of the file where this function was called from.
 * @param line The line number within \a file where this function was called
 * from.
 * @param keyword A keyword literal.
 *
 * @sa fl_elaborate_error()
 * @sa fl_punct_expected()
 * @sa yyerror()
 */
static void fl_keyword_expected( char const *file, int line,
                                 char const *keyword ) {
  assert( keyword != NULL );

  dym_kind_t dym_kinds = DYM_NONE;

  char const *const error_token = lexer_printable_token();
  if ( error_token != NULL ) {
    if ( strcmp( error_token, keyword ) == 0 ) {
      //
      // The error token is the expected keyword which means the lexer returned
      // it as a name and not the token which likely means it's not a C/C++
      // keyword until a later version of the current language.
      //
      c_keyword_t const *const ck =
        c_keyword_find( keyword, LANG_ANY, C_KW_CTX_DEFAULT );
      if ( ck != NULL ) {
        char const *const which_lang = c_lang_which( ck->lang_ids );
        if ( which_lang[0] != '\0' ) {
          EPRINTF( ": \"%s\" not supported%s\n", keyword, which_lang );
          return;
        }
      }
    }

    dym_kinds = cdecl_mode == CDECL_ENGLISH_TO_GIBBERISH ?
      DYM_CDECL_KEYWORDS : DYM_C_KEYWORDS;
  }

  fl_elaborate_error( file, line, dym_kinds, "\"%s\" expected", keyword );
}

/**
 * A special case of fl_elaborate_error() that prevents oddly worded error
 * messages when a punctuation character is expected by not doing keyword look-
 * ups of the error token.

 * For example, if fl_elaborate_error() were used for the following \b cdecl
 * command, you'd get the following:
 * ```
 * explain void f(int g const)
 *                      ^
 * 29: syntax error: "const": ',' expected ("const" is a keyword)
 * ```
 * and that looks odd since, if a punctuation character was expected, it seems
 * silly to point out that the encountered token is a keyword.
 *
 * @note This function isn't normally called directly; use the
 * #punct_expected() macro instead.
 *
 * @param file The name of the file where this function was called from.
 * @param line The line number within \a file where this function was called
 * from.
 * @param punct The punctuation character that was expected.
 *
 * @sa fl_elaborate_error()
 * @sa fl_keyword_expected()
 * @sa yyerror()
 */
static void fl_punct_expected( char const *file, int line, char punct ) {
  EPUTS( ": " );
  print_debug_file_line( file, line );

  char const *const error_token = lexer_printable_token();
  if ( error_token != NULL )
    EPRINTF( "\"%s\": ", error_token );

  EPRINTF( "'%c' expected\n", punct );
}

/**
 * Cleans-up all resources used by \ref in_attr "inherited attributes".
 */
static void ia_cleanup( void ) {
  c_sname_cleanup( &in_attr.current_scope );
  // Do _not_ pass &c_ast_free for the 2nd argument! All AST nodes were already
  // free'd from the gc_ast_list in parse_cleanup(). Just free the slist nodes.
  slist_cleanup( &in_attr.type_ast_stack, /*free_fn=*/NULL );
  c_ast_list_gc( &in_attr.typedef_ast_list );
  MEM_ZERO( &in_attr );
}

/**
 * Joins \a type_ast and \a decl_ast into a single AST.
 *
 * @param type_ast The type AST.
 * @param decl_ast The declaration AST.
 * @return Returns the joined AST on success or NULL on error.
 */
NODISCARD
c_ast_t* join_type_decl( c_ast_t *type_ast, c_ast_t *decl_ast ) {
  assert( type_ast != NULL );
  assert( decl_ast != NULL );

  if ( in_attr.is_typename && !c_ast_is_typename_ok( type_ast ) )
    return NULL;

  c_type_t type = c_ast_take_type_any( type_ast, &T_TS_TYPEDEF );

  if ( c_tid_is_any( type.stids, TS_TYPEDEF ) && decl_ast->kind == K_TYPEDEF ) {
    //
    // This is for a case like:
    //
    //      explain typedef int int32_t;
    //
    // that is: explaining an existing typedef.  In order to do that, we have
    // to un-typedef it so we explain the type that it's a typedef for.
    //
    c_ast_t const *const raw_decl_ast = c_ast_untypedef( decl_ast );

    //
    // However, we also have to check whether the typedef being explained is
    // not equivalent to the existing typedef.  This is for a case like:
    //
    //      explain typedef char int32_t;
    //
    if ( !c_ast_equal( type_ast, raw_decl_ast ) ) {
      print_error( &decl_ast->loc,
        "\"%s\": type redefinition with different type; original is: ",
        c_sname_full_name( &raw_decl_ast->sname )
      );
      // Look-up the type so we can print it how it was originally defined.
      c_typedef_t const *const tdef =
        c_typedef_find_sname( &raw_decl_ast->sname );
      assert( tdef != NULL );
      print_type( tdef, stderr );
      return NULL;
    }

    //
    // Because the raw_decl_ast for the existing type is about to be combined
    // with type_ast, duplicate raw_decl_ast first.
    //
    decl_ast = c_ast_dup( raw_decl_ast, &gc_ast_list );
  }

  c_ast_t *const ast = c_ast_patch_placeholder( type_ast, decl_ast );
  c_type_t const tdef_type = c_ast_take_type_any( ast, &T_TS_TYPEDEF );
  c_type_or_eq( &type, &tdef_type );
  c_type_or_eq( &ast->type, &type );

  if ( in_attr.align.kind != C_ALIGNAS_NONE ) {
    ast->align = in_attr.align;
    if ( c_tid_is_any( type.stids, TS_TYPEDEF ) ) {
      //
      // We check for illegal aligned typedef here rather than in c_ast_check.c
      // because the "typedef-ness" needed to be removed previously before the
      // eventual call to c_ast_check().
      //
      print_error( &ast->align.loc, "typedef can not be aligned\n" );
      return NULL;
    }
  }

  if ( ast->kind == K_USER_DEF_CONVERSION &&
       c_sname_local_type( &ast->sname )->btids == TB_SCOPE ) {
    //
    // User-defined conversions don't have names, but they can still have a
    // scope.  Since only classes can have them, if the scope is still
    // TB_SCOPE, change it to TB_CLASS.
    //
    c_sname_set_local_type( &ast->sname, &C_TYPE_LIT_B( TB_CLASS ) );
  }

  return ast;
}

/**
 * Cleans up individial parse data after each parse.
 *
 * @param fatal_error Must be `true` only if a fatal semantic error has
 * occurred and `YYABORT` is about to be called to bail out of parsing by
 * returning from yyparse().
 */
static void parse_cleanup( bool fatal_error ) {
  cdecl_mode = CDECL_ENGLISH_TO_GIBBERISH;

  //
  // We need to reset the lexer differently depending on whether we completed a
  // parse with a fatal error.  If so, do a "hard" reset that also resets the
  // EOF flag of the lexer.
  //
  lexer_reset( /*hard_reset=*/fatal_error );

  c_ast_list_gc( &gc_ast_list );
  ia_cleanup();
}

/**
 * Implements the **cdecl** `quit` command.
 *
 * @note This should be marked `noreturn` but isn't since that would generate a
 * warning that a `break` in the Bison-generated code won't be executed.
 */
static void quit( void ) {
  exit( EX_OK );
}

/**
 * Shows (prints) the definition of \a tdef.
 *
 * @param tdef The \ref c_typedef to show.
 * @param gib_flags The gibberish flags to use.
 */
static void show_type( c_typedef_t const *tdef, unsigned gib_flags ) {
  assert( tdef != NULL );
  if ( gib_flags == C_GIB_NONE ) {
    c_typedef_english( tdef, stdout );
  } else {
    if ( opt_semicolon )
      gib_flags |= C_GIB_FINAL_SEMI;
    c_typedef_gibberish( tdef, gib_flags, stdout );
  }
  PUTC( '\n' );
}

/**
 * A visitor function to show (print) \a tdef.
 *
 * @param tdef The \ref c_typedef to show.
 * @param data Optional data passed to the visitor: in this case, a \ref
 * show_type_info.
 * @return Always returns `false`.
 */
NODISCARD
static bool show_type_visitor( c_typedef_t const *tdef, void *data ) {
  assert( tdef != NULL );
  assert( data != NULL );

  show_type_info_t const *const sti = data;

  bool const show_in_lang =
    (sti->show_which & SHOW_ALL_TYPES) != 0 ||
    opt_lang_is_any( tdef->lang_ids );

  if ( show_in_lang ) {
    bool const show_it =
      ((tdef->is_predefined ?
        (sti->show_which & SHOW_PREDEFINED_TYPES  ) != 0 :
        (sti->show_which & SHOW_USER_DEFINED_TYPES) != 0)) &&
      (c_sglob_empty( &sti->sglob ) ||
       c_sname_match( &tdef->ast->sname, &sti->sglob ));

    if ( show_it )
      show_type( tdef, sti->gib_flags );
  }

  return /*stop=*/false;
}

/**
 * Initializes a show_type_info_t.
 *
 * @param sti The \ref show_type_info to initialize.
 * @param show_which Which types to show: predefined, user, or both?
 * @param glob The glob string; may be NULL.
 * @param gib_flags The gibberish flags to use.
 *
 * @sa sti_cleanup()
 */
static void sti_init( show_type_info_t *sti, unsigned show_which,
                      char const *glob, unsigned gib_flags ) {
  assert( sti != NULL );
  sti->show_which = show_which;
  sti->gib_flags = gib_flags;
  c_sglob_init( &sti->sglob );
  c_sglob_parse( glob, &sti->sglob );
}

/**
 * Called by Bison to print a parsing error message to standard error.
 *
 * @remarks A custom error printing function via `%%define parse.error custom`
 * and `yyreport_syntax_error()` is not done because printing a (perhaps long)
 * list of all the possible expected tokens isn't helpful.
 * @par
 * It's also more flexible to be able to call one of #elaborate_error(),
 * #keyword_expected(), or #punct_expected() at the point of the error rather
 * than having a single function try to figure out the best type of error
 * message to print.
 *
 * @note A newline is _not_ printed since the error message will be appended to
 * by fl_elaborate_error().  For example, the parts of an error message are
 * printed by the functions shown:
 *
 *      42: syntax error: "int": "into" expected
 *      |--||----------||----------------------|
 *      |   |           |
 *      |   yyerror()   fl_elaborate_error()
 *      |
 *      print_loc()
 *
 * @param msg The error message to print.  Bison invariably passes `syntax
 * error`.
 *
 * @sa fl_elaborate_error()
 * @sa fl_keyword_expected()
 * @sa fl_punct_expected()
 * @sa print_loc()
 */
static void yyerror( char const *msg ) {
  assert( msg != NULL );

  c_loc_t const loc = lexer_loc();
  print_loc( &loc );

  color_start( stderr, sgr_error );
  EPUTS( msg );                         // no newline
  color_end( stderr, sgr_error );

  //
  // A syntax error has occurred, but syntax errors aren't fatal since Bison
  // tries to recover.  We'll clean-up the current parse, but YYABORT won't be
  // called so we won't bail out of parsing by returning from yyparse(); hence,
  // parsing will continue.
  //
  parse_cleanup( /*fatal_error=*/false );
}

/** @} */

///////////////////////////////////////////////////////////////////////////////

/// @cond DOXYGEN_IGNORE


#line 1151 "parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include  "parser.h" 
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_Y_cast = 3,                     /* Y_cast  */
  YYSYMBOL_Y_const_ENG = 4,                /* Y_const_ENG  */
  YYSYMBOL_Y_declare = 5,                  /* Y_declare  */
  YYSYMBOL_Y_define = 6,                   /* Y_define  */
  YYSYMBOL_Y_dynamic = 7,                  /* Y_dynamic  */
  YYSYMBOL_Y_explain = 8,                  /* Y_explain  */
  YYSYMBOL_Y_help = 9,                     /* Y_help  */
  YYSYMBOL_Y_no = 10,                      /* Y_no  */
  YYSYMBOL_Y_quit = 11,                    /* Y_quit  */
  YYSYMBOL_Y_reinterpret = 12,             /* Y_reinterpret  */
  YYSYMBOL_Y_set = 13,                     /* Y_set  */
  YYSYMBOL_Y_show = 14,                    /* Y_show  */
  YYSYMBOL_Y_aligned = 15,                 /* Y_aligned  */
  YYSYMBOL_Y_all = 16,                     /* Y_all  */
  YYSYMBOL_Y_array = 17,                   /* Y_array  */
  YYSYMBOL_Y_as = 18,                      /* Y_as  */
  YYSYMBOL_Y_bit = 19,                     /* Y_bit  */
  YYSYMBOL_Y_bit_precise = 20,             /* Y_bit_precise  */
  YYSYMBOL_Y_bits = 21,                    /* Y_bits  */
  YYSYMBOL_Y_by = 22,                      /* Y_by  */
  YYSYMBOL_Y_bytes = 23,                   /* Y_bytes  */
  YYSYMBOL_Y_capturing = 24,               /* Y_capturing  */
  YYSYMBOL_Y_commands = 25,                /* Y_commands  */
  YYSYMBOL_Y_constructor = 26,             /* Y_constructor  */
  YYSYMBOL_Y_conversion = 27,              /* Y_conversion  */
  YYSYMBOL_Y_copy = 28,                    /* Y_copy  */
  YYSYMBOL_Y_defined = 29,                 /* Y_defined  */
  YYSYMBOL_Y_destructor = 30,              /* Y_destructor  */
  YYSYMBOL_Y_english = 31,                 /* Y_english  */
  YYSYMBOL_Y_evaluation = 32,              /* Y_evaluation  */
  YYSYMBOL_Y_expression = 33,              /* Y_expression  */
  YYSYMBOL_Y_floating = 34,                /* Y_floating  */
  YYSYMBOL_Y_function = 35,                /* Y_function  */
  YYSYMBOL_Y_initialization = 36,          /* Y_initialization  */
  YYSYMBOL_Y_into = 37,                    /* Y_into  */
  YYSYMBOL_Y_lambda = 38,                  /* Y_lambda  */
  YYSYMBOL_Y_length = 39,                  /* Y_length  */
  YYSYMBOL_Y_linkage = 40,                 /* Y_linkage  */
  YYSYMBOL_Y_literal = 41,                 /* Y_literal  */
  YYSYMBOL_Y_member = 42,                  /* Y_member  */
  YYSYMBOL_Y_non_empty = 43,               /* Y_non_empty  */
  YYSYMBOL_Y_non_member = 44,              /* Y_non_member  */
  YYSYMBOL_Y_of = 45,                      /* Y_of  */
  YYSYMBOL_Y_options = 46,                 /* Y_options  */
  YYSYMBOL_Y_point = 47,                   /* Y_point  */
  YYSYMBOL_Y_pointer = 48,                 /* Y_pointer  */
  YYSYMBOL_Y_precise = 49,                 /* Y_precise  */
  YYSYMBOL_Y_precision = 50,               /* Y_precision  */
  YYSYMBOL_Y_predefined = 51,              /* Y_predefined  */
  YYSYMBOL_Y_pure = 52,                    /* Y_pure  */
  YYSYMBOL_Y_reference = 53,               /* Y_reference  */
  YYSYMBOL_Y_returning = 54,               /* Y_returning  */
  YYSYMBOL_Y_rvalue = 55,                  /* Y_rvalue  */
  YYSYMBOL_Y_scope = 56,                   /* Y_scope  */
  YYSYMBOL_Y_to = 57,                      /* Y_to  */
  YYSYMBOL_Y_user = 58,                    /* Y_user  */
  YYSYMBOL_Y_user_defined = 59,            /* Y_user_defined  */
  YYSYMBOL_Y_variable = 60,                /* Y_variable  */
  YYSYMBOL_Y_wide = 61,                    /* Y_wide  */
  YYSYMBOL_Y_width = 62,                   /* Y_width  */
  YYSYMBOL_Y_PREC_LESS_THAN_upc_layout_qualifier = 63, /* Y_PREC_LESS_THAN_upc_layout_qualifier  */
  YYSYMBOL_Y_COLON2 = 64,                  /* Y_COLON2  */
  YYSYMBOL_65_ = 65,                       /* "::"  */
  YYSYMBOL_Y_COLON2_STAR = 66,             /* Y_COLON2_STAR  */
  YYSYMBOL_67_ = 67,                       /* "::*"  */
  YYSYMBOL_Y_PLUS2 = 68,                   /* "++"  */
  YYSYMBOL_Y_MINUS2 = 69,                  /* "--"  */
  YYSYMBOL_70_ = 70,                       /* '('  */
  YYSYMBOL_71_ = 71,                       /* ')'  */
  YYSYMBOL_72_ = 72,                       /* '['  */
  YYSYMBOL_73_ = 73,                       /* ']'  */
  YYSYMBOL_74_ = 74,                       /* '.'  */
  YYSYMBOL_Y_ARROW = 75,                   /* Y_ARROW  */
  YYSYMBOL_76_ = 76,                       /* "->"  */
  YYSYMBOL_Y_AMPER = 77,                   /* Y_AMPER  */
  YYSYMBOL_78_ = 78,                       /* '*'  */
  YYSYMBOL_Y_EXCLAM = 79,                  /* Y_EXCLAM  */
  YYSYMBOL_Y_sizeof = 80,                  /* Y_sizeof  */
  YYSYMBOL_Y_TILDE = 81,                   /* Y_TILDE  */
  YYSYMBOL_Y_DOT_STAR = 82,                /* Y_DOT_STAR  */
  YYSYMBOL_83_ = 83,                       /* ".*"  */
  YYSYMBOL_Y_ARROW_STAR = 84,              /* Y_ARROW_STAR  */
  YYSYMBOL_85_ = 85,                       /* "->*"  */
  YYSYMBOL_86_ = 86,                       /* '/'  */
  YYSYMBOL_87_ = 87,                       /* '%'  */
  YYSYMBOL_88_ = 88,                       /* '-'  */
  YYSYMBOL_89_ = 89,                       /* '+'  */
  YYSYMBOL_Y_LESS2 = 90,                   /* Y_LESS2  */
  YYSYMBOL_91_ = 91,                       /* "<<"  */
  YYSYMBOL_Y_GREATER2 = 92,                /* Y_GREATER2  */
  YYSYMBOL_93_ = 93,                       /* ">>"  */
  YYSYMBOL_Y_LESS_EQUAL_GREATER = 94,      /* Y_LESS_EQUAL_GREATER  */
  YYSYMBOL_95_ = 95,                       /* "<=>"  */
  YYSYMBOL_96_ = 96,                       /* '<'  */
  YYSYMBOL_97_ = 97,                       /* '>'  */
  YYSYMBOL_Y_LESS_EQUAL = 98,              /* Y_LESS_EQUAL  */
  YYSYMBOL_99_ = 99,                       /* "<="  */
  YYSYMBOL_Y_GREATER_EQUAL = 100,          /* Y_GREATER_EQUAL  */
  YYSYMBOL_101_ = 101,                     /* ">="  */
  YYSYMBOL_Y_EQUAL2 = 102,                 /* Y_EQUAL2  */
  YYSYMBOL_103_ = 103,                     /* "=="  */
  YYSYMBOL_Y_EXCLAM_EQUAL = 104,           /* Y_EXCLAM_EQUAL  */
  YYSYMBOL_Y_bit_and = 105,                /* Y_bit_and  */
  YYSYMBOL_Y_CARET = 106,                  /* Y_CARET  */
  YYSYMBOL_Y_PIPE = 107,                   /* Y_PIPE  */
  YYSYMBOL_Y_AMPER2 = 108,                 /* Y_AMPER2  */
  YYSYMBOL_Y_PIPE2 = 109,                  /* Y_PIPE2  */
  YYSYMBOL_Y_QMARK_COLON = 110,            /* Y_QMARK_COLON  */
  YYSYMBOL_111_ = 111,                     /* "?:"  */
  YYSYMBOL_112_ = 112,                     /* '='  */
  YYSYMBOL_Y_PERCENT_EQUAL = 113,          /* Y_PERCENT_EQUAL  */
  YYSYMBOL_114_ = 114,                     /* "%="  */
  YYSYMBOL_Y_AMPER_EQUAL = 115,            /* Y_AMPER_EQUAL  */
  YYSYMBOL_Y_STAR_EQUAL = 116,             /* Y_STAR_EQUAL  */
  YYSYMBOL_117_ = 117,                     /* "*="  */
  YYSYMBOL_Y_PLUS_EQUAL = 118,             /* Y_PLUS_EQUAL  */
  YYSYMBOL_119_ = 119,                     /* "+="  */
  YYSYMBOL_Y_MINUS_EQUAL = 120,            /* Y_MINUS_EQUAL  */
  YYSYMBOL_121_ = 121,                     /* "-="  */
  YYSYMBOL_Y_SLASH_EQUAL = 122,            /* Y_SLASH_EQUAL  */
  YYSYMBOL_123_ = 123,                     /* "/="  */
  YYSYMBOL_Y_LESS2_EQUAL = 124,            /* Y_LESS2_EQUAL  */
  YYSYMBOL_125_ = 125,                     /* "<<="  */
  YYSYMBOL_Y_GREATER2_EQUAL = 126,         /* Y_GREATER2_EQUAL  */
  YYSYMBOL_127_ = 127,                     /* ">>="  */
  YYSYMBOL_Y_CARET_EQUAL = 128,            /* Y_CARET_EQUAL  */
  YYSYMBOL_Y_PIPE_EQUAL = 129,             /* Y_PIPE_EQUAL  */
  YYSYMBOL_130_ = 130,                     /* ','  */
  YYSYMBOL_Y_auto_STORAGE = 131,           /* Y_auto_STORAGE  */
  YYSYMBOL_Y_break = 132,                  /* Y_break  */
  YYSYMBOL_Y_case = 133,                   /* Y_case  */
  YYSYMBOL_Y_char = 134,                   /* Y_char  */
  YYSYMBOL_Y_continue = 135,               /* Y_continue  */
  YYSYMBOL_Y_default = 136,                /* Y_default  */
  YYSYMBOL_Y_do = 137,                     /* Y_do  */
  YYSYMBOL_Y_double = 138,                 /* Y_double  */
  YYSYMBOL_Y_else = 139,                   /* Y_else  */
  YYSYMBOL_Y_extern = 140,                 /* Y_extern  */
  YYSYMBOL_Y_float = 141,                  /* Y_float  */
  YYSYMBOL_Y_for = 142,                    /* Y_for  */
  YYSYMBOL_Y_goto = 143,                   /* Y_goto  */
  YYSYMBOL_Y_if = 144,                     /* Y_if  */
  YYSYMBOL_Y_int = 145,                    /* Y_int  */
  YYSYMBOL_Y_long = 146,                   /* Y_long  */
  YYSYMBOL_Y_register = 147,               /* Y_register  */
  YYSYMBOL_Y_return = 148,                 /* Y_return  */
  YYSYMBOL_Y_short = 149,                  /* Y_short  */
  YYSYMBOL_Y_static = 150,                 /* Y_static  */
  YYSYMBOL_Y_struct = 151,                 /* Y_struct  */
  YYSYMBOL_Y_switch = 152,                 /* Y_switch  */
  YYSYMBOL_Y_typedef = 153,                /* Y_typedef  */
  YYSYMBOL_Y_union = 154,                  /* Y_union  */
  YYSYMBOL_Y_unsigned = 155,               /* Y_unsigned  */
  YYSYMBOL_Y_while = 156,                  /* Y_while  */
  YYSYMBOL_Y_asm = 157,                    /* Y_asm  */
  YYSYMBOL_Y_const = 158,                  /* Y_const  */
  YYSYMBOL_Y_ELLIPSIS = 159,               /* "..."  */
  YYSYMBOL_Y_enum = 160,                   /* Y_enum  */
  YYSYMBOL_Y_signed = 161,                 /* Y_signed  */
  YYSYMBOL_Y_void = 162,                   /* Y_void  */
  YYSYMBOL_Y_volatile = 163,               /* Y_volatile  */
  YYSYMBOL_Y_wchar_t = 164,                /* Y_wchar_t  */
  YYSYMBOL_Y__Bool = 165,                  /* Y__Bool  */
  YYSYMBOL_Y__Complex = 166,               /* Y__Complex  */
  YYSYMBOL_Y__Imaginary = 167,             /* Y__Imaginary  */
  YYSYMBOL_Y_inline = 168,                 /* Y_inline  */
  YYSYMBOL_Y_restrict = 169,               /* Y_restrict  */
  YYSYMBOL_Y__Alignas = 170,               /* Y__Alignas  */
  YYSYMBOL_Y__Alignof = 171,               /* Y__Alignof  */
  YYSYMBOL_Y__Atomic_QUAL = 172,           /* Y__Atomic_QUAL  */
  YYSYMBOL_Y__Atomic_SPEC = 173,           /* Y__Atomic_SPEC  */
  YYSYMBOL_Y__Generic = 174,               /* Y__Generic  */
  YYSYMBOL_Y__Noreturn = 175,              /* Y__Noreturn  */
  YYSYMBOL_Y__Static_assert = 176,         /* Y__Static_assert  */
  YYSYMBOL_Y__Thread_local = 177,          /* Y__Thread_local  */
  YYSYMBOL_Y_thread = 178,                 /* Y_thread  */
  YYSYMBOL_Y_local = 179,                  /* Y_local  */
  YYSYMBOL_Y_bool = 180,                   /* Y_bool  */
  YYSYMBOL_Y_catch = 181,                  /* Y_catch  */
  YYSYMBOL_Y_class = 182,                  /* Y_class  */
  YYSYMBOL_Y_const_cast = 183,             /* Y_const_cast  */
  YYSYMBOL_Y_CONSTRUCTOR_SNAME = 184,      /* Y_CONSTRUCTOR_SNAME  */
  YYSYMBOL_Y_delete = 185,                 /* Y_delete  */
  YYSYMBOL_Y_DESTRUCTOR_SNAME = 186,       /* Y_DESTRUCTOR_SNAME  */
  YYSYMBOL_Y_dynamic_cast = 187,           /* Y_dynamic_cast  */
  YYSYMBOL_Y_explicit = 188,               /* Y_explicit  */
  YYSYMBOL_Y_false = 189,                  /* Y_false  */
  YYSYMBOL_Y_friend = 190,                 /* Y_friend  */
  YYSYMBOL_Y_mutable = 191,                /* Y_mutable  */
  YYSYMBOL_Y_namespace = 192,              /* Y_namespace  */
  YYSYMBOL_Y_new = 193,                    /* Y_new  */
  YYSYMBOL_Y_operator = 194,               /* Y_operator  */
  YYSYMBOL_Y_OPERATOR_SNAME = 195,         /* Y_OPERATOR_SNAME  */
  YYSYMBOL_Y_private = 196,                /* Y_private  */
  YYSYMBOL_Y_protected = 197,              /* Y_protected  */
  YYSYMBOL_Y_public = 198,                 /* Y_public  */
  YYSYMBOL_Y_reinterpret_cast = 199,       /* Y_reinterpret_cast  */
  YYSYMBOL_Y_static_cast = 200,            /* Y_static_cast  */
  YYSYMBOL_Y_template = 201,               /* Y_template  */
  YYSYMBOL_Y_this = 202,                   /* Y_this  */
  YYSYMBOL_Y_throw = 203,                  /* Y_throw  */
  YYSYMBOL_Y_true = 204,                   /* Y_true  */
  YYSYMBOL_Y_try = 205,                    /* Y_try  */
  YYSYMBOL_Y_typeid = 206,                 /* Y_typeid  */
  YYSYMBOL_Y_typename = 207,               /* Y_typename  */
  YYSYMBOL_Y_using = 208,                  /* Y_using  */
  YYSYMBOL_Y_virtual = 209,                /* Y_virtual  */
  YYSYMBOL_Y_char16_t = 210,               /* Y_char16_t  */
  YYSYMBOL_Y_char32_t = 211,               /* Y_char32_t  */
  YYSYMBOL_Y__BitInt = 212,                /* Y__BitInt  */
  YYSYMBOL_Y_reproducible = 213,           /* Y_reproducible  */
  YYSYMBOL_Y_typeof = 214,                 /* Y_typeof  */
  YYSYMBOL_Y_typeof_unqual = 215,          /* Y_typeof_unqual  */
  YYSYMBOL_Y_unsequenced = 216,            /* Y_unsequenced  */
  YYSYMBOL_Y_ATTR_BEGIN = 217,             /* Y_ATTR_BEGIN  */
  YYSYMBOL_Y_alignas = 218,                /* Y_alignas  */
  YYSYMBOL_Y_alignof = 219,                /* Y_alignof  */
  YYSYMBOL_Y_auto_TYPE = 220,              /* Y_auto_TYPE  */
  YYSYMBOL_Y_carries = 221,                /* Y_carries  */
  YYSYMBOL_Y_dependency = 222,             /* Y_dependency  */
  YYSYMBOL_Y_carries_dependency = 223,     /* Y_carries_dependency  */
  YYSYMBOL_Y_constexpr = 224,              /* Y_constexpr  */
  YYSYMBOL_Y_decltype = 225,               /* Y_decltype  */
  YYSYMBOL_Y_except = 226,                 /* Y_except  */
  YYSYMBOL_Y_final = 227,                  /* Y_final  */
  YYSYMBOL_Y_noexcept = 228,               /* Y_noexcept  */
  YYSYMBOL_Y_nullptr = 229,                /* Y_nullptr  */
  YYSYMBOL_Y_override = 230,               /* Y_override  */
  YYSYMBOL_Y_QUOTE2 = 231,                 /* Y_QUOTE2  */
  YYSYMBOL_Y_static_assert = 232,          /* Y_static_assert  */
  YYSYMBOL_Y_thread_local = 233,           /* Y_thread_local  */
  YYSYMBOL_Y_deprecated = 234,             /* Y_deprecated  */
  YYSYMBOL_Y_discard = 235,                /* Y_discard  */
  YYSYMBOL_Y_maybe_unused = 236,           /* Y_maybe_unused  */
  YYSYMBOL_Y_maybe = 237,                  /* Y_maybe  */
  YYSYMBOL_Y_unused = 238,                 /* Y_unused  */
  YYSYMBOL_Y_nodiscard = 239,              /* Y_nodiscard  */
  YYSYMBOL_Y_noreturn = 240,               /* Y_noreturn  */
  YYSYMBOL_Y_char8_t = 241,                /* Y_char8_t  */
  YYSYMBOL_Y_address = 242,                /* Y_address  */
  YYSYMBOL_Y_concept = 243,                /* Y_concept  */
  YYSYMBOL_Y_consteval = 244,              /* Y_consteval  */
  YYSYMBOL_Y_constinit = 245,              /* Y_constinit  */
  YYSYMBOL_Y_co_await = 246,               /* Y_co_await  */
  YYSYMBOL_Y_co_return = 247,              /* Y_co_return  */
  YYSYMBOL_Y_co_yield = 248,               /* Y_co_yield  */
  YYSYMBOL_Y_export = 249,                 /* Y_export  */
  YYSYMBOL_Y_no_unique_address = 250,      /* Y_no_unique_address  */
  YYSYMBOL_Y_requires = 251,               /* Y_requires  */
  YYSYMBOL_Y_unique = 252,                 /* Y_unique  */
  YYSYMBOL_Y_EMC__Accum = 253,             /* Y_EMC__Accum  */
  YYSYMBOL_Y_EMC__Fract = 254,             /* Y_EMC__Fract  */
  YYSYMBOL_Y_EMC__Sat = 255,               /* Y_EMC__Sat  */
  YYSYMBOL_Y_UPC_relaxed = 256,            /* Y_UPC_relaxed  */
  YYSYMBOL_Y_UPC_shared = 257,             /* Y_UPC_shared  */
  YYSYMBOL_Y_UPC_strict = 258,             /* Y_UPC_strict  */
  YYSYMBOL_Y_GNU___attribute__ = 259,      /* Y_GNU___attribute__  */
  YYSYMBOL_Y_GNU___restrict = 260,         /* Y_GNU___restrict  */
  YYSYMBOL_Y_Apple___block = 261,          /* Y_Apple___block  */
  YYSYMBOL_Y_Apple_block = 262,            /* Y_Apple_block  */
  YYSYMBOL_Y_MSC___cdecl = 263,            /* Y_MSC___cdecl  */
  YYSYMBOL_Y_MSC___clrcall = 264,          /* Y_MSC___clrcall  */
  YYSYMBOL_Y_MSC___declspec = 265,         /* Y_MSC___declspec  */
  YYSYMBOL_Y_MSC___fastcall = 266,         /* Y_MSC___fastcall  */
  YYSYMBOL_Y_MSC___stdcall = 267,          /* Y_MSC___stdcall  */
  YYSYMBOL_Y_MSC___thiscall = 268,         /* Y_MSC___thiscall  */
  YYSYMBOL_Y_MSC___vectorcall = 269,       /* Y_MSC___vectorcall  */
  YYSYMBOL_270_ = 270,                     /* ':'  */
  YYSYMBOL_271_ = 271,                     /* ';'  */
  YYSYMBOL_272_ = 272,                     /* '{'  */
  YYSYMBOL_273_ = 273,                     /* '}'  */
  YYSYMBOL_Y_CHAR_LIT = 274,               /* Y_CHAR_LIT  */
  YYSYMBOL_Y_END = 275,                    /* Y_END  */
  YYSYMBOL_Y_ERROR = 276,                  /* Y_ERROR  */
  YYSYMBOL_Y_GLOB = 277,                   /* Y_GLOB  */
  YYSYMBOL_Y_INT_LIT = 278,                /* Y_INT_LIT  */
  YYSYMBOL_Y_NAME = 279,                   /* Y_NAME  */
  YYSYMBOL_Y_SET_OPTION = 280,             /* Y_SET_OPTION  */
  YYSYMBOL_Y_STR_LIT = 281,                /* Y_STR_LIT  */
  YYSYMBOL_Y_TYPEDEF_NAME = 282,           /* Y_TYPEDEF_NAME  */
  YYSYMBOL_Y_TYPEDEF_SNAME = 283,          /* Y_TYPEDEF_SNAME  */
  YYSYMBOL_Y_LEXER_ERROR = 284,            /* Y_LEXER_ERROR  */
  YYSYMBOL_YYACCEPT = 285,                 /* $accept  */
  YYSYMBOL_command_list = 286,             /* command_list  */
  YYSYMBOL_command = 287,                  /* command  */
  YYSYMBOL_cast_command = 288,             /* cast_command  */
  YYSYMBOL_new_style_cast_english = 289,   /* new_style_cast_english  */
  YYSYMBOL_declare_command = 290,          /* declare_command  */
  YYSYMBOL_291_1 = 291,                    /* $@1  */
  YYSYMBOL_alignas_or_width_decl_english_ast = 292, /* alignas_or_width_decl_english_ast  */
  YYSYMBOL_alignas_specifier_english = 293, /* alignas_specifier_english  */
  YYSYMBOL_aligned_english = 294,          /* aligned_english  */
  YYSYMBOL_capturing_paren_capture_decl_list_english_opt = 295, /* capturing_paren_capture_decl_list_english_opt  */
  YYSYMBOL_paren_capture_decl_list_english = 296, /* paren_capture_decl_list_english  */
  YYSYMBOL_capture_decl_list_english_opt = 297, /* capture_decl_list_english_opt  */
  YYSYMBOL_capture_decl_list_english = 298, /* capture_decl_list_english  */
  YYSYMBOL_capture_decl_english_ast = 299, /* capture_decl_english_ast  */
  YYSYMBOL_capture_default_opt = 300,      /* capture_default_opt  */
  YYSYMBOL_width_specifier_english_uint = 301, /* width_specifier_english_uint  */
  YYSYMBOL_storage_class_subset_english_type_opt = 302, /* storage_class_subset_english_type_opt  */
  YYSYMBOL_storage_class_subset_english_type = 303, /* storage_class_subset_english_type  */
  YYSYMBOL_storage_class_subset_english_stid = 304, /* storage_class_subset_english_stid  */
  YYSYMBOL_define_command = 305,           /* define_command  */
  YYSYMBOL_explain_command = 306,          /* explain_command  */
  YYSYMBOL_307_2 = 307,                    /* $@2  */
  YYSYMBOL_explain = 308,                  /* explain  */
  YYSYMBOL_help_command = 309,             /* help_command  */
  YYSYMBOL_help_what_opt = 310,            /* help_what_opt  */
  YYSYMBOL_quit_command = 311,             /* quit_command  */
  YYSYMBOL_scoped_command = 312,           /* scoped_command  */
  YYSYMBOL_set_command = 313,              /* set_command  */
  YYSYMBOL_set_option_list = 314,          /* set_option_list  */
  YYSYMBOL_set_option = 315,               /* set_option  */
  YYSYMBOL_set_option_value_opt = 316,     /* set_option_value_opt  */
  YYSYMBOL_show_command = 317,             /* show_command  */
  YYSYMBOL_show_format = 318,              /* show_format  */
  YYSYMBOL_show_format_exp = 319,          /* show_format_exp  */
  YYSYMBOL_show_format_opt = 320,          /* show_format_opt  */
  YYSYMBOL_show_which_types_flags_opt = 321, /* show_which_types_flags_opt  */
  YYSYMBOL_predefined_or_user_flags_opt = 322, /* predefined_or_user_flags_opt  */
  YYSYMBOL_template_command = 323,         /* template_command  */
  YYSYMBOL_typedef_command = 324,          /* typedef_command  */
  YYSYMBOL_using_command = 325,            /* using_command  */
  YYSYMBOL_c_style_cast_expr_c = 326,      /* c_style_cast_expr_c  */
  YYSYMBOL_327_3 = 327,                    /* $@3  */
  YYSYMBOL_new_style_cast_expr_c = 328,    /* new_style_cast_expr_c  */
  YYSYMBOL_329_4 = 329,                    /* $@4  */
  YYSYMBOL_new_style_cast_c = 330,         /* new_style_cast_c  */
  YYSYMBOL_aligned_declaration_c = 331,    /* aligned_declaration_c  */
  YYSYMBOL_332_5 = 332,                    /* $@5  */
  YYSYMBOL_333_6 = 333,                    /* $@6  */
  YYSYMBOL_alignas_specifier_c = 334,      /* alignas_specifier_c  */
  YYSYMBOL_335_7 = 335,                    /* $@7  */
  YYSYMBOL_alignas = 336,                  /* alignas  */
  YYSYMBOL_asm_declaration_c = 337,        /* asm_declaration_c  */
  YYSYMBOL_scoped_declaration_c = 338,     /* scoped_declaration_c  */
  YYSYMBOL_class_struct_union_declaration_c = 339, /* class_struct_union_declaration_c  */
  YYSYMBOL_340_8 = 340,                    /* $@8  */
  YYSYMBOL_341_9 = 341,                    /* $@9  */
  YYSYMBOL_enum_declaration_c = 342,       /* enum_declaration_c  */
  YYSYMBOL_343_10 = 343,                   /* $@10  */
  YYSYMBOL_namespace_declaration_c = 344,  /* namespace_declaration_c  */
  YYSYMBOL_345_11 = 345,                   /* $@11  */
  YYSYMBOL_346_12 = 346,                   /* $@12  */
  YYSYMBOL_namespace_sname_c_exp = 347,    /* namespace_sname_c_exp  */
  YYSYMBOL_namespace_sname_c = 348,        /* namespace_sname_c  */
  YYSYMBOL_namespace_typedef_sname_c = 349, /* namespace_typedef_sname_c  */
  YYSYMBOL_brace_in_scope_declaration_c_exp = 350, /* brace_in_scope_declaration_c_exp  */
  YYSYMBOL_brace_in_scope_declaration_c_opt = 351, /* brace_in_scope_declaration_c_opt  */
  YYSYMBOL_brace_in_scope_declaration_c = 352, /* brace_in_scope_declaration_c  */
  YYSYMBOL_in_scope_declaration_c_exp = 353, /* in_scope_declaration_c_exp  */
  YYSYMBOL_lambda_declaration_c = 354,     /* lambda_declaration_c  */
  YYSYMBOL_capture_decl_list_c_opt = 355,  /* capture_decl_list_c_opt  */
  YYSYMBOL_capture_decl_list_c = 356,      /* capture_decl_list_c  */
  YYSYMBOL_capture_decl_c_ast = 357,       /* capture_decl_c_ast  */
  YYSYMBOL_lambda_param_c_ast_list_opt = 358, /* lambda_param_c_ast_list_opt  */
  YYSYMBOL_lambda_return_type_c_ast_opt = 359, /* lambda_return_type_c_ast_opt  */
  YYSYMBOL_360_13 = 360,                   /* $@13  */
  YYSYMBOL_template_declaration_c = 361,   /* template_declaration_c  */
  YYSYMBOL_typed_declaration_c = 362,      /* typed_declaration_c  */
  YYSYMBOL_363_14 = 363,                   /* $@14  */
  YYSYMBOL_typedef_declaration_c = 364,    /* typedef_declaration_c  */
  YYSYMBOL_365_15 = 365,                   /* $@15  */
  YYSYMBOL_366_16 = 366,                   /* $@16  */
  YYSYMBOL_typedef_decl_list_c = 367,      /* typedef_decl_list_c  */
  YYSYMBOL_368_17 = 368,                   /* $@17  */
  YYSYMBOL_typedef_decl_c = 369,           /* typedef_decl_c  */
  YYSYMBOL_typedef_decl_c_exp = 370,       /* typedef_decl_c_exp  */
  YYSYMBOL_user_defined_conversion_declaration_c = 371, /* user_defined_conversion_declaration_c  */
  YYSYMBOL_using_declaration_c = 372,      /* using_declaration_c  */
  YYSYMBOL_using_decl_c_ast = 373,         /* using_decl_c_ast  */
  YYSYMBOL_374_18 = 374,                   /* $@18  */
  YYSYMBOL_375_19 = 375,                   /* $@19  */
  YYSYMBOL_decl_list_c_opt = 376,          /* decl_list_c_opt  */
  YYSYMBOL_decl_list_c = 377,              /* decl_list_c  */
  YYSYMBOL_decl_c = 378,                   /* decl_c  */
  YYSYMBOL_decl_c_exp = 379,               /* decl_c_exp  */
  YYSYMBOL_decl_c_astp = 380,              /* decl_c_astp  */
  YYSYMBOL_msc_calling_convention_c_astp = 381, /* msc_calling_convention_c_astp  */
  YYSYMBOL_decl2_c_astp = 382,             /* decl2_c_astp  */
  YYSYMBOL_array_decl_c_astp = 383,        /* array_decl_c_astp  */
  YYSYMBOL_array_size_c_ast = 384,         /* array_size_c_ast  */
  YYSYMBOL_block_decl_c_astp = 385,        /* block_decl_c_astp  */
  YYSYMBOL_386_20 = 386,                   /* $@20  */
  YYSYMBOL_destructor_declaration_c = 387, /* destructor_declaration_c  */
  YYSYMBOL_file_scope_constructor_declaration_c = 388, /* file_scope_constructor_declaration_c  */
  YYSYMBOL_file_scope_destructor_declaration_c = 389, /* file_scope_destructor_declaration_c  */
  YYSYMBOL_func_decl_c_astp = 390,         /* func_decl_c_astp  */
  YYSYMBOL_pc99_func_or_constructor_declaration_c = 391, /* pc99_func_or_constructor_declaration_c  */
  YYSYMBOL_392_21 = 392,                   /* $@21  */
  YYSYMBOL_rparen_func_qualifier_list_c_stid_opt = 393, /* rparen_func_qualifier_list_c_stid_opt  */
  YYSYMBOL_394_22 = 394,                   /* $@22  */
  YYSYMBOL_func_qualifier_list_c_stid_opt = 395, /* func_qualifier_list_c_stid_opt  */
  YYSYMBOL_func_qualifier_c_stid = 396,    /* func_qualifier_c_stid  */
  YYSYMBOL_func_ref_qualifier_c_stid_opt = 397, /* func_ref_qualifier_c_stid_opt  */
  YYSYMBOL_noexcept_c_stid_opt = 398,      /* noexcept_c_stid_opt  */
  YYSYMBOL_noexcept_bool_stid_exp = 399,   /* noexcept_bool_stid_exp  */
  YYSYMBOL_trailing_return_type_c_ast_opt = 400, /* trailing_return_type_c_ast_opt  */
  YYSYMBOL_401_23 = 401,                   /* $@23  */
  YYSYMBOL_func_equals_c_stid_opt = 402,   /* func_equals_c_stid_opt  */
  YYSYMBOL_param_c_ast_list_exp = 403,     /* param_c_ast_list_exp  */
  YYSYMBOL_param_c_ast_list_opt = 404,     /* param_c_ast_list_opt  */
  YYSYMBOL_param_c_ast_list = 405,         /* param_c_ast_list  */
  YYSYMBOL_param_c_ast = 406,              /* param_c_ast  */
  YYSYMBOL_407_24 = 407,                   /* $@24  */
  YYSYMBOL_param_c_ast_exp = 408,          /* param_c_ast_exp  */
  YYSYMBOL_nested_decl_c_astp = 409,       /* nested_decl_c_astp  */
  YYSYMBOL_410_25 = 410,                   /* $@25  */
  YYSYMBOL_oper_decl_c_astp = 411,         /* oper_decl_c_astp  */
  YYSYMBOL_pointer_decl_c_astp = 412,      /* pointer_decl_c_astp  */
  YYSYMBOL_413_26 = 413,                   /* $@26  */
  YYSYMBOL_pointer_type_c_ast = 414,       /* pointer_type_c_ast  */
  YYSYMBOL_pc99_pointer_decl_list_c = 415, /* pc99_pointer_decl_list_c  */
  YYSYMBOL_pc99_pointer_decl_c = 416,      /* pc99_pointer_decl_c  */
  YYSYMBOL_417_27 = 417,                   /* $@27  */
  YYSYMBOL_pc99_pointer_type_c_ast = 418,  /* pc99_pointer_type_c_ast  */
  YYSYMBOL_pointer_to_member_decl_c_astp = 419, /* pointer_to_member_decl_c_astp  */
  YYSYMBOL_420_28 = 420,                   /* $@28  */
  YYSYMBOL_pointer_to_member_type_c_ast = 421, /* pointer_to_member_type_c_ast  */
  YYSYMBOL_reference_decl_c_astp = 422,    /* reference_decl_c_astp  */
  YYSYMBOL_423_29 = 423,                   /* $@29  */
  YYSYMBOL_reference_type_c_ast = 424,     /* reference_type_c_ast  */
  YYSYMBOL_typedef_type_decl_c_ast = 425,  /* typedef_type_decl_c_ast  */
  YYSYMBOL_user_defined_conversion_decl_c_astp = 426, /* user_defined_conversion_decl_c_astp  */
  YYSYMBOL_427_30 = 427,                   /* $@30  */
  YYSYMBOL_user_defined_literal_decl_c_astp = 428, /* user_defined_literal_decl_c_astp  */
  YYSYMBOL_cast_c_astp_opt = 429,          /* cast_c_astp_opt  */
  YYSYMBOL_cast_c_astp = 430,              /* cast_c_astp  */
  YYSYMBOL_cast2_c_astp = 431,             /* cast2_c_astp  */
  YYSYMBOL_array_cast_c_astp = 432,        /* array_cast_c_astp  */
  YYSYMBOL_block_cast_c_astp = 433,        /* block_cast_c_astp  */
  YYSYMBOL_434_31 = 434,                   /* $@31  */
  YYSYMBOL_func_cast_c_astp = 435,         /* func_cast_c_astp  */
  YYSYMBOL_nested_cast_c_astp = 436,       /* nested_cast_c_astp  */
  YYSYMBOL_437_32 = 437,                   /* $@32  */
  YYSYMBOL_pointer_cast_c_astp = 438,      /* pointer_cast_c_astp  */
  YYSYMBOL_439_33 = 439,                   /* $@33  */
  YYSYMBOL_pointer_to_member_cast_c_astp = 440, /* pointer_to_member_cast_c_astp  */
  YYSYMBOL_441_34 = 441,                   /* $@34  */
  YYSYMBOL_reference_cast_c_astp = 442,    /* reference_cast_c_astp  */
  YYSYMBOL_443_35 = 443,                   /* $@35  */
  YYSYMBOL_udc_decl_c_ast_opt = 444,       /* udc_decl_c_ast_opt  */
  YYSYMBOL_udc_decl_c_ast = 445,           /* udc_decl_c_ast  */
  YYSYMBOL_pointer_udc_decl_c_ast = 446,   /* pointer_udc_decl_c_ast  */
  YYSYMBOL_447_36 = 447,                   /* $@36  */
  YYSYMBOL_pointer_to_member_udc_decl_c_ast = 448, /* pointer_to_member_udc_decl_c_ast  */
  YYSYMBOL_449_37 = 449,                   /* $@37  */
  YYSYMBOL_reference_udc_decl_c_ast = 450, /* reference_udc_decl_c_ast  */
  YYSYMBOL_451_38 = 451,                   /* $@38  */
  YYSYMBOL_type_c_ast = 452,               /* type_c_ast  */
  YYSYMBOL_type_modifier_list_c_type_opt = 453, /* type_modifier_list_c_type_opt  */
  YYSYMBOL_type_modifier_list_c_type = 454, /* type_modifier_list_c_type  */
  YYSYMBOL_type_modifier_c_type = 455,     /* type_modifier_c_type  */
  YYSYMBOL_type_modifier_base_type = 456,  /* type_modifier_base_type  */
  YYSYMBOL_east_modified_type_c_ast = 457, /* east_modified_type_c_ast  */
  YYSYMBOL_atomic_builtin_typedef_type_c_ast = 458, /* atomic_builtin_typedef_type_c_ast  */
  YYSYMBOL_atomic_specifier_type_c_ast = 459, /* atomic_specifier_type_c_ast  */
  YYSYMBOL_460_39 = 460,                   /* $@39  */
  YYSYMBOL_builtin_type_c_ast = 461,       /* builtin_type_c_ast  */
  YYSYMBOL_builtin_no_BitInt_c_btid = 462, /* builtin_no_BitInt_c_btid  */
  YYSYMBOL_typeof_type_c_ast = 463,        /* typeof_type_c_ast  */
  YYSYMBOL_typeof = 464,                   /* typeof  */
  YYSYMBOL_enum_class_struct_union_c_ast = 465, /* enum_class_struct_union_c_ast  */
  YYSYMBOL_class_struct_union_c_ast = 466, /* class_struct_union_c_ast  */
  YYSYMBOL_enum_c_ast = 467,               /* enum_c_ast  */
  YYSYMBOL_enum_btids = 468,               /* enum_btids  */
  YYSYMBOL_enum_fixed_type_c_ast_opt = 469, /* enum_fixed_type_c_ast_opt  */
  YYSYMBOL_enum_fixed_type_c_ast = 470,    /* enum_fixed_type_c_ast  */
  YYSYMBOL_enum_fixed_type_modifier_list_btid_opt = 471, /* enum_fixed_type_modifier_list_btid_opt  */
  YYSYMBOL_enum_fixed_type_modifier_list_btid = 472, /* enum_fixed_type_modifier_list_btid  */
  YYSYMBOL_enum_fixed_type_modifier_btid = 473, /* enum_fixed_type_modifier_btid  */
  YYSYMBOL_enum_unmodified_fixed_type_c_ast = 474, /* enum_unmodified_fixed_type_c_ast  */
  YYSYMBOL_class_struct_btid_opt = 475,    /* class_struct_btid_opt  */
  YYSYMBOL_class_struct_btid = 476,        /* class_struct_btid  */
  YYSYMBOL_class_struct_union_btid = 477,  /* class_struct_union_btid  */
  YYSYMBOL_type_qualifier_list_c_stid_opt = 478, /* type_qualifier_list_c_stid_opt  */
  YYSYMBOL_type_qualifier_list_c_stid = 479, /* type_qualifier_list_c_stid  */
  YYSYMBOL_type_qualifier_c_stid = 480,    /* type_qualifier_c_stid  */
  YYSYMBOL_cv_qualifier_stid = 481,        /* cv_qualifier_stid  */
  YYSYMBOL_cv_qualifier_list_stid_opt = 482, /* cv_qualifier_list_stid_opt  */
  YYSYMBOL_restrict_qualifier_c_stid = 483, /* restrict_qualifier_c_stid  */
  YYSYMBOL_upc_layout_qualifier_c = 484,   /* upc_layout_qualifier_c  */
  YYSYMBOL_storage_class_c_type = 485,     /* storage_class_c_type  */
  YYSYMBOL__Noreturn_atid = 486,           /* _Noreturn_atid  */
  YYSYMBOL_attribute_specifier_list_c_atid_opt = 487, /* attribute_specifier_list_c_atid_opt  */
  YYSYMBOL_attribute_specifier_list_c_atid = 488, /* attribute_specifier_list_c_atid  */
  YYSYMBOL_489_40 = 489,                   /* $@40  */
  YYSYMBOL_using_opt = 490,                /* using_opt  */
  YYSYMBOL_attribute_list_c_atid_opt = 491, /* attribute_list_c_atid_opt  */
  YYSYMBOL_attribute_list_c_atid = 492,    /* attribute_list_c_atid  */
  YYSYMBOL_attribute_c_atid_exp = 493,     /* attribute_c_atid_exp  */
  YYSYMBOL_attribute_str_arg_c_opt = 494,  /* attribute_str_arg_c_opt  */
  YYSYMBOL_gnu_or_msc_attribute_specifier_list_c_opt = 495, /* gnu_or_msc_attribute_specifier_list_c_opt  */
  YYSYMBOL_gnu_or_msc_attribute_specifier_list_c = 496, /* gnu_or_msc_attribute_specifier_list_c  */
  YYSYMBOL_gnu_attribute_specifier_list_c_opt = 497, /* gnu_attribute_specifier_list_c_opt  */
  YYSYMBOL_gnu_attribute_specifier_list_c = 498, /* gnu_attribute_specifier_list_c  */
  YYSYMBOL_gnu_attribute_specifier_c = 499, /* gnu_attribute_specifier_c  */
  YYSYMBOL_500_41 = 500,                   /* $@41  */
  YYSYMBOL_gnu_attribute_list_c_opt = 501, /* gnu_attribute_list_c_opt  */
  YYSYMBOL_gnu_attribuet_list_c = 502,     /* gnu_attribuet_list_c  */
  YYSYMBOL_gnu_attribute_c_exp = 503,      /* gnu_attribute_c_exp  */
  YYSYMBOL_gnu_attribute_decl_arg_list_c_opt = 504, /* gnu_attribute_decl_arg_list_c_opt  */
  YYSYMBOL_gnu_attribute_arg_list_c_opt = 505, /* gnu_attribute_arg_list_c_opt  */
  YYSYMBOL_gnu_attribute_arg_list_c = 506, /* gnu_attribute_arg_list_c  */
  YYSYMBOL_gnu_attribute_arg_c = 507,      /* gnu_attribute_arg_c  */
  YYSYMBOL_msc_attribute_specifier_list_c = 508, /* msc_attribute_specifier_list_c  */
  YYSYMBOL_msc_attribute_specifier_c = 509, /* msc_attribute_specifier_c  */
  YYSYMBOL_510_42 = 510,                   /* $@42  */
  YYSYMBOL_msc_attribute_list_c_opt = 511, /* msc_attribute_list_c_opt  */
  YYSYMBOL_msc_attribuet_list_c = 512,     /* msc_attribuet_list_c  */
  YYSYMBOL_decl_english_ast = 513,         /* decl_english_ast  */
  YYSYMBOL_array_decl_english_ast = 514,   /* array_decl_english_ast  */
  YYSYMBOL_array_size_decl_ast = 515,      /* array_size_decl_ast  */
  YYSYMBOL_length_opt = 516,               /* length_opt  */
  YYSYMBOL_block_decl_english_ast = 517,   /* block_decl_english_ast  */
  YYSYMBOL_constructor_decl_english_ast = 518, /* constructor_decl_english_ast  */
  YYSYMBOL_destructor_decl_english_ast = 519, /* destructor_decl_english_ast  */
  YYSYMBOL_parens_opt = 520,               /* parens_opt  */
  YYSYMBOL_func_decl_english_ast = 521,    /* func_decl_english_ast  */
  YYSYMBOL_func_qualifier_english_type_opt = 522, /* func_qualifier_english_type_opt  */
  YYSYMBOL_msc_calling_convention_atid = 523, /* msc_calling_convention_atid  */
  YYSYMBOL_oper_decl_english_ast = 524,    /* oper_decl_english_ast  */
  YYSYMBOL_paren_param_decl_list_english_opt = 525, /* paren_param_decl_list_english_opt  */
  YYSYMBOL_paren_param_decl_list_english = 526, /* paren_param_decl_list_english  */
  YYSYMBOL_param_decl_list_english_opt = 527, /* param_decl_list_english_opt  */
  YYSYMBOL_param_decl_list_english = 528,  /* param_decl_list_english  */
  YYSYMBOL_decl_english_ast_exp = 529,     /* decl_english_ast_exp  */
  YYSYMBOL_ref_qualifier_english_stid_opt = 530, /* ref_qualifier_english_stid_opt  */
  YYSYMBOL_returning_english_ast_opt = 531, /* returning_english_ast_opt  */
  YYSYMBOL_returning_english_ast = 532,    /* returning_english_ast  */
  YYSYMBOL_qualified_decl_english_ast = 533, /* qualified_decl_english_ast  */
  YYSYMBOL_type_qualifier_list_english_type_opt = 534, /* type_qualifier_list_english_type_opt  */
  YYSYMBOL_type_qualifier_list_english_type = 535, /* type_qualifier_list_english_type  */
  YYSYMBOL_type_qualifier_english_type = 536, /* type_qualifier_english_type  */
  YYSYMBOL_attribute_english_atid = 537,   /* attribute_english_atid  */
  YYSYMBOL_storage_class_english_stid = 538, /* storage_class_english_stid  */
  YYSYMBOL_eval_expr_init_stid = 539,      /* eval_expr_init_stid  */
  YYSYMBOL_linkage_stid = 540,             /* linkage_stid  */
  YYSYMBOL_linkage_opt = 541,              /* linkage_opt  */
  YYSYMBOL_type_qualifier_english_stid = 542, /* type_qualifier_english_stid  */
  YYSYMBOL_upc_layout_qualifier_english = 543, /* upc_layout_qualifier_english  */
  YYSYMBOL_qualifiable_decl_english_ast = 544, /* qualifiable_decl_english_ast  */
  YYSYMBOL_pointer_decl_english_ast = 545, /* pointer_decl_english_ast  */
  YYSYMBOL_reference_decl_english_ast = 546, /* reference_decl_english_ast  */
  YYSYMBOL_reference_english_ast = 547,    /* reference_english_ast  */
  YYSYMBOL_user_defined_literal_decl_english_ast = 548, /* user_defined_literal_decl_english_ast  */
  YYSYMBOL_var_decl_english_ast = 549,     /* var_decl_english_ast  */
  YYSYMBOL_type_english_ast = 550,         /* type_english_ast  */
  YYSYMBOL_type_modifier_list_english_type_opt = 551, /* type_modifier_list_english_type_opt  */
  YYSYMBOL_type_modifier_list_english_type = 552, /* type_modifier_list_english_type  */
  YYSYMBOL_type_modifier_english_type = 553, /* type_modifier_english_type  */
  YYSYMBOL_unmodified_type_english_ast = 554, /* unmodified_type_english_ast  */
  YYSYMBOL_builtin_type_english_ast = 555, /* builtin_type_english_ast  */
  YYSYMBOL_builtin_no_BitInt_english_btid = 556, /* builtin_no_BitInt_english_btid  */
  YYSYMBOL_BitInt_english_int = 557,       /* BitInt_english_int  */
  YYSYMBOL_BitInt_english = 558,           /* BitInt_english  */
  YYSYMBOL_precise_opt = 559,              /* precise_opt  */
  YYSYMBOL_class_struct_union_english_ast = 560, /* class_struct_union_english_ast  */
  YYSYMBOL_enum_english_ast = 561,         /* enum_english_ast  */
  YYSYMBOL_of_type_enum_fixed_type_english_ast_opt = 562, /* of_type_enum_fixed_type_english_ast_opt  */
  YYSYMBOL_enum_fixed_type_english_ast = 563, /* enum_fixed_type_english_ast  */
  YYSYMBOL_enum_fixed_type_modifier_list_english_btid_opt = 564, /* enum_fixed_type_modifier_list_english_btid_opt  */
  YYSYMBOL_enum_fixed_type_modifier_list_english_btid = 565, /* enum_fixed_type_modifier_list_english_btid  */
  YYSYMBOL_enum_unmodified_fixed_type_english_ast = 566, /* enum_unmodified_fixed_type_english_ast  */
  YYSYMBOL_any_name = 567,                 /* any_name  */
  YYSYMBOL_any_name_exp = 568,             /* any_name_exp  */
  YYSYMBOL_any_sname_c = 569,              /* any_sname_c  */
  YYSYMBOL_any_sname_c_exp = 570,          /* any_sname_c_exp  */
  YYSYMBOL_any_sname_c_opt = 571,          /* any_sname_c_opt  */
  YYSYMBOL_any_typedef = 572,              /* any_typedef  */
  YYSYMBOL_name_ast = 573,                 /* name_ast  */
  YYSYMBOL_name_exp = 574,                 /* name_exp  */
  YYSYMBOL_name_opt = 575,                 /* name_opt  */
  YYSYMBOL_oper_sname_c_opt = 576,         /* oper_sname_c_opt  */
  YYSYMBOL_typedef_type_c_ast = 577,       /* typedef_type_c_ast  */
  YYSYMBOL_sub_scope_sname_c_opt = 578,    /* sub_scope_sname_c_opt  */
  YYSYMBOL_sname_c = 579,                  /* sname_c  */
  YYSYMBOL_sname_c_ast = 580,              /* sname_c_ast  */
  YYSYMBOL_bit_field_c_uint_opt = 581,     /* bit_field_c_uint_opt  */
  YYSYMBOL_sname_c_exp = 582,              /* sname_c_exp  */
  YYSYMBOL_sname_c_opt = 583,              /* sname_c_opt  */
  YYSYMBOL_sname_english = 584,            /* sname_english  */
  YYSYMBOL_sname_english_ast = 585,        /* sname_english_ast  */
  YYSYMBOL_sname_english_exp = 586,        /* sname_english_exp  */
  YYSYMBOL_sname_english_opt = 587,        /* sname_english_opt  */
  YYSYMBOL_sname_list_english = 588,       /* sname_list_english  */
  YYSYMBOL_typedef_sname_c = 589,          /* typedef_sname_c  */
  YYSYMBOL_address_exp = 590,              /* address_exp  */
  YYSYMBOL_array_exp = 591,                /* array_exp  */
  YYSYMBOL_as_exp = 592,                   /* as_exp  */
  YYSYMBOL_as_into_to_exp = 593,           /* as_into_to_exp  */
  YYSYMBOL_as_or_to_opt = 594,             /* as_or_to_opt  */
  YYSYMBOL_bits_opt = 595,                 /* bits_opt  */
  YYSYMBOL_bytes_opt = 596,                /* bytes_opt  */
  YYSYMBOL_cast_exp = 597,                 /* cast_exp  */
  YYSYMBOL_char_exp = 598,                 /* char_exp  */
  YYSYMBOL_class_struct_union_btid_exp = 599, /* class_struct_union_btid_exp  */
  YYSYMBOL_colon_exp = 600,                /* colon_exp  */
  YYSYMBOL_comma_exp = 601,                /* comma_exp  */
  YYSYMBOL_conversion_exp = 602,           /* conversion_exp  */
  YYSYMBOL_c_operator = 603,               /* c_operator  */
  YYSYMBOL_default_exp = 604,              /* default_exp  */
  YYSYMBOL_defined_exp = 605,              /* defined_exp  */
  YYSYMBOL_dependency_exp = 606,           /* dependency_exp  */
  YYSYMBOL_destructor_sname = 607,         /* destructor_sname  */
  YYSYMBOL_equals_exp = 608,               /* equals_exp  */
  YYSYMBOL_extern_linkage_c_stid = 609,    /* extern_linkage_c_stid  */
  YYSYMBOL_extern_linkage_c_stid_opt = 610, /* extern_linkage_c_stid_opt  */
  YYSYMBOL_glob = 611,                     /* glob  */
  YYSYMBOL_glob_opt = 612,                 /* glob_opt  */
  YYSYMBOL_gt_exp = 613,                   /* gt_exp  */
  YYSYMBOL_inline_stid_opt = 614,          /* inline_stid_opt  */
  YYSYMBOL_int_exp = 615,                  /* int_exp  */
  YYSYMBOL_int_lit_exp = 616,              /* int_lit_exp  */
  YYSYMBOL_int_lit_opt = 617,              /* int_lit_opt  */
  YYSYMBOL_literal_exp = 618,              /* literal_exp  */
  YYSYMBOL_local_exp = 619,                /* local_exp  */
  YYSYMBOL_lparen_exp = 620,               /* lparen_exp  */
  YYSYMBOL_lt_exp = 621,                   /* lt_exp  */
  YYSYMBOL_member_or_non_member_opt = 622, /* member_or_non_member_opt  */
  YYSYMBOL_namespace_btid_exp = 623,       /* namespace_btid_exp  */
  YYSYMBOL_namespace_type = 624,           /* namespace_type  */
  YYSYMBOL_of_exp = 625,                   /* of_exp  */
  YYSYMBOL_of_scope_english = 626,         /* of_scope_english  */
  YYSYMBOL_of_scope_list_english = 627,    /* of_scope_list_english  */
  YYSYMBOL_of_scope_list_english_opt = 628, /* of_scope_list_english_opt  */
  YYSYMBOL_operator_exp = 629,             /* operator_exp  */
  YYSYMBOL_operator_opt = 630,             /* operator_opt  */
  YYSYMBOL_point_exp = 631,                /* point_exp  */
  YYSYMBOL_precision_opt = 632,            /* precision_opt  */
  YYSYMBOL_quote2_exp = 633,               /* quote2_exp  */
  YYSYMBOL_rbrace_exp = 634,               /* rbrace_exp  */
  YYSYMBOL_rbracket_exp = 635,             /* rbracket_exp  */
  YYSYMBOL_reference_exp = 636,            /* reference_exp  */
  YYSYMBOL_returning = 637,                /* returning  */
  YYSYMBOL_returning_exp = 638,            /* returning_exp  */
  YYSYMBOL_rparen_exp = 639,               /* rparen_exp  */
  YYSYMBOL_scope_english_type = 640,       /* scope_english_type  */
  YYSYMBOL_scope_english_type_exp = 641,   /* scope_english_type_exp  */
  YYSYMBOL_semi_exp = 642,                 /* semi_exp  */
  YYSYMBOL_semi_opt = 643,                 /* semi_opt  */
  YYSYMBOL_semi_or_end = 644,              /* semi_or_end  */
  YYSYMBOL_static_stid_opt = 645,          /* static_stid_opt  */
  YYSYMBOL_str_lit = 646,                  /* str_lit  */
  YYSYMBOL_str_lit_exp = 647,              /* str_lit_exp  */
  YYSYMBOL_this_exp = 648,                 /* this_exp  */
  YYSYMBOL_this_stid_opt = 649,            /* this_stid_opt  */
  YYSYMBOL_to_exp = 650,                   /* to_exp  */
  YYSYMBOL_type_opt = 651,                 /* type_opt  */
  YYSYMBOL_typename_flag_opt = 652,        /* typename_flag_opt  */
  YYSYMBOL_unused_exp = 653,               /* unused_exp  */
  YYSYMBOL_user_defined = 654,             /* user_defined  */
  YYSYMBOL_virtual_stid_exp = 655,         /* virtual_stid_exp  */
  YYSYMBOL_virtual_stid_opt = 656          /* virtual_stid_opt  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   4792

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  285
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  372
/* YYNRULES -- Number of rules.  */
#define YYNRULES  942
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1265

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   521


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,    87,     2,     2,
      70,    71,    78,    89,   130,    88,    74,    86,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   270,   271,
      96,   112,    97,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    72,     2,    73,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   272,     2,   273,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    75,    76,    77,    79,    80,
      81,    82,    83,    84,    85,    90,    91,    92,    93,    94,
      95,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,  1719,  1719,  1720,  1729,  1730,  1731,  1732,  1733,  1734,
    1735,  1736,  1737,  1738,  1739,  1740,  1741,  1742,  1761,  1780,
    1811,  1812,  1813,  1814,  1815,  1824,  1951,  1950,  1993,  2026,
    2058,  2068,  2070,  2077,  2097,  2103,  2109,  2118,  2119,  2120,
    2124,  2125,  2129,  2136,  2140,  2144,  2152,  2153,  2157,  2172,
    2187,  2192,  2197,  2203,  2207,  2208,  2209,  2213,  2227,  2228,
    2246,  2247,  2268,  2272,  2273,  2274,  2275,  2276,  2277,  2278,
    2279,  2280,  2281,  2282,  2283,  2284,  2285,  2286,  2287,  2293,
    2341,  2346,  2351,  2356,  2361,  2366,  2371,  2376,  2381,  2386,
    2396,  2405,  2415,  2415,  2430,  2435,  2454,  2461,  2468,  2485,
    2489,  2490,  2491,  2492,  2493,  2502,  2508,  2514,  2518,  2522,
    2523,  2527,  2537,  2538,  2539,  2549,  2559,  2569,  2579,  2589,
    2618,  2627,  2628,  2629,  2643,  2644,  2654,  2655,  2659,  2660,
    2667,  2668,  2672,  2673,  2674,  2680,  2686,  2692,  2703,  2702,
    2738,  2749,  2748,  2789,  2790,  2791,  2792,  2802,  2803,  2802,
    2808,  2819,  2819,  2835,  2842,  2843,  2849,  2860,  2861,  2862,
    2870,  2875,  2869,  2927,  2926,  2967,  2971,  2966,  3033,  3034,
    3035,  3048,  3062,  3077,  3093,  3112,  3126,  3142,  3160,  3164,
    3165,  3172,  3173,  3177,  3178,  3182,  3183,  3184,  3185,  3194,
    3223,  3224,  3228,  3244,  3259,  3264,  3270,  3275,  3280,  3285,
    3293,  3294,  3298,  3299,  3299,  3319,  3331,  3331,  3341,  3347,
    3340,  3378,  3377,  3388,  3393,  3457,  3458,  3467,  3482,  3493,
    3514,  3492,  3578,  3624,  3632,  3637,  3646,  3679,  3680,  3687,
    3688,  3689,  3690,  3691,  3700,  3701,  3705,  3706,  3707,  3708,
    3709,  3710,  3714,  3715,  3716,  3723,  3756,  3761,  3767,  3773,
    3779,  3787,  3795,  3801,  3810,  3819,  3830,  3829,  3871,  3904,
    3939,  3979,  4120,  4119,  4213,  4212,  4231,  4232,  4248,  4249,
    4250,  4258,  4262,  4263,  4264,  4268,  4269,  4270,  4274,  4278,
    4297,  4298,  4299,  4306,  4308,  4308,  4359,  4366,  4367,  4368,
    4369,  4377,  4389,  4390,  4398,  4399,  4403,  4416,  4434,  4433,
    4468,  4473,  4485,  4486,  4496,  4495,  4520,  4572,  4572,  4592,
    4612,  4617,  4625,  4625,  4644,  4681,  4681,  4701,  4739,  4739,
    4758,  4775,  4796,  4890,  4889,  4935,  4979,  4980,  4984,  4985,
    4986,  4987,  4991,  4992,  4993,  4994,  4996,  5006,  5043,  5042,
    5081,  5157,  5156,  5199,  5199,  5221,  5221,  5244,  5244,  5273,
    5274,  5278,  5279,  5280,  5281,  5285,  5285,  5303,  5303,  5321,
    5321,  5348,  5383,  5398,  5402,  5403,  5407,  5421,  5425,  5449,
    5450,  5451,  5458,  5459,  5460,  5461,  5462,  5463,  5464,  5470,
    5474,  5491,  5509,  5510,  5511,  5512,  5519,  5518,  5564,  5575,
    5590,  5591,  5592,  5593,  5594,  5595,  5596,  5597,  5598,  5599,
    5600,  5601,  5602,  5603,  5607,  5617,  5618,  5624,  5625,  5629,
    5648,  5661,  5682,  5697,  5701,  5702,  5703,  5719,  5737,  5763,
    5782,  5783,  5787,  5803,  5807,  5808,  5809,  5810,  5814,  5815,
    5816,  5822,  5823,  5827,  5828,  5832,  5833,  5839,  5840,  5844,
    5859,  5864,  5871,  5872,  5873,  5874,  5875,  5876,  5877,  5881,
    5882,  5886,  5887,  5903,  5917,  5921,  5922,  5923,  5924,  5933,
    5934,  5935,  5936,  5937,  5938,  5939,  5940,  5941,  5942,  5943,
    5944,  5945,  5946,  5971,  5973,  5974,  5975,  5976,  5977,  5981,
    5982,  5988,  5989,  5994,  5993,  6017,  6024,  6025,  6035,  6036,
    6040,  6054,  6058,  6059,  6060,  6061,  6062,  6063,  6064,  6065,
    6066,  6097,  6104,  6105,  6115,  6116,  6120,  6121,  6125,  6126,
    6130,  6131,  6136,  6135,  6151,  6152,  6156,  6157,  6161,  6165,
    6172,  6173,  6177,  6178,  6182,  6183,  6187,  6188,  6189,  6190,
    6191,  6192,  6199,  6200,  6205,  6204,  6217,  6218,  6229,  6230,
    6238,  6239,  6240,  6246,  6261,  6285,  6289,  6295,  6301,  6309,
    6310,  6317,  6338,  6355,  6367,  6368,  6375,  6401,  6405,  6412,
    6413,  6414,  6415,  6416,  6417,  6424,  6461,  6462,  6466,  6480,
    6481,  6485,  6500,  6517,  6518,  6527,  6528,  6529,  6536,  6547,
    6551,  6562,  6571,  6591,  6592,  6596,  6612,  6616,  6617,  6618,
    6622,  6623,  6624,  6625,  6626,  6627,  6628,  6629,  6630,  6631,
    6632,  6633,  6634,  6635,  6639,  6640,  6641,  6645,  6646,  6647,
    6648,  6649,  6650,  6651,  6652,  6653,  6657,  6658,  6659,  6660,
    6661,  6662,  6663,  6664,  6666,  6667,  6668,  6669,  6670,  6671,
    6672,  6673,  6674,  6678,  6679,  6680,  6691,  6711,  6712,  6716,
    6717,  6718,  6719,  6720,  6721,  6722,  6726,  6727,  6731,  6732,
    6733,  6734,  6735,  6736,  6737,  6738,  6748,  6770,  6790,  6803,
    6820,  6825,  6834,  6874,  6898,  6903,  6920,  6942,  6962,  6963,
    6967,  6983,  6987,  6991,  6992,  6993,  6994,  6998,  7010,  7025,
    7026,  7027,  7028,  7029,  7041,  7042,  7043,  7044,  7045,  7046,
    7047,  7048,  7049,  7050,  7051,  7055,  7059,  7063,  7067,  7074,
    7075,  7076,  7080,  7081,  7085,  7102,  7122,  7123,  7130,  7148,
    7163,  7164,  7168,  7184,  7188,  7189,  7197,  7198,  7206,  7207,
    7215,  7216,  7220,  7221,  7229,  7230,  7234,  7235,  7239,  7253,
    7254,  7262,  7263,  7267,  7269,  7278,  7338,  7339,  7343,  7368,
    7390,  7404,  7440,  7441,  7455,  7456,  7464,  7465,  7469,  7488,
    7517,  7518,  7526,  7527,  7531,  7547,  7563,  7582,  7604,  7612,
    7613,  7620,  7621,  7628,  7648,  7655,  7656,  7657,  7658,  7665,
    7666,  7667,  7671,  7672,  7673,  7677,  7678,  7682,  7683,  7690,
    7691,  7698,  7699,  7706,  7707,  7714,  7715,  7722,  7723,  7730,
    7731,  7732,  7733,  7734,  7735,  7736,  7737,  7738,  7739,  7740,
    7741,  7742,  7743,  7744,  7745,  7746,  7747,  7748,  7749,  7750,
    7751,  7752,  7753,  7754,  7755,  7756,  7757,  7758,  7759,  7760,
    7761,  7762,  7763,  7764,  7765,  7766,  7767,  7768,  7769,  7770,
    7771,  7772,  7773,  7774,  7775,  7776,  7777,  7781,  7782,  7789,
    7790,  7797,  7798,  7805,  7806,  7814,  7815,  7822,  7823,  7833,
    7834,  7838,  7853,  7854,  7858,  7859,  7866,  7867,  7871,  7872,
    7879,  7880,  7887,  7888,  7892,  7893,  7900,  7901,  7908,  7909,
    7916,  7917,  7924,  7925,  7926,  7930,  7931,  7938,  7939,  7943,
    7944,  7951,  7974,  7985,  7989,  7990,  7994,  7995,  8002,  8003,
    8007,  8008,  8014,  8015,  8019,  8020,  8027,  8028,  8035,  8036,
    8043,  8044,  8051,  8052,  8056,  8057,  8064,  8065,  8072,  8073,
    8074,  8078,  8079,  8088,  8089,  8096,  8097,  8101,  8102,  8106,
    8107,  8111,  8112,  8120,  8121,  8129,  8130,  8137,  8138,  8142,
    8143,  8150,  8151,  8155,  8156,  8160,  8161,  8168,  8169,  8173,
    8174,  8181,  8182
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "Y_cast",
  "Y_const_ENG", "Y_declare", "Y_define", "Y_dynamic", "Y_explain",
  "Y_help", "Y_no", "Y_quit", "Y_reinterpret", "Y_set", "Y_show",
  "Y_aligned", "Y_all", "Y_array", "Y_as", "Y_bit", "Y_bit_precise",
  "Y_bits", "Y_by", "Y_bytes", "Y_capturing", "Y_commands",
  "Y_constructor", "Y_conversion", "Y_copy", "Y_defined", "Y_destructor",
  "Y_english", "Y_evaluation", "Y_expression", "Y_floating", "Y_function",
  "Y_initialization", "Y_into", "Y_lambda", "Y_length", "Y_linkage",
  "Y_literal", "Y_member", "Y_non_empty", "Y_non_member", "Y_of",
  "Y_options", "Y_point", "Y_pointer", "Y_precise", "Y_precision",
  "Y_predefined", "Y_pure", "Y_reference", "Y_returning", "Y_rvalue",
  "Y_scope", "Y_to", "Y_user", "Y_user_defined", "Y_variable", "Y_wide",
  "Y_width", "Y_PREC_LESS_THAN_upc_layout_qualifier", "Y_COLON2", "\"::\"",
  "Y_COLON2_STAR", "\"::*\"", "\"++\"", "\"--\"", "'('", "')'", "'['",
  "']'", "'.'", "Y_ARROW", "\"->\"", "Y_AMPER", "'*'", "Y_EXCLAM",
  "Y_sizeof", "Y_TILDE", "Y_DOT_STAR", "\".*\"", "Y_ARROW_STAR", "\"->*\"",
  "'/'", "'%'", "'-'", "'+'", "Y_LESS2", "\"<<\"", "Y_GREATER2", "\">>\"",
  "Y_LESS_EQUAL_GREATER", "\"<=>\"", "'<'", "'>'", "Y_LESS_EQUAL",
  "\"<=\"", "Y_GREATER_EQUAL", "\">=\"", "Y_EQUAL2", "\"==\"",
  "Y_EXCLAM_EQUAL", "Y_bit_and", "Y_CARET", "Y_PIPE", "Y_AMPER2",
  "Y_PIPE2", "Y_QMARK_COLON", "\"?:\"", "'='", "Y_PERCENT_EQUAL", "\"%=\"",
  "Y_AMPER_EQUAL", "Y_STAR_EQUAL", "\"*=\"", "Y_PLUS_EQUAL", "\"+=\"",
  "Y_MINUS_EQUAL", "\"-=\"", "Y_SLASH_EQUAL", "\"/=\"", "Y_LESS2_EQUAL",
  "\"<<=\"", "Y_GREATER2_EQUAL", "\">>=\"", "Y_CARET_EQUAL",
  "Y_PIPE_EQUAL", "','", "Y_auto_STORAGE", "Y_break", "Y_case", "Y_char",
  "Y_continue", "Y_default", "Y_do", "Y_double", "Y_else", "Y_extern",
  "Y_float", "Y_for", "Y_goto", "Y_if", "Y_int", "Y_long", "Y_register",
  "Y_return", "Y_short", "Y_static", "Y_struct", "Y_switch", "Y_typedef",
  "Y_union", "Y_unsigned", "Y_while", "Y_asm", "Y_const", "\"...\"",
  "Y_enum", "Y_signed", "Y_void", "Y_volatile", "Y_wchar_t", "Y__Bool",
  "Y__Complex", "Y__Imaginary", "Y_inline", "Y_restrict", "Y__Alignas",
  "Y__Alignof", "Y__Atomic_QUAL", "Y__Atomic_SPEC", "Y__Generic",
  "Y__Noreturn", "Y__Static_assert", "Y__Thread_local", "Y_thread",
  "Y_local", "Y_bool", "Y_catch", "Y_class", "Y_const_cast",
  "Y_CONSTRUCTOR_SNAME", "Y_delete", "Y_DESTRUCTOR_SNAME",
  "Y_dynamic_cast", "Y_explicit", "Y_false", "Y_friend", "Y_mutable",
  "Y_namespace", "Y_new", "Y_operator", "Y_OPERATOR_SNAME", "Y_private",
  "Y_protected", "Y_public", "Y_reinterpret_cast", "Y_static_cast",
  "Y_template", "Y_this", "Y_throw", "Y_true", "Y_try", "Y_typeid",
  "Y_typename", "Y_using", "Y_virtual", "Y_char16_t", "Y_char32_t",
  "Y__BitInt", "Y_reproducible", "Y_typeof", "Y_typeof_unqual",
  "Y_unsequenced", "Y_ATTR_BEGIN", "Y_alignas", "Y_alignof", "Y_auto_TYPE",
  "Y_carries", "Y_dependency", "Y_carries_dependency", "Y_constexpr",
  "Y_decltype", "Y_except", "Y_final", "Y_noexcept", "Y_nullptr",
  "Y_override", "Y_QUOTE2", "Y_static_assert", "Y_thread_local",
  "Y_deprecated", "Y_discard", "Y_maybe_unused", "Y_maybe", "Y_unused",
  "Y_nodiscard", "Y_noreturn", "Y_char8_t", "Y_address", "Y_concept",
  "Y_consteval", "Y_constinit", "Y_co_await", "Y_co_return", "Y_co_yield",
  "Y_export", "Y_no_unique_address", "Y_requires", "Y_unique",
  "Y_EMC__Accum", "Y_EMC__Fract", "Y_EMC__Sat", "Y_UPC_relaxed",
  "Y_UPC_shared", "Y_UPC_strict", "Y_GNU___attribute__",
  "Y_GNU___restrict", "Y_Apple___block", "Y_Apple_block", "Y_MSC___cdecl",
  "Y_MSC___clrcall", "Y_MSC___declspec", "Y_MSC___fastcall",
  "Y_MSC___stdcall", "Y_MSC___thiscall", "Y_MSC___vectorcall", "':'",
  "';'", "'{'", "'}'", "Y_CHAR_LIT", "Y_END", "Y_ERROR", "Y_GLOB",
  "Y_INT_LIT", "Y_NAME", "Y_SET_OPTION", "Y_STR_LIT", "Y_TYPEDEF_NAME",
  "Y_TYPEDEF_SNAME", "Y_LEXER_ERROR", "$accept", "command_list", "command",
  "cast_command", "new_style_cast_english", "declare_command", "$@1",
  "alignas_or_width_decl_english_ast", "alignas_specifier_english",
  "aligned_english", "capturing_paren_capture_decl_list_english_opt",
  "paren_capture_decl_list_english", "capture_decl_list_english_opt",
  "capture_decl_list_english", "capture_decl_english_ast",
  "capture_default_opt", "width_specifier_english_uint",
  "storage_class_subset_english_type_opt",
  "storage_class_subset_english_type", "storage_class_subset_english_stid",
  "define_command", "explain_command", "$@2", "explain", "help_command",
  "help_what_opt", "quit_command", "scoped_command", "set_command",
  "set_option_list", "set_option", "set_option_value_opt", "show_command",
  "show_format", "show_format_exp", "show_format_opt",
  "show_which_types_flags_opt", "predefined_or_user_flags_opt",
  "template_command", "typedef_command", "using_command",
  "c_style_cast_expr_c", "$@3", "new_style_cast_expr_c", "$@4",
  "new_style_cast_c", "aligned_declaration_c", "$@5", "$@6",
  "alignas_specifier_c", "$@7", "alignas", "asm_declaration_c",
  "scoped_declaration_c", "class_struct_union_declaration_c", "$@8", "$@9",
  "enum_declaration_c", "$@10", "namespace_declaration_c", "$@11", "$@12",
  "namespace_sname_c_exp", "namespace_sname_c",
  "namespace_typedef_sname_c", "brace_in_scope_declaration_c_exp",
  "brace_in_scope_declaration_c_opt", "brace_in_scope_declaration_c",
  "in_scope_declaration_c_exp", "lambda_declaration_c",
  "capture_decl_list_c_opt", "capture_decl_list_c", "capture_decl_c_ast",
  "lambda_param_c_ast_list_opt", "lambda_return_type_c_ast_opt", "$@13",
  "template_declaration_c", "typed_declaration_c", "$@14",
  "typedef_declaration_c", "$@15", "$@16", "typedef_decl_list_c", "$@17",
  "typedef_decl_c", "typedef_decl_c_exp",
  "user_defined_conversion_declaration_c", "using_declaration_c",
  "using_decl_c_ast", "$@18", "$@19", "decl_list_c_opt", "decl_list_c",
  "decl_c", "decl_c_exp", "decl_c_astp", "msc_calling_convention_c_astp",
  "decl2_c_astp", "array_decl_c_astp", "array_size_c_ast",
  "block_decl_c_astp", "$@20", "destructor_declaration_c",
  "file_scope_constructor_declaration_c",
  "file_scope_destructor_declaration_c", "func_decl_c_astp",
  "pc99_func_or_constructor_declaration_c", "$@21",
  "rparen_func_qualifier_list_c_stid_opt", "$@22",
  "func_qualifier_list_c_stid_opt", "func_qualifier_c_stid",
  "func_ref_qualifier_c_stid_opt", "noexcept_c_stid_opt",
  "noexcept_bool_stid_exp", "trailing_return_type_c_ast_opt", "$@23",
  "func_equals_c_stid_opt", "param_c_ast_list_exp", "param_c_ast_list_opt",
  "param_c_ast_list", "param_c_ast", "$@24", "param_c_ast_exp",
  "nested_decl_c_astp", "$@25", "oper_decl_c_astp", "pointer_decl_c_astp",
  "$@26", "pointer_type_c_ast", "pc99_pointer_decl_list_c",
  "pc99_pointer_decl_c", "$@27", "pc99_pointer_type_c_ast",
  "pointer_to_member_decl_c_astp", "$@28", "pointer_to_member_type_c_ast",
  "reference_decl_c_astp", "$@29", "reference_type_c_ast",
  "typedef_type_decl_c_ast", "user_defined_conversion_decl_c_astp", "$@30",
  "user_defined_literal_decl_c_astp", "cast_c_astp_opt", "cast_c_astp",
  "cast2_c_astp", "array_cast_c_astp", "block_cast_c_astp", "$@31",
  "func_cast_c_astp", "nested_cast_c_astp", "$@32", "pointer_cast_c_astp",
  "$@33", "pointer_to_member_cast_c_astp", "$@34", "reference_cast_c_astp",
  "$@35", "udc_decl_c_ast_opt", "udc_decl_c_ast", "pointer_udc_decl_c_ast",
  "$@36", "pointer_to_member_udc_decl_c_ast", "$@37",
  "reference_udc_decl_c_ast", "$@38", "type_c_ast",
  "type_modifier_list_c_type_opt", "type_modifier_list_c_type",
  "type_modifier_c_type", "type_modifier_base_type",
  "east_modified_type_c_ast", "atomic_builtin_typedef_type_c_ast",
  "atomic_specifier_type_c_ast", "$@39", "builtin_type_c_ast",
  "builtin_no_BitInt_c_btid", "typeof_type_c_ast", "typeof",
  "enum_class_struct_union_c_ast", "class_struct_union_c_ast",
  "enum_c_ast", "enum_btids", "enum_fixed_type_c_ast_opt",
  "enum_fixed_type_c_ast", "enum_fixed_type_modifier_list_btid_opt",
  "enum_fixed_type_modifier_list_btid", "enum_fixed_type_modifier_btid",
  "enum_unmodified_fixed_type_c_ast", "class_struct_btid_opt",
  "class_struct_btid", "class_struct_union_btid",
  "type_qualifier_list_c_stid_opt", "type_qualifier_list_c_stid",
  "type_qualifier_c_stid", "cv_qualifier_stid",
  "cv_qualifier_list_stid_opt", "restrict_qualifier_c_stid",
  "upc_layout_qualifier_c", "storage_class_c_type", "_Noreturn_atid",
  "attribute_specifier_list_c_atid_opt", "attribute_specifier_list_c_atid",
  "$@40", "using_opt", "attribute_list_c_atid_opt",
  "attribute_list_c_atid", "attribute_c_atid_exp",
  "attribute_str_arg_c_opt", "gnu_or_msc_attribute_specifier_list_c_opt",
  "gnu_or_msc_attribute_specifier_list_c",
  "gnu_attribute_specifier_list_c_opt", "gnu_attribute_specifier_list_c",
  "gnu_attribute_specifier_c", "$@41", "gnu_attribute_list_c_opt",
  "gnu_attribuet_list_c", "gnu_attribute_c_exp",
  "gnu_attribute_decl_arg_list_c_opt", "gnu_attribute_arg_list_c_opt",
  "gnu_attribute_arg_list_c", "gnu_attribute_arg_c",
  "msc_attribute_specifier_list_c", "msc_attribute_specifier_c", "$@42",
  "msc_attribute_list_c_opt", "msc_attribuet_list_c", "decl_english_ast",
  "array_decl_english_ast", "array_size_decl_ast", "length_opt",
  "block_decl_english_ast", "constructor_decl_english_ast",
  "destructor_decl_english_ast", "parens_opt", "func_decl_english_ast",
  "func_qualifier_english_type_opt", "msc_calling_convention_atid",
  "oper_decl_english_ast", "paren_param_decl_list_english_opt",
  "paren_param_decl_list_english", "param_decl_list_english_opt",
  "param_decl_list_english", "decl_english_ast_exp",
  "ref_qualifier_english_stid_opt", "returning_english_ast_opt",
  "returning_english_ast", "qualified_decl_english_ast",
  "type_qualifier_list_english_type_opt",
  "type_qualifier_list_english_type", "type_qualifier_english_type",
  "attribute_english_atid", "storage_class_english_stid",
  "eval_expr_init_stid", "linkage_stid", "linkage_opt",
  "type_qualifier_english_stid", "upc_layout_qualifier_english",
  "qualifiable_decl_english_ast", "pointer_decl_english_ast",
  "reference_decl_english_ast", "reference_english_ast",
  "user_defined_literal_decl_english_ast", "var_decl_english_ast",
  "type_english_ast", "type_modifier_list_english_type_opt",
  "type_modifier_list_english_type", "type_modifier_english_type",
  "unmodified_type_english_ast", "builtin_type_english_ast",
  "builtin_no_BitInt_english_btid", "BitInt_english_int", "BitInt_english",
  "precise_opt", "class_struct_union_english_ast", "enum_english_ast",
  "of_type_enum_fixed_type_english_ast_opt", "enum_fixed_type_english_ast",
  "enum_fixed_type_modifier_list_english_btid_opt",
  "enum_fixed_type_modifier_list_english_btid",
  "enum_unmodified_fixed_type_english_ast", "any_name", "any_name_exp",
  "any_sname_c", "any_sname_c_exp", "any_sname_c_opt", "any_typedef",
  "name_ast", "name_exp", "name_opt", "oper_sname_c_opt",
  "typedef_type_c_ast", "sub_scope_sname_c_opt", "sname_c", "sname_c_ast",
  "bit_field_c_uint_opt", "sname_c_exp", "sname_c_opt", "sname_english",
  "sname_english_ast", "sname_english_exp", "sname_english_opt",
  "sname_list_english", "typedef_sname_c", "address_exp", "array_exp",
  "as_exp", "as_into_to_exp", "as_or_to_opt", "bits_opt", "bytes_opt",
  "cast_exp", "char_exp", "class_struct_union_btid_exp", "colon_exp",
  "comma_exp", "conversion_exp", "c_operator", "default_exp",
  "defined_exp", "dependency_exp", "destructor_sname", "equals_exp",
  "extern_linkage_c_stid", "extern_linkage_c_stid_opt", "glob", "glob_opt",
  "gt_exp", "inline_stid_opt", "int_exp", "int_lit_exp", "int_lit_opt",
  "literal_exp", "local_exp", "lparen_exp", "lt_exp",
  "member_or_non_member_opt", "namespace_btid_exp", "namespace_type",
  "of_exp", "of_scope_english", "of_scope_list_english",
  "of_scope_list_english_opt", "operator_exp", "operator_opt", "point_exp",
  "precision_opt", "quote2_exp", "rbrace_exp", "rbracket_exp",
  "reference_exp", "returning", "returning_exp", "rparen_exp",
  "scope_english_type", "scope_english_type_exp", "semi_exp", "semi_opt",
  "semi_or_end", "static_stid_opt", "str_lit", "str_lit_exp", "this_exp",
  "this_stid_opt", "to_exp", "type_opt", "typename_flag_opt", "unused_exp",
  "user_defined", "virtual_stid_exp", "virtual_stid_opt", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-985)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-943)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    -985,  3789,  -985,  -985,   438,  2582,    46,   422,  -985,   109,
    -985,   422,  -127,  1448,   422,  -985,   -45,  -985,   422,   340,
      75,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,   419,    46,   419,   419,   419,  1042,   419,   419,
    -985,   419,   419,   419,   419,   419,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,   199,  -985,   183,  -985,   120,   192,  -985,
    -985,  -985,  -985,   131,   113,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,   187,   316,  -985,  3662,  -985,    94,  -985,
    -985,  -985,   140,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,   330,  -127,  -985,  -985,   594,  -985,  -985,  -985,
     209,   446,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,    58,  -985,   120,  -985,  -985,  -985,  -985,  4162,   377,
     712,  -985,  -985,  -985,  -110,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,   114,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,   462,  -985,  -985,  -985,   114,  -985,  -985,  -985,
    -985,  -985,  -985,   463,  -985,   470,  -985,  -985,   114,  -985,
    -985,   467,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,   532,  -985,  -985,
    -985,  -985,  -985,   569,  -985,  -985,   418,  -985,  -985,   114,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
     534,  -985,  -985,  -985,  4301,  -985,  -985,  -985,  4527,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,   344,   344,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,   466,  -985,   472,  -985,
     647,   554,  -985,   183,   549,   550,   487,   678,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,    64,    64,    66,    81,  -985,
     199,  -985,   453,  -985,  -985,  -985,  -985,  3527,   438,  -985,
    -985,  -985,  -985,  -985,  -985,   113,   113,   698,   -43,   434,
      57,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,    84,  -985,  -985,  -985,  -985,  -985,  -985,  -985,    63,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,   523,  -985,
    -985,  -985,    46,  3527,   199,  3527,    56,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,   480,   119,  -985,  -985,  -985,  -985,
    -985,  4301,  -985,  -985,  -985,  -985,   344,  3527,  -985,  -985,
     131,  -985,  -985,   485,   169,  -985,  -985,  -985,   694,   128,
    -985,  -985,   666,   396,   666,  -985,  -985,   504,  -985,  -985,
    -985,    42,  4301,  -985,  4301,    98,  -985,    90,  -985,   114,
     114,  -985,  -985,  -985,  4301,   -45,  3163,  1636,  1636,  3415,
    -985,  -985,  -985,  4527,   461,    52,  -985,    52,  -985,  -985,
     438,  -985,  4301,  -985,   114,  -985,  -985,   114,    58,  -985,
    -985,   498,  -985,  -985,  -985,  -985,   716,   718,  -985,  -985,
    -985,  -985,  -985,  -985,    64,  -985,  -985,  -985,   698,   395,
    -985,    57,   515,  -985,  -985,  -985,  -110,  -985,  -985,  -985,
    -985,  -985,  -985,   165,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
       6,  -985,  -985,   435,  -985,  -985,  -985,  -985,  3983,  3949,
    -985,  -985,  -985,  -985,  -985,  -985,   444,  -985,   135,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
      50,   121,    53,   713,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,   530,  -985,  -985,   399,   140,  -985,
    -985,  -985,   119,  -985,  -985,  -985,  -985,  -985,   100,  -985,
    -985,   118,  -985,  -985,  -985,  -985,   714,  -985,  -985,   377,
     396,  -985,  -985,  -985,  -985,  -985,  -985,   131,  -985,  -985,
    -985,  -985,   131,   566,   715,  -985,   113,   113,   114,    72,
      38,  -985,  -985,   720,   131,  -985,   680,   712,   712,   712,
    -985,  -985,  -985,  -985,  -985,  -985,   655,  -985,  -985,   652,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,   200,   727,   499,   600,  -985,     5,
     466,  -985,  -985,   655,   525,   498,   528,  -985,   531,  -985,
    -985,    38,   724,   114,   872,  -985,   535,   106,   -65,   358,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,   764,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,   107,   713,   736,   158,   203,
     141,   769,   713,  -985,  -985,  -985,  -985,  -985,  -985,   551,
    -985,  -985,  -985,  -985,  -985,   158,  -985,  3800,  3661,  -985,
    -985,  3527,  -985,  -985,   114,  -985,  -985,  -985,  -985,    53,
      53,  -985,   102,    91,   741,   116,  -985,  -985,  3390,    65,
    -985,  -985,  -985,   624,   133,    98,  -985,  -985,  -985,  1530,
    -985,  3949,  -985,  1636,  -985,  -985,  4301,   717,  -985,  -985,
    -985,   496,  -985,   750,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,    38,  -985,  -985,  -985,  -985,   118,  -985,    74,
     704,  -985,  -985,  -985,    73,  -985,   752,  -985,   755,    78,
    -985,  -985,  -985,   757,   127,  -985,  -985,  4301,   118,  4301,
    -985,  -985,   118,  -985,  1636,  -985,  -985,  -985,   879,    38,
    1379,   466,  1636,  1636,  1636,  -985,   652,   679,  -985,    13,
    -985,  1263,    98,  -985,  -985,   466,  -985,  -985,  -985,   156,
     724,  -985,   482,   724,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  4430,  -985,   553,  -985,   619,  -985,  -985,  -985,
    -985,  -985,    74,  -985,  -985,    74,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,   122,  -985,   131,  -985,  -985,  -985,  1800,
    -985,  -985,   456,  -985,   591,    65,  -985,  -985,   795,  3527,
     787,    85,   126,    97,   559,   790,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,    64,
      64,  -985,  -985,  -985,  -985,    99,  -985,  -985,  -985,  -985,
    -985,  3390,   770,   771,   101,  -985,  -985,    74,  -985,  -985,
      53,  -985,   772,   132,  -985,  -985,  -985,  -985,  2070,  -985,
     199,  -985,  -985,  -985,   734,  -985,   819,  -985,  -985,   710,
     719,  -985,  -985,  -985,  -985,   118,   118,   118,   118,  -985,
     568,    38,   777,  4045,   496,  -985,  -985,    41,  -985,  -985,
    -985,  -985,   780,  -985,   780,  -985,  -985,   781,   450,  -985,
     183,   782,   402,  -985,   191,  -985,  -985,  -985,   482,  2869,
    -985,   110,  -985,   496,   712,   131,  -985,  -985,  -985,   724,
     785,   712,   113,   113,   786,   318,  -985,  -985,  -985,  -985,
    -985,   461,  -985,  -985,   114,    74,  -985,  -985,  -985,  -985,
     114,  -985,  -985,  -985,  -985,  -985,   482,  -985,   114,   789,
     466,   482,  -985,   553,  -985,   553,  -985,  -985,  -985,   589,
      62,    62,  -985,  -985,  -985,  -985,  3527,  -985,  -985,   122,
    -985,  -985,  -985,   584,  -985,   713,  -985,  -985,    85,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,   823,  -985,  -985,    98,    98,   734,   800,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  2340,  -985,  -985,
     458,  -985,  -985,  -985,  -985,  -985,  -985,   141,   551,  -985,
     118,   712,   496,   805,   805,   805,   183,  -985,   724,  -985,
    4301,  -985,  -985,  -985,  -985,  -985,    42,  -985,  -985,   113,
     765,   131,    79,   191,  -985,  -985,  -985,  -985,  -985,   801,
     436,  -985,   766,  -985,  -985,  -985,   118,  -985,  -985,   114,
    -985,  1636,  -985,   483,  -985,   240,  -985,  -985,   113,  -985,
    -985,   306,    38,   114,   156,   156,   156,   724,   466,   452,
    2722,    82,  -985,   466,  -985,  -985,    43,  -985,  -985,  -985,
    -985,  -985,   408,  -985,   122,    65,  -985,   726,  -985,   734,
     131,  -985,    65,  -985,  -985,  -985,  -985,  -985,  3527,  -985,
      86,  3278,   805,   118,  -985,   482,  -985,   131,  -985,  -985,
    -985,  -985,   484,  -985,   191,    92,  -985,   805,    88,   131,
    -985,  -985,   482,   113,   113,  -985,   113,   113,   724,  3016,
    -985,  -985,  -985,   482,  -985,  -985,  -985,  -985,  -985,  -985,
     493,  -985,  -985,  -985,  -985,   131,   766,  -985,  -985,  -985,
    -985,  -985,    46,  3527,  -985,  -985,   553,  -985,  -985,  -985,
    -985,  -985,  -985,   713,  -985,  -985,  -985,   496,    17,   118,
    -985,   502,  -985,  -985,  -985,  -985,  -985,  -985,  -985,   183,
     131,   114,    17,  -985,  -985,  -985,  -985,   483,  -985,   811,
     536,   766,  -985,  -985,  -985,  3527,  -985,  -985,  -985,  3857,
    2768,    65,   114,  4301,  -985,   466,   805,  -985,    38,   766,
     482,   482,  -985,  -985,   199,  -985,  -985,  -985,  -985,  -985,
      38,  -985,   812,  -985,    17,    17,   814,   118,   466,   766,
    -985,  -985,  -985,  -985,  -985
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     1,    17,   752,     0,     0,     0,    98,     0,
     105,     0,   107,     0,     0,   434,   933,   436,     0,   431,
       0,   433,   143,   144,   877,   145,   146,   205,   219,   917,
     918,     3,     0,     0,     0,     0,     0,     0,     0,     0,
      10,     0,     0,     0,     0,     0,    24,   106,   157,   158,
     159,   135,   136,   137,   218,   163,   435,   160,   165,    16,
     740,   726,   727,   884,   758,   720,   753,     0,   721,    30,
     817,   805,   809,     0,     0,   813,   811,   798,   802,   794,
     836,   814,   812,   815,   796,   808,   804,   819,   826,   822,
     818,   825,   821,   828,   824,   795,   831,   833,   799,   834,
     829,   823,   797,   800,   803,   806,   810,   816,   820,   827,
     832,   835,   807,   792,   790,   789,   451,   755,     0,    26,
     751,   750,     0,   778,   777,    21,   104,   101,   102,   103,
      99,    22,   112,   108,   110,   120,   132,   130,   131,   119,
     852,   126,    23,   934,   208,    20,   413,   432,   876,   875,
     878,     0,     4,     0,     5,     6,     7,    97,     0,   190,
     437,   459,   394,   401,   466,   400,   399,   374,   379,   375,
     474,   475,   377,     0,   449,   376,   390,   450,   398,   392,
     372,   373,   470,   453,   154,   442,     0,   479,   476,   393,
     464,   469,   471,     0,    92,   478,   396,   397,     0,   405,
     406,     0,   155,   391,   462,   468,   473,   477,   480,   395,
     461,   463,   465,   402,   403,   378,   445,   446,   448,   512,
     454,   460,   534,   740,    80,    81,     0,    83,   147,     0,
      84,    88,    91,    82,    94,    86,    85,    87,    89,    90,
     311,   312,   217,   206,   361,   367,   368,   363,   364,   382,
     383,   388,   385,   404,   451,   407,   408,   481,   481,   369,
     443,   444,   370,   472,   371,   485,   506,   511,   507,   533,
     736,     0,   384,    96,   467,     0,     0,     0,     8,     9,
      11,    12,    13,    14,    15,     0,     0,     0,     0,   883,
     885,   748,     0,   768,   765,   766,   767,   583,     0,   907,
     906,   801,   899,   898,   830,     0,     0,     0,     0,    40,
       0,    75,    70,   598,    66,    69,    71,    76,    77,   602,
     603,     0,   591,    64,    68,    73,    74,   592,   594,     0,
     596,   599,    63,    65,    67,   601,    59,    61,     0,    60,
     764,   763,     0,   583,   884,   583,     0,   111,   109,   133,
     134,   129,   851,   853,   126,     0,   121,   122,   123,   127,
     115,     0,   719,   716,   717,   718,   481,   583,   470,   478,
       0,   138,   467,   194,     0,   196,   198,   197,     0,     0,
     193,   314,   438,   504,     0,   921,   922,   847,   636,   869,
     868,     0,     0,   734,     0,     0,   483,     0,   447,     0,
       0,   262,   871,   870,     0,   933,     0,   733,   733,   222,
     366,   362,   380,   365,   381,     0,   482,     0,   510,   532,
       0,   735,     0,    95,     0,   843,   844,     0,     0,   723,
     722,   414,   161,   170,   174,   166,   168,   169,   178,   912,
     910,   908,   909,   911,     0,   882,   738,   739,     0,     0,
     622,     0,     0,   937,   604,   610,   614,   624,   630,   665,
     618,   639,   627,     0,   611,   612,   617,   619,   625,   629,
     631,   608,   616,   621,   623,   628,   607,   609,   613,   642,
     643,   645,   605,   884,   640,   641,    18,   540,   668,   584,
     586,   587,   588,   589,   541,   542,     0,   664,     0,   757,
     756,   793,   791,   633,   634,   635,    62,   597,    72,   595,
       0,     0,    46,   566,   940,   939,    78,   842,   841,   590,
     936,   935,   593,   452,     0,   754,    25,    31,     0,    79,
     114,   113,     0,   117,   125,   124,   116,   209,     0,    19,
     140,   326,   195,   926,   925,   199,   200,   786,   785,     0,
     504,   441,   505,   440,   848,   924,   923,     0,   386,    93,
     861,   860,     0,   486,     0,   455,     0,     0,     0,     0,
     927,   141,   148,     0,     0,   151,   304,   437,   437,   437,
     559,   560,   561,   562,   563,   564,   310,   225,   226,   229,
     236,   237,   238,   239,   240,   230,   307,   231,   315,   232,
     318,   242,   243,   244,   733,     0,   736,     0,   322,   742,
     508,   313,   207,   223,   722,   414,     0,   409,     0,   737,
     323,   927,     0,     0,     0,   164,   181,     0,     0,     0,
     881,   606,   620,   632,   840,   839,   938,   637,   867,   866,
     626,   647,   646,   644,   749,   545,   566,   554,     0,   576,
       0,   549,   566,   672,   648,   649,   650,   651,   652,   872,
     558,   557,   582,   653,   654,     0,   655,     0,   669,   671,
     585,   583,   865,   864,     0,   760,   759,   600,    45,    46,
      46,    41,    54,    54,     0,     0,    49,    53,   583,   578,
     567,   788,   787,   888,   769,     0,    38,    39,    32,     0,
      33,   583,   118,   733,   846,   845,     0,   341,   343,   345,
     347,     0,   327,   328,   332,   333,   334,   335,   329,   330,
     331,   336,   927,    58,   192,   439,   156,   326,   389,     0,
       0,   458,   457,   456,     0,   519,   520,   539,     0,     0,
     301,   928,   728,     0,     0,   297,   300,     0,   326,     0,
     153,   150,   326,   256,   733,   320,   309,   321,     0,   927,
       0,   508,   733,   733,   733,   233,     0,   234,   235,   742,
     451,     0,     0,   741,   241,   509,   411,   412,   410,   349,
       0,   264,   275,     0,   416,   424,   425,   427,   426,   428,
     430,   415,   417,   423,   420,   429,     0,   162,   182,   180,
     167,   179,     0,   171,   172,     0,   176,   175,   638,   615,
     548,   546,   547,     0,   552,     0,   553,   930,   929,     0,
     901,   900,   577,   550,     0,   578,   873,   874,     0,   583,
     702,     0,     0,     0,   862,   892,   690,   689,   679,   687,
     681,   682,   685,   686,   699,   680,   684,   693,   694,     0,
       0,   666,   673,   677,   678,     0,   674,   675,   676,   670,
     663,   583,     0,     0,     0,    56,    50,     0,    51,    42,
       0,   572,     0,     0,   902,   903,    28,   579,     0,   889,
     884,   770,   771,    37,   772,    36,   775,    35,    27,   575,
     210,   213,   214,   220,   338,   326,   326,   326,   326,   337,
     746,   927,     0,   202,     0,   730,   729,     0,   501,   498,
     499,   492,   502,   494,   502,   496,   497,     0,     0,   491,
     500,     0,     0,   517,   522,   518,   535,   538,   275,     0,
     298,     0,   149,     0,   437,     0,   228,   227,   224,     0,
     899,   437,     0,     0,     0,     0,   246,   245,   308,   316,
     319,   317,   895,   894,     0,     0,   743,   355,   357,   359,
       0,   350,   351,   352,   353,   354,   275,   266,     0,   276,
     508,   275,   422,   420,   419,   421,   188,   183,   185,   915,
       0,     0,   173,   177,   880,   879,   583,   555,   658,     0,
     656,   762,   761,   731,   551,   566,   659,   703,     0,   859,
     858,   700,   891,   890,   691,   780,   779,   688,   863,   683,
     893,   692,   706,   704,   698,     0,     0,   772,     0,    44,
      43,   838,   837,    55,    52,    48,   568,     0,   581,   580,
       0,   773,   774,    57,   776,    34,   576,     0,   872,   211,
     326,   437,     0,   344,   346,   348,   747,   139,     0,   201,
       0,   189,   387,   784,   783,   487,     0,   493,   495,     0,
       0,     0,     0,     0,   528,   527,   526,   529,   531,     0,
       0,   525,   287,   303,   302,   296,   326,   855,   854,     0,
     152,   733,   305,   272,   255,     0,   247,   248,     0,   920,
     249,     0,   927,     0,   349,   349,   349,     0,   508,   265,
       0,     0,   260,   508,   418,   916,     0,   914,   913,   186,
     187,   543,     0,   732,     0,   578,   701,   931,   705,   772,
       0,   695,   578,   574,   573,   571,   905,   904,   583,   577,
       0,     0,   221,   326,   342,   275,   203,     0,   484,   490,
     513,   516,     0,   521,     0,     0,   263,   299,     0,     0,
     273,   274,   275,     0,     0,   252,     0,     0,     0,     0,
     356,   358,   360,   275,   259,   269,   270,   271,   267,   268,
       0,   278,   282,   280,   281,     0,   287,   897,   896,   184,
     782,   781,     0,   583,   556,   932,   710,   697,   696,   662,
      29,   887,   886,   566,   216,   215,   212,     0,   283,   326,
     503,   786,   530,   524,   291,   288,   289,   290,   745,   744,
       0,     0,   283,   253,   254,   250,   251,   272,   293,     0,
       0,   287,   279,   277,   258,   583,   544,   713,   707,     0,
     711,   578,     0,     0,   340,   286,   204,   142,   927,   287,
     275,   275,   324,   657,   884,   714,   708,   715,   712,   565,
     927,   284,     0,   261,   283,   283,     0,   326,   508,   287,
     325,   339,   285,   257,   306
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,    36,  -985,    18,   208,  -985,   172,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
     768,  -985,  -985,  -149,   367,   557,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,   866,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,   108,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,   280,  -985,  -985,
    -985,  -985,  -113,  -985,  -985,  -985,   871,  -368,  -985,   117,
    -985,  -985,  -985,  -985,  -216,  -985,  -985,   123,   641,  -985,
    -985,  -985,   509,   163,  -985,  -398,  -985,   321,  -985,  -348,
    -985,  -985,  -985,  -985,  -985,   324,  -985,  -985,  -728,  -985,
    -985,  -985,  -288,  -692,  -985,  -642,  -985,  -541,  -985,  -587,
    -984,     1,  -985,  -985,  -985,  -985,  -985,   328,  -985,  -262,
     775,  -985,  -985,  -985,  -985,  -985,  -105,  -985,  -985,   -35,
    -985,   897,  -985,  -985,  -588,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -355,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -153,  -985,   687,
    -148,  -400,   693,  -985,  -985,  -985,  -405,  -985,  -399,  -985,
    -985,  -985,  -985,    20,   326,  -985,   -34,   322,  -752,   150,
    -985,   926,     3,  -517,   190,  -132,  -289,  -232,  -273,  -985,
    -985,  -985,  -161,   263,  -985,  -985,  -985,  -985,  -109,    33,
     405,  -129,  -748,  -562,  -260,  -985,  -985,  -985,  -702,  -985,
    -985,  -104,  -186,  -985,   692,  -985,  -985,  -985,  -277,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,   474,  -985,
    -616,  -985,   103,  -985,  -985,    76,  -800,  -985,  -985,   262,
    -985,   478,  -107,  -985,   526,   517,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,   311,  -985,
    -249,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,  -985,
    -985,  -985,  -985,   556,    12,  -263,   575,    -2,  -985,  -339,
    -985,   948,  -120,  -985,    -4,  -229,  -985,  -985,  -985,   738,
    -243,   -30,  -985,  -985,  -985,  -985,  -985,   -95,   840,  -985,
    -909,  -985,   689,  -985,  -985,  -985,  -364,  -985,   223,  -985,
    -985,  -985,  -985,  -985,   958,  -985,  -985,  -985,  -985,  -985,
      -1,  -654,  -985,  -985,  -985,  -179,  -985,   -42,  -985,   721,
    -885,   708,  -985,   -49,  -985,  -985,  -985,  -985,  -985,  -985,
    -267,   -37,   -28,  -985,  -244,  -985,  -985,    22,  -985,  1059,
    -985,  -379,   -48,  -985,  -985,   342,  -985,   607,  -985,   676,
     565,  -985
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,    31,    32,    33,    34,   344,   526,   698,   699,
     513,   681,   684,   685,   686,   866,   700,   116,   336,   337,
      35,    36,   394,    37,    38,   130,    39,    40,    41,   133,
     134,   347,    42,   359,   536,   360,   140,   351,    43,    44,
      45,   224,   541,   225,   748,    46,   227,   405,   749,   228,
     752,   229,   230,    47,    48,   286,   626,    49,   285,    50,
     287,   627,   435,   436,   437,   800,   797,   798,   979,   231,
     378,   379,   687,   723,  1051,  1199,    51,   233,   409,    52,
     361,   703,   890,  1131,   891,  1196,   234,    53,    54,   151,
    1040,   612,   586,   587,   938,   588,   765,   589,   590,   899,
     591,   934,   235,   236,   237,   592,   238,   570,   782,   967,
    1099,  1168,  1152,   970,  1175,  1234,  1257,  1146,  1219,   743,
     744,   745,  1076,  1075,   593,   754,   594,   595,   762,   708,
     239,   240,   408,   241,   597,   763,   709,   599,   764,   710,
     601,   602,   779,   603,   711,   712,   713,   714,   715,  1041,
     716,   717,   895,   718,   896,   719,   897,   720,   898,   960,
     961,   962,  1094,   963,  1095,   964,  1096,   243,   412,   244,
     245,   246,   247,   248,   249,   727,   250,   251,   252,   253,
     254,   255,   256,   257,   625,   791,   974,   975,   793,   794,
     146,    56,   258,   381,   382,   259,   260,   338,   261,   398,
     262,   263,   415,   264,   563,   730,   917,   918,   919,  1057,
     551,   265,   774,   266,   267,   399,   921,   922,   737,   925,
    1069,  1070,  1071,   268,   269,   400,   738,   739,   871,   654,
     813,   824,   655,   656,   657,   816,   658,   659,   604,   888,
     689,   690,   872,   873,  1125,   661,   876,   877,   487,   488,
     489,   490,   491,   492,   506,   387,   809,   493,   643,   662,
     663,   664,   665,   494,   495,   666,   667,   668,   669,   851,
     852,   853,   854,   855,   998,   856,   857,  1118,  1228,  1229,
    1230,  1246,   365,   366,   605,   431,   616,    64,   746,   907,
    1114,   607,   272,   421,   609,   721,   773,  1210,  1047,   121,
     497,   122,    67,   118,    68,   677,   993,   343,   297,   883,
    1033,  1035,   125,  1007,  1182,  1055,   929,   693,   119,  1023,
     636,   519,   427,   706,   372,   275,   353,   354,  1079,   276,
    1001,   562,  1009,   674,   640,   391,   404,   828,   150,    58,
     986,   289,   290,   644,  1193,   880,  1004,  1011,   955,  1179,
     304,   822,   878,  1128,   301,   443,   444,  1109,  1106,    59,
    1091,   388,   557,   545,   747,   819,  1186,   144,   522,   498,
     516,   277
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      65,    65,    65,   153,    57,   371,   418,   392,   484,   339,
     611,   141,   556,   947,   291,   549,    63,    63,    63,   395,
     486,    55,   414,   432,   485,   994,   559,   345,   383,    65,
     814,   384,   923,   273,   780,   270,   825,   927,   501,   502,
     972,   884,  1053,   555,  1177,    63,   380,   120,   775,   523,
     406,   675,   966,   429,   484,   971,   484,   530,   514,   362,
     755,   756,   757,  1107,   520,   429,   527,   433,   529,   292,
     485,  -720,   485,   735,   735,   905,   148,   292,   484,   735,
     735,   682,   439,  1172,   641,   517,   999,  1191,   653,  1208,
     539,   564,  1233,  1204,   485,   340,   410,   417,  1005,   560,
    1014,   704,  1021,   802,  1112,   507,   683,   799,  1121,  -294,
     126,  1077,   341,   864,   302,   389,  1170,   547,   956,   874,
     534,   293,   678,   984,   864,   523,   540,  1002,   547,   547,
     373,   374,   299,   547,   127,   902,   672,   440,   294,   904,
     128,   340,   820,  -536,  -514,   596,   596,   596,   867,  -537,
     356,   881,   615,   132,   617,   129,   270,   295,   341,   817,
     931,  1015,   143,   565,   933,   375,   638,   985,   566,  1016,
     543,   385,   939,  1003,   386,  1220,   673,   296,   610,   610,
     610,   630,   760,   508,   390,   810,   303,   -47,   707,   -47,
     882,   679,   509,   680,   821,   577,   578,   740,  -295,   775,
     484,  -191,   300,  -570,  -660,   538,   535,  1078,   537,   510,
    1187,  1083,   705,   875,   803,   818,   485,    61,    62,   789,
     568,   569,  1102,   972,   342,   790,   579,   865,  1205,  1183,
    1000,  1006,    15,   577,   578,    17,  1072,  1022,   865,   558,
     741,   761,   270,   944,   288,   621,   548,   292,   622,    20,
     550,   571,   553,   575,   552,   376,   298,   548,   548,   305,
    -660,  1063,   548,    21,   579,   410,   515,   149,   653,   620,
     576,  1173,   357,    24,  1098,   772,   219,  1206,   578,  1103,
    1192,    65,    65,   772,   642,   438,  1174,   608,   608,   608,
     447,   441,   676,   496,   500,   528,   499,   430,   430,   732,
     733,   521,   598,   598,   598,   892,   518,  1042,  1043,  1044,
    1045,  1054,   525,   726,  1048,  1184,  1178,   742,   728,   302,
    1135,   870,  1189,   385,  -724,    60,   386,   358,    61,    62,
     751,    60,   377,  1108,    61,    62,   531,   363,    65,   496,
     364,   496,   596,    60,   639,   434,    61,    62,    61,    62,
    1164,   736,   736,   906,    63,  1176,   935,   736,   736,   270,
    1141,  1119,  1120,   496,   948,   949,   950,    60,   567,  1163,
    1207,   544,   600,   600,   600,   610,   561,  1017,   796,  1115,
    -100,   932,   484,   535,  -100,   811,   812,   789,   306,   734,
     270,   303,   270,   790,   860,   193,  -438,    60,   485,   484,
      61,    62,   270,   547,   270,   606,   606,   606,   775,  1180,
     484,    65,   484,    65,   694,   485,    65,  1081,   761,   402,
     270,   552,   887,   123,  1085,   124,   485,   614,   485,   614,
    1217,  1249,   619,   701,  1227,    60,   724,   547,    61,    62,
      65,   596,   346,  1198,   783,   383,   383,   383,   384,   384,
     384,   547,  1132,  -740,   373,   374,   430,  -661,   511,  1126,
    1212,   695,   671,   982,   355,  1064,   983,   900,  1089,  1065,
    1066,  1221,  1067,  -515,   610,  1068,   174,   356,  1248,    60,
     288,   177,    61,    62,   608,  1201,   352,   183,  1147,   375,
     185,    15,   596,   946,   547,   861,   596,   299,   532,  -740,
     596,   596,   596,  -907,   795,  1158,   512,  -523,   292,  1027,
    1263,   356,   874,  -661,   403,   418,   634,   957,  1153,  1154,
     416,   416,    21,  -489,  1133,   610,   805,   393,  1024,   610,
     484,   691,   548,   610,   610,   610,   775,   547,   951,   396,
     484,   775,   990,   507,   635,  1197,   485,   858,  1254,  1255,
     965,  -942,   996,   893,  1060,   300,   485,   692,  1062,    15,
    1150,   201,    17,   420,  1222,  -758,   548,   300,   760,   696,
    1239,   987,   484,  -907,   216,   217,   218,  1231,   220,   376,
     548,   452,   453,   608,  1156,  1157,  1012,  1013,   485,   484,
      21,  1151,   991,   826,   930,   827,  -919,  -919,   598,   357,
     769,  1029,   270,   219,   397,   485,   875,  -292,   992,   222,
     174,  1236,  1259,  1260,   548,   177,  1093,   697,   620,   174,
     976,   632,   270,   548,   177,   807,   804,   806,   383,   416,
     509,   384,  -907,   357,   608,  1224,  1235,    60,   608,   401,
      61,    62,   608,   608,   608,   349,  -857,   510,  -857,   598,
    1235,  1252,   350,   598,   358,   219,   377,   598,   598,   598,
    1052,   222,   523,  1256,   407,   270,   548,   496,   600,  1262,
     850,   424,   795,   425,   958,  1086,  1087,   556,  1090,  1165,
    1242,   174,  1166,  1149,   496,   968,   177,   849,   358,  1080,
      29,  1082,  1235,  1235,    30,   496,   775,   484,  1253,   785,
     131,   606,   786,   142,   270,   908,  1144,   145,   787,  1111,
     969,   420,  1167,   485,   788,   862,   863,    60,  1264,   600,
      61,    62,   759,   600,   760,   219,   920,   600,   600,   600,
     503,   504,   446,   892,   505,    61,    62,   222,   484,  1160,
    1161,  1162,    66,   117,   959,   270,  -857,   270,   422,  -238,
    1124,  -238,   606,  1031,   485,  1032,   606,  -850,    28,   428,
     606,   606,   606,  1036,   542,  1037,   908,   546,   624,   270,
      15,   426,    16,    17,   729,  1092,   554,  -488,  1144,    19,
     628,  1097,   629,   688,   722,   758,   753,    20,   731,  1100,
     270,   750,  1138,   770,   771,   781,   339,  -725,  1134,    57,
     777,    21,   383,   778,   808,   384,   815,   796,   823,   383,
    1169,    24,   384,   550,   869,   496,    55,  1140,   879,   596,
     901,  1155,   924,   894,   174,   496,   926,    28,   928,   177,
     995,  1030,   957,   957,   957,   183,   997,  1008,   185,   484,
    1010,  1019,  1034,  1026,  1020,    65,    65,    60,  1049,  1039,
    1056,  1190,   610,  1061,  1059,   485,  1171,   496,  1084,  1101,
    1105,   430,   430,  1113,  1088,   965,   965,   965,  1117,   596,
     174,  1122,  1143,   784,   496,   177,  1188,   760,  1145,  1185,
     936,   183,  1241,  1258,   185,  1261,  1213,  1214,  1025,  1215,
    1216,   868,   977,  1200,   484,   903,  1046,  1136,  1202,   702,
    1148,   348,   610,   226,   978,  1211,  1226,   801,   232,   383,
     485,   533,   384,   980,  1159,  1195,   423,   909,   613,   981,
     910,   937,   216,   217,   218,   766,   220,   911,   767,  1240,
    1074,  1223,   768,   370,   242,   413,   484,   411,   912,  1104,
     913,   776,   973,   914,   915,   147,   792,  1058,  1243,   576,
     945,  1139,   485,  1232,   916,   725,   577,   578,  1203,  1142,
     419,   608,   660,   889,  1018,  1038,  1237,   670,   216,   217,
     218,   219,   220,   637,   631,   418,   598,   222,   909,   859,
    1245,   910,   496,    60,   623,   271,  1247,   579,   911,   958,
     958,   958,   618,   367,   954,   274,  1130,  1116,   445,   912,
    1129,   913,  1127,  1110,   914,   915,   162,   829,  1137,   442,
     163,   608,   572,   165,   524,   916,   633,   166,   785,     0,
       0,   786,     0,   496,     0,     0,   598,   787,     0,     0,
       0,     0,  1238,   788,   176,     0,   178,   179,     0,     0,
       0,     0,     0,   157,    60,     0,   600,     0,   270,     0,
       0,     0,   189,  1250,     0,     0,   920,     0,     0,   959,
     959,   959,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -733,   193,     0,     0,     0,     0,   606,
    1251,     0,   196,   197,   198,     0,   199,   200,     0,     0,
       0,   152,   203,   154,   155,   156,   600,   278,   279,     0,
     280,   281,   282,   283,   284,     0,     0,     0,     0,     0,
       0,     0,   158,   209,   159,  1181,     0,     0,     0,     0,
     160,     0,     0,  -941,   496,   213,   214,     0,     0,   606,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   580,   581,  1209,   582,   583,   584,   585,     0,
       0,     0,  1225,     0,    61,    62,     0,     0,    60,     0,
       0,    61,    62,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   161,     0,     0,   162,     0,    65,   496,
     163,     0,   164,   165,     0,     0,     0,   166,   167,   168,
       0,   169,   170,    15,    63,   171,    17,   172,     0,   173,
     174,     0,    19,   175,   176,   177,   178,   179,   180,   181,
     182,   183,   184,     0,   185,   186,     0,   187,     0,   188,
       0,   496,   189,     0,    21,    22,  -856,     0,  -856,    23,
     190,   270,   191,   192,     0,     0,  -733,   193,     0,     0,
       0,    25,    26,    27,     0,     0,     0,     0,     0,   194,
    -849,   195,   196,   197,   198,     0,   199,   200,     0,   201,
     202,     0,   203,     0,   952,     0,   204,     0,     0,   205,
       0,     0,   206,     0,     0,   207,     0,     0,     0,     0,
       0,     0,   208,   209,     0,     0,   210,   211,     0,     0,
       0,   212,     0,     0,     0,   213,   214,   215,   216,   217,
     218,   219,   220,   221,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   223,     0,     0,    61,    62,  -856,    70,     0,     0,
       0,    71,    72,    73,     0,    74,     0,    75,    76,     0,
      77,    78,    79,     0,    80,    81,     0,    82,     0,    83,
      84,    85,    86,    87,     0,    88,     0,    89,     0,    90,
      91,    92,     0,    93,     0,    94,     0,    95,     0,    96,
      97,    98,    99,   100,     0,   101,   102,     0,   103,   104,
     940,   105,     0,   106,     0,   107,     0,   108,     0,   109,
       0,   110,   111,   112,   161,     0,     0,   162,     0,     0,
       0,   163,     0,   164,   165,     0,     0,     0,   166,   167,
     168,     0,   169,   170,    15,     0,   171,    17,   172,     0,
       0,   174,     0,    19,   175,   176,   177,   178,   179,   180,
     181,   368,   183,     0,     0,   185,   186,     0,   187,     0,
     188,     0,     0,   189,     0,    21,     0,     0,   113,   135,
       0,   190,   303,   191,   192,     0,   114,  -437,     0,     0,
       0,     0,     0,     0,   136,     0,  -128,     0,     0,     0,
       0,     0,   369,   196,   197,   198,     0,   199,   200,  -128,
     201,     0,     0,   203,     0,     0,     0,   204,     0,     0,
     205,     0,     0,   206,   953,     0,   207,     0,     0,   137,
       0,     0,     0,   208,   209,     0,   138,   210,   211,   115,
       0,     0,   212,     0,     0,     0,   213,   214,   215,   216,
     217,   218,   219,   220,   221,     0,     0,     0,   222,   941,
       0,   885,     0,     0,   448,     0,     0,   174,     0,     0,
     449,     0,   177,     0,     0,    61,    62,  -583,   183,  -583,
    -583,   185,     0,     0,     0,     0,  -583,     0,     0,     0,
    -583,     0,     0,     0,  -583,  -583,     0,     0,     0,     0,
       0,     0,  -583,   450,  -583,     0,     0,     0,  -583,     0,
       0,     0,   451,  -583,     0,  -583,     0,     0,   452,   453,
    -583,  -583,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -128,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   216,   217,   218,   219,   220,
       0,     0,     0,     0,   222,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -128,   942,   943,     0,
       0,   454,     0,     0,  -583,     0,   455,     0,  -583,     0,
     456,  -583,     0,     0,     0,  -583,  -583,  -583,     0,  -583,
     457,  -583,     0,   458,  -583,  -583,     0,     0,   174,   459,
    -583,  -583,  -583,   177,  -583,  -583,  -583,  -583,   460,   183,
       0,     0,   461,     0,     0,   313,   576,   462,   463,     0,
    -583,     0,  -583,   577,   578,   464,     0,     0,   465,  -128,
     466,   467,     0,  -128,     0,  -128,     0,   139,     0,     0,
      61,    62,   468,   469,     0,     0,     0,     0,     0,   470,
    -583,  -583,  -583,   319,   579,     0,   320,     0,     0,     0,
    -583,   321,     0,   322,   471,     0,     0,   472,   473,     0,
     474,     0,     0,   475,   327,     0,   328,   329,     0,   330,
     331,  -583,     0,     0,   476,   477,     0,     0,     0,   478,
     335,     0,     0,  -583,  -583,  -583,   479,   480,   481,     0,
     220,   482,  -583,  -583,  -583,     0,  -583,  -583,  -583,  -583,
       0,   988,     0,     0,   448,     0,     0,     0,   886,   483,
     449,     0,  -583,  -583,     0,     0,     0,  -583,     0,  -583,
    -583,     0,     0,     0,     0,     0,  -583,     0,     0,     0,
    -583,   193,     0,     0,  -583,  -583,     0,     0,     0,     0,
       0,     0,   989,   450,  -583,     0,     0,     0,  -583,     0,
       0,     0,   451,  -583,     0,  -583,     0,     0,   452,   453,
    -583,  -583,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   580,
     581,     0,   582,   583,   584,   585,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    60,     0,     0,    61,    62,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   454,     0,     0,  -583,     0,   455,     0,  -583,     0,
     456,  -583,     0,     0,     0,  -583,  -583,  -583,     0,  -583,
     457,  -583,     0,   458,  -583,  -583,     0,     0,   174,   459,
    -583,  -583,  -583,   177,  -583,  -583,  -583,  -583,   460,   183,
       0,     0,   461,     0,     0,   313,     0,   462,   463,     0,
    -583,     0,  -583,     0,     0,   464,     0,     0,   465,     0,
     466,   467,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   468,   469,     0,     0,     0,     0,     0,   470,
    -583,  -583,  -583,   319,     0,     0,   320,     0,     0,     0,
    -583,   321,     0,   322,   471,     0,     0,   472,   473,     0,
     474,     0,     0,   475,   327,     0,   328,   329,     0,   330,
     331,  -583,     0,     0,   476,   477,     0,     0,     0,   478,
     335,     0,     0,  -583,  -583,  -583,   479,   480,   481,     0,
     220,   482,  -583,  -583,  -583,     0,  -583,  -583,  -583,  -583,
       0,  1028,     0,     0,   448,     0,     0,     0,     0,   483,
     449,     0,  -583,  -583,     0,     0,     0,  -583,     0,  -583,
    -583,     0,     0,     0,     0,     0,  -583,     0,     0,     0,
    -583,     0,     0,     0,  -583,  -583,     0,     0,     0,     0,
       0,     0,  -583,   450,  -583,     0,     0,     0,  -583,     0,
       0,     0,   451,  -583,     0,  -583,     0,     0,   452,   453,
    -583,  -583,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   454,     0,     0,  -583,     0,   455,     0,  -583,     0,
     456,  -583,     0,     0,     0,  -583,  -583,  -583,     0,  -583,
     457,  -583,     0,   458,  -583,  -583,     0,     0,   174,   459,
    -583,  -583,  -583,   177,  -583,  -583,  -583,  -583,   460,   183,
       0,     0,   461,     0,     0,   313,     0,   462,   463,     0,
    -583,     0,  -583,     0,     0,   464,     0,     0,   465,     0,
     466,   467,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   468,   469,     0,     0,     0,     0,     0,   470,
    -583,  -583,  -583,   319,     0,     0,   320,     0,     0,     0,
    -583,   321,     0,   322,   471,     0,     0,   472,   473,     0,
     474,     0,     0,   475,   327,     0,   328,   329,     0,   330,
     331,  -583,     0,     0,   476,   477,     0,     0,     0,   478,
     335,     0,     0,  -583,  -583,  -583,   479,   480,   481,     0,
     220,   482,  -583,  -583,  -583,     0,  -583,  -583,  -583,  -583,
       0,  1123,     0,     0,   448,     0,     0,     0,     0,   483,
     449,     0,  -583,  -583,     0,     0,     0,  -583,     0,  -583,
    -583,     0,     0,     0,     0,     0,  -583,     0,     0,     0,
    -583,     0,     0,     0,  -583,  -583,     0,     0,     0,     0,
       0,     0,  -583,   450,  -583,     0,     0,     0,  -583,     0,
       0,     0,   451,  -583,     0,  -583,     0,     0,   452,   453,
    -583,  -583,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   454,     0,     0,  -583,     0,   455,     0,  -583,     0,
     456,  -583,     0,     0,     0,  -583,  -583,  -583,     0,  -583,
     457,  -583,     0,   458,  -583,  -583,     0,     0,   174,   459,
    -583,  -583,  -583,   177,  -583,  -583,  -583,  -583,   460,   183,
       0,     0,   461,     0,     0,   313,     0,   462,   463,     0,
    -583,     0,  -583,     0,     0,   464,     0,     0,   465,     0,
     466,   467,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   468,   469,     0,     0,     0,     0,     0,   470,
    -583,  -583,  -583,   319,     0,     0,   320,     0,     0,     0,
    -583,   321,     0,   322,   471,     0,     0,   472,   473,     0,
     474,     0,     0,   475,   327,     0,   328,   329,     0,   330,
     331,  -583,     0,    69,   476,   477,   -58,     0,     0,   478,
     335,     0,   -58,  -583,  -583,  -583,   479,   480,   481,     0,
     220,   482,  -583,  -583,  -583,     0,  -583,  -583,  -583,  -583,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   483,
     -58,     0,  -583,  -583,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   -58,     0,     0,     0,     0,     0,
     -58,   -58,     0,     0,     0,     0,    70,     0,     0,     0,
      71,    72,    73,     0,    74,     0,    75,    76,     0,    77,
      78,    79,     0,    80,    81,     0,    82,     0,    83,    84,
      85,    86,    87,     0,    88,     0,    89,     0,    90,    91,
      92,     0,    93,     0,    94,     0,    95,     0,    96,    97,
      98,    99,   100,     0,   101,   102,     0,   103,   104,     0,
     105,     0,   106,     0,   107,     0,   108,     0,   109,     0,
     110,   111,   112,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   299,     0,     0,     0,     0,     0,     0,
       0,     0,   -58,     0,     0,     0,     0,     0,     0,     0,
     -58,     0,     0,     0,     0,   -58,     0,     0,     0,     0,
     -58,     0,     0,     0,     0,     0,     0,   -58,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   113,     0,  -709,
     -58,     0,   -58,   -58,     0,   114,     0,     0,     0,     0,
       0,     0,     0,  -709,     0,   -58,     0,     0,     0,     0,
       0,   -58,     0,   300,     0,   -58,     0,     0,   -58,     0,
       0,     0,     0,   -58,     0,   -58,   -58,     0,     0,   -58,
     -58,     0,   -58,     0,     0,     0,   -58,     0,   -58,   -58,
       0,   -58,   -58,     0,     0,     0,   -58,   -58,   115,     0,
    -709,   -58,   -58,     0,     0,     0,     0,     0,     0,  -709,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -927,     0,     0,  -927,     0,     0,     0,
    -927,    60,  -927,  -927,    61,    62,     0,  -927,  -927,  -927,
    1073,  -927,  -927,  -927,     0,  -927,  -927,  -927,     0,     0,
    -927,   740,  -927,  -927,  -927,  -927,  -927,  -927,  -927,  -927,
    -927,  -927,     0,     0,  -927,  -927,     0,  -927,  -709,  -927,
       0,     0,  -927,     0,  -927,     0,     0,     0,     0,     0,
    -927,     0,  -927,  -927,   785,     0,     0,   786,     0,     0,
       0,     0,     0,   787,   741,     0,     0,     0,     0,   788,
       0,  -927,  -927,  -927,  -927,     0,  -927,  -927,  -709,  -927,
       0,     0,  -927,     0,     0,     0,  -927,     0,     0,  -927,
       0,     0,  -927,     0,     0,  -927,     0,     0,     0,     0,
       0,     0,  -927,  -927,     0,     0,  -927,  -927,     0,     0,
       0,  -927,     0,     0,     0,  -927,  -927,  -927,  -927,  -927,
    -927,  -927,  -927,  -927,     0,     0,  -709,  -927,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -927,   742,     0,  -927,  -927,  -927,     0,  -927,     0,  -927,
    -927,     0,     0,     0,  -927,  -927,  -927,  1218,  -927,  -927,
    -927,     0,  -927,  -927,  -927,     0,     0,  -927,   740,  -927,
    -927,  -927,  -927,  -927,  -927,  -927,  -927,  -927,  -927,  -709,
       0,  -927,  -927,  -709,  -927,     0,  -927,     0,     0,  -927,
       0,  -927,     0,     0,     0,     0,     0,  -927,     0,  -927,
    -927,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   741,     0,     0,     0,     0,     0,     0,  -927,  -927,
    -927,  -927,     0,  -927,  -927,     0,  -927,     0,     0,  -927,
       0,     0,     0,  -927,     0,     0,  -927,     0,     0,  -927,
       0,     0,  -927,     0,     0,     0,     0,     0,     0,  -927,
    -927,     0,     0,  -927,  -927,     0,     0,     0,  -927,     0,
       0,     0,  -927,  -927,  -927,  -927,  -927,  -927,  -927,  -927,
    -927,     0,     0,     0,  -927,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -927,   742,     0,
    -927,  -927,  -927,     0,  -927,     0,  -927,  -927,     0,     0,
       0,  -927,  -927,  -927,   573,  -927,  -927,  -927,     0,  -927,
    -927,  -927,     0,     0,  -927,   740,  -927,  -927,  -927,  -927,
    -927,  -927,  -927,  -927,  -927,  -927,     0,     0,  -927,  -927,
       0,  -927,     0,  -927,     0,     0,  -927,     0,  -927,     0,
       0,     0,     0,     0,  -927,     0,  -927,  -927,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   741,     0,
       0,     0,     0,     0,     0,  -927,  -927,  -927,  -927,     0,
    -927,  -927,     0,  -927,     0,     0,  -927,     0,     0,     0,
    -927,     0,     0,  -927,     0,     0,  -927,     0,     0,  -927,
       0,     0,     0,     0,     0,     0,  -927,  -927,     0,     0,
    -927,  -927,     0,     0,     0,  -927,     0,     0,     0,  -927,
    -927,  -927,  -927,  -927,  -927,  -927,  -927,  -927,     0,  1194,
       0,  -927,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   161,   742,     0,   162,  -927,  -927,
       0,   163,     0,   164,   165,     0,     0,     0,   166,   167,
     168,     0,   169,   170,    15,     0,   171,    17,   172,     0,
       0,   174,     0,    19,   175,   176,   177,   178,   179,   180,
     181,   368,   183,     0,     0,   185,   186,     0,   187,     0,
     188,     0,     0,   189,     0,    21,     0,     0,   576,     0,
       0,   190,     0,   191,   192,   577,   578,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   369,   196,   197,   198,     0,   199,   200,     0,
     201,     0,     0,   203,     0,     0,   579,   204,     0,     0,
     205,     0,     0,   206,   448,     0,   207,     0,     0,     0,
     449,     0,     0,   208,   209,     0,     0,   210,   211,     0,
       0,     0,   212,     0,     0,     0,   213,   214,   215,   216,
     217,   218,   219,   220,   221,     0,     0,     0,   222,     0,
       0,     0,     0,   450,     0,     0,     0,     0,     0,     0,
       0,   574,   451,     0,     0,    61,    62,     0,   452,   453,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -569,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -733,   193,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   576,     0,     0,     0,     0,
       0,     0,   577,   578,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   454,     0,   579,     0,     0,   455,     0,     0,     0,
     456,   448,     0,     0,     0,     0,     0,   449,     0,     0,
     457,   580,   581,   458,   582,   583,   584,   585,   174,   459,
       0,     0,     0,   177,     0,     0,     0,    60,   460,   183,
      61,    62,   461,     0,     0,   313,     0,   462,   463,     0,
     450,     0,     0,     0,     0,   464,     0,     0,   465,   451,
     466,   467,     0,     0,     0,   452,   453,     0,     0,     0,
       0,     0,   468,   469,     0,     0,     0,     0,     0,   470,
       0,     0,     0,   319,     0,     0,   320,     0,     0,  -733,
     193,   321,     0,   322,   471,     0,     0,   472,   473,     0,
     474,     0,     0,   475,   327,     0,   328,   329,     0,   330,
     331,     0,     0,     0,   476,   477,     0,     0,     0,   478,
     335,     0,     0,     0,     0,     0,   479,   480,   481,     0,
     220,   482,     0,     0,     0,     0,     0,     0,   454,     0,
       0,     0,  -667,   455,     0,     0,   307,   456,     0,   483,
       0,     0,   308,     0,     0,     0,  -667,   457,   580,   581,
     458,   582,   583,   584,   585,   174,   459,     0,     0,     0,
     177,     0,     0,     0,    60,   460,   183,    61,    62,   461,
     309,     0,   313,     0,   462,   463,     0,     0,     0,     0,
       0,     0,   464,     0,   310,   465,     0,   466,   467,     0,
       0,     0,     0,  -667,     0,     0,     0,     0,     0,   468,
     469,     0,  -667,     0,     0,     0,   470,     0,     0,     0,
     319,     0,     0,   320,     0,     0,     0,     0,   321,     0,
     322,   471,     0,     0,   472,   473,     0,   474,     0,     0,
     475,   327,     0,   328,   329,     0,   330,   331,     0,     0,
       0,   476,   477,     0,     0,     0,   478,   335,     0,     0,
       0,     0,     0,   479,   480,   481,     0,   220,   482,     2,
       3,  -667,     4,     0,     5,     6,     7,     8,     9,     0,
      10,    11,    12,    13,     0,     0,   483,   167,   168,     0,
     169,     0,   311,     0,     0,     0,   172,     0,     0,   830,
     831,     0,   175,     0,     0,     0,     0,   180,   181,     0,
     312,  -667,     0,     0,   832,     0,     0,   313,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     314,     0,   315,   316,     0,     0,     0,     0,     0,     0,
       0,   833,     0,     0,     0,   317,     0,     0,     0,     0,
       0,   318,     0,     0,     0,   319,   830,   831,   320,  -667,
       0,     0,     0,   321,     0,   322,   323,     0,     0,   324,
     325,   832,   326,     0,     0,     0,   327,     0,   328,   329,
       0,   330,   331,     0,     0,     0,   332,   333,     0,     0,
       0,   334,   335,     0,     0,     0,   215,     0,   833,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -667,     0,   834,     0,  -667,     0,   835,    14,
      15,   836,    16,    17,     0,   837,     0,    18,     0,    19,
       0,    15,     0,   448,    17,     0,     0,    20,     0,   449,
      19,     0,   838,     0,   839,   840,     0,     0,     0,     0,
       0,    21,    22,     0,     0,     0,    23,     0,     0,     0,
     841,    24,    21,     0,     0,     0,     0,     0,    25,    26,
      27,   834,   450,     0,     0,   835,     0,    28,   836,     0,
     645,   451,   837,     0,     0,     0,     0,     0,     0,   646,
     842,   843,   844,   647,     0,     0,     0,     0,  -575,   838,
     845,   839,   840,     0,     0,  -575,     0,  -575,     0,     0,
       0,   648,     0,     0,     0,     0,   649,   841,   650,     0,
       0,   846,     0,   651,     0,     0,     0,     0,     0,   307,
       0,     0,     0,   847,   848,   308,     0,     0,     0,     0,
      29,     0,     0,     0,    30,     0,     0,   842,   843,   844,
       0,     0,     0,     0,     0,     0,     0,   845,     0,     0,
     454,     0,    61,    62,     0,   455,     0,     0,     0,   456,
       0,     0,     0,     0,     0,     0,     0,   310,   846,   457,
       0,     0,   458,     0,     0,     0,     0,   174,     0,     0,
     847,   848,   177,     0,     0,     0,     0,   460,   183,     0,
    1050,   461,     0,     0,   313,     0,   462,   463,     0,   167,
     168,     0,   169,     0,   464,     0,  1244,   465,   172,   466,
     467,     0,     0,     0,   175,     0,     0,     0,     0,   180,
     181,   468,   469,     0,     0,     0,     0,     0,   470,     0,
       0,     0,   319,     0,     0,   320,     0,     0,     0,     0,
     321,     0,   322,   471,     0,     0,   472,   473,     0,   474,
       0,     0,   475,   327,     0,   328,   329,     0,   330,   331,
       0,     0,     0,   476,   477,   311,     0,     0,   478,   335,
       0,     0,     0,     0,     0,   479,   480,   481,     0,   220,
     482,     0,     0,   312,     0,     0,     0,     0,     0,     0,
     313,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   314,     0,   315,   316,     0,   215,     0,
     160,     0,     0,     0,     0,   652,   580,   581,   317,   582,
     583,   584,   585,     0,   318,     0,     0,     0,   319,     0,
       0,   320,     0,     0,     0,     0,   321,     0,   322,   323,
       0,     0,   324,   325,     0,   326,     0,     0,     0,   327,
       0,   328,   329,     0,   330,   331,     0,     0,     0,   332,
     333,     0,     0,   161,   334,   335,   162,     0,     0,     0,
     163,     0,   164,   165,     0,     0,     0,   166,   167,   168,
       0,   169,   170,    15,     0,   171,    17,   172,     0,     0,
     174,     0,    19,   175,   176,   177,   178,   179,   180,   181,
     368,   183,     0,     0,   185,   186,     0,   187,     0,   188,
       0,     0,   189,     0,    21,     0,     0,     0,     0,     0,
     190,     0,   191,   192,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   369,   196,   197,   198,     0,   199,   200,     0,   201,
       0,     0,   203,     0,     0,     0,   204,     0,     0,   205,
       0,     0,   206,     0,     0,   207,     0,     0,     0,     0,
       0,     0,   208,   209,     0,     0,   210,   211,     0,     0,
       0,   212,     0,     0,     0,   213,   214,   215,   216,   217,
     218,   219,   220,   221,     0,     0,     0,   222,     0,     0,
       0,     0,   161,     0,     0,   162,     0,     0,     0,   163,
       0,   164,   165,     0,    61,    62,   166,   167,   168,     0,
     169,   170,    15,     0,   171,    17,   172,     0,     0,   174,
       0,    19,   175,   176,   177,   178,   179,   180,   181,   368,
     183,     0,     0,   185,   186,     0,   187,     0,   188,     0,
       0,   189,     0,    21,     0,     0,     0,     0,     0,   190,
       0,   191,   192,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     369,   196,   197,   198,     0,   199,   200,     0,   201,     0,
       0,   203,     0,     0,     0,   204,     0,     0,   205,     0,
       0,   206,     0,     0,   207,     0,     0,     0,     0,     0,
       0,   208,   209,     0,     0,   210,   211,     0,     0,     0,
     212,     0,     0,     0,   213,   214,   215,   216,   217,   218,
     219,   220,   221,     0,   162,     0,   222,     0,   163,     0,
       0,   165,     0,     0,     0,   166,   785,     0,     0,   786,
       0,     0,     0,    61,    62,   787,     0,     0,     0,     0,
       0,   788,   176,     0,   178,   179,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     189,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     196,   197,   198,     0,   199,   200,     0,     0,     0,     0,
     203,     0,     0,     0,     0,     0,     0,     0,   161,     0,
       0,     0,     0,     0,     0,     0,     0,   164,     0,     0,
       0,   209,     0,   167,   168,     0,   169,   170,     0,     0,
     171,     0,   172,   213,   214,   174,     0,     0,   175,     0,
     177,     0,     0,   180,   181,   368,   183,     0,     0,   185,
       0,     0,   187,     0,   188,     0,     0,     0,     0,     0,
       0,     0,    61,    62,     0,   190,     0,   191,   192,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   369,     0,     0,     0,
       0,     0,     0,     0,   201,     0,     0,     0,     0,     0,
       0,   204,     0,     0,   205,     0,     0,   206,     0,     0,
     207,     0,     0,     0,     0,     0,     0,   208,     0,     0,
       0,   210,   211,     0,     0,     0,   212,     0,     0,     0,
       0,     0,   215,   216,   217,   218,   219,   220,   221,     0,
       0,     0,   222
};

static const yytype_int16 yycheck[] =
{
       4,     5,     6,    33,     1,   158,   266,   186,   297,   116,
     408,    13,   391,   761,    63,   379,     4,     5,     6,   198,
     297,     1,   254,   286,   297,   825,   394,   122,   160,    33,
     646,   160,   734,    37,   621,    37,   652,   739,   305,   306,
     792,   695,     1,     1,     1,    33,   159,     1,   610,   338,
     229,     1,   780,     1,   343,   783,   345,     1,     1,     1,
     577,   578,   579,     1,     1,     1,   343,     1,   345,    64,
     343,    66,   345,     1,     1,     1,     1,    64,   367,     1,
       1,    28,     1,     1,    78,     1,     1,     1,   488,     1,
     367,     1,    75,     1,   367,     1,   244,   258,     1,     1,
       1,     1,     1,   168,   989,   148,    53,     1,  1017,    71,
       1,     1,    18,    22,     1,     1,  1100,     1,   772,    54,
       1,     1,     1,     1,    22,   414,   370,     1,     1,     1,
      77,    78,     1,     1,    25,   722,     1,    56,    18,   727,
      31,     1,     1,    71,    71,   407,   408,   409,    57,    71,
      31,    18,   415,   280,   417,    46,   158,    37,    18,     1,
     748,    62,   207,    73,   752,   112,     1,    45,    78,    70,
       1,   281,   759,    47,   284,  1159,    41,    57,   407,   408,
     409,   444,    72,   226,    70,    78,    73,    71,    70,    73,
      57,    70,   235,    72,    53,    77,    78,   159,    71,   761,
     489,    73,    71,    71,     1,   366,   355,    97,   361,   252,
    1119,   939,   112,   148,   279,    57,   489,   282,   283,   624,
     399,   400,   970,   975,   130,   624,   108,   136,   136,  1114,
     145,   134,   151,    77,    78,   154,   928,   136,   136,   392,
     202,   589,   244,   760,    45,   424,   130,    64,   427,   168,
     382,   404,   384,   406,   383,   202,    64,   130,   130,    72,
      57,    70,   130,   182,   108,   413,   209,   192,   668,   422,
      70,   189,   153,   192,   966,   270,   259,   185,    78,   971,
     194,   285,   286,   270,   278,   287,   204,   407,   408,   409,
     292,   288,   242,   297,   298,   344,   298,   285,   286,   566,
     567,   238,   407,   408,   409,   703,   222,   895,   896,   897,
     898,   270,   342,   557,   901,  1115,   273,   279,   562,     1,
    1048,   685,  1122,   281,   272,   279,   284,   208,   282,   283,
     574,   279,   279,   271,   282,   283,   280,   279,   342,   343,
     282,   345,   604,   279,   179,   279,   282,   283,   282,   283,
    1098,   279,   279,   279,   342,  1103,   754,   279,   279,   361,
    1062,  1015,  1016,   367,   762,   763,   764,   279,   278,  1097,
     278,   202,   407,   408,   409,   604,   278,   278,   272,   995,
     271,   749,   671,   532,   275,   278,   279,   792,    72,   568,
     392,    73,   394,   792,   671,   195,    78,   279,   671,   688,
     282,   283,   404,     1,   406,   407,   408,   409,   970,     1,
     699,   415,   701,   417,    15,   688,   420,   934,   766,     1,
     422,   550,   699,     1,   941,     3,   699,   415,   701,   417,
    1158,  1231,   420,   528,  1186,   279,   549,     1,   282,   283,
     444,   703,   112,  1135,   623,   577,   578,   579,   577,   578,
     579,     1,  1040,    18,    77,    78,   444,     1,    24,     1,
    1152,    62,    18,   802,    18,   274,   805,   711,   150,   278,
     279,  1163,   281,    71,   703,   284,   158,    31,  1230,   279,
      45,   163,   282,   283,   604,     1,   277,   169,  1076,   112,
     172,   151,   754,   760,     1,   674,   758,     1,    18,    64,
     762,   763,   764,     1,   624,  1092,    72,    71,    64,   873,
    1258,    31,    54,    57,    96,   775,     1,   779,   278,   279,
     257,   258,   182,    73,  1041,   754,   168,    64,   867,   758,
     819,     1,   130,   762,   763,   764,  1098,     1,   770,    72,
     829,  1103,   819,   148,    29,  1133,   819,   667,  1240,  1241,
     779,    81,   829,   706,   918,    71,   829,    27,   922,   151,
      77,   217,   154,    64,    71,    66,   130,    71,    72,   170,
    1212,   815,   861,    71,   256,   257,   258,  1193,   260,   202,
     130,    58,    59,   703,   278,   279,   849,   850,   861,   878,
     182,   108,     1,    42,   747,    44,   278,   279,   703,   153,
     604,   878,   604,   259,    72,   878,   148,    71,    17,   265,
     158,  1199,  1254,  1255,   130,   163,   955,   218,   771,   158,
       1,   226,   624,   130,   163,   629,   628,   629,   760,   366,
     235,   760,   130,   153,   754,  1176,  1198,   279,   758,    70,
     282,   283,   762,   763,   764,    51,   184,   252,   186,   754,
    1212,  1238,    58,   758,   208,   259,   279,   762,   763,   764,
     904,   265,   951,  1250,   130,   667,   130,   671,   703,  1257,
     667,   184,   792,   186,   779,   942,   943,  1056,   945,   227,
    1221,   158,   230,  1081,   688,   203,   163,   667,   208,   933,
     271,   935,  1254,  1255,   275,   699,  1258,   986,  1239,   146,
      11,   703,   149,    14,   706,     1,  1070,    18,   155,   986,
     228,    64,   260,   986,   161,   679,   680,   279,  1259,   754,
     282,   283,    70,   758,    72,   259,   730,   762,   763,   764,
      32,    33,   279,  1131,    36,   282,   283,   265,  1027,  1094,
    1095,  1096,     4,     5,   779,   747,   284,   749,   194,    70,
    1027,    72,   754,    19,  1027,    21,   758,   208,   208,    81,
     762,   763,   764,    53,   279,    55,     1,    73,   270,   771,
     151,   284,   153,   154,   208,   954,   272,    73,  1142,   160,
      64,   960,    64,    70,    70,   130,   106,   168,    73,   968,
     792,    71,  1059,    66,   194,    71,   903,   272,  1042,   796,
     272,   182,   934,   272,    40,   934,    70,   272,    39,   941,
    1099,   192,   941,   945,    73,   819,   796,  1061,   194,  1081,
      70,  1088,    70,   106,   158,   829,    71,   208,    71,   163,
      35,   880,  1094,  1095,  1096,   169,    49,   278,   172,  1128,
      50,    71,    23,    71,    73,   849,   850,   279,    71,   130,
      70,  1128,  1081,    71,    73,  1128,  1100,   861,    73,    70,
     271,   849,   850,   279,    78,  1094,  1095,  1096,    45,  1131,
     158,    71,    71,     1,   878,   163,  1120,    72,   112,   153,
       1,   169,    71,    71,   172,    71,  1153,  1154,   870,  1156,
    1157,   683,   273,  1137,  1183,   723,   900,  1050,  1142,   532,
    1079,   133,  1131,    37,   796,  1149,  1183,   627,    37,  1041,
    1183,   354,  1041,   796,  1093,  1131,   275,   213,   409,   796,
     216,   758,   256,   257,   258,   604,   260,   223,   604,  1217,
     929,  1175,   604,   158,    37,   248,  1225,   244,   234,   973,
     236,   615,   792,   239,   240,    19,   624,   914,  1225,    70,
     760,  1060,  1225,  1197,   250,   550,    77,    78,  1144,  1063,
     268,  1081,   488,   701,   861,   889,  1210,   489,   256,   257,
     258,   259,   260,   456,   448,  1235,  1081,   265,   213,   668,
    1229,   216,   986,   279,   428,    37,  1229,   108,   223,  1094,
    1095,  1096,   417,   153,   771,    37,  1038,   998,   290,   234,
    1037,   236,  1030,   981,   239,   240,   134,   665,  1056,   288,
     138,  1131,   405,   141,   338,   250,   451,   145,   146,    -1,
      -1,   149,    -1,  1027,    -1,    -1,  1131,   155,    -1,    -1,
      -1,    -1,  1211,   161,   162,    -1,   164,   165,    -1,    -1,
      -1,    -1,    -1,     1,   279,    -1,  1081,    -1,  1050,    -1,
      -1,    -1,   180,  1232,    -1,    -1,  1060,    -1,    -1,  1094,
    1095,  1096,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   194,   195,    -1,    -1,    -1,    -1,  1081,
    1233,    -1,   210,   211,   212,    -1,   214,   215,    -1,    -1,
      -1,    32,   220,    34,    35,    36,  1131,    38,    39,    -1,
      41,    42,    43,    44,    45,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,   241,    72,  1112,    -1,    -1,    -1,    -1,
      78,    -1,    -1,    81,  1128,   253,   254,    -1,    -1,  1131,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   263,   264,  1148,   266,   267,   268,   269,    -1,
      -1,    -1,  1182,    -1,   282,   283,    -1,    -1,   279,    -1,
      -1,   282,   283,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   131,    -1,    -1,   134,    -1,  1182,  1183,
     138,    -1,   140,   141,    -1,    -1,    -1,   145,   146,   147,
      -1,   149,   150,   151,  1182,   153,   154,   155,    -1,   157,
     158,    -1,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,   170,    -1,   172,   173,    -1,   175,    -1,   177,
      -1,  1225,   180,    -1,   182,   183,   184,    -1,   186,   187,
     188,  1233,   190,   191,    -1,    -1,   194,   195,    -1,    -1,
      -1,   199,   200,   201,    -1,    -1,    -1,    -1,    -1,   207,
     208,   209,   210,   211,   212,    -1,   214,   215,    -1,   217,
     218,    -1,   220,    -1,     1,    -1,   224,    -1,    -1,   227,
      -1,    -1,   230,    -1,    -1,   233,    -1,    -1,    -1,    -1,
      -1,    -1,   240,   241,    -1,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,    -1,   253,   254,   255,   256,   257,
     258,   259,   260,   261,    -1,    -1,    -1,   265,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   279,    -1,    -1,   282,   283,   284,    64,    -1,    -1,
      -1,    68,    69,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    -1,    81,    82,    -1,    84,    -1,    86,
      87,    88,    89,    90,    -1,    92,    -1,    94,    -1,    96,
      97,    98,    -1,   100,    -1,   102,    -1,   104,    -1,   106,
     107,   108,   109,   110,    -1,   112,   113,    -1,   115,   116,
       1,   118,    -1,   120,    -1,   122,    -1,   124,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,   134,    -1,    -1,
      -1,   138,    -1,   140,   141,    -1,    -1,    -1,   145,   146,
     147,    -1,   149,   150,   151,    -1,   153,   154,   155,    -1,
      -1,   158,    -1,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,    -1,    -1,   172,   173,    -1,   175,    -1,
     177,    -1,    -1,   180,    -1,   182,    -1,    -1,   185,     1,
      -1,   188,    73,   190,   191,    -1,   193,    78,    -1,    -1,
      -1,    -1,    -1,    -1,    16,    -1,    18,    -1,    -1,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,   214,   215,    31,
     217,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,    -1,    -1,   230,   231,    -1,   233,    -1,    -1,    51,
      -1,    -1,    -1,   240,   241,    -1,    58,   244,   245,   246,
      -1,    -1,   249,    -1,    -1,    -1,   253,   254,   255,   256,
     257,   258,   259,   260,   261,    -1,    -1,    -1,   265,   150,
      -1,     1,    -1,    -1,     4,    -1,    -1,   158,    -1,    -1,
      10,    -1,   163,    -1,    -1,   282,   283,    17,   169,    19,
      20,   172,    -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,
      30,    -1,    -1,    -1,    34,    35,    -1,    -1,    -1,    -1,
      -1,    -1,    42,    43,    44,    -1,    -1,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    55,    -1,    -1,    58,    59,
      60,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   153,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   256,   257,   258,   259,   260,
      -1,    -1,    -1,    -1,   265,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   208,   278,   279,    -1,
      -1,   131,    -1,    -1,   134,    -1,   136,    -1,   138,    -1,
     140,   141,    -1,    -1,    -1,   145,   146,   147,    -1,   149,
     150,   151,    -1,   153,   154,   155,    -1,    -1,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
      -1,    -1,   172,    -1,    -1,   175,    70,   177,   178,    -1,
     180,    -1,   182,    77,    78,   185,    -1,    -1,   188,   271,
     190,   191,    -1,   275,    -1,   277,    -1,   279,    -1,    -1,
     282,   283,   202,   203,    -1,    -1,    -1,    -1,    -1,   209,
     210,   211,   212,   213,   108,    -1,   216,    -1,    -1,    -1,
     220,   221,    -1,   223,   224,    -1,    -1,   227,   228,    -1,
     230,    -1,    -1,   233,   234,    -1,   236,   237,    -1,   239,
     240,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,   249,
     250,    -1,    -1,   253,   254,   255,   256,   257,   258,    -1,
     260,   261,   262,   263,   264,    -1,   266,   267,   268,   269,
      -1,     1,    -1,    -1,     4,    -1,    -1,    -1,   278,   279,
      10,    -1,   282,   283,    -1,    -1,    -1,    17,    -1,    19,
      20,    -1,    -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,
      30,   195,    -1,    -1,    34,    35,    -1,    -1,    -1,    -1,
      -1,    -1,    42,    43,    44,    -1,    -1,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    55,    -1,    -1,    58,    59,
      60,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   263,
     264,    -1,   266,   267,   268,   269,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   279,    -1,    -1,   282,   283,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   131,    -1,    -1,   134,    -1,   136,    -1,   138,    -1,
     140,   141,    -1,    -1,    -1,   145,   146,   147,    -1,   149,
     150,   151,    -1,   153,   154,   155,    -1,    -1,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
      -1,    -1,   172,    -1,    -1,   175,    -1,   177,   178,    -1,
     180,    -1,   182,    -1,    -1,   185,    -1,    -1,   188,    -1,
     190,   191,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   202,   203,    -1,    -1,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,    -1,   216,    -1,    -1,    -1,
     220,   221,    -1,   223,   224,    -1,    -1,   227,   228,    -1,
     230,    -1,    -1,   233,   234,    -1,   236,   237,    -1,   239,
     240,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,   249,
     250,    -1,    -1,   253,   254,   255,   256,   257,   258,    -1,
     260,   261,   262,   263,   264,    -1,   266,   267,   268,   269,
      -1,     1,    -1,    -1,     4,    -1,    -1,    -1,    -1,   279,
      10,    -1,   282,   283,    -1,    -1,    -1,    17,    -1,    19,
      20,    -1,    -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,
      30,    -1,    -1,    -1,    34,    35,    -1,    -1,    -1,    -1,
      -1,    -1,    42,    43,    44,    -1,    -1,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    55,    -1,    -1,    58,    59,
      60,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   131,    -1,    -1,   134,    -1,   136,    -1,   138,    -1,
     140,   141,    -1,    -1,    -1,   145,   146,   147,    -1,   149,
     150,   151,    -1,   153,   154,   155,    -1,    -1,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
      -1,    -1,   172,    -1,    -1,   175,    -1,   177,   178,    -1,
     180,    -1,   182,    -1,    -1,   185,    -1,    -1,   188,    -1,
     190,   191,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   202,   203,    -1,    -1,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,    -1,   216,    -1,    -1,    -1,
     220,   221,    -1,   223,   224,    -1,    -1,   227,   228,    -1,
     230,    -1,    -1,   233,   234,    -1,   236,   237,    -1,   239,
     240,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,   249,
     250,    -1,    -1,   253,   254,   255,   256,   257,   258,    -1,
     260,   261,   262,   263,   264,    -1,   266,   267,   268,   269,
      -1,     1,    -1,    -1,     4,    -1,    -1,    -1,    -1,   279,
      10,    -1,   282,   283,    -1,    -1,    -1,    17,    -1,    19,
      20,    -1,    -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,
      30,    -1,    -1,    -1,    34,    35,    -1,    -1,    -1,    -1,
      -1,    -1,    42,    43,    44,    -1,    -1,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    55,    -1,    -1,    58,    59,
      60,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   131,    -1,    -1,   134,    -1,   136,    -1,   138,    -1,
     140,   141,    -1,    -1,    -1,   145,   146,   147,    -1,   149,
     150,   151,    -1,   153,   154,   155,    -1,    -1,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
      -1,    -1,   172,    -1,    -1,   175,    -1,   177,   178,    -1,
     180,    -1,   182,    -1,    -1,   185,    -1,    -1,   188,    -1,
     190,   191,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   202,   203,    -1,    -1,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,    -1,   216,    -1,    -1,    -1,
     220,   221,    -1,   223,   224,    -1,    -1,   227,   228,    -1,
     230,    -1,    -1,   233,   234,    -1,   236,   237,    -1,   239,
     240,   241,    -1,     1,   244,   245,     4,    -1,    -1,   249,
     250,    -1,    10,   253,   254,   255,   256,   257,   258,    -1,
     260,   261,   262,   263,   264,    -1,   266,   267,   268,   269,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   279,
      38,    -1,   282,   283,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    52,    -1,    -1,    -1,    -1,    -1,
      58,    59,    -1,    -1,    -1,    -1,    64,    -1,    -1,    -1,
      68,    69,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    -1,    81,    82,    -1,    84,    -1,    86,    87,
      88,    89,    90,    -1,    92,    -1,    94,    -1,    96,    97,
      98,    -1,   100,    -1,   102,    -1,   104,    -1,   106,   107,
     108,   109,   110,    -1,   112,   113,    -1,   115,   116,    -1,
     118,    -1,   120,    -1,   122,    -1,   124,    -1,   126,    -1,
     128,   129,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     158,    -1,    -1,    -1,    -1,   163,    -1,    -1,    -1,    -1,
     168,    -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   185,    -1,     1,
     188,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    15,    -1,   203,    -1,    -1,    -1,    -1,
      -1,   209,    -1,    71,    -1,   213,    -1,    -1,   216,    -1,
      -1,    -1,    -1,   221,    -1,   223,   224,    -1,    -1,   227,
     228,    -1,   230,    -1,    -1,    -1,   234,    -1,   236,   237,
      -1,   239,   240,    -1,    -1,    -1,   244,   245,   246,    -1,
      62,   249,   250,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   131,    -1,    -1,   134,    -1,    -1,    -1,
     138,   279,   140,   141,   282,   283,    -1,   145,   146,   147,
       1,   149,   150,   151,    -1,   153,   154,   155,    -1,    -1,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,    -1,    -1,   172,   173,    -1,   175,   130,   177,
      -1,    -1,   180,    -1,   182,    -1,    -1,    -1,    -1,    -1,
     188,    -1,   190,   191,   146,    -1,    -1,   149,    -1,    -1,
      -1,    -1,    -1,   155,   202,    -1,    -1,    -1,    -1,   161,
      -1,   209,   210,   211,   212,    -1,   214,   215,   170,   217,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
      -1,    -1,   230,    -1,    -1,   233,    -1,    -1,    -1,    -1,
      -1,    -1,   240,   241,    -1,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,    -1,   253,   254,   255,   256,   257,
     258,   259,   260,   261,    -1,    -1,   218,   265,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   279,    -1,   134,   282,   283,    -1,   138,    -1,   140,
     141,    -1,    -1,    -1,   145,   146,   147,     1,   149,   150,
     151,    -1,   153,   154,   155,    -1,    -1,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   168,   169,   271,
      -1,   172,   173,   275,   175,    -1,   177,    -1,    -1,   180,
      -1,   182,    -1,    -1,    -1,    -1,    -1,   188,    -1,   190,
     191,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   202,    -1,    -1,    -1,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,   214,   215,    -1,   217,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,    -1,    -1,   230,
      -1,    -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,   240,
     241,    -1,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,    -1,   253,   254,   255,   256,   257,   258,   259,   260,
     261,    -1,    -1,    -1,   265,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,   279,    -1,
     134,   282,   283,    -1,   138,    -1,   140,   141,    -1,    -1,
      -1,   145,   146,   147,     1,   149,   150,   151,    -1,   153,
     154,   155,    -1,    -1,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   169,    -1,    -1,   172,   173,
      -1,   175,    -1,   177,    -1,    -1,   180,    -1,   182,    -1,
      -1,    -1,    -1,    -1,   188,    -1,   190,   191,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   202,    -1,
      -1,    -1,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
     214,   215,    -1,   217,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,    -1,    -1,   230,    -1,    -1,   233,
      -1,    -1,    -1,    -1,    -1,    -1,   240,   241,    -1,    -1,
     244,   245,    -1,    -1,    -1,   249,    -1,    -1,    -1,   253,
     254,   255,   256,   257,   258,   259,   260,   261,    -1,     1,
      -1,   265,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   279,    -1,   134,   282,   283,
      -1,   138,    -1,   140,   141,    -1,    -1,    -1,   145,   146,
     147,    -1,   149,   150,   151,    -1,   153,   154,   155,    -1,
      -1,   158,    -1,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,    -1,    -1,   172,   173,    -1,   175,    -1,
     177,    -1,    -1,   180,    -1,   182,    -1,    -1,    70,    -1,
      -1,   188,    -1,   190,   191,    77,    78,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,   214,   215,    -1,
     217,    -1,    -1,   220,    -1,    -1,   108,   224,    -1,    -1,
     227,    -1,    -1,   230,     4,    -1,   233,    -1,    -1,    -1,
      10,    -1,    -1,   240,   241,    -1,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,    -1,   253,   254,   255,   256,
     257,   258,   259,   260,   261,    -1,    -1,    -1,   265,    -1,
      -1,    -1,    -1,    43,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   278,    52,    -1,    -1,   282,   283,    -1,    58,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   194,   195,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    78,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   131,    -1,   108,    -1,    -1,   136,    -1,    -1,    -1,
     140,     4,    -1,    -1,    -1,    -1,    -1,    10,    -1,    -1,
     150,   263,   264,   153,   266,   267,   268,   269,   158,   159,
      -1,    -1,    -1,   163,    -1,    -1,    -1,   279,   168,   169,
     282,   283,   172,    -1,    -1,   175,    -1,   177,   178,    -1,
      43,    -1,    -1,    -1,    -1,   185,    -1,    -1,   188,    52,
     190,   191,    -1,    -1,    -1,    58,    59,    -1,    -1,    -1,
      -1,    -1,   202,   203,    -1,    -1,    -1,    -1,    -1,   209,
      -1,    -1,    -1,   213,    -1,    -1,   216,    -1,    -1,   194,
     195,   221,    -1,   223,   224,    -1,    -1,   227,   228,    -1,
     230,    -1,    -1,   233,   234,    -1,   236,   237,    -1,   239,
     240,    -1,    -1,    -1,   244,   245,    -1,    -1,    -1,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,   257,   258,    -1,
     260,   261,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,
      -1,    -1,     1,   136,    -1,    -1,     4,   140,    -1,   279,
      -1,    -1,    10,    -1,    -1,    -1,    15,   150,   263,   264,
     153,   266,   267,   268,   269,   158,   159,    -1,    -1,    -1,
     163,    -1,    -1,    -1,   279,   168,   169,   282,   283,   172,
      38,    -1,   175,    -1,   177,   178,    -1,    -1,    -1,    -1,
      -1,    -1,   185,    -1,    52,   188,    -1,   190,   191,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,   202,
     203,    -1,    71,    -1,    -1,    -1,   209,    -1,    -1,    -1,
     213,    -1,    -1,   216,    -1,    -1,    -1,    -1,   221,    -1,
     223,   224,    -1,    -1,   227,   228,    -1,   230,    -1,    -1,
     233,   234,    -1,   236,   237,    -1,   239,   240,    -1,    -1,
      -1,   244,   245,    -1,    -1,    -1,   249,   250,    -1,    -1,
      -1,    -1,    -1,   256,   257,   258,    -1,   260,   261,     0,
       1,   130,     3,    -1,     5,     6,     7,     8,     9,    -1,
      11,    12,    13,    14,    -1,    -1,   279,   146,   147,    -1,
     149,    -1,   150,    -1,    -1,    -1,   155,    -1,    -1,    19,
      20,    -1,   161,    -1,    -1,    -1,    -1,   166,   167,    -1,
     168,   170,    -1,    -1,    34,    -1,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     188,    -1,   190,   191,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,   203,    -1,    -1,    -1,    -1,
      -1,   209,    -1,    -1,    -1,   213,    19,    20,   216,   218,
      -1,    -1,    -1,   221,    -1,   223,   224,    -1,    -1,   227,
     228,    34,   230,    -1,    -1,    -1,   234,    -1,   236,   237,
      -1,   239,   240,    -1,    -1,    -1,   244,   245,    -1,    -1,
      -1,   249,   250,    -1,    -1,    -1,   255,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   271,    -1,   134,    -1,   275,    -1,   138,   150,
     151,   141,   153,   154,    -1,   145,    -1,   158,    -1,   160,
      -1,   151,    -1,     4,   154,    -1,    -1,   168,    -1,    10,
     160,    -1,   162,    -1,   164,   165,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,    -1,   187,    -1,    -1,    -1,
     180,   192,   182,    -1,    -1,    -1,    -1,    -1,   199,   200,
     201,   134,    43,    -1,    -1,   138,    -1,   208,   141,    -1,
      17,    52,   145,    -1,    -1,    -1,    -1,    -1,    -1,    26,
     210,   211,   212,    30,    -1,    -1,    -1,    -1,    35,   162,
     220,   164,   165,    -1,    -1,    42,    -1,    44,    -1,    -1,
      -1,    48,    -1,    -1,    -1,    -1,    53,   180,    55,    -1,
      -1,   241,    -1,    60,    -1,    -1,    -1,    -1,    -1,     4,
      -1,    -1,    -1,   253,   254,    10,    -1,    -1,    -1,    -1,
     271,    -1,    -1,    -1,   275,    -1,    -1,   210,   211,   212,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   220,    -1,    -1,
     131,    -1,   282,   283,    -1,   136,    -1,    -1,    -1,   140,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    52,   241,   150,
      -1,    -1,   153,    -1,    -1,    -1,    -1,   158,    -1,    -1,
     253,   254,   163,    -1,    -1,    -1,    -1,   168,   169,    -1,
      75,   172,    -1,    -1,   175,    -1,   177,   178,    -1,   146,
     147,    -1,   149,    -1,   185,    -1,   279,   188,   155,   190,
     191,    -1,    -1,    -1,   161,    -1,    -1,    -1,    -1,   166,
     167,   202,   203,    -1,    -1,    -1,    -1,    -1,   209,    -1,
      -1,    -1,   213,    -1,    -1,   216,    -1,    -1,    -1,    -1,
     221,    -1,   223,   224,    -1,    -1,   227,   228,    -1,   230,
      -1,    -1,   233,   234,    -1,   236,   237,    -1,   239,   240,
      -1,    -1,    -1,   244,   245,   150,    -1,    -1,   249,   250,
      -1,    -1,    -1,    -1,    -1,   256,   257,   258,    -1,   260,
     261,    -1,    -1,   168,    -1,    -1,    -1,    -1,    -1,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   188,    -1,   190,   191,    -1,   255,    -1,
      78,    -1,    -1,    -1,    -1,   262,   263,   264,   203,   266,
     267,   268,   269,    -1,   209,    -1,    -1,    -1,   213,    -1,
      -1,   216,    -1,    -1,    -1,    -1,   221,    -1,   223,   224,
      -1,    -1,   227,   228,    -1,   230,    -1,    -1,    -1,   234,
      -1,   236,   237,    -1,   239,   240,    -1,    -1,    -1,   244,
     245,    -1,    -1,   131,   249,   250,   134,    -1,    -1,    -1,
     138,    -1,   140,   141,    -1,    -1,    -1,   145,   146,   147,
      -1,   149,   150,   151,    -1,   153,   154,   155,    -1,    -1,
     158,    -1,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,    -1,    -1,   172,   173,    -1,   175,    -1,   177,
      -1,    -1,   180,    -1,   182,    -1,    -1,    -1,    -1,    -1,
     188,    -1,   190,   191,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,   214,   215,    -1,   217,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
      -1,    -1,   230,    -1,    -1,   233,    -1,    -1,    -1,    -1,
      -1,    -1,   240,   241,    -1,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,    -1,   253,   254,   255,   256,   257,
     258,   259,   260,   261,    -1,    -1,    -1,   265,    -1,    -1,
      -1,    -1,   131,    -1,    -1,   134,    -1,    -1,    -1,   138,
      -1,   140,   141,    -1,   282,   283,   145,   146,   147,    -1,
     149,   150,   151,    -1,   153,   154,   155,    -1,    -1,   158,
      -1,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,    -1,    -1,   172,   173,    -1,   175,    -1,   177,    -1,
      -1,   180,    -1,   182,    -1,    -1,    -1,    -1,    -1,   188,
      -1,   190,   191,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,   214,   215,    -1,   217,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,    -1,
      -1,   230,    -1,    -1,   233,    -1,    -1,    -1,    -1,    -1,
      -1,   240,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,    -1,   253,   254,   255,   256,   257,   258,
     259,   260,   261,    -1,   134,    -1,   265,    -1,   138,    -1,
      -1,   141,    -1,    -1,    -1,   145,   146,    -1,    -1,   149,
      -1,    -1,    -1,   282,   283,   155,    -1,    -1,    -1,    -1,
      -1,   161,   162,    -1,   164,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     180,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     210,   211,   212,    -1,   214,   215,    -1,    -1,    -1,    -1,
     220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,    -1,    -1,
      -1,   241,    -1,   146,   147,    -1,   149,   150,    -1,    -1,
     153,    -1,   155,   253,   254,   158,    -1,    -1,   161,    -1,
     163,    -1,    -1,   166,   167,   168,   169,    -1,    -1,   172,
      -1,    -1,   175,    -1,   177,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,   283,    -1,   188,    -1,   190,   191,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   209,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   217,    -1,    -1,    -1,    -1,    -1,
      -1,   224,    -1,    -1,   227,    -1,    -1,   230,    -1,    -1,
     233,    -1,    -1,    -1,    -1,    -1,    -1,   240,    -1,    -1,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,    -1,
      -1,    -1,   255,   256,   257,   258,   259,   260,   261,    -1,
      -1,    -1,   265
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   286,     0,     1,     3,     5,     6,     7,     8,     9,
      11,    12,    13,    14,   150,   151,   153,   154,   158,   160,
     168,   182,   183,   187,   192,   199,   200,   201,   208,   271,
     275,   287,   288,   289,   290,   305,   306,   308,   309,   311,
     312,   313,   317,   323,   324,   325,   330,   338,   339,   342,
     344,   361,   364,   372,   373,   468,   476,   477,   624,   644,
     279,   282,   283,   569,   572,   579,   584,   587,   589,     1,
      64,    68,    69,    70,    72,    74,    75,    77,    78,    79,
      81,    82,    84,    86,    87,    88,    89,    90,    92,    94,
      96,    97,    98,   100,   102,   104,   106,   107,   108,   109,
     110,   112,   113,   115,   116,   118,   120,   122,   124,   126,
     128,   129,   130,   185,   193,   246,   302,   584,   588,   603,
       1,   584,   586,     1,     3,   597,     1,    25,    31,    46,
     310,   597,   280,   314,   315,     1,    16,    51,    58,   279,
     321,   572,   597,   207,   652,   597,   475,   476,     1,   192,
     623,   374,   644,   586,   644,   644,   644,     1,    70,    72,
      78,   131,   134,   138,   140,   141,   145,   146,   147,   149,
     150,   153,   155,   157,   158,   161,   162,   163,   164,   165,
     166,   167,   168,   169,   170,   172,   173,   175,   177,   180,
     188,   190,   191,   195,   207,   209,   210,   211,   212,   214,
     215,   217,   218,   220,   224,   227,   230,   233,   240,   241,
     244,   245,   249,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   265,   279,   326,   328,   330,   331,   334,   336,
     337,   354,   361,   362,   371,   387,   388,   389,   391,   415,
     416,   418,   426,   452,   454,   455,   456,   457,   458,   459,
     461,   462,   463,   464,   465,   466,   467,   468,   477,   480,
     481,   483,   485,   486,   488,   496,   498,   499,   508,   509,
     572,   576,   577,   579,   609,   610,   614,   656,   644,   644,
     644,   644,   644,   644,   644,   343,   340,   345,    45,   626,
     627,   628,    64,     1,    18,    37,    57,   593,    64,     1,
      71,   639,     1,    73,   635,    72,    72,     4,    10,    38,
      52,   150,   168,   175,   188,   190,   191,   203,   209,   213,
     216,   221,   223,   224,   227,   228,   230,   234,   236,   237,
     239,   240,   244,   245,   249,   250,   303,   304,   482,   537,
       1,    18,   130,   592,   291,   592,   112,   316,   315,    51,
      58,   322,   277,   611,   612,    18,    31,   153,   208,   318,
     320,   365,     1,   279,   282,   567,   568,   593,   168,   209,
     415,   452,   609,    77,    78,   112,   202,   279,   355,   356,
     357,   478,   479,   480,   496,   281,   284,   540,   646,     1,
      70,   620,   620,    64,   307,   620,    72,    72,   484,   500,
     510,    70,     1,    96,   621,   332,   620,   130,   417,   363,
     455,   457,   453,   454,   482,   487,   488,   487,   499,   509,
      64,   578,   194,   373,   184,   186,   284,   607,    81,     1,
     569,   570,   570,     1,   279,   347,   348,   349,   572,     1,
      56,   477,   624,   640,   641,   626,   279,   572,     4,    10,
      43,    52,    58,    59,   131,   136,   140,   150,   153,   159,
     168,   172,   177,   178,   185,   188,   190,   191,   202,   203,
     209,   224,   227,   228,   230,   233,   244,   245,   249,   256,
     257,   258,   261,   279,   481,   483,   513,   533,   534,   535,
     536,   537,   538,   542,   548,   549,   579,   585,   654,   572,
     579,   635,   635,    32,    33,    36,   539,   148,   226,   235,
     252,    24,    72,   295,     1,   209,   655,     1,   222,   606,
       1,   238,   653,   481,   654,   586,   292,   513,   628,   513,
       1,   280,    18,   320,     1,   318,   319,   452,   487,   513,
     639,   327,   279,     1,   202,   648,    73,     1,   130,   601,
     480,   495,   496,   480,   272,     1,   646,   647,   452,   362,
       1,   278,   616,   489,     1,    73,    78,   278,   620,   620,
     392,   452,   652,     1,   278,   452,    70,    77,    78,   108,
     263,   264,   266,   267,   268,   269,   377,   378,   380,   382,
     383,   385,   390,   409,   411,   412,   414,   419,   421,   422,
     424,   425,   426,   428,   523,   569,   572,   576,   577,   579,
     580,   380,   376,   377,   569,   570,   571,   570,   571,   569,
     452,   620,   620,   568,   270,   469,   341,   346,    64,    64,
     570,   539,   226,   655,     1,    29,   605,   540,     1,   179,
     619,    78,   278,   543,   628,    17,    26,    30,    48,    53,
      55,    60,   262,   456,   514,   517,   518,   519,   521,   522,
     523,   530,   544,   545,   546,   547,   550,   551,   552,   553,
     536,    18,     1,    41,   618,     1,   242,   590,     1,    70,
      72,   296,    28,    53,   297,   298,   299,   357,    70,   525,
     526,     1,    27,   602,    15,    62,   170,   218,   293,   294,
     301,   592,   319,   366,     1,   112,   608,    70,   414,   421,
     424,   429,   430,   431,   432,   433,   435,   436,   438,   440,
     442,   580,    70,   358,   357,   495,   639,   460,   639,   208,
     490,    73,   635,   635,   620,     1,   279,   503,   511,   512,
     159,   202,   279,   404,   405,   406,   573,   649,   329,   333,
      71,   639,   335,   106,   410,   478,   478,   478,   130,    70,
      72,   384,   413,   420,   423,   381,   382,   390,   412,   579,
      66,   194,   270,   581,   497,   498,   469,   272,   272,   427,
     404,    71,   393,   620,     1,   146,   149,   155,   161,   461,
     463,   470,   472,   473,   474,   577,   272,   351,   352,     1,
     350,   352,   168,   279,   572,   168,   572,   579,    40,   541,
      78,   278,   279,   515,   525,    70,   520,     1,    57,   650,
       1,    53,   636,    39,   516,   525,    42,    44,   622,   650,
      19,    20,    34,    61,   134,   138,   141,   145,   162,   164,
     165,   180,   210,   211,   212,   220,   241,   253,   254,   468,
     477,   554,   555,   556,   557,   558,   560,   561,   577,   553,
     513,   620,   297,   297,    22,   136,   300,    57,   300,    73,
     601,   513,   527,   528,    54,   148,   531,   532,   637,   194,
     630,    18,    57,   594,   616,     1,   278,   513,   524,   534,
     367,   369,   380,   452,   106,   437,   439,   441,   443,   384,
     639,    70,   404,   302,   429,     1,   279,   574,     1,   213,
     216,   223,   234,   236,   239,   240,   250,   491,   492,   493,
     579,   501,   502,   503,    70,   504,    71,   503,    71,   601,
     452,   429,   362,   429,   386,   380,     1,   378,   379,   404,
       1,   150,   278,   279,   478,   479,   635,   497,   380,   380,
     380,   482,     1,   231,   603,   633,   616,   414,   421,   424,
     444,   445,   446,   448,   450,   580,   393,   394,   203,   228,
     398,   393,   473,   474,   471,   472,     1,   273,   338,   353,
     364,   372,   574,   574,     1,    45,   625,   639,     1,    42,
     513,     1,    17,   591,   531,    35,   513,    49,   559,     1,
     145,   615,     1,    47,   631,     1,   134,   598,   278,   617,
      50,   632,   570,   570,     1,    62,    70,   278,   527,    71,
      73,     1,   136,   604,   574,   299,    71,   601,     1,   513,
     628,    19,    21,   595,    23,   596,    53,    55,   530,   130,
     375,   434,   429,   429,   429,   429,   579,   583,   404,    71,
      75,   359,   639,     1,   270,   600,    70,   494,   494,    73,
     601,    71,   601,    70,   274,   278,   279,   281,   284,   505,
     506,   507,   398,     1,   406,   408,   407,     1,    97,   613,
     639,   478,   639,   393,    73,   478,   635,   635,    78,   150,
     635,   645,   620,   574,   447,   449,   451,   620,   398,   395,
     620,    70,   497,   398,   471,   271,   643,     1,   271,   642,
     642,   513,   625,   279,   575,   525,   615,    45,   562,   616,
     616,   595,    71,     1,   513,   529,     1,   637,   638,   636,
     622,   368,   429,   478,   639,   393,   452,   647,   635,   493,
     639,   503,   506,    71,   601,   112,   402,   429,   620,   380,
      77,   108,   397,   278,   279,   635,   278,   279,   404,   620,
     444,   444,   444,   393,   497,   227,   230,   260,   396,   481,
     405,   639,     1,   189,   204,   399,   497,     1,   273,   634,
       1,   477,   599,   625,   531,   153,   651,   595,   639,   531,
     513,     1,   194,   629,     1,   369,   370,   429,   398,   360,
     639,     1,   639,   507,     1,   136,   185,   278,     1,   579,
     582,   639,   398,   635,   635,   635,   635,   393,     1,   403,
     405,   398,    71,   639,   402,   586,   513,   473,   563,   564,
     565,   525,   639,    75,   400,   498,   429,   639,   620,   400,
     397,    71,   402,   513,   279,   555,   566,   585,   473,   531,
     620,   452,   404,   402,   398,   398,   404,   401,    71,   400,
     400,    71,   429,   497,   402
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   285,   286,   286,   287,   287,   287,   287,   287,   287,
     287,   287,   287,   287,   287,   287,   287,   287,   288,   288,
     289,   289,   289,   289,   289,   290,   291,   290,   290,   290,
     290,   292,   292,   292,   293,   293,   293,   294,   294,   294,
     295,   295,   295,   296,   296,   296,   297,   297,   298,   298,
     299,   299,   299,   299,   300,   300,   300,   301,   302,   302,
     303,   303,   304,   304,   304,   304,   304,   304,   304,   304,
     304,   304,   304,   304,   304,   304,   304,   304,   304,   305,
     306,   306,   306,   306,   306,   306,   306,   306,   306,   306,
     306,   306,   307,   306,   306,   306,   306,   306,   308,   309,
     310,   310,   310,   310,   310,   311,   312,   313,   313,   314,
     314,   315,   316,   316,   316,   317,   317,   317,   317,   317,
     317,   318,   318,   318,   319,   319,   320,   320,   321,   321,
     321,   321,   322,   322,   322,   323,   324,   325,   327,   326,
     326,   329,   328,   330,   330,   330,   330,   332,   333,   331,
     334,   335,   334,   334,   336,   336,   337,   338,   338,   338,
     340,   341,   339,   343,   342,   345,   346,   344,   347,   347,
     347,   348,   348,   348,   348,   349,   349,   349,   349,   350,
     350,   351,   351,   352,   352,   353,   353,   353,   353,   354,
     355,   355,   356,   356,   357,   357,   357,   357,   357,   357,
     358,   358,   359,   360,   359,   361,   363,   362,   365,   366,
     364,   368,   367,   367,   369,   370,   370,   371,   372,   374,
     375,   373,   376,   376,   377,   377,   378,   379,   379,   380,
     380,   380,   380,   380,   381,   381,   382,   382,   382,   382,
     382,   382,   382,   382,   382,   383,   384,   384,   384,   384,
     384,   384,   384,   384,   384,   384,   386,   385,   387,   388,
     389,   390,   392,   391,   394,   393,   395,   395,   396,   396,
     396,   396,   397,   397,   397,   398,   398,   398,   398,   398,
     399,   399,   399,   400,   401,   400,   400,   402,   402,   402,
     402,   402,   403,   403,   404,   404,   405,   405,   407,   406,
     406,   406,   408,   408,   410,   409,   411,   413,   412,   414,
     415,   415,   417,   416,   418,   420,   419,   421,   423,   422,
     424,   424,   425,   427,   426,   428,   429,   429,   430,   430,
     430,   430,   431,   431,   431,   431,   431,   432,   434,   433,
     435,   437,   436,   439,   438,   441,   440,   443,   442,   444,
     444,   445,   445,   445,   445,   447,   446,   449,   448,   451,
     450,   452,   452,   452,   453,   453,   454,   454,   455,   455,
     455,   455,   456,   456,   456,   456,   456,   456,   456,   456,
     457,   457,   458,   458,   458,   458,   460,   459,   461,   461,
     462,   462,   462,   462,   462,   462,   462,   462,   462,   462,
     462,   462,   462,   462,   463,   464,   464,   465,   465,   466,
     466,   467,   467,   468,   469,   469,   469,   470,   470,   470,
     471,   471,   472,   472,   473,   473,   473,   473,   474,   474,
     474,   475,   475,   476,   476,   477,   477,   478,   478,   479,
     479,   479,   480,   480,   480,   480,   480,   480,   480,   481,
     481,   482,   482,   483,   483,   484,   484,   484,   484,   485,
     485,   485,   485,   485,   485,   485,   485,   485,   485,   485,
     485,   485,   485,   485,   485,   485,   485,   485,   485,   486,
     486,   487,   487,   489,   488,   488,   490,   490,   491,   491,
     492,   492,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   494,   494,   495,   495,   496,   496,   497,   497,
     498,   498,   500,   499,   501,   501,   502,   502,   503,   503,
     504,   504,   505,   505,   506,   506,   507,   507,   507,   507,
     507,   507,   508,   508,   510,   509,   511,   511,   512,   512,
     513,   513,   513,   514,   514,   515,   515,   515,   515,   516,
     516,   517,   518,   519,   520,   520,   521,   522,   522,   523,
     523,   523,   523,   523,   523,   524,   525,   525,   526,   527,
     527,   528,   528,   529,   529,   530,   530,   530,   531,   531,
     532,   532,   533,   534,   534,   535,   535,   536,   536,   536,
     537,   537,   537,   537,   537,   537,   537,   537,   537,   537,
     537,   537,   537,   537,   538,   538,   538,   538,   538,   538,
     538,   538,   538,   538,   538,   538,   538,   538,   538,   538,
     538,   538,   538,   538,   538,   538,   538,   538,   538,   538,
     538,   538,   538,   539,   539,   539,   540,   541,   541,   542,
     542,   542,   542,   542,   542,   542,   543,   543,   544,   544,
     544,   544,   544,   544,   544,   544,   545,   545,   545,   546,
     547,   547,   548,   549,   549,   549,   550,   550,   551,   551,
     552,   552,   553,   554,   554,   554,   554,   555,   555,   556,
     556,   556,   556,   556,   556,   556,   556,   556,   556,   556,
     556,   556,   556,   556,   556,   557,   557,   557,   557,   558,
     558,   558,   559,   559,   560,   561,   562,   562,   563,   563,
     564,   564,   565,   565,   566,   566,   567,   567,   568,   568,
     569,   569,   570,   570,   571,   571,   572,   572,   573,   574,
     574,   575,   575,   576,   576,   577,   578,   578,   579,   579,
     579,   580,   581,   581,   582,   582,   583,   583,   584,   585,
     586,   586,   587,   587,   588,   588,   589,   589,   589,   590,
     590,   591,   591,   592,   592,   593,   593,   593,   593,   594,
     594,   594,   595,   595,   595,   596,   596,   597,   597,   598,
     598,   599,   599,   600,   600,   601,   601,   602,   602,   603,
     603,   603,   603,   603,   603,   603,   603,   603,   603,   603,
     603,   603,   603,   603,   603,   603,   603,   603,   603,   603,
     603,   603,   603,   603,   603,   603,   603,   603,   603,   603,
     603,   603,   603,   603,   603,   603,   603,   603,   603,   603,
     603,   603,   603,   603,   603,   603,   603,   604,   604,   605,
     605,   606,   606,   607,   607,   608,   608,   609,   609,   610,
     610,   611,   612,   612,   613,   613,   614,   614,   615,   615,
     616,   616,   617,   617,   618,   618,   619,   619,   620,   620,
     621,   621,   622,   622,   622,   623,   623,   624,   624,   625,
     625,   626,   627,   627,   628,   628,   629,   629,   630,   630,
     631,   631,   632,   632,   633,   633,   634,   634,   635,   635,
     636,   636,   637,   637,   638,   638,   639,   639,   640,   640,
     640,   641,   641,   642,   642,   643,   643,   644,   644,   645,
     645,   646,   646,   647,   647,   648,   648,   649,   649,   650,
     650,   651,   651,   652,   652,   653,   653,   654,   654,   655,
     655,   656,   656
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     2,     2,     2,     2,     2,     2,
       1,     2,     2,     2,     2,     2,     1,     1,     4,     4,
       2,     2,     2,     2,     1,     4,     0,     6,     6,     9,
       2,     1,     2,     2,     3,     2,     2,     2,     1,     1,
       0,     2,     3,     3,     3,     1,     0,     1,     3,     1,
       2,     2,     3,     1,     0,     2,     1,     3,     0,     2,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     1,     2,     4,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     0,     4,     2,     3,     2,     2,     1,     2,
       0,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     2,     0,     2,     2,     3,     4,     4,     5,     2,
       2,     1,     1,     1,     1,     1,     0,     1,     0,     2,
       1,     1,     0,     1,     1,     1,     1,     1,     0,     6,
       3,     0,     9,     1,     1,     1,     1,     0,     0,     5,
       4,     0,     6,     4,     1,     1,     4,     1,     1,     1,
       0,     0,     5,     0,     4,     0,     0,     5,     1,     1,
       1,     3,     3,     4,     1,     3,     3,     4,     1,     1,
       1,     0,     1,     2,     4,     1,     2,     2,     1,     6,
       0,     1,     3,     1,     1,     2,     1,     1,     1,     2,
       0,     3,     0,     0,     4,     1,     0,     3,     0,     0,
       6,     0,     4,     1,     1,     1,     1,     1,     1,     0,
       0,     8,     0,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     3,     2,     3,     3,     3,
       5,     5,     4,     5,     5,     3,     0,    10,     8,     7,
       6,     8,     0,     7,     0,     3,     0,     2,     1,     1,
       1,     1,     0,     1,     1,     0,     1,     4,     3,     4,
       1,     1,     1,     0,     0,     4,     1,     0,     2,     2,
       2,     2,     1,     1,     0,     1,     3,     1,     0,     4,
       1,     1,     1,     1,     0,     4,    10,     0,     3,     2,
       3,     1,     0,     3,     2,     0,     3,     3,     0,     3,
       2,     2,     1,     0,     9,     9,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     9,
       6,     0,     4,     0,     3,     0,     3,     0,     3,     0,
       1,     1,     1,     1,     1,     0,     3,     0,     3,     0,
       3,     1,     2,     1,     0,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     1,     1,     1,     1,     0,     6,     1,     4,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       4,     4,     4,     2,     0,     2,     2,     1,     3,     2,
       0,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     1,     1,     1,     0,     1,     3,
       2,     2,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     0,     2,     1,     1,     2,     3,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     0,     7,     1,     0,     3,     0,     1,
       3,     1,     1,     2,     1,     2,     1,     1,     1,     1,
       1,     1,     0,     3,     0,     1,     1,     1,     0,     1,
       2,     1,     0,     7,     0,     1,     3,     1,     2,     1,
       0,     3,     0,     1,     3,     1,     1,     1,     1,     1,
       3,     1,     2,     1,     0,     5,     0,     1,     2,     1,
       1,     1,     1,     4,     6,     0,     1,     1,     1,     0,
       1,     3,     2,     2,     0,     2,     5,     1,     1,     1,
       1,     1,     1,     1,     1,     6,     0,     1,     3,     0,
       1,     3,     1,     1,     1,     0,     1,     2,     0,     1,
       2,     2,     2,     0,     1,     2,     1,     1,     1,     1,
       2,     1,     1,     2,     1,     2,     1,     2,     1,     1,
       3,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     0,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     7,     3,     3,
       1,     2,     6,     3,     1,     1,     2,     1,     0,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     2,     1,
       1,     2,     2,     1,     1,     3,     4,     4,     2,     1,
       2,     3,     0,     1,     2,     3,     0,     3,     2,     1,
       0,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     0,     1,     0,     2,     2,     0,     2,     3,     3,
       1,     2,     0,     2,     1,     1,     0,     1,     2,     2,
       1,     1,     0,     1,     3,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     1,     0,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     0,
       1,     1,     0,     1,     1,     1,     0,     1,     1,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     2,     1,
       1,     3,     2,     1,     0,     1,     1,     1,     0,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     0,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       1,     0,     1,     0,     1,     1,     1,     1,     2,     1,
       1,     0,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]));
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_Y_CONSTRUCTOR_SNAME: /* Y_CONSTRUCTOR_SNAME  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4515 "parser.c"
        break;

    case YYSYMBOL_Y_DESTRUCTOR_SNAME: /* Y_DESTRUCTOR_SNAME  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4521 "parser.c"
        break;

    case YYSYMBOL_Y_OPERATOR_SNAME: /* Y_OPERATOR_SNAME  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4527 "parser.c"
        break;

    case YYSYMBOL_Y_CHAR_LIT: /* Y_CHAR_LIT  */
#line 1713 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).str_val) ); }
#line 4533 "parser.c"
        break;

    case YYSYMBOL_Y_GLOB: /* Y_GLOB  */
#line 1710 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) ); }
#line 4539 "parser.c"
        break;

    case YYSYMBOL_Y_NAME: /* Y_NAME  */
#line 1710 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) ); }
#line 4545 "parser.c"
        break;

    case YYSYMBOL_Y_SET_OPTION: /* Y_SET_OPTION  */
#line 1710 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) ); }
#line 4551 "parser.c"
        break;

    case YYSYMBOL_Y_STR_LIT: /* Y_STR_LIT  */
#line 1713 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).str_val) ); }
#line 4557 "parser.c"
        break;

    case YYSYMBOL_capturing_paren_capture_decl_list_english_opt: /* capturing_paren_capture_decl_list_english_opt  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4563 "parser.c"
        break;

    case YYSYMBOL_paren_capture_decl_list_english: /* paren_capture_decl_list_english  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4569 "parser.c"
        break;

    case YYSYMBOL_capture_decl_list_english_opt: /* capture_decl_list_english_opt  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4575 "parser.c"
        break;

    case YYSYMBOL_capture_decl_list_english: /* capture_decl_list_english  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4581 "parser.c"
        break;

    case YYSYMBOL_set_option_value_opt: /* set_option_value_opt  */
#line 1713 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).str_val) ); }
#line 4587 "parser.c"
        break;

    case YYSYMBOL_namespace_sname_c_exp: /* namespace_sname_c_exp  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4593 "parser.c"
        break;

    case YYSYMBOL_namespace_sname_c: /* namespace_sname_c  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4599 "parser.c"
        break;

    case YYSYMBOL_namespace_typedef_sname_c: /* namespace_typedef_sname_c  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4605 "parser.c"
        break;

    case YYSYMBOL_capture_decl_list_c_opt: /* capture_decl_list_c_opt  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4611 "parser.c"
        break;

    case YYSYMBOL_capture_decl_list_c: /* capture_decl_list_c  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4617 "parser.c"
        break;

    case YYSYMBOL_lambda_param_c_ast_list_opt: /* lambda_param_c_ast_list_opt  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4623 "parser.c"
        break;

    case YYSYMBOL_decl_list_c: /* decl_list_c  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4629 "parser.c"
        break;

    case YYSYMBOL_param_c_ast_list_exp: /* param_c_ast_list_exp  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4635 "parser.c"
        break;

    case YYSYMBOL_param_c_ast_list_opt: /* param_c_ast_list_opt  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4641 "parser.c"
        break;

    case YYSYMBOL_param_c_ast_list: /* param_c_ast_list  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4647 "parser.c"
        break;

    case YYSYMBOL_pc99_pointer_decl_list_c: /* pc99_pointer_decl_list_c  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4653 "parser.c"
        break;

    case YYSYMBOL_paren_param_decl_list_english_opt: /* paren_param_decl_list_english_opt  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4659 "parser.c"
        break;

    case YYSYMBOL_paren_param_decl_list_english: /* paren_param_decl_list_english  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4665 "parser.c"
        break;

    case YYSYMBOL_param_decl_list_english_opt: /* param_decl_list_english_opt  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4671 "parser.c"
        break;

    case YYSYMBOL_param_decl_list_english: /* param_decl_list_english  */
#line 1709 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) ); }
#line 4677 "parser.c"
        break;

    case YYSYMBOL_any_name: /* any_name  */
#line 1710 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) ); }
#line 4683 "parser.c"
        break;

    case YYSYMBOL_any_name_exp: /* any_name_exp  */
#line 1710 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) ); }
#line 4689 "parser.c"
        break;

    case YYSYMBOL_any_sname_c: /* any_sname_c  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4695 "parser.c"
        break;

    case YYSYMBOL_any_sname_c_exp: /* any_sname_c_exp  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4701 "parser.c"
        break;

    case YYSYMBOL_any_sname_c_opt: /* any_sname_c_opt  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4707 "parser.c"
        break;

    case YYSYMBOL_name_exp: /* name_exp  */
#line 1710 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) ); }
#line 4713 "parser.c"
        break;

    case YYSYMBOL_name_opt: /* name_opt  */
#line 1710 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) ); }
#line 4719 "parser.c"
        break;

    case YYSYMBOL_oper_sname_c_opt: /* oper_sname_c_opt  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4725 "parser.c"
        break;

    case YYSYMBOL_sub_scope_sname_c_opt: /* sub_scope_sname_c_opt  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4731 "parser.c"
        break;

    case YYSYMBOL_sname_c: /* sname_c  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4737 "parser.c"
        break;

    case YYSYMBOL_sname_c_exp: /* sname_c_exp  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4743 "parser.c"
        break;

    case YYSYMBOL_sname_c_opt: /* sname_c_opt  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4749 "parser.c"
        break;

    case YYSYMBOL_sname_english: /* sname_english  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4755 "parser.c"
        break;

    case YYSYMBOL_sname_english_exp: /* sname_english_exp  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4761 "parser.c"
        break;

    case YYSYMBOL_sname_english_opt: /* sname_english_opt  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4767 "parser.c"
        break;

    case YYSYMBOL_sname_list_english: /* sname_list_english  */
#line 1712 "parser.y"
            { DTRACE; c_sname_list_cleanup( &((*yyvaluep).sname_list) ); }
#line 4773 "parser.c"
        break;

    case YYSYMBOL_typedef_sname_c: /* typedef_sname_c  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4779 "parser.c"
        break;

    case YYSYMBOL_destructor_sname: /* destructor_sname  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4785 "parser.c"
        break;

    case YYSYMBOL_glob: /* glob  */
#line 1710 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) ); }
#line 4791 "parser.c"
        break;

    case YYSYMBOL_glob_opt: /* glob_opt  */
#line 1710 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) ); }
#line 4797 "parser.c"
        break;

    case YYSYMBOL_of_scope_english: /* of_scope_english  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4803 "parser.c"
        break;

    case YYSYMBOL_of_scope_list_english: /* of_scope_list_english  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4809 "parser.c"
        break;

    case YYSYMBOL_of_scope_list_english_opt: /* of_scope_list_english_opt  */
#line 1711 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) ); }
#line 4815 "parser.c"
        break;

    case YYSYMBOL_str_lit: /* str_lit  */
#line 1713 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).str_val) ); }
#line 4821 "parser.c"
        break;

    case YYSYMBOL_str_lit_exp: /* str_lit_exp  */
#line 1713 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).str_val) ); }
#line 4827 "parser.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Location data for the lookahead symbol.  */
YYLTYPE yylloc
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 3: /* command_list: command_list command  */
#line 1721 "parser.y"
    { //
      // We get here only after a successful parse.
      //
      parse_cleanup( /*fatal_error=*/false );
    }
#line 5126 "parser.c"
    break;

  case 17: /* command: error  */
#line 1743 "parser.y"
    {
      if ( lexer_printable_token() != NULL )
        elaborate_error_dym( DYM_COMMANDS, "unexpected token" );
      else
        elaborate_error( "unexpected end of command" );
    }
#line 5137 "parser.c"
    break;

  case 18: /* cast_command: Y_cast sname_english_opt as_into_to_exp decl_english_ast  */
#line 1762 "parser.y"
    {
      DUMP_START( "cast_command",
                  "CAST sname_english_opt as_into_to_exp decl_english_ast" );
      DUMP_SNAME( "sname_english_opt", (yyvsp[-2].sname) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );
      DUMP_END();

      c_ast_t *const cast_ast = c_ast_new_gc( K_CAST, &(yyloc) );
      cast_ast->sname = c_sname_move( &(yyvsp[-2].sname) );
      cast_ast->cast.kind = C_CAST_C;
      cast_ast->cast.to_ast = (yyvsp[0].ast);
      PARSE_ASSERT( c_ast_check( cast_ast ) );
      c_ast_gibberish( cast_ast, C_GIB_CAST, stdout );
    }
#line 5156 "parser.c"
    break;

  case 19: /* cast_command: new_style_cast_english sname_english_exp as_into_to_exp decl_english_ast  */
#line 1782 "parser.y"
    {
      char const *const cast_literal = c_cast_gibberish( (yyvsp[-3].cast_kind) );

      DUMP_START( "cast_command",
                  "new_style_cast_english CAST sname_english_exp "
                  "as_into_to_exp decl_english_ast" );
      DUMP_STR( "new_style_cast_english", cast_literal );
      DUMP_SNAME( "sname_english_exp", (yyvsp[-2].sname) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );
      DUMP_END();

      if ( UNSUPPORTED( NEW_STYLE_CASTS ) ) {
        print_error( &(yylsp[-3]),
          "%s not supported%s\n", cast_literal,
          C_LANG_WHICH( NEW_STYLE_CASTS )
        );
        PARSE_ABORT();
      }

      c_ast_t *const cast_ast = c_ast_new_gc( K_CAST, &(yyloc) );
      cast_ast->sname = c_sname_move( &(yyvsp[-2].sname) );
      cast_ast->cast.kind = (yyvsp[-3].cast_kind);
      cast_ast->cast.to_ast = (yyvsp[0].ast);
      PARSE_ASSERT( c_ast_check( cast_ast ) );
      c_ast_gibberish( cast_ast, C_GIB_CAST, stdout );
    }
#line 5187 "parser.c"
    break;

  case 20: /* new_style_cast_english: Y_const cast_exp  */
#line 1811 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_CONST;        }
#line 5193 "parser.c"
    break;

  case 21: /* new_style_cast_english: Y_dynamic cast_exp  */
#line 1812 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_DYNAMIC;      }
#line 5199 "parser.c"
    break;

  case 22: /* new_style_cast_english: Y_reinterpret cast_exp  */
#line 1813 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_REINTERPRET;  }
#line 5205 "parser.c"
    break;

  case 23: /* new_style_cast_english: Y_static cast_exp  */
#line 1814 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_STATIC;       }
#line 5211 "parser.c"
    break;

  case 25: /* declare_command: Y_declare sname_list_english as_exp alignas_or_width_decl_english_ast  */
#line 1826 "parser.y"
    {
      if ( (yyvsp[0].ast)->kind == K_NAME ) {
        //
        // This checks for a case like:
        //
        //      declare x as y
        //
        // i.e., declaring a variable name as another name (unknown type).
        // This can get this far due to the nature of the C/C++ grammar.
        //
        // This check has to be done now in the parser rather than later in the
        // AST because the name of the AST node needs to be set to the variable
        // name, but the AST node is itself a name and overwriting it would
        // lose information.
        //
        assert( !c_sname_empty( &(yyvsp[0].ast)->sname ) );
        print_error_unknown_name( &(yylsp[0]), &(yyvsp[0].ast)->sname );
        c_sname_list_cleanup( &(yyvsp[-2].sname_list) );
        PARSE_ABORT();
      }

      DUMP_START( "declare_command",
                  "DECLARE sname_list_english AS "
                  "alignas_or_width_decl_english_ast" );
      DUMP_SNAME_LIST( "sname_list_english", (yyvsp[-2].sname_list) );
      DUMP_AST( "alignas_or_width_decl_english_ast", (yyvsp[0].ast) );

      (yyvsp[0].ast)->loc = (yylsp[-2]);

      DUMP_AST( "decl_english", (yyvsp[0].ast) );
      DUMP_END();

      // To check the declaration, it needs a name: just dup the first one.
      c_sname_t temp_sname = c_sname_dup( slist_front( &(yyvsp[-2].sname_list) ) );
      c_sname_set( &(yyvsp[0].ast)->sname, &temp_sname );

      bool ok = c_ast_check( (yyvsp[0].ast) );

      if ( ok ) {
        //
        // Ensure that none of the names aren't of a previously declared type:
        //
        //      cdecl> struct S
        //      cdecl> declare S as int // error: "S": previously declared
        //
        // This check is done now in the parser rather than later in the AST
        // since similar checks are also done here in the parser.
        //
        FOREACH_SLIST_NODE( sname_node, &(yyvsp[-2].sname_list) ) {
          c_sname_t const *const sname = sname_node->data;
          c_typedef_t const *const tdef = c_typedef_find_sname( sname );
          if ( tdef != NULL ) {
            print_error( &(yyvsp[0].ast)->loc,
              "\"%s\": previously declared as type: ",
              c_sname_full_name( sname )
            );
            print_type( tdef, stderr );
            ok = false;
            break;
          }
        } // for
      }

      if ( ok ) {
        unsigned gib_flags = C_GIB_DECL;
        if ( slist_len( &(yyvsp[-2].sname_list) ) > 1 )
          gib_flags |= C_GIB_MULTI_DECL;
        bool const print_as_using = c_ast_print_as_using( (yyvsp[0].ast) );
        if ( print_as_using && opt_semicolon ) {
          //
          // When declaring multiple types via the same "declare" as "using"
          // declarations, each type needs its own "using" declaration and
          // hence its own semicolon:
          //
          //      c++decl> declare I, J as type int
          //      using I = int;
          //      using J = int;
          //
          gib_flags |= C_GIB_FINAL_SEMI;
        }

        FOREACH_SLIST_NODE( sname_node, &(yyvsp[-2].sname_list) ) {
          c_sname_t *const cur_sname = sname_node->data;
          c_sname_set( &(yyvsp[0].ast)->sname, cur_sname );
          bool const is_last_sname = sname_node->next == NULL;
          if ( is_last_sname && opt_semicolon )
            gib_flags |= C_GIB_FINAL_SEMI;
          c_ast_gibberish( (yyvsp[0].ast), gib_flags, stdout );
          if ( is_last_sname )
            continue;
          if ( print_as_using ) {
            //
            // When declaring multiple types via the same "declare" as "using"
            // declarations, they need to be separated by newlines.  (The final
            // newine is handled below.)
            //
            PUTC( '\n' );
          }
          else {
            //
            // When declaring multiple types (not as "using" declarations) or
            // objects via the same "declare", the second and subsequent types
            // or objects must not have the type name printed -- and they also
            // need to be separated by commas.  For example, when printing:
            //
            //      cdecl> declare x, y as pointer to int
            //      int *x, *y;
            //
            // the gibberish for `y` must not print the `int` again.
            //
            gib_flags |= C_GIB_OMIT_TYPE;
            PUTS( ", " );
          }
        } // for
      }

      c_sname_list_cleanup( &(yyvsp[-2].sname_list) );
      PARSE_ASSERT( ok );
      PUTC( '\n' );
    }
#line 5336 "parser.c"
    break;

  case 26: /* $@1: %empty  */
#line 1951 "parser.y"
    { //
      // This check is done now in the parser rather than later in the AST
      // since it yields a better error message since otherwise it would warn
      // that "operator" is a keyword in C++98 which skims right past the
      // bigger error that operator overloading isn't supported in C.
      //
      if ( UNSUPPORTED( operator ) ) {
        print_error( &(yylsp[0]),
          "operator overloading not supported%s\n",
          C_LANG_WHICH( operator )
        );
        PARSE_ABORT();
      }
      in_attr.operator = c_oper_get( (yyvsp[0].oper_id) );
    }
#line 5356 "parser.c"
    break;

  case 27: /* declare_command: Y_declare c_operator $@1 of_scope_list_english_opt as_exp oper_decl_english_ast  */
#line 1968 "parser.y"
    {
      DUMP_START( "declare_command",
                  "DECLARE c_operator of_scope_list_english_opt AS "
                  "oper_decl_english_ast" );
      DUMP_STR( "c_operator", (yyvsp[0].ast)->oper.operator->literal );
      DUMP_SNAME( "of_scope_list_english_opt", (yyvsp[-2].sname) );
      DUMP_AST( "oper_decl_english_ast", (yyvsp[0].ast) );

      c_sname_set( &(yyvsp[0].ast)->sname, &(yyvsp[-2].sname) );
      (yyvsp[0].ast)->loc = (yylsp[-4]);

      DUMP_AST( "declare_command", (yyvsp[0].ast) );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( (yyvsp[0].ast) ) );
      unsigned gib_flags = C_GIB_DECL;
      if ( opt_semicolon )
        gib_flags |= C_GIB_FINAL_SEMI;
      c_ast_gibberish( (yyvsp[0].ast), gib_flags, stdout );
      PUTC( '\n' );
    }
#line 5382 "parser.c"
    break;

  case 28: /* declare_command: Y_declare storage_class_subset_english_type_opt Y_lambda capturing_paren_capture_decl_list_english_opt paren_param_decl_list_english_opt returning_english_ast_opt  */
#line 1997 "parser.y"
    {
      DUMP_START( "declare_command",
                  "DECLARE storage_class_subset_english_type_opt "
                  "LAMBDA capturing_paren_capture_decl_list_english_opt "
                  "paren_param_decl_list_english_opt"
                  "returning_english_ast_opt" );
      DUMP_TYPE( "storage_class_subset_english_type_opt", (yyvsp[-4].type) );
      DUMP_AST_LIST( "capturing_paren_capture_decl_list_english_opt",
                     (yyvsp[-2].ast_list) );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[-1].ast_list) );
      DUMP_AST( "returning_english_ast_opt", (yyvsp[0].ast) );

      c_ast_t *const lambda_ast = c_ast_new_gc( K_LAMBDA, &(yyloc) );
      lambda_ast->type = (yyvsp[-4].type);
      lambda_ast->lambda.capture_ast_list = slist_move( &(yyvsp[-2].ast_list) );
      lambda_ast->lambda.param_ast_list = slist_move( &(yyvsp[-1].ast_list) );
      c_ast_set_parent( (yyvsp[0].ast), lambda_ast );

      DUMP_AST( "declare_command", lambda_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( lambda_ast ) );
      c_ast_gibberish( lambda_ast, C_GIB_DECL, stdout );
      PUTC( '\n' );
    }
#line 5412 "parser.c"
    break;

  case 29: /* declare_command: Y_declare storage_class_subset_english_type_opt cv_qualifier_list_stid_opt user_defined conversion_exp operator_opt of_scope_list_english_opt returning_exp decl_english_ast  */
#line 2030 "parser.y"
    {
      DUMP_START( "declare_command",
                  "DECLARE storage_class_subset_english_type_opt "
                  "cv_qualifier_list_stid_opt "
                  "USER-DEFINED CONVERSION OPERATOR "
                  "of_scope_list_english_opt "
                  "RETURNING decl_english_ast" );
      DUMP_TYPE( "storage_class_subset_english_type_opt", (yyvsp[-7].type) );
      DUMP_TID( "cv_qualifier_list_stid_opt", (yyvsp[-6].tid) );
      DUMP_SNAME( "of_scope_list_english_opt", (yyvsp[-2].sname) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      c_ast_t *const udc_ast = c_ast_new_gc( K_USER_DEF_CONVERSION, &(yyloc) );
      c_sname_set( &udc_ast->sname, &(yyvsp[-2].sname) );
      udc_ast->type = c_type_or( &(yyvsp[-7].type), &C_TYPE_LIT_S( (yyvsp[-6].tid) ) );
      c_ast_set_parent( (yyvsp[0].ast), udc_ast );

      DUMP_AST( "declare_command", udc_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( udc_ast ) );
      unsigned gib_flags = C_GIB_DECL;
      if ( opt_semicolon )
        gib_flags |= C_GIB_FINAL_SEMI;
      c_ast_gibberish( udc_ast, gib_flags, stdout );
      PUTC( '\n' );
    }
#line 5444 "parser.c"
    break;

  case 30: /* declare_command: Y_declare error  */
#line 2059 "parser.y"
    {
      if ( OPT_LANG_IS( operator ) )
        elaborate_error( "name or operator expected" );
      else
        elaborate_error( "name expected" );
    }
#line 5455 "parser.c"
    break;

  case 32: /* alignas_or_width_decl_english_ast: decl_english_ast alignas_specifier_english  */
#line 2071 "parser.y"
    {
      (yyval.ast) = (yyvsp[-1].ast);
      (yyval.ast)->align = (yyvsp[0].align);
      (yyval.ast)->loc = (yyloc);
    }
#line 5465 "parser.c"
    break;

  case 33: /* alignas_or_width_decl_english_ast: decl_english_ast width_specifier_english_uint  */
#line 2078 "parser.y"
    { //
      // This check has to be done now in the parser rather than later in the
      // AST since we need to use the builtin union member now.
      //
      if ( !c_ast_is_integral( (yyvsp[-1].ast) ) ) {
        print_error( &(yylsp[0]),
          "bit-fields can be only of integral %stypes\n",
          OPT_LANG_IS( enum_BITFIELDS ) ? "or enumeration " : ""
        );
        PARSE_ABORT();
      }

      (yyval.ast) = (yyvsp[-1].ast);
      (yyval.ast)->loc = (yyloc);
      (yyval.ast)->bit_field.bit_width = (yyvsp[0].uint_val);
    }
#line 5486 "parser.c"
    break;

  case 34: /* alignas_specifier_english: aligned_english Y_INT_LIT bytes_opt  */
#line 2098 "parser.y"
    {
      (yyval.align).kind = C_ALIGNAS_BYTES;
      (yyval.align).loc = (yylsp[-2]);
      (yyval.align).bytes = STATIC_CAST( unsigned, (yyvsp[-1].int_val) );
    }
#line 5496 "parser.c"
    break;

  case 35: /* alignas_specifier_english: aligned_english decl_english_ast  */
#line 2104 "parser.y"
    {
      (yyval.align).kind = C_ALIGNAS_TYPE;
      (yyval.align).loc = (yylsp[-1]);
      (yyval.align).type_ast = (yyvsp[0].ast);
    }
#line 5506 "parser.c"
    break;

  case 36: /* alignas_specifier_english: aligned_english error  */
#line 2110 "parser.y"
    {
      MEM_ZERO( &(yyval.align) );
      (yyval.align).loc = (yylsp[-1]);
      elaborate_error( "integer or type expected" );
    }
#line 5516 "parser.c"
    break;

  case 40: /* capturing_paren_capture_decl_list_english_opt: %empty  */
#line 2124 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 5522 "parser.c"
    break;

  case 41: /* capturing_paren_capture_decl_list_english_opt: Y_capturing paren_capture_decl_list_english  */
#line 2126 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[0].ast_list);
    }
#line 5530 "parser.c"
    break;

  case 42: /* capturing_paren_capture_decl_list_english_opt: '[' capture_decl_list_english_opt ']'  */
#line 2130 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[-1].ast_list);
    }
#line 5538 "parser.c"
    break;

  case 43: /* paren_capture_decl_list_english: '[' capture_decl_list_english_opt ']'  */
#line 2137 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[-1].ast_list);
    }
#line 5546 "parser.c"
    break;

  case 44: /* paren_capture_decl_list_english: '(' capture_decl_list_english_opt ')'  */
#line 2141 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[-1].ast_list);
    }
#line 5554 "parser.c"
    break;

  case 45: /* paren_capture_decl_list_english: error  */
#line 2145 "parser.y"
    {
      slist_init( &(yyval.ast_list) );
      elaborate_error( "'[' or '(' expected\n" );
    }
#line 5563 "parser.c"
    break;

  case 46: /* capture_decl_list_english_opt: %empty  */
#line 2152 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 5569 "parser.c"
    break;

  case 48: /* capture_decl_list_english: capture_decl_list_english comma_exp capture_decl_english_ast  */
#line 2159 "parser.y"
    {
      DUMP_START( "capture_decl_list_english",
                  "capture_decl_list_english ',' capture_decl_english_ast" );
      DUMP_AST_LIST( "capture_decl_list_english", (yyvsp[-2].ast_list) );
      DUMP_AST( "capture_decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast_list) = (yyvsp[-2].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "capture_decl_list_english", (yyval.ast_list) );
      DUMP_END();
    }
#line 5586 "parser.c"
    break;

  case 49: /* capture_decl_list_english: capture_decl_english_ast  */
#line 2173 "parser.y"
    {
      DUMP_START( "capture_decl_list_english",
                  "capture_decl_english_ast" );
      DUMP_AST( "capture_decl_english_ast", (yyvsp[0].ast) );

      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "capture_decl_list_english", (yyval.ast_list) );
      DUMP_END();
    }
#line 5602 "parser.c"
    break;

  case 50: /* capture_decl_english_ast: Y_copy capture_default_opt  */
#line 2188 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_COPY;
    }
#line 5611 "parser.c"
    break;

  case 51: /* capture_decl_english_ast: Y_reference capture_default_opt  */
#line 2193 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_REFERENCE;
    }
#line 5620 "parser.c"
    break;

  case 52: /* capture_decl_english_ast: Y_reference Y_to name_exp  */
#line 2198 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      c_sname_append_name( &(yyval.ast)->sname, (yyvsp[0].name) );
      (yyval.ast)->capture.kind = C_CAPTURE_REFERENCE;
    }
#line 5630 "parser.c"
    break;

  case 57: /* width_specifier_english_uint: Y_width int_lit_exp bits_opt  */
#line 2214 "parser.y"
    { //
      // This check has to be done now in the parser rather than later in the
      // AST since we use 0 to mean "no bit-field."
      //
      if ( (yyvsp[-1].int_val) == 0 ) {
        print_error( &(yylsp[-1]), "bit-field width must be > 0\n" );
        PARSE_ABORT();
      }
      (yyval.uint_val) = STATIC_CAST( unsigned, (yyvsp[-1].int_val) );
    }
#line 5645 "parser.c"
    break;

  case 58: /* storage_class_subset_english_type_opt: %empty  */
#line 2227 "parser.y"
                                  { (yyval.type) = T_NONE; }
#line 5651 "parser.c"
    break;

  case 59: /* storage_class_subset_english_type_opt: storage_class_subset_english_type_opt storage_class_subset_english_type  */
#line 2230 "parser.y"
    {
      DUMP_START( "storage_class_subset_english_type_opt",
                  "storage_class_subset_english_type_opt "
                  "storage_class_subset_english_type" );
      DUMP_TYPE( "storage_class_subset_english_type_opt", (yyvsp[-1].type) );
      DUMP_TYPE( "storage_class_subset_english_type", (yyvsp[0].type) );

      (yyval.type) = (yyvsp[-1].type);
      PARSE_ASSERT( c_type_add( &(yyval.type), &(yyvsp[0].type), &(yylsp[0]) ) );

      DUMP_TYPE( "storage_class_subset_english_type_opt", (yyval.type) );
      DUMP_END();
    }
#line 5669 "parser.c"
    break;

  case 60: /* storage_class_subset_english_type: attribute_english_atid  */
#line 2246 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_A( (yyvsp[0].tid) ); }
#line 5675 "parser.c"
    break;

  case 61: /* storage_class_subset_english_type: storage_class_subset_english_stid  */
#line 2248 "parser.y"
    {
      (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) );
    }
#line 5683 "parser.c"
    break;

  case 62: /* storage_class_subset_english_stid: Y_const_ENG eval_expr_init_stid  */
#line 2269 "parser.y"
    {
      (yyval.tid) = (yyvsp[0].tid);
    }
#line 5691 "parser.c"
    break;

  case 72: /* storage_class_subset_english_stid: Y_no Y_except  */
#line 2281 "parser.y"
                                  { (yyval.tid) = TS_NOEXCEPT; }
#line 5697 "parser.c"
    break;

  case 78: /* storage_class_subset_english_stid: Y_pure virtual_stid_exp  */
#line 2287 "parser.y"
                                  { (yyval.tid) = TS_PURE_VIRTUAL | (yyvsp[0].tid); }
#line 5703 "parser.c"
    break;

  case 79: /* define_command: Y_define sname_english_exp as_exp decl_english_ast  */
#line 2294 "parser.y"
    {
      DUMP_START( "define_command",
                  "DEFINE sname_english AS decl_english_ast" );
      DUMP_SNAME( "sname", (yyvsp[-2].sname) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      c_sname_set( &(yyvsp[0].ast)->sname, &(yyvsp[-2].sname) );

      if ( (yyvsp[0].ast)->kind == K_NAME ) { // see the comment in "declare_command"
        assert( !c_sname_empty( &(yyvsp[0].ast)->sname ) );
        print_error_unknown_name( &(yylsp[0]), &(yyvsp[0].ast)->sname );
        PARSE_ABORT();
      }

      //
      // Explicitly add TS_TYPEDEF to prohibit cases like:
      //
      //      define eint as extern int
      //      define rint as register int
      //      define sint as static int
      //      ...
      //
      // i.e., a defined type with a storage class.  Once the semantic checks
      // pass, remove the TS_TYPEDEF.
      //
      PARSE_ASSERT( c_type_add( &(yyvsp[0].ast)->type, &T_TS_TYPEDEF, &(yylsp[0]) ) );
      PARSE_ASSERT( c_ast_check( (yyvsp[0].ast) ) );
      PJL_IGNORE_RV( c_ast_take_type_any( (yyvsp[0].ast), &T_TS_TYPEDEF ) );

      if ( c_tid_is_any( (yyvsp[0].ast)->type.btids, TB_ANY_SCOPE ) )
        c_sname_set_local_type( &(yyvsp[0].ast)->sname, &(yyvsp[0].ast)->type );
      c_sname_fill_in_namespaces( &(yyvsp[0].ast)->sname );

      DUMP_AST( "defined.ast", (yyvsp[0].ast) );
      DUMP_END();

      PARSE_ASSERT( c_sname_check( &(yyvsp[0].ast)->sname, &(yylsp[-2]) ) );
      PARSE_ASSERT( add_type( (yyvsp[0].ast), C_GIB_NONE ) );
    }
#line 5747 "parser.c"
    break;

  case 90: /* explain_command: explain pc99_pointer_decl_list_c  */
#line 2397 "parser.y"
    {
      PARSE_ASSERT( c_ast_list_check( &(yyvsp[0].ast_list) ) );
      c_ast_list_english( &(yyvsp[0].ast_list), stdout );
    }
#line 5756 "parser.c"
    break;

  case 92: /* $@2: %empty  */
#line 2415 "parser.y"
                       { in_attr.is_typename = true; }
#line 5762 "parser.c"
    break;

  case 95: /* explain_command: explain extern_linkage_c_stid_opt using_decl_c_ast  */
#line 2436 "parser.y"
    {
      DUMP_START( "explain_command",
                  "EXPLAIN extern_linkage_c_stid_opt using_decl_c_ast" );
      DUMP_TID( "extern_linkage_c_stid_opt", (yyvsp[-1].tid) );
      DUMP_AST( "using_decl_c_ast", (yyvsp[0].ast) );
      DUMP_END();

      PARSE_ASSERT(
        c_type_add_tid( &(yyvsp[0].ast)->type, (yyvsp[-1].tid), &(yylsp[-1]) )
      );
      PARSE_ASSERT( c_ast_check( (yyvsp[0].ast) ) );
      c_ast_english( (yyvsp[0].ast), stdout );
    }
#line 5780 "parser.c"
    break;

  case 96: /* explain_command: explain sname_c  */
#line 2455 "parser.y"
    {
      print_error_unknown_name( &(yylsp[0]), &(yyvsp[0].sname) );
      c_sname_cleanup( &(yyvsp[0].sname) );
      PARSE_ABORT();
    }
#line 5790 "parser.c"
    break;

  case 97: /* explain_command: explain error  */
#line 2462 "parser.y"
    {
      elaborate_error( "cast or declaration expected" );
    }
#line 5798 "parser.c"
    break;

  case 98: /* explain: Y_explain  */
#line 2469 "parser.y"
    { //
      // Set our mode to deciphering gibberish into English and specifically
      // tell the lexer to return cdecl keywords (e.g., "func") as ordinary
      // names, otherwise gibberish like:
      //
      //      int func(void);
      //
      // would result in a parser error.
      //
      gibberish_to_english();
    }
#line 5814 "parser.c"
    break;

  case 99: /* help_command: Y_help help_what_opt  */
#line 2485 "parser.y"
                                  { print_help( (yyvsp[0].help) ); }
#line 5820 "parser.c"
    break;

  case 100: /* help_what_opt: %empty  */
#line 2489 "parser.y"
                                  { (yyval.help) = CDECL_HELP_COMMANDS; }
#line 5826 "parser.c"
    break;

  case 101: /* help_what_opt: Y_commands  */
#line 2490 "parser.y"
                                  { (yyval.help) = CDECL_HELP_COMMANDS; }
#line 5832 "parser.c"
    break;

  case 102: /* help_what_opt: Y_english  */
#line 2491 "parser.y"
                                  { (yyval.help) = CDECL_HELP_ENGLISH;  }
#line 5838 "parser.c"
    break;

  case 103: /* help_what_opt: Y_options  */
#line 2492 "parser.y"
                                  { (yyval.help) = CDECL_HELP_OPTIONS;  }
#line 5844 "parser.c"
    break;

  case 104: /* help_what_opt: error  */
#line 2494 "parser.y"
    {
      elaborate_error( "\"commands\", \"english\", or \"options\" expected" );
    }
#line 5852 "parser.c"
    break;

  case 105: /* quit_command: Y_quit  */
#line 2502 "parser.y"
                                  { quit(); }
#line 5858 "parser.c"
    break;

  case 107: /* set_command: Y_set  */
#line 2515 "parser.y"
    {
      PARSE_ASSERT( set_option( NULL, NULL, NULL, NULL ) );
    }
#line 5866 "parser.c"
    break;

  case 111: /* set_option: Y_SET_OPTION set_option_value_opt  */
#line 2528 "parser.y"
    {
      bool const ok = set_option( (yyvsp[-1].name), &(yylsp[-1]), (yyvsp[0].str_val), &(yylsp[0]) );
      free( (yyvsp[-1].name) );
      free( (yyvsp[0].str_val) );
      PARSE_ASSERT( ok );
    }
#line 5877 "parser.c"
    break;

  case 112: /* set_option_value_opt: %empty  */
#line 2537 "parser.y"
                                  { (yyval.str_val) = NULL; }
#line 5883 "parser.c"
    break;

  case 113: /* set_option_value_opt: '=' Y_SET_OPTION  */
#line 2538 "parser.y"
                                  { (yyval.str_val) = (yyvsp[0].name); (yyloc) = (yylsp[0]); }
#line 5889 "parser.c"
    break;

  case 114: /* set_option_value_opt: '=' error  */
#line 2540 "parser.y"
    {
      (yyval.str_val) = NULL;
      elaborate_error( "option value expected" );
    }
#line 5898 "parser.c"
    break;

  case 115: /* show_command: Y_show any_typedef show_format_opt  */
#line 2550 "parser.y"
    {
      DUMP_START( "show_command", "SHOW any_typedef show_format_opt" );
      DUMP_AST( "any_typedef__ast", (yyvsp[-1].tdef)->ast );
      DUMP_INT( "show_format_opt", (yyvsp[0].flags) );
      DUMP_END();

      show_type( (yyvsp[-1].tdef), (yyvsp[0].flags) );
    }
#line 5911 "parser.c"
    break;

  case 116: /* show_command: Y_show any_typedef Y_as show_format_exp  */
#line 2560 "parser.y"
    {
      DUMP_START( "show_command", "SHOW any_typedef AS show_format_exp" );
      DUMP_AST( "any_typedef__ast", (yyvsp[-2].tdef)->ast );
      DUMP_INT( "show_format_exp", (yyvsp[0].flags) );
      DUMP_END();

      show_type( (yyvsp[-2].tdef), (yyvsp[0].flags) );
    }
#line 5924 "parser.c"
    break;

  case 117: /* show_command: Y_show show_which_types_flags_opt glob_opt show_format_opt  */
#line 2571 "parser.y"
    {
      show_type_info_t sti;
      sti_init( &sti, (yyvsp[-2].flags), (yyvsp[-1].name), (yyvsp[0].flags) );
      c_typedef_visit( &show_type_visitor, &sti );
      sti_cleanup( &sti );
      free( (yyvsp[-1].name) );
    }
#line 5936 "parser.c"
    break;

  case 118: /* show_command: Y_show show_which_types_flags_opt glob_opt Y_as show_format_exp  */
#line 2581 "parser.y"
    {
      show_type_info_t sti;
      sti_init( &sti, (yyvsp[-3].flags), (yyvsp[-2].name), (yyvsp[0].flags) );
      c_typedef_visit( &show_type_visitor, &sti );
      sti_cleanup( &sti );
      free( (yyvsp[-2].name) );
    }
#line 5948 "parser.c"
    break;

  case 119: /* show_command: Y_show Y_NAME  */
#line 2590 "parser.y"
    {
      static char const *const TYPE_COMMANDS_KNR[] = {
        L_define, L_struct, L_typedef, L_union, NULL
      };
      static char const *const TYPE_COMMANDS_C[] = {
        L_define, L_enum, L_struct, L_typedef, L_union, NULL
      };
      static char const *const TYPE_COMMANDS_CPP_WITHOUT_USING[] = {
        L_class, L_define, L_enum, L_struct, L_typedef, L_union, NULL
      };
      static char const *const TYPE_COMMANDS_CPP_WITH_USING[] = {
        L_class, L_define, L_enum, L_struct, L_typedef, L_union, L_using, NULL
      };

      char const *const *const type_commands =
        OPT_LANG_IS( C_KNR )       ? TYPE_COMMANDS_KNR :
        OPT_LANG_IS( C_ANY )       ? TYPE_COMMANDS_C :
        OPT_LANG_IS( using_DECLS ) ? TYPE_COMMANDS_CPP_WITH_USING :
                                     TYPE_COMMANDS_CPP_WITHOUT_USING;

      print_error( &(yylsp[0]), "\"%s\": not defined as type via ", (yyvsp[0].name) );
      fput_list( stderr, type_commands, /*gets=*/NULL );
      print_suggestions( DYM_C_TYPES, (yyvsp[0].name) );
      EPUTC( '\n' );
      free( (yyvsp[0].name) );
      PARSE_ABORT();
    }
#line 5980 "parser.c"
    break;

  case 120: /* show_command: Y_show error  */
#line 2619 "parser.y"
    {
      elaborate_error(
        "type name or \"all\", \"predefined\", or \"user\" expected"
      );
    }
#line 5990 "parser.c"
    break;

  case 121: /* show_format: Y_english  */
#line 2627 "parser.y"
                                  { (yyval.flags) = C_GIB_NONE; }
#line 5996 "parser.c"
    break;

  case 122: /* show_format: Y_typedef  */
#line 2628 "parser.y"
                                  { (yyval.flags) = C_GIB_TYPEDEF; }
#line 6002 "parser.c"
    break;

  case 123: /* show_format: Y_using  */
#line 2630 "parser.y"
    {
      if ( UNSUPPORTED( using_DECLS ) ) {
        print_error( &(yylsp[0]),
          "\"using\" not supported%s\n",
          C_LANG_WHICH( using_DECLS )
        );
        PARSE_ABORT();
      }
      (yyval.flags) = C_GIB_USING;
    }
#line 6017 "parser.c"
    break;

  case 125: /* show_format_exp: error  */
#line 2645 "parser.y"
    {
      if ( OPT_LANG_IS( using_DECLS ) )
        elaborate_error( "\"english\", \"typedef\", or \"using\" expected" );
      else
        elaborate_error( "\"english\" or \"typedef\" expected" );
    }
#line 6028 "parser.c"
    break;

  case 126: /* show_format_opt: %empty  */
#line 2654 "parser.y"
                                  { (yyval.flags) = C_GIB_NONE; }
#line 6034 "parser.c"
    break;

  case 128: /* show_which_types_flags_opt: %empty  */
#line 2659 "parser.y"
                                  { (yyval.flags) = SHOW_USER_DEFINED_TYPES; }
#line 6040 "parser.c"
    break;

  case 129: /* show_which_types_flags_opt: Y_all predefined_or_user_flags_opt  */
#line 2661 "parser.y"
    {
      (yyval.flags) = SHOW_ALL_TYPES |
           ((yyvsp[0].flags) != 0 ?
            (yyvsp[0].flags) :
            SHOW_PREDEFINED_TYPES | SHOW_USER_DEFINED_TYPES);
    }
#line 6051 "parser.c"
    break;

  case 130: /* show_which_types_flags_opt: Y_predefined  */
#line 2667 "parser.y"
                                  { (yyval.flags) = SHOW_PREDEFINED_TYPES; }
#line 6057 "parser.c"
    break;

  case 131: /* show_which_types_flags_opt: Y_user  */
#line 2668 "parser.y"
                                  { (yyval.flags) = SHOW_USER_DEFINED_TYPES; }
#line 6063 "parser.c"
    break;

  case 132: /* predefined_or_user_flags_opt: %empty  */
#line 2672 "parser.y"
                                  { (yyval.flags) = 0; }
#line 6069 "parser.c"
    break;

  case 133: /* predefined_or_user_flags_opt: Y_predefined  */
#line 2673 "parser.y"
                                  { (yyval.flags) = SHOW_PREDEFINED_TYPES; }
#line 6075 "parser.c"
    break;

  case 134: /* predefined_or_user_flags_opt: Y_user  */
#line 2674 "parser.y"
                                  { (yyval.flags) = SHOW_USER_DEFINED_TYPES; }
#line 6081 "parser.c"
    break;

  case 138: /* $@3: %empty  */
#line 2703 "parser.y"
    {
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 6089 "parser.c"
    break;

  case 139: /* c_style_cast_expr_c: '(' type_c_ast $@3 cast_c_astp_opt rparen_exp sname_c_opt  */
#line 2707 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "explain_command",
                  "EXPLAIN '(' type_c_ast cast_c_astp_opt ')' sname_c_opt" );
      DUMP_AST( "type_c_ast", (yyvsp[-4].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-2].ast_pair) );
      DUMP_SNAME( "sname_c_opt", (yyvsp[0].sname) );

      c_ast_t *const cast_ast = c_ast_new_gc( K_CAST, &(yyloc) );
      cast_ast->sname = c_sname_move( &(yyvsp[0].sname) );
      cast_ast->cast.kind = C_CAST_C;
      cast_ast->cast.to_ast =
        c_ast_patch_placeholder( (yyvsp[-4].ast), (yyvsp[-2].ast_pair).ast );

      DUMP_AST( "explain_command", cast_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( cast_ast ) );
      c_ast_english( cast_ast, stdout );
    }
#line 6115 "parser.c"
    break;

  case 140: /* c_style_cast_expr_c: '(' pc99_pointer_decl_list_c rparen_exp  */
#line 2739 "parser.y"
    {
      PARSE_ASSERT( c_ast_list_check( &(yyvsp[-1].ast_list) ) );
      c_ast_list_english( &(yyvsp[-1].ast_list), stdout );
    }
#line 6124 "parser.c"
    break;

  case 141: /* $@4: %empty  */
#line 2749 "parser.y"
    {
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 6132 "parser.c"
    break;

  case 142: /* new_style_cast_expr_c: new_style_cast_c lt_exp type_c_ast $@4 cast_c_astp_opt gt_exp lparen_exp sname_c_exp rparen_exp  */
#line 2753 "parser.y"
    {
      ia_type_ast_pop();

      char const *const cast_literal = c_cast_english( (yyvsp[-8].cast_kind) );

      DUMP_START( "explain_command",
                  "EXPLAIN new_style_cast_c"
                  "'<' type_c_ast cast_c_astp_opt '>' '(' sname ')'" );
      DUMP_STR( "new_style_cast_c", cast_literal );
      DUMP_AST( "type_c_ast", (yyvsp[-6].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-4].ast_pair) );
      DUMP_SNAME( "sname", (yyvsp[-1].sname) );

      c_ast_t *const cast_ast = c_ast_new_gc( K_CAST, &(yyloc) );
      cast_ast->sname = c_sname_move( &(yyvsp[-1].sname) );
      cast_ast->cast.kind = (yyvsp[-8].cast_kind);
      cast_ast->cast.to_ast =
        c_ast_patch_placeholder( (yyvsp[-6].ast), (yyvsp[-4].ast_pair).ast );

      DUMP_AST( "explain_command", cast_ast );
      DUMP_END();

      if ( UNSUPPORTED( NEW_STYLE_CASTS ) ) {
        print_error( &(yylsp[-8]),
          "%s_cast not supported%s\n",
          cast_literal, C_LANG_WHICH( NEW_STYLE_CASTS )
        );
        PARSE_ABORT();
      }

      PARSE_ASSERT( c_ast_check( cast_ast ) );
      c_ast_english( cast_ast, stdout );
    }
#line 6170 "parser.c"
    break;

  case 143: /* new_style_cast_c: Y_const_cast  */
#line 2789 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_CONST;        }
#line 6176 "parser.c"
    break;

  case 144: /* new_style_cast_c: Y_dynamic_cast  */
#line 2790 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_DYNAMIC;      }
#line 6182 "parser.c"
    break;

  case 145: /* new_style_cast_c: Y_reinterpret_cast  */
#line 2791 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_REINTERPRET;  }
#line 6188 "parser.c"
    break;

  case 146: /* new_style_cast_c: Y_static_cast  */
#line 2792 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_STATIC;       }
#line 6194 "parser.c"
    break;

  case 147: /* $@5: %empty  */
#line 2802 "parser.y"
                                  { in_attr.align = (yyvsp[0].align); }
#line 6200 "parser.c"
    break;

  case 148: /* $@6: %empty  */
#line 2803 "parser.y"
                                  { in_attr.is_typename = (yyvsp[0].flag); }
#line 6206 "parser.c"
    break;

  case 150: /* alignas_specifier_c: alignas lparen_exp Y_INT_LIT rparen_exp  */
#line 2809 "parser.y"
    {
      DUMP_START( "alignas_specifier_c", "ALIGNAS '(' Y_INT_LIT ')'" );
      DUMP_INT( "INT_LIT", (yyvsp[-1].int_val) );
      DUMP_END();

      (yyval.align).kind = C_ALIGNAS_BYTES;
      (yyval.align).loc = (yylsp[-3]);
      (yyval.align).bytes = STATIC_CAST( unsigned, (yyvsp[-1].int_val) );
    }
#line 6220 "parser.c"
    break;

  case 151: /* $@7: %empty  */
#line 2819 "parser.y"
                                            { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 6226 "parser.c"
    break;

  case 152: /* alignas_specifier_c: alignas lparen_exp type_c_ast $@7 cast_c_astp_opt rparen_exp  */
#line 2821 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "alignas_specifier_c",
                  "ALIGNAS '(' type_c_ast cast_c_astp_opt ')'" );
      DUMP_AST( "type_c_ast", (yyvsp[-3].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-1].ast_pair) );
      DUMP_END();

      (yyval.align).kind = C_ALIGNAS_TYPE;
      (yyval.align).loc = (yylsp[-5]);
      (yyval.align).type_ast = c_ast_patch_placeholder( (yyvsp[-3].ast), (yyvsp[-1].ast_pair).ast );
    }
#line 6244 "parser.c"
    break;

  case 153: /* alignas_specifier_c: alignas lparen_exp error ')'  */
#line 2836 "parser.y"
    {
      elaborate_error( "integer or type expected" );
    }
#line 6252 "parser.c"
    break;

  case 156: /* asm_declaration_c: Y_asm lparen_exp str_lit_exp rparen_exp  */
#line 2850 "parser.y"
    {
      free( (yyvsp[-1].str_val) );
      print_error( &(yylsp[-3]), "asm declarations not supported by %s\n", CDECL );
      PARSE_ABORT();
    }
#line 6262 "parser.c"
    break;

  case 160: /* $@8: %empty  */
#line 2870 "parser.y"
    {
      PARSE_ASSERT( is_nested_type_ok( &(yylsp[0]) ) );
      gibberish_to_english();           // see the comment in "explain"
    }
#line 6271 "parser.c"
    break;

  case 161: /* $@9: %empty  */
#line 2875 "parser.y"
    {
      c_type_t const *const cur_type =
        c_sname_local_type( &in_attr.current_scope );
      if ( c_tid_is_any( cur_type->btids, TB_ANY_CLASS ) ) {
        char const *const cur_name =
          c_sname_local_name( &in_attr.current_scope );
        char const *const mbr_name = c_sname_local_name( &(yyvsp[0].sname) );
        if ( strcmp( mbr_name, cur_name ) == 0 ) {
          print_error( &(yylsp[0]),
            "\"%s\": member has the same name as its enclosing %s\n",
            mbr_name, c_type_name_c( cur_type )
          );
          c_sname_cleanup( &(yyvsp[0].sname) );
          PARSE_ABORT();
        }
      }

      DUMP_START( "class_struct_union_declaration_c",
                  "class_struct_union_btid sname '{' "
                  "in_scope_declaration_c_opt "
                  "'}' ';'" );
      DUMP_SNAME( "in_attr__current_scope", in_attr.current_scope );
      DUMP_TID( "class_struct_union_btid", (yyvsp[-2].tid) );
      DUMP_SNAME( "any_sname_c", (yyvsp[0].sname) );

      c_sname_append_sname( &in_attr.current_scope, &(yyvsp[0].sname) );
      c_sname_set_local_type(
        &in_attr.current_scope, &C_TYPE_LIT_B( (yyvsp[-2].tid) )
      );
      PARSE_ASSERT( c_sname_check( &in_attr.current_scope, &(yylsp[0]) ) );

      c_ast_t *const csu_ast = c_ast_new_gc( K_CLASS_STRUCT_UNION, &(yylsp[0]) );
      csu_ast->sname = c_sname_dup( &in_attr.current_scope );
      c_sname_append_name(
        &csu_ast->csu.csu_sname,
        check_strdup( c_sname_local_name( &in_attr.current_scope ) )
      );
      csu_ast->type.btids = c_tid_check( (yyvsp[-2].tid), C_TPID_BASE );

      DUMP_AST( "class_struct_union_declaration_c", csu_ast );
      DUMP_END();

      PARSE_ASSERT( add_type( csu_ast, C_GIB_TYPEDEF ) );
    }
#line 6320 "parser.c"
    break;

  case 163: /* $@10: %empty  */
#line 2927 "parser.y"
    {
      PARSE_ASSERT( is_nested_type_ok( &(yylsp[0]) ) );
      gibberish_to_english();           // see the comment in "explain"
    }
#line 6329 "parser.c"
    break;

  case 164: /* enum_declaration_c: enum_btids $@10 any_sname_c_exp enum_fixed_type_c_ast_opt  */
#line 2932 "parser.y"
    {
      DUMP_START( "enum_declaration_c", "enum_btids sname ';'" );
      DUMP_TID( "enum_btids", (yyvsp[-3].tid) );
      DUMP_SNAME( "any_sname_c", (yyvsp[-1].sname) );
      DUMP_AST( "enum_fixed_type_c_ast_opt", (yyvsp[0].ast) );

      c_sname_t enum_sname = c_sname_dup( &in_attr.current_scope );
      c_sname_append_sname( &enum_sname, &(yyvsp[-1].sname) );
      c_sname_set_local_type( &enum_sname, &C_TYPE_LIT_B( (yyvsp[-3].tid) ) );
      if ( !c_sname_check( &enum_sname, &(yylsp[-1]) ) ) {
        c_sname_cleanup( &enum_sname );
        PARSE_ABORT();
      }

      c_ast_t *const enum_ast = c_ast_new_gc( K_ENUM, &(yylsp[-1]) );
      enum_ast->sname = enum_sname;
      enum_ast->type.btids = c_tid_check( (yyvsp[-3].tid), C_TPID_BASE );
      enum_ast->enum_.of_ast = (yyvsp[0].ast);
      c_sname_append_name(
        &enum_ast->enum_.enum_sname,
        check_strdup( c_sname_local_name( &enum_sname ) )
      );

      DUMP_AST( "enum_declaration_c", enum_ast );
      DUMP_END();

      PARSE_ASSERT( add_type( enum_ast, C_GIB_TYPEDEF ) );
    }
#line 6362 "parser.c"
    break;

  case 165: /* $@11: %empty  */
#line 2967 "parser.y"
    {
      gibberish_to_english();           // see the comment in "explain"
    }
#line 6370 "parser.c"
    break;

  case 166: /* $@12: %empty  */
#line 2971 "parser.y"
    {
      DUMP_START( "namespace_declaration_c",
                  "namespace_type sname '{' "
                  "in_scope_declaration_c_opt "
                  "'}' [';']" );
      DUMP_SNAME( "in_attr__current_scope", in_attr.current_scope );
      DUMP_TYPE( "namespace_type", (yyvsp[-2].type) );
      DUMP_SNAME( "any_sname_c", (yyvsp[0].sname) );
      DUMP_END();

      //
      // Nested namespace declarations are supported only in C++17 and later.
      // (However, we always allow them in configuration files.)
      //
      // This check has to be done now in the parser rather than later in the
      // AST because the AST has no "memory" of how a namespace was
      // constructed.
      //
      if ( c_sname_count( &(yyvsp[0].sname) ) > 1 && UNSUPPORTED( NESTED_namespace ) ) {
        print_error( &(yylsp[0]),
          "nested namespace declarations not supported%s\n",
          C_LANG_WHICH( NESTED_namespace )
        );
        c_sname_cleanup( &(yyvsp[0].sname) );
        PARSE_ABORT();
      }

      //
      // The namespace type (plain namespace or inline namespace) has to be
      // split across the namespace sname: only the storage classes (for
      // TS_INLINE) has to be or'd with the first scope-type of the sname ...
      //
      c_type_t const *const sname_first_type = c_sname_first_type( &(yyvsp[0].sname) );
      c_sname_set_first_type(
        &(yyvsp[0].sname),
        &C_TYPE_LIT(
          sname_first_type->btids,
          sname_first_type->stids | (yyvsp[-2].type).stids,
          sname_first_type->atids
        )
      );
      //
      // ... and only the base types (for TB_NAMESPACE) has to be or'd with the
      // local scope type of the sname.
      //
      c_type_t const *const sname_local_type = c_sname_local_type( &(yyvsp[0].sname) );
      c_sname_set_local_type(
        &(yyvsp[0].sname),
        &C_TYPE_LIT(
          sname_local_type->btids | (yyvsp[-2].type).btids,
          sname_local_type->stids,
          sname_local_type->atids
        )
      );

      c_sname_append_sname( &in_attr.current_scope, &(yyvsp[0].sname) );
      PARSE_ASSERT( c_sname_check( &in_attr.current_scope, &(yylsp[0]) ) );
    }
#line 6433 "parser.c"
    break;

  case 170: /* namespace_sname_c_exp: error  */
#line 3036 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      elaborate_error( "name expected" );
    }
#line 6442 "parser.c"
    break;

  case 171: /* namespace_sname_c: namespace_sname_c Y_COLON2 Y_NAME  */
#line 3049 "parser.y"
    {
      DUMP_START( "namespace_sname_c", "sname_c '::' NAME" );
      DUMP_SNAME( "namespace_sname_c", (yyvsp[-2].sname) );
      DUMP_STR( "name", (yyvsp[0].name) );

      (yyval.sname) = (yyvsp[-2].sname);
      c_sname_append_name( &(yyval.sname), (yyvsp[0].name) );
      c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT_B( TB_NAMESPACE ) );

      DUMP_SNAME( "namespace_sname_c", (yyval.sname) );
      DUMP_END();
    }
#line 6459 "parser.c"
    break;

  case 172: /* namespace_sname_c: namespace_sname_c Y_COLON2 any_typedef  */
#line 3063 "parser.y"
    {
      DUMP_START( "namespace_sname_c", "namespace_sname_c '::' any_typedef" );
      DUMP_SNAME( "namespace_sname_c", (yyvsp[-2].sname) );
      DUMP_AST( "any_typedef__ast", (yyvsp[0].tdef)->ast );

      (yyval.sname) = (yyvsp[-2].sname);
      c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT_B( TB_NAMESPACE ) );
      c_sname_t temp_sname = c_sname_dup( &(yyvsp[0].tdef)->ast->sname );
      c_sname_append_sname( &(yyval.sname), &temp_sname );

      DUMP_SNAME( "namespace_sname_c", (yyval.sname) );
      DUMP_END();
    }
#line 6477 "parser.c"
    break;

  case 173: /* namespace_sname_c: namespace_sname_c Y_COLON2 Y_inline name_exp  */
#line 3078 "parser.y"
    {
      DUMP_START( "namespace_sname_c", "sname_c '::' NAME INLINE NAME" );
      DUMP_SNAME( "namespace_sname_c", (yyvsp[-3].sname) );
      DUMP_STR( "name", (yyvsp[0].name) );

      (yyval.sname) = (yyvsp[-3].sname);
      c_sname_append_name( &(yyval.sname), (yyvsp[0].name) );
      c_sname_set_local_type( &(yyval.sname),
        &C_TYPE_LIT( TB_NAMESPACE, (yyvsp[-1].tid), TA_NONE )
      );

      DUMP_SNAME( "namespace_sname_c", (yyval.sname) );
      DUMP_END();
    }
#line 6496 "parser.c"
    break;

  case 174: /* namespace_sname_c: Y_NAME  */
#line 3094 "parser.y"
    {
      DUMP_START( "namespace_sname_c", "NAME" );
      DUMP_STR( "NAME", (yyvsp[0].name) );

      c_sname_init_name( &(yyval.sname), (yyvsp[0].name) );
      c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT_B( TB_NAMESPACE ) );

      DUMP_SNAME( "sname_c", (yyval.sname) );
      DUMP_END();
    }
#line 6511 "parser.c"
    break;

  case 175: /* namespace_typedef_sname_c: namespace_typedef_sname_c Y_COLON2 sname_c  */
#line 3113 "parser.y"
    {
      DUMP_START( "namespace_typedef_sname_c",
                  "namespace_typedef_sname_c '::' sname_c" );
      DUMP_SNAME( "namespace_typedef_sname_c", (yyvsp[-2].sname) );
      DUMP_SNAME( "sname_c", (yyvsp[0].sname) );

      (yyval.sname) = (yyvsp[-2].sname);
      c_sname_append_sname( &(yyval.sname), &(yyvsp[0].sname) );

      DUMP_SNAME( "typedef_sname_c", (yyval.sname) );
      DUMP_END();
    }
#line 6528 "parser.c"
    break;

  case 176: /* namespace_typedef_sname_c: namespace_typedef_sname_c Y_COLON2 any_typedef  */
#line 3127 "parser.y"
    {
      DUMP_START( "namespace_typedef_sname_c",
                  "namespace_typedef_sname_c '::' any_typedef" );
      DUMP_SNAME( "namespace_typedef_sname_c", (yyvsp[-2].sname) );
      DUMP_AST( "any_typedef", (yyvsp[0].tdef)->ast );

      (yyval.sname) = (yyvsp[-2].sname);
      c_sname_set_local_type( &(yyval.sname), c_sname_local_type( &(yyvsp[0].tdef)->ast->sname ) );
      c_sname_t temp_sname = c_sname_dup( &(yyvsp[0].tdef)->ast->sname );
      c_sname_append_sname( &(yyval.sname), &temp_sname );

      DUMP_SNAME( "typedef_sname_c", (yyval.sname) );
      DUMP_END();
    }
#line 6547 "parser.c"
    break;

  case 177: /* namespace_typedef_sname_c: namespace_typedef_sname_c Y_COLON2 Y_inline name_exp  */
#line 3144 "parser.y"
    {
      DUMP_START( "namespace_typedef_sname_c",
                  "namespace_typedef_sname_c '::' INLINE NAME" );
      DUMP_SNAME( "namespace_typedef_sname_c", (yyvsp[-3].sname) );
      DUMP_STR( "name", (yyvsp[0].name) );

      (yyval.sname) = (yyvsp[-3].sname);
      c_sname_append_name( &(yyval.sname), (yyvsp[0].name) );
      c_sname_set_local_type( &(yyval.sname),
        &C_TYPE_LIT( TB_NAMESPACE, (yyvsp[-1].tid), TA_NONE )
      );

      DUMP_SNAME( "namespace_typedef_sname_c", (yyval.sname) );
      DUMP_END();
    }
#line 6567 "parser.c"
    break;

  case 178: /* namespace_typedef_sname_c: any_typedef  */
#line 3160 "parser.y"
                                  { (yyval.sname) = c_sname_dup( &(yyvsp[0].tdef)->ast->sname ); }
#line 6573 "parser.c"
    break;

  case 180: /* brace_in_scope_declaration_c_exp: error  */
#line 3166 "parser.y"
    {
      punct_expected( '{' );
    }
#line 6581 "parser.c"
    break;

  case 188: /* in_scope_declaration_c_exp: error  */
#line 3186 "parser.y"
    {
      elaborate_error( "declaration expected" );
    }
#line 6589 "parser.c"
    break;

  case 189: /* lambda_declaration_c: '[' capture_decl_list_c_opt ']' lambda_param_c_ast_list_opt storage_class_subset_english_type_opt lambda_return_type_c_ast_opt  */
#line 3198 "parser.y"
    {
      DUMP_START( "lambda_declaration_c",
                  "'[' capture_decl_list_c_opt ']' "
                  "lambda_param_c_ast_list_opt "
                  "lambda_return_type_c_ast_opt" );
      DUMP_AST_LIST( "capture_decl_list_c_opt", (yyvsp[-4].ast_list) );
      DUMP_AST_LIST( "lambda_param_c_ast_list_opt", (yyvsp[-2].ast_list) );
      DUMP_TYPE( "storage_class_subset_english_type_opt", (yyvsp[-1].type) );
      DUMP_AST( "lambda_return_type_c_ast_opt", (yyvsp[0].ast) );

      c_ast_t *const lambda_ast = c_ast_new_gc( K_LAMBDA, &(yyloc) );
      lambda_ast->type = (yyvsp[-1].type);
      lambda_ast->lambda.capture_ast_list = slist_move( &(yyvsp[-4].ast_list) );
      lambda_ast->lambda.param_ast_list = slist_move( &(yyvsp[-2].ast_list) );
      c_ast_set_parent( (yyvsp[0].ast), lambda_ast );

      DUMP_AST( "lambda_declaration_c", lambda_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( lambda_ast ) );
      c_ast_english( lambda_ast, stdout );
    }
#line 6616 "parser.c"
    break;

  case 190: /* capture_decl_list_c_opt: %empty  */
#line 3223 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 6622 "parser.c"
    break;

  case 192: /* capture_decl_list_c: capture_decl_list_c comma_exp capture_decl_c_ast  */
#line 3230 "parser.y"
    {
      DUMP_START( "capture_decl_list_c",
                  "capture_decl_list_c ',' "
                  "capture_decl_c_ast" );
      DUMP_AST_LIST( "capture_decl_list_c", (yyvsp[-2].ast_list) );
      DUMP_AST( "capture_decl_c_ast", (yyvsp[0].ast) );

      (yyval.ast_list) = (yyvsp[-2].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "capture_decl_list_c", (yyval.ast_list) );
      DUMP_END();
    }
#line 6640 "parser.c"
    break;

  case 193: /* capture_decl_list_c: capture_decl_c_ast  */
#line 3245 "parser.y"
    {
      DUMP_START( "capture_decl_list_c",
                  "capture_decl_c_ast" );
      DUMP_AST( "capture_decl_c_ast", (yyvsp[0].ast) );

      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "capture_decl_list_c", (yyval.ast_list) );
      DUMP_END();
    }
#line 6656 "parser.c"
    break;

  case 194: /* capture_decl_c_ast: Y_AMPER  */
#line 3260 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_REFERENCE;
    }
#line 6665 "parser.c"
    break;

  case 195: /* capture_decl_c_ast: Y_AMPER Y_NAME  */
#line 3265 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      c_sname_append_name( &(yyval.ast)->sname, (yyvsp[0].name) );
      (yyval.ast)->capture.kind = C_CAPTURE_REFERENCE;
    }
#line 6675 "parser.c"
    break;

  case 196: /* capture_decl_c_ast: '='  */
#line 3271 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_COPY;
    }
#line 6684 "parser.c"
    break;

  case 197: /* capture_decl_c_ast: Y_NAME  */
#line 3276 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      c_sname_append_name( &(yyval.ast)->sname, (yyvsp[0].name) );
    }
#line 6693 "parser.c"
    break;

  case 198: /* capture_decl_c_ast: Y_this  */
#line 3281 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_THIS;
    }
#line 6702 "parser.c"
    break;

  case 199: /* capture_decl_c_ast: '*' this_exp  */
#line 3286 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_STAR_THIS;
    }
#line 6711 "parser.c"
    break;

  case 200: /* lambda_param_c_ast_list_opt: %empty  */
#line 3293 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 6717 "parser.c"
    break;

  case 201: /* lambda_param_c_ast_list_opt: '(' param_c_ast_list_opt ')'  */
#line 3294 "parser.y"
                                  { (yyval.ast_list) = (yyvsp[-1].ast_list); }
#line 6723 "parser.c"
    break;

  case 202: /* lambda_return_type_c_ast_opt: %empty  */
#line 3298 "parser.y"
                                  { (yyval.ast) = NULL; }
#line 6729 "parser.c"
    break;

  case 203: /* $@13: %empty  */
#line 3299 "parser.y"
                                 { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 6735 "parser.c"
    break;

  case 204: /* lambda_return_type_c_ast_opt: Y_ARROW type_c_ast $@13 cast_c_astp_opt  */
#line 3301 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "lambda_return_type_c_ast_opt",
                  "type_c_ast cast_c_astp_opt" );
      DUMP_AST( "type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      (yyval.ast) = IF_ELSE( (yyvsp[0].ast_pair).ast, (yyvsp[-2].ast) );

      DUMP_AST( "lambda_return_type_c_ast_opt", (yyval.ast) );
      DUMP_END();
    }
#line 6753 "parser.c"
    break;

  case 205: /* template_declaration_c: Y_template  */
#line 3320 "parser.y"
    {
      print_error( &(yylsp[0]),
        "template declarations not supported by %s\n", CDECL
      );
      PARSE_ABORT();
    }
#line 6764 "parser.c"
    break;

  case 206: /* $@14: %empty  */
#line 3331 "parser.y"
                         { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 6770 "parser.c"
    break;

  case 207: /* typed_declaration_c: type_c_ast $@14 decl_list_c_opt  */
#line 3332 "parser.y"
    {
      ia_type_ast_pop();
    }
#line 6778 "parser.c"
    break;

  case 208: /* $@15: %empty  */
#line 3341 "parser.y"
    {
      PARSE_ASSERT( is_nested_type_ok( &(yylsp[-1]) ) );
      in_attr.is_typename = (yyvsp[0].flag);
      gibberish_to_english();           // see the comment in "explain"
    }
#line 6788 "parser.c"
    break;

  case 209: /* $@16: %empty  */
#line 3347 "parser.y"
    {
      PARSE_ASSERT( !in_attr.is_typename || c_ast_is_typename_ok( (yyvsp[0].ast) ) );
      // see the comment in "define_command" about TS_TYPEDEF
      PARSE_ASSERT(
        c_type_add_tid( &(yyvsp[0].ast)->type, TS_TYPEDEF, &(yylsp[0]) )
      );

      //
      // We have to keep a pristine copy of the AST for the base type of the
      // typedef being declared in case multiple types are defined in the same
      // typedef.  For example, given:
      //
      //      typedef int I, *PI;
      //              ^
      // the "int" is the base type that needs to get patched twice to form two
      // types: I and PI.  Hence, we keep a pristine copy and then duplicate it
      // so every type gets a pristine copy.
      //
      assert( slist_empty( &in_attr.typedef_ast_list ) );
      slist_push_list_back( &in_attr.typedef_ast_list, &gc_ast_list );
      in_attr.typedef_ast = (yyvsp[0].ast);
      ia_type_ast_push( c_ast_dup( in_attr.typedef_ast, &gc_ast_list ) );
    }
#line 6816 "parser.c"
    break;

  case 210: /* typedef_declaration_c: Y_typedef typename_flag_opt $@15 type_c_ast $@16 typedef_decl_list_c  */
#line 3371 "parser.y"
    {
      ia_type_ast_pop();
    }
#line 6824 "parser.c"
    break;

  case 211: /* $@17: %empty  */
#line 3378 "parser.y"
    { //
      // We're defining another type in the same typedef so we need to replace
      // the current type AST inherited attribute with a new duplicate of the
      // pristine one we kept earlier.
      //
      ia_type_ast_pop();
      ia_type_ast_push( c_ast_dup( in_attr.typedef_ast, &gc_ast_list ) );
    }
#line 6837 "parser.c"
    break;

  case 214: /* typedef_decl_c: decl_c_astp  */
#line 3394 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "typedef_decl_c", "decl_c_astp" );
      DUMP_SNAME( "in_attr__current_scope", in_attr.current_scope );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[0].ast_pair) );

      c_ast_t *const decl_ast = (yyvsp[0].ast_pair).ast;
      c_ast_t *typedef_ast;
      c_sname_t temp_sname;

      if ( decl_ast->kind == K_TYPEDEF ) {
        //
        // This is for either of the following cases:
        //
        //      typedef int int32_t;
        //      typedef int32_t int_least32_t;
        //
        // that is: any type name followed by an existing typedef name.
        //
        typedef_ast = type_ast;
        if ( c_sname_empty( &typedef_ast->sname ) )
          typedef_ast->sname = c_sname_dup( &decl_ast->tdef.for_ast->sname );
      }
      else {
        //
        // This is for either of the following cases:
        //
        //      typedef int foo;
        //      typedef int32_t foo;
        //
        // that is: any type name followed by a new name.
        //
        typedef_ast = c_ast_patch_placeholder( type_ast, decl_ast );
        temp_sname = c_ast_move_sname( decl_ast );
        c_sname_set( &typedef_ast->sname, &temp_sname );
      }

      PARSE_ASSERT( c_ast_check( typedef_ast ) );
      // see the comment in "define_command" about TS_TYPEDEF
      PJL_IGNORE_RV( c_ast_take_type_any( typedef_ast, &T_TS_TYPEDEF ) );

      if ( c_sname_count( &typedef_ast->sname ) > 1 ) {
        print_error( &(yylsp[0]),
          "typedef names can not be scoped; "
          "use: namespace %s { typedef ... }\n",
          c_sname_scope_name( &typedef_ast->sname )
        );
        PARSE_ABORT();
      }

      temp_sname = c_sname_dup( &in_attr.current_scope );
      c_sname_prepend_sname( &typedef_ast->sname, &temp_sname );

      DUMP_AST( "typedef_decl_c", typedef_ast );
      DUMP_END();

      PARSE_ASSERT( add_type( typedef_ast, C_GIB_TYPEDEF  ) );
    }
#line 6902 "parser.c"
    break;

  case 216: /* typedef_decl_c_exp: error  */
#line 3459 "parser.y"
    {
      elaborate_error( "type expected" );
    }
#line 6910 "parser.c"
    break;

  case 217: /* user_defined_conversion_declaration_c: user_defined_conversion_decl_c_astp  */
#line 3468 "parser.y"
    {
      DUMP_START( "user_defined_conversion_declaration_c",
                  "user_defined_conversion_decl_c_astp" );
      DUMP_AST_PAIR( "user_defined_conversion_declaration_c", (yyvsp[0].ast_pair) );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( (yyvsp[0].ast_pair).ast ) );
      c_ast_english( (yyvsp[0].ast_pair).ast, stdout );
    }
#line 6924 "parser.c"
    break;

  case 218: /* using_declaration_c: using_decl_c_ast  */
#line 3483 "parser.y"
    {
      // see the comment in "define_command" about TS_TYPEDEF
      PJL_IGNORE_RV( c_ast_take_type_any( (yyvsp[0].ast), &T_TS_TYPEDEF ) );

      PARSE_ASSERT( add_type( (yyvsp[0].ast), C_GIB_USING ) );
    }
#line 6935 "parser.c"
    break;

  case 219: /* $@18: %empty  */
#line 3493 "parser.y"
    { //
      // Using declarations are supported only in C++11 and later.  (However,
      // we always allow them in configuration files.)
      //
      // This check has to be done now in the parser rather than later in the
      // AST because using declarations are treated like typedef declarations
      // and the AST has no "memory" that such a declaration was a using
      // declaration.
      //
      if ( UNSUPPORTED( using_DECLS ) ) {
        print_error( &(yylsp[0]),
          "\"using\" not supported%s\n",
          C_LANG_WHICH( using_DECLS )
        );
        PARSE_ABORT();
      }

      gibberish_to_english();           // see the comment in "explain"
    }
#line 6959 "parser.c"
    break;

  case 220: /* $@19: %empty  */
#line 3514 "parser.y"
    {
      // see the comment in "define_command" about TS_TYPEDEF
      if ( !c_type_add_tid( &(yyvsp[0].ast)->type, TS_TYPEDEF, &(yylsp[0]) ) ) {
        free( (yyvsp[-3].name) );
        PARSE_ABORT();
      }
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 6972 "parser.c"
    break;

  case 221: /* using_decl_c_ast: Y_using $@18 any_name_exp attribute_specifier_list_c_atid_opt equals_exp type_c_ast $@19 cast_c_astp_opt  */
#line 3523 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "using_decl_c_ast",
                  "USING any_name_exp attribute_specifier_list_c_atid_opt '=' "
                  "type_c_ast cast_c_astp_opt" );
      DUMP_SNAME( "in_attr__current_scope", in_attr.current_scope );
      DUMP_STR( "any_name_exp", (yyvsp[-5].name) );
      DUMP_TID( "attribute_specifier_list_c_atid_opt", (yyvsp[-4].tid) );
      DUMP_AST( "type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      c_ast_t *const cast_ast = (yyvsp[0].ast_pair).ast;

      //
      // Ensure the type on the right-hand side doesn't have a name, e.g.:
      //
      //      using U = void (*F)();    // error
      //
      // This check has to be done now in the parser rather than later in the
      // AST because the patched AST loses the name.
      //
      c_sname_t const *const sname = c_ast_find_name( cast_ast, C_VISIT_DOWN );
      if ( sname != NULL ) {
        print_error( &cast_ast->loc, "\"using\" type can not have a name\n" );
        FREE( (yyvsp[-5].name) );
        PARSE_ABORT();
      }

      c_sname_t temp_sname = c_sname_dup( &in_attr.current_scope );
      c_sname_append_name( &temp_sname, (yyvsp[-5].name) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[-2].ast), cast_ast );
      c_sname_set( &(yyval.ast)->sname, &temp_sname );
      (yyval.ast)->type.atids = c_tid_check( (yyvsp[-4].tid), C_TPID_ATTR );

      DUMP_AST( "using_decl_c_ast", (yyval.ast) );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( (yyval.ast) ) );
    }
#line 7018 "parser.c"
    break;

  case 222: /* decl_list_c_opt: %empty  */
#line 3578 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "decl_list_c_opt", "<empty>" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "decl_list_c_opt", type_ast );

      if ( (type_ast->kind & K_ANY_ECSU) == 0 ) {
        //
        // The declaration is a non-ECSU type, e.g.:
        //
        //      int
        //
        c_loc_t const loc = lexer_loc();
        print_error( &loc, "declaration expected" );
        print_is_a_keyword( lexer_printable_token() );
        EPUTC( '\n' );
        PARSE_ABORT();
      }

      if ( in_attr.align.kind != C_ALIGNAS_NONE ) {
        print_error( &in_attr.align.loc, "%s invalid here\n", alignas_name() );
        PARSE_ABORT();
      }

      c_sname_t const *const ecsu_sname = &type_ast->csu.csu_sname;
      assert( !c_sname_empty( ecsu_sname ) );

      if ( c_sname_count( ecsu_sname ) > 1 ) {
        print_error( &type_ast->loc,
          "forward declaration can not have a scoped name\n"
        );
        PARSE_ABORT();
      }

      c_sname_t temp_sname = c_sname_dup( ecsu_sname );
      c_sname_set( &type_ast->sname, &temp_sname );

      DUMP_AST( "decl_list_c_opt", type_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( type_ast ) );
      c_typedef_english( &C_TYPEDEF_AST_LIT( type_ast ), stdout );
      PUTC( '\n' );
    }
#line 7068 "parser.c"
    break;

  case 223: /* decl_list_c_opt: decl_list_c  */
#line 3625 "parser.y"
    {
      PARSE_ASSERT( c_ast_list_check( &(yyvsp[0].ast_list) ) );
      c_ast_list_english( &(yyvsp[0].ast_list), stdout );
    }
#line 7077 "parser.c"
    break;

  case 224: /* decl_list_c: decl_list_c ',' decl_c_exp  */
#line 3633 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[-2].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );
    }
#line 7086 "parser.c"
    break;

  case 225: /* decl_list_c: decl_c  */
#line 3638 "parser.y"
    {
      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );
    }
#line 7095 "parser.c"
    break;

  case 226: /* decl_c: decl_c_astp  */
#line 3647 "parser.y"
    { //
      // The type has to be duplicated to guarantee a fresh type AST in case
      // we're doing multiple declarations, e.g.:
      //
      //    explain int *p, *q
      //
      c_ast_t *const type_ast = c_ast_dup( ia_type_ast_peek(), &gc_ast_list );

      DUMP_START( "decl_c", "decl_c_astp" );
      switch ( in_attr.align.kind ) {
        case C_ALIGNAS_NONE:
          break;
        case C_ALIGNAS_BYTES:
          DUMP_INT( "in_attr__alignas_bytes", in_attr.align.bytes );
          break;
        case C_ALIGNAS_TYPE:
          DUMP_AST( "in_attr__alignas_type_ast", in_attr.align.type_ast );
          break;
      } // switch
      DUMP_BOOL( "in_attr__typename_flag_opt", in_attr.is_typename );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[0].ast_pair) );

      (yyval.ast) = join_type_decl( type_ast, (yyvsp[0].ast_pair).ast );
      PARSE_ASSERT( (yyval.ast) != NULL );

      DUMP_AST( "decl_c", (yyval.ast) );
      DUMP_END();
    }
#line 7129 "parser.c"
    break;

  case 228: /* decl_c_exp: error  */
#line 3681 "parser.y"
    {
      elaborate_error( "declaration expected" );
    }
#line 7137 "parser.c"
    break;

  case 233: /* decl_c_astp: msc_calling_convention_atid msc_calling_convention_c_astp  */
#line 3692 "parser.y"
    {
      (yyval.ast_pair) = (yyvsp[0].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);
      (yyval.ast_pair).ast->type.atids |= (yyvsp[-1].tid);
    }
#line 7147 "parser.c"
    break;

  case 241: /* decl2_c_astp: sname_c_ast gnu_attribute_specifier_list_c_opt  */
#line 3711 "parser.y"
    {
      (yyval.ast_pair) = (c_ast_pair_t){ (yyvsp[-1].ast), NULL };
    }
#line 7155 "parser.c"
    break;

  case 242: /* decl2_c_astp: typedef_type_decl_c_ast  */
#line 3714 "parser.y"
                                  { (yyval.ast_pair) = (c_ast_pair_t){ (yyvsp[0].ast), NULL }; }
#line 7161 "parser.c"
    break;

  case 245: /* array_decl_c_astp: decl2_c_astp array_size_c_ast gnu_attribute_specifier_list_c_opt  */
#line 3725 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "array_decl_c_astp", "decl2_c_astp array_size_c_ast" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST_PAIR( "decl2_c_astp", (yyvsp[-2].ast_pair) );
      DUMP_AST( "array_size_c_ast", (yyvsp[-1].ast) );

      c_ast_set_parent(
        c_ast_new_gc( K_PLACEHOLDER, &(yylsp[-2]) ), (yyvsp[-1].ast)
      );

      if ( (yyvsp[-2].ast_pair).target_ast != NULL ) {
        // array-of or function-like-ret type
        (yyval.ast_pair) = (c_ast_pair_t){
          (yyvsp[-2].ast_pair).ast,
          c_ast_add_array( (yyvsp[-2].ast_pair).target_ast, (yyvsp[-1].ast), type_ast )
        };
      } else {
        (yyval.ast_pair) = (c_ast_pair_t){
          c_ast_add_array( (yyvsp[-2].ast_pair).ast, (yyvsp[-1].ast), type_ast ),
          NULL
        };
      }

      DUMP_AST_PAIR( "array_decl_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 7194 "parser.c"
    break;

  case 246: /* array_size_c_ast: '[' rbracket_exp  */
#line 3757 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_EMPTY_SIZE;
    }
#line 7203 "parser.c"
    break;

  case 247: /* array_size_c_ast: '[' Y_INT_LIT rbracket_exp  */
#line 3762 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_INT_SIZE;
      (yyval.ast)->array.size_int = (yyvsp[-1].int_val);
    }
#line 7213 "parser.c"
    break;

  case 248: /* array_size_c_ast: '[' Y_NAME rbracket_exp  */
#line 3768 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_NAMED_SIZE;
      (yyval.ast)->array.size_name = (yyvsp[-1].name);
    }
#line 7223 "parser.c"
    break;

  case 249: /* array_size_c_ast: '[' type_qualifier_list_c_stid rbracket_exp  */
#line 3774 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[-1].tid), C_TPID_STORE );
      (yyval.ast)->array.kind = C_ARRAY_EMPTY_SIZE;
    }
#line 7233 "parser.c"
    break;

  case 250: /* array_size_c_ast: '[' type_qualifier_list_c_stid static_stid_opt Y_INT_LIT rbracket_exp  */
#line 3781 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[-3].tid) | (yyvsp[-2].tid), C_TPID_STORE );
      (yyval.ast)->array.kind = C_ARRAY_INT_SIZE;
      (yyval.ast)->array.size_int = (yyvsp[-1].int_val);
    }
#line 7244 "parser.c"
    break;

  case 251: /* array_size_c_ast: '[' type_qualifier_list_c_stid static_stid_opt Y_NAME rbracket_exp  */
#line 3789 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[-3].tid) | (yyvsp[-2].tid), C_TPID_STORE );
      (yyval.ast)->array.kind = C_ARRAY_NAMED_SIZE;
      (yyval.ast)->array.size_name = (yyvsp[-1].name);
    }
#line 7255 "parser.c"
    break;

  case 252: /* array_size_c_ast: '[' type_qualifier_list_c_stid_opt '*' rbracket_exp  */
#line 3796 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[-2].tid), C_TPID_STORE );
      (yyval.ast)->array.kind = C_ARRAY_VLA_STAR;
    }
#line 7265 "parser.c"
    break;

  case 253: /* array_size_c_ast: '[' Y_static type_qualifier_list_c_stid_opt Y_INT_LIT rbracket_exp  */
#line 3803 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->type.stids =
        c_tid_check( TS_NON_EMPTY_ARRAY | (yyvsp[-2].tid), C_TPID_STORE );
      (yyval.ast)->array.kind = C_ARRAY_INT_SIZE;
      (yyval.ast)->array.size_int = (yyvsp[-1].int_val);
    }
#line 7277 "parser.c"
    break;

  case 254: /* array_size_c_ast: '[' Y_static type_qualifier_list_c_stid_opt Y_NAME rbracket_exp  */
#line 3812 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->type.stids =
        c_tid_check( TS_NON_EMPTY_ARRAY | (yyvsp[-2].tid), C_TPID_STORE );
      (yyval.ast)->array.kind = C_ARRAY_NAMED_SIZE;
      (yyval.ast)->array.size_name = (yyvsp[-1].name);
    }
#line 7289 "parser.c"
    break;

  case 255: /* array_size_c_ast: '[' error ']'  */
#line 3820 "parser.y"
    {
      elaborate_error( "array size expected" );
    }
#line 7297 "parser.c"
    break;

  case 256: /* $@20: %empty  */
#line 3830 "parser.y"
    { //
      // A block AST has to be the type inherited attribute for decl_c_astp so
      // we have to create it here.
      //
      ia_type_ast_push( c_ast_new_gc( K_APPLE_BLOCK, &(yyloc) ) );
    }
#line 7308 "parser.c"
    break;

  case 257: /* block_decl_c_astp: '(' Y_CARET $@20 type_qualifier_list_c_stid_opt decl_c_astp rparen_exp lparen_exp param_c_ast_list_opt ')' gnu_attribute_specifier_list_c_opt  */
#line 3839 "parser.y"
    {
      c_ast_t *const  block_ast = ia_type_ast_pop();
      c_ast_t *const  type_ast = ia_type_ast_peek();

      DUMP_START( "block_decl_c_astp",
                  "'(' '^' type_qualifier_list_c_stid_opt decl_c_astp ')' "
                  "'(' param_c_ast_list_opt ')'" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[-6].tid) );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[-5].ast_pair) );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-2].ast_list) );

      PARSE_ASSERT(
        c_type_add_tid( &block_ast->type, (yyvsp[-6].tid), &(yylsp[-6]) )
      );
      block_ast->block.param_ast_list = slist_move( &(yyvsp[-2].ast_list) );
      (yyval.ast_pair) = (c_ast_pair_t){
        c_ast_add_func( (yyvsp[-5].ast_pair).ast, block_ast, type_ast ),
        block_ast->block.ret_ast
      };

      DUMP_AST_PAIR( "block_decl_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 7337 "parser.c"
    break;

  case 258: /* destructor_declaration_c: virtual_stid_opt Y_TILDE any_name_exp lparen_exp rparen_func_qualifier_list_c_stid_opt noexcept_c_stid_opt gnu_attribute_specifier_list_c_opt func_equals_c_stid_opt  */
#line 3875 "parser.y"
    {
      DUMP_START( "destructor_declaration_c",
                  "virtual_opt '~' NAME '(' ')' func_qualifier_list_c_stid_opt "
                  "noexcept_c_stid_opt gnu_attribute_specifier_list_c_opt "
                  "func_equals_c_stid_opt" );
      DUMP_TID( "virtual_stid_opt", (yyvsp[-7].tid) );
      DUMP_STR( "any_name_exp", (yyvsp[-5].name) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-3].tid) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_TID( "func_equals_c_stid_opt", (yyvsp[0].tid) );

      c_ast_t *const dtor_ast = c_ast_new_gc( K_DESTRUCTOR, &(yyloc) );
      c_sname_append_name( &dtor_ast->sname, (yyvsp[-5].name) );
      dtor_ast->type.stids = c_tid_check(
        (yyvsp[-7].tid) | (yyvsp[-3].tid) | (yyvsp[-2].tid) | (yyvsp[0].tid),
        C_TPID_STORE
      );

      DUMP_AST( "destructor_declaration_c", dtor_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( dtor_ast ) );
      c_ast_english( dtor_ast, stdout );
    }
#line 7366 "parser.c"
    break;

  case 259: /* file_scope_constructor_declaration_c: inline_stid_opt Y_CONSTRUCTOR_SNAME lparen_exp param_c_ast_list_opt rparen_func_qualifier_list_c_stid_opt noexcept_c_stid_opt gnu_attribute_specifier_list_c_opt  */
#line 3908 "parser.y"
    {
      DUMP_START( "file_scope_constructor_declaration_c",
                  "inline_opt CONSTRUCTOR_SNAME '(' param_c_ast_list_opt ')' "
                  "func_qualifier_list_c_stid_opt noexcept_c_stid_opt" );
      DUMP_TID( "inline_stid_opt", (yyvsp[-6].tid) );
      DUMP_SNAME( "CONSTRUCTOR_SNAME", (yyvsp[-5].sname) );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-3].ast_list) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-1].tid) );

      c_sname_set_scope_type( &(yyvsp[-5].sname), &C_TYPE_LIT_B( TB_CLASS ) );

      c_ast_t *const ctor_ast = c_ast_new_gc( K_CONSTRUCTOR, &(yyloc) );
      ctor_ast->sname = c_sname_move( &(yyvsp[-5].sname) );
      ctor_ast->type.stids = c_tid_check(
        (yyvsp[-6].tid) | (yyvsp[-2].tid) | (yyvsp[-1].tid),
        C_TPID_STORE
      );
      ctor_ast->ctor.param_ast_list = slist_move( &(yyvsp[-3].ast_list) );

      DUMP_AST( "file_scope_constructor_declaration_c", ctor_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( ctor_ast ) );
      c_ast_english( ctor_ast, stdout );
    }
#line 7397 "parser.c"
    break;

  case 260: /* file_scope_destructor_declaration_c: inline_stid_opt destructor_sname lparen_exp rparen_func_qualifier_list_c_stid_opt noexcept_c_stid_opt gnu_attribute_specifier_list_c_opt  */
#line 3942 "parser.y"
    {
      DUMP_START( "file_scope_destructor_declaration_c",
                  "inline_opt DESTRUCTOR_SNAME '(' ')' "
                  "func_qualifier_list_c_stid_opt noexcept_c_stid_opt" );
      DUMP_TID( "inline_stid_opt", (yyvsp[-5].tid) );
      DUMP_SNAME( "DESTRUCTOR_SNAME", (yyvsp[-4].sname) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-1].tid) );

      c_sname_set_scope_type( &(yyvsp[-4].sname), &C_TYPE_LIT_B( TB_CLASS ) );

      c_ast_t *const dtor_ast = c_ast_new_gc( K_DESTRUCTOR, &(yyloc) );
      dtor_ast->sname = c_sname_move( &(yyvsp[-4].sname) );
      dtor_ast->type.stids = c_tid_check(
        (yyvsp[-5].tid) | (yyvsp[-2].tid) | (yyvsp[-1].tid),
        C_TPID_STORE
      );

      DUMP_AST( "file_scope_destructor_declaration_c", dtor_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( dtor_ast ) );
      c_ast_english( dtor_ast, stdout );
    }
#line 7426 "parser.c"
    break;

  case 261: /* func_decl_c_astp: decl2_c_astp '(' param_c_ast_list_opt rparen_func_qualifier_list_c_stid_opt func_ref_qualifier_c_stid_opt noexcept_c_stid_opt trailing_return_type_c_ast_opt func_equals_c_stid_opt  */
#line 3985 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "func_decl_c_astp",
                  "decl2_c_astp '(' param_c_ast_list_opt ')' "
                  "func_qualifier_list_c_stid_opt "
                  "func_ref_qualifier_c_stid_opt noexcept_c_stid_opt "
                  "trailing_return_type_c_ast_opt "
                  "func_equals_c_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST_PAIR( "decl2_c_astp", (yyvsp[-7].ast_pair) );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-5].ast_list) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-4].tid) );
      DUMP_TID( "func_ref_qualifier_c_stid_opt", (yyvsp[-3].tid) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_AST( "trailing_return_type_c_ast_opt", (yyvsp[-1].ast) );
      DUMP_TID( "func_equals_c_stid_opt", (yyvsp[0].tid) );

      c_tid_t const func_stids =
        (yyvsp[-4].tid) | (yyvsp[-3].tid) | (yyvsp[-2].tid) | (yyvsp[0].tid);

      //
      // Cdecl can't know for certain whether a "function" name is really a
      // constructor name because it:
      //
      //  1. Doesn't have the context of the surrounding class:
      //
      //          class T {
      //          public:
      //            T();                // <-- All cdecl usually has is this.
      //            // ...
      //          };
      //
      //  2. Can't check to see if the name is a typedef for a class, struct,
      //     or union (even though that would greatly help) since:
      //
      //          T(U);
      //
      //     could be either:
      //
      //      + A constructor of type T with a parameter of type U; or:
      //      + A variable named U of type T (with unnecessary parentheses).
      //
      // Hence, we have to infer which of a function or a constructor was
      // likely the one meant.  Assume the declaration is for a constructor
      // only if:
      //
      bool const assume_constructor =

        // + The current language is C++.
        OPT_LANG_IS( CONSTRUCTORS ) &&

        // + The existing base type is none (because constructors don't have
        //   return types).
        type_ast->type.btids == TB_NONE &&

        // + The existing type does _not_ have any non-constructor storage
        //   classes.
        !c_tid_is_any( type_ast->type.stids, TS_FUNC_LIKE_NOT_CTOR ) &&

        ( // + The existing type has any constructor-only storage-class-like
          //   types (e.g., explicit).
          c_tid_is_any( type_ast->type.stids, TS_CONSTRUCTOR_ONLY ) ||

          // + Or the existing type only has storage-class-like types that may
          //   be applied to constructors.
          is_1n_bit_only_in_set(
            c_tid_no_tpid( type_ast->type.stids ),
            c_tid_no_tpid( TS_CONSTRUCTOR_DECL )
          )
        ) &&

        // + The new type does _not_ have any non-constructor storage classes.
        !c_tid_is_any( func_stids, TS_FUNC_LIKE_NOT_CTOR );

      c_ast_t *const func_ast =
        c_ast_new_gc( assume_constructor ? K_CONSTRUCTOR : K_FUNCTION, &(yyloc) );
      func_ast->type.stids = c_tid_check( func_stids, C_TPID_STORE );
      func_ast->func.param_ast_list = slist_move( &(yyvsp[-5].ast_list) );

      if ( assume_constructor ) {
        assert( (yyvsp[-1].ast) == NULL );
        (yyval.ast_pair).ast = c_ast_add_func( (yyvsp[-7].ast_pair).ast, func_ast, /*ret_ast=*/NULL );
      }
      else if ( (yyvsp[-7].ast_pair).target_ast != NULL ) {
        (yyval.ast_pair).ast = (yyvsp[-7].ast_pair).ast;
        PJL_IGNORE_RV(
          c_ast_add_func( (yyvsp[-7].ast_pair).target_ast, func_ast, type_ast )
        );
      }
      else {
        (yyval.ast_pair).ast = c_ast_add_func(
          (yyvsp[-7].ast_pair).ast,
          func_ast,
          IF_ELSE( (yyvsp[-1].ast), type_ast )
        );
      }

      (yyval.ast_pair).target_ast = func_ast->func.ret_ast;

      c_tid_t const msc_call_atids = (yyval.ast_pair).ast->type.atids & TA_ANY_MSC_CALL;
      if ( msc_call_atids != TA_NONE ) {
        //
        // Microsoft calling conventions need to be moved from the pointer to
        // the function, e.g., change:
        //
        //      declare f as cdecl pointer to function returning void
        //
        // to:
        //
        //      declare f as pointer to cdecl function returning void
        //
        for ( c_ast_t const *ast = (yyval.ast_pair).ast;
              (ast = c_ast_unpointer( ast )) != NULL; ) {
          if ( ast->kind == K_FUNCTION ) {
            (yyval.ast_pair).ast->type.atids &= c_tid_compl( TA_ANY_MSC_CALL );
            CONST_CAST( c_ast_t*, ast )->type.atids |= msc_call_atids;
          }
        } // for
      }

      DUMP_AST_PAIR( "func_decl_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 7555 "parser.c"
    break;

  case 262: /* $@21: %empty  */
#line 4120 "parser.y"
    {
      if ( OPT_LANG_IS( CONSTRUCTORS ) ) {
        //
        // In C++, encountering a name followed by '(' declares an in-class
        // constructor.  That means NAME is the name of a class, so we have to
        // create a temporary class type for it so if it's used as the type of
        // a parameter, e.g.:
        //
        //      C(C const&)
        //
        // it'll be recognized as such.
        //
        c_ast_t *const csu_ast = c_ast_new_gc( K_CLASS_STRUCT_UNION, &(yylsp[-1]) );
        csu_ast->type.btids = TB_CLASS;
        c_sname_init_name( &csu_ast->csu.csu_sname, check_strdup( (yyvsp[-1].name) ) );
        csu_ast->sname = c_sname_dup( &csu_ast->csu.csu_sname );

        in_attr.typedef_rb = c_typedef_add( csu_ast, C_GIB_TYPEDEF );
        MAYBE_UNUSED c_typedef_t *const csu_tdef = in_attr.typedef_rb->data;
        assert( csu_tdef->ast == csu_ast );
      }
    }
#line 7582 "parser.c"
    break;

  case 263: /* pc99_func_or_constructor_declaration_c: Y_NAME '(' $@21 param_c_ast_list_opt ')' noexcept_c_stid_opt func_equals_c_stid_opt  */
#line 4144 "parser.y"
    {
      DUMP_START( "pc99_func_or_constructor_declaration_c",
                  "NAME '(' param_c_ast_list_opt ')' noexcept_c_stid_opt "
                  "func_equals_c_stid_opt" );
      DUMP_STR( "NAME", (yyvsp[-6].name) );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-3].ast_list) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-1].tid) );
      DUMP_TID( "func_equals_c_stid_opt", (yyvsp[0].tid) );

      c_ast_t *ast;

      if ( OPT_LANG_IS( CONSTRUCTORS ) ) {
        //
        // Free the temporary typedef for the class.
        //
        // Note that we free only the typedef and not its AST; its AST will be
        // garbage collected.
        //
        free( c_typedef_remove( in_attr.typedef_rb ) );

        //
        // In C++, encountering a name followed by '(' declares an in-class
        // constructor.
        //
        ast = c_ast_new_gc( K_CONSTRUCTOR, &(yyloc) );
      }
      else {
        if ( UNSUPPORTED( IMPLICIT_int ) ) {
          //
          // In C99 and later, implicit int is an error.  This check has to be
          // done now in the parser rather than later in the AST since the AST
          // would have no "memory" that the return type was implicitly int.
          //
          print_error( &(yylsp[-6]),
            "implicit \"int\" functions are illegal%s\n",
            C_LANG_WHICH( IMPLICIT_int )
          );
          FREE( (yyvsp[-6].name) );
          PARSE_ABORT();
        }

        //
        // In C prior to C99, encountering a name followed by '(' declares a
        // function that implicitly returns int:
        //
        //      power(x, n)             /* raise x to n-th power; n > 0 */
        //
        c_ast_t *const ret_ast = c_ast_new_gc( K_BUILTIN, &(yylsp[-6]) );
        ret_ast->type.btids = TB_INT;

        ast = c_ast_new_gc( K_FUNCTION, &(yyloc) );
        ast->func.ret_ast = ret_ast;
      }

      c_sname_init_name( &ast->sname, (yyvsp[-6].name) );
      ast->type.stids =
        c_tid_check( (yyvsp[-1].tid) | (yyvsp[0].tid), C_TPID_STORE );
      ast->func.param_ast_list = slist_move( &(yyvsp[-3].ast_list) );

      DUMP_AST( "pc99_func_or_constructor_declaration_c", ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( ast ) );
      c_ast_english( ast, stdout );
    }
#line 7652 "parser.c"
    break;

  case 264: /* $@22: %empty  */
#line 4213 "parser.y"
    {
      if ( OPT_LANG_IS( CPP_ANY ) ) {
        //
        // Both "final" and "override" are matched only within member function
        // declarations.  Now that ')' has been parsed, we're within one, so
        // set the keyword context to C_KW_CTX_MBR_FUNC.
        //
        lexer_keyword_ctx = C_KW_CTX_MBR_FUNC;
      }
    }
#line 7667 "parser.c"
    break;

  case 265: /* rparen_func_qualifier_list_c_stid_opt: ')' $@22 func_qualifier_list_c_stid_opt  */
#line 4224 "parser.y"
    {
      lexer_keyword_ctx = C_KW_CTX_DEFAULT;
      (yyval.tid) = (yyvsp[0].tid);
    }
#line 7676 "parser.c"
    break;

  case 266: /* func_qualifier_list_c_stid_opt: %empty  */
#line 4231 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 7682 "parser.c"
    break;

  case 267: /* func_qualifier_list_c_stid_opt: func_qualifier_list_c_stid_opt func_qualifier_c_stid  */
#line 4233 "parser.y"
    {
      DUMP_START( "func_qualifier_list_c_stid_opt",
                  "func_qualifier_list_c_stid_opt func_qualifier_c_stid" );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-1].tid) );
      DUMP_TID( "func_qualifier_c_stid", (yyvsp[0].tid) );

      (yyval.tid) = (yyvsp[-1].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyval.tid) );
      DUMP_END();
    }
#line 7699 "parser.c"
    break;

  case 272: /* func_ref_qualifier_c_stid_opt: %empty  */
#line 4262 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 7705 "parser.c"
    break;

  case 273: /* func_ref_qualifier_c_stid_opt: Y_AMPER  */
#line 4263 "parser.y"
                                  { (yyval.tid) = TS_REFERENCE; }
#line 7711 "parser.c"
    break;

  case 274: /* func_ref_qualifier_c_stid_opt: Y_AMPER2  */
#line 4264 "parser.y"
                                  { (yyval.tid) = TS_RVALUE_REFERENCE; }
#line 7717 "parser.c"
    break;

  case 275: /* noexcept_c_stid_opt: %empty  */
#line 4268 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 7723 "parser.c"
    break;

  case 277: /* noexcept_c_stid_opt: Y_noexcept '(' noexcept_bool_stid_exp rparen_exp  */
#line 4271 "parser.y"
    {
      (yyval.tid) = (yyvsp[-1].tid);
    }
#line 7731 "parser.c"
    break;

  case 278: /* noexcept_c_stid_opt: Y_throw lparen_exp rparen_exp  */
#line 4275 "parser.y"
    {
      (yyval.tid) = (yyvsp[-2].tid);
    }
#line 7739 "parser.c"
    break;

  case 279: /* noexcept_c_stid_opt: Y_throw lparen_exp param_c_ast_list ')'  */
#line 4279 "parser.y"
    {
      c_ast_list_cleanup( &(yyvsp[-1].ast_list) );

      if ( OPT_LANG_IS( throw ) ) {
        print_error( &(yylsp[-1]),
          "dynamic exception specifications not supported by %s\n", CDECL
        );
      } else {
        print_error( &(yylsp[-1]),
          "dynamic exception specifications not supported%s\n",
          C_LANG_WHICH( throw )
        );
      }
      PARSE_ABORT();
    }
#line 7759 "parser.c"
    break;

  case 282: /* noexcept_bool_stid_exp: error  */
#line 4300 "parser.y"
    {
      elaborate_error( "\"true\" or \"false\" expected" );
    }
#line 7767 "parser.c"
    break;

  case 283: /* trailing_return_type_c_ast_opt: %empty  */
#line 4306 "parser.y"
                                  { (yyval.ast) = NULL; }
#line 7773 "parser.c"
    break;

  case 284: /* $@23: %empty  */
#line 4308 "parser.y"
                                 { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 7779 "parser.c"
    break;

  case 285: /* trailing_return_type_c_ast_opt: Y_ARROW type_c_ast $@23 cast_c_astp_opt  */
#line 4310 "parser.y"
    { //
      // The function trailing return-type syntax is supported only in C++11
      // and later.  This check has to be done now in the parser rather than
      // later in the AST because the AST has no "memory" of where the return-
      // type came from.
      //
      if ( UNSUPPORTED( TRAILING_RETURN_TYPES ) ) {
        print_error( &(yylsp[-3]),
          "trailing return type not supported%s\n",
          C_LANG_WHICH( TRAILING_RETURN_TYPES )
        );
        PARSE_ABORT();
      }

      ia_type_ast_pop();
      c_ast_t const *const ret_ast = ia_type_ast_peek();

      DUMP_START( "trailing_return_type_c_ast_opt",
                  "type_c_ast cast_c_astp_opt" );
      DUMP_AST( "in_attr__type_c_ast", ret_ast );
      DUMP_AST( "type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      (yyval.ast) = IF_ELSE( (yyvsp[0].ast_pair).ast, (yyvsp[-2].ast) );

      DUMP_AST( "trailing_return_type_c_ast_opt", (yyval.ast) );
      DUMP_END();

      //
      // Ensure that a function using the C++11 trailing return type syntax
      // starts with "auto":
      //
      //      void f() -> int
      //      ^
      //      error: must be "auto"
      //
      // This check has to be done now in the parser rather than later in the
      // AST because the "auto" is just a syntactic return-type placeholder in
      // C++11 and the AST node for the placeholder is discarded and never made
      // part of the AST.
      //
      if ( ret_ast->type.btids != TB_AUTO ) {
        print_error( &ret_ast->loc,
          "function with trailing return type must only specify \"auto\"\n"
        );
        PARSE_ABORT();
      }
    }
#line 7832 "parser.c"
    break;

  case 286: /* trailing_return_type_c_ast_opt: gnu_attribute_specifier_list_c  */
#line 4360 "parser.y"
    {
      (yyval.ast) = NULL;
    }
#line 7840 "parser.c"
    break;

  case 287: /* func_equals_c_stid_opt: %empty  */
#line 4366 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 7846 "parser.c"
    break;

  case 288: /* func_equals_c_stid_opt: '=' Y_default  */
#line 4367 "parser.y"
                                  { (yyval.tid) = (yyvsp[0].tid); }
#line 7852 "parser.c"
    break;

  case 289: /* func_equals_c_stid_opt: '=' Y_delete  */
#line 4368 "parser.y"
                                  { (yyval.tid) = (yyvsp[0].tid); }
#line 7858 "parser.c"
    break;

  case 290: /* func_equals_c_stid_opt: '=' Y_INT_LIT  */
#line 4370 "parser.y"
    {
      if ( (yyvsp[0].int_val) != 0 ) {
        print_error( &(yylsp[0]), "'0' expected\n" );
        PARSE_ABORT();
      }
      (yyval.tid) = TS_PURE_VIRTUAL;
    }
#line 7870 "parser.c"
    break;

  case 291: /* func_equals_c_stid_opt: '=' error  */
#line 4378 "parser.y"
    {
      if ( OPT_LANG_IS( default_delete_FUNCS ) )
        elaborate_error( "'0', \"default\", or \"delete\" expected" );
      else
        elaborate_error( "'0' expected" );
    }
#line 7881 "parser.c"
    break;

  case 293: /* param_c_ast_list_exp: error  */
#line 4391 "parser.y"
    {
      slist_init( &(yyval.ast_list) );
      elaborate_error( "parameter list expected" );
    }
#line 7890 "parser.c"
    break;

  case 294: /* param_c_ast_list_opt: %empty  */
#line 4398 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 7896 "parser.c"
    break;

  case 296: /* param_c_ast_list: param_c_ast_list comma_exp param_c_ast_exp  */
#line 4404 "parser.y"
    {
      DUMP_START( "param_c_ast_list", "param_c_ast_list ',' param_c_ast" );
      DUMP_AST_LIST( "param_c_ast_list", (yyvsp[-2].ast_list) );
      DUMP_AST( "param_c_ast", (yyvsp[0].ast) );

      (yyval.ast_list) = (yyvsp[-2].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "param_c_ast_list", (yyval.ast_list) );
      DUMP_END();
    }
#line 7912 "parser.c"
    break;

  case 297: /* param_c_ast_list: param_c_ast  */
#line 4417 "parser.y"
    {
      DUMP_START( "param_c_ast_list", "param_c_ast" );
      DUMP_AST( "param_c_ast", (yyvsp[0].ast) );

      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "param_c_ast_list", (yyval.ast_list) );
      DUMP_END();
    }
#line 7927 "parser.c"
    break;

  case 298: /* $@24: %empty  */
#line 4434 "parser.y"
    {
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 7935 "parser.c"
    break;

  case 299: /* param_c_ast: this_stid_opt type_c_ast $@24 cast_c_astp_opt  */
#line 4438 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "param_c_ast", "this_stid_opt type_c_ast cast_c_astp_opt" );
      DUMP_TID( "this_stid_opt", (yyvsp[-3].tid) );
      DUMP_AST( "type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast_pair).ast );

      if ( (yyval.ast)->kind == K_FUNCTION ) {
        //
        // From the C11 standard, section 6.3.2.1(4):
        //
        //    [A] function designator with type "function returning type" is
        //    converted to an expression that has type "pointer to function
        //    returning type."
        //
        (yyval.ast) = c_ast_pointer( (yyval.ast), &gc_ast_list );
      }

      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[-3].tid), &(yylsp[-3]) ) );

      DUMP_AST( "param_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 7966 "parser.c"
    break;

  case 301: /* param_c_ast: "..."  */
#line 4474 "parser.y"
    {
      DUMP_START( "param_c_ast", "..." );

      (yyval.ast) = c_ast_new_gc( K_VARIADIC, &(yyloc) );

      DUMP_AST( "param_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 7979 "parser.c"
    break;

  case 303: /* param_c_ast_exp: error  */
#line 4487 "parser.y"
    {
      elaborate_error( "parameter declaration expected" );
    }
#line 7987 "parser.c"
    break;

  case 304: /* $@25: %empty  */
#line 4496 "parser.y"
    {
      ia_type_ast_push( c_ast_new_gc( K_PLACEHOLDER, &(yyloc) ) );
      ++in_attr.ast_depth;
    }
#line 7996 "parser.c"
    break;

  case 305: /* nested_decl_c_astp: '(' $@25 decl_c_astp rparen_exp  */
#line 4501 "parser.y"
    {
      ia_type_ast_pop();
      --in_attr.ast_depth;

      DUMP_START( "nested_decl_c_astp", "'(' decl_c_astp ')'" );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[-1].ast_pair) );

      (yyval.ast_pair) = (yyvsp[-1].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);

      DUMP_AST_PAIR( "nested_decl_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8014 "parser.c"
    break;

  case 306: /* oper_decl_c_astp: oper_sname_c_opt Y_operator c_operator lparen_exp param_c_ast_list_opt rparen_func_qualifier_list_c_stid_opt func_ref_qualifier_c_stid_opt noexcept_c_stid_opt trailing_return_type_c_ast_opt func_equals_c_stid_opt  */
#line 4527 "parser.y"
    {
      c_operator_t const *const operator = c_oper_get( (yyvsp[-7].oper_id) );
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "oper_decl_c_astp",
                  "oper_sname_c_opt OPERATOR c_operator "
                  "'(' param_c_ast_list_opt ')' "
                  "func_qualifier_list_c_stid_opt "
                  "func_ref_qualifier_c_stid_opt noexcept_c_stid_opt "
                  "trailing_return_type_c_ast_opt "
                  "func_equals_c_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "oper_sname_c_opt", (yyvsp[-9].sname) );
      DUMP_STR( "c_operator", operator->literal );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-5].ast_list) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-4].tid) );
      DUMP_TID( "func_ref_qualifier_c_stid_opt", (yyvsp[-3].tid) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_AST( "trailing_return_type_c_ast_opt", (yyvsp[-1].ast) );
      DUMP_TID( "func_equals_c_stid_opt", (yyvsp[0].tid) );

      c_tid_t const oper_stids =
        (yyvsp[-4].tid) | (yyvsp[-3].tid) | (yyvsp[-2].tid) | (yyvsp[0].tid);

      c_ast_t *const oper_ast = c_ast_new_gc( K_OPERATOR, &(yyloc) );
      oper_ast->sname = c_sname_move( &(yyvsp[-9].sname) );
      oper_ast->type.stids = c_tid_check( oper_stids, C_TPID_STORE );
      oper_ast->oper.param_ast_list = slist_move( &(yyvsp[-5].ast_list) );
      oper_ast->oper.operator = operator;

      c_ast_t *const ret_ast = IF_ELSE( (yyvsp[-1].ast), type_ast );

      (yyval.ast_pair) = (c_ast_pair_t){
        c_ast_add_func( type_ast, oper_ast, ret_ast ),
        oper_ast->oper.ret_ast
      };

      DUMP_AST_PAIR( "oper_decl_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8059 "parser.c"
    break;

  case 307: /* $@26: %empty  */
#line 4572 "parser.y"
                                 { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 8065 "parser.c"
    break;

  case 308: /* pointer_decl_c_astp: pointer_type_c_ast $@26 decl_c_astp  */
#line 4574 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_decl_c_astp", "pointer_type_c_ast decl_c_astp" );
      DUMP_AST( "pointer_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[0].ast_pair) );

      PJL_IGNORE_RV( c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast_pair).ast ) );
      (yyval.ast_pair) = (yyvsp[0].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);

      DUMP_AST_PAIR( "pointer_decl_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8084 "parser.c"
    break;

  case 309: /* pointer_type_c_ast: '*' type_qualifier_list_c_stid_opt  */
#line 4593 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "pointer_type_c_ast", "* type_qualifier_list_c_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_POINTER, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[0].tid), C_TPID_STORE );
      c_ast_set_parent( type_ast, (yyval.ast) );

      DUMP_AST( "pointer_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8103 "parser.c"
    break;

  case 310: /* pc99_pointer_decl_list_c: pc99_pointer_decl_c ',' decl_list_c  */
#line 4613 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[0].ast_list);
      slist_push_front( &(yyval.ast_list), (yyvsp[-2].ast) );
    }
#line 8112 "parser.c"
    break;

  case 311: /* pc99_pointer_decl_list_c: pc99_pointer_decl_c  */
#line 4618 "parser.y"
    {
      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );
    }
#line 8121 "parser.c"
    break;

  case 312: /* $@27: %empty  */
#line 4625 "parser.y"
                                      { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 8127 "parser.c"
    break;

  case 313: /* pc99_pointer_decl_c: pc99_pointer_type_c_ast $@27 decl_c_astp  */
#line 4627 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pc99_pointer_decl_c",
                  "pc99_pointer_type_c_ast decl_c_astp" );
      DUMP_AST( "pc99_pointer_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[0].ast_pair) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast_pair).ast );
      (yyval.ast)->loc = (yyloc);

      DUMP_AST( "pc99_pointer_decl_c", (yyval.ast) );
      DUMP_END();
    }
#line 8146 "parser.c"
    break;

  case 314: /* pc99_pointer_type_c_ast: '*' type_qualifier_list_c_stid_opt  */
#line 4645 "parser.y"
    {
      if ( OPT_LANG_IS( C_ANY ) && UNSUPPORTED( IMPLICIT_int ) ) {
        //
        // In C99 and later, implicit int is an error.  This check has to be
        // done now in the parser rather than later in the AST since the AST
        // would have no "memory" that the return type was implicitly int.
        //
        print_error( &(yylsp[-1]),
          "implicit \"int\" is illegal%s\n",
          C_LANG_WHICH( IMPLICIT_int )
        );
        PARSE_ABORT();
      }

      DUMP_START( "pc99_pointer_type_c_ast",
                  "* type_qualifier_list_c_stid_opt" );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[0].tid) );

      if ( false_set( &in_attr.is_implicit_int ) ) {
        c_ast_t *const int_ast = c_ast_new_gc( K_BUILTIN, &(yylsp[-1]) );
        int_ast->type.btids = TB_INT;
        ia_type_ast_push( int_ast );
      }

      c_ast_t *const type_ast = c_ast_dup( ia_type_ast_peek(), &gc_ast_list );
      (yyval.ast) = c_ast_pointer( type_ast, &gc_ast_list );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[0].tid), C_TPID_STORE );

      DUMP_AST( "pc99_pointer_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8182 "parser.c"
    break;

  case 315: /* $@28: %empty  */
#line 4681 "parser.y"
                                           { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 8188 "parser.c"
    break;

  case 316: /* pointer_to_member_decl_c_astp: pointer_to_member_type_c_ast $@28 decl_c_astp  */
#line 4683 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_to_member_decl_c_astp",
                  "pointer_to_member_type_c_ast decl_c_astp" );
      DUMP_AST( "pointer_to_member_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[0].ast_pair) );

      (yyval.ast_pair) = (yyvsp[0].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);

      DUMP_AST_PAIR( "pointer_to_member_decl_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8207 "parser.c"
    break;

  case 317: /* pointer_to_member_type_c_ast: any_sname_c Y_COLON2_STAR cv_qualifier_list_stid_opt  */
#line 4702 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "pointer_to_member_type_c_ast",
                  "sname '::*' cv_qualifier_list_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "sname", (yyvsp[-2].sname) );
      DUMP_TID( "cv_qualifier_list_stid_opt", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_POINTER_TO_MEMBER, &(yyloc) );

      c_type_t scope_type = *c_sname_local_type( &(yyvsp[-2].sname) );
      if ( !c_tid_is_any( scope_type.btids, TB_ANY_SCOPE ) ) {
        //
        // The sname has no scope-type, but we now know there's a pointer-to-
        // member of it, so it must be a class.  (It could alternatively be a
        // struct, but we have no context to know, so just pick class because
        // it's more C++-like.)
        //
        scope_type.btids = TB_CLASS;
        c_sname_set_local_type( &(yyvsp[-2].sname), &scope_type );
      }

      // adopt sname's scope-type for the AST
      (yyval.ast)->type = c_type_or( &C_TYPE_LIT_S( (yyvsp[0].tid) ), &scope_type );

      (yyval.ast)->ptr_mbr.class_sname = c_sname_move( &(yyvsp[-2].sname) );
      c_ast_set_parent( type_ast, (yyval.ast) );

      DUMP_AST( "pointer_to_member_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8244 "parser.c"
    break;

  case 318: /* $@29: %empty  */
#line 4739 "parser.y"
                                   { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 8250 "parser.c"
    break;

  case 319: /* reference_decl_c_astp: reference_type_c_ast $@29 decl_c_astp  */
#line 4741 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "reference_decl_c_astp", "reference_type_c_ast decl_c_astp" );
      DUMP_AST( "reference_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[0].ast_pair) );

      (yyval.ast_pair) = (yyvsp[0].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);

      DUMP_AST_PAIR( "reference_decl_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8268 "parser.c"
    break;

  case 320: /* reference_type_c_ast: Y_AMPER type_qualifier_list_c_stid_opt  */
#line 4759 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "reference_type_c_ast", "&" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_REFERENCE, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[0].tid), C_TPID_STORE );
      c_ast_set_parent( type_ast, (yyval.ast) );

      DUMP_AST( "reference_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8287 "parser.c"
    break;

  case 321: /* reference_type_c_ast: Y_AMPER2 type_qualifier_list_c_stid_opt  */
#line 4776 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "reference_type_c_ast", "&&" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_RVALUE_REFERENCE, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[0].tid), C_TPID_STORE );
      c_ast_set_parent( type_ast, (yyval.ast) );

      DUMP_AST( "reference_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8306 "parser.c"
    break;

  case 322: /* typedef_type_decl_c_ast: typedef_type_c_ast  */
#line 4797 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "typedef_type_decl_c_ast", "typedef_type_c_ast" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "typedef_type_c_ast", (yyvsp[0].ast) );

      if ( c_tid_is_any( type_ast->type.stids, TS_TYPEDEF ) ) {
        //
        // If we're defining a type, return the type as-is.
        //
        (yyval.ast) = (yyvsp[0].ast);
      }
      else {
        //
        // Otherwise, return the type that it's typedef'd as.
        //
        c_ast_t const *const raw_tdef_ast = c_ast_untypedef( (yyvsp[0].ast) );

        //
        // But first ensure the name isn't of a previously declared type:
        //
        //      cdecl> struct S
        //      cdecl> explain int S    // error: "S": previously declared
        //
        // Note that typedef_type_c_ast is like:
        //
        //      typedef_type_c_ast: {
        //        sname: { string: "" },
        //        kind: { value: 0x20, string: "typedef" },
        //        ...
        //        type: { btid: 0x10000001, ..., string: "none" },
        //        tdef: {
        //          for_ast: {
        //            sname: { string: "S", scopes: "struct" },
        //            kind: { value: 0x8, string: "struct or union" },
        //            ...
        //            type: { btid: 0x800001, ..., string: "struct" },
        //            csu: {
        //              csu_sname: { string: "S", scopes: "none" }
        //            }
        //          }
        //        },
        //        ...
        //      }
        //
        // That is, typedef_type_c_ast has no name itself (at this point), but
        // the raw type, of course, does, so it's that name we have to check.
        //
        // This check has to be done now in the parser rather than later in the
        // AST since if this declaration were joined with a type (like `int`
        // above), the type information would be lost and we'd get this from
        // above:
        //
        //      declare S as structure S          // wrong
        //
        // Additionally, we also get here when the typedef name is used as part
        // of longer name, e.g., `S::x`:
        //
        //      c++decl> explain int S::x
        //      declare x of structure S as int   // correct
        //
        // but that name isn't of a previously declared type, so it's OK.
        //
        c_typedef_t const *const tdef =
          c_typedef_find_sname( &raw_tdef_ast->sname );
        if ( tdef != NULL ) {
          print_error(
            &(yyvsp[0].ast)->loc,
            "\"%s\": previously declared as type: ",
            c_sname_full_name( &raw_tdef_ast->sname )
          );
          print_type( tdef, stderr );
          PARSE_ABORT();
        }

        //
        // We have to duplicate the type to set the current location.
        //
        (yyval.ast) = c_ast_dup( raw_tdef_ast, &gc_ast_list );
        (yyval.ast)->loc = (yyvsp[0].ast)->loc;
      }

      DUMP_AST( "typedef_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8397 "parser.c"
    break;

  case 323: /* $@30: %empty  */
#line 4890 "parser.y"
    {
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 8405 "parser.c"
    break;

  case 324: /* user_defined_conversion_decl_c_astp: oper_sname_c_opt Y_operator type_c_ast $@30 udc_decl_c_ast_opt lparen_exp rparen_func_qualifier_list_c_stid_opt noexcept_c_stid_opt func_equals_c_stid_opt  */
#line 4896 "parser.y"
    {
      ia_type_ast_pop();

      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "user_defined_conversion_decl_c_astp",
                  "oper_sname_c_opt OPERATOR "
                  "type_c_ast udc_decl_c_ast_opt '(' ')' "
                  "func_qualifier_list_c_stid_opt noexcept_c_stid_opt "
                  "func_equals_c_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "oper_sname_c_opt", (yyvsp[-8].sname) );
      DUMP_AST( "type_c_ast", (yyvsp[-6].ast) );
      DUMP_AST( "udc_decl_c_ast_opt", (yyvsp[-4].ast) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-1].tid) );
      DUMP_TID( "func_equals_c_stid_opt", (yyvsp[0].tid) );

      c_ast_t *const udc_ast = c_ast_new_gc( K_USER_DEF_CONVERSION, &(yyloc) );
      udc_ast->sname = c_sname_move( &(yyvsp[-8].sname) );
      udc_ast->type.stids = c_tid_check(
        (yyvsp[-2].tid) | (yyvsp[-1].tid) | (yyvsp[0].tid),
        C_TPID_STORE
      );
      if ( type_ast != NULL )
        c_type_or_eq( &udc_ast->type, &type_ast->type );
      udc_ast->udef_conv.to_ast = IF_ELSE( (yyvsp[-4].ast), (yyvsp[-6].ast) );

      (yyval.ast_pair) = (c_ast_pair_t){ udc_ast, udc_ast->udef_conv.to_ast };

      DUMP_AST_PAIR( "user_defined_conversion_decl_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8443 "parser.c"
    break;

  case 325: /* user_defined_literal_decl_c_astp: oper_sname_c_opt Y_operator quote2_exp name_exp lparen_exp param_c_ast_list_exp ')' noexcept_c_stid_opt trailing_return_type_c_ast_opt  */
#line 4939 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "user_defined_literal_decl_c_astp",
                  "oper_sname_c_opt OPERATOR \"\" "
                  "'(' param_c_ast_list_exp ')' noexcept_c_stid_opt "
                  "trailing_return_type_c_ast_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "oper_sname_c_opt", (yyvsp[-8].sname) );
      DUMP_STR( "name", (yyvsp[-5].name) );
      DUMP_AST_LIST( "param_c_ast_list_exp", (yyvsp[-3].ast_list) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-1].tid) );
      DUMP_AST( "trailing_return_type_c_ast_opt", (yyvsp[0].ast) );

      c_sname_set( &type_ast->sname, &(yyvsp[-8].sname) );
      c_sname_append_name( &type_ast->sname, (yyvsp[-5].name) );

      c_ast_t *const udl_ast = c_ast_new_gc( K_USER_DEF_LITERAL, &(yyloc) );
      udl_ast->type.stids = c_tid_check( (yyvsp[-1].tid), C_TPID_STORE );
      udl_ast->udef_lit.param_ast_list = slist_move( &(yyvsp[-3].ast_list) );

      (yyval.ast_pair) = (c_ast_pair_t){
        c_ast_add_func(
          type_ast,
          udl_ast,
          IF_ELSE( (yyvsp[0].ast), type_ast )
        ),
        udl_ast->udef_lit.ret_ast
      };

      DUMP_AST_PAIR( "user_defined_literal_decl_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8481 "parser.c"
    break;

  case 326: /* cast_c_astp_opt: %empty  */
#line 4979 "parser.y"
                                  { (yyval.ast_pair) = (c_ast_pair_t){ NULL, NULL }; }
#line 8487 "parser.c"
    break;

  case 336: /* cast2_c_astp: sname_c_ast  */
#line 4996 "parser.y"
                                  { (yyval.ast_pair) = (c_ast_pair_t){ (yyvsp[0].ast), NULL }; }
#line 8493 "parser.c"
    break;

  case 337: /* array_cast_c_astp: cast_c_astp_opt array_size_c_ast  */
#line 5007 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "array_cast_c_astp", "cast_c_astp_opt array_size_c_ast" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-1].ast_pair) );
      DUMP_AST( "array_size_c_ast", (yyvsp[0].ast) );

      c_ast_set_parent(
        c_ast_new_gc( K_PLACEHOLDER, &(yylsp[-1]) ), (yyvsp[0].ast)
      );

      if ( (yyvsp[-1].ast_pair).target_ast != NULL ) {
        // array-of or function-like-ret type
        (yyval.ast_pair) = (c_ast_pair_t){
          (yyvsp[-1].ast_pair).ast,
          c_ast_add_array( (yyvsp[-1].ast_pair).target_ast, (yyvsp[0].ast), type_ast )
        };
      } else {
        c_ast_t *const ast = IF_ELSE( (yyvsp[-1].ast_pair).ast, type_ast );
        (yyval.ast_pair) = (c_ast_pair_t){
          c_ast_add_array( ast, (yyvsp[0].ast), type_ast ),
          NULL
        };
      }

      DUMP_AST_PAIR( "array_cast_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8527 "parser.c"
    break;

  case 338: /* $@31: %empty  */
#line 5043 "parser.y"
    { //
      // A block AST has to be the type inherited attribute for cast_c_astp_opt
      // so we have to create it here.
      //
      ia_type_ast_push( c_ast_new_gc( K_APPLE_BLOCK, &(yyloc) ) );
    }
#line 8538 "parser.c"
    break;

  case 339: /* block_cast_c_astp: '(' Y_CARET $@31 type_qualifier_list_c_stid_opt cast_c_astp_opt rparen_exp lparen_exp param_c_ast_list_opt ')'  */
#line 5051 "parser.y"
    {
      c_ast_t *const  block_ast = ia_type_ast_pop();
      c_ast_t *const  type_ast = ia_type_ast_peek();

      DUMP_START( "block_cast_c_astp",
                  "'(' '^' type_qualifier_list_c_stid_opt cast_c_astp_opt ')' "
                  "'(' param_c_ast_list_opt ')'" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[-5].tid) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-4].ast_pair) );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-1].ast_list) );

      PARSE_ASSERT(
        c_type_add_tid( &block_ast->type, (yyvsp[-5].tid), &(yylsp[-5]) )
      );
      block_ast->block.param_ast_list = slist_move( &(yyvsp[-1].ast_list) );
      (yyval.ast_pair) = (c_ast_pair_t){
        c_ast_add_func( (yyvsp[-4].ast_pair).ast, block_ast, type_ast ),
        block_ast->block.ret_ast
      };

      DUMP_AST_PAIR( "block_cast_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8567 "parser.c"
    break;

  case 340: /* func_cast_c_astp: cast2_c_astp '(' param_c_ast_list_opt rparen_func_qualifier_list_c_stid_opt noexcept_c_stid_opt trailing_return_type_c_ast_opt  */
#line 5085 "parser.y"
    {
      c_ast_t *ret_ast = ia_type_ast_peek();

      DUMP_START( "func_cast_c_astp",
                  "cast2_c_astp '(' param_c_ast_list_opt ')' "
                  "func_qualifier_list_c_stid_opt noexcept_c_stid_opt "
                  "trailing_return_type_c_ast_opt" );
      DUMP_AST( "in_attr__type_c_ast", ret_ast );
      DUMP_AST_PAIR( "cast2_c_astp", (yyvsp[-5].ast_pair) );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-3].ast_list) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_AST( "trailing_return_type_c_ast_opt", (yyvsp[0].ast) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-1].tid) );

      c_ast_t *const cast_ast = (yyvsp[-5].ast_pair).ast;
      if ( cast_ast->kind == K_FUNCTION ) {
        //
        // This is for a case like:
        //
        //      void f( int () () )
        //              |   |  |
        //              |   |  func
        //              |   |
        //              |   cast_ast (func)
        //              |
        //              ret_ast
        //
        // We replace ret_ast with cast_ast:
        //
        //      void f( int() () )
        //              |     |
        //              |     func
        //              |
        //              ret_ast <- cast_ast (func)
        //
        // that is, a "function returning function returning int" -- which is
        // illegal (since functions can't return functions) and will be caught
        // by c_ast_check_ret_type().
        //
        ret_ast = cast_ast;
      }

      c_ast_t *const func_ast = c_ast_new_gc( K_FUNCTION, &(yyloc) );
      c_tid_t const func_stids = (yyvsp[-2].tid) | (yyvsp[-1].tid);
      func_ast->type.stids = c_tid_check( func_stids, C_TPID_STORE );
      func_ast->func.param_ast_list = slist_move( &(yyvsp[-3].ast_list) );

      if ( (yyvsp[-5].ast_pair).target_ast != NULL ) {
        (yyval.ast_pair).ast = cast_ast;
        PJL_IGNORE_RV(
          c_ast_add_func( (yyvsp[-5].ast_pair).target_ast, func_ast, ret_ast )
        );
      }
      else {
        (yyval.ast_pair).ast = c_ast_add_func(
          cast_ast,
          func_ast,
          IF_ELSE( (yyvsp[0].ast), ret_ast )
        );
      }

      (yyval.ast_pair).target_ast = func_ast->func.ret_ast;

      DUMP_AST_PAIR( "func_cast_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8638 "parser.c"
    break;

  case 341: /* $@32: %empty  */
#line 5157 "parser.y"
    {
      ia_type_ast_push( c_ast_new_gc( K_PLACEHOLDER, &(yyloc) ) );
      ++in_attr.ast_depth;
    }
#line 8647 "parser.c"
    break;

  case 342: /* nested_cast_c_astp: '(' $@32 cast_c_astp_opt rparen_exp  */
#line 5162 "parser.y"
    {
      ia_type_ast_pop();
      --in_attr.ast_depth;

      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "nested_cast_c_astp", "'(' cast_c_astp_opt ')'" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-1].ast_pair) );

      (yyval.ast_pair) = (yyvsp[-1].ast_pair);

      if ( (yyval.ast_pair).ast == NULL ) {
        //
        // This is for a case like:
        //
        //      void f( int() )
        //                 ^^
        //
        // where the unnamed parameter is a "function returning int".  (In
        // param_c_ast, this will be converted into a "pointer to function
        // returning int".)
        //
        (yyval.ast_pair).ast = c_ast_new_gc( K_FUNCTION, &(yyloc) );
        c_ast_set_parent( type_ast, (yyval.ast_pair).ast );
      } else {
        (yyval.ast_pair).ast->loc = (yyloc);
      }

      DUMP_AST_PAIR( "nested_cast_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8684 "parser.c"
    break;

  case 343: /* $@33: %empty  */
#line 5199 "parser.y"
                                 { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 8690 "parser.c"
    break;

  case 344: /* pointer_cast_c_astp: pointer_type_c_ast $@33 cast_c_astp_opt  */
#line 5201 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_cast_c_astp", "pointer_type_c_ast cast_c_astp_opt" );
      DUMP_AST( "pointer_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      (yyval.ast_pair) = (c_ast_pair_t){
        c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast_pair).ast ),
        (yyvsp[0].ast_pair).target_ast
      };

      DUMP_AST_PAIR( "pointer_cast_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8710 "parser.c"
    break;

  case 345: /* $@34: %empty  */
#line 5221 "parser.y"
                                           { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 8716 "parser.c"
    break;

  case 346: /* pointer_to_member_cast_c_astp: pointer_to_member_type_c_ast $@34 cast_c_astp_opt  */
#line 5223 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_to_member_cast_c_astp",
                  "pointer_to_member_type_c_ast cast_c_astp_opt" );
      DUMP_AST( "pointer_to_member_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      (yyval.ast_pair) = (c_ast_pair_t){
        c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast_pair).ast ),
        (yyvsp[0].ast_pair).target_ast
      };

      DUMP_AST_PAIR( "pointer_to_member_cast_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8737 "parser.c"
    break;

  case 347: /* $@35: %empty  */
#line 5244 "parser.y"
                                   { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 8743 "parser.c"
    break;

  case 348: /* reference_cast_c_astp: reference_type_c_ast $@35 cast_c_astp_opt  */
#line 5246 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "reference_cast_c_astp",
                  "reference_type_c_ast cast_c_astp_opt" );
      DUMP_AST( "reference_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      (yyval.ast_pair) = (c_ast_pair_t){
        c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast_pair).ast ),
        (yyvsp[0].ast_pair).target_ast
      };

      DUMP_AST_PAIR( "reference_cast_c_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8764 "parser.c"
    break;

  case 349: /* udc_decl_c_ast_opt: %empty  */
#line 5273 "parser.y"
                                  { (yyval.ast) = NULL; }
#line 8770 "parser.c"
    break;

  case 355: /* $@36: %empty  */
#line 5285 "parser.y"
                                 { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 8776 "parser.c"
    break;

  case 356: /* pointer_udc_decl_c_ast: pointer_type_c_ast $@36 udc_decl_c_ast_opt  */
#line 5287 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_udc_decl_c_ast",
                  "pointer_type_c_ast udc_decl_c_ast_opt" );
      DUMP_AST( "pointer_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST( "udc_decl_c_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast) );

      DUMP_AST( "pointer_udc_decl_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8794 "parser.c"
    break;

  case 357: /* $@37: %empty  */
#line 5303 "parser.y"
                                           { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 8800 "parser.c"
    break;

  case 358: /* pointer_to_member_udc_decl_c_ast: pointer_to_member_type_c_ast $@37 udc_decl_c_ast_opt  */
#line 5305 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_to_member_udc_decl_c_ast",
                  "pointer_to_member_type_c_ast udc_decl_c_ast_opt" );
      DUMP_AST( "pointer_to_member_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST( "udc_decl_c_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast) );

      DUMP_AST( "pointer_to_member_udc_decl_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8818 "parser.c"
    break;

  case 359: /* $@38: %empty  */
#line 5321 "parser.y"
                                   { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 8824 "parser.c"
    break;

  case 360: /* reference_udc_decl_c_ast: reference_type_c_ast $@38 udc_decl_c_ast_opt  */
#line 5323 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "reference_udc_decl_c_ast",
                  "reference_type_c_ast udc_decl_c_ast_opt" );
      DUMP_AST( "reference_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST( "udc_decl_c_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast) );

      DUMP_AST( "reference_udc_decl_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8842 "parser.c"
    break;

  case 361: /* type_c_ast: type_modifier_list_c_type  */
#line 5349 "parser.y"
    {
      DUMP_START( "type_c_ast", "type_modifier_list_c_type" );
      DUMP_TYPE( "type_modifier_list_c_type", (yyvsp[0].type) );

      //
      // Prior to C99, typeless declarations are implicitly int, so we set it
      // here.  In C99 and later, however, implicit int is an error, so we
      // don't set it here and c_ast_check() will catch the error later.
      //
      // Note that type modifiers, e.g., unsigned, count as a type since that
      // means unsigned int; however, neither qualifiers, e.g., const, nor
      // storage classes, e.g., register, by themselves count as a type:
      //
      //      unsigned i;   // legal in C99
      //      const    j;   // illegal in C99
      //      register k;   // illegal in C99
      //
      c_type_t type = OPT_LANG_IS( IMPLICIT_int ) ?
        C_TYPE_LIT_B( TB_INT ) : T_NONE;

      PARSE_ASSERT( c_type_add( &type, &(yyvsp[0].type), &(yylsp[0]) ) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type = type;

      DUMP_AST( "type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8875 "parser.c"
    break;

  case 362: /* type_c_ast: type_modifier_list_c_type east_modified_type_c_ast  */
#line 5384 "parser.y"
    {
      DUMP_START( "type_c_ast",
                  "type_modifier_list_c_type east_modified_type_c_ast " );
      DUMP_TYPE( "type_modifier_list_c_type", (yyvsp[-1].type) );
      DUMP_AST( "east_modified_type_c_ast", (yyvsp[0].ast) );

      (yyval.ast) = (yyvsp[0].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &(yyvsp[-1].type), &(yylsp[-1]) ) );

      DUMP_AST( "type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8893 "parser.c"
    break;

  case 364: /* type_modifier_list_c_type_opt: %empty  */
#line 5402 "parser.y"
                                  { (yyval.type) = T_NONE; }
#line 8899 "parser.c"
    break;

  case 366: /* type_modifier_list_c_type: type_modifier_list_c_type type_modifier_c_type  */
#line 5408 "parser.y"
    {
      DUMP_START( "type_modifier_list_c_type",
                  "type_modifier_list_c_type type_modifier_c_type" );
      DUMP_TYPE( "type_modifier_list_c_type", (yyvsp[-1].type) );
      DUMP_TYPE( "type_modifier_c_type", (yyvsp[0].type) );

      (yyval.type) = (yyvsp[-1].type);
      PARSE_ASSERT( c_type_add( &(yyval.type), &(yyvsp[0].type), &(yylsp[0]) ) );

      DUMP_TYPE( "type_modifier_list_c_type", (yyval.type) );
      DUMP_END();
    }
#line 8916 "parser.c"
    break;

  case 368: /* type_modifier_c_type: type_modifier_base_type  */
#line 5426 "parser.y"
    {
      (yyval.type) = (yyvsp[0].type);
      //
      // This is for a case like:
      //
      //      explain typedef unsigned long size_t
      //
      // that is: explain a redefinition of a typedef'd type with the same type
      // that contains only one or more type_modifier_base_type.  The problem
      // is that, without an east_modified_type_c_ast (like int), the parser
      // would ordinarily take the typedef'd type (here, the size_t) as part of
      // the type_c_ast and then be out of tokens for the decl_c_astp -- at
      // which time it'll complain.
      //
      // Since type modifiers can't apply to a typedef'd type (e.g., "long
      // size_t" is illegal), we tell the lexer not to return either
      // Y_TYPEDEF_NAME or Y_TYPEDEF_SNAME if we encounter at least one type
      // modifier (except "register" since it's is really a storage class --
      // see the comment in type_modifier_base_type about "register").
      //
      if ( (yyval.type).stids != TS_REGISTER )
        lexer_find &= ~LEXER_FIND_TYPES;
    }
#line 8944 "parser.c"
    break;

  case 369: /* type_modifier_c_type: type_qualifier_c_stid  */
#line 5449 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 8950 "parser.c"
    break;

  case 371: /* type_modifier_c_type: attribute_specifier_list_c_atid  */
#line 5452 "parser.y"
    {
      (yyval.type) = C_TYPE_LIT_A( (yyvsp[0].tid) );
    }
#line 8958 "parser.c"
    break;

  case 372: /* type_modifier_base_type: Y__Complex  */
#line 5458 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 8964 "parser.c"
    break;

  case 373: /* type_modifier_base_type: Y__Imaginary  */
#line 5459 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 8970 "parser.c"
    break;

  case 374: /* type_modifier_base_type: Y_long  */
#line 5460 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 8976 "parser.c"
    break;

  case 375: /* type_modifier_base_type: Y_short  */
#line 5461 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 8982 "parser.c"
    break;

  case 376: /* type_modifier_base_type: Y_signed  */
#line 5462 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 8988 "parser.c"
    break;

  case 377: /* type_modifier_base_type: Y_unsigned  */
#line 5463 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 8994 "parser.c"
    break;

  case 378: /* type_modifier_base_type: Y_EMC__Sat  */
#line 5464 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 9000 "parser.c"
    break;

  case 379: /* type_modifier_base_type: Y_register  */
#line 5470 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9006 "parser.c"
    break;

  case 380: /* east_modified_type_c_ast: atomic_builtin_typedef_type_c_ast type_modifier_list_c_type_opt  */
#line 5476 "parser.y"
    {
      DUMP_START( "east_modified_type_c_ast",
                  "atomic_builtin_typedef_type_c_ast "
                  "type_modifier_list_c_type_opt" );
      DUMP_AST( "atomic_builtin_typedef_type_c_ast", (yyvsp[-1].ast) );
      DUMP_TYPE( "type_modifier_list_c_type_opt", (yyvsp[0].type) );

      (yyval.ast) = (yyvsp[-1].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &(yyvsp[0].type), &(yylsp[0]) ) );

      DUMP_AST( "type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9025 "parser.c"
    break;

  case 381: /* east_modified_type_c_ast: enum_class_struct_union_c_ast cv_qualifier_list_stid_opt  */
#line 5493 "parser.y"
    {
      DUMP_START( "east_modified_type_c_ast",
                  "enum_class_struct_union_c_ast cv_qualifier_list_stid_opt" );
      DUMP_AST( "enum_class_struct_union_c_ast", (yyvsp[-1].ast) );
      DUMP_TID( "cv_qualifier_list_stid_opt", (yyvsp[0].tid) );

      (yyval.ast) = (yyvsp[-1].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_AST( "east_modified_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9043 "parser.c"
    break;

  case 386: /* $@39: %empty  */
#line 5519 "parser.y"
    {
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 9051 "parser.c"
    break;

  case 387: /* atomic_specifier_type_c_ast: Y__Atomic_SPEC lparen_exp type_c_ast $@39 cast_c_astp_opt rparen_exp  */
#line 5523 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "atomic_specifier_type_c_ast",
                  "ATOMIC '(' type_c_ast cast_c_astp_opt ')'" );
      DUMP_AST( "type_c_ast", (yyvsp[-3].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-1].ast_pair) );

      (yyval.ast) = IF_ELSE( (yyvsp[-1].ast_pair).ast, (yyvsp[-3].ast) );
      (yyval.ast)->loc = (yyloc);

      //
      // Ensure the _Atomic() specifier type doesn't have either a storage
      // class or attributes:
      //
      //      const _Atomic(int) x;     // OK
      //      _Atomic(const int) y;     // error
      //
      // This check has to be done now in the parser rather than later in the
      // AST since the type would be stored as "atomic const int" either way so
      // the AST has no "memory" of which it was.
      //
      if ( (yyval.ast)->type.stids != TS_NONE || (yyval.ast)->type.atids != TA_NONE ) {
        static c_type_t const TSA_ANY = { TB_NONE, TS_ANY, TA_ANY };
        c_type_t const error_type = c_type_and( &(yyval.ast)->type, &TSA_ANY );
        print_error( &(yylsp[-3]),
          "_Atomic can not be of \"%s\"\n", c_type_name_c( &error_type )
        );
        PARSE_ABORT();
      }

      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, TS_ATOMIC, &(yylsp[-5]) ) );

      DUMP_AST( "atomic_specifier_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9092 "parser.c"
    break;

  case 388: /* builtin_type_c_ast: builtin_no_BitInt_c_btid  */
#line 5565 "parser.y"
    {
      DUMP_START( "builtin_type_c_ast", "builtin_no_BitInt_c_btid" );
      DUMP_TID( "builtin_no_BitInt_c_btid", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[0].tid), C_TPID_BASE );

      DUMP_AST( "builtin_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9107 "parser.c"
    break;

  case 389: /* builtin_type_c_ast: Y__BitInt lparen_exp int_lit_exp rparen_exp  */
#line 5576 "parser.y"
    {
      DUMP_START( "builtin_type_c_ast", "_BitInt '(' int_lit_exp ')'" );
      DUMP_INT( "int", (yyvsp[-1].int_val) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = TB_BITINT;
      (yyval.ast)->builtin.BitInt.width = STATIC_CAST( unsigned, (yyvsp[-1].int_val) );

      DUMP_AST( "builtin_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9123 "parser.c"
    break;

  case 404: /* typeof_type_c_ast: typeof  */
#line 5608 "parser.y"
    {
      print_error( &(yylsp[0]),
        "typeof declarations not supported by %s\n", CDECL
      );
      PARSE_ABORT();
    }
#line 9134 "parser.c"
    break;

  case 409: /* class_struct_union_c_ast: class_struct_union_btid attribute_specifier_list_c_atid_opt any_sname_c_exp  */
#line 5631 "parser.y"
    {
      DUMP_START( "enum_class_struct_union_c_ast",
                  "class_struct_union_btid "
                  "attribute_specifier_list_c_atid_opt sname" );
      DUMP_TID( "class_struct_union_btid", (yyvsp[-2].tid) );
      DUMP_TID( "attribute_specifier_list_c_atid_opt", (yyvsp[-1].tid) );
      DUMP_SNAME( "any_sname_c", (yyvsp[0].sname) );

      (yyval.ast) = c_ast_new_gc( K_CLASS_STRUCT_UNION, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[-2].tid), C_TPID_BASE );
      (yyval.ast)->type.atids = c_tid_check( (yyvsp[-1].tid), C_TPID_ATTR );
      (yyval.ast)->csu.csu_sname = c_sname_move( &(yyvsp[0].sname) );

      DUMP_AST( "class_struct_union_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9155 "parser.c"
    break;

  case 410: /* class_struct_union_c_ast: class_struct_union_btid attribute_specifier_list_c_atid_opt any_sname_c_opt '{'  */
#line 5650 "parser.y"
    {
      print_error( &(yylsp[0]),
        "explaining %s declarations not supported by %s\n",
        c_tid_name_c( (yyvsp[-3].tid) ), CDECL
      );
      c_sname_cleanup( &(yyvsp[-1].sname) );
      PARSE_ABORT();
    }
#line 9168 "parser.c"
    break;

  case 411: /* enum_c_ast: enum_btids attribute_specifier_list_c_atid_opt any_sname_c_exp enum_fixed_type_c_ast_opt  */
#line 5663 "parser.y"
    {
      DUMP_START( "enum_c_ast",
                  "enum_btids attribute_specifier_list_c_atid_opt sname "
                  "enum_fixed_type_c_ast_opt" );
      DUMP_TID( "enum_btids", (yyvsp[-3].tid) );
      DUMP_TID( "attribute_specifier_list_c_atid_opt", (yyvsp[-2].tid) );
      DUMP_SNAME( "any_sname_c", (yyvsp[-1].sname) );
      DUMP_AST( "enum_fixed_type_c_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_ENUM, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[-3].tid), C_TPID_BASE );
      (yyval.ast)->type.atids = c_tid_check( (yyvsp[-2].tid), C_TPID_ATTR );
      (yyval.ast)->enum_.of_ast = (yyvsp[0].ast);
      (yyval.ast)->enum_.enum_sname = c_sname_move( &(yyvsp[-1].sname) );

      DUMP_AST( "enum_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9191 "parser.c"
    break;

  case 412: /* enum_c_ast: enum_btids attribute_specifier_list_c_atid_opt any_sname_c_opt '{'  */
#line 5684 "parser.y"
    {
      print_error( &(yylsp[0]),
        "explaining %s declarations not supported by %s\n",
        c_tid_name_c( (yyvsp[-3].tid) ), CDECL
      );
      c_sname_cleanup( &(yyvsp[-1].sname) );
      PARSE_ABORT();
    }
#line 9204 "parser.c"
    break;

  case 413: /* enum_btids: Y_enum class_struct_btid_opt  */
#line 5697 "parser.y"
                                  { (yyval.tid) = (yyvsp[-1].tid) | (yyvsp[0].tid); }
#line 9210 "parser.c"
    break;

  case 414: /* enum_fixed_type_c_ast_opt: %empty  */
#line 5701 "parser.y"
                                  { (yyval.ast) = NULL; }
#line 9216 "parser.c"
    break;

  case 415: /* enum_fixed_type_c_ast_opt: ':' enum_fixed_type_c_ast  */
#line 5702 "parser.y"
                                  { (yyval.ast) = (yyvsp[0].ast); }
#line 9222 "parser.c"
    break;

  case 416: /* enum_fixed_type_c_ast_opt: ':' error  */
#line 5704 "parser.y"
    {
      elaborate_error( "type name expected" );
    }
#line 9230 "parser.c"
    break;

  case 417: /* enum_fixed_type_c_ast: enum_fixed_type_modifier_list_btid  */
#line 5720 "parser.y"
    {
      DUMP_START( "enum_fixed_type_c_ast",
                  "enum_fixed_type_modifier_list_btid" );
      DUMP_TID( "enum_fixed_type_modifier_list_btid", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yylsp[0]) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[0].tid), C_TPID_BASE );

      DUMP_AST( "enum_fixed_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9246 "parser.c"
    break;

  case 418: /* enum_fixed_type_c_ast: enum_fixed_type_modifier_list_btid enum_unmodified_fixed_type_c_ast enum_fixed_type_modifier_list_btid_opt  */
#line 5740 "parser.y"
    {
      DUMP_START( "enum_fixed_type_c_ast",
                  "enum_fixed_type_modifier_list_btid "
                  "enum_unmodified_fixed_type_c_ast "
                  "enum_fixed_type_modifier_list_btid_opt" );
      DUMP_TID( "enum_fixed_type_modifier_list_btid", (yyvsp[-2].tid) );
      DUMP_AST( "enum_unmodified_fixed_type_c_ast", (yyvsp[-1].ast) );
      DUMP_TID( "enum_fixed_type_modifier_list_btid_opt", (yyvsp[0].tid) );

      (yyval.ast) = (yyvsp[-1].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[-2].tid), &(yylsp[-2]) ) );
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_AST( "enum_fixed_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9268 "parser.c"
    break;

  case 419: /* enum_fixed_type_c_ast: enum_unmodified_fixed_type_c_ast enum_fixed_type_modifier_list_btid_opt  */
#line 5765 "parser.y"
    {
      DUMP_START( "enum_fixed_type_c_ast",
                  "enum_unmodified_fixed_type_c_ast "
                  "enum_fixed_type_modifier_list_btid_opt" );
      DUMP_AST( "enum_unmodified_fixed_type_c_ast", (yyvsp[-1].ast) );
      DUMP_TID( "enum_fixed_type_modifier_list_btid_opt", (yyvsp[0].tid) );

      (yyval.ast) = (yyvsp[-1].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_AST( "enum_fixed_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9287 "parser.c"
    break;

  case 420: /* enum_fixed_type_modifier_list_btid_opt: %empty  */
#line 5782 "parser.y"
                                  { (yyval.tid) = TB_NONE; }
#line 9293 "parser.c"
    break;

  case 422: /* enum_fixed_type_modifier_list_btid: enum_fixed_type_modifier_list_btid enum_fixed_type_modifier_btid  */
#line 5789 "parser.y"
    {
      DUMP_START( "enum_fixed_type_modifier_list_btid",
                  "enum_fixed_type_modifier_list_btid "
                  "enum_fixed_type_modifier_btid" );
      DUMP_TID( "enum_fixed_type_modifier_list_btid", (yyvsp[-1].tid) );
      DUMP_TID( "enum_fixed_type_modifier_btid", (yyvsp[0].tid) );

      (yyval.tid) = (yyvsp[-1].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_TID( "enum_fixed_type_modifier_list_btid", (yyval.tid) );
      DUMP_END();
    }
#line 9311 "parser.c"
    break;

  case 431: /* class_struct_btid_opt: %empty  */
#line 5822 "parser.y"
                                  { (yyval.tid) = TB_NONE; }
#line 9317 "parser.c"
    break;

  case 437: /* type_qualifier_list_c_stid_opt: %empty  */
#line 5839 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 9323 "parser.c"
    break;

  case 439: /* type_qualifier_list_c_stid: type_qualifier_list_c_stid type_qualifier_c_stid gnu_or_msc_attribute_specifier_list_c_opt  */
#line 5846 "parser.y"
    {
      DUMP_START( "type_qualifier_list_c_stid",
                  "type_qualifier_list_c_stid type_qualifier_c_stid" );
      DUMP_TID( "type_qualifier_list_c_stid", (yyvsp[-2].tid) );
      DUMP_TID( "type_qualifier_c_stid", (yyvsp[-1].tid) );

      (yyval.tid) = (yyvsp[-2].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[-1].tid), &(yylsp[-1]) ) );

      DUMP_TID( "type_qualifier_list_c_stid", (yyval.tid) );
      DUMP_END();
    }
#line 9340 "parser.c"
    break;

  case 440: /* type_qualifier_list_c_stid: gnu_or_msc_attribute_specifier_list_c type_qualifier_c_stid  */
#line 5860 "parser.y"
    {
      (yyval.tid) = (yyvsp[0].tid);
    }
#line 9348 "parser.c"
    break;

  case 441: /* type_qualifier_list_c_stid: type_qualifier_c_stid gnu_or_msc_attribute_specifier_list_c_opt  */
#line 5865 "parser.y"
    {
      (yyval.tid) = (yyvsp[-1].tid);
    }
#line 9356 "parser.c"
    break;

  case 451: /* cv_qualifier_list_stid_opt: %empty  */
#line 5886 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 9362 "parser.c"
    break;

  case 452: /* cv_qualifier_list_stid_opt: cv_qualifier_list_stid_opt cv_qualifier_stid  */
#line 5888 "parser.y"
    {
      DUMP_START( "cv_qualifier_list_stid_opt",
                  "cv_qualifier_list_stid_opt cv_qualifier_stid" );
      DUMP_TID( "cv_qualifier_list_stid_opt", (yyvsp[-1].tid) );
      DUMP_TID( "cv_qualifier_stid", (yyvsp[0].tid) );

      (yyval.tid) = (yyvsp[-1].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_TID( "cv_qualifier_list_stid_opt", (yyval.tid) );
      DUMP_END();
    }
#line 9379 "parser.c"
    break;

  case 453: /* restrict_qualifier_c_stid: Y_restrict  */
#line 5904 "parser.y"
    { //
      // This check has to be done now in the parser rather than later in the
      // AST since both "restrict" and "__restrict" map to TS_RESTRICT and the
      // AST has no "memory" of which it was.
      //
      if ( OPT_LANG_IS( CPP_ANY ) ) {
        print_error( &(yylsp[0]),
          "\"restrict\" not supported in C++; use \"%s\" instead\n",
          L_GNU___restrict
        );
        PARSE_ABORT();
      }
    }
#line 9397 "parser.c"
    break;

  case 458: /* upc_layout_qualifier_c: '[' error ']'  */
#line 5925 "parser.y"
    {
      elaborate_error( "one of nothing, integer, or '*' expected" );
    }
#line 9405 "parser.c"
    break;

  case 459: /* storage_class_c_type: Y_auto_STORAGE  */
#line 5933 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9411 "parser.c"
    break;

  case 460: /* storage_class_c_type: Y_Apple___block  */
#line 5934 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9417 "parser.c"
    break;

  case 461: /* storage_class_c_type: Y_consteval  */
#line 5935 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9423 "parser.c"
    break;

  case 462: /* storage_class_c_type: Y_constexpr  */
#line 5936 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9429 "parser.c"
    break;

  case 463: /* storage_class_c_type: Y_constinit  */
#line 5937 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9435 "parser.c"
    break;

  case 464: /* storage_class_c_type: Y_explicit  */
#line 5938 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9441 "parser.c"
    break;

  case 465: /* storage_class_c_type: Y_export  */
#line 5939 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9447 "parser.c"
    break;

  case 466: /* storage_class_c_type: Y_extern  */
#line 5940 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9453 "parser.c"
    break;

  case 467: /* storage_class_c_type: extern_linkage_c_stid  */
#line 5941 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9459 "parser.c"
    break;

  case 468: /* storage_class_c_type: Y_final  */
#line 5942 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9465 "parser.c"
    break;

  case 469: /* storage_class_c_type: Y_friend  */
#line 5943 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9471 "parser.c"
    break;

  case 470: /* storage_class_c_type: Y_inline  */
#line 5944 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9477 "parser.c"
    break;

  case 471: /* storage_class_c_type: Y_mutable  */
#line 5945 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9483 "parser.c"
    break;

  case 472: /* storage_class_c_type: _Noreturn_atid  */
#line 5947 "parser.y"
    {
      //
      // These checks have to be done now in the parser rather than later in
      // the AST because the _Noreturn keyword is mapped to the [[noreturn]]
      // attribute and the AST has no "memory" that it was _Noreturn.
      //
      if ( UNSUPPORTED( _Noreturn ) ) {
        print_error( &(yylsp[0]),
          "\"%s\" keyword not supported%s",
          lexer_token, C_LANG_WHICH( _Noreturn )
        );
        print_hint( "[[noreturn]]" );
        PARSE_ABORT();
      }
      if ( OPT_LANG_IS( C_MIN(23)) ) {
        print_warning( &(yylsp[0]),
          "\"%s\" is deprecated%s",
          lexer_token, C_LANG_WHICH( C_MAX(17) )
        );
        print_hint( "[[noreturn]]" );
      }

      (yyval.type) = C_TYPE_LIT_A( (yyvsp[0].tid) );
    }
#line 9512 "parser.c"
    break;

  case 473: /* storage_class_c_type: Y_override  */
#line 5971 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9518 "parser.c"
    break;

  case 474: /* storage_class_c_type: Y_static  */
#line 5973 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9524 "parser.c"
    break;

  case 475: /* storage_class_c_type: Y_typedef  */
#line 5974 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9530 "parser.c"
    break;

  case 476: /* storage_class_c_type: Y__Thread_local  */
#line 5975 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9536 "parser.c"
    break;

  case 477: /* storage_class_c_type: Y_thread_local  */
#line 5976 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9542 "parser.c"
    break;

  case 478: /* storage_class_c_type: Y_virtual  */
#line 5977 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 9548 "parser.c"
    break;

  case 481: /* attribute_specifier_list_c_atid_opt: %empty  */
#line 5988 "parser.y"
                                  { (yyval.tid) = TA_NONE; }
#line 9554 "parser.c"
    break;

  case 483: /* $@40: %empty  */
#line 5994 "parser.y"
    {
      if ( UNSUPPORTED( ATTRIBUTES ) ) {
        print_error( &(yylsp[-1]),
          "\"[[\" attribute syntax not supported%s\n",
          C_LANG_WHICH( ATTRIBUTES )
        );
        PARSE_ABORT();
      }
      lexer_keyword_ctx = C_KW_CTX_ATTRIBUTE;
    }
#line 9569 "parser.c"
    break;

  case 484: /* attribute_specifier_list_c_atid: Y_ATTR_BEGIN '[' $@40 using_opt attribute_list_c_atid_opt ']' rbracket_exp  */
#line 6005 "parser.y"
    {
      lexer_keyword_ctx = C_KW_CTX_DEFAULT;

      DUMP_START( "attribute_specifier_list_c_atid",
                  "'[[' using_opt attribute_list_c_atid_opt ']]'" );
      DUMP_TID( "attribute_list_c_atid_opt", (yyvsp[-2].tid) );

      (yyval.tid) = (yyvsp[-2].tid);

      DUMP_END();
    }
#line 9585 "parser.c"
    break;

  case 485: /* attribute_specifier_list_c_atid: gnu_or_msc_attribute_specifier_list_c  */
#line 6018 "parser.y"
    {
      (yyval.tid) = TA_NONE;
    }
#line 9593 "parser.c"
    break;

  case 487: /* using_opt: Y_using name_exp colon_exp  */
#line 6026 "parser.y"
    {
      print_warning( &(yylsp[-2]),
        "\"using\" in attributes not supported by %s (ignoring)\n", CDECL
      );
      free( (yyvsp[-1].name) );
    }
#line 9604 "parser.c"
    break;

  case 488: /* attribute_list_c_atid_opt: %empty  */
#line 6035 "parser.y"
                                  { (yyval.tid) = TA_NONE; }
#line 9610 "parser.c"
    break;

  case 490: /* attribute_list_c_atid: attribute_list_c_atid comma_exp attribute_c_atid_exp  */
#line 6041 "parser.y"
    {
      DUMP_START( "attribute_list_c_atid",
                  "attribute_list_c_atid , attribute_c_atid" );
      DUMP_TID( "attribute_list_c_atid", (yyvsp[-2].tid) );
      DUMP_TID( "attribute_c_atid_exp", (yyvsp[0].tid) );

      (yyval.tid) = (yyvsp[-2].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_TID( "attribute_list_c_atid", (yyval.tid) );
      DUMP_END();
    }
#line 9627 "parser.c"
    break;

  case 500: /* attribute_c_atid_exp: sname_c  */
#line 6067 "parser.y"
    {
      if ( c_sname_count( &(yyvsp[0].sname) ) > 1 ) {
        print_warning( &(yylsp[0]),
          "\"%s\": namespaced attributes not supported by %s\n",
          c_sname_full_name( &(yyvsp[0].sname) ), CDECL
        );
      }
      else {
        char const *adj = "unknown";
        c_lang_id_t lang_ids = LANG_NONE;

        char const *const name = c_sname_local_name( &(yyvsp[0].sname) );
        c_keyword_t const *const ck =
          c_keyword_find( name, c_lang_newer( opt_lang ), C_KW_CTX_ATTRIBUTE );
        if ( ck != NULL && c_tid_tpid( ck->tid ) == C_TPID_ATTR ) {
          adj = "unsupported";
          lang_ids = ck->lang_ids;
        }
        print_warning( &(yylsp[0]),
          "\"%s\": %s attribute%s",
          name, adj, c_lang_which( lang_ids )
        );

        print_suggestions( DYM_C_ATTRIBUTES, name );
        EPUTC( '\n' );
      }

      (yyval.tid) = TA_NONE;
      c_sname_cleanup( &(yyvsp[0].sname) );
    }
#line 9662 "parser.c"
    break;

  case 501: /* attribute_c_atid_exp: error  */
#line 6098 "parser.y"
    {
      elaborate_error_dym( DYM_C_ATTRIBUTES, "attribute name expected" );
    }
#line 9670 "parser.c"
    break;

  case 503: /* attribute_str_arg_c_opt: '(' str_lit_exp rparen_exp  */
#line 6106 "parser.y"
    {
      print_warning( &(yylsp[-2]),
        "attribute arguments not supported by %s (ignoring)\n", CDECL
      );
      free( (yyvsp[-1].str_val) );
    }
#line 9681 "parser.c"
    break;

  case 512: /* $@41: %empty  */
#line 6136 "parser.y"
    {
      attr_syntax_not_supported( &(yylsp[0]), L_GNU___attribute__ );
      //
      // Temporariy disabling finding keywords allows GNU attributes that are C
      // keywords (e.g., const) to be found as ordinary string literals.
      //
      lexer_find &= ~LEXER_FIND_C_KEYWORDS;
    }
#line 9694 "parser.c"
    break;

  case 513: /* gnu_attribute_specifier_c: Y_GNU___attribute__ $@41 lparen_exp lparen_exp gnu_attribute_list_c_opt ')' rparen_exp  */
#line 6145 "parser.y"
    {
      lexer_find |= LEXER_FIND_C_KEYWORDS;
    }
#line 9702 "parser.c"
    break;

  case 518: /* gnu_attribute_c_exp: Y_NAME gnu_attribute_decl_arg_list_c_opt  */
#line 6162 "parser.y"
    {
      free( (yyvsp[-1].name) );
    }
#line 9710 "parser.c"
    break;

  case 519: /* gnu_attribute_c_exp: error  */
#line 6166 "parser.y"
    {
      elaborate_error( "attribute name expected" );
    }
#line 9718 "parser.c"
    break;

  case 526: /* gnu_attribute_arg_c: Y_NAME  */
#line 6187 "parser.y"
                                  { free( (yyvsp[0].name) ); }
#line 9724 "parser.c"
    break;

  case 528: /* gnu_attribute_arg_c: Y_CHAR_LIT  */
#line 6189 "parser.y"
                                  { free( (yyvsp[0].str_val) ); }
#line 9730 "parser.c"
    break;

  case 529: /* gnu_attribute_arg_c: Y_STR_LIT  */
#line 6190 "parser.y"
                                  { free( (yyvsp[0].str_val) ); }
#line 9736 "parser.c"
    break;

  case 531: /* gnu_attribute_arg_c: Y_LEXER_ERROR  */
#line 6193 "parser.y"
    {
      PARSE_ABORT();
    }
#line 9744 "parser.c"
    break;

  case 534: /* $@42: %empty  */
#line 6205 "parser.y"
    {
      attr_syntax_not_supported( &(yylsp[0]), L_MSC___declspec );
      // See comment in gnu_attribute_specifier_c.
      lexer_find &= ~LEXER_FIND_C_KEYWORDS;
    }
#line 9754 "parser.c"
    break;

  case 535: /* msc_attribute_specifier_c: Y_MSC___declspec $@42 lparen_exp msc_attribute_list_c_opt ')'  */
#line 6211 "parser.y"
    {
      lexer_find |= LEXER_FIND_C_KEYWORDS;
    }
#line 9762 "parser.c"
    break;

  case 543: /* array_decl_english_ast: Y_array array_size_decl_ast of_exp decl_english_ast  */
#line 6247 "parser.y"
    {
      DUMP_START( "array_decl_english_ast",
                  "ARRAY array_size_num_opt OF decl_english_ast" );
      DUMP_AST( "array_size_decl_ast", (yyvsp[-2].ast) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = (yyvsp[-2].ast);
      (yyval.ast)->loc = (yylsp[-3]);
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "array_decl_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9780 "parser.c"
    break;

  case 544: /* array_decl_english_ast: Y_variable length_opt array_exp name_opt of_exp decl_english_ast  */
#line 6263 "parser.y"
    {
      DUMP_START( "array_decl_english_ast",
                  "VARIABLE LENGTH ARRAY name_opt OF decl_english_ast" );
      DUMP_STR( "name_opt", (yyvsp[-2].name) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      if ( (yyvsp[-2].name) == NULL ) {
        (yyval.ast)->array.kind = C_ARRAY_VLA_STAR;
      } else {
        (yyval.ast)->array.kind = C_ARRAY_NAMED_SIZE;
        (yyval.ast)->array.size_name = (yyvsp[-2].name);
      }
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "array_decl_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9803 "parser.c"
    break;

  case 545: /* array_size_decl_ast: %empty  */
#line 6285 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_EMPTY_SIZE;
    }
#line 9812 "parser.c"
    break;

  case 546: /* array_size_decl_ast: Y_INT_LIT  */
#line 6290 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_INT_SIZE;
      (yyval.ast)->array.size_int = (yyvsp[0].int_val);
    }
#line 9822 "parser.c"
    break;

  case 547: /* array_size_decl_ast: Y_NAME  */
#line 6296 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_NAMED_SIZE;
      (yyval.ast)->array.size_name = (yyvsp[0].name);
    }
#line 9832 "parser.c"
    break;

  case 548: /* array_size_decl_ast: '*'  */
#line 6302 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_VLA_STAR;
    }
#line 9841 "parser.c"
    break;

  case 551: /* block_decl_english_ast: Y_Apple_block paren_param_decl_list_english_opt returning_english_ast_opt  */
#line 6319 "parser.y"
    {
      DUMP_START( "block_decl_english_ast",
                  "BLOCK paren_param_decl_list_english_opt "
                  "returning_english_ast_opt" );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[-1].ast_list) );
      DUMP_AST( "returning_english_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_APPLE_BLOCK, &(yyloc) );
      (yyval.ast)->block.param_ast_list = slist_move( &(yyvsp[-1].ast_list) );
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "block_decl_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9860 "parser.c"
    break;

  case 552: /* constructor_decl_english_ast: Y_constructor paren_param_decl_list_english_opt  */
#line 6339 "parser.y"
    {
      DUMP_START( "constructor_decl_english_ast",
                  "CONSTRUCTOR paren_param_decl_list_english_opt" );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[0].ast_list) );

      (yyval.ast) = c_ast_new_gc( K_CONSTRUCTOR, &(yyloc) );
      (yyval.ast)->ctor.param_ast_list = slist_move( &(yyvsp[0].ast_list) );

      DUMP_AST( "constructor_decl_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9876 "parser.c"
    break;

  case 553: /* destructor_decl_english_ast: Y_destructor parens_opt  */
#line 6356 "parser.y"
    {
      DUMP_START( "destructor_decl_english_ast", "DESTRUCTOR" );

      (yyval.ast) = c_ast_new_gc( K_DESTRUCTOR, &(yyloc) );

      DUMP_AST( "destructor_decl_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9889 "parser.c"
    break;

  case 556: /* func_decl_english_ast: func_qualifier_english_type_opt member_or_non_member_opt Y_function paren_param_decl_list_english_opt returning_english_ast_opt  */
#line 6378 "parser.y"
    {
      DUMP_START( "func_decl_english_ast",
                  "ref_qualifier_english_stid_opt "
                  "member_or_non_member_opt "
                  "FUNCTION paren_param_decl_list_english_opt "
                  "returning_english_ast_opt" );
      DUMP_TYPE( "func_qualifier_english_type_opt", (yyvsp[-4].type) );
      DUMP_INT( "member_or_non_member_opt", (yyvsp[-3].member) );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[-1].ast_list) );
      DUMP_AST( "returning_english_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_FUNCTION, &(yyloc) );
      (yyval.ast)->type = (yyvsp[-4].type);
      (yyval.ast)->func.param_ast_list = slist_move( &(yyvsp[-1].ast_list) );
      (yyval.ast)->func.member = (yyvsp[-3].member);
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "func_decl_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9914 "parser.c"
    break;

  case 557: /* func_qualifier_english_type_opt: ref_qualifier_english_stid_opt  */
#line 6402 "parser.y"
    {
      (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) );
    }
#line 9922 "parser.c"
    break;

  case 558: /* func_qualifier_english_type_opt: msc_calling_convention_atid  */
#line 6406 "parser.y"
    {
      (yyval.type) = C_TYPE_LIT_A( (yyvsp[0].tid) );
    }
#line 9930 "parser.c"
    break;

  case 565: /* oper_decl_english_ast: type_qualifier_list_english_type_opt ref_qualifier_english_stid_opt member_or_non_member_opt operator_exp paren_param_decl_list_english_opt returning_english_ast_opt  */
#line 6429 "parser.y"
    {
      DUMP_START( "oper_decl_english_ast",
                  "type_qualifier_list_english_type_opt "
                  "ref_qualifier_english_stid_opt "
                  "member_or_non_member_opt "
                  "OPERATOR paren_param_decl_list_english_opt "
                  "returning_english_ast_opt" );
      DUMP_STR( "in_attr__operator", in_attr.operator->literal );
      DUMP_TYPE( "type_qualifier_list_english_type_opt", (yyvsp[-5].type) );
      DUMP_TID( "ref_qualifier_english_stid_opt", (yyvsp[-4].tid) );
      DUMP_INT( "member_or_non_member_opt", (yyvsp[-3].member) );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[-1].ast_list) );
      DUMP_AST( "returning_english_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_OPERATOR, &(yyloc) );
      PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &(yyvsp[-5].type), &(yylsp[-5]) ) );
      PARSE_ASSERT(
        c_type_add_tid( &(yyval.ast)->type, (yyvsp[-4].tid), &(yylsp[-4]) )
      );
      (yyval.ast)->oper.operator = in_attr.operator;
      (yyval.ast)->oper.param_ast_list = slist_move( &(yyvsp[-1].ast_list) );
      (yyval.ast)->oper.member = (yyvsp[-3].member);
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "oper_decl_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9962 "parser.c"
    break;

  case 566: /* paren_param_decl_list_english_opt: %empty  */
#line 6461 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 9968 "parser.c"
    break;

  case 568: /* paren_param_decl_list_english: '(' param_decl_list_english_opt ')'  */
#line 6467 "parser.y"
    {
      DUMP_START( "paren_param_decl_list_english",
                  "'(' param_decl_list_english_opt ')'" );
      DUMP_AST_LIST( "param_decl_list_english_opt", (yyvsp[-1].ast_list) );

      (yyval.ast_list) = (yyvsp[-1].ast_list);

      DUMP_AST_LIST( "paren_param_decl_list_english", (yyval.ast_list) );
      DUMP_END();
    }
#line 9983 "parser.c"
    break;

  case 569: /* param_decl_list_english_opt: %empty  */
#line 6480 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 9989 "parser.c"
    break;

  case 571: /* param_decl_list_english: param_decl_list_english comma_exp decl_english_ast_exp  */
#line 6487 "parser.y"
    {
      DUMP_START( "param_decl_list_english",
                  "param_decl_list_english ',' decl_english_ast" );
      DUMP_AST_LIST( "param_decl_list_english", (yyvsp[-2].ast_list) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast_list) = (yyvsp[-2].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "param_decl_list_english", (yyval.ast_list) );
      DUMP_END();
    }
#line 10006 "parser.c"
    break;

  case 572: /* param_decl_list_english: decl_english_ast  */
#line 6501 "parser.y"
    {
      DUMP_START( "param_decl_list_english", "decl_english_ast" );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      if ( (yyvsp[0].ast)->kind == K_FUNCTION ) // see the comment in param_c_ast
        (yyvsp[0].ast) = c_ast_pointer( (yyvsp[0].ast), &gc_ast_list );

      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "param_decl_list_english", (yyval.ast_list) );
      DUMP_END();
    }
#line 10024 "parser.c"
    break;

  case 574: /* decl_english_ast_exp: error  */
#line 6519 "parser.y"
    {
      elaborate_error( "declaration expected" );
    }
#line 10032 "parser.c"
    break;

  case 575: /* ref_qualifier_english_stid_opt: %empty  */
#line 6527 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 10038 "parser.c"
    break;

  case 576: /* ref_qualifier_english_stid_opt: Y_reference  */
#line 6528 "parser.y"
                                  { (yyval.tid) = TS_REFERENCE; }
#line 10044 "parser.c"
    break;

  case 577: /* ref_qualifier_english_stid_opt: Y_rvalue reference_exp  */
#line 6529 "parser.y"
                                  { (yyval.tid) = TS_RVALUE_REFERENCE; }
#line 10050 "parser.c"
    break;

  case 578: /* returning_english_ast_opt: %empty  */
#line 6536 "parser.y"
    {
      DUMP_START( "returning_english_ast_opt", "<empty>" );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      // see the comment in "type_c_ast"
      (yyval.ast)->type.btids = OPT_LANG_IS( IMPLICIT_int ) ? TB_INT : TB_VOID;

      DUMP_AST( "returning_english_ast_opt", (yyval.ast) );
      DUMP_END();
    }
#line 10065 "parser.c"
    break;

  case 580: /* returning_english_ast: returning decl_english_ast  */
#line 6552 "parser.y"
    {
      DUMP_START( "returning_english_ast", "RETURNING decl_english_ast" );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = (yyvsp[0].ast);

      DUMP_AST( "returning_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10079 "parser.c"
    break;

  case 581: /* returning_english_ast: returning error  */
#line 6563 "parser.y"
    {
      elaborate_error( "English expected after \"returning\"" );
    }
#line 10087 "parser.c"
    break;

  case 582: /* qualified_decl_english_ast: type_qualifier_list_english_type_opt qualifiable_decl_english_ast  */
#line 6573 "parser.y"
    {
      DUMP_START( "qualified_decl_english_ast",
                  "type_qualifier_list_english_type_opt "
                  "qualifiable_decl_english_ast" );
      DUMP_TYPE( "type_qualifier_list_english_type_opt", (yyvsp[-1].type) );
      DUMP_AST( "qualifiable_decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = (yyvsp[0].ast);
      if ( !c_type_is_none( &(yyvsp[-1].type) ) )
        (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &(yyvsp[-1].type), &(yylsp[-1]) ) );

      DUMP_AST( "qualified_decl_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10107 "parser.c"
    break;

  case 583: /* type_qualifier_list_english_type_opt: %empty  */
#line 6591 "parser.y"
                                  { (yyval.type) = T_NONE; }
#line 10113 "parser.c"
    break;

  case 585: /* type_qualifier_list_english_type: type_qualifier_list_english_type type_qualifier_english_type  */
#line 6598 "parser.y"
    {
      DUMP_START( "type_qualifier_list_english_type",
                  "type_qualifier_list_english_type "
                  "type_qualifier_english_type" );
      DUMP_TYPE( "type_qualifier_list_english_type", (yyvsp[-1].type) );
      DUMP_TYPE( "type_qualifier_english_type", (yyvsp[0].type) );

      (yyval.type) = (yyvsp[-1].type);
      PARSE_ASSERT( c_type_add( &(yyval.type), &(yyvsp[0].type), &(yylsp[0]) ) );

      DUMP_TYPE( "type_qualifier_list_english_type", (yyval.type) );
      DUMP_END();
    }
#line 10131 "parser.c"
    break;

  case 587: /* type_qualifier_english_type: attribute_english_atid  */
#line 6616 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_A( (yyvsp[0].tid) ); }
#line 10137 "parser.c"
    break;

  case 588: /* type_qualifier_english_type: storage_class_english_stid  */
#line 6617 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 10143 "parser.c"
    break;

  case 589: /* type_qualifier_english_type: type_qualifier_english_stid  */
#line 6618 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 10149 "parser.c"
    break;

  case 590: /* attribute_english_atid: Y_carries dependency_exp  */
#line 6622 "parser.y"
                                  { (yyval.tid) = TA_CARRIES_DEPENDENCY; }
#line 10155 "parser.c"
    break;

  case 593: /* attribute_english_atid: Y_maybe unused_exp  */
#line 6625 "parser.y"
                                  { (yyval.tid) = TA_MAYBE_UNUSED; }
#line 10161 "parser.c"
    break;

  case 595: /* attribute_english_atid: Y_no Y_discard  */
#line 6627 "parser.y"
                                  { (yyval.tid) = TA_NODISCARD; }
#line 10167 "parser.c"
    break;

  case 597: /* attribute_english_atid: Y_no Y_return  */
#line 6629 "parser.y"
                                  { (yyval.tid) = TA_NORETURN; }
#line 10173 "parser.c"
    break;

  case 600: /* attribute_english_atid: Y_no Y_unique address_exp  */
#line 6632 "parser.y"
                                  { (yyval.tid) = TA_NO_UNIQUE_ADDRESS; }
#line 10179 "parser.c"
    break;

  case 606: /* storage_class_english_stid: Y_const_ENG eval_expr_init_stid  */
#line 6642 "parser.y"
    {
      (yyval.tid) = (yyvsp[0].tid);
    }
#line 10187 "parser.c"
    break;

  case 615: /* storage_class_english_stid: Y_extern linkage_stid linkage_opt  */
#line 6654 "parser.y"
    {
      (yyval.tid) = (yyvsp[-1].tid);
    }
#line 10195 "parser.c"
    break;

  case 620: /* storage_class_english_stid: Y_no Y_except  */
#line 6661 "parser.y"
                                  { (yyval.tid) = TS_NOEXCEPT; }
#line 10201 "parser.c"
    break;

  case 622: /* storage_class_english_stid: Y_non_empty  */
#line 6663 "parser.y"
                                  { (yyval.tid) = TS_NON_EMPTY_ARRAY; }
#line 10207 "parser.c"
    break;

  case 626: /* storage_class_english_stid: Y_thread local_exp  */
#line 6668 "parser.y"
                                  { (yyval.tid) = TS_THREAD_LOCAL; }
#line 10213 "parser.c"
    break;

  case 632: /* storage_class_english_stid: Y_pure virtual_stid_exp  */
#line 6674 "parser.y"
                                  { (yyval.tid) = TS_PURE_VIRTUAL | (yyvsp[0].tid); }
#line 10219 "parser.c"
    break;

  case 633: /* eval_expr_init_stid: Y_evaluation  */
#line 6678 "parser.y"
                                  { (yyval.tid) = TS_CONSTEVAL; }
#line 10225 "parser.c"
    break;

  case 634: /* eval_expr_init_stid: Y_expression  */
#line 6679 "parser.y"
                                  { (yyval.tid) = TS_CONSTEXPR; }
#line 10231 "parser.c"
    break;

  case 635: /* eval_expr_init_stid: Y_initialization  */
#line 6680 "parser.y"
                                  { (yyval.tid) = TS_CONSTINIT; }
#line 10237 "parser.c"
    break;

  case 636: /* linkage_stid: str_lit  */
#line 6692 "parser.y"
    {
      bool ok = true;

      if ( strcmp( (yyvsp[0].str_val), "C" ) == 0 )
        (yyval.tid) = TS_EXTERN_C;
      else if ( strcmp( (yyvsp[0].str_val), "C++" ) == 0 )
        (yyval.tid) = TS_NONE;
      else {
        print_error( &(yylsp[0]), "\"%s\": unknown linkage language", (yyvsp[0].str_val) );
        print_hint( "\"C\" or \"C++\"" );
        ok = false;
      }

      free( (yyvsp[0].str_val) );
      PARSE_ASSERT( ok );
    }
#line 10258 "parser.c"
    break;

  case 656: /* pointer_decl_english_ast: Y_pointer to_exp decl_english_ast  */
#line 6749 "parser.y"
    {
      DUMP_START( "pointer_decl_english_ast", "POINTER TO decl_english_ast" );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      if ( (yyvsp[0].ast)->kind == K_NAME ) { // see the comment in "declare_command"
        assert( !c_sname_empty( &(yyvsp[0].ast)->sname ) );
        print_error_unknown_name( &(yylsp[0]), &(yyvsp[0].ast)->sname );
        PARSE_ABORT();
      }

      (yyval.ast) = c_ast_new_gc( K_POINTER, &(yyloc) );
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "pointer_decl_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10279 "parser.c"
    break;

  case 657: /* pointer_decl_english_ast: Y_pointer to_exp Y_member of_exp class_struct_union_btid_exp sname_english_exp decl_english_ast  */
#line 6772 "parser.y"
    {
      DUMP_START( "pointer_to_member_decl_english",
                  "POINTER TO MEMBER OF "
                  "class_struct_union_btid_exp "
                  "sname_english decl_english_ast" );
      DUMP_TID( "class_struct_union_btid_exp", (yyvsp[-2].tid) );
      DUMP_SNAME( "sname_english_exp", (yyvsp[-1].sname) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_POINTER_TO_MEMBER, &(yyloc) );
      (yyval.ast)->ptr_mbr.class_sname = c_sname_move( &(yyvsp[-1].sname) );
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[-2].tid), &(yylsp[-2]) ) );

      DUMP_AST( "pointer_to_member_decl_english", (yyval.ast) );
      DUMP_END();
    }
#line 10301 "parser.c"
    break;

  case 658: /* pointer_decl_english_ast: Y_pointer to_exp error  */
#line 6791 "parser.y"
    {
      if ( OPT_LANG_IS( POINTERS_TO_MEMBER ) )
        elaborate_error( "type name or \"member\" expected" );
      else
        elaborate_error( "type name expected" );
    }
#line 10312 "parser.c"
    break;

  case 659: /* reference_decl_english_ast: reference_english_ast to_exp decl_english_ast  */
#line 6804 "parser.y"
    {
      DUMP_START( "reference_decl_english_ast",
                  "reference_english_ast TO decl_english_ast" );
      DUMP_AST( "reference_english_ast", (yyvsp[-2].ast) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = (yyvsp[-2].ast);
      (yyval.ast)->loc = (yyloc);
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "reference_decl_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10330 "parser.c"
    break;

  case 660: /* reference_english_ast: Y_reference  */
#line 6821 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_REFERENCE, &(yyloc) );
    }
#line 10338 "parser.c"
    break;

  case 661: /* reference_english_ast: Y_rvalue reference_exp  */
#line 6826 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_RVALUE_REFERENCE, &(yyloc) );
    }
#line 10346 "parser.c"
    break;

  case 662: /* user_defined_literal_decl_english_ast: user_defined literal_exp lparen_exp param_decl_list_english_opt ')' returning_english_ast_opt  */
#line 6837 "parser.y"
    { //
      // User-defined literals are supported only in C++11 and later.
      // (However, we always allow them in configuration files.)
      //
      // This check is better to do now in the parser rather than later in the
      // AST because it has to be done in fewer places in the code plus gives a
      // better error location.
      //
      if ( UNSUPPORTED( USER_DEF_LITERALS ) ) {
        print_error( &(yylsp[-5]),
          "user-defined literal not supported%s\n",
          C_LANG_WHICH( USER_DEF_LITERALS )
        );
        PARSE_ABORT();
      }

      DUMP_START( "user_defined_literal_decl_english_ast",
                  "USER-DEFINED LITERAL '(' param_decl_list_english_opt ')' "
                  "returning_english_ast_opt" );
      DUMP_AST_LIST( "param_decl_list_english_opt", (yyvsp[-2].ast_list) );
      DUMP_AST( "returning_english_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_USER_DEF_LITERAL, &(yyloc) );
      (yyval.ast)->udef_lit.param_ast_list = slist_move( &(yyvsp[-2].ast_list) );
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "user_defined_literal_decl_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10380 "parser.c"
    break;

  case 663: /* var_decl_english_ast: sname_c Y_as decl_english_ast  */
#line 6875 "parser.y"
    {
      DUMP_START( "var_decl_english_ast", "NAME AS decl_english_ast" );
      DUMP_SNAME( "sname", (yyvsp[-2].sname) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      if ( (yyvsp[0].ast)->kind == K_NAME ) { // see the comment in "declare_command"
        assert( !c_sname_empty( &(yyvsp[0].ast)->sname ) );
        print_error_unknown_name( &(yylsp[0]), &(yyvsp[0].ast)->sname );
        c_sname_cleanup( &(yyvsp[-2].sname) );
        PARSE_ABORT();
      }

      (yyval.ast) = (yyvsp[0].ast);
      (yyval.ast)->loc = (yyloc);
      c_sname_set( &(yyval.ast)->sname, &(yyvsp[-2].sname) );

      DUMP_AST( "var_decl_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10404 "parser.c"
    break;

  case 665: /* var_decl_english_ast: "..."  */
#line 6904 "parser.y"
    {
      DUMP_START( "var_decl_english_ast", "..." );

      (yyval.ast) = c_ast_new_gc( K_VARIADIC, &(yyloc) );

      DUMP_AST( "var_decl_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10417 "parser.c"
    break;

  case 666: /* type_english_ast: type_modifier_list_english_type_opt unmodified_type_english_ast  */
#line 6921 "parser.y"
    {
      DUMP_START( "type_english_ast",
                  "type_modifier_list_english_type_opt "
                  "unmodified_type_english_ast" );
      DUMP_TYPE( "type_modifier_list_english_type_opt", (yyvsp[-1].type) );
      DUMP_AST( "unmodified_type_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = (yyvsp[0].ast);
      if ( !c_type_is_none( &(yyvsp[-1].type) ) ) {
        // Set the AST's location to the entire rule only if the leading
        // optional rule is actually present, otherwise @$ refers to a column
        // before $ast.
        (yyval.ast)->loc = (yyloc);
        PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &(yyvsp[-1].type), &(yylsp[-1]) ) );
      }

      DUMP_AST( "type_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10441 "parser.c"
    break;

  case 667: /* type_english_ast: type_modifier_list_english_type  */
#line 6943 "parser.y"
    {
      DUMP_START( "type_english_ast", "type_modifier_list_english_type" );
      DUMP_TYPE( "type_modifier_list_english_type", (yyvsp[0].type) );

      // see the comment in "type_c_ast"
      c_type_t new_type =
        C_TYPE_LIT_B( OPT_LANG_IS( IMPLICIT_int ) ? TB_INT : TB_NONE );

      PARSE_ASSERT( c_type_add( &new_type, &(yyvsp[0].type), &(yylsp[0]) ) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type = new_type;

      DUMP_AST( "type_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10462 "parser.c"
    break;

  case 668: /* type_modifier_list_english_type_opt: %empty  */
#line 6962 "parser.y"
                                  { (yyval.type) = T_NONE; }
#line 10468 "parser.c"
    break;

  case 670: /* type_modifier_list_english_type: type_modifier_list_english_type type_modifier_english_type  */
#line 6969 "parser.y"
    {
      DUMP_START( "type_modifier_list_english_type",
                  "type_modifier_list_english_type "
                  "type_modifier_english_type" );
      DUMP_TYPE( "type_modifier_list_english_type", (yyvsp[-1].type) );
      DUMP_TYPE( "type_modifier_english_type", (yyvsp[0].type) );

      (yyval.type) = (yyvsp[-1].type);
      PARSE_ASSERT( c_type_add( &(yyval.type), &(yyvsp[0].type), &(yylsp[0]) ) );

      DUMP_TYPE( "type_modifier_list_english_type", (yyval.type) );
      DUMP_END();
    }
#line 10486 "parser.c"
    break;

  case 677: /* builtin_type_english_ast: builtin_no_BitInt_english_btid  */
#line 6999 "parser.y"
    {
      DUMP_START( "builtin_type_english_ast",
                  "builtin_no_BitInt_english_btid" );
      DUMP_TID( "builtin_no_BitInt_english_btid", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[0].tid), C_TPID_BASE );

      DUMP_AST( "builtin_type_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10502 "parser.c"
    break;

  case 678: /* builtin_type_english_ast: BitInt_english_int  */
#line 7011 "parser.y"
    {
      DUMP_START( "builtin_type_english_ast", "BitInt_english_int" );
      DUMP_INT( "int", (yyvsp[0].int_val) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = TB_BITINT;
      (yyval.ast)->builtin.BitInt.width = STATIC_CAST( unsigned, (yyvsp[0].int_val) );

      DUMP_AST( "builtin_type_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10518 "parser.c"
    break;

  case 683: /* builtin_no_BitInt_english_btid: Y_char int_lit_opt  */
#line 7030 "parser.y"
    {
      switch ( (yyvsp[0].int_val) ) {
        case  0: (yyval.tid) = TB_CHAR    ; break;
        case  8: (yyval.tid) = TB_CHAR8_T ; break;
        case 16: (yyval.tid) = TB_CHAR16_T; break;
        case 32: (yyval.tid) = TB_CHAR32_T; break;
        default:
          print_error( &(yylsp[0]), "bits must be one of 8, 16, or 32\n" );
          PARSE_ABORT();
      } // switch
    }
#line 10534 "parser.c"
    break;

  case 688: /* builtin_no_BitInt_english_btid: Y_wide char_exp  */
#line 7045 "parser.y"
                                  { (yyval.tid) = TB_WCHAR_T; }
#line 10540 "parser.c"
    break;

  case 691: /* builtin_no_BitInt_english_btid: Y_floating point_exp  */
#line 7048 "parser.y"
                                  { (yyval.tid) = TB_FLOAT; }
#line 10546 "parser.c"
    break;

  case 692: /* builtin_no_BitInt_english_btid: Y_double precision_opt  */
#line 7049 "parser.y"
                                  { (yyval.tid) = TB_DOUBLE; }
#line 10552 "parser.c"
    break;

  case 695: /* BitInt_english_int: BitInt_english Y_INT_LIT bits_opt  */
#line 7056 "parser.y"
    {
      (yyval.int_val) = (yyvsp[-1].int_val);
    }
#line 10560 "parser.c"
    break;

  case 696: /* BitInt_english_int: BitInt_english '(' int_lit_exp rparen_exp  */
#line 7060 "parser.y"
    {
      (yyval.int_val) = (yyvsp[-1].int_val);
    }
#line 10568 "parser.c"
    break;

  case 697: /* BitInt_english_int: BitInt_english Y_width int_lit_exp bits_opt  */
#line 7064 "parser.y"
    {
      (yyval.int_val) = (yyvsp[-1].int_val);
    }
#line 10576 "parser.c"
    break;

  case 698: /* BitInt_english_int: BitInt_english error  */
#line 7068 "parser.y"
    {
      elaborate_error( "integer literal, '(', or \"width\" expected" );
    }
#line 10584 "parser.c"
    break;

  case 704: /* class_struct_union_english_ast: class_struct_union_btid any_sname_c_exp  */
#line 7086 "parser.y"
    {
      DUMP_START( "class_struct_union_english_ast",
                  "class_struct_union_btid sname" );
      DUMP_TID( "class_struct_union_btid", (yyvsp[-1].tid) );
      DUMP_SNAME( "sname", (yyvsp[0].sname) );

      (yyval.ast) = c_ast_new_gc( K_CLASS_STRUCT_UNION, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[-1].tid), C_TPID_BASE );
      (yyval.ast)->csu.csu_sname = c_sname_move( &(yyvsp[0].sname) );

      DUMP_AST( "enum_class_struct_union_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10602 "parser.c"
    break;

  case 705: /* enum_english_ast: enum_btids any_sname_c_exp of_type_enum_fixed_type_english_ast_opt  */
#line 7104 "parser.y"
    {
      DUMP_START( "enum_english_ast",
                  "enum_btids sname of_type_enum_fixed_type_english_ast_opt" );
      DUMP_TID( "enum_btids", (yyvsp[-2].tid) );
      DUMP_SNAME( "sname", (yyvsp[-1].sname) );
      DUMP_AST( "enum_fixed_type_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_ENUM, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[-2].tid), C_TPID_BASE );
      (yyval.ast)->enum_.of_ast = (yyvsp[0].ast);
      (yyval.ast)->enum_.enum_sname = c_sname_move( &(yyvsp[-1].sname) );

      DUMP_AST( "enum_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10622 "parser.c"
    break;

  case 706: /* of_type_enum_fixed_type_english_ast_opt: %empty  */
#line 7122 "parser.y"
                                        { (yyval.ast) = NULL; }
#line 10628 "parser.c"
    break;

  case 707: /* of_type_enum_fixed_type_english_ast_opt: Y_of type_opt enum_fixed_type_english_ast  */
#line 7124 "parser.y"
    {
      (yyval.ast) = (yyvsp[0].ast);
    }
#line 10636 "parser.c"
    break;

  case 708: /* enum_fixed_type_english_ast: enum_fixed_type_modifier_list_english_btid_opt enum_unmodified_fixed_type_english_ast  */
#line 7132 "parser.y"
    {
      DUMP_START( "enum_fixed_type_english_ast",
                  "enum_fixed_type_modifier_list_stid" );
      DUMP_TID( "enum_fixed_type_modifier_list_stid", (yyvsp[-1].tid) );
      DUMP_AST( "enum_unmodified_fixed_type_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = (yyvsp[0].ast);
      if ( (yyvsp[-1].tid) != TB_NONE ) {        // See comment in type_english_ast.
        (yyval.ast)->loc = (yyloc);
        PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[-1].tid), &(yylsp[-1]) ) );
      }

      DUMP_AST( "enum_fixed_type_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10656 "parser.c"
    break;

  case 709: /* enum_fixed_type_english_ast: enum_fixed_type_modifier_list_english_btid  */
#line 7149 "parser.y"
    {
      DUMP_START( "enum_fixed_type_english_ast",
                  "enum_fixed_type_modifier_list_english_btid" );
      DUMP_TID( "enum_fixed_type_modifier_list_english_btid", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[0].tid), C_TPID_BASE );

      DUMP_AST( "enum_fixed_type_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10672 "parser.c"
    break;

  case 710: /* enum_fixed_type_modifier_list_english_btid_opt: %empty  */
#line 7163 "parser.y"
                                  { (yyval.tid) = TB_NONE; }
#line 10678 "parser.c"
    break;

  case 712: /* enum_fixed_type_modifier_list_english_btid: enum_fixed_type_modifier_list_english_btid enum_fixed_type_modifier_btid  */
#line 7170 "parser.y"
    {
      DUMP_START( "enum_fixed_type_modifier_list_english_btid",
                  "enum_fixed_type_modifier_list_english_btid "
                  "enum_fixed_type_modifier_btid" );
      DUMP_TID( "enum_fixed_type_modifier_list_english_btid", (yyvsp[-1].tid) );
      DUMP_TID( "enum_fixed_type_modifier_btid", (yyvsp[0].tid) );

      (yyval.tid) = (yyvsp[-1].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_TID( "enum_fixed_type_modifier_list_english_btid", (yyval.tid) );
      DUMP_END();
    }
#line 10696 "parser.c"
    break;

  case 717: /* any_name: Y_TYPEDEF_NAME  */
#line 7199 "parser.y"
    {
      assert( c_sname_count( &(yyvsp[0].tdef)->ast->sname ) == 1 );
      (yyval.name) = check_strdup( c_sname_local_name( &(yyvsp[0].tdef)->ast->sname ) );
    }
#line 10705 "parser.c"
    break;

  case 719: /* any_name_exp: error  */
#line 7208 "parser.y"
    {
      (yyval.name) = NULL;
      elaborate_error( "name expected" );
    }
#line 10714 "parser.c"
    break;

  case 723: /* any_sname_c_exp: error  */
#line 7222 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      elaborate_error( "name expected" );
    }
#line 10723 "parser.c"
    break;

  case 724: /* any_sname_c_opt: %empty  */
#line 7229 "parser.y"
                                  { c_sname_init( &(yyval.sname) ); }
#line 10729 "parser.c"
    break;

  case 728: /* name_ast: Y_NAME  */
#line 7240 "parser.y"
    {
      DUMP_START( "name_ast", "NAME" );
      DUMP_STR( "NAME", (yyvsp[0].name) );

      (yyval.ast) = c_ast_new_gc( K_NAME, &(yyloc) );
      c_sname_append_name( &(yyval.ast)->sname, (yyvsp[0].name) );

      DUMP_AST( "name_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10744 "parser.c"
    break;

  case 730: /* name_exp: error  */
#line 7255 "parser.y"
    {
      (yyval.name) = NULL;
      elaborate_error( "name expected" );
    }
#line 10753 "parser.c"
    break;

  case 731: /* name_opt: %empty  */
#line 7262 "parser.y"
                                  { (yyval.name) = NULL; }
#line 10759 "parser.c"
    break;

  case 733: /* oper_sname_c_opt: %empty  */
#line 7267 "parser.y"
                                  { c_sname_init( &(yyval.sname) ); }
#line 10765 "parser.c"
    break;

  case 734: /* oper_sname_c_opt: Y_OPERATOR_SNAME Y_COLON2  */
#line 7270 "parser.y"
    {
      (yyval.sname) = (yyvsp[-1].sname);
      if ( c_type_is_none( c_sname_local_type( &(yyval.sname) ) ) )
        c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT_B( TB_SCOPE ) );
    }
#line 10775 "parser.c"
    break;

  case 735: /* typedef_type_c_ast: any_typedef sub_scope_sname_c_opt  */
#line 7279 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();
      c_ast_t const *type_for_ast = (yyvsp[-1].tdef)->ast;

      DUMP_START( "typedef_type_c_ast", "any_typedef" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "any_typedef__ast", type_for_ast );
      DUMP_SNAME( "sub_scope_sname_c_opt", (yyvsp[0].sname) );

      if ( c_sname_empty( &(yyvsp[0].sname) ) ) {
ttntd:  (yyval.ast) = c_ast_new_gc( K_TYPEDEF, &(yyloc) );
        (yyval.ast)->type.btids = TB_TYPEDEF;
        (yyval.ast)->tdef.for_ast = type_for_ast;
      }
      else {
        c_sname_t temp_name = c_sname_dup( &(yyvsp[-1].tdef)->ast->sname );
        c_sname_append_sname( &temp_name, &(yyvsp[0].sname) );

        if ( type_ast == NULL ) {
          //
          // This is for a case like:
          //
          //      define S as struct S
          //      explain S::T x
          //
          // that is: a typedef'd type followed by ::T where T is an unknown
          // name used as a type. Just assume the T is a type and create a name
          // for it.
          //
          c_ast_t *const name_ast = c_ast_new_gc( K_NAME, &(yylsp[0]) );
          c_sname_set( &name_ast->sname, &temp_name );
          type_for_ast = name_ast;
          goto ttntd;
        }

        //
        // Otherwise, this is for cases like:
        //
        //  1. A typedef'd type used for a scope:
        //
        //          define S as struct S
        //          explain int S::x
        //
        //  2. A typedef'd type used for an intermediate scope:
        //
        //          define S as struct S
        //          define T as struct T
        //          explain int S::T::x
        //
        (yyval.ast) = type_ast;
        c_sname_set( &(yyval.ast)->sname, &temp_name );
      }

      DUMP_AST( "typedef_type_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10836 "parser.c"
    break;

  case 736: /* sub_scope_sname_c_opt: %empty  */
#line 7338 "parser.y"
                                  { c_sname_init( &(yyval.sname) ); }
#line 10842 "parser.c"
    break;

  case 737: /* sub_scope_sname_c_opt: Y_COLON2 any_sname_c  */
#line 7339 "parser.y"
                                  { (yyval.sname) = (yyvsp[0].sname); }
#line 10848 "parser.c"
    break;

  case 738: /* sname_c: sname_c Y_COLON2 Y_NAME  */
#line 7344 "parser.y"
    {
      // see the comment in "of_scope_english"
      if ( UNSUPPORTED( SCOPED_NAMES ) ) {
        print_error( &(yylsp[-1]),
          "scoped names not supported%s\n",
          C_LANG_WHICH( SCOPED_NAMES )
        );
        c_sname_cleanup( &(yyvsp[-2].sname) );
        free( (yyvsp[0].name) );
        PARSE_ABORT();
      }

      DUMP_START( "sname_c", "sname_c '::' NAME" );
      DUMP_SNAME( "sname_c", (yyvsp[-2].sname) );
      DUMP_STR( "name", (yyvsp[0].name) );

      (yyval.sname) = (yyvsp[-2].sname);
      c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT_B( TB_SCOPE ) );
      c_sname_append_name( &(yyval.sname), (yyvsp[0].name) );

      DUMP_SNAME( "sname_c", (yyval.sname) );
      DUMP_END();
    }
#line 10876 "parser.c"
    break;

  case 739: /* sname_c: sname_c Y_COLON2 any_typedef  */
#line 7369 "parser.y"
    { //
      // This is for a case like:
      //
      //      define S::int8_t as char
      //
      // that is: the type int8_t is an existing type in no scope being defined
      // as a distinct type in a new scope.
      //
      DUMP_START( "sname_c", "sname_c '::' any_typedef" );
      DUMP_SNAME( "sname_c", (yyvsp[-2].sname) );
      DUMP_AST( "any_typedef__ast", (yyvsp[0].tdef)->ast );

      (yyval.sname) = (yyvsp[-2].sname);
      c_sname_set_local_type( &(yyval.sname), &C_TYPE_LIT_B( TB_SCOPE ) );
      c_sname_t temp_sname = c_sname_dup( &(yyvsp[0].tdef)->ast->sname );
      c_sname_append_sname( &(yyval.sname), &temp_sname );

      DUMP_SNAME( "sname_c", (yyval.sname) );
      DUMP_END();
    }
#line 10901 "parser.c"
    break;

  case 740: /* sname_c: Y_NAME  */
#line 7391 "parser.y"
    {
      DUMP_START( "sname_c", "NAME" );
      DUMP_STR( "NAME", (yyvsp[0].name) );

      c_sname_init_name( &(yyval.sname), (yyvsp[0].name) );

      DUMP_SNAME( "sname_c", (yyval.sname) );
      DUMP_END();
    }
#line 10915 "parser.c"
    break;

  case 741: /* sname_c_ast: sname_c bit_field_c_uint_opt  */
#line 7405 "parser.y"
    {
      c_ast_t *type_ast = ia_type_ast_peek();

      DUMP_START( "sname_c_ast", "sname_c" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "sname", (yyvsp[-1].sname) );
      DUMP_INT( "bit_field_c_uint_opt", (yyvsp[0].uint_val) );

      if ( !c_sname_empty( &type_ast->sname ) )
        type_ast = c_ast_dup( type_ast, &gc_ast_list );

      c_sname_set( &type_ast->sname, &(yyvsp[-1].sname) );

      if ( (yyvsp[0].uint_val) != 0 ) {
        //
        // This check has to be done now in the parser rather than later in the
        // AST since we need to use the builtin union member now.
        //
        if ( !c_ast_is_integral( type_ast ) ) {
          print_error( &(yylsp[0]),
            "bit-fields can be only of integral %stypes\n",
            OPT_LANG_IS( enum_BITFIELDS ) ? "or enumeration " : ""
          );
          PARSE_ABORT();
        }
        type_ast->bit_field.bit_width = STATIC_CAST( unsigned, (yyvsp[0].uint_val) );
      }

      (yyval.ast) = type_ast;
      DUMP_AST( "sname_c_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10952 "parser.c"
    break;

  case 742: /* bit_field_c_uint_opt: %empty  */
#line 7440 "parser.y"
                                  { (yyval.uint_val) = 0; }
#line 10958 "parser.c"
    break;

  case 743: /* bit_field_c_uint_opt: ':' int_lit_exp  */
#line 7442 "parser.y"
    { //
      // This check has to be done now in the parser rather than later in the
      // AST since we use 0 to mean "no bit-field."
      //
      if ( (yyvsp[0].int_val) == 0 ) {
        print_error( &(yylsp[0]), "bit-field width must be > 0\n" );
        PARSE_ABORT();
      }
      (yyval.uint_val) = STATIC_CAST( unsigned, (yyvsp[0].int_val) );
    }
#line 10973 "parser.c"
    break;

  case 745: /* sname_c_exp: error  */
#line 7457 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      elaborate_error( "name expected" );
    }
#line 10982 "parser.c"
    break;

  case 746: /* sname_c_opt: %empty  */
#line 7464 "parser.y"
                                  { c_sname_init( &(yyval.sname) ); }
#line 10988 "parser.c"
    break;

  case 748: /* sname_english: any_sname_c of_scope_list_english_opt  */
#line 7470 "parser.y"
    {
      DUMP_START( "sname_english", "any_sname_c of_scope_list_english_opt" );
      DUMP_SNAME( "any_sname_c", (yyvsp[-1].sname) );
      DUMP_SNAME( "of_scope_list_english_opt", (yyvsp[0].sname) );

      c_type_t const *local_type = c_sname_local_type( &(yyvsp[0].sname) );
      if ( c_type_is_none( local_type ) )
        local_type = c_sname_local_type( &(yyvsp[-1].sname) );
      (yyval.sname) = (yyvsp[0].sname);
      c_sname_append_sname( &(yyval.sname), &(yyvsp[-1].sname) );
      c_sname_set_local_type( &(yyval.sname), local_type );

      DUMP_SNAME( "sname_english", (yyval.sname) );
      DUMP_END();
    }
#line 11008 "parser.c"
    break;

  case 749: /* sname_english_ast: Y_NAME of_scope_list_english_opt  */
#line 7489 "parser.y"
    {
      DUMP_START( "sname_english_ast", "NAME of_scope_list_english_opt" );
      DUMP_STR( "NAME", (yyvsp[-1].name) );
      DUMP_SNAME( "of_scope_list_english_opt", (yyvsp[0].sname) );

      c_sname_t sname = c_sname_move( &(yyvsp[0].sname) );
      c_sname_append_name( &sname, (yyvsp[-1].name) );

      //
      // See if the full name is the name of a typedef'd type.
      //
      c_typedef_t const *const tdef = c_typedef_find_sname( &sname );
      if ( tdef != NULL ) {
        (yyval.ast) = c_ast_new_gc( K_TYPEDEF, &(yyloc) );
        (yyval.ast)->type.btids = TB_TYPEDEF;
        (yyval.ast)->tdef.for_ast = tdef->ast;
        c_sname_cleanup( &sname );
      } else {
        (yyval.ast) = c_ast_new_gc( K_NAME, &(yyloc) );
        c_sname_set( &(yyval.ast)->sname, &sname );
      }

      DUMP_AST( "sname_english_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11038 "parser.c"
    break;

  case 751: /* sname_english_exp: error  */
#line 7519 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      elaborate_error( "name expected" );
    }
#line 11047 "parser.c"
    break;

  case 752: /* sname_english_opt: %empty  */
#line 7526 "parser.y"
                                  { c_sname_init( &(yyval.sname) ); }
#line 11053 "parser.c"
    break;

  case 754: /* sname_list_english: sname_list_english ',' sname_english_exp  */
#line 7532 "parser.y"
    {
      DUMP_START( "sname_list_english",
                  "sname_list_english ',' sname_english" );
      DUMP_SNAME_LIST( "sname_list_english", (yyvsp[-2].sname_list) );
      DUMP_SNAME( "sname_english", (yyvsp[0].sname) );

      (yyval.sname_list) = (yyvsp[-2].sname_list);
      c_sname_t *const temp_sname = MALLOC( c_sname_t, 1 );
      *temp_sname = c_sname_move( &(yyvsp[0].sname) );
      slist_push_back( &(yyval.sname_list), temp_sname );

      DUMP_SNAME_LIST( "sname_list_english", (yyval.sname_list) );
      DUMP_END();
    }
#line 11072 "parser.c"
    break;

  case 755: /* sname_list_english: sname_english  */
#line 7548 "parser.y"
    {
      DUMP_START( "sname_list_english", "sname_english" );
      DUMP_SNAME( "sname_english", (yyvsp[0].sname) );

      c_sname_t *const temp_sname = MALLOC( c_sname_t, 1 );
      *temp_sname = c_sname_move( &(yyvsp[0].sname) );
      slist_init( &(yyval.sname_list) );
      slist_push_back( &(yyval.sname_list), temp_sname );

      DUMP_SNAME_LIST( "sname_list_english", (yyval.sname_list) );
      DUMP_END();
    }
#line 11089 "parser.c"
    break;

  case 756: /* typedef_sname_c: typedef_sname_c Y_COLON2 sname_c  */
#line 7564 "parser.y"
    {
      DUMP_START( "typedef_sname_c", "typedef_sname_c '::' sname_c" );
      DUMP_SNAME( "typedef_sname_c", (yyvsp[-2].sname) );
      DUMP_SNAME( "sname_c", (yyvsp[0].sname) );

      //
      // This is for a case like:
      //
      //      define S as struct S
      //      define S::T as struct T
      //
      (yyval.sname) = c_sname_move( &(yyvsp[-2].sname) );
      c_sname_append_sname( &(yyval.sname), &(yyvsp[0].sname) );

      DUMP_SNAME( "typedef_sname_c", (yyval.sname) );
      DUMP_END();
    }
#line 11111 "parser.c"
    break;

  case 757: /* typedef_sname_c: typedef_sname_c Y_COLON2 any_typedef  */
#line 7583 "parser.y"
    {
      DUMP_START( "typedef_sname_c", "typedef_sname_c '::' any_typedef" );
      DUMP_SNAME( "typedef_sname_c", (yyvsp[-2].sname) );
      DUMP_AST( "any_typedef", (yyvsp[0].tdef)->ast );

      //
      // This is for a case like:
      //
      //      define S as struct S
      //      define T as struct T
      //      define S::T as struct S_T
      //
      (yyval.sname) = c_sname_move( &(yyvsp[-2].sname) );
      c_sname_set_local_type( &(yyval.sname), c_sname_local_type( &(yyvsp[0].tdef)->ast->sname ) );
      c_sname_t temp_sname = c_sname_dup( &(yyvsp[0].tdef)->ast->sname );
      c_sname_append_sname( &(yyval.sname), &temp_sname );

      DUMP_SNAME( "typedef_sname_c", (yyval.sname) );
      DUMP_END();
    }
#line 11136 "parser.c"
    break;

  case 758: /* typedef_sname_c: any_typedef  */
#line 7604 "parser.y"
                                  { (yyval.sname) = c_sname_dup( &(yyvsp[0].tdef)->ast->sname ); }
#line 11142 "parser.c"
    break;

  case 760: /* address_exp: error  */
#line 7614 "parser.y"
    {
      keyword_expected( L_address );
    }
#line 11150 "parser.c"
    break;

  case 762: /* array_exp: error  */
#line 7622 "parser.y"
    {
      keyword_expected( L_array );
    }
#line 11158 "parser.c"
    break;

  case 763: /* as_exp: Y_as  */
#line 7629 "parser.y"
    {
      if ( OPT_LANG_IS( CPP_ANY ) ) {
        //
        // For either "declare" or "define", neither "override" nor "final"
        // must be matched initially to allow for cases like:
        //
        //      c++decl> declare final as int
        //      int final;
        //
        // (which is legal).  However, in C++, after parsing "as", the keyword
        // context has to be set to C_KW_CTX_MBR_FUNC to be able to match
        // "override" and "final", e.g.:
        //
        //      c++decl> declare f as final function
        //      void f() final;
        //
        lexer_keyword_ctx = C_KW_CTX_MBR_FUNC;
      }
    }
#line 11182 "parser.c"
    break;

  case 764: /* as_exp: error  */
#line 7649 "parser.y"
    {
      keyword_expected( L_as );
    }
#line 11190 "parser.c"
    break;

  case 768: /* as_into_to_exp: error  */
#line 7659 "parser.y"
    {
      elaborate_error( "\"as\", \"into\", or \"to\" expected" );
    }
#line 11198 "parser.c"
    break;

  case 778: /* cast_exp: error  */
#line 7684 "parser.y"
    {
      keyword_expected( L_cast );
    }
#line 11206 "parser.c"
    break;

  case 780: /* char_exp: error  */
#line 7692 "parser.y"
    {
      keyword_expected( L_char );
    }
#line 11214 "parser.c"
    break;

  case 782: /* class_struct_union_btid_exp: error  */
#line 7700 "parser.y"
    {
      elaborate_error( "\"class\", \"struct\", or \"union\" expected" );
    }
#line 11222 "parser.c"
    break;

  case 784: /* colon_exp: error  */
#line 7708 "parser.y"
    {
      punct_expected( ':' );
    }
#line 11230 "parser.c"
    break;

  case 786: /* comma_exp: error  */
#line 7716 "parser.y"
    {
      punct_expected( ',' );
    }
#line 11238 "parser.c"
    break;

  case 788: /* conversion_exp: error  */
#line 7724 "parser.y"
    {
      keyword_expected( L_conversion );
    }
#line 11246 "parser.c"
    break;

  case 789: /* c_operator: Y_co_await  */
#line 7730 "parser.y"
                                  { (yyval.oper_id) = C_OP_CO_AWAIT          ; }
#line 11252 "parser.c"
    break;

  case 790: /* c_operator: Y_new  */
#line 7731 "parser.y"
                                  { (yyval.oper_id) = C_OP_NEW               ; }
#line 11258 "parser.c"
    break;

  case 791: /* c_operator: Y_new '[' rbracket_exp  */
#line 7732 "parser.y"
                                  { (yyval.oper_id) = C_OP_NEW_ARRAY         ; }
#line 11264 "parser.c"
    break;

  case 792: /* c_operator: Y_delete  */
#line 7733 "parser.y"
                                  { (yyval.oper_id) = C_OP_DELETE            ; }
#line 11270 "parser.c"
    break;

  case 793: /* c_operator: Y_delete '[' rbracket_exp  */
#line 7734 "parser.y"
                                  { (yyval.oper_id) = C_OP_DELETE_ARRAY      ; }
#line 11276 "parser.c"
    break;

  case 794: /* c_operator: Y_EXCLAM  */
#line 7735 "parser.y"
                                  { (yyval.oper_id) = C_OP_EXCLAM            ; }
#line 11282 "parser.c"
    break;

  case 795: /* c_operator: Y_EXCLAM_EQUAL  */
#line 7736 "parser.y"
                                  { (yyval.oper_id) = C_OP_EXCLAM_EQUAL      ; }
#line 11288 "parser.c"
    break;

  case 796: /* c_operator: '%'  */
#line 7737 "parser.y"
                                  { (yyval.oper_id) = C_OP_PERCENT           ; }
#line 11294 "parser.c"
    break;

  case 797: /* c_operator: Y_PERCENT_EQUAL  */
#line 7738 "parser.y"
                                  { (yyval.oper_id) = C_OP_PERCENT_EQUAL     ; }
#line 11300 "parser.c"
    break;

  case 798: /* c_operator: Y_AMPER  */
#line 7739 "parser.y"
                                  { (yyval.oper_id) = C_OP_AMPER             ; }
#line 11306 "parser.c"
    break;

  case 799: /* c_operator: Y_AMPER2  */
#line 7740 "parser.y"
                                  { (yyval.oper_id) = C_OP_AMPER2            ; }
#line 11312 "parser.c"
    break;

  case 800: /* c_operator: Y_AMPER_EQUAL  */
#line 7741 "parser.y"
                                  { (yyval.oper_id) = C_OP_AMPER_EQUAL       ; }
#line 11318 "parser.c"
    break;

  case 801: /* c_operator: '(' rparen_exp  */
#line 7742 "parser.y"
                                  { (yyval.oper_id) = C_OP_PARENS            ; }
#line 11324 "parser.c"
    break;

  case 802: /* c_operator: '*'  */
#line 7743 "parser.y"
                                  { (yyval.oper_id) = C_OP_STAR              ; }
#line 11330 "parser.c"
    break;

  case 803: /* c_operator: Y_STAR_EQUAL  */
#line 7744 "parser.y"
                                  { (yyval.oper_id) = C_OP_STAR_EQUAL        ; }
#line 11336 "parser.c"
    break;

  case 804: /* c_operator: '+'  */
#line 7745 "parser.y"
                                  { (yyval.oper_id) = C_OP_PLUS              ; }
#line 11342 "parser.c"
    break;

  case 805: /* c_operator: "++"  */
#line 7746 "parser.y"
                                  { (yyval.oper_id) = C_OP_PLUS2             ; }
#line 11348 "parser.c"
    break;

  case 806: /* c_operator: Y_PLUS_EQUAL  */
#line 7747 "parser.y"
                                  { (yyval.oper_id) = C_OP_PLUS_EQUAL        ; }
#line 11354 "parser.c"
    break;

  case 807: /* c_operator: ','  */
#line 7748 "parser.y"
                                  { (yyval.oper_id) = C_OP_COMMA             ; }
#line 11360 "parser.c"
    break;

  case 808: /* c_operator: '-'  */
#line 7749 "parser.y"
                                  { (yyval.oper_id) = C_OP_MINUS             ; }
#line 11366 "parser.c"
    break;

  case 809: /* c_operator: "--"  */
#line 7750 "parser.y"
                                  { (yyval.oper_id) = C_OP_MINUS2            ; }
#line 11372 "parser.c"
    break;

  case 810: /* c_operator: Y_MINUS_EQUAL  */
#line 7751 "parser.y"
                                  { (yyval.oper_id) = C_OP_MINUS_EQUAL       ; }
#line 11378 "parser.c"
    break;

  case 811: /* c_operator: Y_ARROW  */
#line 7752 "parser.y"
                                  { (yyval.oper_id) = C_OP_ARROW             ; }
#line 11384 "parser.c"
    break;

  case 812: /* c_operator: Y_ARROW_STAR  */
#line 7753 "parser.y"
                                  { (yyval.oper_id) = C_OP_ARROW_STAR        ; }
#line 11390 "parser.c"
    break;

  case 813: /* c_operator: '.'  */
#line 7754 "parser.y"
                                  { (yyval.oper_id) = C_OP_DOT               ; }
#line 11396 "parser.c"
    break;

  case 814: /* c_operator: Y_DOT_STAR  */
#line 7755 "parser.y"
                                  { (yyval.oper_id) = C_OP_DOT_STAR          ; }
#line 11402 "parser.c"
    break;

  case 815: /* c_operator: '/'  */
#line 7756 "parser.y"
                                  { (yyval.oper_id) = C_OP_SLASH             ; }
#line 11408 "parser.c"
    break;

  case 816: /* c_operator: Y_SLASH_EQUAL  */
#line 7757 "parser.y"
                                  { (yyval.oper_id) = C_OP_SLASH_EQUAL       ; }
#line 11414 "parser.c"
    break;

  case 817: /* c_operator: Y_COLON2  */
#line 7758 "parser.y"
                                  { (yyval.oper_id) = C_OP_COLON2            ; }
#line 11420 "parser.c"
    break;

  case 818: /* c_operator: '<'  */
#line 7759 "parser.y"
                                  { (yyval.oper_id) = C_OP_LESS              ; }
#line 11426 "parser.c"
    break;

  case 819: /* c_operator: Y_LESS2  */
#line 7760 "parser.y"
                                  { (yyval.oper_id) = C_OP_LESS2             ; }
#line 11432 "parser.c"
    break;

  case 820: /* c_operator: Y_LESS2_EQUAL  */
#line 7761 "parser.y"
                                  { (yyval.oper_id) = C_OP_LESS2_EQUAL       ; }
#line 11438 "parser.c"
    break;

  case 821: /* c_operator: Y_LESS_EQUAL  */
#line 7762 "parser.y"
                                  { (yyval.oper_id) = C_OP_LESS_EQUAL        ; }
#line 11444 "parser.c"
    break;

  case 822: /* c_operator: Y_LESS_EQUAL_GREATER  */
#line 7763 "parser.y"
                                  { (yyval.oper_id) = C_OP_LESS_EQUAL_GREATER; }
#line 11450 "parser.c"
    break;

  case 823: /* c_operator: '='  */
#line 7764 "parser.y"
                                  { (yyval.oper_id) = C_OP_EQUAL             ; }
#line 11456 "parser.c"
    break;

  case 824: /* c_operator: Y_EQUAL2  */
#line 7765 "parser.y"
                                  { (yyval.oper_id) = C_OP_EQUAL2            ; }
#line 11462 "parser.c"
    break;

  case 825: /* c_operator: '>'  */
#line 7766 "parser.y"
                                  { (yyval.oper_id) = C_OP_GREATER           ; }
#line 11468 "parser.c"
    break;

  case 826: /* c_operator: Y_GREATER2  */
#line 7767 "parser.y"
                                  { (yyval.oper_id) = C_OP_GREATER2          ; }
#line 11474 "parser.c"
    break;

  case 827: /* c_operator: Y_GREATER2_EQUAL  */
#line 7768 "parser.y"
                                  { (yyval.oper_id) = C_OP_GREATER2_EQUAL    ; }
#line 11480 "parser.c"
    break;

  case 828: /* c_operator: Y_GREATER_EQUAL  */
#line 7769 "parser.y"
                                  { (yyval.oper_id) = C_OP_GREATER_EQUAL     ; }
#line 11486 "parser.c"
    break;

  case 829: /* c_operator: Y_QMARK_COLON  */
#line 7770 "parser.y"
                                  { (yyval.oper_id) = C_OP_QMARK_COLON       ; }
#line 11492 "parser.c"
    break;

  case 830: /* c_operator: '[' rbracket_exp  */
#line 7771 "parser.y"
                                  { (yyval.oper_id) = C_OP_BRACKETS          ; }
#line 11498 "parser.c"
    break;

  case 831: /* c_operator: Y_CARET  */
#line 7772 "parser.y"
                                  { (yyval.oper_id) = C_OP_CARET             ; }
#line 11504 "parser.c"
    break;

  case 832: /* c_operator: Y_CARET_EQUAL  */
#line 7773 "parser.y"
                                  { (yyval.oper_id) = C_OP_CARET_EQUAL       ; }
#line 11510 "parser.c"
    break;

  case 833: /* c_operator: Y_PIPE  */
#line 7774 "parser.y"
                                  { (yyval.oper_id) = C_OP_PIPE              ; }
#line 11516 "parser.c"
    break;

  case 834: /* c_operator: Y_PIPE2  */
#line 7775 "parser.y"
                                  { (yyval.oper_id) = C_OP_PIPE2             ; }
#line 11522 "parser.c"
    break;

  case 835: /* c_operator: Y_PIPE_EQUAL  */
#line 7776 "parser.y"
                                  { (yyval.oper_id) = C_OP_PIPE_EQUAL        ; }
#line 11528 "parser.c"
    break;

  case 836: /* c_operator: Y_TILDE  */
#line 7777 "parser.y"
                                  { (yyval.oper_id) = C_OP_TILDE             ; }
#line 11534 "parser.c"
    break;

  case 838: /* default_exp: error  */
#line 7783 "parser.y"
    {
      keyword_expected( L_default );
    }
#line 11542 "parser.c"
    break;

  case 840: /* defined_exp: error  */
#line 7791 "parser.y"
    {
      keyword_expected( L_defined );
    }
#line 11550 "parser.c"
    break;

  case 842: /* dependency_exp: error  */
#line 7799 "parser.y"
    {
      keyword_expected( L_dependency );
    }
#line 11558 "parser.c"
    break;

  case 844: /* destructor_sname: Y_LEXER_ERROR  */
#line 7807 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      PARSE_ABORT();
    }
#line 11567 "parser.c"
    break;

  case 846: /* equals_exp: error  */
#line 7816 "parser.y"
    {
      punct_expected( '=' );
    }
#line 11575 "parser.c"
    break;

  case 847: /* extern_linkage_c_stid: Y_extern linkage_stid  */
#line 7822 "parser.y"
                                  { (yyval.tid) = (yyvsp[0].tid); }
#line 11581 "parser.c"
    break;

  case 848: /* extern_linkage_c_stid: Y_extern linkage_stid '{'  */
#line 7824 "parser.y"
    {
      print_error( &(yylsp[0]),
        "scoped linkage declarations not supported by %s\n", CDECL
      );
      PARSE_ABORT();
    }
#line 11592 "parser.c"
    break;

  case 849: /* extern_linkage_c_stid_opt: %empty  */
#line 7833 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 11598 "parser.c"
    break;

  case 851: /* glob: Y_GLOB  */
#line 7839 "parser.y"
    {
      if ( !OPT_LANG_IS( SCOPED_NAMES ) && strchr( (yyvsp[0].name), ':' ) != NULL ) {
        print_error( &(yylsp[0]),
          "scoped names not supported%s\n",
          C_LANG_WHICH( SCOPED_NAMES )
        );
        free( (yyvsp[0].name) );
        PARSE_ABORT();
      }
      (yyval.name) = (yyvsp[0].name);
    }
#line 11614 "parser.c"
    break;

  case 852: /* glob_opt: %empty  */
#line 7853 "parser.y"
                                  { (yyval.name) = NULL; }
#line 11620 "parser.c"
    break;

  case 855: /* gt_exp: error  */
#line 7860 "parser.y"
    {
      punct_expected( '>' );
    }
#line 11628 "parser.c"
    break;

  case 856: /* inline_stid_opt: %empty  */
#line 7866 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 11634 "parser.c"
    break;

  case 859: /* int_exp: error  */
#line 7873 "parser.y"
    {
      elaborate_error( "int[eger] expected" );
    }
#line 11642 "parser.c"
    break;

  case 861: /* int_lit_exp: error  */
#line 7881 "parser.y"
    {
      elaborate_error( "integer literal expected" );
    }
#line 11650 "parser.c"
    break;

  case 862: /* int_lit_opt: %empty  */
#line 7887 "parser.y"
                                  { (yyval.int_val) = 0; }
#line 11656 "parser.c"
    break;

  case 865: /* literal_exp: error  */
#line 7894 "parser.y"
    {
      keyword_expected( L_literal );
    }
#line 11664 "parser.c"
    break;

  case 867: /* local_exp: error  */
#line 7902 "parser.y"
    {
      keyword_expected( L_local );
    }
#line 11672 "parser.c"
    break;

  case 869: /* lparen_exp: error  */
#line 7910 "parser.y"
    {
      punct_expected( '(' );
    }
#line 11680 "parser.c"
    break;

  case 871: /* lt_exp: error  */
#line 7918 "parser.y"
    {
      punct_expected( '<' );
    }
#line 11688 "parser.c"
    break;

  case 872: /* member_or_non_member_opt: %empty  */
#line 7924 "parser.y"
                                  { (yyval.member) = C_FUNC_UNSPECIFIED; }
#line 11694 "parser.c"
    break;

  case 873: /* member_or_non_member_opt: Y_member  */
#line 7925 "parser.y"
                                  { (yyval.member) = C_FUNC_MEMBER     ; }
#line 11700 "parser.c"
    break;

  case 874: /* member_or_non_member_opt: Y_non_member  */
#line 7926 "parser.y"
                                  { (yyval.member) = C_FUNC_NON_MEMBER ; }
#line 11706 "parser.c"
    break;

  case 876: /* namespace_btid_exp: error  */
#line 7932 "parser.y"
    {
      keyword_expected( L_namespace );
    }
#line 11714 "parser.c"
    break;

  case 877: /* namespace_type: Y_namespace  */
#line 7938 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 11720 "parser.c"
    break;

  case 878: /* namespace_type: Y_inline namespace_btid_exp  */
#line 7939 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT( (yyvsp[0].tid), (yyvsp[-1].tid), TA_NONE ); }
#line 11726 "parser.c"
    break;

  case 880: /* of_exp: error  */
#line 7945 "parser.y"
    {
      keyword_expected( L_of );
    }
#line 11734 "parser.c"
    break;

  case 881: /* of_scope_english: Y_of scope_english_type_exp any_sname_c_exp  */
#line 7952 "parser.y"
    { //
      // Scoped names are supported only in C++.  (However, we always allow
      // them in configuration files.)
      //
      // This check is better to do now in the parser rather than later in the
      // AST because it has to be done in fewer places in the code plus gives a
      // better error location.
      //
      if ( UNSUPPORTED( SCOPED_NAMES ) ) {
        print_error( &(yylsp[-1]),
          "scoped names not supported%s\n",
          C_LANG_WHICH( SCOPED_NAMES )
        );
        c_sname_cleanup( &(yyvsp[0].sname) );
        PARSE_ABORT();
      }
      (yyval.sname) = c_sname_move( &(yyvsp[0].sname) );
      c_sname_set_local_type( &(yyval.sname), &(yyvsp[-1].type) );
    }
#line 11758 "parser.c"
    break;

  case 882: /* of_scope_list_english: of_scope_list_english of_scope_english  */
#line 7975 "parser.y"
    {
      // "of scope X of scope Y" means Y::X
      (yyval.sname) = c_sname_move( &(yyvsp[0].sname) );
      c_sname_append_sname( &(yyval.sname), &(yyvsp[-1].sname) );
      c_sname_fill_in_namespaces( &(yyval.sname) );
      if ( !c_sname_check( &(yyval.sname), &(yylsp[-1]) ) ) {
        c_sname_cleanup( &(yyval.sname) );
        PARSE_ABORT();
      }
    }
#line 11773 "parser.c"
    break;

  case 884: /* of_scope_list_english_opt: %empty  */
#line 7989 "parser.y"
                                  { c_sname_init( &(yyval.sname) ); }
#line 11779 "parser.c"
    break;

  case 887: /* operator_exp: error  */
#line 7996 "parser.y"
    {
      keyword_expected( L_operator );
    }
#line 11787 "parser.c"
    break;

  case 891: /* point_exp: error  */
#line 8009 "parser.y"
    {
      keyword_expected( L_point );
    }
#line 11795 "parser.c"
    break;

  case 895: /* quote2_exp: error  */
#line 8021 "parser.y"
    {
      elaborate_error( "\"\" expected" );
    }
#line 11803 "parser.c"
    break;

  case 897: /* rbrace_exp: error  */
#line 8029 "parser.y"
    {
      punct_expected( '}' );
    }
#line 11811 "parser.c"
    break;

  case 899: /* rbracket_exp: error  */
#line 8037 "parser.y"
    {
      punct_expected( ']' );
    }
#line 11819 "parser.c"
    break;

  case 901: /* reference_exp: error  */
#line 8045 "parser.y"
    {
      keyword_expected( L_reference );
    }
#line 11827 "parser.c"
    break;

  case 905: /* returning_exp: error  */
#line 8058 "parser.y"
    {
      keyword_expected( L_returning );
    }
#line 11835 "parser.c"
    break;

  case 907: /* rparen_exp: error  */
#line 8066 "parser.y"
    {
      punct_expected( ')' );
    }
#line 11843 "parser.c"
    break;

  case 908: /* scope_english_type: class_struct_union_btid  */
#line 8072 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 11849 "parser.c"
    break;

  case 910: /* scope_english_type: Y_scope  */
#line 8074 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( TB_SCOPE ); }
#line 11855 "parser.c"
    break;

  case 912: /* scope_english_type_exp: error  */
#line 8080 "parser.y"
    {
      elaborate_error(
        "\"class\", \"namespace\", \"scope\", \"struct\", or \"union\" expected"
      );
    }
#line 11865 "parser.c"
    break;

  case 914: /* semi_exp: error  */
#line 8090 "parser.y"
    {
      punct_expected( ';' );
    }
#line 11873 "parser.c"
    break;

  case 919: /* static_stid_opt: %empty  */
#line 8106 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 11879 "parser.c"
    break;

  case 920: /* static_stid_opt: Y_static  */
#line 8107 "parser.y"
                                  { (yyval.tid) = TS_NON_EMPTY_ARRAY; }
#line 11885 "parser.c"
    break;

  case 922: /* str_lit: Y_LEXER_ERROR  */
#line 8113 "parser.y"
    {
      (yyval.str_val) = NULL;
      PARSE_ABORT();
    }
#line 11894 "parser.c"
    break;

  case 924: /* str_lit_exp: error  */
#line 8122 "parser.y"
    {
      (yyval.str_val) = NULL;
      elaborate_error( "string literal expected" );
    }
#line 11903 "parser.c"
    break;

  case 926: /* this_exp: error  */
#line 8131 "parser.y"
    {
      keyword_expected( L_this );
    }
#line 11911 "parser.c"
    break;

  case 927: /* this_stid_opt: %empty  */
#line 8137 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 11917 "parser.c"
    break;

  case 930: /* to_exp: error  */
#line 8144 "parser.y"
    {
      keyword_expected( L_to );
    }
#line 11925 "parser.c"
    break;

  case 933: /* typename_flag_opt: %empty  */
#line 8155 "parser.y"
                                  { (yyval.flag) = false; }
#line 11931 "parser.c"
    break;

  case 934: /* typename_flag_opt: Y_typename  */
#line 8156 "parser.y"
                                  { (yyval.flag) = true; }
#line 11937 "parser.c"
    break;

  case 936: /* unused_exp: error  */
#line 8162 "parser.y"
    {
      keyword_expected( L_unused );
    }
#line 11945 "parser.c"
    break;

  case 940: /* virtual_stid_exp: error  */
#line 8175 "parser.y"
    {
      keyword_expected( L_virtual );
    }
#line 11953 "parser.c"
    break;

  case 941: /* virtual_stid_opt: %empty  */
#line 8181 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 11959 "parser.c"
    break;


#line 11963 "parser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 8185 "parser.y"


/// @endcond

// Re-enable warnings.
#ifdef __GNUC__
# pragma GCC diagnostic pop
#endif /* __GNUC__ */

/**
 * @addtogroup parser-group
 * @{
 */

////////// local functions ////////////////////////////////////////////////////

/**
 * Prints an additional parsing error message including a newline to standard
 * error that continues from where yyerror() left off.  Additionally:
 *
 * + If the lexer_printable_token() isn't NULL:
 *     + Checks to see if it's a keyword: if it is, mentions that it's a
 *       keyword in the error message.
 *     + May print "did you mean ...?" \a dym_kinds suggestions.
 *
 * + In debug mode, also prints the file & line where the function was called
 *   from as well as the ID of the lookahead token, if any.
 *
 * @note A newline _is_ printed.
 * @note This function isn't normally called directly; use the
 * #elaborate_error() or #elaborate_error_dym() macros instead.
 *
 * @param file The name of the file where this function was called from.
 * @param line The line number within \a file where this function was called
 * from.
 * @param dym_kinds The bitwise-or of the kind(s) of things possibly meant.
 * @param format A `printf()` style format string.  It _must not_ end in a
 * newline since this function prints its own newline.
 * @param ... Arguments to print.
 *
 * @sa #elaborate_error()
 * @sa #elaborate_error_dym()
 * @sa fl_keyword_expected()
 * @sa fl_punct_expected()
 * @sa yyerror()
 */
PJL_PRINTF_LIKE_FUNC(4)
static void fl_elaborate_error( char const *file, int line,
                                dym_kind_t dym_kinds, char const *format,
                                ... ) {
  assert( format != NULL );

  EPUTS( ": " );
  print_debug_file_line( file, line );

  char const *const error_token = lexer_printable_token();
  if ( error_token != NULL ) {
    EPRINTF( "\"%s\"", error_token );
#ifdef ENABLE_CDECL_DEBUG
    if ( opt_cdecl_debug ) {
      switch ( yychar ) {
        case YYEMPTY:
          EPUTS( " [<empty>]" );
          break;
        case YYEOF:
          EPUTS( " [<EOF>]" );
          break;
        default:
          EPRINTF( " [%d]", yychar );
      } // switch
    }
#endif /* ENABLE_CDECL_DEBUG */
    EPUTS( ": " );
  }

  va_list args;
  va_start( args, format );
  vfprintf( stderr, format, args );
  va_end( args );

  if ( error_token != NULL ) {
    print_is_a_keyword( error_token );
    print_suggestions( dym_kinds, error_token );
  }

  EPUTC( '\n' );
}

////////// extern functions ///////////////////////////////////////////////////

void parser_cleanup( void ) {
  c_ast_list_gc( &typedef_ast_list );
}

///////////////////////////////////////////////////////////////////////////////

/** @} */

/* vim:set et sw=2 ts=2: */
