#include "pjl_config.h"                 /* must go first */

#line 3 "lexer.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 108
#define YY_END_OF_BUFFER 109
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_acclist[596] =
    {   0,
      106,  106,  109,  107,  108,  100,  107,  108,  102,  108,
       62,  107,  108,   89,  107,  108,   99,  107,  108,   68,
      107,  108,   63,  107,  108,   89,  107,  108,   69,  107,
      108,   70,  107,  108,   71,  107,  108,   72,  107,  108,
       73,  107,  108,   74,  107,  108,   75,  107,  108,   76,
      107,  108,   13,  107,  108,   14,  107,  108,   77,  107,
      108,   78,  107,  108,   79,  107,  108,   80,  107,  108,
       81,  107,  108,   67,  107,  108,   11,  107,  108,   11,
      107,  108,   11,  107,  108,   82,  107,  108,  107,  108,
       83,  107,  108,   64,  107,  108,   11,  107,  108,   11,

      107,  108,   11,  107,  108,   11,  107,  108,   11,  107,
      108,   11,  107,  108,   84,  107,  108,   65,  107,  108,
       85,  107,  108,   66,  107,  108,  100,  107,  108,    6,
       11,  107,  108,   94,  107,  108,   94,  100,  107,  108,
       91,  102,  108,   95,  107,  108,   94,   99,  107,  108,
       94,  107,  108,   80,   94,  107,  108,  107,  108,  104,
      107,  108,   99,  104,  107,  108,  104,  107,  108,  103,
      107,  108,   80,  107,  108,  104,  107,  108,  100,  107,
      108,   71,  106,  107,  108,   77,  107,  108,   78,  105,
      107,  108,   11,  106,  107,  108,   11,  106,  107,  108,

       11,  106,  107,  108,   11,  106,  107,  108,   11,  106,
      107,  108,   11,  106,  107,  108,   11,  106,  107,  108,
       11,  106,  107,  108,   11,  106,  107,  108,  100,  107,
      108,    6,   11,  106,  107,  108,   92,  107,  108,   92,
      100,  107,  108,   92,   99,  107,  108,   93,  107,  108,
       92,  107,  108,   80,   92,  107,  108,   96,  107,  108,
       87,  107,  108,   87,  100,  107,  108,   87,  102,  108,
       87,   99,  107,  108,   88,  107,  108,   87,  107,  108,
       80,   87,  107,  108,   87,  107,  108,  100,   35,   36,
       99,   37,   20,   38,   39,   40,   41,   42,   43,   44,

       45,   47,   97,   98,   49,   13,   13,   13,   13,   14,
       14,   14,   14,   34,   22,   19,   21,   50,   52,   54,
       55,   56,   58,   11,   89,   11,   18,  101,   59,   11,
       11,   11,   11,   11,   11,   60,   61,  100,    6,    6,
       94,   94,  100,   94,   99,   94,   97,   94,   98,   90,
       90,  101,  104,   99,  104,   97,  104,   98,  104,  100,
      106,  106,   34,  106,  106,   11,  106,   11,  106,   11,
      106,   11,  106,   11,  106,   11,  106,   11,  106,   11,
      106,   11,  106,  100,    6,   92,   92,  100,   92,   99,
       92,   97,   92,   98,   87,   87,  100,   87,   99,   87,

       97,   87,   98,   87,  101,   46,   48,   98,   13,   12,
       13,   13,   13,   13,   15,   13,   14,   14,   14,   14,
       14,   14,   33,   51,   53,   57,   26,   27,   28,   29,
       32,   30,   31,   86,   11,   10,   11,   11,   11,    6,
        5,    5,   94,   98,   98,  104,  106,  106,  106,  106,
       33,  106,  106,  106,   11,  106,   11,  106,   11,  106,
       11,  106,    5,   92,   98,   87,   98,   12,   12,   12,
       15,   15,   15,   16,   24,   23,   11,   11,   11,   11,
      106,  106,  106,  106,  106,  106,  106,  106,  106,   11,
      106,   11,  106,   11,  106,   11,  106,   12,   12,   12,

       12,   12,   12,   15,   15,   15,   15,   15,   15,    9,
        9,    9,    7,   11,   11,16386,   11,   11,    9,    9,
      106,  106,    9,  106,  106,  106,   11,  106,   11,  106,
    16386,   11,  106,   11,  106,   25,   17,    7,   11,   11,
       11,   11,  106,  106,   11,  106,   11,  106,   11,  106,
       11,  106,   11,   11,   11,   11,  106,  106,   11,  106,
       11,  106,   11,  106,   11,  106,    1,   11,16386,    4,
      106,  106,   11,  106,16386,    9,    9,  106,  106, 8194,
      106,    8,    9,    8,    9,    8,    9,    8,    9,    8,
        9,  106,    8,    9,    3

    } ;

static const flex_int16_t yy_accept[469] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    2,    3,    3,
        3,    3,    3,    3,    3,    4,    6,    9,   11,   14,
       17,   20,   23,   26,   29,   32,   35,   38,   41,   44,
       47,   50,   53,   56,   59,   62,   65,   68,   71,   74,
       77,   80,   83,   86,   89,   91,   94,   97,  100,  103,
      106,  109,  112,  115,  118,  121,  124,  127,  130,  134,
      137,  141,  144,  147,  151,  154,  158,  160,  163,  167,
      170,  173,  176,  179,  182,  186,  189,  193,  197,  201,
      205,  209,  213,  217,  221,  225,  229,  232,  237,  240,
      244,  248,  251,  254,  258,  261,  264,  268,  271,  275,

      278,  281,  285,  288,  289,  290,  291,  292,  293,  294,
      295,  296,  297,  298,  299,  300,  301,  302,  303,  303,
      304,  305,  306,  306,  307,  307,  308,  309,  309,  309,
      310,  310,  310,  311,  312,  313,  313,  314,  314,  315,
      316,  317,  318,  319,  320,  321,  322,  323,  324,  324,
      324,  325,  325,  326,  327,  327,  327,  328,  329,  330,
      331,  331,  332,  333,  334,  335,  336,  337,  338,  339,
      340,  341,  342,  344,  346,  348,  350,  351,  353,  354,
      356,  358,  360,  361,  361,  361,  362,  363,  365,  365,
      366,  368,  368,  370,  372,  374,  376,  378,  380,  382,

      384,  385,  386,  387,  389,  391,  393,  395,  396,  398,
      400,  402,  404,  406,  407,  408,  409,  410,  411,  412,
      413,  414,  414,  415,  415,  416,  417,  418,  419,  420,
      421,  421,  422,  422,  423,  423,  424,  424,  424,  425,
      426,  427,  428,  429,  430,  431,  432,  433,  434,  434,
      434,  435,  436,  437,  438,  439,  440,  441,  442,  443,
      445,  447,  448,  449,  450,  451,  453,  454,  455,  457,
      459,  461,  463,  464,  466,  468,  468,  469,  470,  470,
      471,  471,  471,  472,  473,  473,  474,  474,  475,  476,
      476,  477,  477,  477,  477,  477,  477,  477,  477,  478,

      478,  479,  480,  481,  482,  483,  484,  485,  486,  487,
      488,  489,  490,  492,  494,  496,  498,  499,  500,  501,
      502,  502,  503,  503,  504,  505,  506,  507,  508,  508,
      509,  509,  510,  510,  510,  511,  512,  512,  513,  513,
      513,  513,  514,  515,  517,  518,  519,  520,  522,  523,
      524,  525,  526,  527,  529,  532,  534,  536,  537,  538,
      538,  538,  539,  540,  540,  541,  542,  543,  544,  545,
      547,  547,  549,  551,  553,  553,  553,  554,  554,  554,
      555,  556,  557,  558,  559,  561,  563,  565,  567,  567,
      567,  567,  568,  568,  568,  568,  570,  570,  570,  571,

      572,  573,  573,  576,  576,  576,  577,  577,  577,  577,
      577,  577,  577,  577,  578,  579,  579,  579,  579,  579,
      579,  579,  579,  579,  580,  580,  581,  581,  581,  581,
      581,  582,  584,  586,  588,  588,  588,  588,  588,  590,
      593,  595,  595,  595,  595,  595,  595,  595,  595,  595,
      595,  595,  595,  595,  595,  595,  595,  595,  595,  596,
      596,  596,  596,  596,  596,  596,  596,  596
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    1,    7,    8,    9,   10,
       11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
       20,   20,   20,   20,   20,   21,   22,   23,   24,   25,
       26,   27,   28,    1,   29,   30,   31,   31,   31,   31,
       32,   32,   32,   32,   32,   33,   32,   32,   32,   32,
       32,   34,   32,   32,   35,   32,   36,   37,   32,   38,
       39,   40,   41,   42,   43,    1,   44,   45,   46,   47,

       48,   49,   50,   50,   51,   50,   50,   52,   53,   54,
       55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
       50,   65,   66,   67,   68,   69,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[70] =
    {   0,
        1,    2,    3,    1,    4,    1,    1,    1,    5,    1,
        6,    7,    1,    1,    8,    1,    1,    9,    9,    9,
        9,    9,   10,   11,    1,   12,    1,    1,   13,   13,
       13,   14,   14,   14,   14,   14,   14,   14,    1,   15,
        1,    1,   14,   16,   16,   16,   16,   16,   16,   17,
       18,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       19,   17,   17,   17,   17,    1,    1,    1,   20
    } ;

static const flex_int16_t yy_base[507] =
    {   0,
        0,   68,   69,   74,   79,   87,  127,  195,  196,  198,
      206,  214,   81,  224, 1497, 1937, 1492, 1937, 1467, 1485,
        0,   75,   80, 1937, 1937, 1937, 1462,   84, 1937,   97,
      104,   82,  256,  313,   95, 1937,  222, 1461,  207,   50,
      216,  254,  255,  204, 1483, 1937, 1459,  226,  377, 1424,
     1427, 1419,  261, 1937,  177, 1937, 1937,  212, 1470,    0,
     1468, 1937, 1937,  232,  241,    0, 1466,    0,  259,  250,
     1937, 1937, 1465,  219,  288,  257, 1937,  335,  441,  293,
      294,  474, 1412, 1400, 1383,  304,  295, 1434,    0, 1426,
      264, 1937,  293,    0, 1937,    0, 1425,    0,  268, 1937,

      295,    0, 1385, 1378, 1937, 1937,    0, 1937, 1937, 1937,
     1937, 1937, 1937, 1937, 1937, 1937, 1357, 1937, 1352, 1937,
        0, 1937,  321,  299,  297,  310,  328, 1331,    0,  190,
     1313,  363,    0,  342,  416, 1327,  289, 1309,  294, 1937,
     1937,  365, 1327, 1325, 1937, 1937, 1325, 1937,  463,  366,
      442, 1327, 1937,  443, 1339,  416, 1937, 1937, 1937,  454,
        0,    0, 1276, 1197, 1196,  538, 1937, 1937,  285, 1239,
      468,    0, 1238,  364,    0,  365, 1937, 1937,    0,  445,
        0,  456,  539, 1216,  540,  542,  548,  552,  550,  572,
      544, 1215,  546,  572,  574,    0, 1183, 1190, 1189,    0,

      574,  580,    0, 1232,  377,    0,  379,    0, 1231,  545,
        0,  582,    0, 1937, 1937,    0,  465,  626,  452, 1937,
      553, 1202, 1937, 1186,  578, 1937,  480,  554, 1937,  555,
     1200, 1937, 1184, 1937,  588, 1937,  592, 1205, 1937, 1937,
     1937,   89, 1201,  590, 1937, 1937, 1937, 1937,  555, 1216,
     1937,  597, 1210,  690,  550,  560, 1222, 1937, 1200,  411,
      602,  625,  648,  661,  630,  634,  754,  755,  620, 1163,
     1169, 1164, 1192,  506,  644,  341,  588,  652, 1184,  561,
     1168,    0,  641,  727, 1182,  616, 1166, 1937, 1937, 1182,
     1937,  670, 1181,  716,  824, 1153, 1151, 1198,  663, 1184,

      313,  343,  597,  757,  779,  781,  793,  892,  893,  962,
     1143, 1141,  891, 1136, 1130, 1112,  540,  668, 1937,  662,
     1142, 1937, 1126, 1937,  888,  671, 1937,  735, 1140, 1937,
     1124, 1937, 1164, 1157, 1937,  759,    0, 1143, 1112, 1116,
     1161,    0,  896,  762,  638,  711,  784,  786,    0, 1139,
        0, 1108, 1112,  894,  589, 1101, 1111, 1937, 1937, 1101,
     1098,    0,  904,  906,  640,  741,  749, 1099, 1096, 1027,
      907, 1099, 1104, 1099, 1094, 1100,  933,  732, 1089,  641,
      900, 1032, 1089, 1096, 1033, 1079, 1129,  815, 1128, 1069,
     1031, 1937, 1083, 1052, 1054, 1037,  899,  915, 1937, 1101,

     1042, 1042, 1098, 1043,  929, 1045, 1044, 1045, 1034, 1029,
     1046,  761, 1017, 1047, 1033, 1048, 1049, 1029, 1025,  220,
      881, 1032, 1051, 1025, 1109, 1937, 1031, 1005, 1019, 1023,
     1178, 1937, 1054, 1039, 1000, 1000, 1005, 1067, 1056, 1083,
      938,  895,  890,  886,  889,  878,  863,  842,  775,  765,
      764,  759,  750,  670,  669,  647,  587,  494, 1937,  462,
      402,  353,  276,  279,  149,   75, 1937, 1247, 1267, 1287,
     1307, 1327, 1346, 1365, 1385, 1405, 1425, 1445, 1464, 1482,
     1501, 1521, 1541, 1561, 1581, 1085, 1601, 1606, 1625, 1645,
     1665, 1684, 1702, 1721, 1741, 1760, 1780, 1793, 1811, 1829,

     1129, 1848, 1859, 1877, 1896, 1916
    } ;

static const flex_int16_t yy_def[507] =
    {   0,
      467,    1,  468,  468,  469,  469,  467,    7,  470,  470,
      468,  468,  471,  471,  467,  467,  467,  467,  467,  467,
      472,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      473,  473,  473,  467,  467,  467,  467,  473,  467,   49,
       49,   49,   49,  467,  467,  467,  467,  467,   49,  474,
      474,  467,  467,  475,  474,  474,  476,  477,  478,  477,
      467,  467,  477,  467,  479,  467,  467,  480,  480,   79,
       79,  467,   82,   82,   82,   82,  467,   82,  481,  481,
      482,  467,  481,  481,  467,  483,  483,  483,  484,  467,

      483,  483,  483,  467,  467,  467,  472,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      485,  467,  467,   33,  467,  467,  467,  467,  486,  467,
      467,  467,   34,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      473,  467,  467,  473,  487,  467,  467,  467,  467,  473,
      488,   49,   49,   49,   49,  473,  467,  467,  467,  467,
      489,  474,  474,  475,  474,  490,  467,  467,  477,  478,
      477,  491,  467,  467,  467,  467,  492,  493,  467,  479,
       79,  467,   79,   79,   79,   82,   82,   82,   82,   79,

      467,  489,  481,  481,  482,  481,  494,  483,  483,  484,
      483,  495,  483,  467,  467,  485,  124,  467,  467,  467,
      467,  467,  467,  467,  486,  467,   34,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  496,  497,
      467,  473,  498,  467,  254,  254,  489,  467,  467,  490,
      491,  493,  492,  492,  493,  493,  499,  500,   79,   82,
       82,   82,  467,  494,  495,  467,  467,  467,  467,  467,
      467,  501,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  496,  467,  295,  295,  502,  473,  498,

      254,  254,  254,  493,  493,  493,  499,  499,  500,  467,
      310,  310,   79,   82,   82,   82,  218,  467,  467,  467,
      467,  467,  467,  467,  501,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  295,  467,  295,  295,
      502,  503,  473,  254,  254,  254,  467,  493,  310,  467,
      310,  310,  310,   79,   82,   82,   82,  467,  467,  295,
      295,  503,  473,  467,  254,  254,  254,  310,  310,   79,
      467,   82,   82,   82,  295,  295,  473,  467,  467,  254,
      254,  254,  310,  310,   79,   82,   82,   82,  295,  295,
      467,  467,  467,  467,  467,  254,  504,  467,  467,  310,

      310,  467,   82,  504,  467,  502,  295,  467,  467,  467,
      504,  504,  504,  502,  310,  504,  502,  295,  505,  505,
      505,  504,  502,  310,  295,  467,  467,  467,  467,  504,
      310,  467,  467,  467,  467,  467,  467,  504,  467,  493,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  505,  505,  467,  506,  467,  467,  467,
      467,  467,  467,  467,  505,  506,    0,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,

      467,  467,  467,  467,  467,  467
    } ;

static const flex_int16_t yy_nxt[2007] =
    {   0,
       16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
       26,   27,   28,   29,   30,   31,   32,   33,   34,   34,
       34,   34,   35,   36,   37,   38,   39,   40,   41,   41,
       41,   41,   42,   43,   42,   41,   41,   41,   44,   45,
       46,   47,   48,   49,   49,   50,   51,   49,   49,   49,
       52,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       53,   49,   49,   49,   49,   54,   55,   56,   57,   58,
       61,   62,  148,   63,   64,   61,   62,  149,   63,   64,
       17,   18,   97,   98,   69,   65,   99,  110,   17,   18,
       65,  100,   69,  120,   66,   70,  113,  101,  121,   66,

      108,  109,   71,   70,   72,  111,  102,  122,   67,  114,
       71,  115,   72,   67,  289,  118,  290,  139,   73,  119,
      103,  140,  116,  117,   59,  467,   73,   16,   74,   18,
       19,   20,   21,   22,   23,   24,   25,   26,   75,   28,
       29,   30,   31,   32,   33,   34,   34,   34,   34,   76,
       77,   37,   38,   39,   40,   78,   78,   78,   78,   79,
       80,   79,   78,   78,   78,   44,   45,   46,   47,   81,
       82,   82,   83,   84,   82,   82,   82,   85,   82,   82,
       82,   82,   82,   82,   82,   82,   82,   86,   82,   82,
       82,   82,   54,   55,   56,   57,   87,   90,   62,   90,

       62,   91,  167,   91,   92,  156,   92,   61,   62,  467,
       95,   64,   93,  169,   93,   61,   62,  150,   95,   64,
      183,   94,   65,   94,  226,   97,   98,  150,  141,   99,
       65,   66,  146,  147,  100,   67,  107,   67,  152,   66,
      101,  184,  157,  168,  142,   67,  143,  144,  152,  102,
      226,   88,  175,   67,  160,  150,  150,  176,  153,  155,
      107,  181,  153,  103,  123,  153,  182,  428,  170,  153,
      208,  107,  107,  124,  124,  124,  152,  152,  107,  188,
      467,  166,  107,  140,  107,  125,  169,  154,  126,  185,
      127,  128,  129,  130,  154,  235,  201,  155,  467,  186,

      125,  467,  467,  107,  206,  236,  211,  126,  153,  207,
      184,  212,  153,  112,  218,  218,  127,  184,  131,  129,
      130,  132,  195,  234,  200,  466,  193,  193,  467,  465,
      133,  133,  133,  133,  133,  467,  189,  194,  217,  217,
      217,  170,  219,  467,  220,  134,  190,  135,  136,  234,
      137,  170,  191,  191,  191,  191,  191,  192,  317,  317,
      221,  219,  467,  222,  134,  223,  237,  150,  107,  216,
      220,  162,  344,  135,  228,  138,  229,  137,  150,  221,
      227,  227,  227,  227,  227,  107,  345,  216,  152,  238,
      224,  161,  223,  228,  151,  151,  151,  151,  151,  152,

      464,  162,  229,  107,  216,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  216,  107,  156,  216,  151,
      162,  162,  162,  162,  162,  162,  162,  162,  162,  162,
      162,  162,  162,  162,  162,  162,  162,  162,  162,  162,
      162,  162,  189,  150,  150,  153,  107,  155,  230,  153,
      216,  231,  190,  232,  157,  150,  463,  216,  191,  191,
      191,  191,  191,  192,  152,  152,  242,  230,  107,  171,
      107,  243,  244,  245,  194,  189,  152,  246,  233,  216,
      232,  216,  217,  217,  217,  190,  220,  247,  161,  248,
      259,  191,  191,  191,  191,  191,  192,  227,  227,  227,

      227,  227,  193,  193,  193,  193,  193,  193,  193,  193,
      193,  193,  220,  252,  216,  462,  193,  196,  196,  196,
      196,  196,  196,  196,  196,  196,  196,  196,  196,  196,
      196,  196,  196,  196,  196,  196,  196,  196,  196,  150,
      183,  185,  153,  185,  461,  216,  153,  208,  467,  185,
      467,  189,  467,  265,  467,  107,  294,  317,  317,  190,
      152,  184,  184,  266,  184,  263,  263,  263,  263,  263,
      184,  154,  192,  185,  184,  201,  155,  193,  467,  193,
      467,  202,  467,  467,  208,  223,  282,  232,  229,  235,
      371,  292,  216,  237,  184,  324,  184,  467,  150,  236,

      296,  302,  273,  216,  223,  193,  232,  193,  162,  297,
      283,  303,  284,  285,  229,  286,  238,  293,  162,  152,
      318,  324,  319,  298,  467,  216,  304,  216,  467,  283,
      170,  265,  372,  269,  276,  185,  305,  460,  284,  318,
      287,  266,  286,  218,  218,  467,  208,  184,  319,  185,
      332,  299,  184,  193,  216,  162,  184,  346,  277,  190,
      278,  279,  185,  280,  150,  263,  263,  263,  263,  263,
      184,  292,  190,  326,  313,  327,  332,  277,  263,  263,
      263,  263,  263,  184,  320,  152,  278,  321,  281,  322,
      280,  150,  326,  380,  322,  366,  162,  293,  162,  162,

      396,  327,  319,  320,  161,  327,  458,  151,  151,  151,
      151,  151,  152,  322,  323,  343,  322,  294,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  319,  467,
      467,  327,  151,  162,  162,  162,  162,  162,  162,  162,
      162,  162,  162,  162,  162,  162,  162,  162,  301,  162,
      162,  162,  162,  162,  162,  185,  309,  367,  304,  328,
      150,  296,  329,  364,  330,  306,  305,  330,  305,  162,
      297,  307,  307,  307,  307,  307,  184,  184,  328,  184,
      185,  152,  185,  467,  298,  189,  330,  185,  381,  331,
      467,  330,  467,  393,  185,  394,  382,  467,  457,  162,

      311,  184,  456,  184,  306,  365,  192,  162,  184,  312,
      307,  307,  307,  307,  307,  184,  405,  455,  454,  399,
      162,  413,  453,  298,  335,  336,  335,  335,  335,  335,
      335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
      335,  337,  337,  337,  337,  337,  338,  335,  335,  335,
      335,  335,  337,  337,  337,  337,  337,  337,  337,  337,
      337,  337,  335,  335,  335,  335,  337,  337,  337,  337,
      337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
      337,  337,  337,  337,  337,  337,  337,  337,  337,  335,
      335,  335,  335,  185,  309,  467,  282,  150,  467,  467,

      411,  397,  467,  306,  305,  150,  452,  364,  371,  307,
      307,  307,  307,  307,  184,  184,  398,  451,  152,  399,
      283,  152,  284,  285,  193,  286,  152,  193,  152,  192,
      405,  429,  450,  399,  391,  449,  448,  152,  311,  283,
      447,  467,  392,  354,  370,  446,  363,  312,  284,  377,
      287,  192,  286,  378,  378,  152,  379,  379,  162,  413,
      268,  298,  335,  347,  335,  335,  335,  335,  335,  335,
      335,  335,  335,  348,  335,  335,  335,  335,  335,  349,
      349,  349,  349,  349,  350,  335,  335,  335,  335,  335,
      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,

      335,  335,  335,  335,  351,  351,  351,  351,  351,  351,
      351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
      351,  351,  351,  351,  351,  351,  351,  335,  335,  335,
      335,  467,  391,  398,  402,  467,  399,  467,  364,  467,
      392,  467,  392,  402,  416,  467,  417,  411,  423,  416,
      417,  392,  423,  152,  467,  150,  444,  189,  443,  442,
      193,  249,  437,  436,  192,  192,  193,  152,  152,  192,
      192,  152,  385,  192,  435,  422,  152,  413,  192,  430,
      438,  445,  431,  413,  185,  427,  425,  424,  421,  467,
      162,  420,  413,  225,  467,  162,  419,  225,  418,  371,

      225,  415,  414,  413,  410,  184,  413,  409,  413,  432,
      433,  432,  432,  432,  432,  432,  432,  432,  432,  432,
      432,  432,  432,  432,  432,  432,  408,  413,  407,  406,
      404,  434,  432,  432,  432,  432,  432,  325,  403,  401,
      400,  325,  395,  390,  325,  389,  388,  432,  432,  432,
      432,  387,  386,  384,  383,  376,  375,  374,  373,  369,
      368,  268,  341,  361,  360,  249,  359,  358,  330,  330,
      322,  322,  357,  356,  432,  432,  432,  432,  432,  439,
      432,  432,  432,  432,  432,  432,  432,  432,  432,  440,
      432,  432,  432,  432,  432,  355,  353,  352,  467,  341,

      441,  432,  432,  432,  432,  432,  340,  339,  334,  333,
      327,  327,  319,  319,  268,  316,  432,  432,  432,  432,
      315,  314,  249,  257,  300,  251,  291,  288,  232,  232,
      223,  223,  209,  204,  272,  271,  270,  268,  262,  173,
      257,  256,  255,  432,  432,  432,  432,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   89,   89,   89,
       89,   89,   89,   89,   89,   89,   89,   89,   89,   89,

       89,   89,   89,   89,   89,   89,   89,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,  107,  107,  254,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  151,  251,  249,
      241,  240,  239,  229,  151,  151,  229,  220,  151,  151,
      220,  151,  151,  151,  151,  172,  172,  215,  214,  172,
      172,  172,  172,  172,  172,  172,  172,  172,  172,  104,
      172,  172,  172,  172,  172,  174,  174,  213,  174,  174,
      174,  174,  174,  174,  174,  174,  174,  174,  174,  174,

      174,  174,  174,  174,  174,  177,  177,  177,  177,  177,
      177,  177,  177,  177,  177,  177,  177,  177,  177,  177,
      177,  177,  177,  177,  177,  179,  209,  204,  179,  179,
      179,  179,  179,  179,  179,  202,  199,  179,  179,  179,
      179,  179,  179,  179,  179,  180,  180,  198,  180,  180,
      180,  180,  180,  180,  180,  180,  180,  180,  180,  180,
      180,  180,  180,  180,  180,  187,  197,  158,  178,  173,
      187,  171,  165,  187,  164,  187,  187,  187,  163,  187,
      187,  187,  187,  193,  159,  158,  145,  112,  193,  106,
      193,  193,  105,  104,  193,  193,  467,  193,  193,  193,

      193,  203,  203,  467,  203,  467,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  467,  203,  203,  203,  203,
      203,  205,  205,  467,  205,  205,  205,  205,  205,  205,
      205,  205,  205,  205,  205,  205,  205,  205,  205,  205,
      205,  208,  208,  208,  208,  208,  467,  208,  208,  208,
      208,  208,  208,  208,  208,  208,  208,  208,  208,  208,
      208,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  216,  216,  467,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,

      216,  250,  467,  467,  250,  250,  467,  250,  250,  250,
      250,  250,  250,  250,  250,  467,  250,  250,  250,  250,
      250,  253,  253,  253,  253,  258,  258,  258,  258,  258,
      258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
      258,  258,  258,  258,  258,  260,  260,  467,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  260,  261,  261,  467,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  264,  467,  467,  467,  467,
      264,  467,  264,  264,  467,  467,  264,  264,  467,  264,

      264,  264,  264,  267,  467,  467,  467,  467,  267,  467,
      467,  267,  467,  467,  267,  267,  467,  267,  267,  267,
      267,  274,  274,  467,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  275,  275,  275,  275,  275,  275,  275,  275,  275,
      275,  275,  275,  275,  275,  275,  275,  275,  275,  275,
      275,  295,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  295,  295,  467,  295,  295,  295,  295,  295,
      250,  467,  467,  250,  250,  467,  250,  250,  250,  250,
      250,  250,  250,  250,  467,  250,  250,  250,  250,  250,

      253,  467,  467,  467,  467,  467,  467,  467,  253,  253,
      253,  253,  308,  467,  467,  467,  467,  308,  467,  308,
      308,  467,  467,  308,  308,  467,  308,  308,  308,  308,
      310,  467,  467,  467,  467,  310,  467,  467,  310,  467,
      467,  310,  310,  467,  310,  310,  310,  310,  310,  342,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      342,  342,  467,  342,  342,  342,  342,  362,  467,  467,
      467,  362,  362,  467,  362,  362,  362,  362,  412,  467,
      467,  467,  467,  467,  467,  467,  412,  467,  467,  412,
      412,  467,  412,  412,  412,  412,  426,  426,  426,  426,

      426,  426,  426,  426,  467,  426,  426,  426,  467,  467,
      426,  467,  467,  467,  426,  426,  459,  459,  459,  459,
      459,  459,  459,  459,  467,  459,  459,  459,  467,  467,
      459,  467,  467,  459,  467,  459,   15,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,

      467,  467,  467,  467,  467,  467
    } ;

static const flex_int16_t yy_chk[2007] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    2,
        3,    3,   40,    3,    3,    4,    4,   40,    4,    4,
        5,    5,   13,   13,    5,    3,   13,   23,    6,    6,
        4,   13,    6,   32,    3,    5,   28,   13,   32,    4,

       22,   22,    5,    6,    5,   23,   13,   32,    3,   28,
        6,   30,    6,    4,  242,   31,  242,   35,    5,   31,
       13,   35,   30,   30,    2,  466,    6,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    8,    9,    9,   10,

       10,    9,   55,   10,    9,   44,   10,   11,   11,  465,
       11,   11,    9,   58,   10,   12,   12,   41,   12,   12,
       74,    9,   11,   10,  130,   14,   14,   48,   37,   14,
       12,   11,   39,   39,   14,    9,   64,   10,   41,   12,
       14,   74,   44,   55,   37,   11,   37,   37,   48,   14,
      130,    8,   65,   12,   48,   42,   43,   65,   42,   43,
       69,   70,   42,   14,   33,   53,   70,  420,   58,   53,
       99,   64,   91,   33,   33,   33,   42,   43,   99,   76,
      420,   53,   69,   76,   69,   33,  169,   42,   33,   75,
       33,   33,   33,   33,   53,  139,   87,   80,   81,   75,

       33,   80,   81,   91,   93,  139,  101,   33,   86,   93,
       75,  101,   86,   75,  125,  125,   33,   87,   33,   33,
       33,   34,   81,  137,   86,  464,   80,   81,  124,  463,
       34,   34,   34,   34,   34,  124,   78,   86,  123,  123,
      123,  169,  126,  124,  126,   34,   78,   34,   34,  137,
       34,   87,   78,   78,   78,   78,   78,   78,  276,  276,
      127,  126,  124,  127,   34,  127,  142,  150,  174,  176,
      126,  301,  301,   34,  134,   34,  134,   34,   49,  127,
      132,  132,  132,  132,  132,  205,  302,  207,  150,  142,
      127,   49,  127,  134,   49,   49,   49,   49,   49,   49,

      462,  302,  134,  174,  176,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,  260,  205,  156,  207,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   79,  151,  154,   79,  180,  154,  135,   79,
      260,  135,   79,  135,  156,  160,  461,  182,   79,   79,
       79,   79,   79,   79,  151,  154,  149,  135,  180,  171,
      180,  149,  149,  149,   79,   82,  160,  149,  135,  182,
      135,  182,  217,  217,  217,   82,  219,  149,   82,  149,
      171,   82,   82,   82,   82,   82,   82,  227,  227,  227,

      227,  227,   82,   82,   82,   82,   82,   82,   82,   82,
       82,   82,  219,  160,  274,  460,   82,   82,   82,   82,
       82,   82,   82,   82,   82,   82,   82,   82,   82,   82,
       82,   82,   82,   82,   82,   82,   82,   82,   82,  166,
      183,  185,  166,  186,  458,  274,  166,  210,  191,  187,
      193,  189,  191,  188,  193,  210,  249,  317,  317,  187,
      166,  183,  185,  188,  186,  187,  187,  187,  187,  187,
      187,  166,  189,  190,  188,  201,  194,  191,  195,  193,
      194,  202,  195,  190,  212,  221,  225,  230,  228,  235,
      355,  244,  212,  237,  190,  280,  201,  190,  252,  235,

      249,  255,  202,  261,  221,  194,  230,  195,  255,  249,
      225,  256,  225,  225,  228,  225,  237,  244,  256,  252,
      277,  280,  277,  249,  269,  261,  262,  261,  269,  225,
      201,  265,  355,  195,  218,  266,  262,  457,  225,  277,
      225,  265,  225,  218,  218,  266,  275,  262,  277,  263,
      286,  252,  265,  269,  275,  303,  266,  303,  218,  263,
      218,  218,  264,  218,  299,  263,  263,  263,  263,  263,
      263,  292,  264,  283,  269,  283,  286,  218,  264,  264,
      264,  264,  264,  264,  278,  299,  218,  278,  218,  278,
      218,  254,  283,  365,  320,  345,  345,  292,  365,  380,

      380,  283,  318,  278,  254,  326,  456,  254,  254,  254,
      254,  254,  254,  320,  278,  299,  278,  294,  254,  254,
      254,  254,  254,  254,  254,  254,  254,  254,  318,  455,
      454,  326,  254,  254,  254,  254,  254,  254,  254,  254,
      254,  254,  254,  254,  254,  254,  254,  254,  254,  254,
      254,  254,  254,  254,  254,  267,  268,  346,  304,  284,
      336,  294,  284,  344,  284,  267,  268,  328,  304,  346,
      294,  267,  267,  267,  267,  267,  267,  268,  284,  304,
      305,  336,  306,  412,  294,  347,  328,  348,  366,  284,
      305,  284,  306,  378,  307,  378,  367,  348,  453,  366,

      268,  305,  452,  306,  307,  344,  347,  367,  348,  268,
      307,  307,  307,  307,  307,  307,  388,  451,  450,  388,
      344,  412,  449,  268,  295,  295,  295,  295,  295,  295,
      295,  295,  295,  295,  295,  295,  295,  295,  295,  295,
      295,  295,  295,  295,  295,  295,  295,  295,  295,  295,
      295,  295,  295,  295,  295,  295,  295,  295,  295,  295,
      295,  295,  295,  295,  295,  295,  295,  295,  295,  295,
      295,  295,  295,  295,  295,  295,  295,  295,  295,  295,
      295,  295,  295,  295,  295,  295,  295,  295,  295,  295,
      295,  295,  295,  308,  309,  313,  325,  343,  354,  313,

      397,  381,  354,  308,  309,  363,  448,  364,  371,  308,
      308,  308,  308,  308,  308,  309,  398,  447,  343,  398,
      325,  397,  325,  325,  313,  325,  363,  354,  364,  371,
      405,  421,  446,  405,  377,  445,  444,  398,  309,  325,
      443,  421,  377,  313,  354,  442,  343,  309,  325,  363,
      325,  405,  325,  364,  371,  377,  364,  371,  381,  397,
      441,  309,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,

      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  370,  391,  382,  385,  370,  382,  385,  396,  413,
      391,  385,  385,  402,  404,  430,  406,  411,  414,  416,
      417,  402,  423,  391,  422,  433,  437,  439,  436,  435,
      370,  434,  429,  428,  402,  404,  385,  406,  411,  414,
      416,  417,  370,  423,  427,  413,  433,  413,  439,  422,
      430,  438,  424,  430,  440,  419,  418,  415,  410,  438,
      382,  409,  422,  486,  440,  396,  408,  486,  407,  403,

      486,  401,  400,  404,  395,  440,  411,  394,  416,  425,
      425,  425,  425,  425,  425,  425,  425,  425,  425,  425,
      425,  425,  425,  425,  425,  425,  393,  438,  390,  389,
      387,  425,  425,  425,  425,  425,  425,  501,  386,  384,
      383,  501,  379,  376,  501,  375,  374,  425,  425,  425,
      425,  373,  372,  369,  368,  361,  360,  357,  356,  353,
      352,  350,  341,  340,  339,  338,  334,  333,  331,  329,
      323,  321,  316,  315,  425,  425,  425,  425,  431,  431,
      431,  431,  431,  431,  431,  431,  431,  431,  431,  431,
      431,  431,  431,  431,  431,  314,  312,  311,  300,  298,

      431,  431,  431,  431,  431,  431,  297,  296,  293,  290,
      287,  285,  281,  279,  273,  272,  431,  431,  431,  431,
      271,  270,  259,  257,  253,  250,  243,  238,  233,  231,
      224,  222,  209,  204,  199,  198,  197,  192,  184,  173,
      170,  165,  164,  431,  431,  431,  431,  468,  468,  468,
      468,  468,  468,  468,  468,  468,  468,  468,  468,  468,
      468,  468,  468,  468,  468,  468,  468,  469,  469,  469,
      469,  469,  469,  469,  469,  469,  469,  469,  469,  469,
      469,  469,  469,  469,  469,  469,  469,  470,  470,  470,
      470,  470,  470,  470,  470,  470,  470,  470,  470,  470,

      470,  470,  470,  470,  470,  470,  470,  471,  471,  471,
      471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
      471,  471,  471,  471,  471,  471,  471,  472,  472,  163,
      472,  472,  472,  472,  472,  472,  472,  472,  472,  472,
      472,  472,  472,  472,  472,  472,  472,  473,  155,  152,
      147,  144,  143,  138,  473,  473,  136,  131,  473,  473,
      128,  473,  473,  473,  473,  474,  474,  119,  117,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  104,
      474,  474,  474,  474,  474,  475,  475,  103,  475,  475,
      475,  475,  475,  475,  475,  475,  475,  475,  475,  475,

      475,  475,  475,  475,  475,  476,  476,  476,  476,  476,
      476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
      476,  476,  476,  476,  476,  477,   97,   90,  477,  477,
      477,  477,  477,  477,  477,   88,   85,  477,  477,  477,
      477,  477,  477,  477,  477,  478,  478,   84,  478,  478,
      478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
      478,  478,  478,  478,  478,  479,   83,   73,   67,   61,
      479,   59,   52,  479,   51,  479,  479,  479,   50,  479,
      479,  479,  479,  480,   47,   45,   38,   27,  480,   20,
      480,  480,   19,   17,  480,  480,   15,  480,  480,  480,

      480,  481,  481,    0,  481,    0,  481,  481,  481,  481,
      481,  481,  481,  481,  481,    0,  481,  481,  481,  481,
      481,  482,  482,    0,  482,  482,  482,  482,  482,  482,
      482,  482,  482,  482,  482,  482,  482,  482,  482,  482,
      482,  483,  483,  483,  483,  483,    0,  483,  483,  483,
      483,  483,  483,  483,  483,  483,  483,  483,  483,  483,
      483,  484,  484,  484,  484,  484,  484,  484,  484,  484,
      484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
      484,  485,  485,    0,  485,  485,  485,  485,  485,  485,
      485,  485,  485,  485,  485,  485,  485,  485,  485,  485,

      485,  487,    0,    0,  487,  487,    0,  487,  487,  487,
      487,  487,  487,  487,  487,    0,  487,  487,  487,  487,
      487,  488,  488,  488,  488,  489,  489,  489,  489,  489,
      489,  489,  489,  489,  489,  489,  489,  489,  489,  489,
      489,  489,  489,  489,  489,  490,  490,    0,  490,  490,
      490,  490,  490,  490,  490,  490,  490,  490,  490,  490,
      490,  490,  490,  490,  490,  491,  491,    0,  491,  491,
      491,  491,  491,  491,  491,  491,  491,  491,  491,  491,
      491,  491,  491,  491,  491,  492,    0,    0,    0,    0,
      492,    0,  492,  492,    0,    0,  492,  492,    0,  492,

      492,  492,  492,  493,    0,    0,    0,    0,  493,    0,
        0,  493,    0,    0,  493,  493,    0,  493,  493,  493,
      493,  494,  494,    0,  494,  494,  494,  494,  494,  494,
      494,  494,  494,  494,  494,  494,  494,  494,  494,  494,
      494,  495,  495,  495,  495,  495,  495,  495,  495,  495,
      495,  495,  495,  495,  495,  495,  495,  495,  495,  495,
      495,  496,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  496,  496,    0,  496,  496,  496,  496,  496,
      497,    0,    0,  497,  497,    0,  497,  497,  497,  497,
      497,  497,  497,  497,    0,  497,  497,  497,  497,  497,

      498,    0,    0,    0,    0,    0,    0,    0,  498,  498,
      498,  498,  499,    0,    0,    0,    0,  499,    0,  499,
      499,    0,    0,  499,  499,    0,  499,  499,  499,  499,
      500,    0,    0,    0,    0,  500,    0,    0,  500,    0,
        0,  500,  500,    0,  500,  500,  500,  500,  500,  502,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      502,  502,    0,  502,  502,  502,  502,  503,    0,    0,
        0,  503,  503,    0,  503,  503,  503,  503,  504,    0,
        0,    0,    0,    0,    0,    0,  504,    0,    0,  504,
      504,    0,  504,  504,  504,  504,  505,  505,  505,  505,

      505,  505,  505,  505,    0,  505,  505,  505,    0,    0,
      505,    0,    0,    0,  505,  505,  506,  506,  506,  506,
      506,  506,  506,  506,    0,  506,  506,  506,    0,    0,
      506,    0,    0,  506,    0,  506,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
      467,  467,  467,  467,  467,  467,  467,  467,  467,  467,

      467,  467,  467,  467,  467,  467
    } ;

/* Table of booleans, true if rule could match eol. */
static const flex_int32_t yy_rule_can_match_eol[109] =
    {   0,
0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 1, 1, 0, 0, 0, 0, 0, 0,     };

extern int yy_flex_debug;
int yy_flex_debug = 0;

static yy_state_type *yy_state_buf=0, *yy_state_ptr=0;
static char *yy_full_match;
static int yy_lp;
static int yy_looking_for_trail_begin = 0;
static int yy_full_lp;
static int *yy_full_state;
#define YY_TRAILING_MASK 0x2000
#define YY_TRAILING_HEAD_MASK 0x4000
#define REJECT \
{ \
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */ \
yy_cp = (yy_full_match); /* restore poss. backed-over text */ \
(yy_lp) = (yy_full_lp); /* restore orig. accepting pos. */ \
(yy_state_ptr) = (yy_full_state); /* restore orig. state */ \
yy_current_state = *(yy_state_ptr); /* restore curr. state */ \
++(yy_lp); \
goto find_rule; \
}

#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lexer.l"
/*
**      cdecl -- C gibberish translator
**      src/lexer.l
**
**      Copyright (C) 2017-2023  Paul J. Lucas, et al.
**
**      This program is free software: you can redistribute it and/or modify
**      it under the terms of the GNU General Public License as published by
**      the Free Software Foundation, either version 3 of the License, or
**      (at your option) any later version.
**
**      This program is distributed in the hope that it will be useful,
**      but WITHOUT ANY WARRANTY; without even the implied warranty of
**      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**      GNU General Public License for more details.
**
**      You should have received a copy of the GNU General Public License
**      along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/**
 * @file
 * Defines helper macros, data structures, variables, functions, and the
 * tokenizer for C/C++ declarations.
 */
/** @cond DOXYGEN_IGNORE */

#line 37 "lexer.l"
/** @endcond */

// local
#include "lexer.h"
#include "c_keyword.h"
#include "c_lang.h"
#include "c_typedef.h"
#include "cdecl.h"
#include "cdecl_keyword.h"
#include "gibberish.h"
#include "literals.h"
#include "options.h"
#include "print.h"
#include "red_black.h"
#include "slist.h"
#include "strbuf.h"
#include "util.h"
#include "cdecl_parser.h"               /* must go last */

/// @cond DOXYGEN_IGNORE

// standard
#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>                     /* for strtol(3) */
#include <string.h>
#include <wordexp.h>

// Silence these warnings for Flex-generated code.
#ifdef __clang__
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wimplicit-int-conversion"
# pragma clang diagnostic ignored "-Wshorten-64-to-32"
#endif /* __clang__ */
#ifdef __GNUC__
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wconversion"
# pragma GCC diagnostic ignored "-Wimplicit-fallthrough"
# pragma GCC diagnostic ignored "-Wmisleading-indentation"
# pragma GCC diagnostic ignored "-Wredundant-decls"
# pragma GCC diagnostic ignored "-Wsign-compare"
# pragma GCC diagnostic ignored "-Wsign-conversion"
#endif /* __GNUC__ */

/// @endcond

/**
 * @addtogroup lexer-group
 * @{
 */

/**
 * The maximum number of decimal digits in the unsigned 64-bit integer
 * 18446744073709551615.
 */
#define MAX_DIGITS_64             20u

/**
 * C++ raw string delimiter maximum length.
 */
#define RSTR_DELIM_LEN_MAX        16u

/**
 * Sets \ref lexer_token to the current Flex token.
 */
#define SET_TOKEN                 SET_TOKEN_TO( yytext )

/**
 * Sets \ref lexer_token to \a S.
 *
 * @param S The string to set the token to.
 */
#define SET_TOKEN_TO(S)           (lexer_token = (S))

/**
 * Overrides Flex's fatal error message to print the message in our format and
 * also exit with the status code we want.
 *
 * @param MSG The error message to print.
 */
#define YY_FATAL_ERROR(MSG)       lexer_fatal( MSG )

/**
 * Overrides Flex's input.
 *
 * @param BUF The buffer to use.
 * @param BYTES_READ Set to the number of bytes read.
 * @param BYTES_MAX The maximum number of bytes to read.
 */
#define YY_INPUT(BUF,BYTES_READ,BYTES_MAX) \
  (BYTES_READ) = lexer_get_input( (BUF), STATIC_CAST( yy_size_t, (BYTES_MAX) ) )

/**
 * This code is inserted by Flex at the beginning of each rule to set the
 * current token location information.
 */
#define YY_USER_ACTION            lexer_update_loc(); /* must include ';' */

/**
 * This code must be manually inserted before a REJECT to undo #YY_USER_ACTION.
 */
#define YY_USER_ACTION_UNDO_FOR_REJECT \
  token_column -= STATIC_CAST( int, yyleng )

/**
 * Data to keep for a file that is `include`d.
 *
 * @remarks When a file is included, an <code>%include_file_info</code> is
 * pushed onto \ref include_stack such that:
 *
 * @par
 *  + \ref prev_orig_path is the unresolved path of the _previous_ include (or
 *    configuration) file, if any, that is the value of print_params.conf_path.
 *
 *  + \ref curr_real_path is the resolved path of the _new_ file about to be
 *    included.  We need to remember the resolved path in order to be able to
 *    remove it from \ref include_set upon EOF.
 *
 * @note We need \ref prev_lineno because Flex doesn't restore `yylineno` when
 * `yypop_buffer_state()` is called.
 */
struct include_file_info {
  char const *prev_orig_path;           ///< The previous file's original path.
  char const *curr_real_path;           ///< The current file's real path.
  int         prev_lineno;              ///< The file's last line number.
};
typedef struct include_file_info include_file_info_t;

static char const lexer_token_init_buf; ///< So lexer_token is never NULL.

// extern variables
unsigned          lexer_find = LEXER_FIND_ANY;
c_keyword_ctx_t   lexer_keyword_ctx;

// A separate pointer for the current token allows it:
//  + To be `const`.
//  + To be assigned to either other `const` strings or string literals.
char const       *lexer_token = &lexer_token_init_buf;

// local variables
static bool       digraph_warned;       ///< Printed digraph warning once?
static rb_tree_t  include_set;          ///< Set of resolved include paths.
static slist_t    include_stack;        ///< Stack of include paths.
static char      *input_buf;            ///< Entire current input line.
static size_t     input_len;            ///< Length of `input_buf`.
static size_t     input_sent;           ///< How many bytes returned to Flex.
static bool       is_eof;               ///< Encountered EOF?
static int        newline_column;       ///< Column position of newline.
static strbuf_t   str_lit_buf;          ///< String (or character) literal.
static c_loc_t    str_lit_loc;          ///< String literal starting location.
static int        token_column;         ///< Column position of current token.
static bool       trigraph_warned;      ///< Printed trigraph warning once?

/// C++ raw string literal delimiter.
static char       rstr_delim[ RSTR_DELIM_LEN_MAX + 1/*"*/ + 1/*\0*/ ];

// local functions
_Noreturn
static void       lexer_fatal( char const* );

////////// local functions ////////////////////////////////////////////////////

/**
 * Frees all memory associated with \a ifi _including_ \a ifi itself.
 *
 * @param ifi The \ref include_file_info to free.  If NULL, does nothing.
 */
static void ifi_free( include_file_info_t *ifi ) {
  if ( ifi != NULL ) {
    FREE( ifi->prev_orig_path );
    FREE( ifi->curr_real_path );
    free( ifi );
  }
}

/**
 * Frees all memory used by include files.
 *
 * @sa include_init()
 */
static void include_cleanup( void ) {
  slist_cleanup( &include_stack, POINTER_CAST( slist_free_fn_t, &ifi_free ) );
  // Do not pass free() as the second argument since the resolved include path
  // strings are shared with and owned by include_stack.
  rb_tree_cleanup( &include_set, /*free_fn=*/NULL );
}

/**
 * Initializes include files.
 *
 * @sa include_cleanup()
 */
static void include_init( void ) {
  rb_tree_init( &include_set, POINTER_CAST( rb_cmp_fn_t, &strcmp ) );
}

/**
 * Lexer-specific wrapper around cdecl_keyword_find() that finds a cdecl
 * keyword, but only if we're currently supposed to or we're always supposed to
 * find a particular keyword.
 *
 * @param literal The literal to find.
 * @return Returns a pointer to the corresponding cdecl_keyword or NULL if not
 * found or we're not currently supposed to find it.
 */
NODISCARD
static inline
cdecl_keyword_t const* lexer_cdecl_keyword_find( char const *literal ) {
  cdecl_keyword_t const *const cdk = cdecl_keyword_find( literal );
  if ( cdk == NULL )
    return NULL;
  if ( (lexer_find & LEXER_FIND_CDECL_KEYWORDS) != 0 || cdk->always_find )
    return cdk;
  return NULL;
}

/**
 * Cleans up lexer data.
 *
 * @sa lexer_init()
 */
static void lexer_cleanup( void ) {
  include_cleanup();
  strbuf_cleanup( &str_lit_buf );
}

/**
 * Gets a line of input for Flex and keeps a copy for use later if printing an
 * error message.
 *
 * @param buf A pointer to the buffer to write into.
 * @param buf_cap The capacity of \a buf.
 * @return Returns the number of bytes read.
 */
NODISCARD
static yy_size_t lexer_get_input( char *buf, yy_size_t buf_cap ) {
  assert( buf != NULL );
  yy_size_t input_avail = input_len - input_sent;
  if ( input_avail == 0 ) {
    static size_t input_cap;
    ssize_t bytes_read = getline( &input_buf, &input_cap, yyin );
    if ( unlikely( bytes_read == -1 ) ) {
      FERROR( yyin );
      bytes_read = 0;
    }
    input_avail = input_len = STATIC_CAST( yy_size_t, bytes_read );
    input_sent = 0;
  }
  //
  // Given that the default buffer capacity (YY_READ_BUF_SIZE) for Flex is
  // 8192, it's unlikely that this will ever be true and that we'll have to
  // return the input line in chunks; but might as well code for the case.
  //
  if ( unlikely( input_avail > buf_cap ) )
    input_avail = buf_cap;
  memcpy( buf, input_buf + input_sent, input_avail );
  input_sent += input_avail;
  return input_avail;
}

/**
 * Update the parser's location.
 * @note This is called by Flex via #YY_USER_ACTION.
 */
static void lexer_update_loc( void ) {
  yylloc.first_line   = yylloc.last_line = STATIC_CAST( int, yylineno );
  yylloc.first_column = token_column;
  yylloc.last_column  = token_column + STATIC_CAST( int, yyleng ) - 1;
  token_column += STATIC_CAST( int, yyleng );
}

/**
 * Resets the token column position upon encountering a newline.
 */
static inline void newline( void ) {
  newline_column = token_column;
  token_column = 0;
}

/**
 * Parses an integer from \ref lexer_token.
 *
 * @param base The integer base to use.
 * @return Returns the integer value.
 */
NODISCARD
static int parse_int( int base ) {
  char const *s = lexer_token;

  if ( base == 2 ) {
    // Prior to C23, strtol(3) doesn't understand a "0b" (binary) prefix, so
    // skip over it.
    assert( s[0] == '0' );
    assert( tolower( s[1] ) == 'b' );
    s += 2;
  }

  char no_digit_seps[ MAX_DIGITS_64 + 1/*\0*/ ];

  if ( strchr( s, '\'' ) != NULL ) {
    char *t = no_digit_seps;
    do {
      if ( *s != '\'' )
        *t++ = *s;
    } while ( *s++ != '\0' );
    s = no_digit_seps;
  }

  errno = 0;
  long const rv = strtol( s, /*endptr=*/NULL, base );
  if ( unlikely( errno != 0 || rv > INT_MAX ) ) {
    print_warning( &yylloc, "integer out of range; clamped to %d\n", INT_MAX );
    return INT_MAX;
  }

  return STATIC_CAST( int, rv );
}

/**
 * Pops the current input file, if any.
 *
 * @return Returns `true` only if an include file was popped.
 *
 * @sa push_file()
 * @sa https://westes.github.io/flex/manual/Multiple-Input-Buffers.html
 */
NODISCARD
static bool pop_file( void ) {
  if ( slist_empty( &include_stack ) )
    return false;

  include_file_info_t *const ifi = slist_pop_front( &include_stack );
  assert( ifi != NULL );

  rb_node_t *const found_rb = rb_tree_find( &include_set, ifi->curr_real_path );
  assert( found_rb != NULL );
  // Ignore the curr_real_path returned by rb_tree_delete() since it's shared
  // with and owned by ifi.
  PJL_IGNORE_RV( rb_tree_delete( &include_set, found_rb ) );

  print_params.conf_path = ifi->prev_orig_path;
  yylineno = ifi->prev_lineno;
  ifi_free( ifi );

  // The example code in the Flex manual leaks file handles; see:
  // https://stackoverflow.com/a/27512485/99089
  assert( yyin != NULL );
  assert( yyin != stdin );
  PJL_IGNORE_RV( fclose( yyin ) );
  yypop_buffer_state();
  assert( YY_CURRENT_BUFFER != NULL );

  return true;
}

/**
 * Pushes the current input file and sets \a path as the new file to read
 * subsequent input from.
 *
 * @param path The path to read subsequent input from until EOF.  Shell
 * metacharacters, e.g., `~`, are expanded.
 * @param path_loc The location of \a path.
 *
 * @sa pop_file()
 * @sa http://westes.github.io/flex/manual/Multiple-Input-Buffers.html
 */
static void push_file( char const *path, c_loc_t const *path_loc ) {
  path = null_if_empty( path );
  if ( path == NULL ) {
    print_error( path_loc, "empty path\n" );
    return;
  }

  wordexp_t we;
  int const rv_we = wordexp( path, &we, /*flags=*/0 );

  char const *real_path = NULL;

  switch ( rv_we ) {
    case 0:                             // success
      if ( we.we_wordc != 1 ) {
        print_error( path_loc, "%s: too many files\n", path );
        goto done;
      }
      break;
    case WRDE_BADCHAR:
      print_error( path_loc, "%s: contains unquoted shell characters\n", path );
      return;
    case WRDE_SYNTAX:
      print_error( path_loc, "%s: path syntax error\n", path );
      return;
    // LCOV_EXCL_START
    case WRDE_NOSPACE:                  // unlikely
      print_error( path_loc, "out of memory\n" );
      _Exit( EX_OSERR );
    case WRDE_BADVAL:                   // can't happen
    case WRDE_CMDSUB:                   // can't happen
      FALLTHROUGH;
    default:
      UNEXPECTED_INT_VALUE( rv_we );
    // LCOV_EXCL_STOP
  } // switch

  real_path = realpath( we.we_wordv[0], /*real_buf=*/NULL );
  if ( real_path == NULL ) {
    print_error( path_loc, "%s: could not resolve path\n", path );
    goto done;
  }

  if ( rb_tree_find( &include_set, real_path ) != NULL ) {
    print_error( path_loc, "%s: file previously included\n", path );
    goto done;
  }

  if ( !path_is_file( real_path ) ) {
    print_error( path_loc, "%s: not a plain file\n", path );
    goto done;
  }

  FILE *const include_file = fopen( real_path, "r" );
  if ( include_file == NULL ) {
    print_error( path_loc, "%s: %s\n", path, STRERROR() );
    goto done;
  }

  //
  // Now that we know the path resolves, it wasn't previously included, it's a
  // plain file, and we can open it, we can insert it into include_set.
  //
  PJL_IGNORE_RV(
    rb_tree_insert( &include_set, CONST_CAST( void*, real_path ) )
  );

  include_file_info_t *const ifi = MALLOC( include_file_info_t, 1 );
  *ifi = (include_file_info_t){ print_params.conf_path, real_path, yylineno };
  slist_push_front( &include_stack, ifi );
  real_path = NULL;                     // now owned by ifi above

  yyin = include_file;
  yypush_buffer_state( yy_create_buffer( yyin, YY_BUF_SIZE ) );
  print_params.conf_path = check_strdup( we.we_wordv[0] );
  yylineno = 0;

done:
  FREE( real_path );
  wordfree( &we );                      // call only if rv_we == 0
}

/**
 * Sets the current token to \a token for the current digraph sequence.
 * Additionally, if the current language is older than C95, prints a warning
 * that digraphs are not supported until C95 (only once per parse).
 *
 * @param token The token the digraph maps to.
 *
 * @sa set_trigraph()
 */
static void set_digraph( char const *token ) {
  if ( !OPT_LANG_IS( DIGRAPHS ) && false_set( &digraph_warned ) )
    print_warning( &yylloc,
      "digraphs not supported%s\n", C_LANG_WHICH( DIGRAPHS )
    );
  SET_TOKEN_TO( token );
}

/**
 * Sets the current token to \a token for the current trigraph sequence.
 * Additionally, if the current language is K&R C or C++17 or later, prints a
 * warning that trigraphs are not supported (only once per parse).
 *
 * @param token The token the trigraph maps to.
 *
 * @sa set_digraph()
 */
static void set_trigraph( char const *token ) {
  if ( !OPT_LANG_IS( TRIGRAPHS ) && false_set( &trigraph_warned ) ) {
    print_warning( &yylloc,
      "trigraphs not supported%s\n", C_LANG_WHICH( TRIGRAPHS )
    );
  }
  SET_TOKEN_TO( token );
}

/**
 * Standard lex function to know whether to continue parsing upon reaching EOF.
 *
 * @return Returns 1 if done or 0 to continue parsing (a new file set via
 * `yyin`).
 */
static int yywrap( void ) {
  return /*done=*/1;
}

///////////////////////////////////////////////////////////////////////////////

/** @} */

/// @cond DOXYGEN_IGNORE

#line 1687 "lexer.c"
/*
 * For "include" files.
 */

/*
 * For the "set" command, we want to allow (almost) any character sequence for
 * the command's options.
 */

/*
 * For the "show" command, we want to allow globs (scoped names containing
 * `*`).
 */

/*
 * For C character and string literals.
 */

#line 1706 "lexer.c"

#define INITIAL 0
#define X_INCL 1
#define X_SET 2
#define S_SHOW 3
#define X_CHAR 4
#define X_STR 5
#define X_RSTR 6

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

        /* Create the reject buffer large enough to save one state per allowed character. */
        if ( ! (yy_state_buf) )
            (yy_state_buf) = (yy_state_type *)yyalloc(YY_STATE_BUF_SIZE  );
            if ( ! (yy_state_buf) )
                YY_FATAL_ERROR( "out of dynamic memory in yylex()" );

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 591 "lexer.l"

#line 593 "lexer.l"
              /*
               * Special case: if "_Atomic" is immediately followed by a '(',
               * it is interpreted as a type specifier, not as a type
               * qualifier.
               */
#line 1946 "lexer.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();

		(yy_state_ptr) = (yy_state_buf);
		*(yy_state_ptr)++ = yy_current_state;

yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 468 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			*(yy_state_ptr)++ = yy_current_state;
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 1937 );

yy_find_action:
		yy_current_state = *--(yy_state_ptr);
		(yy_lp) = yy_accept[yy_current_state];
find_rule: /* we branch to this label when backing up */
		for ( ; ; ) /* until we find what rule we matched */
			{
			if ( (yy_lp) && (yy_lp) < yy_accept[yy_current_state + 1] )
				{
				yy_act = yy_acclist[(yy_lp)];
				if ( yy_act & YY_TRAILING_HEAD_MASK ||
				     (yy_looking_for_trail_begin) )
					{
					if ( yy_act == (yy_looking_for_trail_begin) )
						{
						(yy_looking_for_trail_begin) = 0;
						yy_act &= ~YY_TRAILING_HEAD_MASK;
						break;
						}
					}
				else if ( yy_act & YY_TRAILING_MASK )
					{
					(yy_looking_for_trail_begin) = yy_act & ~YY_TRAILING_MASK;
					(yy_looking_for_trail_begin) |= YY_TRAILING_HEAD_MASK;
					(yy_full_match) = yy_cp;
					(yy_full_state) = (yy_state_ptr);
					(yy_full_lp) = (yy_lp);
					}
				else
					{
					(yy_full_match) = yy_cp;
					(yy_full_state) = (yy_state_ptr);
					(yy_full_lp) = (yy_lp);
					break;
					}
				++(yy_lp);
				goto find_rule;
				}
			--yy_cp;
			yy_current_state = *--(yy_state_ptr);
			(yy_lp) = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 7;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 598 "lexer.l"
{
                SET_TOKEN;
                return Y__Atomic_SPEC;
              }
	YY_BREAK
/*
               * Special case: if "const[ant]" is immediately followed by one
               * of "eval[uation]", "expr[ession]", or "init[ialization]",
               * return a special English version of the "const" token to
               * disambiguate it (as part of one of those three storage
               * classes) from the normal "const" that's a CV qualifier.
               */
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 610 "lexer.l"
{
                SET_TOKEN;
                return Y_const_ENG;
              }
	YY_BREAK
/*
               * Special case: if "declare" is eventually followed by "user-
               * defined", e.g.:
               *
               *      c++decl> declare overridden user-defined \
               *        conversion operator returning int
               *      operator int() override;
               *
               * the keyword context has to be set to C_KW_CTX_MBR_FUNC to be
               * able to match "override" and "final" (that ordinarily are not
               * matched unless within a member function declaration).
               *
               * The context can't always be set to C_KW_CTX_MBR_FUNC after
               * "declare" otherwise "override" and "final" would match when
               * they shouldn't, e.g.:
               *
               *      c++decl> declare final as int
               *      int final;
               *
               * (which is legal).
               */
case 3:
/* rule 3 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_bp + 7);
(yy_c_buf_p) = yy_cp = yy_bp + 7;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 636 "lexer.l"
{
                SET_TOKEN;
                lexer_keyword_ctx = C_KW_CTX_MBR_FUNC;
                return Y_declare;
              }
	YY_BREAK
/*
               * Special case: implement "include" files entirely within the
               * lexer.  See:
               *
               * http://westes.github.io/flex/manual/Multiple-Input-Buffers.html
               */
case 4:
YY_RULE_SETUP
#line 648 "lexer.l"
{
                strbuf_init( &str_lit_buf );
                //
                // Save the start location because we want to use it as the
                // location for the literal, not its end location.
                //
                str_lit_loc = yylloc;
                str_lit_loc.first_column = yylloc.last_column;
                BEGIN( X_INCL );
              }
	YY_BREAK
/*
               * Special case: make `q` a synonym for `quit`, but only when
               * it's the only thing on a line other than whitespace.  In all
               * other cases, `q` should be treated as an ordinary identifier.
               * This is done to allow things like:
               *
               *      cdecl> declare p, q as pointer to int
               *      int *p, *q;
               *
               * This isn't handled by having a `q` entry in CDECL_KEYWORDS
               * because that would make `q` a synonym all the time.
               *
               * Note that we can't simply do:
               *
               *      ^{S}*q{S}*$
               *
               * because `$` only matches a newline and not "end of string."
               *
               * To forbid a string like `q x`, we first have to match its
               * pattern explicitly and always forbid it.
               */
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 680 "lexer.l"
{
                char const *s = yytext + yylloc.last_column;
                // Set the offending token to the one past the `q`.
                while ( !isspace( s[-1] ) )
                  --s;
                SET_TOKEN_TO( s );
                return Y_LEXER_ERROR;
              }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 688 "lexer.l"
{ SET_TOKEN_TO( L_quit ); return Y_quit; }
	YY_BREAK
/*
               * Special case: similar to {sname} below, handle scoped
               * destructor names in the lexer so destructor names are
               * recognized as such, e.g.:
               *
               *      S::T::T           // not a destructor
               *      S::T::U           // not a destructor
               *      S::T::~T          // a destructor
               *      S::T::~U          // not a destructor (and an error)
               */
case 7:
YY_RULE_SETUP
#line 700 "lexer.l"
{
                SET_TOKEN;

                c_sname_t sname;
                if ( c_sname_parse_dtor( lexer_token, &sname ) ) {
                  yylval.sname = sname;
                  return Y_DESTRUCTOR_SNAME;
                }
                print_error( &yylloc,
                  "matching class name after '~' expected\n"
                );
                return Y_LEXER_ERROR;
              }
	YY_BREAK
/*
               * Special case: similar to {sname} below, handle scoped
               * operators in the lexer to simplify the grammar, e.g.:
               *
               *      S::T::operator    // sname = "S::T"
               */
case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 720 "lexer.l"
{
                SET_TOKEN;

                c_sname_t sname;
                size_t const sname_len = c_sname_parse( lexer_token, &sname );
                assert( sname_len > 0 );

                //
                // c_sname_parse() will not include "::operator" in the parsed
                // scoped name, so the returned length will only include the
                // actual scoped name, e.g., "S::T".  We therefore have to tell
                // Flex to put the characters "::operator" back onto the input
                // stream.
                //
                yyless( STATIC_CAST( int, sname_len ) );

                //
                // See if it's a typedef'd type: if so, copy the type's scoped
                // name so we get its scope types (if any).
                //
                c_typedef_t const *const tdef = c_typedef_find_sname( &sname );
                if ( tdef != NULL ) {
                  c_sname_cleanup( &sname );
                  sname = c_sname_dup( &tdef->ast->sname );
                }

                yylval.sname = sname;
                return Y_OPERATOR_SNAME;
              }
	YY_BREAK
/*
               * Special case: handle scoped names in the lexer so:
               *
               * 1. Constructors are recognized as such, specifically, when the
               *    scoped name's last two scopes match, e.g.:
               *
               *          A::B::C       // not a constructor
               *          S::T::T       // a constructor
               *
               *    This is needed because constructors and ordinary
               *    declarations are lexically ambiguous in a LALR(1) parser:
               *
               *          A::B(x);      // declare x as A::B with unneeded ()
               *          S::S()        // define constructor for S
               *
               * 2. Previously declared scope-types are recognized as such,
               *    e.g.:
               *
               *          define S::T as int
               *          explain S::T x
               *
               * The trailing context of a Non-Indentifier (NI) character is
               * necessary to prevent Flex from recognizing partial identifiers
               * upon REJECT.  For example, given these declarations:
               *
               *      namespace X::YY { class T; }
               *      namespace X     { class Y; }
               *      namespace X::YY { class U; }
               *
               * Just as in the first declaration, when "X::YY" is encountered
               * in the third declaration, we would ordinarily REJECT a match
               * because "X::YY" is not a type.  (Hence, "X::YY" would be
               * returned to the parser as three separate tokens "X", "::", and
               * "YY" just as they were in the first declaration.)
               *
               * However, upon REJECT, Flex backs off one character at a time,
               * so it will next try to match "X::Y" and succeed since it's a
               * substring of "X::YY".  The "X::Y" is then looked-up and finds
               * the class X::Y (from the second declaration).  This is of
               * course wrong semantically, but Flex doesn't know anything
               * about semantics, i.e., it doesn't know that the longest set of
               * contiguous alphanumeric characters comprises an identifier and
               * shouldn't be split.
               *
               * Using the trailing context prevents Flex from matching the
               * partial token.
               */
case 9:
/* rule 9 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_cp - 1);
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 797 "lexer.l"
{
                SET_TOKEN;

                c_sname_t sname;
                size_t const sname_len = c_sname_parse( lexer_token, &sname );
                if ( sname_len > 0 ) {
                  if ( sname_len < STATIC_CAST( size_t, yyleng ) )
                    yyless( sname_len );

                  //
                  // 1. See if it's a constructor name.
                  //
                  if ( c_sname_is_ctor( &sname ) ) {
                    yylval.sname = sname;
                    return Y_CONSTRUCTOR_SNAME;
                  }

                  if ( (lexer_find & LEXER_FIND_TYPES) != 0 ) {
                    //
                    // 2. See if it's a typedef'd type.
                    //
                    c_typedef_t const *const tdef =
                      c_typedef_find_sname( &sname );
                    if ( tdef != NULL ) {
                      yylval.tdef = tdef;
                      c_sname_cleanup( &sname );
                      return Y_TYPEDEF_SNAME;
                    }
                  }

                  //
                  // 3. Otherwise, reject it.
                  //
                  c_sname_cleanup( &sname );
                }
                YY_USER_ACTION_UNDO_FOR_REJECT;
                REJECT;
              }
	YY_BREAK
/*
               * Special case: match hyphenated tokens.  We need a separate
               * rule because '-' isn't a valid character in an identifier.
               */
case 10:
YY_RULE_SETUP
#line 840 "lexer.l"
{
                SET_TOKEN;
                //
                // Hyphenated tokens are legal only in pseudo-English.
                //
                if ( (lexer_find & LEXER_FIND_CDECL_KEYWORDS) == 0 )
                  return Y_ERROR;

                //
                // Now that we've matched a hyphenated token, use the same
                // keyword-matching code.
                //
                goto find_cdecl_keyword;
              }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 855 "lexer.l"
{
                SET_TOKEN;

                //
                // 1. See if it's a cdecl keyword.
                //
        find_cdecl_keyword:
                NO_OP;
                cdecl_keyword_t const *const cdk =
                  lexer_cdecl_keyword_find( lexer_token );
                if ( cdk != NULL ) {
                  if ( cdk->lang_syn == NULL ) {
                    if ( cdk->literal == L_set ) {
                      //
                      // For the "set" command, we want to allow (almost) any
                      // character sequence for the command's options, so we
                      // use an exclusive start state.
                      //
                      BEGIN( X_SET );
                    }
                    else if ( cdk->literal == L_show ) {
                      //
                      // For the "show" command, we need to allow globs.
                      //
                      BEGIN( S_SHOW );
                    }
                    return cdk->y_token_id;
                  }
                  char const *const literal = c_lang_literal( cdk->lang_syn );
                  if ( literal != NULL ) {
                    SET_TOKEN_TO( literal );
                    goto find_c_keyword;
                  }
                }

                if ( (lexer_find & LEXER_FIND_TYPES) != 0 ) {
                  //
                  // 2. See if it's a typedef'd type.
                  //
                  SNAME_VAR_INIT( sname, lexer_token );
                  c_typedef_t const *const tdef =
                    c_typedef_find_sname( &sname );
                  if ( tdef != NULL ) {
                    yylval.tdef = tdef;
                    return Y_TYPEDEF_NAME;
                  }
                }

        find_c_keyword:
                if ( (lexer_find & LEXER_FIND_C_KEYWORDS) != 0 ) {
                  //
                  // 3. See if it's a C/C++ keyword.
                  //
                  c_keyword_t const *const ck =
                    c_keyword_find( lexer_token, opt_lang, lexer_keyword_ctx );
                  if ( ck != NULL ) {
                    yylval.tid = ck->tid;
                    return ck->y_token_id;
                  }
                }

                //
                // 4. Otherwise, it's just an ordinary name.
                //
                yylval.name = check_strdup( lexer_token );
                return Y_NAME;
              }
	YY_BREAK
/* Integer literals. */
case 12:
YY_RULE_SETUP
#line 924 "lexer.l"
{ SET_TOKEN; yylval.int_val = parse_int(  2 ); return Y_INT_LIT; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 925 "lexer.l"
{ SET_TOKEN; yylval.int_val = parse_int(  8 ); return Y_INT_LIT; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 926 "lexer.l"
{ SET_TOKEN; yylval.int_val = parse_int( 10 ); return Y_INT_LIT; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 927 "lexer.l"
{ SET_TOKEN; yylval.int_val = parse_int( 16 ); return Y_INT_LIT; }
	YY_BREAK
/*
               * Special case: if '[' is immediately followed by another '[',
               * return a distinct token to decrease the number of shift/reduce
               * conflicts.
               *
               * (This doesn't use | to have the actions fall through to
               * eliminate a Flex warning with trailing context.)
               */
case 16:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 937 "lexer.l"
{ set_digraph( "[" );  return Y_ATTR_BEGIN; }
	YY_BREAK
case 17:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 938 "lexer.l"
{ set_trigraph( "[" ); return Y_ATTR_BEGIN; }
	YY_BREAK
case 18:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 939 "lexer.l"
{ SET_TOKEN;           return Y_ATTR_BEGIN; }
	YY_BREAK
/* Digraphs. */
case 19:
YY_RULE_SETUP
#line 942 "lexer.l"
{ set_digraph( "{" ); return '{'; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 943 "lexer.l"
{ set_digraph( "}" ); return '}'; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 944 "lexer.l"
{ set_digraph( "[" ); return '['; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 945 "lexer.l"
{ set_digraph( "]" ); return ']'; }
	YY_BREAK
/* Trigraphs. */
case 23:
YY_RULE_SETUP
#line 948 "lexer.l"
{ set_trigraph( "^=" ); return Y_CARET_EQUAL; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 949 "lexer.l"
{ set_trigraph( "|=" ); return Y_PIPE_EQUAL ; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 950 "lexer.l"
{ set_trigraph( "||" ); return Y_PIPE2      ; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 951 "lexer.l"
{ set_trigraph( "|"  ); return Y_PIPE       ; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 952 "lexer.l"
{ set_trigraph( "^"  ); return Y_CARET      ; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 953 "lexer.l"
{ set_trigraph( "["  ); return '['          ; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 954 "lexer.l"
{ set_trigraph( "]"  ); return ']'          ; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 955 "lexer.l"
{ set_trigraph( "{"  ); return '{'          ; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 956 "lexer.l"
{ set_trigraph( "}"  ); return '}'          ; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 957 "lexer.l"
{ set_trigraph( "~"  ); return Y_TILDE      ; }
	YY_BREAK
/*
               * Special case: if "::" is immediately followed by a '*', return
               * a distinct token to make it possible to distinguish between:
               *
               *    <name>::<name>::<name>
               *    <name>::<name>::*
               *
               * in an LALR(1) parser.
               */
case 33:
YY_RULE_SETUP
#line 968 "lexer.l"
{ SET_TOKEN; return Y_COLON2_STAR       ; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 969 "lexer.l"
{ SET_TOKEN; return Y_COLON2            ; }
	YY_BREAK
/* Multi-character operators. */
case 35:
YY_RULE_SETUP
#line 972 "lexer.l"
{ SET_TOKEN; return Y_EXCLAM_EQUAL      ; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 973 "lexer.l"
{ SET_TOKEN; return Y_QUOTE2            ; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 974 "lexer.l"
{ SET_TOKEN; return Y_PERCENT_EQUAL     ; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 975 "lexer.l"
{ SET_TOKEN; return Y_AMPER2            ; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 976 "lexer.l"
{ SET_TOKEN; return Y_AMPER_EQUAL       ; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 977 "lexer.l"
{ SET_TOKEN; return Y_STAR_EQUAL        ; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 978 "lexer.l"
{ SET_TOKEN; return Y_PLUS2             ; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 979 "lexer.l"
{ SET_TOKEN; return Y_PLUS_EQUAL        ; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 980 "lexer.l"
{ SET_TOKEN; return Y_MINUS2            ; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 981 "lexer.l"
{ SET_TOKEN; return Y_MINUS_EQUAL       ; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 982 "lexer.l"
{ SET_TOKEN; return Y_ARROW             ; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 983 "lexer.l"
{ SET_TOKEN; return Y_ARROW_STAR        ; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 984 "lexer.l"
{ SET_TOKEN; return Y_DOT_STAR          ; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 985 "lexer.l"
{ SET_TOKEN; return Y_ELLIPSIS          ; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 986 "lexer.l"
{ SET_TOKEN; return Y_SLASH_EQUAL       ; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 987 "lexer.l"
{ SET_TOKEN; return Y_LESS2             ; }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 988 "lexer.l"
{ SET_TOKEN; return Y_LESS2_EQUAL       ; }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 989 "lexer.l"
{ SET_TOKEN; return Y_LESS_EQUAL        ; }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 990 "lexer.l"
{ SET_TOKEN; return Y_LESS_EQUAL_GREATER; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 991 "lexer.l"
{ SET_TOKEN; return Y_EQUAL2            ; }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 992 "lexer.l"
{ SET_TOKEN; return Y_GREATER_EQUAL     ; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 993 "lexer.l"
{ SET_TOKEN; return Y_GREATER2          ; }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 994 "lexer.l"
{ SET_TOKEN; return Y_GREATER2_EQUAL    ; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 995 "lexer.l"
{ SET_TOKEN; return Y_QMARK_COLON       ; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 996 "lexer.l"
{ SET_TOKEN; return Y_CARET_EQUAL       ; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 997 "lexer.l"
{ SET_TOKEN; return Y_PIPE_EQUAL        ; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 998 "lexer.l"
{ SET_TOKEN; return Y_PIPE2             ; }
	YY_BREAK
/* Single-character operators having alternative tokens. */
case 62:
YY_RULE_SETUP
#line 1001 "lexer.l"
{ SET_TOKEN; return Y_EXCLAM            ; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 1002 "lexer.l"
{ SET_TOKEN; return Y_AMPER             ; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 1003 "lexer.l"
{ SET_TOKEN; return Y_CARET             ; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 1004 "lexer.l"
{ SET_TOKEN; return Y_PIPE              ; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 1005 "lexer.l"
{ SET_TOKEN; return Y_TILDE             ; }
	YY_BREAK
/* Synonym for "help", not "?:". */
case 67:
YY_RULE_SETUP
#line 1008 "lexer.l"
{ SET_TOKEN; return Y_help              ; }
	YY_BREAK
/* Single-character operators and miscellaneous punctuation. */
case 68:
#line 1012 "lexer.l"
case 69:
#line 1013 "lexer.l"
case 70:
#line 1014 "lexer.l"
case 71:
#line 1015 "lexer.l"
case 72:
#line 1016 "lexer.l"
case 73:
#line 1017 "lexer.l"
case 74:
#line 1018 "lexer.l"
case 75:
#line 1019 "lexer.l"
case 76:
#line 1020 "lexer.l"
case 77:
#line 1021 "lexer.l"
case 78:
#line 1022 "lexer.l"
case 79:
#line 1023 "lexer.l"
case 80:
#line 1024 "lexer.l"
case 81:
#line 1025 "lexer.l"
case 82:
#line 1026 "lexer.l"
case 83:
#line 1027 "lexer.l"
case 84:
#line 1028 "lexer.l"
case 85:
YY_RULE_SETUP
#line 1028 "lexer.l"
{ SET_TOKEN; return lexer_token[0]    ; }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 1030 "lexer.l"
{ // e.g.: u8R"abc(...)abc"
                // find:    ^   ^
                char const *q = strchr( yytext, '"' );
                assert( q != NULL );
                char const *const p = strchr( ++q, '(' );
                assert( p != NULL );

                size_t const delim_len = STATIC_CAST( size_t, p - q );
                if ( delim_len > RSTR_DELIM_LEN_MAX ) {
                  print_error( &yylloc,
                    "raw string literal delimiter "
                    "exceeds maximum length of %u\n",
                    RSTR_DELIM_LEN_MAX
                  );
                  return Y_LEXER_ERROR;
                }

                strncpy( rstr_delim, q, delim_len );
                //
                // To make the delimiter-match code simpler, include the
                // closing '"' as part of the delimiter.  (Using strcpy() also
                // has the benefit of ensuring rstr_delim is null-terminated.)
                //
                strcpy( rstr_delim + delim_len, "\"" );

                strbuf_init( &str_lit_buf );
                //
                // Save the start location because we want to use it as the
                // location for the literal, not its end location.
                //
                str_lit_loc = yylloc;

                BEGIN( X_RSTR );
              }
	YY_BREAK

case 87:
/* rule 87 can match eol */
YY_RULE_SETUP
#line 1066 "lexer.l"
{ strbuf_putsn( &str_lit_buf, yytext, yyleng ); }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 1067 "lexer.l"
{
                char const *d;
                for ( d = rstr_delim; *d != '\0'; ++d, ++token_column ) {
                  int const c = input();
                  if ( c == EOF ) {
                    print_error( &yylloc, "unterminated string literal\n" );
                    strbuf_reset( &str_lit_buf );
                    return Y_LEXER_ERROR;
                  }
                  if ( c != *d ) {
                    //
                    // Found a mismatch with the delimiter, e.g.:
                    //
                    //      )abc"       // delimiter
                    //      )abx"       // what was found
                    //
                    // Hence, it's not the actual delimiter, but part of the
                    // string literal: append the part that matched (")ab").
                    //
                    strbuf_printf( &str_lit_buf,
                      ")%.*s", STATIC_CAST( int, d - rstr_delim ), rstr_delim
                    );
                    //
                    // Unput the character that caused the mismatch since it
                    // could be ')' that could potentially start a real match,
                    // e.g.:
                    //
                    //      R"abc(X)ab)abc"
                    //                ^
                    //
                    // Hence the raw string is "X)ab".
                    //
                    unput( c );
                    break;
                  }
                } // for

                if ( *d == '\0' ) {     // found delimiter
                  yylloc.first_line   = str_lit_loc.first_line;
                  yylloc.first_column = str_lit_loc.first_column;
                  yylval.str_val = strbuf_take( &str_lit_buf );
                  BEGIN( INITIAL );
                  return Y_STR_LIT;
                }
              }
	YY_BREAK

case 89:
YY_RULE_SETUP
#line 1114 "lexer.l"
{
                strbuf_init( &str_lit_buf );
                //
                // Save the start location because we want to use it as the
                // location for the literal, not its end location.
                //
                str_lit_loc = yylloc;

                char const quote = yytext[ yyleng - 1 ];
                BEGIN( (quote == '"' ? X_STR : X_CHAR) );
              }
	YY_BREAK
/*
               * Common code between X_CHAR, X_INCL, and X_STR.  Multicharacter
               * literals are legal, but implementation-defined.
               */

/* Escaped characters are copied verbatim, not interpreted. */
case 90:
/* rule 90 can match eol */
YY_RULE_SETUP
#line 1132 "lexer.l"
{ strbuf_putsn( &str_lit_buf, yytext, yyleng ); }
	YY_BREAK
case 91:
/* rule 91 can match eol */
YY_RULE_SETUP
#line 1133 "lexer.l"
{
                print_error( &str_lit_loc,
                  "unterminated %s literal\n",
                  YY_START == X_CHAR ? "character" : "string"
                );
                strbuf_reset( &str_lit_buf );
                return Y_LEXER_ERROR;
              }
	YY_BREAK


case 92:
YY_RULE_SETUP
#line 1144 "lexer.l"
{ strbuf_putsn( &str_lit_buf, yytext, yyleng ); }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 1145 "lexer.l"
{
                yylloc.first_line   = str_lit_loc.first_line;
                yylloc.first_column = str_lit_loc.first_column;
                yylval.str_val = strbuf_take( &str_lit_buf );
                BEGIN( INITIAL );
                return Y_CHAR_LIT;
              }
	YY_BREAK

/*
               * Common code between X_INCL and X_STR:
               *
               * 1. X_INCL is the same as X_STR except we need to do different
               *    things upon the terminating " (which is why X_INCL exists
               *    rather than just using X_STR).
               *
               * 2. X_STR is the same as X_CHAR except " replaces '.
               */
case 94:
YY_RULE_SETUP
#line 1163 "lexer.l"
{
                strbuf_putsn( &str_lit_buf, yytext, yyleng );
              }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 1167 "lexer.l"
{
                push_file( str_lit_buf.str, &str_lit_loc );
                strbuf_reset( &str_lit_buf );
                BEGIN( INITIAL );
              }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 1173 "lexer.l"
{
                yylloc.first_line   = str_lit_loc.first_line;
                yylloc.first_column = str_lit_loc.first_column;
                yylval.str_val = strbuf_take( &str_lit_buf );
                BEGIN( INITIAL );
                return Y_STR_LIT;
              }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 1181 "lexer.l"
{                         /* ignore C-style comments */
                for ( int c = input(), prev = '\0'; ; prev = c, c = input() ) {
                  if ( c == EOF ) {
                    print_error( &yylloc, "unterminated comment\n" );
                    return Y_LEXER_ERROR;
                  }
                  ++token_column;
                  if ( c == '/' && prev == '*' )
                    break;
                  if ( c == '\n' )
                    newline();
                } // for
              }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 1195 "lexer.l"
;                         /* ignore C++-style comments */
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 1196 "lexer.l"
;                         /* ignore preprocessor directives */
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 1197 "lexer.l"
;                         /* ignore all other whitespace */
	YY_BREAK
case 101:
/* rule 101 can match eol */
YY_RULE_SETUP
#line 1198 "lexer.l"
;                         /* eat escaped newlines */
	YY_BREAK
case 102:
/* rule 102 can match eol */
YY_RULE_SETUP
#line 1200 "lexer.l"
{
                SET_TOKEN;
                newline();
                BEGIN( INITIAL );
                return Y_END;
              }
	YY_BREAK

case 103:
YY_RULE_SETUP
#line 1208 "lexer.l"
{
                SET_TOKEN;
                BEGIN( INITIAL );
                return lexer_token[0];
              }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 1214 "lexer.l"
{
                SET_TOKEN;
                yylval.name = check_strdup( lexer_token );
                return Y_SET_OPTION;
              }
	YY_BREAK


case 105:
YY_RULE_SETUP
#line 1222 "lexer.l"
{
                SET_TOKEN;
                BEGIN( INITIAL );
                return lexer_token[0];
              }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 1228 "lexer.l"
{
                SET_TOKEN;
                yylval.name = check_strdup( lexer_token );
                return Y_GLOB;
              }
	YY_BREAK

case 107:
YY_RULE_SETUP
#line 1235 "lexer.l"
{
                SET_TOKEN;
                return Y_ERROR;
              }
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(X_INCL):
case YY_STATE_EOF(X_SET):
case YY_STATE_EOF(S_SHOW):
case YY_STATE_EOF(X_CHAR):
case YY_STATE_EOF(X_STR):
case YY_STATE_EOF(X_RSTR):
#line 1240 "lexer.l"
{
                SET_TOKEN;
                newline();
                BEGIN( INITIAL );

                if ( pop_file() )
                  return Y_END;

                //
                // The first time we encounter EOF (not for an include file),
                // we want to treat it as if it were a newline by returning
                // Y_END so commands in the parser always end in Y_END.
                //
                // Requesting more characters after encountering EOF will
                // simply continue to return EOF, so the second time we
                // encounter EOF, treat it as EOF by returning no token.
                //
                return (is_eof = !is_eof) ? Y_END : YY_NULL;
              }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 1260 "lexer.l"
ECHO;
	YY_BREAK
#line 3087 "lexer.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	(yy_state_ptr) = (yy_state_buf);
	*(yy_state_ptr)++ = yy_current_state;

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 468 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		*(yy_state_ptr)++ = yy_current_state;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    
	YY_CHAR yy_c = 1;
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 468 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 467);
	if ( ! yy_is_jam )
		*(yy_state_ptr)++ = yy_current_state;

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');
	if ( YY_CURRENT_BUFFER_LVALUE->yy_at_bol )
		
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

    (yy_state_buf) = 0;
    (yy_state_ptr) = 0;
    (yy_full_match) = 0;
    (yy_lp) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    yyfree ( (yy_state_buf) );
    (yy_state_buf)  = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 1260 "lexer.l"


/// @endcond

// Re-enable warnings.
#ifdef __clang__
# pragma clang diagnostic pop
#endif /* __clang__ */
#ifdef __GNUC__
# pragma GCC diagnostic pop
#endif /* __GNUC__ */

////////// local functions ////////////////////////////////////////////////////

/**
 * @addtogroup lexer-group
 * @{
 */

// LCOV_EXCL_START
/**
 * Called by Flex only when there's a fatal error.
 *
 * @param msg The error message to print.
 */
_Noreturn
static void lexer_fatal( char const *msg ) {
  if ( msg == NULL ) {
    // Never true -- here just to silence the "unused function" warning.
    yy_fatal_error( msg );
  }

  //
  // This is defined down here to avoid having to declare yy_fatal_error
  // ourselves and having to get it right being subject to possible changes in
  // its signature in different Flex versions.
  //
  INTERNAL_ERROR( "lexer_fatal(): %s\n", msg );
}
// LCOV_EXCL_STOP

/** @} */

////////// extern functions ///////////////////////////////////////////////////

void lexer_init( void ) {
  ASSERT_RUN_ONCE();
  check_atexit( &lexer_cleanup );
  include_init();
}

char const* lexer_input_line( size_t *rv_len ) {
  assert( rv_len != NULL );
  *rv_len = input_len;
  return input_buf;
}

c_loc_t lexer_loc( void ) {
  c_loc_t rv_loc;
  rv_loc.first_line = yylineno;

  if ( token_column == 0 )
    rv_loc.first_column = newline_column;
  else if ( lexer_token[0] == '\n' )
    rv_loc.first_column = token_column;
  else {
    rv_loc.first_column =
      token_column - STATIC_CAST( int, strlen( lexer_token ) );
    assert( rv_loc.first_column >= 0 );
  }

  rv_loc.last_line = rv_loc.first_line;
  rv_loc.last_column = rv_loc.first_column;
  return rv_loc;
}

char const* lexer_printable_token( void ) {
  switch ( lexer_token[0] ) {
    case '\0': return NULL;
    case '\n': return "\\n";
    default  : return lexer_token;
  } // switch
}

void lexer_reset( bool hard_reset ) {
  if ( hard_reset ) {
    is_eof = false;
    include_cleanup();
    include_init();
    newline();
    yylineno = 0;
  }
  BEGIN( INITIAL );
  digraph_warned = trigraph_warned = false;
  input_len = input_sent = 0;
  lexer_find = LEXER_FIND_ANY;
  lexer_keyword_ctx = C_KW_CTX_DEFAULT;
  strbuf_reset( &str_lit_buf );
}

///////////////////////////////////////////////////////////////////////////////
/* vim:set et sw=2 ts=2: */

