# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# This file is generated by wxPython's PI generator.  Do not edit by hand.
#
# The *.pyi files are used by PyCharm and other development tools to provide
# more information, such as PEP 484 type hints, than it is able to glean from
# introspection of extension types and methods.  They are not intended to be
# imported, executed or used for any other purpose other than providing info
# to the tools. If you don't use use a tool that makes use of .pyi files then
# you can safely ignore this file.
#
# See: https://www.python.org/dev/peps/pep-0484/
#      https://www.jetbrains.com/help/pycharm/2016.1/type-hinting-in-pycharm.html
#
# Copyright: (c) 2018 by Total Control Software
# License:   wxWindows License
#---------------------------------------------------------------------------


"""
`wx.aui` provides a set of classes for implementing an "Advanced User Interface".
More specifically, these classes enable to you present some of your application in
floating or dockable panels, notebooks with floatable tabs, etc.

There is also a pure-python implementation of these classes available in the
`wx.lib.agw.aui` package.
"""
#-- begin-_aui --#

import wx
#-- end-_aui --#
#-- begin-auiframemanager --#
AUI_DOCK_NONE = 0
AUI_DOCK_TOP = 0
AUI_DOCK_RIGHT = 0
AUI_DOCK_BOTTOM = 0
AUI_DOCK_LEFT = 0
AUI_DOCK_CENTER = 0
AUI_DOCK_CENTRE = 0
AUI_MGR_ALLOW_FLOATING = 0
AUI_MGR_ALLOW_ACTIVE_PANE = 0
AUI_MGR_TRANSPARENT_DRAG = 0
AUI_MGR_TRANSPARENT_HINT = 0
AUI_MGR_VENETIAN_BLINDS_HINT = 0
AUI_MGR_RECTANGLE_HINT = 0
AUI_MGR_HINT_FADE = 0
AUI_MGR_NO_VENETIAN_BLINDS_FADE = 0
AUI_MGR_LIVE_RESIZE = 0
AUI_MGR_DEFAULT = 0
wxEVT_AUI_PANE_BUTTON = 0
wxEVT_AUI_PANE_CLOSE = 0
wxEVT_AUI_PANE_MAXIMIZE = 0
wxEVT_AUI_PANE_RESTORE = 0
wxEVT_AUI_PANE_ACTIVATED = 0
wxEVT_AUI_RENDER = 0
wxEVT_AUI_FIND_MANAGER = 0

class AuiManager(wx.EvtHandler):
    """
    AuiManager(managed_wnd=None, flags=AUI_MGR_DEFAULT)
    
    wxAuiManager is the central class of the wxAUI class framework.
    """

    def __init__(self, managed_wnd=None, flags=AUI_MGR_DEFAULT):
        """
        AuiManager(managed_wnd=None, flags=AUI_MGR_DEFAULT)
        
        wxAuiManager is the central class of the wxAUI class framework.
        """

    def AddPane(self, *args, **kw):
        """
        AddPane(window, pane_info) -> bool
        AddPane(window, direction=wx.LEFT, caption=wx.EmptyString) -> bool
        AddPane(window, pane_info, drop_pos) -> bool
        
        AddPane() tells the frame manager to start managing a child window.
        """

    def DetachPane(self, window):
        """
        DetachPane(window) -> bool
        
        Tells the wxAuiManager to stop managing the pane specified by window.
        """

    def GetAllPanes(self):
        """
        GetAllPanes() -> AuiPaneInfoArray
        
        Returns an array of all panes managed by the frame manager.
        """

    def GetArtProvider(self):
        """
        GetArtProvider() -> AuiDockArt
        
        Returns the current art provider being used.
        """

    def GetDockSizeConstraint(self, widthpct, heightpct):
        """
        GetDockSizeConstraint(widthpct, heightpct)
        
        Returns the current dock constraint values.
        """

    def GetFlags(self):
        """
        GetFlags() -> unsignedint
        
        Returns the current wxAuiManagerOption's flags.
        """

    def GetManagedWindow(self):
        """
        GetManagedWindow() -> wx.Window
        
        Returns the frame currently being managed by wxAuiManager.
        """

    def GetPane(self, *args, **kw):
        """
        GetPane(window) -> AuiPaneInfo
        GetPane(name) -> AuiPaneInfo
        
        GetPane() is used to lookup a wxAuiPaneInfo object either by window
        pointer or by pane name, which acts as a unique id for a window pane.
        """

    def HideHint(self):
        """
        HideHint()
        
        HideHint() hides any docking hint that may be visible.
        """

    def InsertPane(self, window, insert_location, insert_level=AUI_INSERT_PANE):
        """
        InsertPane(window, insert_location, insert_level=AUI_INSERT_PANE) -> bool
        
        This method is used to insert either a previously unmanaged pane
        window into the frame manager, or to insert a currently managed pane
        somewhere else.
        """

    def LoadPaneInfo(self, pane_part, pane):
        """
        LoadPaneInfo(pane_part, pane)
        
        LoadPaneInfo() is similar to LoadPerspective, with the exception that
        it only loads information about a single pane.
        """

    def LoadPerspective(self, perspective, update=True):
        """
        LoadPerspective(perspective, update=True) -> bool
        
        Loads a saved perspective.
        """

    def SavePaneInfo(self, pane):
        """
        SavePaneInfo(pane) -> String
        
        SavePaneInfo() is similar to SavePerspective, with the exception that
        it only saves information about a single pane.
        """

    def SavePerspective(self):
        """
        SavePerspective() -> String
        
        Saves the entire user interface layout into an encoded wxString, which
        can then be stored by the application (probably using wxConfig).
        """

    def SetArtProvider(self, art_provider):
        """
        SetArtProvider(art_provider)
        
        Instructs wxAuiManager to use art provider specified by parameter
        art_provider for all drawing calls.
        """

    def SetDockSizeConstraint(self, widthpct, heightpct):
        """
        SetDockSizeConstraint(widthpct, heightpct)
        
        When a user creates a new dock by dragging a window into a docked
        position, often times the large size of the window will create a dock
        that is unwieldly large.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        This method is used to specify wxAuiManagerOption's flags.
        """

    def SetManagedWindow(self, managed_wnd):
        """
        SetManagedWindow(managed_wnd)
        
        Called to specify the frame or window which is to be managed by
        wxAuiManager.
        """

    def ShowHint(self, rect):
        """
        ShowHint(rect)
        
        This function is used by controls to explicitly show a hint window at
        the specified rectangle.
        """

    def UnInit(self):
        """
        UnInit()
        
        Uninitializes the framework and should be called before a managed
        frame or window is destroyed.
        """

    def Update(self):
        """
        Update()
        
        This method is called after any number of changes are made to any of
        the managed panes.
        """

    @staticmethod
    def GetManager(window):
        """
        GetManager(window) -> AuiManager
        
        Calling this method will return the wxAuiManager for a given window.
        """
    AllPanes = property(None, None)
    ArtProvider = property(None, None)
    Flags = property(None, None)
    ManagedWindow = property(None, None)

    def ProcessDockResult(self, target, new_pos):
        """
        ProcessDockResult(target, new_pos) -> bool
        
        ProcessDockResult() is a protected member of the wxAUI layout manager.
        """
# end of class AuiManager


class AuiPaneInfo(object):
    """
    AuiPaneInfo()
    AuiPaneInfo(c)
    
    wxAuiPaneInfo is part of the wxAUI class framework.
    """

    def __init__(self, *args, **kw):
        """
        AuiPaneInfo()
        AuiPaneInfo(c)
        
        wxAuiPaneInfo is part of the wxAUI class framework.
        """
    name = property(None, None)
    caption = property(None, None)
    icon = property(None, None)
    window = property(None, None)
    frame = property(None, None)
    state = property(None, None)
    dock_direction = property(None, None)
    dock_layer = property(None, None)
    dock_row = property(None, None)
    dock_pos = property(None, None)
    best_size = property(None, None)
    min_size = property(None, None)
    max_size = property(None, None)
    floating_pos = property(None, None)
    floating_size = property(None, None)
    dock_proportion = property(None, None)
    buttons = property(None, None)
    rect = property(None, None)

    def BestSize(self, *args, **kw):
        """
        BestSize(size) -> AuiPaneInfo
        BestSize(x, y) -> AuiPaneInfo
        
        BestSize() sets the ideal size for the pane.
        """

    def Bottom(self):
        """
        Bottom() -> AuiPaneInfo
        
        Bottom() sets the pane dock position to the bottom side of the frame.
        """

    def BottomDockable(self, b=True):
        """
        BottomDockable(b=True) -> AuiPaneInfo
        
        BottomDockable() indicates whether a pane can be docked at the bottom
        of the frame.
        """

    def Caption(self, c):
        """
        Caption(c) -> AuiPaneInfo
        
        Caption() sets the caption of the pane.
        """

    def CaptionVisible(self, visible=True):
        """
        CaptionVisible(visible=True) -> AuiPaneInfo
        
        CaptionVisible indicates that a pane caption should be visible.
        """

    def Centre(self):
        """
        Centre() -> AuiPaneInfo
        
        Center() sets the pane dock position to the left side of the frame.
        """

    def Center(self):
        """
        Center() -> AuiPaneInfo
        """

    def CentrePane(self):
        """
        CentrePane() -> AuiPaneInfo
        
        CentrePane() specifies that the pane should adopt the default center
        pane settings.
        """

    def CenterPane(self):
        """
        CenterPane() -> AuiPaneInfo
        """

    def CloseButton(self, visible=True):
        """
        CloseButton(visible=True) -> AuiPaneInfo
        
        CloseButton() indicates that a close button should be drawn for the
        pane.
        """

    def DefaultPane(self):
        """
        DefaultPane() -> AuiPaneInfo
        
        DefaultPane() specifies that the pane should adopt the default pane
        settings.
        """

    def DestroyOnClose(self, b=True):
        """
        DestroyOnClose(b=True) -> AuiPaneInfo
        
        DestroyOnClose() indicates whether a pane should be destroyed when it
        is closed.
        """

    def Direction(self, direction):
        """
        Direction(direction) -> AuiPaneInfo
        
        Direction() determines the direction of the docked pane.
        """

    def Dock(self):
        """
        Dock() -> AuiPaneInfo
        
        Dock() indicates that a pane should be docked.
        """

    def DockFixed(self, b=True):
        """
        DockFixed(b=True) -> AuiPaneInfo
        
        DockFixed() causes the containing dock to have no resize sash.
        """

    def Dockable(self, b=True):
        """
        Dockable(b=True) -> AuiPaneInfo
        
        Dockable() specifies whether a frame can be docked or not.
        """

    def Fixed(self):
        """
        Fixed() -> AuiPaneInfo
        
        Fixed() forces a pane to be fixed size so that it cannot be resized.
        """

    def Float(self):
        """
        Float() -> AuiPaneInfo
        
        Float() indicates that a pane should be floated.
        """

    def Floatable(self, b=True):
        """
        Floatable(b=True) -> AuiPaneInfo
        
        Floatable() sets whether the user will be able to undock a pane and
        turn it into a floating window.
        """

    def FloatingPosition(self, *args, **kw):
        """
        FloatingPosition(pos) -> AuiPaneInfo
        FloatingPosition(x, y) -> AuiPaneInfo
        
        FloatingPosition() sets the position of the floating pane.
        """

    def FloatingSize(self, *args, **kw):
        """
        FloatingSize(size) -> AuiPaneInfo
        FloatingSize(x, y) -> AuiPaneInfo
        
        FloatingSize() sets the size of the floating pane.
        """

    def Gripper(self, visible=True):
        """
        Gripper(visible=True) -> AuiPaneInfo
        
        Gripper() indicates that a gripper should be drawn for the pane.
        """

    def GripperTop(self, attop=True):
        """
        GripperTop(attop=True) -> AuiPaneInfo
        
        GripperTop() indicates that a gripper should be drawn at the top of
        the pane.
        """

    def HasBorder(self):
        """
        HasBorder() -> bool
        
        HasBorder() returns true if the pane displays a border.
        """

    def HasCaption(self):
        """
        HasCaption() -> bool
        
        HasCaption() returns true if the pane displays a caption.
        """

    def HasCloseButton(self):
        """
        HasCloseButton() -> bool
        
        HasCloseButton() returns true if the pane displays a button to close
        the pane.
        """

    def HasFlag(self, flag):
        """
        HasFlag(flag) -> bool
        
        HasFlag() returns true if the property specified by flag is active for
        the pane.
        """

    def HasGripper(self):
        """
        HasGripper() -> bool
        
        HasGripper() returns true if the pane displays a gripper.
        """

    def HasGripperTop(self):
        """
        HasGripperTop() -> bool
        
        HasGripper() returns true if the pane displays a gripper at the top.
        """

    def HasMaximizeButton(self):
        """
        HasMaximizeButton() -> bool
        
        HasMaximizeButton() returns true if the pane displays a button to
        maximize the pane.
        """

    def HasMinimizeButton(self):
        """
        HasMinimizeButton() -> bool
        
        HasMinimizeButton() returns true if the pane displays a button to
        minimize the pane.
        """

    def HasPinButton(self):
        """
        HasPinButton() -> bool
        
        HasPinButton() returns true if the pane displays a button to float the
        pane.
        """

    def Hide(self):
        """
        Hide() -> AuiPaneInfo
        
        Hide() indicates that a pane should be hidden.
        """

    def Icon(self, b):
        """
        Icon(b) -> AuiPaneInfo
        
        Icon() sets the icon of the pane.
        """

    def IsBottomDockable(self):
        """
        IsBottomDockable() -> bool
        
        IsBottomDockable() returns true if the pane can be docked at the
        bottom of the managed frame.
        """

    def IsDockable(self):
        """
        IsDockable() -> bool
        
        Returns true if the pane can be docked at any side.
        """

    def IsDocked(self):
        """
        IsDocked() -> bool
        
        IsDocked() returns true if the pane is currently docked.
        """

    def IsFixed(self):
        """
        IsFixed() -> bool
        
        IsFixed() returns true if the pane cannot be resized.
        """

    def IsFloatable(self):
        """
        IsFloatable() -> bool
        
        IsFloatable() returns true if the pane can be undocked and displayed
        as a floating window.
        """

    def IsFloating(self):
        """
        IsFloating() -> bool
        
        IsFloating() returns true if the pane is floating.
        """

    def IsLeftDockable(self):
        """
        IsLeftDockable() -> bool
        
        IsLeftDockable() returns true if the pane can be docked on the left of
        the managed frame.
        """

    def IsMovable(self):
        """
        IsMovable() -> bool
        
        IsMoveable() returns true if the docked frame can be undocked or moved
        to another dock position.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        IsOk() returns true if the wxAuiPaneInfo structure is valid.
        """

    def IsResizable(self):
        """
        IsResizable() -> bool
        
        IsResizable() returns true if the pane can be resized.
        """

    def IsRightDockable(self):
        """
        IsRightDockable() -> bool
        
        IsRightDockable() returns true if the pane can be docked on the right
        of the managed frame.
        """

    def IsShown(self):
        """
        IsShown() -> bool
        
        IsShown() returns true if the pane is currently shown.
        """

    def IsToolbar(self):
        """
        IsToolbar() -> bool
        
        IsToolbar() returns true if the pane contains a toolbar.
        """

    def IsTopDockable(self):
        """
        IsTopDockable() -> bool
        
        IsTopDockable() returns true if the pane can be docked at the top of
        the managed frame.
        """

    def Layer(self, layer):
        """
        Layer(layer) -> AuiPaneInfo
        
        Layer() determines the layer of the docked pane.
        """

    def Left(self):
        """
        Left() -> AuiPaneInfo
        
        Left() sets the pane dock position to the left side of the frame.
        """

    def LeftDockable(self, b=True):
        """
        LeftDockable(b=True) -> AuiPaneInfo
        
        LeftDockable() indicates whether a pane can be docked on the left of
        the frame.
        """

    def MaxSize(self, *args, **kw):
        """
        MaxSize(size) -> AuiPaneInfo
        MaxSize(x, y) -> AuiPaneInfo
        
        MaxSize() sets the maximum size of the pane.
        """

    def MaximizeButton(self, visible=True):
        """
        MaximizeButton(visible=True) -> AuiPaneInfo
        
        MaximizeButton() indicates that a maximize button should be drawn for
        the pane.
        """

    def MinSize(self, *args, **kw):
        """
        MinSize(size) -> AuiPaneInfo
        MinSize(x, y) -> AuiPaneInfo
        
        MinSize() sets the minimum size of the pane.
        """

    def MinimizeButton(self, visible=True):
        """
        MinimizeButton(visible=True) -> AuiPaneInfo
        
        MinimizeButton() indicates that a minimize button should be drawn for
        the pane.
        """

    def Movable(self, b=True):
        """
        Movable(b=True) -> AuiPaneInfo
        
        Movable indicates whether a frame can be moved.
        """

    def Name(self, n):
        """
        Name(n) -> AuiPaneInfo
        
        Name() sets the name of the pane so it can be referenced in lookup
        functions.
        """

    def PaneBorder(self, visible=True):
        """
        PaneBorder(visible=True) -> AuiPaneInfo
        
        PaneBorder indicates that a border should be drawn for the pane.
        """

    def PinButton(self, visible=True):
        """
        PinButton(visible=True) -> AuiPaneInfo
        
        PinButton() indicates that a pin button should be drawn for the pane.
        """

    def Position(self, pos):
        """
        Position(pos) -> AuiPaneInfo
        
        Position() determines the position of the docked pane.
        """

    def Resizable(self, resizable=True):
        """
        Resizable(resizable=True) -> AuiPaneInfo
        
        Resizable() allows a pane to be resized if the parameter is true, and
        forces it to be a fixed size if the parameter is false.
        """

    def Right(self):
        """
        Right() -> AuiPaneInfo
        
        Right() sets the pane dock position to the right side of the frame.
        """

    def RightDockable(self, b=True):
        """
        RightDockable(b=True) -> AuiPaneInfo
        
        RightDockable() indicates whether a pane can be docked on the right of
        the frame.
        """

    def Row(self, row):
        """
        Row(row) -> AuiPaneInfo
        
        Row() determines the row of the docked pane.
        """

    def SafeSet(self, source):
        """
        SafeSet(source)
        
        Write the safe parts of a newly loaded PaneInfo structure "source"
        into "this" used on loading perspectives etc.
        """

    def SetFlag(self, flag, option_state):
        """
        SetFlag(flag, option_state) -> AuiPaneInfo
        
        SetFlag() turns the property given by flag on or off with the
        option_state parameter.
        """

    def Show(self, show=True):
        """
        Show(show=True) -> AuiPaneInfo
        
        Show() indicates that a pane should be shown.
        """

    def ToolbarPane(self):
        """
        ToolbarPane() -> AuiPaneInfo
        
        ToolbarPane() specifies that the pane should adopt the default toolbar
        pane settings.
        """

    def Top(self):
        """
        Top() -> AuiPaneInfo
        
        Top() sets the pane dock position to the top of the frame.
        """

    def TopDockable(self, b=True):
        """
        TopDockable(b=True) -> AuiPaneInfo
        
        TopDockable() indicates whether a pane can be docked at the top of the
        frame.
        """

    def Window(self, w):
        """
        Window(w) -> AuiPaneInfo
        
        Window() assigns the window pointer that the wxAuiPaneInfo should use.
        """

    def IsValid(self):
        """
        IsValid() -> bool
        """
# end of class AuiPaneInfo


class AuiManagerEvent(wx.Event):
    """
    AuiManagerEvent(type=wx.wxEVT_NULL)
    
    Event used to indicate various actions taken with wxAuiManager.
    """

    def __init__(self, type=wx.wxEVT_NULL):
        """
        AuiManagerEvent(type=wx.wxEVT_NULL)
        
        Event used to indicate various actions taken with wxAuiManager.
        """

    def CanVeto(self):
        """
        CanVeto() -> bool
        """

    def GetButton(self):
        """
        GetButton() -> int
        """

    def GetDC(self):
        """
        GetDC() -> wx.DC
        """

    def GetVeto(self):
        """
        GetVeto() -> bool
        """

    def GetManager(self):
        """
        GetManager() -> AuiManager
        """

    def GetPane(self):
        """
        GetPane() -> AuiPaneInfo
        """

    def SetButton(self, button):
        """
        SetButton(button)
        
        Sets the ID of the button clicked that triggered this event.
        """

    def SetCanVeto(self, can_veto):
        """
        SetCanVeto(can_veto)
        
        Sets whether or not this event can be vetoed.
        """

    def SetDC(self, pdc):
        """
        SetDC(pdc)
        """

    def SetManager(self, manager):
        """
        SetManager(manager)
        
        Sets the wxAuiManager this event is associated with.
        """

    def SetPane(self, pane):
        """
        SetPane(pane)
        
        Sets the pane this event is associated with.
        """

    def Veto(self, veto=True):
        """
        Veto(veto=True)
        
        Cancels the action indicated by this event if CanVeto() is true.
        """
    Button = property(None, None)
    DC = property(None, None)
    Manager = property(None, None)
    Pane = property(None, None)
# end of class AuiManagerEvent


class AuiDockInfo(object):
    """
    AuiDockInfo()
    AuiDockInfo(c)
    """

    def __init__(self, *args, **kw):
        """
        AuiDockInfo()
        AuiDockInfo(c)
        """
    panes = property(None, None)
    rect = property(None, None)
    dock_direction = property(None, None)
    dock_layer = property(None, None)
    dock_row = property(None, None)
    size = property(None, None)
    min_size = property(None, None)
    resizable = property(None, None)
    toolbar = property(None, None)
    fixed = property(None, None)
    reserved1 = property(None, None)

    def IsOk(self):
        """
        IsOk() -> bool
        """

    def IsHorizontal(self):
        """
        IsHorizontal() -> bool
        """

    def IsVertical(self):
        """
        IsVertical() -> bool
        """
# end of class AuiDockInfo


class AuiDockUIPart(object):
    """
    
    """
    typeCaption = 0
    typeGripper = 0
    typeDock = 0
    typeDockSizer = 0
    typePane = 0
    typePaneSizer = 0
    typeBackground = 0
    typePaneBorder = 0
    typePaneButton = 0
    type = property(None, None)
    orientation = property(None, None)
    dock = property(None, None)
    pane = property(None, None)
    button = property(None, None)
    cont_sizer = property(None, None)
    sizer_item = property(None, None)
    rect = property(None, None)
# end of class AuiDockUIPart


class AuiPaneButton(object):
    """
    
    """
    button_id = property(None, None)
# end of class AuiPaneButton


EVT_AUI_PANE_BUTTON = wx.PyEventBinder( wxEVT_AUI_PANE_BUTTON )
EVT_AUI_PANE_CLOSE = wx.PyEventBinder( wxEVT_AUI_PANE_CLOSE )
EVT_AUI_PANE_MAXIMIZE = wx.PyEventBinder( wxEVT_AUI_PANE_MAXIMIZE )
EVT_AUI_PANE_RESTORE = wx.PyEventBinder( wxEVT_AUI_PANE_RESTORE )
EVT_AUI_PANE_ACTIVATED = wx.PyEventBinder( wxEVT_AUI_PANE_ACTIVATED )
EVT_AUI_RENDER = wx.PyEventBinder( wxEVT_AUI_RENDER )
EVT_AUI_FIND_MANAGER = wx.PyEventBinder( wxEVT_AUI_FIND_MANAGER )
#-- end-auiframemanager --#
#-- begin-auidockart --#
AUI_DOCKART_SASH_SIZE = 0
AUI_DOCKART_CAPTION_SIZE = 0
AUI_DOCKART_GRIPPER_SIZE = 0
AUI_DOCKART_PANE_BORDER_SIZE = 0
AUI_DOCKART_PANE_BUTTON_SIZE = 0
AUI_DOCKART_BACKGROUND_COLOUR = 0
AUI_DOCKART_SASH_COLOUR = 0
AUI_DOCKART_ACTIVE_CAPTION_COLOUR = 0
AUI_DOCKART_ACTIVE_CAPTION_GRADIENT_COLOUR = 0
AUI_DOCKART_INACTIVE_CAPTION_COLOUR = 0
AUI_DOCKART_INACTIVE_CAPTION_GRADIENT_COLOUR = 0
AUI_DOCKART_ACTIVE_CAPTION_TEXT_COLOUR = 0
AUI_DOCKART_INACTIVE_CAPTION_TEXT_COLOUR = 0
AUI_DOCKART_BORDER_COLOUR = 0
AUI_DOCKART_GRIPPER_COLOUR = 0
AUI_DOCKART_CAPTION_FONT = 0
AUI_DOCKART_GRADIENT_TYPE = 0
AUI_GRADIENT_NONE = 0
AUI_GRADIENT_VERTICAL = 0
AUI_GRADIENT_HORIZONTAL = 0
AUI_BUTTON_STATE_NORMAL = 0
AUI_BUTTON_STATE_HOVER = 0
AUI_BUTTON_STATE_PRESSED = 0
AUI_BUTTON_STATE_DISABLED = 0
AUI_BUTTON_STATE_HIDDEN = 0
AUI_BUTTON_STATE_CHECKED = 0
AUI_BUTTON_CLOSE = 0
AUI_BUTTON_MAXIMIZE_RESTORE = 0
AUI_BUTTON_MINIMIZE = 0
AUI_BUTTON_PIN = 0
AUI_BUTTON_OPTIONS = 0
AUI_BUTTON_WINDOWLIST = 0
AUI_BUTTON_LEFT = 0
AUI_BUTTON_RIGHT = 0
AUI_BUTTON_UP = 0
AUI_BUTTON_DOWN = 0
AUI_BUTTON_CUSTOM1 = 0
AUI_BUTTON_CUSTOM2 = 0
AUI_BUTTON_CUSTOM3 = 0

class AuiDockArt(object):
    """
    AuiDockArt()
    
    wxAuiDockArt is part of the wxAUI class framework.
    """

    def __init__(self):
        """
        AuiDockArt()
        
        wxAuiDockArt is part of the wxAUI class framework.
        """

    def DrawBackground(self, dc, window, orientation, rect):
        """
        DrawBackground(dc, window, orientation, rect)
        
        Draws a background.
        """

    def DrawBorder(self, dc, window, rect, pane):
        """
        DrawBorder(dc, window, rect, pane)
        
        Draws a border.
        """

    def DrawCaption(self, dc, window, text, rect, pane):
        """
        DrawCaption(dc, window, text, rect, pane)
        
        Draws a caption.
        """

    def DrawGripper(self, dc, window, rect, pane):
        """
        DrawGripper(dc, window, rect, pane)
        
        Draws a gripper.
        """

    def DrawPaneButton(self, dc, window, button, button_state, rect, pane):
        """
        DrawPaneButton(dc, window, button, button_state, rect, pane)
        
        Draws a button in the pane's title bar.
        """

    def DrawSash(self, dc, window, orientation, rect):
        """
        DrawSash(dc, window, orientation, rect)
        
        Draws a sash between two windows.
        """

    def GetColour(self, id):
        """
        GetColour(id) -> wx.Colour
        
        Get the colour of a certain setting.
        """

    def GetFont(self, id):
        """
        GetFont(id) -> wx.Font
        
        Get a font setting.
        """

    def GetMetric(self, id):
        """
        GetMetric(id) -> int
        
        Get the value of a certain setting.
        """

    def SetColour(self, id, colour):
        """
        SetColour(id, colour)
        
        Set a certain setting with the value colour.
        """

    def SetFont(self, id, font):
        """
        SetFont(id, font)
        
        Set a font setting.
        """

    def SetMetric(self, id, new_val):
        """
        SetMetric(id, new_val)
        
        Set a certain setting with the value new_val.
        """
# end of class AuiDockArt


class AuiDefaultDockArt(AuiDockArt):
    """
    AuiDefaultDockArt()
    
    This is the default art provider for wxAuiManager.
    """

    def __init__(self):
        """
        AuiDefaultDockArt()
        
        This is the default art provider for wxAuiManager.
        """

    def GetMetric(self, id):
        """
        GetMetric(id) -> int
        
        Get the value of a certain setting.
        """

    def SetMetric(self, id, new_val):
        """
        SetMetric(id, new_val)
        
        Set a certain setting with the value new_val.
        """

    def GetColour(self, id):
        """
        GetColour(id) -> wx.Colour
        
        Get the colour of a certain setting.
        """

    def SetColour(self, id, colour):
        """
        SetColour(id, colour)
        
        Set a certain setting with the value colour.
        """

    def SetFont(self, id, font):
        """
        SetFont(id, font)
        
        Set a font setting.
        """

    def GetFont(self, id):
        """
        GetFont(id) -> wx.Font
        
        Get a font setting.
        """

    def DrawSash(self, dc, window, orientation, rect):
        """
        DrawSash(dc, window, orientation, rect)
        
        Draws a sash between two windows.
        """

    def DrawBackground(self, dc, window, orientation, rect):
        """
        DrawBackground(dc, window, orientation, rect)
        
        Draws a background.
        """

    def DrawCaption(self, dc, window, text, rect, pane):
        """
        DrawCaption(dc, window, text, rect, pane)
        
        Draws a caption.
        """

    def DrawGripper(self, dc, window, rect, pane):
        """
        DrawGripper(dc, window, rect, pane)
        
        Draws a gripper.
        """

    def DrawBorder(self, dc, window, rect, pane):
        """
        DrawBorder(dc, window, rect, pane)
        
        Draws a border.
        """

    def DrawPaneButton(self, dc, window, button, button_state, rect, pane):
        """
        DrawPaneButton(dc, window, button, button_state, rect, pane)
        
        Draws a button in the pane's title bar.
        """

    def DrawIcon(self, dc, rect, pane):
        """
        DrawIcon(dc, rect, pane)
        """
# end of class AuiDefaultDockArt

#-- end-auidockart --#
#-- begin-auibar --#
AUI_TB_TEXT = 0
AUI_TB_NO_TOOLTIPS = 0
AUI_TB_NO_AUTORESIZE = 0
AUI_TB_GRIPPER = 0
AUI_TB_OVERFLOW = 0
AUI_TB_VERTICAL = 0
AUI_TB_HORZ_LAYOUT = 0
AUI_TB_HORIZONTAL = 0
AUI_TB_PLAIN_BACKGROUND = 0
AUI_TB_HORZ_TEXT = 0
AUI_ORIENTATION_MASK = 0
AUI_TB_DEFAULT_STYLE = 0
AUI_TBART_SEPARATOR_SIZE = 0
AUI_TBART_GRIPPER_SIZE = 0
AUI_TBART_OVERFLOW_SIZE = 0
AUI_TBTOOL_TEXT_LEFT = 0
AUI_TBTOOL_TEXT_RIGHT = 0
AUI_TBTOOL_TEXT_TOP = 0
AUI_TBTOOL_TEXT_BOTTOM = 0
wxEVT_AUITOOLBAR_TOOL_DROPDOWN = 0
wxEVT_AUITOOLBAR_OVERFLOW_CLICK = 0
wxEVT_AUITOOLBAR_RIGHT_CLICK = 0
wxEVT_AUITOOLBAR_MIDDLE_CLICK = 0
wxEVT_AUITOOLBAR_BEGIN_DRAG = 0

class AuiToolBarItem(object):
    """
    AuiToolBarItem()
    AuiToolBarItem(c)
    
    wxAuiToolBarItem is part of the wxAUI class framework, representing a
    toolbar element.
    """

    def __init__(self, *args, **kw):
        """
        AuiToolBarItem()
        AuiToolBarItem(c)
        
        wxAuiToolBarItem is part of the wxAUI class framework, representing a
        toolbar element.
        """

    def Assign(self, c):
        """
        Assign(c)
        
        Assigns the properties of the wxAuiToolBarItem "c" to this.
        """

    def SetWindow(self, w):
        """
        SetWindow(w)
        
        Assigns a window to the toolbar item.
        """

    def GetWindow(self):
        """
        GetWindow() -> wx.Window
        
        Returns the wxWindow* associated to the toolbar item.
        """

    def SetId(self, new_id):
        """
        SetId(new_id)
        
        Sets the toolbar item identifier.
        """

    def GetId(self):
        """
        GetId() -> int
        
        Returns the toolbar item identifier.
        """

    def SetKind(self, new_kind):
        """
        SetKind(new_kind)
        
        Sets the wxAuiToolBarItem kind.
        """

    def GetKind(self):
        """
        GetKind() -> int
        
        Returns the toolbar item kind.
        """

    def SetState(self, new_state):
        """
        SetState(new_state)
        """

    def GetState(self):
        """
        GetState() -> int
        """

    def SetSizerItem(self, s):
        """
        SetSizerItem(s)
        """

    def GetSizerItem(self):
        """
        GetSizerItem() -> wx.SizerItem
        """

    def SetLabel(self, s):
        """
        SetLabel(s)
        """

    def GetLabel(self):
        """
        GetLabel() -> String
        """

    def SetBitmap(self, bmp):
        """
        SetBitmap(bmp)
        """

    def GetBitmap(self):
        """
        GetBitmap() -> wx.Bitmap
        """

    def SetDisabledBitmap(self, bmp):
        """
        SetDisabledBitmap(bmp)
        """

    def GetDisabledBitmap(self):
        """
        GetDisabledBitmap() -> wx.Bitmap
        """

    def SetHoverBitmap(self, bmp):
        """
        SetHoverBitmap(bmp)
        """

    def GetHoverBitmap(self):
        """
        GetHoverBitmap() -> wx.Bitmap
        """

    def SetShortHelp(self, s):
        """
        SetShortHelp(s)
        """

    def GetShortHelp(self):
        """
        GetShortHelp() -> String
        """

    def SetLongHelp(self, s):
        """
        SetLongHelp(s)
        """

    def GetLongHelp(self):
        """
        GetLongHelp() -> String
        """

    def SetMinSize(self, s):
        """
        SetMinSize(s)
        """

    def GetMinSize(self):
        """
        GetMinSize() -> wx.Size
        """

    def SetSpacerPixels(self, s):
        """
        SetSpacerPixels(s)
        """

    def GetSpacerPixels(self):
        """
        GetSpacerPixels() -> int
        """

    def SetProportion(self, p):
        """
        SetProportion(p)
        """

    def GetProportion(self):
        """
        GetProportion() -> int
        """

    def SetActive(self, b):
        """
        SetActive(b)
        """

    def IsActive(self):
        """
        IsActive() -> bool
        """

    def SetHasDropDown(self, b):
        """
        SetHasDropDown(b)
        
        Set whether this tool has a drop down button.
        """

    def HasDropDown(self):
        """
        HasDropDown() -> bool
        
        Returns whether the toolbar item has an associated drop down button.
        """

    def SetSticky(self, b):
        """
        SetSticky(b)
        """

    def IsSticky(self):
        """
        IsSticky() -> bool
        """

    def SetUserData(self, l):
        """
        SetUserData(l)
        """

    def GetUserData(self):
        """
        GetUserData() -> long
        """

    def SetAlignment(self, l):
        """
        SetAlignment(l)
        """

    def GetAlignment(self):
        """
        GetAlignment() -> int
        """
    Alignment = property(None, None)
    Bitmap = property(None, None)
    DisabledBitmap = property(None, None)
    HoverBitmap = property(None, None)
    Id = property(None, None)
    Kind = property(None, None)
    Label = property(None, None)
    LongHelp = property(None, None)
    MinSize = property(None, None)
    Proportion = property(None, None)
    ShortHelp = property(None, None)
    SizerItem = property(None, None)
    SpacerPixels = property(None, None)
    State = property(None, None)
    UserData = property(None, None)
    Window = property(None, None)
# end of class AuiToolBarItem


class AuiToolBarArt(object):
    """
    AuiToolBarArt()
    
    wxAuiToolBarArt is part of the wxAUI class framework.
    """

    def __init__(self):
        """
        AuiToolBarArt()
        
        wxAuiToolBarArt is part of the wxAUI class framework.
        """

    def Clone(self):
        """
        Clone() -> AuiToolBarArt
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        """

    def GetFlags(self):
        """
        GetFlags() -> unsignedint
        """

    def SetFont(self, font):
        """
        SetFont(font)
        """

    def GetFont(self):
        """
        GetFont() -> wx.Font
        """

    def SetTextOrientation(self, orientation):
        """
        SetTextOrientation(orientation)
        """

    def GetTextOrientation(self):
        """
        GetTextOrientation() -> int
        """

    def DrawBackground(self, dc, wnd, rect):
        """
        DrawBackground(dc, wnd, rect)
        """

    def DrawPlainBackground(self, dc, wnd, rect):
        """
        DrawPlainBackground(dc, wnd, rect)
        """

    def DrawLabel(self, dc, wnd, item, rect):
        """
        DrawLabel(dc, wnd, item, rect)
        """

    def DrawButton(self, dc, wnd, item, rect):
        """
        DrawButton(dc, wnd, item, rect)
        """

    def DrawDropDownButton(self, dc, wnd, item, rect):
        """
        DrawDropDownButton(dc, wnd, item, rect)
        """

    def DrawControlLabel(self, dc, wnd, item, rect):
        """
        DrawControlLabel(dc, wnd, item, rect)
        """

    def DrawSeparator(self, dc, wnd, rect):
        """
        DrawSeparator(dc, wnd, rect)
        """

    def DrawGripper(self, dc, wnd, rect):
        """
        DrawGripper(dc, wnd, rect)
        """

    def DrawOverflowButton(self, dc, wnd, rect, state):
        """
        DrawOverflowButton(dc, wnd, rect, state)
        """

    def GetLabelSize(self, dc, wnd, item):
        """
        GetLabelSize(dc, wnd, item) -> wx.Size
        """

    def GetToolSize(self, dc, wnd, item):
        """
        GetToolSize(dc, wnd, item) -> wx.Size
        """

    def GetElementSize(self, element_id):
        """
        GetElementSize(element_id) -> int
        """

    def SetElementSize(self, element_id, size):
        """
        SetElementSize(element_id, size)
        """

    def ShowDropDown(self, wnd, items):
        """
        ShowDropDown(wnd, items) -> int
        """
    Flags = property(None, None)
    Font = property(None, None)
    TextOrientation = property(None, None)
# end of class AuiToolBarArt


class AuiDefaultToolBarArt(AuiToolBarArt):
    """
    AuiDefaultToolBarArt()
    
    wxAuiDefaultToolBarArt is part of the wxAUI class framework.
    """

    def __init__(self):
        """
        AuiDefaultToolBarArt()
        
        wxAuiDefaultToolBarArt is part of the wxAUI class framework.
        """

    def Clone(self):
        """
        Clone() -> AuiToolBarArt
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        """

    def GetFlags(self):
        """
        GetFlags() -> unsignedint
        """

    def SetFont(self, font):
        """
        SetFont(font)
        """

    def GetFont(self):
        """
        GetFont() -> wx.Font
        """

    def SetTextOrientation(self, orientation):
        """
        SetTextOrientation(orientation)
        """

    def GetTextOrientation(self):
        """
        GetTextOrientation() -> int
        """

    def DrawBackground(self, dc, wnd, rect):
        """
        DrawBackground(dc, wnd, rect)
        """

    def DrawPlainBackground(self, dc, wnd, rect):
        """
        DrawPlainBackground(dc, wnd, rect)
        """

    def DrawLabel(self, dc, wnd, item, rect):
        """
        DrawLabel(dc, wnd, item, rect)
        """

    def DrawButton(self, dc, wnd, item, rect):
        """
        DrawButton(dc, wnd, item, rect)
        """

    def DrawDropDownButton(self, dc, wnd, item, rect):
        """
        DrawDropDownButton(dc, wnd, item, rect)
        """

    def DrawControlLabel(self, dc, wnd, item, rect):
        """
        DrawControlLabel(dc, wnd, item, rect)
        """

    def DrawSeparator(self, dc, wnd, rect):
        """
        DrawSeparator(dc, wnd, rect)
        """

    def DrawGripper(self, dc, wnd, rect):
        """
        DrawGripper(dc, wnd, rect)
        """

    def DrawOverflowButton(self, dc, wnd, rect, state):
        """
        DrawOverflowButton(dc, wnd, rect, state)
        """

    def GetLabelSize(self, dc, wnd, item):
        """
        GetLabelSize(dc, wnd, item) -> wx.Size
        """

    def GetToolSize(self, dc, wnd, item):
        """
        GetToolSize(dc, wnd, item) -> wx.Size
        """

    def GetElementSize(self, element):
        """
        GetElementSize(element) -> int
        """

    def SetElementSize(self, element_id, size):
        """
        SetElementSize(element_id, size)
        """

    def ShowDropDown(self, wnd, items):
        """
        ShowDropDown(wnd, items) -> int
        """
    Flags = property(None, None)
    Font = property(None, None)
    TextOrientation = property(None, None)
# end of class AuiDefaultToolBarArt


class AuiToolBar(wx.Control):
    """
    AuiToolBar()
    AuiToolBar(parent, id=wx.ID_ANY, position=wx.DefaultPosition, size=wx.DefaultSize, style=AUI_TB_DEFAULT_STYLE)
    
    wxAuiToolBar is a dockable toolbar, part of the wxAUI class framework.
    """

    def __init__(self, *args, **kw):
        """
        AuiToolBar()
        AuiToolBar(parent, id=wx.ID_ANY, position=wx.DefaultPosition, size=wx.DefaultSize, style=AUI_TB_DEFAULT_STYLE)
        
        wxAuiToolBar is a dockable toolbar, part of the wxAUI class framework.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AUI_TB_DEFAULT_STYLE):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AUI_TB_DEFAULT_STYLE) -> bool
        
        Really create wxAuiToolBar created using default constructor.
        """

    def SetWindowStyleFlag(self, style):
        """
        SetWindowStyleFlag(style)
        
        Sets the style of the window.
        """

    def GetWindowStyleFlag(self):
        """
        GetWindowStyleFlag() -> long
        
        Gets the window style that was passed to the constructor or Create()
        method.
        """

    def SetArtProvider(self, art):
        """
        SetArtProvider(art)
        """

    def GetArtProvider(self):
        """
        GetArtProvider() -> AuiToolBarArt
        """

    def SetFont(self, font):
        """
        SetFont(font) -> bool
        
        Sets the font for this window.
        """

    def AddTool(self, *args, **kw):
        """
        AddTool(tool_id, label, bitmap, short_help_string=wx.EmptyString, kind=wx.ITEM_NORMAL) -> AuiToolBarItem
        AddTool(tool_id, label, bitmap, disabled_bitmap, kind, short_help_string, long_help_string, client_data) -> AuiToolBarItem
        AddTool(tool_id, bitmap, disabled_bitmap, toggle=False, client_data=None, short_help_string=wx.EmptyString, long_help_string=wx.EmptyString) -> AuiToolBarItem
        """

    def AddLabel(self, tool_id, label=wx.EmptyString, width=-1):
        """
        AddLabel(tool_id, label=wx.EmptyString, width=-1) -> AuiToolBarItem
        """

    def AddControl(self, control, label=wx.EmptyString):
        """
        AddControl(control, label=wx.EmptyString) -> AuiToolBarItem
        """

    def AddSeparator(self):
        """
        AddSeparator() -> AuiToolBarItem
        """

    def AddSpacer(self, pixels):
        """
        AddSpacer(pixels) -> AuiToolBarItem
        """

    def AddStretchSpacer(self, proportion=1):
        """
        AddStretchSpacer(proportion=1) -> AuiToolBarItem
        """

    def Realize(self):
        """
        Realize() -> bool
        """

    def FindControl(self, window_id):
        """
        FindControl(window_id) -> wx.Control
        """

    def FindToolByPosition(self, x, y):
        """
        FindToolByPosition(x, y) -> AuiToolBarItem
        """

    def FindToolByIndex(self, idx):
        """
        FindToolByIndex(idx) -> AuiToolBarItem
        """

    def FindTool(self, tool_id):
        """
        FindTool(tool_id) -> AuiToolBarItem
        """

    def ClearTools(self):
        """
        ClearTools()
        """

    def Clear(self):
        """
        Clear()
        """

    def DeleteTool(self, tool_id):
        """
        DeleteTool(tool_id) -> bool
        """

    def DeleteByIndex(self, tool_id):
        """
        DeleteByIndex(tool_id) -> bool
        """

    def GetToolCount(self):
        """
        GetToolCount() -> size_t
        """

    def GetToolPos(self, tool_id):
        """
        GetToolPos(tool_id) -> int
        """

    def GetToolIndex(self, tool_id):
        """
        GetToolIndex(tool_id) -> int
        """

    def GetToolFits(self, tool_id):
        """
        GetToolFits(tool_id) -> bool
        """

    def GetToolRect(self, tool_id):
        """
        GetToolRect(tool_id) -> wx.Rect
        """

    def GetToolFitsByIndex(self, tool_id):
        """
        GetToolFitsByIndex(tool_id) -> bool
        """

    def GetToolBarFits(self):
        """
        GetToolBarFits() -> bool
        """

    def SetMargins(self, *args, **kw):
        """
        SetMargins(size)
        SetMargins(x, y)
        SetMargins(left, right, top, bottom)
        """

    def SetToolBitmapSize(self, size):
        """
        SetToolBitmapSize(size)
        """

    def GetToolBitmapSize(self):
        """
        GetToolBitmapSize() -> wx.Size
        """

    def GetOverflowVisible(self):
        """
        GetOverflowVisible() -> bool
        """

    def SetOverflowVisible(self, visible):
        """
        SetOverflowVisible(visible)
        """

    def GetGripperVisible(self):
        """
        GetGripperVisible() -> bool
        """

    def SetGripperVisible(self, visible):
        """
        SetGripperVisible(visible)
        """

    def ToggleTool(self, tool_id, state):
        """
        ToggleTool(tool_id, state)
        """

    def GetToolToggled(self, tool_id):
        """
        GetToolToggled(tool_id) -> bool
        """

    def EnableTool(self, tool_id, state):
        """
        EnableTool(tool_id, state)
        """

    def GetToolEnabled(self, tool_id):
        """
        GetToolEnabled(tool_id) -> bool
        """

    def SetToolDropDown(self, tool_id, dropdown):
        """
        SetToolDropDown(tool_id, dropdown)
        
        Set whether the specified toolbar item has a drop down button.
        """

    def GetToolDropDown(self, tool_id):
        """
        GetToolDropDown(tool_id) -> bool
        
        Returns whether the specified toolbar item has an associated drop down
        button.
        """

    def SetToolBorderPadding(self, padding):
        """
        SetToolBorderPadding(padding)
        """

    def GetToolBorderPadding(self):
        """
        GetToolBorderPadding() -> int
        """

    def SetToolTextOrientation(self, orientation):
        """
        SetToolTextOrientation(orientation)
        """

    def GetToolTextOrientation(self):
        """
        GetToolTextOrientation() -> int
        """

    def SetToolPacking(self, packing):
        """
        SetToolPacking(packing)
        """

    def GetToolPacking(self):
        """
        GetToolPacking() -> int
        """

    def SetToolProportion(self, tool_id, proportion):
        """
        SetToolProportion(tool_id, proportion)
        """

    def GetToolProportion(self, tool_id):
        """
        GetToolProportion(tool_id) -> int
        """

    def SetToolSeparation(self, separation):
        """
        SetToolSeparation(separation)
        """

    def GetToolSeparation(self):
        """
        GetToolSeparation() -> int
        """

    def SetToolSticky(self, tool_id, sticky):
        """
        SetToolSticky(tool_id, sticky)
        """

    def GetToolSticky(self, tool_id):
        """
        GetToolSticky(tool_id) -> bool
        """

    def GetToolLabel(self, tool_id):
        """
        GetToolLabel(tool_id) -> String
        """

    def SetToolLabel(self, tool_id, label):
        """
        SetToolLabel(tool_id, label)
        """

    def GetToolBitmap(self, tool_id):
        """
        GetToolBitmap(tool_id) -> wx.Bitmap
        """

    def SetToolBitmap(self, tool_id, bitmap):
        """
        SetToolBitmap(tool_id, bitmap)
        """

    def GetToolShortHelp(self, tool_id):
        """
        GetToolShortHelp(tool_id) -> String
        """

    def SetToolShortHelp(self, tool_id, help_string):
        """
        SetToolShortHelp(tool_id, help_string)
        """

    def GetToolLongHelp(self, tool_id):
        """
        GetToolLongHelp(tool_id) -> String
        """

    def SetToolLongHelp(self, tool_id, help_string):
        """
        SetToolLongHelp(tool_id, help_string)
        """

    def SetCustomOverflowItems(self, prepend, append):
        """
        SetCustomOverflowItems(prepend, append)
        """

    def GetHintSize(self, dock_direction):
        """
        GetHintSize(dock_direction) -> wx.Size
        
        get size of hint rectangle for a particular dock location
        """

    def IsPaneValid(self, pane):
        """
        IsPaneValid(pane) -> bool
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    ArtProvider = property(None, None)
    GripperVisible = property(None, None)
    OverflowVisible = property(None, None)
    ToolBarFits = property(None, None)
    ToolBitmapSize = property(None, None)
    ToolBorderPadding = property(None, None)
    ToolCount = property(None, None)
    ToolPacking = property(None, None)
    ToolSeparation = property(None, None)
    ToolTextOrientation = property(None, None)
    WindowStyleFlag = property(None, None)
# end of class AuiToolBar


class AuiToolBarEvent(wx.NotifyEvent):
    """
    AuiToolBarEvent(commandType=wx.wxEVT_NULL, winId=0)
    AuiToolBarEvent(c)
    
    wxAuiToolBarEvent is used for the events generated by wxAuiToolBar.
    """

    def __init__(self, *args, **kw):
        """
        AuiToolBarEvent(commandType=wx.wxEVT_NULL, winId=0)
        AuiToolBarEvent(c)
        
        wxAuiToolBarEvent is used for the events generated by wxAuiToolBar.
        """

    def IsDropDownClicked(self):
        """
        IsDropDownClicked() -> bool
        
        Returns whether the drop down menu has been clicked.
        """

    def GetClickPoint(self):
        """
        GetClickPoint() -> wx.Point
        
        Returns the point where the user clicked with the mouse.
        """

    def GetItemRect(self):
        """
        GetItemRect() -> wx.Rect
        
        Returns the wxAuiToolBarItem rectangle bounding the mouse click point.
        """

    def GetToolId(self):
        """
        GetToolId() -> int
        
        Returns the wxAuiToolBarItem identifier.
        """

    def SetDropDownClicked(self, c):
        """
        SetDropDownClicked(c)
        """

    def SetClickPoint(self, p):
        """
        SetClickPoint(p)
        """

    def SetItemRect(self, r):
        """
        SetItemRect(r)
        """

    def SetToolId(self, toolId):
        """
        SetToolId(toolId)
        """
    ClickPoint = property(None, None)
    ItemRect = property(None, None)
    ToolId = property(None, None)
# end of class AuiToolBarEvent


EVT_AUITOOLBAR_TOOL_DROPDOWN = wx.PyEventBinder( wxEVT_AUITOOLBAR_TOOL_DROPDOWN, 1 )
EVT_AUITOOLBAR_OVERFLOW_CLICK = wx.PyEventBinder( wxEVT_AUITOOLBAR_OVERFLOW_CLICK, 1 )
EVT_AUITOOLBAR_RIGHT_CLICK = wx.PyEventBinder( wxEVT_AUITOOLBAR_RIGHT_CLICK, 1 )
EVT_AUITOOLBAR_MIDDLE_CLICK = wx.PyEventBinder( wxEVT_AUITOOLBAR_MIDDLE_CLICK, 1 )
EVT_AUITOOLBAR_BEGIN_DRAG = wx.PyEventBinder( wxEVT_AUITOOLBAR_BEGIN_DRAG, 1 )
#-- end-auibar --#
#-- begin-auibook --#
AUI_NB_TOP = 0
AUI_NB_LEFT = 0
AUI_NB_RIGHT = 0
AUI_NB_BOTTOM = 0
AUI_NB_TAB_SPLIT = 0
AUI_NB_TAB_MOVE = 0
AUI_NB_TAB_EXTERNAL_MOVE = 0
AUI_NB_TAB_FIXED_WIDTH = 0
AUI_NB_SCROLL_BUTTONS = 0
AUI_NB_WINDOWLIST_BUTTON = 0
AUI_NB_CLOSE_BUTTON = 0
AUI_NB_CLOSE_ON_ACTIVE_TAB = 0
AUI_NB_CLOSE_ON_ALL_TABS = 0
AUI_NB_MIDDLE_CLICK_CLOSE = 0
AUI_NB_DEFAULT_STYLE = 0
wxEVT_AUINOTEBOOK_PAGE_CLOSE = 0
wxEVT_AUINOTEBOOK_PAGE_CLOSED = 0
wxEVT_AUINOTEBOOK_PAGE_CHANGED = 0
wxEVT_AUINOTEBOOK_PAGE_CHANGING = 0
wxEVT_AUINOTEBOOK_BUTTON = 0
wxEVT_AUINOTEBOOK_BEGIN_DRAG = 0
wxEVT_AUINOTEBOOK_END_DRAG = 0
wxEVT_AUINOTEBOOK_DRAG_MOTION = 0
wxEVT_AUINOTEBOOK_ALLOW_DND = 0
wxEVT_AUINOTEBOOK_DRAG_DONE = 0
wxEVT_AUINOTEBOOK_TAB_MIDDLE_DOWN = 0
wxEVT_AUINOTEBOOK_TAB_MIDDLE_UP = 0
wxEVT_AUINOTEBOOK_TAB_RIGHT_DOWN = 0
wxEVT_AUINOTEBOOK_TAB_RIGHT_UP = 0
wxEVT_AUINOTEBOOK_BG_DCLICK = 0

class AuiNotebook(wx.BookCtrlBase):
    """
    AuiNotebook()
    AuiNotebook(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AUI_NB_DEFAULT_STYLE)
    
    wxAuiNotebook is part of the wxAUI class framework, which represents a
    notebook control, managing multiple windows with associated tabs.
    """

    def __init__(self, *args, **kw):
        """
        AuiNotebook()
        AuiNotebook(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AUI_NB_DEFAULT_STYLE)
        
        wxAuiNotebook is part of the wxAUI class framework, which represents a
        notebook control, managing multiple windows with associated tabs.
        """

    def AddPage(self, *args, **kw):
        """
        AddPage(page, caption, select=False, bitmap=wx.NullBitmap) -> bool
        AddPage(page, text, select, imageId) -> bool
        
        Adds a page.
        """

    def AdvanceSelection(self, forward=True):
        """
        AdvanceSelection(forward=True)
        
        Sets the selection to the next or previous page.
        """

    def ChangeSelection(self, n):
        """
        ChangeSelection(n) -> int
        
        Changes the selection for the given page, returning the previous
        selection.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0) -> bool
        
        Creates the notebook window.
        """

    def DeleteAllPages(self):
        """
        DeleteAllPages() -> bool
        
        Deletes all pages.
        """

    def DeletePage(self, page):
        """
        DeletePage(page) -> bool
        
        Deletes a page at the given index.
        """

    def GetArtProvider(self):
        """
        GetArtProvider() -> AuiTabArt
        
        Returns the associated art provider.
        """

    def GetCurrentPage(self):
        """
        GetCurrentPage() -> wx.Window
        
        Returns the currently selected page or NULL.
        """

    def GetHeightForPageHeight(self, pageHeight):
        """
        GetHeightForPageHeight(pageHeight) -> int
        
        Returns the desired height of the notebook for the given page height.
        """

    def GetPage(self, page_idx):
        """
        GetPage(page_idx) -> wx.Window
        
        Returns the page specified by the given index.
        """

    def GetPageBitmap(self, page):
        """
        GetPageBitmap(page) -> wx.Bitmap
        
        Returns the tab bitmap for the page.
        """

    def GetPageCount(self):
        """
        GetPageCount() -> size_t
        
        Returns the number of pages in the notebook.
        """

    def GetPageIndex(self, page_wnd):
        """
        GetPageIndex(page_wnd) -> int
        
        Returns the page index for the specified window.
        """

    def GetPageText(self, page):
        """
        GetPageText(page) -> String
        
        Returns the tab label for the page.
        """

    def GetPageToolTip(self, pageIdx):
        """
        GetPageToolTip(pageIdx) -> String
        
        Returns the tooltip for the tab label of the page.
        """

    def GetSelection(self):
        """
        GetSelection() -> int
        
        Returns the currently selected page.
        """

    def GetTabCtrlHeight(self):
        """
        GetTabCtrlHeight() -> int
        
        Returns the height of the tab control.
        """

    def InsertPage(self, *args, **kw):
        """
        InsertPage(page_idx, page, caption, select=False, bitmap=wx.NullBitmap) -> bool
        InsertPage(index, page, text, select, imageId) -> bool
        
        InsertPage() is similar to AddPage, but allows the ability to specify
        the insert location.
        """

    def RemovePage(self, page):
        """
        RemovePage(page) -> bool
        
        Removes a page, without deleting the window pointer.
        """

    def SetArtProvider(self, art):
        """
        SetArtProvider(art)
        
        Sets the art provider to be used by the notebook.
        """

    def SetFont(self, font):
        """
        SetFont(font) -> bool
        
        Sets the font for drawing the tab labels, using a bold version of the
        font for selected tab labels.
        """

    def SetMeasuringFont(self, font):
        """
        SetMeasuringFont(font)
        
        Sets the font for measuring tab labels.
        """

    def SetNormalFont(self, font):
        """
        SetNormalFont(font)
        
        Sets the font for drawing unselected tab labels.
        """

    def SetPageBitmap(self, page, bitmap):
        """
        SetPageBitmap(page, bitmap) -> bool
        
        Sets the bitmap for the page.
        """

    def SetPageImage(self, n, imageId):
        """
        SetPageImage(n, imageId) -> bool
        
        Sets the image index for the given page.
        """

    def SetPageText(self, page, text):
        """
        SetPageText(page, text) -> bool
        
        Sets the tab label for the page.
        """

    def SetPageToolTip(self, page, text):
        """
        SetPageToolTip(page, text) -> bool
        
        Sets the tooltip displayed when hovering over the tab label of the
        page.
        """

    def SetSelectedFont(self, font):
        """
        SetSelectedFont(font)
        
        Sets the font for drawing selected tab labels.
        """

    def SetSelection(self, new_page):
        """
        SetSelection(new_page) -> int
        
        Sets the page selection.
        """

    def SetTabCtrlHeight(self, height):
        """
        SetTabCtrlHeight(height)
        
        Sets the tab height.
        """

    def SetUniformBitmapSize(self, size):
        """
        SetUniformBitmapSize(size)
        
        Ensure that all tabs have the same height, even if some of them don't
        have bitmaps.
        """

    def Split(self, page, direction):
        """
        Split(page, direction)
        
        Split performs a split operation programmatically.
        """

    def ShowWindowMenu(self):
        """
        ShowWindowMenu() -> bool
        
        Shows the window menu for the active tab control associated with this
        notebook, and returns true if a selection was made.
        """

    def GetPageImage(self, nPage):
        """
        GetPageImage(nPage) -> int
        
        Returns the image index for the given page.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    ArtProvider = property(None, None)
    CurrentPage = property(None, None)
    PageCount = property(None, None)
    Selection = property(None, None)
    TabCtrlHeight = property(None, None)
# end of class AuiNotebook


class AuiNotebookPage(object):
    """
    A simple class which holds information about the notebook's pages and
    their state.
    """
    window = property(None, None)
    caption = property(None, None)
    tooltip = property(None, None)
    bitmap = property(None, None)
    rect = property(None, None)
    active = property(None, None)
# end of class AuiNotebookPage


class AuiTabContainerButton(object):
    """
    A simple class which holds information about wxAuiNotebook tab buttons
    and their state.
    """
    id = property(None, None)
    curState = property(None, None)
    location = property(None, None)
    bitmap = property(None, None)
    disBitmap = property(None, None)
    rect = property(None, None)
# end of class AuiTabContainerButton


class AuiTabContainer(object):
    """
    AuiTabContainer()
    
    wxAuiTabContainer is a class which contains information about each
    tab.
    """

    def __init__(self):
        """
        AuiTabContainer()
        
        wxAuiTabContainer is a class which contains information about each
        tab.
        """

    def SetArtProvider(self, art):
        """
        SetArtProvider(art)
        """

    def GetArtProvider(self):
        """
        GetArtProvider() -> AuiTabArt
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        """

    def GetFlags(self):
        """
        GetFlags() -> unsignedint
        """

    def AddPage(self, page, info):
        """
        AddPage(page, info) -> bool
        """

    def InsertPage(self, page, info, idx):
        """
        InsertPage(page, info, idx) -> bool
        """

    def MovePage(self, page, newIdx):
        """
        MovePage(page, newIdx) -> bool
        """

    def RemovePage(self, page):
        """
        RemovePage(page) -> bool
        """

    def SetActivePage(self, *args, **kw):
        """
        SetActivePage(page) -> bool
        SetActivePage(page) -> bool
        """

    def SetNoneActive(self):
        """
        SetNoneActive()
        """

    def GetActivePage(self):
        """
        GetActivePage() -> int
        """

    def TabHitTest(self, x, y, hit):
        """
        TabHitTest(x, y, hit) -> bool
        """

    def ButtonHitTest(self, x, y, hit):
        """
        ButtonHitTest(x, y, hit) -> bool
        """

    def GetWindowFromIdx(self, idx):
        """
        GetWindowFromIdx(idx) -> wx.Window
        """

    def GetIdxFromWindow(self, page):
        """
        GetIdxFromWindow(page) -> int
        """

    def GetPageCount(self):
        """
        GetPageCount() -> size_t
        """

    def GetPage(self, idx):
        """
        GetPage(idx) -> AuiNotebookPage
        """

    def GetPages(self):
        """
        GetPages() -> AuiNotebookPageArray
        """

    def SetNormalFont(self, normalFont):
        """
        SetNormalFont(normalFont)
        """

    def SetSelectedFont(self, selectedFont):
        """
        SetSelectedFont(selectedFont)
        """

    def SetMeasuringFont(self, measuringFont):
        """
        SetMeasuringFont(measuringFont)
        """

    def SetColour(self, colour):
        """
        SetColour(colour)
        """

    def SetActiveColour(self, colour):
        """
        SetActiveColour(colour)
        """

    def DoShowHide(self):
        """
        DoShowHide()
        """

    def SetRect(self, rect):
        """
        SetRect(rect)
        """

    def RemoveButton(self, id):
        """
        RemoveButton(id)
        """

    def AddButton(self, id, location, normalBitmap=wx.NullBitmap, disabledBitmap=wx.NullBitmap):
        """
        AddButton(id, location, normalBitmap=wx.NullBitmap, disabledBitmap=wx.NullBitmap)
        """

    def GetTabOffset(self):
        """
        GetTabOffset() -> size_t
        """

    def SetTabOffset(self, offset):
        """
        SetTabOffset(offset)
        """

    def IsTabVisible(self, tabPage, tabOffset, dc, wnd):
        """
        IsTabVisible(tabPage, tabOffset, dc, wnd) -> bool
        """

    def MakeTabVisible(self, tabPage, win):
        """
        MakeTabVisible(tabPage, win)
        """
    ActivePage = property(None, None)
    ArtProvider = property(None, None)
    Flags = property(None, None)
    PageCount = property(None, None)
    Pages = property(None, None)
    TabOffset = property(None, None)
# end of class AuiTabContainer


class AuiTabArt(object):
    """
    AuiTabArt()
    
    Tab art provider defines all the drawing functions used by
    wxAuiNotebook.
    """

    def __init__(self):
        """
        AuiTabArt()
        
        Tab art provider defines all the drawing functions used by
        wxAuiNotebook.
        """

    def Clone(self):
        """
        Clone() -> AuiTabArt
        
        Clones the art object.
        """

    def DrawBackground(self, dc, wnd, rect):
        """
        DrawBackground(dc, wnd, rect)
        
        Draws a background on the given area.
        """

    def DrawButton(self, dc, wnd, in_rect, bitmap_id, button_state, orientation, out_rect):
        """
        DrawButton(dc, wnd, in_rect, bitmap_id, button_state, orientation, out_rect)
        
        Draws a button.
        """

    def DrawTab(self, dc, wnd, page, rect, close_button_state, out_tab_rect, out_button_rect, x_extent):
        """
        DrawTab(dc, wnd, page, rect, close_button_state, out_tab_rect, out_button_rect, x_extent)
        
        Draws a tab.
        """

    def GetBestTabCtrlSize(self, , , ):
        """
        GetBestTabCtrlSize(, , ) -> int
        
        Returns the tab control size.
        """

    def GetIndentSize(self):
        """
        GetIndentSize() -> int
        
        Returns the indent size.
        """

    def GetTabSize(self, dc, wnd, caption, bitmap, active, close_button_state, x_extent):
        """
        GetTabSize(dc, wnd, caption, bitmap, active, close_button_state, x_extent) -> wx.Size
        
        Returns the tab size for the given caption, bitmap and state.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Sets flags.
        """

    def SetMeasuringFont(self, font):
        """
        SetMeasuringFont(font)
        
        Sets the font used for calculating measurements.
        """

    def SetNormalFont(self, font):
        """
        SetNormalFont(font)
        
        Sets the normal font for drawing labels.
        """

    def SetSelectedFont(self, font):
        """
        SetSelectedFont(font)
        
        Sets the font for drawing text for selected UI elements.
        """

    def SetColour(self, colour):
        """
        SetColour(colour)
        
        Sets the colour of the inactive tabs.
        """

    def SetActiveColour(self, colour):
        """
        SetActiveColour(colour)
        
        Sets the colour of the selected tab.
        """

    def SetSizingInfo(self, tab_ctrl_size, tab_count):
        """
        SetSizingInfo(tab_ctrl_size, tab_count)
        
        Sets sizing information.
        """
    IndentSize = property(None, None)
# end of class AuiTabArt


class AuiDefaultTabArt(AuiTabArt):
    """
    AuiDefaultTabArt()
    
    Default art provider for wxAuiNotebook.
    """

    def __init__(self):
        """
        AuiDefaultTabArt()
        
        Default art provider for wxAuiNotebook.
        """

    def Clone(self):
        """
        Clone() -> AuiTabArt
        
        Clones the art object.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Sets flags.
        """

    def SetSizingInfo(self, tab_ctrl_size, tab_count):
        """
        SetSizingInfo(tab_ctrl_size, tab_count)
        
        Sets sizing information.
        """

    def SetNormalFont(self, font):
        """
        SetNormalFont(font)
        
        Sets the normal font for drawing labels.
        """

    def SetSelectedFont(self, font):
        """
        SetSelectedFont(font)
        
        Sets the font for drawing text for selected UI elements.
        """

    def SetMeasuringFont(self, font):
        """
        SetMeasuringFont(font)
        
        Sets the font used for calculating measurements.
        """

    def SetColour(self, colour):
        """
        SetColour(colour)
        
        Sets the colour of the inactive tabs.
        """

    def SetActiveColour(self, colour):
        """
        SetActiveColour(colour)
        
        Sets the colour of the selected tab.
        """

    def DrawBackground(self, dc, wnd, rect):
        """
        DrawBackground(dc, wnd, rect)
        
        Draws a background on the given area.
        """

    def DrawTab(self, dc, wnd, page, rect, close_button_state, out_tab_rect, out_button_rect, x_extent):
        """
        DrawTab(dc, wnd, page, rect, close_button_state, out_tab_rect, out_button_rect, x_extent)
        
        Draws a tab.
        """

    def DrawButton(self, dc, wnd, in_rect, bitmap_id, button_state, orientation, out_rect):
        """
        DrawButton(dc, wnd, in_rect, bitmap_id, button_state, orientation, out_rect)
        
        Draws a button.
        """

    def GetIndentSize(self):
        """
        GetIndentSize() -> int
        
        Returns the indent size.
        """

    def GetTabSize(self, dc, wnd, caption, bitmap, active, close_button_state, x_extent):
        """
        GetTabSize(dc, wnd, caption, bitmap, active, close_button_state, x_extent) -> wx.Size
        
        Returns the tab size for the given caption, bitmap and state.
        """

    def ShowDropDown(self, wnd, items, activeIdx):
        """
        ShowDropDown(wnd, items, activeIdx) -> int
        """

    def GetBestTabCtrlSize(self, , , ):
        """
        GetBestTabCtrlSize(, , ) -> int
        
        Returns the tab control size.
        """
    IndentSize = property(None, None)
# end of class AuiDefaultTabArt


class AuiSimpleTabArt(AuiTabArt):
    """
    AuiSimpleTabArt()
    
    Another standard tab art provider for wxAuiNotebook.
    """

    def __init__(self):
        """
        AuiSimpleTabArt()
        
        Another standard tab art provider for wxAuiNotebook.
        """

    def Clone(self):
        """
        Clone() -> AuiTabArt
        
        Clones the art object.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Sets flags.
        """

    def SetSizingInfo(self, tab_ctrl_size, tab_count):
        """
        SetSizingInfo(tab_ctrl_size, tab_count)
        
        Sets sizing information.
        """

    def SetNormalFont(self, font):
        """
        SetNormalFont(font)
        
        Sets the normal font for drawing labels.
        """

    def SetSelectedFont(self, font):
        """
        SetSelectedFont(font)
        
        Sets the font for drawing text for selected UI elements.
        """

    def SetMeasuringFont(self, font):
        """
        SetMeasuringFont(font)
        
        Sets the font used for calculating measurements.
        """

    def SetColour(self, colour):
        """
        SetColour(colour)
        
        Sets the colour of the inactive tabs.
        """

    def SetActiveColour(self, colour):
        """
        SetActiveColour(colour)
        
        Sets the colour of the selected tab.
        """

    def DrawBackground(self, dc, wnd, rect):
        """
        DrawBackground(dc, wnd, rect)
        
        Draws a background on the given area.
        """

    def DrawTab(self, dc, wnd, page, rect, close_button_state, out_tab_rect, out_button_rect, x_extent):
        """
        DrawTab(dc, wnd, page, rect, close_button_state, out_tab_rect, out_button_rect, x_extent)
        
        Draws a tab.
        """

    def DrawButton(self, dc, wnd, in_rect, bitmap_id, button_state, orientation, out_rect):
        """
        DrawButton(dc, wnd, in_rect, bitmap_id, button_state, orientation, out_rect)
        
        Draws a button.
        """

    def GetIndentSize(self):
        """
        GetIndentSize() -> int
        
        Returns the indent size.
        """

    def GetTabSize(self, dc, wnd, caption, bitmap, active, close_button_state, x_extent):
        """
        GetTabSize(dc, wnd, caption, bitmap, active, close_button_state, x_extent) -> wx.Size
        
        Returns the tab size for the given caption, bitmap and state.
        """

    def ShowDropDown(self, wnd, items, activeIdx):
        """
        ShowDropDown(wnd, items, activeIdx) -> int
        """

    def GetBestTabCtrlSize(self, , , ):
        """
        GetBestTabCtrlSize(, , ) -> int
        
        Returns the tab control size.
        """
    IndentSize = property(None, None)
# end of class AuiSimpleTabArt


class AuiNotebookEvent(wx.BookCtrlEvent):
    """
    AuiNotebookEvent(command_type=wx.wxEVT_NULL, win_id=0)
    
    This class is used by the events generated by wxAuiNotebook.
    """

    def __init__(self, command_type=wx.wxEVT_NULL, win_id=0):
        """
        AuiNotebookEvent(command_type=wx.wxEVT_NULL, win_id=0)
        
        This class is used by the events generated by wxAuiNotebook.
        """

    def Clone(self):
        """
        Clone() -> wx.Event
        """
# end of class AuiNotebookEvent


EVT_AUINOTEBOOK_PAGE_CLOSE = wx.PyEventBinder( wxEVT_AUINOTEBOOK_PAGE_CLOSE, 1 )
EVT_AUINOTEBOOK_PAGE_CLOSED = wx.PyEventBinder( wxEVT_AUINOTEBOOK_PAGE_CLOSED, 1 )
EVT_AUINOTEBOOK_PAGE_CHANGED = wx.PyEventBinder( wxEVT_AUINOTEBOOK_PAGE_CHANGED, 1 )
EVT_AUINOTEBOOK_PAGE_CHANGING = wx.PyEventBinder( wxEVT_AUINOTEBOOK_PAGE_CHANGING, 1 )
EVT_AUINOTEBOOK_BUTTON = wx.PyEventBinder( wxEVT_AUINOTEBOOK_BUTTON, 1 )
EVT_AUINOTEBOOK_BEGIN_DRAG = wx.PyEventBinder( wxEVT_AUINOTEBOOK_BEGIN_DRAG, 1 )
EVT_AUINOTEBOOK_END_DRAG = wx.PyEventBinder( wxEVT_AUINOTEBOOK_END_DRAG, 1 )
EVT_AUINOTEBOOK_DRAG_MOTION = wx.PyEventBinder( wxEVT_AUINOTEBOOK_DRAG_MOTION, 1 )
EVT_AUINOTEBOOK_ALLOW_DND = wx.PyEventBinder( wxEVT_AUINOTEBOOK_ALLOW_DND, 1 )
EVT_AUINOTEBOOK_DRAG_DONE = wx.PyEventBinder( wxEVT_AUINOTEBOOK_DRAG_DONE, 1 )
EVT_AUINOTEBOOK_TAB_MIDDLE_DOWN = wx.PyEventBinder( wxEVT_AUINOTEBOOK_TAB_MIDDLE_DOWN, 1 )
EVT_AUINOTEBOOK_TAB_MIDDLE_UP = wx.PyEventBinder( wxEVT_AUINOTEBOOK_TAB_MIDDLE_UP, 1 )
EVT_AUINOTEBOOK_TAB_RIGHT_DOWN = wx.PyEventBinder( wxEVT_AUINOTEBOOK_TAB_RIGHT_DOWN, 1 )
EVT_AUINOTEBOOK_TAB_RIGHT_UP = wx.PyEventBinder( wxEVT_AUINOTEBOOK_TAB_RIGHT_UP, 1 )
EVT_AUINOTEBOOK_BG_DCLICK = wx.PyEventBinder( wxEVT_AUINOTEBOOK_BG_DCLICK, 1 )

class AuiTabCtrl(wx.Control, AuiTabContainer):
    """
    AuiTabCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
    """

    def __init__(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0):
        """
        AuiTabCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
        """

    def IsDragging(self):
        """
        IsDragging() -> bool
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
# end of class AuiTabCtrl

#-- end-auibook --#
#-- begin-auitabmdi --#

class AuiMDIParentFrame(wx.Frame):
    """
    AuiMDIParentFrame()
    AuiMDIParentFrame(parent, winid=wx.ID_ANY, title=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_FRAME_STYLE|wx.VSCROLL|wx.HSCROLL, name=wx.FrameNameStr)
    """

    def __init__(self, *args, **kw):
        """
        AuiMDIParentFrame()
        AuiMDIParentFrame(parent, winid=wx.ID_ANY, title=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_FRAME_STYLE|wx.VSCROLL|wx.HSCROLL, name=wx.FrameNameStr)
        """

    def Create(self, parent, winid=wx.ID_ANY, title=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_FRAME_STYLE|wx.VSCROLL|wx.HSCROLL, name=wx.FrameNameStr):
        """
        Create(parent, winid=wx.ID_ANY, title=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_FRAME_STYLE|wx.VSCROLL|wx.HSCROLL, name=wx.FrameNameStr) -> bool
        """

    def SetArtProvider(self, provider):
        """
        SetArtProvider(provider)
        """

    def GetArtProvider(self):
        """
        GetArtProvider() -> AuiTabArt
        """

    def GetNotebook(self):
        """
        GetNotebook() -> AuiNotebook
        """

    def GetWindowMenu(self):
        """
        GetWindowMenu() -> wx.Menu
        """

    def SetWindowMenu(self, pMenu):
        """
        SetWindowMenu(pMenu)
        """

    def SetMenuBar(self, menuBar):
        """
        SetMenuBar(menuBar)
        
        Tells the frame to show the given menu bar.
        """

    def SetChildMenuBar(self, pChild):
        """
        SetChildMenuBar(pChild)
        """

    def GetActiveChild(self):
        """
        GetActiveChild() -> AuiMDIChildFrame
        """

    def SetActiveChild(self, pChildFrame):
        """
        SetActiveChild(pChildFrame)
        """

    def GetClientWindow(self):
        """
        GetClientWindow() -> AuiMDIClientWindow
        """

    def OnCreateClient(self):
        """
        OnCreateClient() -> AuiMDIClientWindow
        """

    def Cascade(self):
        """
        Cascade()
        """

    def Tile(self, orient=wx.HORIZONTAL):
        """
        Tile(orient=wx.HORIZONTAL)
        """

    def ArrangeIcons(self):
        """
        ArrangeIcons()
        """

    def ActivateNext(self):
        """
        ActivateNext()
        """

    def ActivatePrevious(self):
        """
        ActivatePrevious()
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    ActiveChild = property(None, None)
    ArtProvider = property(None, None)
    ClientWindow = property(None, None)
    Notebook = property(None, None)
    WindowMenu = property(None, None)
# end of class AuiMDIParentFrame


class AuiMDIChildFrame(wx.Panel):
    """
    AuiMDIChildFrame()
    AuiMDIChildFrame(parent, winid=wx.ID_ANY, title=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_FRAME_STYLE, name=wx.FrameNameStr)
    """

    def __init__(self, *args, **kw):
        """
        AuiMDIChildFrame()
        AuiMDIChildFrame(parent, winid=wx.ID_ANY, title=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_FRAME_STYLE, name=wx.FrameNameStr)
        """

    def Create(self, parent, winid=wx.ID_ANY, title=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_FRAME_STYLE, name=wx.FrameNameStr):
        """
        Create(parent, winid=wx.ID_ANY, title=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_FRAME_STYLE, name=wx.FrameNameStr) -> bool
        """

    def SetMenuBar(self, menuBar):
        """
        SetMenuBar(menuBar)
        """

    def GetMenuBar(self):
        """
        GetMenuBar() -> wx.MenuBar
        """

    def SetTitle(self, title):
        """
        SetTitle(title)
        """

    def GetTitle(self):
        """
        GetTitle() -> String
        """

    def SetIcons(self, icons):
        """
        SetIcons(icons)
        """

    def GetIcons(self):
        """
        GetIcons() -> wx.IconBundle
        """

    def SetIcon(self, icon):
        """
        SetIcon(icon)
        """

    def GetIcon(self):
        """
        GetIcon() -> wx.Icon
        """

    def Activate(self):
        """
        Activate()
        """

    def Destroy(self):
        """
        Destroy() -> bool
        
        Destroys the window safely.
        """

    def Show(self, show=True):
        """
        Show(show=True) -> bool
        
        Shows or hides the window.
        """

    def CreateStatusBar(self, number=1, style=1, winid=1, name=wx.EmptyString):
        """
        CreateStatusBar(number=1, style=1, winid=1, name=wx.EmptyString) -> wx.StatusBar
        """

    def GetStatusBar(self):
        """
        GetStatusBar() -> wx.StatusBar
        """

    def SetStatusText(self, text, number=0):
        """
        SetStatusText(text, number=0)
        """

    def SetStatusWidths(self, widths):
        """
        SetStatusWidths(widths)
        """

    def CreateToolBar(self, style, winid, name):
        """
        CreateToolBar(style, winid, name) -> wx.ToolBar
        """

    def GetToolBar(self):
        """
        GetToolBar() -> wx.ToolBar
        """

    def Maximize(self, maximize=True):
        """
        Maximize(maximize=True)
        """

    def Restore(self):
        """
        Restore()
        """

    def Iconize(self, iconize=True):
        """
        Iconize(iconize=True)
        """

    def IsMaximized(self):
        """
        IsMaximized() -> bool
        """

    def IsIconized(self):
        """
        IsIconized() -> bool
        """

    def ShowFullScreen(self, show, style):
        """
        ShowFullScreen(show, style) -> bool
        """

    def IsFullScreen(self):
        """
        IsFullScreen() -> bool
        """

    def IsTopLevel(self):
        """
        IsTopLevel() -> bool
        
        Returns true if the given window is a top-level one.
        """

    def SetMDIParentFrame(self, parent):
        """
        SetMDIParentFrame(parent)
        """

    def GetMDIParentFrame(self):
        """
        GetMDIParentFrame() -> AuiMDIParentFrame
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    Icon = property(None, None)
    Icons = property(None, None)
    MDIParentFrame = property(None, None)
    MenuBar = property(None, None)
    StatusBar = property(None, None)
    Title = property(None, None)
    ToolBar = property(None, None)
# end of class AuiMDIChildFrame


class AuiMDIClientWindow(AuiNotebook):
    """
    AuiMDIClientWindow()
    AuiMDIClientWindow(parent, style=0)
    """

    def __init__(self, *args, **kw):
        """
        AuiMDIClientWindow()
        AuiMDIClientWindow(parent, style=0)
        """

    def CreateClient(self, parent, style=wx.VSCROLL|wx.HSCROLL):
        """
        CreateClient(parent, style=wx.VSCROLL|wx.HSCROLL) -> bool
        """

    def SetSelection(self, new_page):
        """
        SetSelection(new_page) -> int
        
        Sets the page selection.
        """

    def GetActiveChild(self):
        """
        GetActiveChild() -> AuiMDIChildFrame
        """

    def SetActiveChild(self, pChildFrame):
        """
        SetActiveChild(pChildFrame)
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    ActiveChild = property(None, None)
# end of class AuiMDIClientWindow

#-- end-auitabmdi --#
