/*
 * This file is part of the Yices SMT Solver.
 * Copyright (C) 2020 SRI International.
 *
 * Yices is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Yices is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Yices.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Given a model M and a term t, we want to compute a set of
 * uninterpreted terms whose value in M is sufficient to derive the
 * value of t. For example, assume 
 *    t = (if x>0 then x+1 else y)
 * then M will assign a value to x and to y, from which we can compute
 * the value of t. But in some cases, the value of t is independent of y.
 * For example, if M[x] = 1, then M[t] = 2 and the value of y doesn't matter.
 *
 * In general, we call support of t in M = a set of uninterpreted terms x_1, ... x_n,
 * such that M[t] is defined by M[x_1], ..., M[x_n] but does not depend on other
 * uninterpreted terms. More formally, { x_1, ..., x_n } is a support of t in M if
 * for any model M' we have (M'[x_1] = M[x_1] ... M'[x_n] = M[x_n] => M[t] = M[t]).
 * In the previous example support t in M = { x }.
 *
 * We generalize this to more than one term: support of t_1, ... , t_m in M =
 * a set of uninterpreted terms x_1, ...., x_n such that M[x_1], ..., M[x_n]
 * determine M[t_1], ..., M[t_m].
 *
 * Given a model M and a This module computes a (small) support for t_1, ..., t_m.
 */

#ifndef __MODEL_SUPPORT_H
#define __MODEL_SUPPORT_H

#include "model/model_eval.h"
#include "utils/int_harray_store.h"
#include "utils/ptr_hash_map.h"
#include "utils/ptr_stack.h"



