/////////////////////////////////////////////////////////////////////////////
// Name:        wx/private/lang_scripts.h
// Purpose:     Mapping of language script ids
// Author:      misc/languages/genlang.py
// Created:     2024-10-04
// Copyright:   (c) 2024 wxWidgets development team <vadim@wxwidgets.org>
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

// WARNING: Parts of this file are generated. See misc/languages/README for
// details.

#ifndef _WX_PRIVATE_LANG_SCRIPTS_H_
#define _WX_PRIVATE_LANG_SCRIPTS_H_

// ----------------------------------------------------------------------------
// Mapping of known script ids to POSIX modifiers
// ----------------------------------------------------------------------------

// --- --- --- generated code begins here --- --- ---

// The following data tables are generated by misc/languages/genlang.py
// When making changes, please put them into misc/languages/scripttabl.txt

// Data table for known language scripts
static const struct scriptData_t
{
    const char* scname;
    const char* scalias;
}
tabScriptData[] =
{
    { "Adlm", "adlam" },
    { "Aghb", "caucasian_albanian" },
    { "Ahom", "ahom" },
    { "Arab", "arabic" },
    { "Armi", "imperial_aramaic" },
    { "Armn", "armenian" },
    { "Avst", "avestan" },
    { "Bali", "balinese" },
    { "Bamu", "bamum" },
    { "Bass", "bassa_vah" },
    { "Batk", "batak" },
    { "Beng", "bengali" },
    { "Bhks", "bhaiksuki" },
    { "Bopo", "bopomofo" },
    { "Brah", "brahmi" },
    { "Brai", "braille" },
    { "Bugi", "buginese" },
    { "Buhd", "buhid" },
    { "Cakm", "chakma" },
    { "Cans", "canadian_aboriginal" },
    { "Cari", "carian" },
    { "Cham", "cham" },
    { "Cher", "cherokee" },
    { "Chrs", "chorasmian" },
    { "Copt", "coptic" },
    { "Cpmn", "cypro_minoan" },
    { "Cprt", "cypriot" },
    { "Cyrl", "cyrillic" },
    { "Deva", "devanagari" },
    { "Diak", "dives_akuru" },
    { "Dogr", "dogra" },
    { "Dsrt", "deseret" },
    { "Dupl", "duployan" },
    { "Egyp", "egyptian_hieroglyphs" },
    { "Elba", "elbasan" },
    { "Elym", "elymaic" },
    { "Ethi", "ethiopic" },
    { "Geok", "georgian" },
    { "Geor", "georgian" },
    { "Glag", "glagolitic" },
    { "Gong", "gunjala_gondi" },
    { "Gonm", "masaram_gondi" },
    { "Goth", "gothic" },
    { "Gran", "grantha" },
    { "Grek", "greek" },
    { "Gujr", "gujarati" },
    { "Guru", "gurmukhi" },
    { "Hang", "hangul" },
    { "Hani", "han" },
    { "Hano", "hanunoo" },
    { "Hans", "Hans" },
    { "Hant", "Hant" },
    { "Hatr", "hatran" },
    { "Hebr", "hebrew" },
    { "Hira", "hiragana" },
    { "Hluw", "anatolian_hieroglyphs" },
    { "Hmng", "pahawh_hmong" },
    { "Hmnp", "nyiakeng_puachue_hmong" },
    { "Hrkt", "katakana_or_hiragana" },
    { "Hung", "old_hungarian" },
    { "Ital", "old_italic" },
    { "Java", "javanese" },
    { "Kali", "kayah_li" },
    { "Kana", "katakana" },
    { "Kawi", "kawi" },
    { "Khar", "kharoshthi" },
    { "Khmr", "khmer" },
    { "Khoj", "khojki" },
    { "Kits", "khitan_small_script" },
    { "Knda", "kannada" },
    { "Kthi", "kaithi" },
    { "Lana", "tai_tham" },
    { "Laoo", "lao" },
    { "Latn", "latin" },
    { "Lepc", "lepcha" },
    { "Limb", "limbu" },
    { "Lina", "linear_a" },
    { "Linb", "linear_b" },
    { "Lisu", "lisu" },
    { "Lyci", "lycian" },
    { "Lydi", "lydian" },
    { "Mahj", "mahajani" },
    { "Maka", "makasar" },
    { "Mand", "mandaic" },
    { "Mani", "manichaean" },
    { "Marc", "marchen" },
    { "Medf", "medefaidrin" },
    { "Mend", "mende_kikakui" },
    { "Merc", "meroitic_cursive" },
    { "Mero", "meroitic_hieroglyphs" },
    { "Mlym", "malayalam" },
    { "Modi", "modi" },
    { "Mong", "mongolian" },
    { "Mroo", "mro" },
    { "Mtei", "meetei_mayek" },
    { "Mult", "multani" },
    { "Mymr", "myanmar" },
    { "Nagm", "nag_mundari" },
    { "Nand", "nandinagari" },
    { "Narb", "old_north_arabian" },
    { "Nbat", "nabataean" },
    { "Newa", "newa" },
    { "Nkoo", "nko" },
    { "Nshu", "nushu" },
    { "Ogam", "ogham" },
    { "Olck", "ol_chiki" },
    { "Orkh", "old_turkic" },
    { "Orya", "oriya" },
    { "Osge", "osage" },
    { "Osma", "osmanya" },
    { "Ougr", "old_uyghur" },
    { "Palm", "palmyrene" },
    { "Pauc", "pau_cin_hau" },
    { "Perm", "old_permic" },
    { "Phag", "phags_pa" },
    { "Phli", "inscriptional_pahlavi" },
    { "Phlp", "psalter_pahlavi" },
    { "Phnx", "phoenician" },
    { "Plrd", "miao" },
    { "Prti", "inscriptional_parthian" },
    { "Rjng", "rejang" },
    { "Rohg", "hanifi_rohingya" },
    { "Runr", "runic" },
    { "Samr", "samaritan" },
    { "Sarb", "old_south_arabian" },
    { "Saur", "saurashtra" },
    { "Sgnw", "signwriting" },
    { "Shaw", "shavian" },
    { "Shrd", "sharada" },
    { "Sidd", "siddham" },
    { "Sind", "khudawadi" },
    { "Sinh", "sinhala" },
    { "Sogd", "sogdian" },
    { "Sogo", "old_sogdian" },
    { "Sora", "sora_sompeng" },
    { "Soyo", "soyombo" },
    { "Sund", "sundanese" },
    { "Sylo", "syloti_nagri" },
    { "Syrc", "syriac" },
    { "Tagb", "tagbanwa" },
    { "Takr", "takri" },
    { "Tale", "tai_le" },
    { "Talu", "new_tai_lue" },
    { "Taml", "tamil" },
    { "Tang", "tangut" },
    { "Tavt", "tai_viet" },
    { "Telu", "telugu" },
    { "Tfng", "tifinagh" },
    { "Tglg", "tagalog" },
    { "Thaa", "thaana" },
    { "Thai", "thai" },
    { "Tibt", "tibetan" },
    { "Tirh", "tirhuta" },
    { "Tnsa", "tangsa" },
    { "Toto", "toto" },
    { "Ugar", "ugaritic" },
    { "Vaii", "vai" },
    { "Vith", "vithkuqi" },
    { "Wara", "warang_citi" },
    { "Wcho", "wancho" },
    { "Xpeo", "old_persian" },
    { "Xsux", "cuneiform" },
    { "Yezi", "yezidi" },
    { "Yiii", "yi" },
    { "Zanb", "zanabazar_square" },
    { "Zinh", "inherited" },
    { "Zyyy", "common" },
    { "Zzzz", "unknown" },

    { nullptr, nullptr }
};
// --- --- --- generated code ends here --- --- ---

#endif // _WX_PRIVATE_LANG_SCRIPTS_H_
